/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;

public final class RECTnav
extends AREAnav {
    int itype;
    int iwest;
    double xrow;
    double xcol;
    double zslat;
    double zslon;
    double zdlat;
    double zdlon;

    public RECTnav(int[] iparms) throws IllegalArgumentException {
        int ipowecc;
        if (iparms[0] != 1380270932) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.itype = 2;
        this.xrow = iparms[1];
        int ipowlat = iparms[11];
        if (ipowlat == 0) {
            ipowlat = 4;
        }
        this.zslat = (double)iparms[2] / Math.pow(10.0, ipowlat);
        this.xcol = iparms[3];
        int ipowlon = iparms[12];
        if (ipowlon == 0) {
            ipowlon = 4;
        }
        this.zslon = (double)iparms[4] / Math.pow(10.0, ipowlon);
        int ipowdlin = iparms[13];
        if (ipowdlin == 0) {
            ipowdlin = 4;
        }
        this.zdlat = (double)iparms[5] / Math.pow(10.0, ipowdlin);
        int ipowdele = iparms[14];
        if (ipowdele == 0) {
            ipowdele = 4;
        }
        this.zdlon = (double)iparms[6] / Math.pow(10.0, ipowdele);
        int ipowrad = iparms[15];
        if (ipowrad == 0) {
            ipowrad = 3;
        }
        if ((ipowecc = iparms[16]) == 0) {
            ipowecc = 6;
        }
        int n = this.iwest = iparms[10] >= 0 ? 1 : -1;
        if (this.xcol == 1.0) {
            this.zslon -= 180.0 * (double)this.iwest;
        }
    }

    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xlon;
            double xedif;
            double xlin = imglinele[1][point];
            double xele = imglinele[0][point];
            double xldif = this.xrow - xlin;
            if (this.xcol == 1.0) {
                xedif = (double)this.iwest * (xele - this.xcol);
                xlon = this.zslon + (double)(180 * this.iwest) - xedif * this.zdlon;
            } else {
                xedif = (double)this.iwest * (this.xcol - xele);
                xlon = this.zslon + xedif * this.zdlon;
            }
            double xlat = this.zslat + xldif * this.zdlat;
            if (xlat > 90.0 || xlat < -90.0) {
                xlat = Double.NaN;
            }
            if (xlon > this.zslon + 180.0 || xlon < this.zslon - 180.0) {
                xlon = Double.NaN;
            }
            if (!Double.isNaN(xlon)) {
                if (xlon < -180.0) {
                    xlon += 360.0;
                }
                if (xlon > 180.0) {
                    xlon -= 360.0;
                }
            }
            if (Double.isNaN(xlat) || Double.isNaN(xlon)) {
                latlon[0][point] = Double.NaN;
                latlon[1][point] = Double.NaN;
                continue;
            }
            latlon[0][point] = xlat;
            latlon[1][point] = this.iwest == 1 ? -xlon : xlon;
        }
        return latlon;
    }

    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double xlon;
            double xlat = latlon[0][point];
            double d = xlon = this.iwest == 1 ? -latlon[1][point] : latlon[1][point];
            if (xlon > this.zslon + 180.0) {
                xlon -= 360.0;
            } else if (xlon < this.zslon - 180.0) {
                xlon += 360.0;
            }
            double xlin = this.xrow - (xlat - this.zslat) / this.zdlat;
            double xele = this.xcol == 1.0 ? this.xcol - (xlon - this.zslon - (double)(180 * this.iwest)) / (this.zdlon * (double)this.iwest) : this.xcol - (xlon - this.zslon) / (this.zdlon * (double)this.iwest);
            linele[1][point] = xlin;
            linele[0][point] = xele;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    public float[][] toLatLon(float[][] linele) {
        int number = linele[0].length;
        float[][] latlon = new float[2][number];
        float[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xlon;
            double xedif;
            double xlin = imglinele[1][point];
            double xele = imglinele[0][point];
            double xldif = this.xrow - xlin;
            if (this.xcol == 1.0) {
                xedif = (double)this.iwest * (xele - this.xcol);
                xlon = this.zslon + (double)(180 * this.iwest) - xedif * this.zdlon;
            } else {
                xedif = (double)this.iwest * (this.xcol - xele);
                xlon = this.zslon + xedif * this.zdlon;
            }
            double xlat = this.zslat + xldif * this.zdlat;
            if (xlat > 90.0 || xlat < -90.0) {
                xlat = Double.NaN;
            }
            if (xlon > this.zslon + 180.0 || xlon < this.zslon - 180.0) {
                xlon = Double.NaN;
            }
            if (!Double.isNaN(xlon)) {
                if (xlon < -180.0) {
                    xlon += 360.0;
                }
                if (xlon > 180.0) {
                    xlon -= 360.0;
                }
            }
            if (Double.isNaN(xlat) || Double.isNaN(xlon)) {
                latlon[0][point] = Float.NaN;
                latlon[1][point] = Float.NaN;
                continue;
            }
            latlon[0][point] = (float)xlat;
            latlon[1][point] = (float)(this.iwest == 1 ? -xlon : xlon);
        }
        return latlon;
    }

    public float[][] toLinEle(float[][] latlon) {
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        for (int point = 0; point < number; ++point) {
            double xlon;
            double xlat = latlon[0][point];
            double d = xlon = this.iwest == 1 ? (double)(-latlon[1][point]) : (double)latlon[1][point];
            if (xlon > this.zslon + 180.0) {
                xlon -= 360.0;
            } else if (xlon < this.zslon - 180.0) {
                xlon += 360.0;
            }
            double xlin = this.xrow - (xlat - this.zslat) / this.zdlat;
            double xele = this.xcol == 1.0 ? this.xcol - (xlon - this.zslon - (double)(180 * this.iwest)) / (this.zdlon * (double)this.iwest) : this.xcol - (xlon - this.zslon) / (this.zdlon * (double)this.iwest);
            linele[1][point] = (float)xlin;
            linele[0][point] = (float)xele;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }
}

