/*
 * Decompiled with CFR 0.152.
 */
package thredds.logs;

import java.io.File;
import java.io.FileFilter;
import thredds.logs.LogReader;
import thredds.logs.PathMatcher;
import ucar.unidata.util.StringUtil2;

public class LogCategorizer {
    static String prefix = "/thredds/catalog/";
    static boolean showRoots = false;
    private static String roots = "terminal/level3/IDD,/data/ldm/pub/native/radar/level3/\nterminal/level3,/data/ldm/pub/native/radar/level3/\nstation/soundings,/data/ldm/pub/native/profiler/bufr/profiler3/\nstation/profiler/wind/1hr,/data/ldm/pub/native/profiler/wind/01hr/\nstation/profiler/wind/06min,/data/ldm/pub/native/profiler/wind/06min/\nstation/profiler/RASS/1hr,/data/ldm/pub/native/profiler/RASS/01hr/\nstation/profiler/RASS/06min,/data/ldm/pub/native/profiler/RASS/06min/\nstation/metar,/data/ldm/pub/decoded/netcdf/surface/metar/\nsatellite/WV,/data/ldm/pub/native/satellite/WV/\nsatellite/VIS,/data/ldm/pub/native/satellite/VIS/\nsatellite/SOUND-VIS,/data/ldm/pub/native/satellite/SOUND-VIS/\nsatellite/SOUND-7.43,/data/ldm/pub/native/satellite/SOUND-7.43/\nsatellite/SOUND-7.02,/data/ldm/pub/native/satellite/SOUND-7.02/\nsatellite/SOUND-6.51,/data/ldm/pub/native/satellite/SOUND-6.51/\nsatellite/SOUND-4.45,/data/ldm/pub/native/satellite/SOUND-4.45/\nsatellite/SOUND-3.98,/data/ldm/pub/native/satellite/SOUND-3.98/\nsatellite/SOUND-14.06,/data/ldm/pub/native/satellite/SOUND-14.06/\nsatellite/SOUND-11.03,/data/ldm/pub/native/satellite/SOUND-11.03/\nsatellite/SFC-T/SUPER-NATIONAL_1km,/data/ldm/pub/native/satellite/SFC-T/SUPER-NATIONAL_1km/\nsatellite/PW,/data/ldm/pub/native/satellite/PW/\nsatellite/LI,/data/ldm/pub/native/satellite/LI/\nsatellite/IR,/data/ldm/pub/native/satellite/IR/\nsatellite/CTP,/data/ldm/pub/native/satellite/CTP/\nsatellite/3.9/WEST-CONUS_4km,/data/ldm/pub/native/satellite/3.9/WEST-CONUS_4km/\nsatellite/3.9/PR-REGIONAL_4km,/data/ldm/pub/native/satellite/3.9/PR-REGIONAL_4km/\nsatellite/3.9/HI-REGIONAL_4km,/data/ldm/pub/native/satellite/3.9/HI-REGIONAL_4km/\nsatellite/3.9/EAST-CONUS_4km,/data/ldm/pub/native/satellite/3.9/EAST-CONUS_4km/\nsatellite/3.9/AK-REGIONAL_8km,/data/ldm/pub/native/satellite/3.9/AK-REGIONAL_8km/\nsatellite/13.3,/data/ldm/pub/native/satellite/13.3/\nsatellite/12.0,/data/ldm/pub/native/satellite/12.0/\nrestrict,/opt/tds-test/content/thredds/public/\nnexrad/level3/IDD,/data/ldm/pub/native/radar/level3/\nnexrad/level3/CCS039,/data/ldm/pub/casestudies/ccs039/images/radar/nids\nnexrad/level3,/data/ldm/pub/native/radar/level3/\nnexrad/level2/IDD,/data/ldm/pub/native/radar/level2\nnexrad/level2/CCS039,/data/ldm/pub/casestudies/ccs039/images/radar/level2\nnexrad/level2,/data/ldm/pub/native/radar/level2/\nnexrad/composite/nws,/data/ldm/pub/native/radar/10km_mosaic/\nnexrad/composite/gini,/data/ldm/pub/native/radar/composite/gini/\nnexrad/composite/1km/files,/data/ldm/pub/native/radar/composite/grib2/\nmodelsNc/NCEP/SST/Global_5x2p5deg,/data/ldm/pub/decoded/netcdf/grid/NCEP/SST/Global_5x2p5deg/\nmodelsNc/NCEP/SST/Global_2x2deg,/data/ldm/pub/decoded/netcdf/grid/NCEP/SST/Global_2x2deg/\nmodelsNc/NCEP/RUC2/CONUS_40km,/data/ldm/pub/decoded/netcdf/grid/NCEP/RUC2/CONUS_40km/\nmodelsNc/NCEP/RUC/CONUS_80km,/data/ldm/pub/decoded/netcdf/grid/NCEP/RUC/CONUS_80km/\nmodelsNc/NCEP/OCEAN/Global_5x2p5deg,/data/ldm/pub/decoded/netcdf/grid/NCEP/OCEAN/Global_5x2p5deg/\nmodelsNc/NCEP/NAM/CONUS_80km,/data/ldm/pub/decoded/netcdf/grid/NCEP/NAM/CONUS_80km/\nmodelsNc/NCEP/GFS/Global_5x2p5deg,/data/ldm/pub/decoded/netcdf/grid/NCEP/GFS/Global_5x2p5deg/\nmodelsNc/NCEP/GFS/Extended_Global_5p0deg,/data/ldm/pub/decoded/netcdf/grid/NCEP/GFS/Extended_Global_5p0deg/\nmodelsNc/NCEP/GFS/CONUS_80km,/data/ldm/pub/decoded/netcdf/grid/NCEP/GFS/CONUS_80km/\nmodel/NCEP/RUC2/CONUS_20km/surface,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/surface/\nmodel/NCEP/RUC2/CONUS_20km/pressure,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/pressure/\nmodel/NCEP/RUC2/CONUS_20km/hybrid,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/hybrid/\nmodel/NCEP/RUC/CONUS_80km,/data/ldm/pub/native/grid/NCEP/RUC/CONUS_80km/\nmodel/NCEP/NDFD/CONUS_5km,/data/ldm/pub/native/grid/NCEP/NDFD/CONUS_5km/\nmodel/NCEP/NAM/Polar_90km,/data/ldm/pub/native/grid/NCEP/NAM/Polar_90km/\nmodel/NCEP/NAM/CONUS_80km,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_80km/\nmodel/NCEP/NAM/CONUS_40km/conduit,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_40km/conduit/\nmodel/NCEP/NAM/CONUS_20km/surface,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/surface/\nmodel/NCEP/NAM/CONUS_20km/selectsurface,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/selectsurface/\nmodel/NCEP/NAM/CONUS_20km/noaaport,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/noaaport/\nmodel/NCEP/NAM/CONUS_12km,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_12km/\nmodel/NCEP/NAM/Alaska_95km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_95km/\nmodel/NCEP/NAM/Alaska_45km/noaaport,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_45km/noaaport/\nmodel/NCEP/NAM/Alaska_45km/conduit,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_45km/conduit/\nmodel/NCEP/NAM/Alaska_22km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_22km/\nmodel/NCEP/NAM/Alaska_11km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_11km/\nmodel/NCEP/GFS/Puerto_Rico_191km,/data/ldm/pub/native/grid/NCEP/GFS/Puerto_Rico_191km/\nmodel/NCEP/GFS/N_Hemisphere_381km,/data/ldm/pub/native/grid/NCEP/GFS/N_Hemisphere_381km/\nmodel/NCEP/GFS/Hawaii_160km,/data/ldm/pub/native/grid/NCEP/GFS/Hawaii_160km/\nmodel/NCEP/GFS/Global_onedeg,/data/ldm/pub/native/grid/NCEP/GFS/Global_onedeg/\nmodel/NCEP/GFS/Global_2p5deg,/data/ldm/pub/native/grid/NCEP/GFS/Global_2p5deg/\nmodel/NCEP/GFS/Global_0p5deg,/data/ldm/pub/native/grid/NCEP/GFS/Global_0p5deg/\nmodel/NCEP/GFS/CONUS_95km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_95km/\nmodel/NCEP/GFS/CONUS_80km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_80km/\nmodel/NCEP/GFS/CONUS_191km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_191km/\nmodel/NCEP/GFS/Alaska_191km,/data/ldm/pub/native/grid/NCEP/GFS/Alaska_191km/\nmodel/NCEP/DGEX/CONUS_12km,/data/ldm/pub/native/grid/NCEP/DGEX/CONUS_12km/\nmodel/NCEP/DGEX/Alaska_12km,/data/ldm/pub/native/grid/NCEP/DGEX/Alaska_12km/\ngis/test,/data/thredds/gis/\ngaleon/testdata,/data/thredds/galeon/\ngaleon/ndfd/testdata,/data/ldm/pub/native/grid/NCEP/NDFD/CONUS_5km/\ngaleon/global/testdata,/data/ldm/pub/native/grid/NCEP/GFS/Global_0p5deg/\nfmrc/Unidata/rtmodel/nmm/files,/data/ldm/pub/rtmodel/\nfmrc/Unidata/rtmodel/nmm-alt/files,/data/ldm/pub/rtmodel/\nfmrc/NCEP/SREF/CONUS_40km/pgrb_biasc,/data/ldm/pub/native/grid/NCEP/SREF/CONUS_40km/pgrb_biasc/\nfmrc/NCEP/SREF/CONUS_40km/ensprod_biasc,/data/ldm/pub/native/grid/NCEP/SREF/CONUS_40km/ensprod_biasc/\nfmrc/NCEP/RUC2/CONUS_40km,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_40km/\nfmrc/NCEP/RUC2/CONUS_20km/surface,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/surface/\nfmrc/NCEP/RUC2/CONUS_20km/pressure,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/pressure/\nfmrc/NCEP/RUC2/CONUS_20km/hybrid,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/hybrid/\nfmrc/NCEP/RUC/CONUS_80km,/data/ldm/pub/native/grid/NCEP/RUC/CONUS_80km/\nfmrc/NCEP/NEWGBXNDFD/CONUS_5km,/data/ldm/pub/native/grid/NCEP/NEWGBXNDFD/CONUS_5km/\nfmrc/NCEP/NDFD/CONUS_5km,/data/ldm/pub/native/grid/NCEP/NDFD/CONUS_5km/\nfmrc/NCEP/NAM/Polar_90km,/data/ldm/pub/native/grid/NCEP/NAM/Polar_90km/\nfmrc/NCEP/NAM/CONUS_80km,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_80km/\nfmrc/NCEP/NAM/CONUS_40km/conduit,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_40km/conduit/\nfmrc/NCEP/NAM/CONUS_20km/surface,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/surface/\nfmrc/NCEP/NAM/CONUS_20km/selectsurface,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/selectsurface/\nfmrc/NCEP/NAM/CONUS_20km/noaaport,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/noaaport/\nfmrc/NCEP/NAM/CONUS_12km/conduit,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_12km_conduit/\nfmrc/NCEP/NAM/CONUS_12km,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_12km/\nfmrc/NCEP/NAM/Alaska_95km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_95km/\nfmrc/NCEP/NAM/Alaska_45km/noaaport,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_45km/noaaport/\nfmrc/NCEP/NAM/Alaska_45km/conduit,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_45km/conduit/\nfmrc/NCEP/NAM/Alaska_22km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_22km/\nfmrc/NCEP/NAM/Alaska_11km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_11km/\nfmrc/NCEP/GFS/Puerto_Rico_191km,/data/ldm/pub/native/grid/NCEP/GFS/Puerto_Rico_191km/\nfmrc/NCEP/GFS/N_Hemisphere_381km,/data/ldm/pub/native/grid/NCEP/GFS/N_Hemisphere_381km/\nfmrc/NCEP/GFS/Hawaii_160km,/data/ldm/pub/native/grid/NCEP/GFS/Hawaii_160km/\nfmrc/NCEP/GFS/Global_onedeg,/data/ldm/pub/native/grid/NCEP/GFS/Global_onedeg/\nfmrc/NCEP/GFS/Global_2p5deg,/data/ldm/pub/native/grid/NCEP/GFS/Global_2p5deg/\nfmrc/NCEP/GFS/Global_1p0deg_Ensemble,/data/ldm/pub/native/grid/NCEP/GFS/Global_1p0deg_Ensemble/\nfmrc/NCEP/GFS/Global_0p5deg,/data/ldm/pub/native/grid/NCEP/GFS/Global_0p5deg/\nfmrc/NCEP/GFS/CONUS_95km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_95km/\nfmrc/NCEP/GFS/CONUS_80km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_80km/\nfmrc/NCEP/GFS/CONUS_191km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_191km/\nfmrc/NCEP/GFS/Alaska_191km,/data/ldm/pub/native/grid/NCEP/GFS/Alaska_191km/\nfmrc/NCEP/DGEX/CONUS_12km,/data/ldm/pub/native/grid/NCEP/DGEX/CONUS_12km/\nfmrc/NCEP/DGEX/Alaska_12km,/data/ldm/pub/native/grid/NCEP/DGEX/Alaska_12km/\ncasestudies/vgee_demo,/data/ldm/pub/casestudies/vgee_demo\ncasestudies/july18_2002/grids,/data/ldm/pub/casestudies/july18_2002/grids\ncasestudies/idvtest/grids,/data/ldm/pub/casestudies/idvtest/grids\ncasestudies/ccs039/grids,/data/ldm/pub/casestudies/ccs039/grids\ncasestudies/ccs034/netcdf,/data/ldm/pub/casestudies/ccs034/netcdf\ncasestudies/ccs034/grib,/data/ldm/pub/casestudies/ccs034/grib\ncasestudies/ccs034/acars,/data/ldm/pub/casestudies/ccs034/acars\nGEMPAK/model,/data/ldm/pub/decoded/gempak/model";
    private static PathMatcher pathMatcher = null;
    public static String[] services = new String[]{"admin", "cataloggen", "catalog", "cdmremote", "cdmrfeature", "dodsC", "dqc", "fileServer", "godiva2", "ncss/grid", "ncss", "ncstream", "radarServer", "remoteCatalogService", "view", "wcs", "wms"};
    int datasetReq = 0;
    int unknownReq = 0;
    int latestReq = 0;

    public static String[] getRoots() {
        String rootString = StringUtil2.replace(roots, "\n", ",");
        String[] root2 = rootString.split(",");
        String[] result = new String[root2.length / 2];
        for (int i = 0; i < root2.length; i += 2) {
            result[i / 2] = root2[i];
        }
        return result;
    }

    public static void setRoots(String raw) {
        if (null != raw) {
            roots = raw;
        }
    }

    public static PathMatcher readRoots() {
        PathMatcher pathMatcher = new PathMatcher();
        String rootString = StringUtil2.replace(roots, "\n", ",");
        String[] roots = rootString.split(",");
        for (int i = 0; i < roots.length; i += 2) {
            if (showRoots) {
                System.out.printf("  %-40s %-40s%n", roots[i], roots[i + 1]);
            }
            pathMatcher.put(roots[i], roots[i + 1]);
        }
        return pathMatcher;
    }

    public static String getDataroot(String path, int status) {
        PathMatcher.Match match;
        String ss;
        if (pathMatcher == null) {
            pathMatcher = LogCategorizer.readRoots();
        }
        if ((ss = LogCategorizer.getServiceSpecial(path)) != null) {
            return "service-" + ss;
        }
        if (path.startsWith("//thredds/")) {
            path = path.substring(1);
        }
        if (!path.startsWith("/thredds/")) {
            return "zervice-root";
        }
        String dataRoot = null;
        String spath = path.substring(9);
        String service = LogCategorizer.findService(spath);
        if (service != null && spath.length() > service.length() && (match = pathMatcher.match(spath = spath.substring(service.length() + 1))) != null) {
            dataRoot = match.root;
        }
        if (dataRoot == null && status >= 400) {
            dataRoot = "zBad";
        }
        if (dataRoot == null) {
            service = LogCategorizer.getService(path);
            dataRoot = service != null ? "zervice-" + service : "unknown";
        }
        return dataRoot;
    }

    public static String getServiceSpecial(String path) {
        String ss = null;
        if (path.startsWith("/dqcServlet")) {
            ss = "dqcServlet";
        } else if (path.startsWith("/cdmvalidator")) {
            ss = "cdmvalidator";
        }
        return ss;
    }

    public static String getService(String path) {
        String service = LogCategorizer.getServiceSpecial(path);
        if (service != null) {
            return service;
        }
        if (path.startsWith("/dts")) {
            return "dts";
        }
        if (path.startsWith("/dqcServlet")) {
            return "dqcServlet";
        }
        if (path.startsWith("/thredds/")) {
            String req;
            int pos;
            String spath = path.substring(9);
            service = LogCategorizer.findService(spath);
            if (service == null && (spath.startsWith("ncml") || spath.startsWith("uddc") || spath.startsWith("iso"))) {
                service = "ncIso";
            }
            if (service == null && (spath.endsWith("xml") || spath.endsWith("html"))) {
                service = "catalog";
            }
            if (service == null && (pos = spath.indexOf(63)) > 0 && ((req = spath.substring(0, pos)).endsWith("xml") || req.endsWith("html"))) {
                service = "catalog";
            }
        }
        if (service == null) {
            service = "other";
        }
        return service;
    }

    public static String findService(String path) {
        for (String service : services) {
            if (!path.startsWith(service)) continue;
            return service;
        }
        return null;
    }

    class MyClosure
    implements LogReader.Closure {
        MyClosure() {
        }

        @Override
        public void process(LogReader.Log log) {
            String path = log.path.substring(prefix.length());
            int len = 0;
            if (path.endsWith("/catalog.xml")) {
                len = "/catalog.xml".length();
            } else if (path.endsWith("/catalog.html")) {
                len = "/catalog.html".length();
            } else if (path.endsWith("/latest.xml")) {
                ++LogCategorizer.this.latestReq;
                len = "/latest.xml".length();
            } else if (path.endsWith("/latest.html")) {
                ++LogCategorizer.this.latestReq;
                len = "/latest.html".length();
            } else {
                if (path.contains("catalog.html?dataset=")) {
                    ++LogCategorizer.this.datasetReq;
                    return;
                }
                if (path.contains("latest.html?dataset=")) {
                    ++LogCategorizer.this.datasetReq;
                    return;
                }
                ++LogCategorizer.this.unknownReq;
                return;
            }
            PathMatcher.Match match = pathMatcher.match(path);
            if (match == null) {
                System.out.printf("No root for path %s %n", path);
                return;
            }
            String remaining = path.substring(match.root.length(), path.length() - len);
            if (remaining.startsWith("/")) {
                remaining = remaining.substring(1);
            }
        }
    }

    class MyFF
    implements FileFilter {
        MyFF() {
        }

        @Override
        public boolean accept(File f) {
            String name = f.getName();
            return name.startsWith("access") && name.endsWith(".log");
        }
    }

    class MyLogFilter
    implements LogReader.LogFilter {
        MyLogFilter() {
        }

        @Override
        public boolean pass(LogReader.Log log) {
            return log.returnCode == 200 && log.path.startsWith(prefix);
        }
    }
}

