/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.catalog.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDatasetScan;
import thredds.catalog.crawl.CatalogExtractor;
import thredds.ui.catalog.CatalogTreeView;
import thredds.ui.catalog.tools.DatasetEditor;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.HtmlBrowser;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextGetPutPane;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.IO;
import ucar.nc2.util.net.HttpClientManager;
import ucar.unidata.util.StringUtil2;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.ComboBox;

public class TDServerConfigurator
extends JPanel {
    private static final String SOURCE_WINDOW_SIZE = "SourceWindowSize";
    private static final String EXTRACT_WINDOW_SIZE = "ExtractWindowSize";
    private static final String SAVE_WINDOW_SIZE = "SaveWindowSize";
    private static final String SAVE_HTML_SIZE = "SaveHtmlWindowSize";
    private static final String SPLIT_POS = "SplitPos";
    private PreferencesExt prefs;
    private Component myParent;
    private ComboBox catalogCB;
    private CatalogTreeView catTree;
    private DatasetEditor datasetEditor;
    private JSplitPane splitH;
    private IndependentWindow sourceWindow;
    private IndependentWindow extractWindow;
    private IndependentWindow saveWindow;
    private IndependentWindow htmlWindow;
    private TextHistoryPane sourcePane;
    private TextHistoryPane extractPane;
    private TextGetPutPane savePane;
    private HtmlBrowser htmlViewer;
    private CatalogExtractor extractor = new CatalogExtractor(false);
    private String catalogPath;
    private boolean debugEvents = false;
    private boolean debugSave = false;

    public TDServerConfigurator(PreferencesExt prefs, Component parent) {
        this.prefs = prefs;
        this.myParent = parent;
        this.catalogCB = new ComboBox(prefs == null ? null : (PreferencesExt)prefs.node("catalogCB"));
        JButton connectButton = new JButton("Connect");
        connectButton.setToolTipText("Read the Catalog");
        connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TDServerConfigurator.this.catalogPath = (String)TDServerConfigurator.this.catalogCB.getSelectedItem();
                TDServerConfigurator.this.catTree.setCatalog(TDServerConfigurator.this.catalogPath);
            }
        });
        JButton catSource = new JButton("Source");
        catSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvCatalogImpl cat = TDServerConfigurator.this.catTree.getCatalog();
                ByteArrayOutputStream os = new ByteArrayOutputStream(60000);
                try {
                    cat.writeXML(os, true);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                TDServerConfigurator.this.sourcePane.setText(os.toString());
                TDServerConfigurator.this.sourceWindow.show();
                if (TDServerConfigurator.this.debugSave) {
                    try {
                        IO.writeToFile(os.toString(), "C:/dev/netcdf-java-2.2/test/serverConfig/start.xml");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JButton saveSource = new JButton("Save");
        saveSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!TDServerConfigurator.this.datasetEditor.accept()) {
                    return;
                }
                InvCatalogImpl cat = TDServerConfigurator.this.catTree.getCatalog();
                if (cat == null) {
                    return;
                }
                try {
                    TDServerConfigurator.this.savePane.setCatalog(TDServerConfigurator.this.catalogPath, cat);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                TDServerConfigurator.this.saveWindow.show();
                if (TDServerConfigurator.this.debugSave) {
                    try {
                        ByteArrayOutputStream os = new ByteArrayOutputStream(60000);
                        cat.writeXML(os, true);
                        IO.writeToFile(os.toString(), "C:/dev/netcdf-java-2.2/test/serverConfig/end.xml");
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        AbstractButton infoButton = BAMutil.makeButtcon("Information", "Extract Info", false);
        infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvDatasetImpl ds = TDServerConfigurator.this.datasetEditor.getExtractedDataset();
                if (ds == null) {
                    return;
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream(60000);
                PrintStream out = new PrintStream(os);
                TDServerConfigurator.this.extractor.extractTypedDatasetInfo(out, ds);
                TDServerConfigurator.this.extractPane.setText(os.toString());
                TDServerConfigurator.this.extractWindow.show();
            }
        });
        JPanel topButtons = new JPanel(new FlowLayout(0, 5, 0));
        topButtons.add(connectButton);
        topButtons.add(catSource);
        topButtons.add(saveSource);
        topButtons.add(infoButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("Catalog URL"), "West");
        topPanel.add((Component)this.catalogCB, "Center");
        topPanel.add((Component)topButtons, "East");
        this.catTree = new CatalogTreeView();
        this.catTree.setOpenCatalogReferences(false);
        this.catTree.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (TDServerConfigurator.this.debugEvents) {
                    System.out.println("ServerConfigurator tree propertyChange= " + e.getPropertyName());
                }
                if (e.getPropertyName().equals("Catalog")) {
                    InvCatalogImpl cat = TDServerConfigurator.this.catTree.getCatalog();
                    TDServerConfigurator.this.setCatalogURL();
                    TDServerConfigurator.this.catalogCB.addItem(e.getNewValue());
                    InvDatasetImpl top = cat.getDataset();
                    if (top != null) {
                        TDServerConfigurator.this.catTree.setSelectedDataset(top);
                    }
                }
                if (e.getPropertyName().equals("Selection")) {
                    InvDatasetImpl ds = (InvDatasetImpl)e.getNewValue();
                    if (!TDServerConfigurator.this.datasetEditor.setDataset(ds)) {
                        JOptionPane.showMessageDialog(TDServerConfigurator.this, "The current dataset has editing errors - please fix those first");
                        TDServerConfigurator.this.catTree.setSelectedDataset(TDServerConfigurator.this.datasetEditor.getDataset());
                    }
                }
            }
        });
        PopupMenu csPopup = new PopupMenu(this.catTree.getJTree(), "Options");
        csPopup.addAction("Move To", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvDataset ds = TDServerConfigurator.this.catTree.getSelectedDataset();
                if (ds == null) {
                    return;
                }
                if (ds instanceof InvDatasetScan) {
                    return;
                }
                if (!(ds instanceof InvCatalogRef)) {
                    return;
                }
                InvCatalogRef catref = (InvCatalogRef)ds;
                URI uri = catref.getURI();
                String path = uri.toString();
                int pos = path.indexOf("/thredds/");
                if (pos < 0) {
                    return;
                }
                TDServerConfigurator.this.catalogPath = path.substring(0, pos + 9) + "content/" + path.substring(pos + 9);
                TDServerConfigurator.this.catalogCB.addItem(TDServerConfigurator.this.catalogPath);
                TDServerConfigurator.this.catTree.setCatalog(TDServerConfigurator.this.catalogPath);
            }
        });
        csPopup.addAction("Expand", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvDataset ds = TDServerConfigurator.this.catTree.getSelectedDataset();
                if (ds == null) {
                    return;
                }
                if (!(ds instanceof InvDatasetScan)) {
                    return;
                }
                TDServerConfigurator.this.expand((InvDatasetScan)ds);
                TDServerConfigurator.this.catTree.redisplay();
            }
        });
        csPopup.addAction("Show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvDatasetImpl ds = (InvDatasetImpl)TDServerConfigurator.this.catTree.getSelectedDataset();
                if (ds == null) {
                    return;
                }
                StringBuilder sbuff = new StringBuilder(20000);
                InvDatasetImpl.writeHtmlDescription(sbuff, ds, true, false, false, false, true);
                TDServerConfigurator.this.htmlViewer.setContent(ds.getName(), sbuff.toString());
                TDServerConfigurator.this.htmlWindow.show();
            }
        });
        csPopup.addAction("Delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InvDatasetImpl ds = (InvDatasetImpl)TDServerConfigurator.this.catTree.getSelectedDataset();
                if (ds == null) {
                    return;
                }
                int confirm = JOptionPane.showConfirmDialog(TDServerConfigurator.this.catTree, "Do you want to delete " + ds.getName(), "Deleting dataset", 0);
                if (confirm != 0) {
                    return;
                }
                InvDatasetImpl parent = (InvDatasetImpl)ds.getParentReal();
                if (parent == null) {
                    InvCatalogImpl cat = (InvCatalogImpl)ds.getParentCatalog();
                    if (cat != null) {
                        cat.removeDataset(ds);
                    }
                } else {
                    parent.removeDataset(ds);
                    parent.finish();
                }
                TDServerConfigurator.this.catTree.redisplay();
            }
        });
        this.datasetEditor = new DatasetEditor();
        this.sourcePane = new TextHistoryPane(false);
        this.sourceWindow = new IndependentWindow("Catalog Source", BAMutil.getImage("thredds"), this.sourcePane);
        this.sourceWindow.setBounds((Rectangle)prefs.getBean(SOURCE_WINDOW_SIZE, new Rectangle(50, 50, 725, 450)));
        this.extractPane = new TextHistoryPane(false);
        this.extractWindow = new IndependentWindow("Extract from dataset", BAMutil.getImage("thredds"), this.extractPane);
        this.extractWindow.setBounds((Rectangle)prefs.getBean(EXTRACT_WINDOW_SIZE, new Rectangle(50, 150, 725, 450)));
        this.savePane = new TextGetPutPane(prefs);
        this.saveWindow = new IndependentWindow("Save Changes", BAMutil.getImage("thredds"), this.savePane);
        this.saveWindow.setBounds((Rectangle)prefs.getBean(SAVE_WINDOW_SIZE, new Rectangle(50, 150, 725, 450)));
        this.htmlViewer = new HtmlBrowser();
        this.htmlWindow = new IndependentWindow("Dataset", BAMutil.getImage("thredds"), this.htmlViewer);
        this.htmlWindow.setBounds((Rectangle)prefs.getBean(SAVE_HTML_SIZE, new Rectangle(12, 25, 725, 900)));
        JButton rereadButt = new JButton("Server Reinit");
        rereadButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String catalogPath = (String)TDServerConfigurator.this.catalogCB.getSelectedItem();
                int pos = catalogPath.indexOf("/thredds/");
                String serverURL = catalogPath.substring(0, pos + 9);
                try {
                    String result = HttpClientManager.getContentAsString(null, serverURL + "debug?catalogs/reinit");
                    TDServerConfigurator.this.savePane.setText(result);
                }
                catch (Exception e) {
                    TDServerConfigurator.this.savePane.setText(e.getMessage());
                }
            }
        });
        this.savePane.addButton(rereadButt);
        this.savePane.addPutActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TDServerConfigurator.this.catTree.setCatalog(TDServerConfigurator.this.catalogPath);
            }
        });
        this.setLayout(new BorderLayout());
        this.splitH = new JSplitPane(1, false, this.catTree, this.datasetEditor);
        this.splitH.setDividerLocation(prefs.getInt(SPLIT_POS, 500));
        this.add((Component)topPanel, "North");
        this.add((Component)this.splitH, "Center");
        JPanel bottomPanel = new JPanel();
        this.add((Component)bottomPanel, "South");
    }

    public void save() {
        this.catalogCB.save();
        this.prefs.putInt(SPLIT_POS, this.splitH.getDividerLocation());
        this.prefs.putBeanObject(EXTRACT_WINDOW_SIZE, this.extractWindow.getBounds());
        this.prefs.putBeanObject(SOURCE_WINDOW_SIZE, this.sourceWindow.getBounds());
        this.prefs.putBeanObject(SAVE_WINDOW_SIZE, this.saveWindow.getBounds());
        this.prefs.putBeanObject(SAVE_HTML_SIZE, this.htmlWindow.getBounds());
        this.savePane.save();
    }

    private void expand(InvDatasetScan dscan) {
        InvCatalogImpl cat = (InvCatalogImpl)dscan.getParentCatalog();
        InvDatasetImpl replace = new InvDatasetImpl(dscan);
        List<InvDataset> datasets = dscan.getDatasets();
        for (int i = 0; i < datasets.size(); ++i) {
            InvDatasetImpl d = (InvDatasetImpl)datasets.get(i);
            if (d instanceof InvCatalogRef) {
                String ext = d.getName();
                String id = dscan.getID() == null ? ext : dscan.getID() + "/" + ext;
                InvDatasetScan replaceNested = new InvDatasetScan(replace, ext, dscan.getPath() + "/" + ext, dscan.getScanLocation() + ext + "/", id, dscan);
                replace.addDataset(replaceNested);
                continue;
            }
            d.setParent(replace);
            replace.addDataset(d);
        }
        InvDatasetImpl parent = (InvDatasetImpl)dscan.getParentReal();
        if (parent == null) {
            cat.replaceDataset(dscan, replace);
        } else {
            parent.replaceDataset(dscan, replace);
        }
        replace.finish();
    }

    private void setCatalogURL() {
        InvCatalogImpl cat = this.catTree.getCatalog();
        URI baseURI = cat.getBaseURI();
        String uri = baseURI.toString();
        String uriNew = StringUtil2.remove(uri, "content/");
        try {
            cat.setBaseURI(new URI(uriNew));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

