/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_Plus;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.wcs.v1_0_0_Plus.AxisSubset;
import thredds.wcs.v1_0_0_Plus.WcsDataset;
import thredds.wcs.v1_0_0_Plus.WcsException;
import thredds.wcs.v1_0_0_Plus.WcsRangeField;
import thredds.wcs.v1_0_0_Plus.WcsRequest;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.CFGridWriter;
import ucar.nc2.geotiff.GeotiffWriter;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ogc.EPSG_OGC_CF_Helper;

public class WcsCoverage {
    private static Logger log = LoggerFactory.getLogger(WcsCoverage.class);
    private GridDataset.Gridset coverage;
    private WcsDataset dataset;
    private String name;
    private String label;
    private String description;
    private GridCoordSystem coordSys;
    private String nativeCRS;
    private String defaultRequestCrs;
    private List<WcsRequest.Format> supportedCoverageFormatList;
    private HashMap<String, WcsRangeField> range;
    private static DiskCache2 diskCache = null;

    public WcsCoverage(GridDataset.Gridset coverage, WcsDataset dataset) {
        this.dataset = dataset;
        if (this.dataset == null) {
            log.error("WcsCoverage(): non-null dataset required.");
            throw new IllegalArgumentException("Non-null dataset required.");
        }
        this.coverage = coverage;
        if (this.coverage == null) {
            log.error("WcsCoverage(): non-null coverage required.");
            throw new IllegalArgumentException("Non-null coverage required.");
        }
        this.coordSys = coverage.getGeoCoordSystem();
        if (this.coordSys == null) {
            log.error("WcsCoverage(): Coverage must have non-null coordinate system.");
            throw new IllegalArgumentException("Non-null coordinate system required.");
        }
        this.name = this.coordSys.getName();
        this.label = this.coordSys.getName();
        this.range = new HashMap();
        StringBuilder descripSB = new StringBuilder("All parameters on the \"").append(this.name).append("\" coordinate system: ");
        for (GridDatatype curField : this.coverage.getGrids()) {
            String stdName = curField.findAttValueIgnoreCase("standard_name", "");
            descripSB.append(stdName.length() == 0 ? curField.getFullName() : stdName).append(",");
            WcsRangeField field = new WcsRangeField(curField);
            this.range.put(field.getName(), field);
        }
        descripSB.setCharAt(descripSB.length() - 1, '.');
        this.description = descripSB.toString();
        this.nativeCRS = EPSG_OGC_CF_Helper.getWcs1_0CrsId(this.coordSys.getProjection());
        this.defaultRequestCrs = "OGC:CRS84";
        this.supportedCoverageFormatList = new ArrayList<WcsRequest.Format>();
        this.supportedCoverageFormatList.add(WcsRequest.Format.GeoTIFF);
        this.supportedCoverageFormatList.add(WcsRequest.Format.GeoTIFF_Float);
        this.supportedCoverageFormatList.add(WcsRequest.Format.NetCDF3);
    }

    GridDataset.Gridset getGridset() {
        return this.coverage;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public GridCoordSystem getCoordinateSystem() {
        return this.coordSys;
    }

    public String getDefaultRequestCrs() {
        return this.defaultRequestCrs;
    }

    public String getNativeCrs() {
        return this.nativeCRS;
    }

    public List<WcsRequest.Format> getSupportedCoverageFormatList() {
        return Collections.unmodifiableList(this.supportedCoverageFormatList);
    }

    public boolean isSupportedCoverageFormat(WcsRequest.Format covFormat) {
        return this.supportedCoverageFormatList.contains((Object)covFormat);
    }

    public boolean isRangeFieldName(String fieldName) {
        return this.range.containsKey(fieldName);
    }

    public Set<String> getRangeFieldNames() {
        return this.range.keySet();
    }

    public Collection<WcsRangeField> getRange() {
        return this.range.values();
    }

    public static void setDiskCache(DiskCache2 _diskCache) {
        diskCache = _diskCache;
    }

    private static DiskCache2 getDiskCache() {
        if (diskCache == null) {
            log.error("getDiskCache(): Disk cache has not been set.");
            throw new IllegalStateException("Disk cache must be set before calling GetCoverage.getDiskCache().");
        }
        return diskCache;
    }

    public File writeCoverageDataToFile(WcsRequest.Format format, LatLonRect bboxLatLonRect, AxisSubset vertSubset, List<String> rangeSubset, CalendarDateRange timeRange) throws WcsException {
        boolean zRangeDone = false;
        boolean tRangeDone = false;
        try {
            Range zRange = vertSubset != null ? vertSubset.getRange() : null;
            zRangeDone = true;
            Range tRange = null;
            if (timeRange != null) {
                CoordinateAxis1DTime timeAxis = this.coordSys.getTimeAxis1D();
                int startIndex = timeAxis.findTimeIndexFromCalendarDate(timeRange.getStart());
                int endIndex = timeAxis.findTimeIndexFromCalendarDate(timeRange.getEnd());
                tRange = new Range(startIndex, endIndex);
                tRangeDone = true;
            }
            if (format == WcsRequest.Format.GeoTIFF || format == WcsRequest.Format.GeoTIFF_Float) {
                if (rangeSubset.size() != 1) {
                    String msg = "GeoTIFF response encoding only available for single range field selection [" + rangeSubset + "].";
                    log.error("writeCoverageDataToFile(): " + msg);
                    throw new WcsException(WcsException.Code.InvalidParameterValue, "RangeSubset", msg);
                }
                String reqRangeFieldName = rangeSubset.get(0);
                File dir = new File(WcsCoverage.getDiskCache().getRootDirectory());
                File tifFile = File.createTempFile("WCS", ".tif", dir);
                if (log.isDebugEnabled()) {
                    log.debug("writeCoverageDataToFile(): tifFile=" + tifFile.getPath());
                }
                WcsRangeField rangeField = this.range.get(reqRangeFieldName);
                GridDatatype subset = rangeField.getGridDatatype().makeSubset(tRange, zRange, bboxLatLonRect, 1, 1, 1);
                Array data = subset.readDataSlice(0, 0, -1, -1);
                GeotiffWriter writer = new GeotiffWriter(tifFile.getPath());
                writer.writeGrid(this.dataset.getDataset(), subset, data, format == WcsRequest.Format.GeoTIFF);
                writer.close();
                return tifFile;
            }
            if (format == WcsRequest.Format.NetCDF3) {
                File dir = new File(WcsCoverage.getDiskCache().getRootDirectory());
                File ncFile = File.createTempFile("WCS", ".nc", dir);
                if (log.isDebugEnabled()) {
                    log.debug("writeCoverageDataToFile(): ncFile=" + ncFile.getPath());
                }
                CFGridWriter writer = new CFGridWriter();
                this.coordSys.getVerticalAxis().isNumeric();
                writer.makeFile(ncFile.getPath(), this.dataset.getDataset(), rangeSubset, bboxLatLonRect, 1, zRange, timeRange, 1, true);
                return ncFile;
            }
            log.error("writeCoverageDataToFile(): Unsupported response encoding format [" + (Object)((Object)format) + "].");
            throw new WcsException(WcsException.Code.InvalidFormat, "Format", "Unsupported response encoding format [" + (Object)((Object)format) + "].");
        }
        catch (InvalidRangeException e) {
            String msg = "Failed to subset coverage [" + this.getName();
            msg = !zRangeDone ? msg + "] along vertical axis [" + vertSubset + "]. " : (!tRangeDone ? msg + "] along time axis [" + timeRange + "]. " : msg + "] in horizontal plane [" + bboxLatLonRect + "]. ");
            log.error("writeCoverageDataToFile(): " + msg + e.getMessage());
            throw new WcsException(WcsException.Code.CoverageNotDefined, "", msg);
        }
        catch (IOException e) {
            log.error("writeCoverageDataToFile(): Failed to write file for requested coverage <" + this.getName() + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.UNKNOWN, "", "Problem creating coverage [" + this.getName() + "].");
        }
    }
}

