/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.util.NamedObject;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.util.Format;

public class GeoGrid
implements NamedObject,
GridDatatype {
    private static final Logger log = LoggerFactory.getLogger(GeoGrid.class);
    private static final boolean debugArrayShape = false;
    private final GridDataset dataset;
    private final GridCoordSys gcs;
    private final VariableDS vs;
    private int xDimOrgIndex = -1;
    private int yDimOrgIndex = -1;
    private int zDimOrgIndex = -1;
    private int tDimOrgIndex = -1;
    private int eDimOrgIndex = -1;
    private int rtDimOrgIndex = -1;
    private int xDimNewIndex = -1;
    private int yDimNewIndex = -1;
    private int zDimNewIndex = -1;
    private int tDimNewIndex = -1;
    private int eDimNewIndex = -1;
    private int rtDimNewIndex = -1;
    private final List<Dimension> mydims;
    private int hashCode = 0;

    public GeoGrid(GridDataset dataset, VariableDS dsvar, GridCoordSys gcs) {
        this.dataset = dataset;
        this.vs = dsvar;
        this.gcs = gcs;
        CoordinateAxis xaxis = gcs.getXHorizAxis();
        if (xaxis instanceof CoordinateAxis1D) {
            this.xDimOrgIndex = this.findDimension(gcs.getXHorizAxis().getDimension(0));
            this.yDimOrgIndex = this.findDimension(gcs.getYHorizAxis().getDimension(0));
        } else {
            this.yDimOrgIndex = this.findDimension(gcs.getXHorizAxis().getDimension(0));
            this.xDimOrgIndex = this.findDimension(gcs.getXHorizAxis().getDimension(1));
        }
        if (gcs.getVerticalAxis() != null) {
            this.zDimOrgIndex = this.findDimension(gcs.getVerticalAxis().getDimension(0));
        }
        if (gcs.getTimeAxis() != null) {
            this.tDimOrgIndex = gcs.getTimeAxis1D() != null ? this.findDimension(gcs.getTimeAxis1D().getDimension(0)) : this.findDimension(gcs.getTimeAxis().getDimension(1));
            if (this.tDimOrgIndex == this.yDimOrgIndex || this.tDimOrgIndex == this.xDimOrgIndex) {
                this.tDimOrgIndex = -1;
            }
        }
        if (gcs.getEnsembleAxis() != null) {
            this.eDimOrgIndex = this.findDimension(gcs.getEnsembleAxis().getDimension(0));
        }
        if (gcs.getRunTimeAxis() != null) {
            this.rtDimOrgIndex = this.findDimension(gcs.getRunTimeAxis().getDimension(0));
        }
        int count = 0;
        this.mydims = new ArrayList<Dimension>();
        if (this.rtDimOrgIndex >= 0 && this.rtDimOrgIndex != this.tDimOrgIndex) {
            this.mydims.add(dsvar.getDimension(this.rtDimOrgIndex));
            this.rtDimNewIndex = count++;
        }
        if (this.eDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.eDimOrgIndex));
            this.eDimNewIndex = count++;
        }
        if (this.tDimOrgIndex >= 0) {
            Dimension tdim = dsvar.getDimension(this.tDimOrgIndex);
            this.mydims.add(tdim);
            this.tDimNewIndex = count++;
        }
        if (this.zDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.zDimOrgIndex));
            this.zDimNewIndex = count++;
        }
        if (this.yDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.yDimOrgIndex));
            this.yDimNewIndex = count++;
        }
        if (this.xDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.xDimOrgIndex));
            this.xDimNewIndex = count;
        }
    }

    private int findDimension(Dimension want) {
        List<Dimension> dims = this.vs.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension d = dims.get(i);
            if (!d.equals(want)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Dimension> getDimensions() {
        return new ArrayList<Dimension>(this.mydims);
    }

    @Override
    public Dimension getDimension(int i) {
        if (i < 0 || i >= this.mydims.size()) {
            return null;
        }
        return this.mydims.get(i);
    }

    @Override
    public Dimension getTimeDimension() {
        return this.tDimNewIndex < 0 ? null : this.getDimension(this.tDimNewIndex);
    }

    @Override
    public Dimension getZDimension() {
        return this.zDimNewIndex < 0 ? null : this.getDimension(this.zDimNewIndex);
    }

    @Override
    public Dimension getYDimension() {
        return this.yDimNewIndex < 0 ? null : this.getDimension(this.yDimNewIndex);
    }

    @Override
    public Dimension getXDimension() {
        return this.xDimNewIndex < 0 ? null : this.getDimension(this.xDimNewIndex);
    }

    @Override
    public Dimension getEnsembleDimension() {
        return this.eDimNewIndex < 0 ? null : this.getDimension(this.eDimNewIndex);
    }

    @Override
    public Dimension getRunTimeDimension() {
        return this.rtDimNewIndex < 0 ? null : this.getDimension(this.rtDimNewIndex);
    }

    @Override
    public int getTimeDimensionIndex() {
        return this.tDimNewIndex;
    }

    @Override
    public int getZDimensionIndex() {
        return this.zDimNewIndex;
    }

    @Override
    public int getYDimensionIndex() {
        return this.yDimNewIndex;
    }

    @Override
    public int getXDimensionIndex() {
        return this.xDimNewIndex;
    }

    @Override
    public int getEnsembleDimensionIndex() {
        return this.eDimNewIndex;
    }

    @Override
    public int getRunTimeDimensionIndex() {
        return this.rtDimNewIndex;
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        return this.vs.findAttributeIgnoreCase(name);
    }

    @Override
    public String findAttValueIgnoreCase(String attName, String defaultValue) {
        return this.dataset.getNetcdfDataset().findAttValueIgnoreCase(this.vs, attName, defaultValue);
    }

    @Override
    public int getRank() {
        return this.mydims.size();
    }

    @Override
    public int[] getShape() {
        int[] shape = new int[this.mydims.size()];
        for (int i = 0; i < this.mydims.size(); ++i) {
            Dimension d = this.mydims.get(i);
            shape[i] = d.getLength();
        }
        return shape;
    }

    @Override
    public DataType getDataType() {
        return this.vs.getDataType();
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.vs.getAttributes();
    }

    @Override
    public VariableDS getVariable() {
        return this.vs;
    }

    @Override
    public String getFullName() {
        return this.vs.getFullName();
    }

    @Override
    public String getName() {
        return this.vs.getFullName();
    }

    @Override
    public String getShortName() {
        return this.vs.getShortName();
    }

    @Override
    public GridCoordSystem getCoordinateSystem() {
        return this.gcs;
    }

    @Override
    public ProjectionImpl getProjection() {
        return this.gcs.getProjection();
    }

    public List<NamedObject> getLevels() {
        return this.gcs.getLevels();
    }

    public List<NamedObject> getTimes() {
        return this.gcs.getTimes();
    }

    @Override
    public String getDescription() {
        return this.vs.getDescription();
    }

    @Override
    public String getUnitsString() {
        String units = this.vs.getUnitsString();
        return units == null ? "" : units;
    }

    public String getUnitString() {
        return this.getUnitsString();
    }

    @Override
    public boolean hasMissingData() {
        return this.vs.hasMissing();
    }

    @Override
    public boolean isMissingData(double val) {
        return this.vs.isMissing(val);
    }

    @Override
    public boolean hasMissing() {
        return this.vs.hasMissing();
    }

    @Override
    public boolean isMissing(double val) {
        return this.vs.isMissing(val);
    }

    @Override
    public float[] setMissingToNaN(float[] values) {
        if (!this.vs.hasMissing()) {
            return values;
        }
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            double value = values[i];
            if (!this.vs.isMissing(value)) continue;
            values[i] = Float.NaN;
        }
        return values;
    }

    @Override
    public MAMath.MinMax getMinMaxSkipMissingData(Array a) {
        return MAMath.getMinMaxSkipMissingData(a, this);
    }

    @Override
    public Array readVolumeData(int t) throws IOException {
        return this.readDataSlice(t, -1, -1, -1);
    }

    public Array readYXData(int t, int z) throws IOException {
        return this.readDataSlice(t, z, -1, -1);
    }

    public Array readZYData(int t, int x) throws IOException {
        return this.readDataSlice(t, -1, -1, x);
    }

    public Array getDataSlice(int t, int z, int y, int x) throws IOException {
        return this.readDataSlice(t, z, y, x);
    }

    @Override
    public Array readDataSlice(int t, int z, int y, int x) throws IOException {
        return this.readDataSlice(0, 0, t, z, y, x);
    }

    @Override
    public Array readDataSlice(int rt, int e, int t, int z, int y, int x) throws IOException {
        Array dataVolume;
        int rank = this.vs.getRank();
        int[] start = new int[rank];
        int[] shape = new int[rank];
        for (int i = 0; i < rank; ++i) {
            start[i] = 0;
            shape[i] = 1;
        }
        Dimension xdim = this.getXDimension();
        Dimension ydim = this.getYDimension();
        Dimension zdim = this.getZDimension();
        Dimension tdim = this.getTimeDimension();
        Dimension edim = this.getEnsembleDimension();
        Dimension rtdim = this.getRunTimeDimension();
        if (rtdim != null) {
            if (rt >= 0 && rt < rtdim.getLength()) {
                start[this.rtDimOrgIndex] = rt;
            } else {
                shape[this.rtDimOrgIndex] = rtdim.getLength();
            }
        }
        if (edim != null) {
            if (e >= 0 && e < edim.getLength()) {
                start[this.eDimOrgIndex] = e;
            } else {
                shape[this.eDimOrgIndex] = edim.getLength();
            }
        }
        if (tdim != null) {
            if (t >= 0 && t < tdim.getLength()) {
                start[this.tDimOrgIndex] = t;
            } else {
                shape[this.tDimOrgIndex] = tdim.getLength();
            }
        }
        if (zdim != null) {
            if (z >= 0 && z < zdim.getLength()) {
                start[this.zDimOrgIndex] = z;
            } else {
                shape[this.zDimOrgIndex] = zdim.getLength();
            }
        }
        if (ydim != null) {
            if (y >= 0 && y < ydim.getLength()) {
                start[this.yDimOrgIndex] = y;
            } else {
                shape[this.yDimOrgIndex] = ydim.getLength();
            }
        }
        if (xdim != null) {
            if (x >= 0 && x < xdim.getLength()) {
                start[this.xDimOrgIndex] = x;
            } else {
                shape[this.xDimOrgIndex] = xdim.getLength();
            }
        }
        try {
            dataVolume = this.vs.read(start, shape);
        }
        catch (Exception ex) {
            log.error("GeoGrid.getdataSlice() on dataset " + this.getFullName() + " " + this.dataset.getLocation(), ex);
            throw new IOException(ex);
        }
        ArrayList<Dimension> oldDims = new ArrayList<Dimension>(this.vs.getDimensions());
        int[] permuteIndex = new int[dataVolume.getRank()];
        int count = 0;
        if (oldDims.contains(rtdim)) {
            permuteIndex[count++] = oldDims.indexOf(rtdim);
        }
        if (oldDims.contains(edim)) {
            permuteIndex[count++] = oldDims.indexOf(edim);
        }
        if (oldDims.contains(tdim)) {
            permuteIndex[count++] = oldDims.indexOf(tdim);
        }
        if (oldDims.contains(zdim)) {
            permuteIndex[count++] = oldDims.indexOf(zdim);
        }
        if (oldDims.contains(ydim)) {
            permuteIndex[count++] = oldDims.indexOf(ydim);
        }
        if (oldDims.contains(xdim)) {
            permuteIndex[count] = oldDims.indexOf(xdim);
        }
        boolean needPermute = false;
        for (int i = 0; i < permuteIndex.length; ++i) {
            if (i == permuteIndex[i]) continue;
            needPermute = true;
        }
        if (needPermute) {
            dataVolume = dataVolume.permute(permuteIndex);
        }
        count = 0;
        if (rtdim != null) {
            if (rt >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (edim != null) {
            if (e >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (tdim != null) {
            if (t >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (zdim != null) {
            if (z >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (ydim != null) {
            if (y >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (xdim != null && x >= 0) {
            dataVolume = dataVolume.reduce(count);
        }
        return dataVolume;
    }

    public GeoGrid subset(Range t_range, Range z_range, LatLonRect bbox, int z_stride, int y_stride, int x_stride) throws InvalidRangeException {
        Dimension zdim;
        if (z_range == null && z_stride > 1 && (zdim = this.getZDimension()) != null) {
            z_range = new Range(0, zdim.getLength() - 1, z_stride);
        }
        Range y_range = null;
        Range x_range = null;
        if (bbox != null) {
            List<Range> yx_ranges = this.gcs.getRangesFromLatLonRect(bbox);
            y_range = yx_ranges.get(0);
            x_range = yx_ranges.get(1);
        }
        if (y_stride > 1) {
            if (y_range == null) {
                Dimension ydim = this.getYDimension();
                y_range = new Range(0, ydim.getLength() - 1, y_stride);
            } else {
                y_range = new Range(y_range.first(), y_range.last(), y_stride);
            }
        }
        if (x_stride > 1) {
            if (x_range == null) {
                Dimension xdim = this.getXDimension();
                x_range = new Range(0, xdim.getLength() - 1, x_stride);
            } else {
                x_range = new Range(x_range.first(), x_range.last(), x_stride);
            }
        }
        return this.subset(t_range, z_range, y_range, x_range);
    }

    @Override
    public GridDatatype makeSubset(Range t_range, Range z_range, LatLonRect bbox, int z_stride, int y_stride, int x_stride) throws InvalidRangeException {
        return this.subset(t_range, z_range, bbox, z_stride, y_stride, x_stride);
    }

    public GeoGrid subset(Range t_range, Range z_range, Range y_range, Range x_range) throws InvalidRangeException {
        return (GeoGrid)this.makeSubset(null, null, t_range, z_range, y_range, x_range);
    }

    @Override
    public GridDatatype makeSubset(Range rt_range, Range e_range, Range t_range, Range z_range, Range y_range, Range x_range) throws InvalidRangeException {
        int rank = this.getRank();
        Range[] ranges = new Range[rank];
        if (null != this.getXDimension()) {
            ranges[this.xDimOrgIndex] = x_range;
        }
        if (null != this.getYDimension()) {
            ranges[this.yDimOrgIndex] = y_range;
        }
        if (null != this.getZDimension()) {
            ranges[this.zDimOrgIndex] = z_range;
        }
        if (null != this.getTimeDimension()) {
            ranges[this.tDimOrgIndex] = t_range;
        }
        if (null != this.getRunTimeDimension()) {
            ranges[this.rtDimOrgIndex] = rt_range;
        }
        if (null != this.getEnsembleDimension()) {
            ranges[this.eDimOrgIndex] = e_range;
        }
        List<Range> rangesList = Arrays.asList(ranges);
        VariableDS v_section = (VariableDS)this.vs.section(new Section(rangesList));
        List<Dimension> dims = v_section.getDimensions();
        for (Dimension dim : dims) {
            dim.setShared(true);
        }
        GridCoordSys gcs_section = new GridCoordSys(this.gcs, rt_range, e_range, t_range, z_range, y_range, x_range);
        return new GeoGrid(this.dataset, v_section, gcs_section);
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof GeoGrid)) {
            return false;
        }
        GeoGrid d = (GeoGrid)oo;
        if (!this.getFullName().equals(d.getFullName())) {
            return false;
        }
        return this.getCoordinateSystem().equals(d.getCoordinateSystem());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getFullName().hashCode();
            this.hashCode = result = 37 * result + this.getCoordinateSystem().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.getFullName();
    }

    @Override
    public String getInfo() {
        StringBuilder buf = new StringBuilder(200);
        buf.setLength(0);
        buf.append(this.getFullName());
        Format.tab(buf, 30, true);
        buf.append(this.getUnitsString());
        Format.tab(buf, 60, true);
        buf.append(this.hasMissingData());
        Format.tab(buf, 66, true);
        buf.append(this.getDescription());
        return buf.toString();
    }

    @Override
    public int compareTo(GridDatatype g) {
        return this.getFullName().compareTo(g.getFullName());
    }
}

