/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.collection.Grib2Iosp;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.PartitionCollection;
import ucar.nc2.grib.grib2.table.Grib2Customizer;

public class Grib2Partition
extends PartitionCollection
implements AutoCloseable {
    public Grib2Partition(String name, File directory, FeatureCollectionConfig config, Logger logger) {
        super(name, directory, config, false, logger);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(GribCollection.Dataset ds, GribCollection.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        Grib2Iosp iosp = new Grib2Iosp(group, ds.getType());
        GribCollection.NetcdfFileGC ncfile = new GribCollection.NetcdfFileGC(iosp, null, this.getIndexFilepathInCache(), null);
        return new NetcdfDataset(ncfile);
    }

    @Override
    public GridDataset getGridDataset(GribCollection.Dataset ds, GribCollection.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        Grib2Iosp iosp = new Grib2Iosp(group, ds.getType());
        GribCollection.NetcdfFileGC ncfile = new GribCollection.NetcdfFileGC(iosp, null, this.getIndexFilepathInCache(), null);
        NetcdfDataset ncd = new NetcdfDataset(ncfile);
        return new GridDataset(ncd);
    }

    @Override
    public String makeVariableName(GribCollection.VariableIndex vindex) {
        return Grib2Iosp.makeVariableNameFromTable((Grib2Customizer)this.cust, this, vindex);
    }
}

