/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import thredds.inventory.CollectionManager;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.PartitionManagerFromIndexList;
import ucar.coord.CoordinateRuntime;
import ucar.nc2.grib.GribIndex;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CloseableIterator;
import ucar.unidata.util.StringUtil2;

public abstract class GribCollectionBuilder {
    protected final MCollection dcm;
    protected final Logger logger;
    protected final boolean isGrib1;
    protected String name;
    protected File directory;

    protected abstract List<? extends Group> makeGroups(List<MFile> var1, Formatter var2) throws IOException;

    protected abstract boolean writeIndex(String var1, String var2, CoordinateRuntime var3, List<? extends Group> var4, List<MFile> var5) throws IOException;

    public GribCollectionBuilder(boolean isGrib1, String name, MCollection dcm, Logger logger) {
        this.dcm = dcm;
        this.logger = logger;
        this.isGrib1 = isGrib1;
        this.name = StringUtil2.replace(name, ' ', "_");
        this.directory = new File(dcm.getRoot());
    }

    public boolean updateNeeded(CollectionUpdateType ff) throws IOException {
        if (ff == CollectionUpdateType.never) {
            return false;
        }
        if (ff == CollectionUpdateType.always) {
            return true;
        }
        File idx = GribCollection.getFileInCache(this.dcm.getIndexFilename());
        if (!idx.exists()) {
            return true;
        }
        if (ff == CollectionUpdateType.nocheck) {
            return false;
        }
        return this.collectionWasChanged(idx.lastModified());
    }

    private boolean collectionWasChanged(long idxLastModified) throws IOException {
        CollectionManager.ChangeChecker cc = GribIndex.getChangeChecker();
        try (CloseableIterator<MFile> iter = this.dcm.getFileIterator();){
            while (iter.hasNext()) {
                if (!cc.hasChangedSince((MFile)iter.next(), idxLastModified)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean createIndex(Formatter errlog) throws IOException {
        if (this.dcm == null) {
            this.logger.error("GribCollectionBuilder " + this.name + " : cannot create new index ");
            throw new IllegalStateException();
        }
        long start = System.currentTimeMillis();
        ArrayList<MFile> files = new ArrayList<MFile>();
        List<? extends Group> groups = this.makeGroups(files, errlog);
        List<MFile> allFiles = Collections.unmodifiableList(files);
        HashMap<Long, ArrayList<Group>> runGroups = new HashMap<Long, ArrayList<Group>>();
        for (Group group : groups) {
            ArrayList<Group> runGroup = (ArrayList<Group>)runGroups.get(group.getRuntime().getMillis());
            if (runGroup == null) {
                runGroup = new ArrayList<Group>();
                runGroups.put(group.getRuntime().getMillis(), runGroup);
            }
            runGroup.add(group);
        }
        boolean multipleRuntimes = runGroups.values().size() > 1;
        ArrayList<MFile> arrayList = new ArrayList<MFile>();
        for (List runGroupList : runGroups.values()) {
            Group g = (Group)runGroupList.get(0);
            String gcname = multipleRuntimes ? GribCollection.makeName(this.name, g.getRuntime()) : this.name;
            MFile indexFileForRuntime = GribCollection.makeIndexMFile(gcname, this.directory);
            arrayList.add(indexFileForRuntime);
            boolean ok = this.writeIndex(gcname, indexFileForRuntime.getPath(), g.getCoordinateRuntime(), runGroupList, allFiles);
            this.logger.info("GribCollectionBuilder write {} ok={}", (Object)indexFileForRuntime.getPath(), (Object)ok);
        }
        boolean ok = true;
        if (multipleRuntimes) {
            Collections.sort(arrayList);
            PartitionManagerFromIndexList part = new PartitionManagerFromIndexList(this.dcm, arrayList, this.logger);
            part.putAuxInfo("fcConfig", this.dcm.getAuxInfo("fcConfig"));
            ok = GribCdmIndex.updateGribCollectionFromMCollection(this.isGrib1, part, CollectionUpdateType.always, errlog, this.logger);
        }
        long took = System.currentTimeMillis() - start;
        this.logger.debug("That took {} msecs", (Object)took);
        return ok;
    }

    protected class GroupAndRuntime {
        int gdsHash;
        long runtime;

        GroupAndRuntime(int gdsHash, long runtime) {
            this.gdsHash = gdsHash;
            this.runtime = runtime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupAndRuntime that = (GroupAndRuntime)o;
            if (this.gdsHash != that.gdsHash) {
                return false;
            }
            return this.runtime == that.runtime;
        }

        public int hashCode() {
            int result = this.gdsHash;
            result = 31 * result + (int)(this.runtime ^ this.runtime >>> 32);
            return result;
        }
    }

    public static interface Group {
        public CalendarDate getRuntime();

        public CoordinateRuntime getCoordinateRuntime();
    }
}

