/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.MFile;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.SparseArray;
import ucar.nc2.grib.collection.Grib2CollectionBuilderFromIndex;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.PartitionCollection;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.ui.MFileTable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.Indent;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class CdmIndex2Panel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(CdmIndex2Panel.class);
    private PreferencesExt prefs;
    private BeanTable groupTable;
    private BeanTable varTable;
    private BeanTable coordTable;
    private JSplitPane split;
    private JSplitPane split2;
    private JSplitPane split3;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private MFileTable fileTable;
    GribCollection gc;
    Collection<MFile> gcFiles;
    FeatureCollectionConfig config = new FeatureCollectionConfig();

    public CdmIndex2Panel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        if (buttPanel != null) {
            AbstractButton infoButton = BAMutil.makeButtcon("Information", "Show Info", false);
            infoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    CdmIndex2Panel.this.showInfo(f);
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            });
            buttPanel.add(infoButton);
            AbstractButton filesButton = BAMutil.makeButtcon("Information", "Show Files", false);
            filesButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CdmIndex2Panel.this.gc != null) {
                        CdmIndex2Panel.this.showFileTable(CdmIndex2Panel.this.gc, null);
                    }
                }
            });
            buttPanel.add(filesButton);
            AbstractButton rawButton = BAMutil.makeButtcon("Information", "Show Raw Info", false);
            rawButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Formatter f = new Formatter();
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            });
            buttPanel.add(rawButton);
        }
        this.groupTable = new BeanTable(GroupBean.class, (PreferencesExt)prefs.node("GroupBean"), false, "GDS group", "GribCollection.GroupHcs", null);
        this.groupTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GroupBean bean = (GroupBean)CdmIndex2Panel.this.groupTable.getSelectedBean();
                if (bean != null) {
                    CdmIndex2Panel.this.setGroup(bean.group);
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.groupTable.getJTable(), "Options");
        varPopup.addAction("Show Group Info", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupBean bean = (GroupBean)CdmIndex2Panel.this.groupTable.getSelectedBean();
                if (bean != null && bean.group != null) {
                    Formatter f = new Formatter();
                    bean.group.show(f);
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Show Files Used", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupBean bean = (GroupBean)CdmIndex2Panel.this.groupTable.getSelectedBean();
                if (bean != null && bean.group != null) {
                    CdmIndex2Panel.this.showFileTable(CdmIndex2Panel.this.gc, bean.group);
                }
            }
        });
        this.varTable = new BeanTable(VarBean.class, (PreferencesExt)prefs.node("Grib2Bean"), false, "Variables in group", "GribCollection.VariableIndex", null);
        varPopup = new PopupMenu(this.varTable.getJTable(), "Options");
        varPopup.addAction("Show Variable(s)", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndex2Panel.this.varTable.getSelectedBeans();
                CdmIndex2Panel.this.infoTA.clear();
                for (VarBean bean : beans) {
                    CdmIndex2Panel.this.infoTA.appendLine(bean.v.toStringComplete());
                }
                CdmIndex2Panel.this.infoTA.gotoTop();
                CdmIndex2Panel.this.infoWindow.show();
            }
        });
        varPopup.addAction("Show Sparse Array", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarBean bean = (VarBean)CdmIndex2Panel.this.varTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.showSparseArray(f);
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Make Variable(s) GribConfig", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndex2Panel.this.varTable.getSelectedBeans();
                CdmIndex2Panel.this.infoTA.clear();
                Formatter f = new Formatter();
                for (VarBean bean : beans) {
                    bean.makeGribConfig(f);
                }
                CdmIndex2Panel.this.infoTA.appendLine(f.toString());
                CdmIndex2Panel.this.infoTA.gotoTop();
                CdmIndex2Panel.this.infoWindow.show();
            }
        });
        this.coordTable = new BeanTable(CoordBean.class, (PreferencesExt)prefs.node("CoordBean"), false, "Coordinates in group", "Coordinates", null);
        varPopup = new PopupMenu(this.coordTable.getJTable(), "Options");
        varPopup.addAction("Show", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)CdmIndex2Panel.this.coordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.coord.showCoords(f);
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("ShowCompact", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)CdmIndex2Panel.this.coordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    bean.coord.showInfo(f, new Indent(2));
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Test Time2D isRegular", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordBean bean = (CoordBean)CdmIndex2Panel.this.coordTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    CdmIndex2Panel.this.testOrthogonal(f, bean.coord);
                    CdmIndex2Panel.this.testRegular(f, bean.coord);
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Compare", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndex2Panel.this.coordTable.getSelectedBeans();
                if (beans.size() == 2) {
                    Formatter f = new Formatter();
                    CoordBean bean1 = (CoordBean)beans.get(0);
                    CoordBean bean2 = (CoordBean)beans.get(1);
                    if (bean1.coord.getType() == Coordinate.Type.time2D && bean2.coord.getType() == Coordinate.Type.time2D) {
                        CdmIndex2Panel.this.compareCoords2D(f, (CoordinateTime2D)bean1.coord, (CoordinateTime2D)bean2.coord);
                    } else {
                        CdmIndex2Panel.this.compareCoords(f, bean1.coord, bean2.coord);
                    }
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        varPopup.addAction("Try to Merge", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = CdmIndex2Panel.this.coordTable.getSelectedBeans();
                if (beans.size() == 2) {
                    Formatter f = new Formatter();
                    CoordBean bean1 = (CoordBean)beans.get(0);
                    CoordBean bean2 = (CoordBean)beans.get(1);
                    if (bean1.coord.getType() == Coordinate.Type.time2D && bean2.coord.getType() == Coordinate.Type.time2D) {
                        CdmIndex2Panel.this.mergeCoords2D(f, (CoordinateTime2D)bean1.coord, (CoordinateTime2D)bean2.coord);
                    } else {
                        f.format("CoordinateTime2D only", new Object[0]);
                    }
                    CdmIndex2Panel.this.infoTA.setText(f.toString());
                    CdmIndex2Panel.this.infoTA.gotoTop();
                    CdmIndex2Panel.this.infoWindow.show();
                }
            }
        });
        this.fileTable = new MFileTable((PreferencesExt)prefs.node("MFileTable"), true);
        this.fileTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CdmIndex2Panel.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split3 = new JSplitPane(0, false, this.groupTable, this.varTable);
        this.split3.setDividerLocation(prefs.getInt("splitPos3", 800));
        this.split2 = new JSplitPane(0, false, this.split3, this.coordTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.add((Component)this.split2, "Center");
    }

    public void save() {
        this.groupTable.saveState(false);
        this.varTable.saveState(false);
        this.coordTable.saveState(false);
        this.fileTable.save();
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
        if (this.split3 != null) {
            this.prefs.putInt("splitPos3", this.split3.getDividerLocation());
        }
    }

    public void clear() {
        if (this.gc != null) {
            try {
                this.gc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.gc = null;
        this.groupTable.clearBeans();
        this.varTable.clearBeans();
        this.coordTable.clearBeans();
    }

    public void showInfo(Formatter f) {
        if (this.gc == null) {
            return;
        }
        this.gc.showIndex(f);
        f.format("%n", new Object[0]);
        List groups = this.groupTable.getBeans();
        for (GroupBean bean : groups) {
            f.format("%-50s %-50s %d%n", bean.getGroupId(), bean.getDescription(), bean.getGdsHash());
            bean.group.show(f);
        }
        f.format("%n", new Object[0]);
    }

    private void compareCoords(Formatter f, Coordinate coord1, Coordinate coord2) {
        boolean missing;
        List<? extends Object> vals1 = coord1.getValues();
        List<? extends Object> vals2 = coord2.getValues();
        f.format("Coordinate %s%n", coord1.getName());
        for (Object object : vals1) {
            missing = !vals2.contains(object);
            f.format(" %s %s%n", object, missing ? "MISSING IN 2" : "");
        }
        f.format("%nCoordinate %s%n", coord2.getName());
        for (Object object : vals2) {
            missing = !vals1.contains(object);
            f.format(" %s %s%n", object, missing ? "MISSING IN 1" : "");
        }
    }

    private void compareCoords2D(Formatter f, CoordinateTime2D coord1, CoordinateTime2D coord2) {
        int n2;
        CoordinateRuntime runtimes1 = coord1.getRuntimeCoordinate();
        CoordinateRuntime runtimes2 = coord2.getRuntimeCoordinate();
        int n1 = coord1.getNruns();
        if (n1 != (n2 = coord2.getNruns())) {
            f.format("Coordinate 1 has %d runtimes, Coordinate 2 has %d runtimes, %n", n1, n2);
        }
        int min = Math.min(n1, n2);
        for (int idx = 0; idx < min; ++idx) {
            CoordinateTimeAbstract time1 = coord1.getTimeCoordinate(idx);
            CoordinateTimeAbstract time2 = coord2.getTimeCoordinate(idx);
            f.format("Run %d %n", idx);
            if (!runtimes1.getValue(idx).equals(runtimes2.getValue(idx))) {
                f.format("Runtime 1 %s != %s runtime 2%n", runtimes1.getValue(idx), runtimes2.getValue(idx));
            }
            this.compareCoords(f, time1, time2);
        }
    }

    private void mergeCoords2D(Formatter f, CoordinateTime2D coord1, CoordinateTime2D coord2) {
        int n2;
        if (coord1.isTimeInterval() != coord2.isTimeInterval()) {
            f.format("Coordinate 1 isTimeInterval %s != Coordinate 2 isTimeInterval %s %n", coord1.isTimeInterval(), coord2.isTimeInterval());
            return;
        }
        CoordinateRuntime runtimes1 = coord1.getRuntimeCoordinate();
        CoordinateRuntime runtimes2 = coord2.getRuntimeCoordinate();
        int n1 = coord1.getNruns();
        if (n1 != (n2 = coord2.getNruns())) {
            f.format("Coordinate 1 has %d runtimes, Coordinate 2 has %d runtimes, %n", n1, n2);
        }
        int min = Math.min(n1, n2);
        for (int idx = 0; idx < min; ++idx) {
            if (runtimes1.getValue(idx).equals(runtimes2.getValue(idx))) continue;
            f.format("Runtime 1 %s != %s runtime 2%n", runtimes1.getValue(idx), runtimes2.getValue(idx));
        }
        Set<Object> set1 = this.makeCoordSet(coord1);
        List<? extends Object> list1 = coord1.getOffsetsSorted();
        Set<Object> set2 = this.makeCoordSet(coord2);
        List<? extends Object> list2 = coord2.getOffsetsSorted();
        f.format("%nCoordinate %s%n", coord1.getName());
        for (Object object : list1) {
            f.format(" %s,", object);
        }
        f.format(" n=(%d)%n", list1.size());
        this.testMissing(f, list1, set2);
        f.format("%nCoordinate %s%n", coord2.getName());
        for (Object object : list2) {
            f.format(" %s,", object);
        }
        f.format(" (n=%d)%n", list2.size());
        this.testMissing(f, list2, set1);
    }

    private Set<Object> makeCoordSet(CoordinateTime2D time2D) {
        HashSet<Object> result = new HashSet<Object>(100);
        for (int runIdx = 0; runIdx < time2D.getNruns(); ++runIdx) {
            CoordinateTimeAbstract coord = time2D.getTimeCoordinate(runIdx);
            for (Object object : coord.getValues()) {
                result.add(object);
            }
        }
        return result;
    }

    private void testMissing(Formatter f, List<? extends Object> test, Set<Object> against) {
        int countMissing = 0;
        for (Object object : test) {
            if (against.contains(object)) continue;
            f.format(" %d: %s MISSING%n", countMissing++, object);
        }
        f.format("TOTAL MISSING %s%n", countMissing);
    }

    private boolean testOrthogonal(Formatter f, Coordinate c) {
        if (!(c instanceof CoordinateTime2D)) {
            f.format("Must be CoordinateTime2D", new Object[0]);
            return false;
        }
        CoordinateTime2D time2D = (CoordinateTime2D)c;
        ArrayList<CoordinateTimeAbstract> coords = new ArrayList<CoordinateTimeAbstract>();
        for (int runIdx = 0; runIdx < time2D.getNruns(); ++runIdx) {
            coords.add(time2D.getTimeCoordinate(runIdx));
        }
        return this.testOrthogonal(f, coords);
    }

    private boolean testRegular(Formatter f, Coordinate c) {
        if (!(c instanceof CoordinateTime2D)) {
            f.format("Must be CoordinateTime2D", new Object[0]);
            return false;
        }
        f.format("Test isRegular by Offset Hour%n", new Object[0]);
        CoordinateTime2D time2D = (CoordinateTime2D)c;
        HashMap<Integer, ArrayList<CoordinateTimeAbstract>> hourMap = new HashMap<Integer, ArrayList<CoordinateTimeAbstract>>();
        for (int runIdx = 0; runIdx < time2D.getNruns(); ++runIdx) {
            CoordinateTimeAbstract coord = time2D.getTimeCoordinate(runIdx);
            CalendarDate runDate = coord.getRefDate();
            int hour = runDate.getHourOfDay();
            ArrayList<CoordinateTimeAbstract> hg = (ArrayList<CoordinateTimeAbstract>)hourMap.get(hour);
            if (hg == null) {
                hg = new ArrayList<CoordinateTimeAbstract>();
                hourMap.put(hour, hg);
            }
            hg.add(coord);
        }
        boolean ok = true;
        Iterator i$ = hourMap.keySet().iterator();
        while (i$.hasNext()) {
            int hour = (Integer)i$.next();
            List hg = (List)hourMap.get(hour);
            f.format("Hour %d: ", hour);
            for (CoordinateTimeAbstract coord : hg) {
                f.format("%s,", coord.getRefDate());
            }
            f.format("%n", new Object[0]);
            ok &= this.testOrthogonal(f, hg);
        }
        f.format("%nAll orthogonal: %s%n", ok);
        return ok;
    }

    private boolean testOrthogonal(Formatter f, List<CoordinateTimeAbstract> times) {
        int max = 0;
        HashSet<Object> allCoords = new HashSet<Object>(100);
        for (CoordinateTimeAbstract coord : times) {
            max = Math.max(max, coord.getSize());
            for (Object object : coord.getValues()) {
                allCoords.add(object);
            }
        }
        int totalMax = allCoords.size();
        boolean isOrthogonal = totalMax == max;
        f.format("isOrthogonal %s : totalMax = %d max=%d %n%n", isOrthogonal, totalMax, max);
        return isOrthogonal;
    }

    private void compareFiles(Formatter f) throws IOException {
        if (this.gc == null) {
            return;
        }
        ArrayList<String> canon = new ArrayList<String>(this.gc.getFilenames());
        Collections.sort(canon);
        File idxFile = new File(this.gc.getIndexFilepathInCache());
        File dir = idxFile.getParentFile();
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".ncx");
            }
        });
        int total = 0;
        for (File file : files) {
            RandomAccessFile raf = new RandomAccessFile(file.getPath(), "r");
            GribCollection cgc = Grib2CollectionBuilderFromIndex.readFromIndex(file.getName(), raf, null, false, logger);
            ArrayList<String> cfiles = new ArrayList<String>(cgc.getFilenames());
            Collections.sort(cfiles);
            f.format("Compare files in %s to canonical files in %s%n", file.getPath(), idxFile.getPath());
            this.compareSortedList(f, canon.iterator(), cfiles.iterator());
            f.format("  Compared %d files to %d files%n%n", cfiles.size(), canon.size());
            raf.close();
            total += cfiles.size();
        }
        f.format("Total files = %d%n%n", total);
    }

    private void compareSortedList(Formatter f, Iterator<String> i1, Iterator<String> i2) {
        String s1 = null;
        String s2 = null;
        boolean need1 = true;
        boolean need2 = true;
        while (true) {
            if (need1) {
                String string = s1 = i1.hasNext() ? i1.next() : null;
            }
            if (need2) {
                s2 = i2.hasNext() ? i2.next() : null;
            }
            need1 = true;
            need2 = true;
            if (s1 == null && s2 == null) break;
            if (s1 == null) {
                f.format(" extra file = %s%n", s2);
                continue;
            }
            if (s2 == null) {
                f.format(" missing file = %s%n", s1);
                continue;
            }
            int pos = s1.lastIndexOf("/");
            String name1 = s1.substring(pos);
            name1 = name1.substring(1, name1.indexOf("gdas"));
            String name2 = s2.substring(pos);
            int val = name1.compareTo(name2 = name2.substring(1, name2.indexOf("gdas")));
            if (val < 0) {
                f.format(" missing file = %s%n", s1);
                need2 = false;
                continue;
            }
            if (val <= 0) continue;
            f.format(" extra file = %s%n", s2);
            need1 = false;
        }
    }

    public void setIndexFile(Path indexFile, FeatureCollectionConfig config) throws IOException {
        if (this.gc != null) {
            this.gc.close();
        }
        this.config = config;
        this.gc = GribCdmIndex.openCdmIndex(indexFile.toString(), config, false, logger);
        if (this.gc == null) {
            throw new IOException("Not a grib collection index file");
        }
        ArrayList<GroupBean> groups = new ArrayList<GroupBean>();
        for (GribCollection.Dataset ds : this.gc.getDatasets()) {
            for (GribCollection.GroupGC g : ds.getGroups()) {
                groups.add(new GroupBean(g, ds.getType().toString()));
            }
        }
        this.groupTable.setBeans(groups);
        this.groupTable.setHeader(indexFile.toString());
        this.gcFiles = this.gc.getFiles();
        this.varTable.clearBeans();
        this.coordTable.clearBeans();
    }

    private void setGroup(GribCollection.GroupGC group) {
        ArrayList<VarBean> vars = new ArrayList<VarBean>();
        for (GribCollection.VariableIndex v : group.getVariables()) {
            vars.add(new VarBean(v, group));
        }
        this.varTable.setBeans(vars);
        int count = 0;
        ArrayList<CoordBean> coords = new ArrayList<CoordBean>();
        for (Coordinate vc : group.getCoordinates()) {
            coords.add(new CoordBean(vc, count++));
        }
        this.coordTable.setBeans(coords);
    }

    private void showFileTable(GribCollection gc, GribCollection.GroupGC group) {
        File dir = gc.getDirectory();
        Collection<MFile> files = group == null ? gc.getFiles() : group.getFiles();
        this.fileTable.setFiles(dir, files);
    }

    public class VarBean {
        GribCollection.VariableIndex v;
        GribCollection.GroupGC group;
        String name;

        public VarBean() {
        }

        public VarBean(GribCollection.VariableIndex vindex, GribCollection.GroupGC group) {
            this.v = vindex;
            this.group = group;
            this.name = CdmIndex2Panel.this.gc.makeVariableName(vindex);
        }

        public int getNRecords() {
            return this.v.nrecords;
        }

        public int getNMissing() {
            return this.v.missing;
        }

        public int getNDups() {
            return this.v.ndups;
        }

        public float getDensity() {
            return this.v.density;
        }

        public String getIndexes() {
            Formatter f = new Formatter();
            for (int idx : this.v.getCoordinateIndex()) {
                f.format("%d,", idx);
            }
            return f.toString();
        }

        public String getIntvName() {
            return this.v.getTimeIntvName();
        }

        public int getHash() {
            return this.v.cdmHash;
        }

        public String getGroupId() {
            return this.group.getId();
        }

        public String getVariableId() {
            return this.v.discipline + "-" + this.v.category + "-" + this.v.parameter;
        }

        public String getName() {
            return this.name;
        }

        public void makeGribConfig(Formatter f) {
            f.format("<variable id='%s'/>%n", this.getVariableId());
        }

        private void showSparseArray(Formatter f) {
            int count = 0;
            Indent indent = new Indent(2);
            for (Coordinate coord : this.v.getCoordinates()) {
                f.format("%d: ", count++);
                coord.showInfo(f, indent);
            }
            f.format("%n", new Object[0]);
            if (this.v instanceof PartitionCollection.VariableIndexPartitioned) {
                PartitionCollection.VariableIndexPartitioned vip = (PartitionCollection.VariableIndexPartitioned)this.v;
                vip.show(f);
            } else {
                try {
                    this.v.readRecords();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                if (this.v.getSparseArray() != null) {
                    SparseArray<GribCollection.Record> sa = this.v.getSparseArray();
                    sa.showInfo(f, null);
                    f.format("%n", new Object[0]);
                    sa.showContent(f);
                }
            }
        }
    }

    public class CoordBean
    implements Comparable<CoordBean> {
        Coordinate coord;
        int idx;

        public CoordBean() {
        }

        public String getType() {
            if (this.coord instanceof CoordinateTime2D) {
                CoordinateTime2D c2d = (CoordinateTime2D)this.coord;
                Formatter f = new Formatter();
                f.format("%s %s", new Object[]{this.coord.getType(), c2d.isTimeInterval() ? "intv" : "offs"});
                if (c2d.isOrthogonal()) {
                    f.format(" ort", new Object[0]);
                }
                if (c2d.isRegular()) {
                    f.format(" reg", new Object[0]);
                }
                return f.toString();
            }
            return this.coord.getType().toString();
        }

        public CoordBean(Coordinate coord, int idx) {
            this.coord = coord;
            this.idx = idx;
        }

        public String getValues() {
            if (this.coord.getValues() == null) {
                return "";
            }
            Formatter f = new Formatter();
            for (Object object : this.coord.getValues()) {
                f.format("%s,", object);
            }
            return f.toString();
        }

        public String getSize() {
            if (this.coord instanceof CoordinateTime2D) {
                CoordinateTime2D c2d = (CoordinateTime2D)this.coord;
                Formatter f = new Formatter();
                f.format("%d X %d (%d)", c2d.getRuntimeCoordinate().getSize(), c2d.getNtimes(), this.coord.getSize());
                return f.toString();
            }
            return Integer.toString(this.coord.getSize());
        }

        public int getCode() {
            return this.coord.getCode();
        }

        public int getIndex() {
            return this.idx;
        }

        public String getUnit() {
            return this.coord.getUnit();
        }

        public String getName() {
            CoordinateTimeAbstract timeiCoord;
            String intvName = null;
            if (this.coord instanceof CoordinateTimeIntv) {
                timeiCoord = (CoordinateTimeIntv)this.coord;
                intvName = ((CoordinateTimeIntv)timeiCoord).getTimeIntervalName();
            }
            if (this.coord instanceof CoordinateTime2D) {
                timeiCoord = (CoordinateTime2D)this.coord;
                intvName = ((CoordinateTime2D)timeiCoord).getTimeIntervalName();
            }
            return intvName == null ? this.coord.getName() : this.coord.getName() + " (" + intvName + ")";
        }

        @Override
        public int compareTo(CoordBean o) {
            return this.getType().compareTo(o.getType());
        }

        void showCoords(Formatter f) {
            this.coord.showCoords(f);
        }
    }

    public class GroupBean {
        GribCollection.GroupGC group;
        String type;
        float density;
        float avgDensity;
        int nrecords = 0;

        public GroupBean() {
        }

        public GroupBean(GribCollection.GroupGC g, String type) {
            this.group = g;
            this.type = type;
            int nvars = 0;
            int total = 0;
            this.avgDensity = 0.0f;
            for (GribCollection.VariableIndex vi : this.group.getVariables()) {
                vi.calcTotalSize();
                total += vi.totalSize;
                this.nrecords += vi.nrecords;
                this.avgDensity += vi.density;
                ++nvars;
            }
            this.avgDensity /= (float)nvars;
            this.density = total == 0 ? 0.0f : (float)this.nrecords / (float)total;
        }

        public String getGroupId() {
            return this.group.getId();
        }

        public int getGdsHash() {
            return this.group.getGdsHash();
        }

        public int getNrecords() {
            return this.nrecords;
        }

        public String getType() {
            return this.type;
        }

        public int getNFiles() {
            return this.group.getNFiles();
        }

        public int getNCoords() {
            return this.group.getNCoords();
        }

        public int getNVariables() {
            return this.group.getNVariables();
        }

        public float getAvgDensity() {
            return this.avgDensity;
        }

        public float getDensity() {
            return this.density;
        }

        public String getDescription() {
            return this.group.getDescription();
        }
    }
}

