/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.coord.SparseArray;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.PartitionCollection;
import ucar.nc2.ui.Grib2ReportPanel;
import ucar.nc2.ui.ReportPanel;
import ucar.nc2.util.CloseableIterator;
import ucar.nc2.util.Indent;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class CdmIndexReportPanel
extends ReportPanel {
    private static final Logger logger = LoggerFactory.getLogger(Grib2ReportPanel.class);

    public CdmIndexReportPanel(PreferencesExt prefs) {
        super(prefs);
    }

    @Override
    public Object[] getOptions() {
        return Report.values();
    }

    @Override
    protected void doReport(Formatter f, Object option, MCollection dcm, boolean useIndex, boolean eachFile, boolean extra) throws IOException {
        if (eachFile) {
            HashSet<String> filenames = new HashSet<String>();
            try (CloseableIterator<MFile> iter = dcm.getFileIterator();){
                while (iter.hasNext()) {
                    switch ((Report)((Object)option)) {
                        case misplacedFlds: {
                            this.doMisplacedFieldsEach(f, (MFile)iter.next(), filenames, extra);
                        }
                    }
                }
            }
            f.format("%nAll files%n", new Object[0]);
            for (String filename : filenames) {
                f.format("  %s%n", filename);
            }
        } else {
            switch ((Report)((Object)option)) {
                case misplacedFlds: {
                    this.doMisplacedFields(f, dcm, useIndex, extra);
                }
            }
        }
    }

    private void doMisplacedFieldsEach(Formatter f2, MFile mfile, Set<String> filenames, boolean extra) throws IOException {
        Formatter f = new Formatter(System.out);
        f.format("Check Misplaced Fields for %s%n", mfile);
        HashMap<Integer, VarInfo> varCount = new HashMap<Integer, VarInfo>();
        int countMisplaced = 0;
        f.format("%n%s%n", mfile.getPath());
        this.countTop(mfile.getPath(), f, varCount);
        f.format("%nTotals%n", new Object[0]);
        ArrayList sorted = new ArrayList(varCount.values());
        Collections.sort(sorted);
        for (VarInfo vinfo : sorted) {
            f.format(" %20s = %d%n", vinfo.name, vinfo.count);
            if (vinfo.count > 400) {
                vinfo.ok = true;
            }
            if (vinfo.ok) continue;
            countMisplaced += vinfo.count;
        }
        f.format("countMisplaced = %d%n", countMisplaced);
        countMisplaced = 0;
        f.format("%nFind Misplaced Files%n", new Object[0]);
        File indexFile = new File(mfile.getPath());
        f.format("%nDone countMisplaced=%d (n < 400)%n%nFiles%n", countMisplaced += this.doOneIndex(indexFile, f, varCount, filenames, new Indent(2), extra));
        f2.format("%s", f.toString());
    }

    private void doMisplacedFields(Formatter f, MCollection dcm, boolean useIndex, boolean extra) throws IOException {
        f.format("Check Misplaced Fields%n", new Object[0]);
        HashMap<Integer, VarInfo> varCount = new HashMap<Integer, VarInfo>();
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format("%n%s%n", mfile.getPath());
            this.countTop(mfile.getPath(), f, varCount);
        }
        int countMisplaced = 0;
        f.format("%nTotals%n", new Object[0]);
        ArrayList sorted = new ArrayList(varCount.values());
        Collections.sort(sorted);
        for (VarInfo vinfo : sorted) {
            f.format(" %20s = %d%n", vinfo.name, vinfo.count);
            if (vinfo.count > 400) {
                vinfo.ok = true;
            }
            if (vinfo.ok) continue;
            countMisplaced += vinfo.count;
        }
        f.format("countMisplaced = %d%n", countMisplaced);
        HashSet<String> filenames = new HashSet<String>();
        countMisplaced = 0;
        f.format("%nFind Misplaced Files%n", new Object[0]);
        for (MFile mfile : dcm.getFilesSorted()) {
            File indexFile = new File(mfile.getPath());
            countMisplaced += this.doOneIndex(indexFile, f, varCount, filenames, new Indent(2), extra);
        }
        f.format("%nDone countMisplaced=%d (n < 400)%n%nFiles%n", countMisplaced);
        for (String filename : filenames) {
            f.format("  %s%n", filename);
        }
    }

    public void countTop(String indexFile, Formatter f, Map<Integer, VarInfo> varCount) throws IOException {
        FeatureCollectionConfig config = new FeatureCollectionConfig();
        try (GribCollection gc = GribCdmIndex.openCdmIndex(indexFile, config, false, logger);){
            if (gc == null) {
                throw new IOException(indexFile + " not a grib collection index file");
            }
            for (GribCollection.Dataset ds : gc.getDatasets()) {
                if (!ds.getType().equals((Object)GribCollection.Type.TwoD)) continue;
                for (GribCollection.GroupGC g : ds.getGroups()) {
                    f.format(" Group %s%n", g.getDescription());
                    for (GribCollection.VariableIndex vi : g.getVariables()) {
                        String name = gc.makeVariableName(vi);
                        f.format("  %7d: %s%n", vi.nrecords, name);
                        int hash = vi.cdmHash + g.getGdsHash();
                        VarInfo vinfo = varCount.get(hash);
                        if (vinfo == null) {
                            vinfo = new VarInfo(hash, name);
                            varCount.put(hash, vinfo);
                        }
                        vinfo.count += vi.nrecords;
                    }
                }
            }
        }
    }

    private int doOneIndex(File indexFile, Formatter f, Map<Integer, VarInfo> varCount, Set<String> filenames, Indent indent, boolean showScan) throws IOException {
        FeatureCollectionConfig config = new FeatureCollectionConfig();
        try (RandomAccessFile raf = new RandomAccessFile(indexFile.getPath(), "r");){
            GribCdmIndex.GribCollectionType type = GribCdmIndex.getType(raf);
            if (showScan) {
                f.format("%sIndex %s type=%s", new Object[]{indent, indexFile, type});
            }
        }
        int totalMisplaced = 0;
        File parent = indexFile.getParentFile();
        try (GribCollection gc = GribCdmIndex.openCdmIndex(indexFile.getPath(), config, false, logger);){
            VarInfo vinfo;
            int hash;
            if (gc == null) {
                throw new IOException(indexFile + " not a grib collection index file");
            }
            int countMisplaced = 0;
            for (GribCollection.Dataset ds : gc.getDatasets()) {
                if (ds.getType().equals((Object)GribCollection.Type.Best)) continue;
                for (GribCollection.GroupGC g : ds.getGroups()) {
                    for (GribCollection.VariableIndex vi : g.getVariables()) {
                        hash = vi.cdmHash + g.getGdsHash();
                        vinfo = varCount.get(hash);
                        if (vinfo == null) {
                            f.format("ERROR on vi %s%n", vi);
                            continue;
                        }
                        if (vinfo.ok) continue;
                        countMisplaced += vi.nrecords;
                    }
                }
            }
            if (countMisplaced == 0) {
                if (showScan) {
                    f.format(" none%n", new Object[0]);
                }
                int i$ = 0;
                return i$;
            }
            indent.incr();
            if (gc instanceof PartitionCollection) {
                PartitionCollection pc = (PartitionCollection)gc;
                boolean isPoP = pc.isPartitionOfPartitions();
                if (showScan) {
                    f.format(" isPofP=%s%n", isPoP);
                }
                for (PartitionCollection.Partition partition : pc.getPartitions()) {
                    File nestedIndex;
                    File partParent = new File(partition.getDirectory());
                    File reparent = new File(parent, partParent.getName());
                    File file = nestedIndex = isPoP ? new File(reparent, partition.getFilename()) : new File(parent, partition.getFilename());
                    if (showScan) {
                        f.format("%sPartition index= %s exists=%s%n", indent, nestedIndex, nestedIndex.exists());
                    }
                    if (nestedIndex.exists()) {
                        totalMisplaced += this.doOneIndex(nestedIndex, f, varCount, filenames, indent.incr(), showScan);
                        indent.decr();
                        continue;
                    }
                    f.format("%sdir=%s filename=%s nestedIndex %s NOT EXIST%n", indent, partition.getDirectory(), partition.getFilename(), nestedIndex.getPath());
                }
            } else {
                if (showScan) {
                    f.format("%n", new Object[0]);
                }
                f.format("%sIndex %s count=%d%n", indent, indexFile, countMisplaced);
                indent.incr();
                for (GribCollection.Dataset ds : gc.getDatasets()) {
                    if (ds.getType().equals((Object)GribCollection.Type.Best)) continue;
                    for (GribCollection.GroupGC g : ds.getGroups()) {
                        for (GribCollection.VariableIndex vi : g.getVariables()) {
                            hash = vi.cdmHash + g.getGdsHash();
                            vinfo = varCount.get(hash);
                            if (vinfo.ok) continue;
                            vi.readRecords();
                            if (vi.getSparseArray() == null) continue;
                            SparseArray<GribCollection.Record> sa = vi.getSparseArray();
                            for (GribCollection.Record record : sa.getContent()) {
                                String filename = gc.getFilename(record.fileno);
                                f.format(">%s%s: %s at pos %d%n", indent, vinfo.name, filename, record.pos);
                                ++totalMisplaced;
                                filenames.add(filename);
                            }
                        }
                    }
                }
                indent.decr();
            }
        }
        indent.decr();
        return totalMisplaced;
    }

    private class VarInfo
    implements Comparable<VarInfo> {
        int hash;
        String name;
        int count = 0;
        boolean ok;

        private VarInfo(int hash, String name) {
            this.hash = hash;
            this.name = name;
        }

        @Override
        public int compareTo(VarInfo o) {
            return this.name.compareTo(o.name);
        }
    }

    public static enum Report {
        misplacedFlds;

    }
}

