/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter2;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.stream.NcStreamWriter;
import ucar.nc2.ui.DatasetTreeView;
import ucar.nc2.ui.NCdumpPane;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.VariablePlot;
import ucar.nc2.ui.dialog.CompareDialog;
import ucar.nc2.ui.dialog.NetcdfOutputChooser;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.CompareNetcdf2;
import ucar.nc2.write.Nc4ChunkingStrategy;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;
import ucar.util.prefs.ui.Debug;

public class DatasetViewer
extends JPanel {
    private FileManager fileChooser;
    private PreferencesExt prefs;
    private NetcdfFile ds;
    private List<NestedTable> nestedTableList = new ArrayList<NestedTable>();
    private BeanTable attTable;
    private JPanel tablePanel;
    private JSplitPane mainSplit;
    private JComponent currentComponent;
    private DatasetTreeView datasetTree;
    private NCdumpPane dumpPane;
    private VariablePlot dataPlot;
    private TextHistoryPane infoTA;
    private StructureTable dataTable;
    private IndependentWindow infoWindow;
    private IndependentWindow dataWindow;
    private IndependentWindow plotWindow;
    private IndependentWindow dumpWindow;
    private IndependentWindow attWindow;
    private boolean eventsOK = true;
    NetcdfOutputChooser outChooser;
    private CompareDialog dialog = null;

    public DatasetViewer(PreferencesExt prefs, FileManager fileChooser) {
        this.prefs = prefs;
        this.fileChooser = fileChooser;
        this.tablePanel = new JPanel(new BorderLayout());
        this.setNestedTable(0, null);
        this.datasetTree = new DatasetTreeView();
        this.datasetTree.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Selection")) {
                    DatasetViewer.this.setSelected((Variable)e.getNewValue());
                }
            }
        });
        this.mainSplit = new JSplitPane(1, false, this.datasetTree, this.tablePanel);
        this.mainSplit.setDividerLocation(prefs.getInt("mainSplit", 100));
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainSplit, "Center");
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Variable Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.dataTable = new StructureTable((PreferencesExt)prefs.node("structTable"));
        this.dataWindow = new IndependentWindow("Data Table", BAMutil.getImage("netcdfUI"), this.dataTable);
        this.dataWindow.setBounds((Rectangle)prefs.getBean("dataWindow", new Rectangle(50, 300, 1000, 600)));
        this.dumpPane = new NCdumpPane((PreferencesExt)prefs.node("dumpPane"));
        this.dumpWindow = new IndependentWindow("NCDump Variable Data", BAMutil.getImage("netcdfUI"), this.dumpPane);
        this.dumpWindow.setBounds((Rectangle)prefs.getBean("DumpWindowBounds", new Rectangle(300, 300, 300, 200)));
        this.dataPlot = new VariablePlot((PreferencesExt)prefs.node("plotPane"));
        this.plotWindow = new IndependentWindow("Plot Variable Data", BAMutil.getImage("netcdfUI"), this.dataPlot);
        this.plotWindow.setBounds((Rectangle)prefs.getBean("PlotWindowBounds", new Rectangle(300, 300, 300, 200)));
    }

    public void addActions(JPanel buttPanel) {
        AbstractAction netcdfAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DatasetViewer.this.ds == null) {
                    return;
                }
                if (DatasetViewer.this.outChooser == null) {
                    DatasetViewer.this.outChooser = new NetcdfOutputChooser((Frame)null);
                    DatasetViewer.this.outChooser.addPropertyChangeListener("OK", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            DatasetViewer.this.writeNetcdf((NetcdfOutputChooser.Data)evt.getNewValue());
                        }
                    });
                }
                DatasetViewer.this.outChooser.setOutputFilename(DatasetViewer.this.ds.getLocation());
                DatasetViewer.this.outChooser.setVisible(true);
            }
        };
        BAMutil.setActionProperties(netcdfAction, "netcdf", "Write netCDF file", false, 83, -1);
        BAMutil.addActionToContainer(buttPanel, netcdfAction);
        AbstractButton compareButton = BAMutil.makeButtcon("Select", "Compare to another file", false);
        compareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetViewer.this.compareDataset();
            }
        });
        buttPanel.add(compareButton);
        AbstractAction attAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetViewer.this.showAtts();
            }
        };
        BAMutil.setActionProperties(attAction, "FontDecr", "global attributes", false, 65, -1);
        BAMutil.addActionToContainer(buttPanel, attAction);
    }

    void writeNetcdf(NetcdfOutputChooser.Data data) {
        if (data.version == NetcdfFileWriter.Version.ncstream) {
            this.writeNcstream(data.outputFilename);
            return;
        }
        try {
            FileWriter2 writer = new FileWriter2(this.ds, data.outputFilename, data.version, Nc4ChunkingStrategy.factory(data.chunkerType, data.deflate, data.shuffle));
            NetcdfFile result = writer.write();
            result.close();
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    void writeNcstream(String filename) {
        try {
            NcStreamWriter writer = new NcStreamWriter(this.ds, null);
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(filename), 50000);
            writer.streamAll(fos);
            ((OutputStream)fos).close();
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    void writeNcstreamHeader(String filename) {
        try {
            NcStreamWriter writer = new NcStreamWriter(this.ds, null);
            FileOutputStream fos = new FileOutputStream(filename);
            writer.sendHeader(fos);
            fos.close();
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    public void compareDataset() {
        if (this.ds == null) {
            return;
        }
        if (this.dialog == null) {
            this.dialog = new CompareDialog(null, this.fileChooser);
            this.dialog.pack();
            this.dialog.addPropertyChangeListener("OK", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CompareDialog.Data data = (CompareDialog.Data)evt.getNewValue();
                    DatasetViewer.this.compareDataset(data);
                }
            });
        }
        this.dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareDataset(CompareDialog.Data data) {
        if (data.name == null) {
            return;
        }
        NetcdfFile compareFile = null;
        try {
            compareFile = NetcdfDataset.openFile(data.name, null);
            Formatter f = new Formatter();
            CompareNetcdf2 cn = new CompareNetcdf2(f, data.showCompare, data.showDetails, data.readData);
            if (data.howMuch == CompareDialog.HowMuch.All) {
                cn.compare(this.ds, compareFile);
            } else {
                NestedTable nested = this.nestedTableList.get(0);
                Variable org = this.getCurrentVariable(nested.table);
                if (org == null) {
                    return;
                }
                Variable ov = compareFile.findVariable(org.getFullNameEscaped());
                if (ov != null) {
                    cn.compareVariable(org, ov);
                }
            }
            this.infoTA.setText(f.toString());
            this.infoTA.gotoTop();
            this.infoWindow.setTitle("Compare");
            this.infoWindow.show();
        }
        catch (Throwable ioe) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            ioe.printStackTrace(new PrintStream(bos));
            this.infoTA.setText(bos.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
        }
        finally {
            if (compareFile != null) {
                try {
                    compareFile.close();
                }
                catch (Exception eek) {}
            }
        }
    }

    public void showAtts() {
        if (this.ds == null) {
            return;
        }
        if (this.attTable == null) {
            this.attTable = new BeanTable(AttributeBean.class, (PreferencesExt)this.prefs.node("AttributeBeans"), false);
            PopupMenu varPopup = new PopupMenu(this.attTable.getJTable(), "Options");
            varPopup.addAction("Show Attribute", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeBean bean = (AttributeBean)DatasetViewer.this.attTable.getSelectedBean();
                    if (bean != null) {
                        DatasetViewer.this.infoTA.setText(bean.att.toString());
                        DatasetViewer.this.infoTA.gotoTop();
                        DatasetViewer.this.infoWindow.show();
                    }
                }
            });
            this.attWindow = new IndependentWindow("Global Attributes", BAMutil.getImage("netcdfUI"), this.attTable);
            this.attWindow.setBounds((Rectangle)this.prefs.getBean("AttWindowBounds", new Rectangle(300, 100, 500, 800)));
        }
        ArrayList<AttributeBean> attlist = new ArrayList<AttributeBean>();
        for (Attribute att : this.ds.getGlobalAttributes()) {
            attlist.add(new AttributeBean(att));
        }
        this.attTable.setBeans(attlist);
        this.attWindow.show();
    }

    public NetcdfFile getDataset() {
        return this.ds;
    }

    public void clear() {
        this.ds = null;
        if (this.attTable != null) {
            this.attTable.clearBeans();
        }
        for (NestedTable nt : this.nestedTableList) {
            nt.table.clearBeans();
        }
        this.datasetTree.clear();
    }

    public void setDataset(NetcdfFile ds) {
        this.ds = ds;
        NestedTable nt = this.nestedTableList.get(0);
        nt.table.setBeans(this.getVariableBeans(ds));
        this.hideNestedTable(1);
        this.datasetTree.setFile(ds);
    }

    private void setSelected(Variable v) {
        this.eventsOK = false;
        ArrayList<Variable> vchain = new ArrayList<Variable>();
        vchain.add(v);
        Variable vp = v;
        while (vp.isMemberOfStructure()) {
            vp = vp.getParentStructure();
            vchain.add(0, vp);
        }
        for (int i = 0; i < vchain.size(); ++i) {
            vp = (Variable)vchain.get(i);
            NestedTable ntable = this.setNestedTable(i, vp.getParentStructure());
            ntable.setSelected(vp);
        }
        this.eventsOK = true;
    }

    private NestedTable setNestedTable(int level, Structure s) {
        NestedTable ntable;
        if (this.nestedTableList.size() < level + 1) {
            ntable = new NestedTable(level);
            this.nestedTableList.add(ntable);
        } else {
            ntable = this.nestedTableList.get(level);
        }
        if (s != null) {
            ntable.table.setBeans(this.getStructureVariables(s));
        }
        ntable.show();
        return ntable;
    }

    private void hideNestedTable(int level) {
        int n = this.nestedTableList.size();
        for (int i = n - 1; i >= level; --i) {
            NestedTable ntable = this.nestedTableList.get(i);
            ntable.hide();
        }
    }

    private void showDeclaration(BeanTable from, boolean isNcml) {
        Variable v = this.getCurrentVariable(from);
        if (v == null) {
            return;
        }
        this.infoTA.clear();
        if (isNcml) {
            Formatter out = new Formatter();
            try {
                NCdumpW.writeNcMLVariable(v, out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.infoTA.appendLine(out.toString());
        } else {
            this.infoTA.appendLine(v.toString());
        }
        if (Debug.isSet("Xdeveloper")) {
            this.infoTA.appendLine("\n");
            this.infoTA.appendLine("FULL NAME = " + v.getFullName());
            this.infoTA.appendLine("\n");
            this.infoTA.appendLine(v.toStringDebug());
        }
        this.infoTA.gotoTop();
        this.infoWindow.setTitle("Variable Info");
        this.infoWindow.show();
    }

    private void dumpData(BeanTable from) {
        Variable v = this.getCurrentVariable(from);
        if (v == null) {
            return;
        }
        this.dumpPane.clear();
        try {
            String spec = ParsedSectionSpec.makeSectionSpecString(v, null);
            this.dumpPane.setContext(this.ds, spec);
        }
        catch (Exception ex) {
            StringWriter s = new StringWriter();
            ex.printStackTrace(new PrintWriter(s));
            this.dumpPane.setText(s.toString());
        }
        this.dumpWindow.show();
    }

    private void dataTable(BeanTable from) {
        VariableBean vb = (VariableBean)from.getSelectedBean();
        if (vb == null) {
            return;
        }
        Variable v = vb.vs;
        if (v instanceof Structure) {
            try {
                this.dataTable.setStructure((Structure)v);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(this, "Variable '" + v.getShortName() + "' not a Structure");
            return;
        }
        this.dataWindow.show();
    }

    private void dataPlot(BeanTable from) {
        this.dataPlot.clear();
        List l = from.getSelectedBeans();
        for (VariableBean vb : l) {
            if (vb == null) {
                return;
            }
            Variable v = vb.vs;
            if (v != null) {
                try {
                    this.dataPlot.setDataset(this.ds);
                    this.dataPlot.setVariable(v);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            return;
        }
        this.plotWindow.show();
    }

    private Variable getCurrentVariable(BeanTable from) {
        VariableBean vb = (VariableBean)from.getSelectedBean();
        if (vb == null) {
            return null;
        }
        return vb.vs;
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.dumpPane.save();
        for (NestedTable nt : this.nestedTableList) {
            nt.saveState();
        }
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putBeanObject("DumpWindowBounds", this.dumpWindow.getBounds());
        this.prefs.putBeanObject("PlotWindowBounds", this.plotWindow.getBounds());
        if (this.attWindow != null) {
            this.prefs.putBeanObject("AttWindowBounds", this.attWindow.getBounds());
        }
        this.prefs.putInt("mainSplit", this.mainSplit.getDividerLocation());
    }

    public List<VariableBean> getVariableBeans(NetcdfFile ds) {
        ArrayList<VariableBean> vlist = new ArrayList<VariableBean>();
        for (Variable v : ds.getVariables()) {
            vlist.add(new VariableBean(v));
        }
        return vlist;
    }

    public List<VariableBean> getStructureVariables(Structure s) {
        ArrayList<VariableBean> vlist = new ArrayList<VariableBean>();
        for (Variable v : s.getVariables()) {
            vlist.add(new VariableBean(v));
        }
        return vlist;
    }

    public class AttributeBean {
        private Attribute att;

        public AttributeBean() {
        }

        public AttributeBean(Attribute att) {
            this.att = att;
        }

        public String getName() {
            return this.att.getShortName();
        }

        public String getValue() {
            Array value = this.att.getValues();
            return NCdumpW.printArray(value, null, null);
        }
    }

    public class VariableBean {
        private Variable vs;
        private String name;
        private String dimensions;
        private String desc;
        private String units;
        private String dataType;
        private String shape;
        private String coordSys;

        public VariableBean() {
        }

        public VariableBean(Variable vs) {
            this.vs = vs;
            this.setName(vs.getShortName());
            this.setDescription(vs.getDescription());
            this.setUnits(vs.getUnitsString());
            this.setDataType(vs.getDataType().toString());
            StringBuilder lens = new StringBuilder();
            StringBuilder names = new StringBuilder();
            List<Dimension> dims = vs.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                if (j > 0) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getShortName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
            }
            this.setDimensions(names.toString());
            this.setShape(lens.toString());
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGroup() {
            return this.vs.getParentGroup().getFullName();
        }

        public String getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(String dimensions) {
            this.dimensions = dimensions;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }
    }

    private class NestedTable {
        int level;
        PreferencesExt myPrefs;
        BeanTable table;
        JSplitPane split = null;
        int splitPos = 100;
        boolean isShowing = false;

        NestedTable(int level) {
            this.level = level;
            this.myPrefs = (PreferencesExt)DatasetViewer.this.prefs.node("NestedTable" + level);
            this.table = new BeanTable(VariableBean.class, this.myPrefs, false);
            JTable jtable = this.table.getJTable();
            PopupMenu csPopup = new PopupMenu(jtable, "Options");
            csPopup.addAction("Show Declaration", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetViewer.this.showDeclaration(NestedTable.this.table, false);
                }
            });
            csPopup.addAction("Show NcML", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetViewer.this.showDeclaration(NestedTable.this.table, true);
                }
            });
            csPopup.addAction("NCdump Data", "Dump", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetViewer.this.dumpData(NestedTable.this.table);
                }
            });
            if (level == 0) {
                csPopup.addAction("Data Table", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DatasetViewer.this.dataTable(NestedTable.this.table);
                    }
                });
                csPopup.addAction("Data Plot", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DatasetViewer.this.dataPlot(NestedTable.this.table);
                    }
                });
            }
            this.table.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    Variable v = DatasetViewer.this.getCurrentVariable(NestedTable.this.table);
                    if (v != null && v instanceof Structure) {
                        DatasetViewer.this.hideNestedTable(NestedTable.this.level + 2);
                        DatasetViewer.this.setNestedTable(NestedTable.this.level + 1, (Structure)v);
                    } else {
                        DatasetViewer.this.hideNestedTable(NestedTable.this.level + 1);
                    }
                    if (DatasetViewer.this.eventsOK) {
                        DatasetViewer.this.datasetTree.setSelected(v);
                    }
                }
            });
            if (DatasetViewer.this.currentComponent == null) {
                DatasetViewer.this.currentComponent = this.table;
                DatasetViewer.this.tablePanel.add((Component)DatasetViewer.this.currentComponent, "Center");
                this.isShowing = true;
            } else {
                this.split = new JSplitPane(0, false, DatasetViewer.this.currentComponent, this.table);
                this.splitPos = this.myPrefs.getInt("splitPos" + level, 500);
                if (this.splitPos > 0) {
                    this.split.setDividerLocation(this.splitPos);
                }
                this.show();
            }
        }

        void show() {
            if (this.isShowing) {
                return;
            }
            DatasetViewer.this.tablePanel.remove(DatasetViewer.this.currentComponent);
            this.split.setLeftComponent(DatasetViewer.this.currentComponent);
            this.split.setDividerLocation(this.splitPos);
            DatasetViewer.this.currentComponent = this.split;
            DatasetViewer.this.tablePanel.add((Component)DatasetViewer.this.currentComponent, "Center");
            DatasetViewer.this.tablePanel.revalidate();
            this.isShowing = true;
        }

        void hide() {
            if (!this.isShowing) {
                return;
            }
            DatasetViewer.this.tablePanel.remove(DatasetViewer.this.currentComponent);
            if (this.split != null) {
                this.splitPos = this.split.getDividerLocation();
                DatasetViewer.this.currentComponent = (JComponent)this.split.getLeftComponent();
                DatasetViewer.this.tablePanel.add((Component)DatasetViewer.this.currentComponent, "Center");
            }
            DatasetViewer.this.tablePanel.revalidate();
            this.isShowing = false;
        }

        void setSelected(Variable vs) {
            List beans = this.table.getBeans();
            for (Object bean1 : beans) {
                VariableBean bean = (VariableBean)bean1;
                if (bean.vs != vs) continue;
                this.table.setSelectedBean(bean);
                return;
            }
        }

        void saveState() {
            this.table.saveState(false);
            if (this.split != null) {
                this.myPrefs.putInt("splitPos" + this.level, this.split.getDividerLocation());
            }
        }
    }
}

