/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.GribVariableRenamer;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionBinaryData;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1ParamTableReader;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.ui.ReportPanel;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Grib1ReportPanel
extends ReportPanel {
    public Grib1ReportPanel(PreferencesExt prefs) {
        super(prefs);
    }

    @Override
    public Object[] getOptions() {
        return Report.values();
    }

    @Override
    protected void doReport(Formatter f, Object option, MCollection dcm, boolean useIndex, boolean eachFile, boolean extra) throws IOException {
        switch ((Report)((Object)option)) {
            case checkTables: {
                this.doCheckTables(f, dcm, useIndex);
                break;
            }
            case showLocalParams: {
                this.doCheckLocalParams(f, dcm, useIndex);
                break;
            }
            case scanIssues: {
                this.doScanIssues(f, dcm, useIndex);
                break;
            }
            case rename: {
                this.doRename(f, dcm, useIndex);
                break;
            }
            case checkRename: {
                this.doCheckRename(f, dcm, useIndex);
                break;
            }
            case showEncoding: {
                this.doShowEncoding(f, dcm, useIndex);
            }
        }
    }

    private void doCheckLocalParams(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("Check Grib-1 Parameter Tables for local entries%n", new Object[0]);
        int[] accum = new int[4];
        for (MFile mfile : dcm.getFilesSorted()) {
            String path = mfile.getPath();
            if (path.endsWith(".gbx8") || path.endsWith(".gbx9") || path.endsWith(".ncx")) continue;
            f.format("%n %s%n", path);
            try {
                this.doCheckLocalParams(mfile, f, accum);
            }
            catch (Throwable t) {
                System.out.printf("FAIL on %s%n", mfile.getPath());
                t.printStackTrace();
            }
        }
        f.format("%nGrand total=%d local = %d missing = %d%n", accum[0], accum[2], accum[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckLocalParams(MFile ff, Formatter fm, int[] accum) throws IOException {
        int local = 0;
        int miss = 0;
        int nonop = 0;
        int total = 0;
        try (GridDataset ncfile = null;){
            ncfile = GridDataset.open(ff.getPath());
            Attribute gatt = ncfile.findGlobalAttributeIgnoreCase("GRIB table");
            if (gatt != null) {
                String[] s = gatt.getStringValue().split("-");
                Grib1ParamTableReader gtable = new Grib1ParamTables().getParameterTable(Integer.parseInt(s[0]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
                fm.format("  %s == %s%n", gatt, gtable.getPath());
            }
            for (GridDatatype dt : ncfile.getGrids()) {
                String currName = dt.getName();
                ++total;
                Attribute att = dt.findAttributeIgnoreCase("Grib_Parameter");
                int number = att == null ? 0 : att.getNumericValue().intValue();
                if (number < 128) continue;
                fm.format("  local parameter = %s (%d) units=%s %n", currName, number, dt.getUnitsString());
                ++local;
                if (!currName.startsWith("VAR")) continue;
                ++miss;
            }
        }
        fm.format("total=%d local = %d miss=%d %n", total, local, miss);
        accum[0] = accum[0] + total;
        accum[1] = accum[1] + nonop;
        accum[2] = accum[2] + local;
        accum[3] = accum[3] + miss;
    }

    private void doCheckTables(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        ReportPanel.CounterS tableSet = new ReportPanel.CounterS(this, "tableVersion");
        ReportPanel.Counter local = new ReportPanel.Counter(this, "local");
        ReportPanel.Counter missing = new ReportPanel.Counter(this, "missing");
        for (MFile mfile : dcm.getFilesSorted()) {
            String path = mfile.getPath();
            if (path.endsWith(".gbx8") || path.endsWith(".gbx9") || path.endsWith(".ncx")) continue;
            f.format(" %s%n", path);
            this.doCheckTables(f, mfile, useIndex, tableSet, local, missing);
        }
        f.format("Check Parameter Tables%n", new Object[0]);
        tableSet.show(f);
        local.show(f);
        missing.show(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckTables(Formatter fm, MFile ff, boolean useIndex, ReportPanel.CounterS tableSet, ReportPanel.Counter local, ReportPanel.Counter missing) throws IOException {
        String path = ff.getPath();
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(path, "r");
            raf.order(0);
            raf.seek(0L);
            Grib1RecordScanner reader = new Grib1RecordScanner(raf);
            while (reader.hasNext()) {
                Grib1ParamTableReader table;
                Grib1Record gr = reader.next();
                Grib1SectionProductDefinition pds = gr.getPDSsection();
                String key = pds.getCenter() + "-" + pds.getSubCenter() + "-" + pds.getTableVersion();
                tableSet.count(key);
                if (pds.getParameterNumber() > 127) {
                    local.count(pds.getParameterNumber());
                }
                if ((table = new Grib1ParamTables().getParameterTable(pds.getCenter(), pds.getSubCenter(), pds.getTableVersion())) == null && useIndex) {
                    table = Grib1ParamTables.getDefaultTable();
                }
                if (table != null && null != table.getParameter(pds.getParameterNumber())) continue;
                missing.count(pds.getParameterNumber());
            }
        }
    }

    private void doScanIssues(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        ReportPanel.Counter predefinedA = new ReportPanel.Counter(this, "predefined");
        ReportPanel.Counter thinA = new ReportPanel.Counter(this, "thin");
        ReportPanel.Counter timeUnitA = new ReportPanel.Counter(this, "timeUnit");
        ReportPanel.Counter vertCoordA = new ReportPanel.Counter(this, "vertCoord");
        ReportPanel.Counter vertCoordInGDSA = new ReportPanel.Counter(this, "vertCoordInGDS");
        for (MFile mfile : dcm.getFilesSorted()) {
            ReportPanel.Counter predefined = new ReportPanel.Counter(this, "predefined");
            ReportPanel.Counter thin = new ReportPanel.Counter(this, "thin");
            ReportPanel.Counter timeUnit = new ReportPanel.Counter(this, "timeUnit");
            ReportPanel.Counter vertCoord = new ReportPanel.Counter(this, "vertCoord");
            ReportPanel.Counter vertCoordInGDS = new ReportPanel.Counter(this, "vertCoordInGDS");
            String path = mfile.getPath();
            if (path.endsWith(".gbx8") || path.endsWith(".gbx9") || path.endsWith(".ncx")) continue;
            f.format(" %s%n", path);
            this.doScanIssues(f, mfile, useIndex, predefined, thin, timeUnit, vertCoord, vertCoordInGDS);
            predefined.show(f);
            thin.show(f);
            timeUnit.show(f);
            vertCoord.show(f);
            vertCoordInGDS.show(f);
            predefinedA.add(predefined);
            thinA.add(thin);
            timeUnitA.add(timeUnit);
            vertCoordA.add(vertCoord);
            vertCoordInGDSA.add(vertCoordInGDS);
        }
        f.format("SUMMARY ALL%n", new Object[0]);
        predefinedA.show(f);
        thinA.show(f);
        timeUnitA.show(f);
        vertCoordA.show(f);
        vertCoordInGDSA.show(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doScanIssues(Formatter fm, MFile ff, boolean useIndex, ReportPanel.Counter predefined, ReportPanel.Counter thin, ReportPanel.Counter timeUnit, ReportPanel.Counter vertCoord, ReportPanel.Counter vertCoordInGDS) throws IOException {
        boolean showThin = true;
        boolean showPredefined = true;
        boolean showVert = true;
        String path = ff.getPath();
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(path, "r");
            raf.order(0);
            raf.seek(0L);
            Grib1RecordScanner reader = new Grib1RecordScanner(raf);
            while (reader.hasNext()) {
                Grib1Record gr = reader.next();
                Grib1SectionGridDefinition gdss = gr.getGDSsection();
                Grib1SectionProductDefinition pds = gr.getPDSsection();
                String key = pds.getCenter() + "-" + pds.getSubCenter() + "-" + pds.getTableVersion();
                timeUnit.count(pds.getTimeRangeIndicator());
                vertCoord.count(pds.getLevelType());
                if (gdss.isThin()) {
                    if (showThin) {
                        fm.format("  THIN= (gds=%d) %s%n", gdss.getGridTemplate(), ff.getPath());
                    }
                    thin.count(gdss.getGridTemplate());
                    showThin = false;
                }
                if (!pds.gdsExists()) {
                    if (showPredefined) {
                        fm.format("   PREDEFINED GDS= %s%n", ff.getPath());
                    }
                    predefined.count(gdss.getPredefinedGridDefinition());
                    showPredefined = false;
                }
                if (!gdss.hasVerticalCoordinateParameters()) continue;
                if (showVert) {
                    fm.format("   Has vertical coordinates in GDS= %s%n", ff.getPath());
                }
                vertCoordInGDS.count(pds.getLevelType());
                showVert = false;
            }
        }
    }

    private void doShowEncoding(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        ReportPanel.Counter decimals = new ReportPanel.Counter(this, "decimalScale");
        ReportPanel.Counter nbits = new ReportPanel.Counter(this, "nbits");
        ReportPanel.Counter refVal = new ReportPanel.Counter(this, "refVal");
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format(" %s%n", mfile.getPath());
            this.doShowEncoding(f, mfile, decimals, nbits, refVal);
        }
        decimals.show(f);
        nbits.show(f);
        refVal.show(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doShowEncoding(Formatter fm, MFile ff, ReportPanel.Counter decimals, ReportPanel.Counter nbits, ReportPanel.Counter refVal) throws IOException {
        String path = ff.getPath();
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(path, "r");
            raf.order(0);
            raf.seek(0L);
            Grib1RecordScanner reader = new Grib1RecordScanner(raf);
            while (reader.hasNext()) {
                Grib1Record gr = reader.next();
                Grib1SectionProductDefinition pds = gr.getPDSsection();
                decimals.count(pds.getDecimalScale());
                double scale = Math.pow(10.0, pds.getDecimalScale());
                Grib1SectionBinaryData data = gr.getDataSection();
                nbits.count(data.getNBits(raf));
                refVal.count((int)(scale * (double)data.getRefValue(raf)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckRename(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("CHECK Renaming uniqueness %s%n", dcm.getCollectionName());
        GribVariableRenamer renamer = new GribVariableRenamer();
        int fail = 0;
        int multiple = 0;
        int ok = 0;
        for (MFile mfile : dcm.getFilesSorted()) {
            f.format("%n%s%n", mfile.getPath());
            NetcdfFile ncfileOld = null;
            GridDataset gdsNew = null;
            try {
                ncfileOld = NetcdfFile.open(mfile.getPath(), "ucar.nc2.iosp.grib.GribServiceProvider", -1, null, null);
                NetcdfDataset ncdOld = new NetcdfDataset(ncfileOld);
                GridDataset gridOld = new GridDataset(ncdOld);
                gdsNew = GridDataset.open(mfile.getPath());
                for (GridDatatype grid : gridOld.getGrids()) {
                    List<String> newNames = renamer.matchNcepNames(gdsNew, grid.getShortName());
                    if (newNames.size() == 0) {
                        f.format(" ***FAIL %s%n", grid.getShortName());
                        ++fail;
                        continue;
                    }
                    if (newNames.size() != 1) {
                        f.format(" *** %s multiple matches on %n", grid.getShortName());
                        for (String newName : newNames) {
                            f.format("    %s%n", newName);
                        }
                        f.format("%n", new Object[0]);
                        ++multiple;
                        continue;
                    }
                    if (!useIndex) continue;
                    f.format(" %s%n %s%n%n", grid.getShortName(), newNames.get(0));
                    ++ok;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                if (ncfileOld != null) {
                    ncfileOld.close();
                }
                if (gdsNew == null) continue;
                gdsNew.close();
            }
        }
        f.format("Fail=%d multiple=%d ok=%d%n", fail, multiple, ok);
    }

    private void doRename(Formatter f, MCollection dcm, boolean useIndex) throws IOException {
        f.format("CHECK Grib-1 Names: Old vs New for collection %s%n", dcm.getCollectionName());
        ArrayList<VarName> varNames = new ArrayList<VarName>(3000);
        HashMap gridsAll = new HashMap(1000);
        for (MFile mfile : dcm.getFilesSorted()) {
            GridMatch match;
            f.format("%n%s%n", mfile.getPath());
            Map<Integer, GridMatch> gridsNew = this.getGridsNew(mfile, f);
            Map<Integer, GridMatch> gridsOld = this.getGridsOld(mfile, f);
            for (GridMatch gm : gridsNew.values()) {
                match = gridsOld.get(gm.hashCode());
                if (match == null) continue;
                gm.match = match;
                match.match = gm;
            }
            for (GridMatch gm : gridsNew.values()) {
                if (gm.match != null || (match = this.altMatch(gm, gridsOld.values())) == null) continue;
                gm.match = match;
                match.match = gm;
            }
            f.format("%n", new Object[0]);
            ArrayList<GridMatch> listNew = new ArrayList<GridMatch>(gridsNew.values());
            Collections.sort(listNew);
            for (GridMatch gm : listNew) {
                f.format(" %s%n", gm.grid.getFullName());
                if (gm.match != null) {
                    f.format(" %s%n", gm.match.grid.getFullName());
                }
                f.format("%n", new Object[0]);
            }
            f.format("%nMISSING MATCHES IN NEW%n", new Object[0]);
            ArrayList<GridMatch> list = new ArrayList<GridMatch>(gridsNew.values());
            Collections.sort(list);
            for (GridMatch gm : list) {
                if (gm.match != null) continue;
                f.format(" %s (%s) == %s%n", gm.grid.getFullName(), gm.show(), gm.grid.getDescription());
            }
            f.format("%nMISSING MATCHES IN OLD%n", new Object[0]);
            ArrayList<GridMatch> listOld = new ArrayList<GridMatch>(gridsOld.values());
            Collections.sort(listOld);
            for (GridMatch gm : listOld) {
                if (gm.match != null) continue;
                f.format(" %s (%s)%n", gm.grid.getFullName(), gm.show());
            }
            for (GridMatch gmOld : listOld) {
                String keyNew;
                String key = gmOld.grid.getFullName();
                ArrayList<String> newGrids = (ArrayList<String>)gridsAll.get(key);
                if (newGrids == null) {
                    newGrids = new ArrayList<String>();
                    gridsAll.put(key, newGrids);
                }
                if (gmOld.match == null || newGrids.contains(keyNew = gmOld.match.grid.getFullName() + " == " + gmOld.match.grid.getDescription())) continue;
                newGrids.add(keyNew);
            }
            for (GridMatch gmOld : listOld) {
                if (gmOld.match == null) {
                    f.format("MISSING %s (%s)%n", gmOld.grid.getFullName(), gmOld.show());
                    continue;
                }
                Attribute att = gmOld.match.grid.findAttributeIgnoreCase("Grib_Variable_Id");
                String varId = att == null ? "" : att.getStringValue();
                varNames.add(new VarName(mfile.getName(), gmOld.grid.getShortName(), gmOld.match.grid.getShortName(), varId));
            }
        }
        f.format("%nOLD -> NEW MAPPINGS%n", new Object[0]);
        ArrayList keys = new ArrayList(gridsAll.keySet());
        int total = keys.size();
        int dups = 0;
        Collections.sort(keys);
        for (String key : keys) {
            f.format(" OLD %s%n", key);
            List newGrids = (List)gridsAll.get(key);
            Collections.sort(newGrids);
            if (newGrids.size() > 1) {
                ++dups;
            }
            for (String newKey : newGrids) {
                f.format(" NEW %s%n", newKey);
            }
            f.format("%n", new Object[0]);
        }
        f.format("Number with more than one map=%d total=%d%n", dups, total);
        if (!useIndex) {
            Element rootElem = new Element("gribVarMap");
            Document doc = new Document(rootElem);
            rootElem.setAttribute("collection", dcm.getCollectionName());
            String currentDs = null;
            Element dsElem = null;
            for (VarName vn : varNames) {
                if (!vn.dataset.equals(currentDs)) {
                    dsElem = new Element("dataset");
                    rootElem.addContent(dsElem);
                    dsElem.setAttribute("name", vn.dataset);
                    currentDs = vn.dataset;
                }
                Element param = new Element("param");
                dsElem.addContent(param);
                param.setAttribute("oldName", vn.oldVar);
                param.setAttribute("newName", vn.newVar);
                param.setAttribute("varId", vn.varId);
            }
            FileOutputStream fout = new FileOutputStream("C:/tmp/grib1VarMap.xml");
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            fmt.output(doc, (OutputStream)fout);
            fout.close();
        }
    }

    private GridMatch altMatch(GridMatch want, Collection<GridMatch> test) {
        for (GridMatch gm : test) {
            if (gm.match != null || !gm.altMatch(want)) continue;
            return gm;
        }
        for (GridMatch gm : test) {
            if (gm.match != null || !gm.altMatchNoProb(want)) continue;
            return gm;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, GridMatch> getGridsNew(MFile ff, Formatter f) throws IOException {
        HashMap<Integer, GridMatch> grids = new HashMap<Integer, GridMatch>(100);
        try (GridDataset ncfile = null;){
            ncfile = GridDataset.open(ff.getPath());
            for (GridDatatype dt : ncfile.getGrids()) {
                GridMatch gm = new GridMatch(ncfile, dt, true);
                GridMatch dup = (GridMatch)grids.get(gm.hashCode());
                if (dup != null) {
                    f.format(" DUP NEW (%d == %d) = %s (%s) and DUP %s (%s)%n", gm.hashCode(), dup.hashCode(), gm.grid.getFullName(), gm.show(), dup.grid.getFullName(), dup.show());
                    continue;
                }
                grids.put(gm.hashCode(), gm);
            }
        }
        return grids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, GridMatch> getGridsOld(MFile ff, Formatter f) throws IOException {
        HashMap<Integer, GridMatch> grids = new HashMap<Integer, GridMatch>(100);
        try (NetcdfFile ncfile = null;){
            ncfile = NetcdfFile.open(ff.getPath(), "ucar.nc2.iosp.grib.GribServiceProvider", -1, null, null);
            NetcdfDataset ncd = new NetcdfDataset(ncfile);
            GridDataset grid = new GridDataset(ncd);
            for (GridDatatype dt : grid.getGrids()) {
                GridMatch gm = new GridMatch(grid, dt, false);
                GridMatch dup = (GridMatch)grids.get(gm.hashCode());
                if (dup != null) {
                    f.format(" DUP OLD (%d == %d) = %s (%s) and DUP %s (%s)%n", gm.hashCode(), dup.hashCode(), gm.grid.getFullName(), gm.show(), dup.grid.getFullName(), dup.show());
                    continue;
                }
                grids.put(gm.hashCode(), gm);
            }
        }
        return grids;
    }

    private class GridMatch
    implements Comparable<GridMatch> {
        GridDatatype grid;
        GridMatch match;
        boolean isNew;
        int[] param = new int[3];
        int level;
        boolean isLayer;
        boolean isError;
        int interval = -1;
        int prob = -1;
        int ens = -1;
        int probLimit;

        private GridMatch(GridDataset gds, GridDatatype grid, boolean aNew) {
            this.grid = grid;
            this.isNew = aNew;
            GridCoordSystem gcs = grid.getCoordinateSystem();
            CoordinateAxis1D zaxis = gcs.getVerticalAxis();
            if (zaxis != null) {
                this.isLayer = zaxis.isInterval();
            }
            if (this.isNew) {
                int intv;
                Attribute att = grid.findAttributeIgnoreCase("Grib1_Center");
                this.param[0] = att.getNumericValue().intValue();
                att = grid.findAttributeIgnoreCase("Grib1_Subcenter");
                this.param[1] = att.getNumericValue().intValue();
                att = grid.findAttributeIgnoreCase("Grib1_Parameter");
                this.param[2] = att.getNumericValue().intValue();
                att = grid.findAttributeIgnoreCase("Grib1_Level_Type");
                this.level = att.getNumericValue().intValue();
                this.isError = grid.getName().contains("error");
                att = grid.findAttributeIgnoreCase("Grib1_Statistical_Interval_Type");
                if (att != null && (intv = att.getNumericValue().intValue()) != 255) {
                    this.interval = intv;
                }
                if ((att = grid.findAttributeIgnoreCase("Grib1_Probability_Type")) != null) {
                    this.prob = att.getNumericValue().intValue();
                }
                if ((att = grid.findAttributeIgnoreCase("Grib1_Probability_Name")) != null) {
                    String pname = att.getStringValue();
                    int pos = pname.indexOf(95);
                    pname = pname.substring(pos + 1);
                    this.probLimit = (int)(1000.0 * Double.parseDouble(pname));
                }
                if ((att = grid.findAttributeIgnoreCase("Grib1_Ensemble_Derived_Type")) != null) {
                    this.ens = att.getNumericValue().intValue();
                }
            } else {
                Attribute att = grid.findAttributeIgnoreCase("GRIB_center_id");
                this.param[0] = att.getNumericValue().intValue();
                att = gds.findGlobalAttributeIgnoreCase("Originating_subcenter_id");
                this.param[1] = att.getNumericValue().intValue();
                att = grid.findAttributeIgnoreCase("GRIB_param_number");
                this.param[2] = att.getNumericValue().intValue();
                att = grid.findAttributeIgnoreCase("GRIB_level_type");
                this.level = att.getNumericValue().intValue();
                this.isError = grid.getName().contains("error");
                String desc = grid.getDescription();
                if (desc.contains("Accumulation")) {
                    this.interval = 4;
                } else if (desc.contains("Accumulation")) {
                    this.interval = 4;
                }
                att = grid.findAttributeIgnoreCase("GRIB_probability_type");
                if (att != null) {
                    this.prob = att.getNumericValue().intValue();
                }
                if (this.prob == 0) {
                    att = grid.findAttributeIgnoreCase("GRIB_probability_lower_limit");
                    if (att != null) {
                        this.probLimit = (int)(1000.0 * att.getNumericValue().doubleValue());
                    }
                } else if (this.prob == 1 && (att = grid.findAttributeIgnoreCase("GRIB_probability_upper_limit")) != null) {
                    this.probLimit = (int)(1000.0 * att.getNumericValue().doubleValue());
                }
                if ((att = grid.findAttributeIgnoreCase("GRIB_ensemble_derived_type")) != null) {
                    this.ens = att.getNumericValue().intValue();
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridMatch gridMatch = (GridMatch)o;
            if (this.param != gridMatch.param) {
                return false;
            }
            if (this.ens != gridMatch.ens) {
                return false;
            }
            if (this.interval != gridMatch.interval) {
                return false;
            }
            if (this.isError != gridMatch.isError) {
                return false;
            }
            if (this.isLayer != gridMatch.isLayer) {
                return false;
            }
            if (this.level != gridMatch.level) {
                return false;
            }
            if (this.prob != gridMatch.prob) {
                return false;
            }
            return this.probLimit == gridMatch.probLimit;
        }

        public boolean altMatch(GridMatch gridMatch) {
            if (!this.altMatchNoProb(gridMatch)) {
                return false;
            }
            if (this.probLimit / 1000 == gridMatch.probLimit) {
                return true;
            }
            return this.probLimit == gridMatch.probLimit / 1000;
        }

        public boolean altMatchNoProb(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GridMatch gridMatch = (GridMatch)o;
            if (this.ens != gridMatch.ens) {
                return false;
            }
            if (this.interval != gridMatch.interval) {
                return false;
            }
            if (this.isError != gridMatch.isError) {
                return false;
            }
            if (this.isLayer != gridMatch.isLayer) {
                return false;
            }
            if (this.level != gridMatch.level) {
                return false;
            }
            return this.prob == gridMatch.prob;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.level;
            result = 31 * result + this.param[0];
            result = 31 * result + (this.isLayer ? 1 : 0);
            result = 31 * result + (this.isError ? 1 : 0);
            result = 31 * result + this.param[1];
            result = 31 * result + this.interval;
            result = 31 * result + this.prob;
            result = 31 * result + this.param[2];
            result = 31 * result + this.ens;
            result = 31 * result + this.probLimit;
            return result;
        }

        @Override
        public int compareTo(GridMatch o) {
            return this.grid.compareTo(o.grid);
        }

        String show() {
            Formatter f = new Formatter();
            f.format("%d-%d-%d-", this.param[0], this.param[1], this.param[2]);
            f.format("%d", this.level);
            if (this.isLayer) {
                f.format("_layer", new Object[0]);
            }
            if (this.interval >= 0) {
                f.format("_intv%d", this.interval);
            }
            if (this.prob >= 0) {
                f.format("_prob%d_%d", this.prob, this.probLimit);
            }
            if (this.ens >= 0) {
                f.format("_ens%d", this.ens);
            }
            if (this.isError) {
                f.format("_error", new Object[0]);
            }
            return f.toString();
        }
    }

    private class VarName {
        String dataset;
        String oldVar;
        String newVar;
        String varId;

        private VarName(String dataset, String oldVar, String newVar, String varId) {
            this.dataset = dataset;
            this.oldVar = oldVar;
            this.newVar = newVar;
            this.varId = varId;
        }
    }

    public static enum Report {
        checkTables,
        showLocalParams,
        scanIssues,
        rename,
        checkRename,
        showEncoding;

    }
}

