/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.grib.GribVariableRenamer;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class GribRenamePanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable varTable;
    private BeanTable mapTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private JComboBox kind;
    private GribVariableRenamer renamer;

    public GribRenamePanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.varTable = new BeanTable(GribVariableRenamer.VariableRenamerBean.class, (PreferencesExt)prefs.node("VariableBean"), false);
        this.mapTable = new BeanTable(MapBean.class, (PreferencesExt)prefs.node("MapBean"), false);
        this.mapTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MapBean bean = (MapBean)GribRenamePanel.this.mapTable.getSelectedBean();
                GribRenamePanel.this.showVariable(bean);
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.varTable, this.mapTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        this.kind = new JComboBox<String>(new String[]{"GRIB-1", "GRIB-2"});
        buttPanel.add(this.kind);
        this.kind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GribRenamePanel.this.renamer = new GribVariableRenamer();
                List<GribVariableRenamer.VariableRenamerBean> vbeans = GribRenamePanel.this.renamer.readVariableRenamerBeans((String)GribRenamePanel.this.kind.getSelectedItem());
                GribRenamePanel.this.varTable.setBeans(vbeans);
                GribRenamePanel.this.makeMapBeans();
            }
        });
    }

    public void save() {
        this.varTable.saveState(false);
        this.mapTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public boolean matchNcepName(String oldName) {
        if (this.renamer == null) {
            return false;
        }
        GribVariableRenamer.VariableRenamerBean bean = (GribVariableRenamer.VariableRenamerBean)this.varTable.getSelectedBean();
        List<String> result = this.renamer.matchNcepNames(bean.getDatasetType(), oldName);
        Formatter f = new Formatter();
        f.format("Match '%s'%n", oldName);
        for (String s : result) {
            f.format("  %s%n", s);
        }
        this.infoTA.setText(f.toString());
        this.infoTA.gotoTop();
        this.infoWindow.setVisible(true);
        return true;
    }

    private void showVariable(MapBean bean) {
        this.infoTA.setText(bean.show());
        this.infoTA.gotoTop();
        this.infoWindow.setVisible(true);
    }

    private void makeMapBeans() {
        HashMap<String, MapBean> map = new HashMap<String, MapBean>(3000);
        List vbeans = this.varTable.getBeans();
        for (GribVariableRenamer.VariableRenamerBean vbean : vbeans) {
            MapBean mbean = (MapBean)map.get(vbean.getOldName());
            if (mbean == null) {
                mbean = new MapBean(vbean.getOldName());
                map.put(vbean.getOldName(), mbean);
            }
            mbean.add(vbean);
        }
        this.mapTable.setBeans(new ArrayList(map.values()));
    }

    public class MapBean {
        String oldName;
        List<GribVariableRenamer.VariableRenamerBean> newVars = new ArrayList<GribVariableRenamer.VariableRenamerBean>();
        HashMap<String, GribVariableRenamer.VariableRenamerBean> newVarsMap = new HashMap();

        public MapBean() {
        }

        void add(GribVariableRenamer.VariableRenamerBean vbean) {
            this.newVars.add(vbean);
            this.newVarsMap.put(vbean.getNewName(), vbean);
        }

        public MapBean(String oldName) {
            this.oldName = oldName;
        }

        public int getCount() {
            return this.newVarsMap.size();
        }

        public String getOldName() {
            return this.oldName;
        }

        String show() {
            Formatter f = new Formatter();
            f.format("OldName %s%nNewNames%n", this.oldName);
            ArrayList<GribVariableRenamer.VariableRenamerBean> vbeans = new ArrayList<GribVariableRenamer.VariableRenamerBean>(this.newVarsMap.values());
            Collections.sort(vbeans);
            for (GribVariableRenamer.VariableRenamerBean vb : vbeans) {
                f.format("  %-70s %-40s %s%n", vb.getNewName(), vb.getVarId(), vb.getDataset());
            }
            f.format("%n", new Object[0]);
            for (GribVariableRenamer.VariableRenamerBean vb : this.newVars) {
                f.format("  %-70s %-40s %s (%s)%n", vb.getNewName(), vb.getVarId(), vb.getDataset(), vb.getDatasetType());
            }
            return f.toString();
        }
    }
}

