/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.grib.grib2.table.WmoTemplateTable;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class GribWmoTemplatesPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable codeTable;
    private BeanTable entryTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane compareTA;
    private IndependentWindow infoWindow;
    private FileManager fileChooser;

    public GribWmoTemplatesPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.codeTable = new BeanTable(CodeBean.class, (PreferencesExt)prefs.node("CodeTableBean"), false);
        this.codeTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CodeBean csb = (CodeBean)GribWmoTemplatesPanel.this.codeTable.getSelectedBean();
                GribWmoTemplatesPanel.this.setEntries(csb.template);
            }
        });
        this.entryTable = new BeanTable(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        this.entryTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EntryBean csb = (EntryBean)GribWmoTemplatesPanel.this.entryTable.getSelectedBean();
            }
        });
        PopupMenu varPopup = new PopupMenu(this.codeTable.getJTable(), "Options");
        varPopup.addAction("Show table", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter out = new Formatter();
                CodeBean csb = (CodeBean)GribWmoTemplatesPanel.this.codeTable.getSelectedBean();
                csb.showTable(out);
                GribWmoTemplatesPanel.this.compareTA.setText(out.toString());
                GribWmoTemplatesPanel.this.compareTA.gotoTop();
                GribWmoTemplatesPanel.this.infoWindow.setVisible(true);
            }
        });
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, this.codeTable, this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.codeTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        if (this.fileChooser != null) {
            this.fileChooser.save();
        }
    }

    public void setTable(WmoTemplateTable.Version v) {
        try {
            WmoTemplateTable.GribTemplates wmo = WmoTemplateTable.readXml(v);
            List<WmoTemplateTable> codes = wmo.list;
            ArrayList<CodeBean> dds = new ArrayList<CodeBean>(codes.size());
            for (WmoTemplateTable code : codes) {
                dds.add(new CodeBean(code));
            }
            this.codeTable.setBeans(dds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEntries(WmoTemplateTable template) {
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>(template.flds.size());
        for (WmoTemplateTable.Field d : template.flds) {
            beans.add(new EntryBean(d));
        }
        this.entryTable.setBeans(beans);
    }

    public class EntryBean {
        WmoTemplateTable.Field te;

        public EntryBean() {
        }

        public EntryBean(WmoTemplateTable.Field te) {
            this.te = te;
        }

        public String getOctet() {
            return this.te.octet;
        }

        public String getContent() {
            return this.te.content;
        }

        public int getNbytes() {
            return this.te.nbytes;
        }

        public int getStart() {
            return this.te.start;
        }

        public String getStatus() {
            return this.te.status;
        }

        public String getNotes() {
            return this.te.note;
        }
    }

    public class CodeBean {
        WmoTemplateTable template;

        public CodeBean() {
        }

        public CodeBean(WmoTemplateTable template) {
            this.template = template;
        }

        public String getName() {
            return this.template.name;
        }

        public String getDescription() {
            return this.template.desc;
        }

        public int getM1() {
            return this.template.m1;
        }

        public int getM2() {
            return this.template.m2;
        }

        void showTable(Formatter f) {
            f.format("Template %s (%s)%n", this.template.name, this.template.desc);
            for (WmoTemplateTable.Field entry : this.template.flds) {
                f.format("  %6s (%d): %s", entry.octet, entry.nbytes, entry.content);
                if (entry.note != null) {
                    f.format(" - %s", entry.note);
                }
                f.format("%n", new Object[0]);
            }
        }
    }
}

