/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ucar.nc2.NetcdfFile;
import ucar.nc2.stream.NcStreamIosp;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class NcStreamPanel
extends JPanel {
    private PreferencesExt prefs;
    private BeanTable messTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private TextHistoryPane infoPopup2;
    private TextHistoryPane infoPopup3;
    private IndependentWindow infoWindow2;
    private IndependentWindow infoWindow3;
    private RandomAccessFile raf;
    private NetcdfFile ncd;
    private NcStreamIosp iosp;

    public NcStreamPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.messTable = new BeanTable(MessBean.class, (PreferencesExt)prefs.node("NcStreamPanel"), false);
        this.messTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MessBean bean = (MessBean)NcStreamPanel.this.messTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                NcStreamPanel.this.infoTA.setText(bean.getDesc());
            }
        });
        PopupMenu varPopup = new PopupMenu(this.messTable.getJTable(), "Options");
        varPopup.addAction("Show deflate", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessBean bean = (MessBean)NcStreamPanel.this.messTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                NcStreamPanel.this.infoTA.setText(bean.m.showDeflate());
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoPopup2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", new Rectangle(300, 300, 500, 300)));
        this.infoPopup3 = new TextHistoryPane();
        this.infoWindow3 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup3);
        this.infoWindow3.setBounds((Rectangle)prefs.getBean("InfoWindowBounds3", new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split2 = new JSplitPane(0, false, this.messTable, this.infoTA);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.add((Component)this.split2, "Center");
    }

    public void save() {
        this.messTable.saveState(false);
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
    }

    public void closeOpenFiles() throws IOException {
        if (this.ncd != null) {
            this.ncd.close();
        }
        this.ncd = null;
        this.raf = null;
        this.iosp = null;
    }

    public void showInfo(Formatter f) {
        if (this.ncd == null) {
            return;
        }
        try {
            f.format("%s%n", this.raf.getLocation());
            f.format(" file length = %d%n", this.raf.length());
            f.format(" version = %d%n", this.iosp.getVersion());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        f.format("%n%s", this.ncd.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNcStreamFile(String filename) throws IOException {
        this.closeOpenFiles();
        ArrayList<MessBean> messages = new ArrayList<MessBean>();
        this.ncd = new MyNetcdfFile();
        this.iosp = new NcStreamIosp();
        try {
            this.raf = new RandomAccessFile(filename, "r");
            ArrayList<NcStreamIosp.NcsMess> ncm = new ArrayList<NcStreamIosp.NcsMess>();
            this.iosp.openDebug(this.raf, this.ncd, ncm);
            for (NcStreamIosp.NcsMess m : ncm) {
                messages.add(new MessBean(m));
            }
        }
        finally {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        this.messTable.setBeans(messages);
    }

    public class MessBean {
        private NcStreamIosp.NcsMess m;

        MessBean() {
        }

        MessBean(NcStreamIosp.NcsMess m) {
            this.m = m;
        }

        public String getObjClass() {
            return this.m.what.getClass().toString();
        }

        public String getDesc() {
            return this.m.what.toString();
        }

        public int getSize() {
            return this.m.len;
        }

        public int getNelems() {
            return this.m.nelems;
        }

        public long getFilePos() {
            return this.m.filePos;
        }
    }

    private static class MyNetcdfFile
    extends NetcdfFile {
        private MyNetcdfFile() {
        }
    }
}

