/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.coverage;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.grid.Coverage;
import ucar.nc2.ft.grid.CoverageCS;
import ucar.nc2.ft.grid.CoverageDataset;
import ucar.nc2.ft.grid.impl.CoverageDatasetImpl;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.ui.coverage.CoverageRenderer;
import ucar.nc2.ui.event.ActionCoordinator;
import ucar.nc2.ui.event.ActionSourceListener;
import ucar.nc2.ui.event.ActionValueEvent;
import ucar.nc2.ui.geoloc.NavigatedPanel;
import ucar.nc2.ui.geoloc.NewMapAreaEvent;
import ucar.nc2.ui.geoloc.NewMapAreaListener;
import ucar.nc2.ui.geoloc.NewProjectionEvent;
import ucar.nc2.ui.geoloc.NewProjectionListener;
import ucar.nc2.ui.geoloc.ProjectionManager;
import ucar.nc2.ui.gis.MapBean;
import ucar.nc2.ui.grid.ColorScale;
import ucar.nc2.ui.util.Renderer;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.MFlowLayout;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.ProgressMonitor;
import ucar.nc2.ui.widget.ProgressMonitorTask;
import ucar.nc2.ui.widget.SuperComboBox;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.NamedObject;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.Debug;

public class CoverageDisplay
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(CoverageDisplay.class);
    private static final int DELAY_DRAW_AFTER_DATA_EVENT = 250;
    private static final String LastMapAreaName = "LastMapArea";
    private static final String LastProjectionName = "LastProjection";
    private static final String LastDatasetName = "LastDataset";
    private static final String ColorScaleName = "ColorScale";
    private static final String DATASET_URL = "DatasetURL";
    private static final String GEOTIFF_FILECHOOSER_DEFAULTDIR = "geotiffDefDir";
    private PreferencesExt store;
    private JFrame parent;
    private FileManager fileChooser;
    private ColorScale colorScale;
    private ColorScale.Panel colorScalePanel;
    private List<Chooser> choosers;
    private SuperComboBox fieldChooser;
    private SuperComboBox levelChooser;
    private SuperComboBox timeChooser;
    private SuperComboBox ensembleChooser;
    private SuperComboBox runtimeChooser;
    private JLabel dataValueLabel;
    private JLabel positionLabel;
    private NavigatedPanel navPanel;
    private TextHistoryPane datasetInfoTA;
    private TextHistoryPane ncmlTA;
    private JPanel drawingPanel;
    private JComboBox csDataMinMax;
    private PopupMenu mapBeanMenu;
    private JSpinner strideSpinner;
    private JLabel datasetNameLabel = new JLabel();
    private ProjectionManager projManager;
    private IndependentWindow infoWindow = null;
    private IndependentWindow ncmlWindow = null;
    private IndependentWindow gtWindow = null;
    private JDialog dsDialog = null;
    private FileManager geotiffFileChooser;
    private JPanel fieldPanel;
    private JPanel toolPanel;
    private JToolBar navToolbar;
    private JToolBar moveToolbar;
    private AbstractAction navToolbarAction;
    private AbstractAction moveToolbarAction;
    private AbstractAction redrawAction;
    private AbstractAction showDatasetInfoAction;
    private AbstractAction minmaxHorizAction;
    private AbstractAction minmaxLogAction;
    private AbstractAction minmaxHoldAction;
    private AbstractAction fieldLoopAction;
    private AbstractAction levelLoopAction;
    private AbstractAction timeLoopAction;
    private AbstractAction chooseProjectionAction;
    private AbstractAction saveCurrentProjectionAction;
    private AbstractAction dataProjectionAction;
    private AbstractAction exitAction;
    private AbstractAction helpAction;
    private AbstractAction showGridAction;
    private AbstractAction showContoursAction;
    private AbstractAction showContourLabelsAction;
    private AbstractAction showWindsAction;
    private AbstractAction drawHorizAction;
    private AbstractAction drawVertAction;
    private CoverageDataset coverageDataset;
    private Coverage currentField;
    private ProjectionImpl project;
    private List<NamedObject> levelNames;
    private List<NamedObject> timeNames;
    private List<NamedObject> ensembleNames;
    private List<NamedObject> runtimeNames;
    private int currentLevel;
    private int currentSlice;
    private int currentTime;
    private int currentEnsemble;
    private int currentRunTime;
    private boolean drawHorizOn = true;
    private boolean drawVertOn = false;
    private boolean eventsOK = true;
    private Color mapColor = Color.black;
    private boolean drawWinds = false;
    private boolean hasDependentTimeAxis = false;
    private boolean selected = false;
    private int mapBeanCount = 0;
    private AffineTransform atI = new AffineTransform();
    private Renderer renderMap = null;
    private CoverageRenderer renderGrid;
    private Timer redrawTimer;
    private boolean debugBeans = false;
    private boolean debugChooser = false;
    private boolean debugPrint = false;
    private boolean debugHelp = false;
    private boolean debugTask = false;
    private boolean debugThread = false;
    private ProjectionPointImpl projPoint = new ProjectionPointImpl();
    private boolean startOK = true;

    public CoverageDisplay(PreferencesExt pstore, RootPaneContainer root, FileManager fileChooser, int defaultHeight) {
        this.store = pstore;
        this.fileChooser = fileChooser;
        try {
            this.choosers = new ArrayList<Chooser>();
            this.fieldChooser = new SuperComboBox(root, "field", true, null);
            this.choosers.add(new Chooser("field", this.fieldChooser, true));
            this.levelChooser = new SuperComboBox(root, "level", false, null);
            this.choosers.add(new Chooser("level", this.levelChooser, false));
            this.timeChooser = new SuperComboBox(root, "time", false, null);
            this.choosers.add(new Chooser("time", this.timeChooser, false));
            this.ensembleChooser = new SuperComboBox(root, "ensemble", false, null);
            this.choosers.add(new Chooser("ensemble", this.ensembleChooser, false));
            this.runtimeChooser = new SuperComboBox(root, "runtime", false, null);
            this.choosers.add(new Chooser("runtime", this.runtimeChooser, false));
            Object bean = this.store.getBean(ColorScaleName, null);
            this.colorScale = null == bean || !(bean instanceof ColorScale) ? new ColorScale("default") : (ColorScale)this.store.getBean(ColorScaleName, null);
            this.colorScalePanel = new ColorScale.Panel(this, this.colorScale);
            this.csDataMinMax = new JComboBox<ColorScale.MinMaxType>(ColorScale.MinMaxType.values());
            this.csDataMinMax.setToolTipText("ColorScale Min/Max setting");
            this.csDataMinMax.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CoverageDisplay.this.renderGrid.setDataMinMaxType((ColorScale.MinMaxType)((Object)CoverageDisplay.this.csDataMinMax.getSelectedItem()));
                    CoverageDisplay.this.redrawLater();
                }
            });
            this.renderGrid = new CoverageRenderer(this.store);
            this.renderGrid.setColorScale(this.colorScale);
            this.strideSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
            this.strideSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Integer val = (Integer)CoverageDisplay.this.strideSpinner.getValue();
                    CoverageDisplay.this.renderGrid.setHorizStride(val);
                }
            });
            this.makeActionsDataset();
            this.makeActionsToolbars();
            this.makeActions();
            this.makeEventManagement();
            this.toolPanel = new JPanel();
            this.toolPanel.setBorder(new EtchedBorder());
            this.toolPanel.setLayout(new MFlowLayout(0, 0, 0));
            JMenu dataMenu = new JMenu("Dataset");
            dataMenu.setMnemonic('D');
            JMenu configMenu = new JMenu("Configure");
            configMenu.setMnemonic('C');
            JMenu toolMenu = new JMenu("Controls");
            toolMenu.setMnemonic('T');
            JMenuBar menuBar = new JMenuBar();
            menuBar.add(dataMenu);
            menuBar.add(configMenu);
            menuBar.add(toolMenu);
            this.toolPanel.add(menuBar);
            this.fieldPanel = new JPanel();
            this.fieldPanel.setLayout(new FlowLayout(0, 0, 0));
            this.toolPanel.add(this.fieldPanel);
            this.toolPanel.add(this.strideSpinner);
            BAMutil.addActionToContainer(this.toolPanel, this.drawHorizAction);
            BAMutil.addActionToContainer(this.toolPanel, this.drawVertAction);
            this.mapBeanMenu = MapBean.makeMapSelectButton();
            this.toolPanel.add(this.mapBeanMenu.getParentComponent());
            this.navPanel = new NavigatedPanel();
            this.navPanel.setLayout(new FlowLayout());
            ProjectionRect ma = (ProjectionRect)this.store.getBean(LastMapAreaName, null);
            if (ma != null) {
                this.navPanel.setMapArea(ma);
            }
            this.navToolbar = this.navPanel.getNavToolBar();
            this.moveToolbar = this.navPanel.getMoveToolBar();
            if (((Boolean)this.navToolbarAction.getValue("state")).booleanValue()) {
                this.toolPanel.add(this.navToolbar);
            }
            if (((Boolean)this.moveToolbarAction.getValue("state")).booleanValue()) {
                this.toolPanel.add(this.moveToolbar);
            }
            this.makeNavPanelWiring();
            this.addActionsToMenus(dataMenu, configMenu, toolMenu);
            BAMutil.addActionToContainer(this.toolPanel, this.navPanel.setReferenceAction);
            BAMutil.addActionToContainer(this.toolPanel, this.dataProjectionAction);
            BAMutil.addActionToContainer(this.toolPanel, this.showGridAction);
            BAMutil.addActionToContainer(this.toolPanel, this.showContoursAction);
            BAMutil.addActionToContainer(this.toolPanel, this.showContourLabelsAction);
            BAMutil.addActionToContainer(this.toolPanel, this.redrawAction);
            this.drawingPanel = new JPanel(new BorderLayout());
            JPanel statusPanel = new JPanel(new BorderLayout());
            statusPanel.setBorder(new EtchedBorder());
            this.positionLabel = new JLabel("position");
            this.positionLabel.setToolTipText("position at cursor");
            this.dataValueLabel = new JLabel("data value", 0);
            this.dataValueLabel.setToolTipText("data value (double click on grid)");
            statusPanel.add((Component)this.positionLabel, "West");
            statusPanel.add((Component)this.dataValueLabel, "Center");
            this.navPanel.setPositionLabel(this.positionLabel);
            JPanel westPanel = new JPanel(new BorderLayout());
            westPanel.add((Component)this.colorScalePanel, "Center");
            westPanel.add((Component)this.csDataMinMax, "North");
            JPanel northPanel = new JPanel();
            northPanel.setLayout(new BorderLayout());
            northPanel.add((Component)this.datasetNameLabel, "North");
            northPanel.add((Component)this.toolPanel, "South");
            this.setLayout(new BorderLayout());
            this.add((Component)northPanel, "North");
            this.add((Component)statusPanel, "South");
            this.add((Component)westPanel, "West");
            this.add((Component)this.drawingPanel, "Center");
            this.setDrawHorizAndVert(this.drawHorizOn, this.drawVertOn);
            this.project = (ProjectionImpl)this.store.getBean(LastProjectionName, null);
            if (this.project != null) {
                this.setProjection(this.project);
            }
            this.redrawTimer = new Timer(0, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CoverageDisplay.this.draw(false);
                        }
                    });
                    CoverageDisplay.this.redrawTimer.stop();
                }
            });
            this.redrawTimer.setInitialDelay(250);
            this.redrawTimer.setRepeats(false);
        }
        catch (Exception e) {
            System.out.println("UI creation failed");
            e.printStackTrace();
        }
    }

    private void makeActionsDataset() {
        AbstractAction chooseLocalDatasetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InvDatasetImpl invDs;
                String filename = CoverageDisplay.this.fileChooser.chooseFilename();
                if (filename == null) {
                    return;
                }
                try {
                    invDs = new InvDatasetImpl(filename, FeatureType.GRID, ServiceType.NETCDF);
                }
                catch (Exception ue) {
                    JOptionPane.showMessageDialog(CoverageDisplay.this, "Invalid filename = <" + filename + ">\n" + ue.getMessage());
                    ue.printStackTrace();
                    return;
                }
                CoverageDisplay.this.setDataset(invDs);
            }
        };
        BAMutil.setActionProperties(chooseLocalDatasetAction, "FileChooser", "open Local dataset...", false, 76, -1);
        this.chooseProjectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageDisplay.this.getProjectionManager().setVisible();
            }
        };
        BAMutil.setActionProperties(this.chooseProjectionAction, null, "Projection Manager...", false, 80, 0);
        this.saveCurrentProjectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageDisplay.this.getProjectionManager();
                ProjectionImpl proj = CoverageDisplay.this.navPanel.getProjectionImpl().constructCopy();
                proj.setDefaultMapArea(CoverageDisplay.this.navPanel.getMapArea());
            }
        };
        BAMutil.setActionProperties(this.saveCurrentProjectionAction, null, "save Current Projection", false, 83, 0);
        this.redrawAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageDisplay.this.repaint();
                CoverageDisplay.this.start(true);
                CoverageDisplay.this.draw(true);
            }
        };
        BAMutil.setActionProperties(this.redrawAction, "alien", "RedRaw", false, 87, 0);
        this.showDatasetInfoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CoverageDisplay.this.infoWindow == null) {
                    CoverageDisplay.this.datasetInfoTA = new TextHistoryPane();
                    CoverageDisplay.this.infoWindow = new IndependentWindow("Dataset Information", BAMutil.getImage("GDVs"), CoverageDisplay.this.datasetInfoTA);
                    CoverageDisplay.this.infoWindow.setSize(700, 700);
                    CoverageDisplay.this.infoWindow.setLocation(100, 100);
                }
                CoverageDisplay.this.datasetInfoTA.clear();
                if (CoverageDisplay.this.coverageDataset != null) {
                    Formatter f = new Formatter();
                    CoverageDisplay.this.coverageDataset.getDetailInfo(f);
                    CoverageDisplay.this.datasetInfoTA.appendLine(f.toString());
                } else {
                    CoverageDisplay.this.datasetInfoTA.appendLine("No coverageDataset loaded");
                }
                CoverageDisplay.this.datasetInfoTA.gotoTop();
                CoverageDisplay.this.infoWindow.show();
            }
        };
        BAMutil.setActionProperties(this.showDatasetInfoAction, "Information", "Show info...", false, 83, -1);
        this.minmaxHorizAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageDisplay.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.horiz);
                CoverageDisplay.this.setDataMinMaxType(ColorScale.MinMaxType.horiz);
            }
        };
        BAMutil.setActionProperties(this.minmaxHorizAction, null, "Horizontal plane", false, 72, 0);
        this.minmaxLogAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageDisplay.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.log);
                CoverageDisplay.this.setDataMinMaxType(ColorScale.MinMaxType.log);
            }
        };
        BAMutil.setActionProperties(this.minmaxLogAction, null, "log horiz plane", false, 86, 0);
        this.minmaxHoldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageDisplay.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.hold);
                CoverageDisplay.this.setDataMinMaxType(ColorScale.MinMaxType.hold);
            }
        };
        BAMutil.setActionProperties(this.minmaxHoldAction, null, "Hold scale constant", false, 67, 0);
        this.fieldLoopAction = new LoopControlAction(this.fieldChooser);
        this.levelLoopAction = new LoopControlAction(this.levelChooser);
        this.timeLoopAction = new LoopControlAction(this.timeChooser);
    }

    private void makeActionsToolbars() {
        this.navToolbarAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state.booleanValue()) {
                    CoverageDisplay.this.toolPanel.add(CoverageDisplay.this.navToolbar);
                } else {
                    CoverageDisplay.this.toolPanel.remove(CoverageDisplay.this.navToolbar);
                }
            }
        };
        BAMutil.setActionProperties(this.navToolbarAction, "MagnifyPlus", "show Navigate toolbar", true, 77, 0);
        this.navToolbarAction.putValue("state", new Boolean(this.store.getBoolean("navToolbarAction", true)));
        this.moveToolbarAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state.booleanValue()) {
                    CoverageDisplay.this.toolPanel.add(CoverageDisplay.this.moveToolbar);
                } else {
                    CoverageDisplay.this.toolPanel.remove(CoverageDisplay.this.moveToolbar);
                }
            }
        };
        BAMutil.setActionProperties(this.moveToolbarAction, "Up", "show Move toolbar", true, 77, 0);
        this.moveToolbarAction.putValue("state", new Boolean(this.store.getBoolean("moveToolbarAction", true)));
    }

    private void makeActions() {
        this.dataProjectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectionImpl dataProjection = CoverageDisplay.this.renderGrid.getDataProjection();
                if (null != dataProjection) {
                    CoverageDisplay.this.setProjection(dataProjection);
                }
            }
        };
        BAMutil.setActionProperties(this.dataProjectionAction, "DataProjection", "use Data Projection", false, 68, 0);
        this.drawHorizAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoverageDisplay.this.drawHorizOn = state;
                CoverageDisplay.this.setDrawHorizAndVert(CoverageDisplay.this.drawHorizOn, CoverageDisplay.this.drawVertOn);
                CoverageDisplay.this.draw(false);
            }
        };
        BAMutil.setActionProperties(this.drawHorizAction, "DrawHoriz", "draw horizontal", true, 72, 0);
        boolean state = this.store.getBoolean("drawHorizAction", true);
        this.drawHorizAction.putValue("state", new Boolean(state));
        this.drawHorizOn = state;
        this.drawVertAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoverageDisplay.this.drawVertOn = state;
                CoverageDisplay.this.setDrawHorizAndVert(CoverageDisplay.this.drawHorizOn, CoverageDisplay.this.drawVertOn);
                CoverageDisplay.this.draw(false);
            }
        };
        BAMutil.setActionProperties(this.drawVertAction, "DrawVert", "draw vertical", true, 86, 0);
        state = this.store.getBoolean("drawVertAction", false);
        this.drawVertAction.putValue("state", new Boolean(state));
        this.drawVertOn = state;
        this.showGridAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoverageDisplay.this.renderGrid.setDrawGridLines(state);
                CoverageDisplay.this.draw(false);
            }
        };
        BAMutil.setActionProperties(this.showGridAction, "Grid", "show grid lines", true, 71, 0);
        state = this.store.getBoolean("showGridAction", false);
        this.showGridAction.putValue("state", new Boolean(state));
        this.renderGrid.setDrawGridLines(state);
        this.showContoursAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoverageDisplay.this.renderGrid.setDrawContours(state);
                CoverageDisplay.this.draw(false);
            }
        };
        BAMutil.setActionProperties(this.showContoursAction, "Contours", "show contours", true, 67, 0);
        state = this.store.getBoolean("showContoursAction", false);
        this.showContoursAction.putValue("state", new Boolean(state));
        this.renderGrid.setDrawContours(state);
        this.showContourLabelsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoverageDisplay.this.renderGrid.setDrawContourLabels(state);
                CoverageDisplay.this.draw(false);
            }
        };
        BAMutil.setActionProperties(this.showContourLabelsAction, "ContourLabels", "show contour labels", true, 76, 0);
        state = this.store.getBoolean("showContourLabelsAction", false);
        this.showContourLabelsAction.putValue("state", new Boolean(state));
        this.renderGrid.setDrawContourLabels(state);
    }

    private void makeEventManagement() {
        String actionName = "field";
        ActionCoordinator fieldCoordinator = new ActionCoordinator(actionName);
        fieldCoordinator.addActionSourceListener(this.fieldChooser.getActionSourceListener());
        ActionSourceListener fieldSource = new ActionSourceListener(actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                if (CoverageDisplay.this.setField(e.getValue())) {
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        CoverageDisplay.this.draw(true);
                    } else {
                        CoverageDisplay.this.redrawLater();
                    }
                }
            }
        };
        fieldCoordinator.addActionSourceListener(fieldSource);
        actionName = "level";
        ActionCoordinator levelCoordinator = new ActionCoordinator(actionName);
        levelCoordinator.addActionSourceListener(this.levelChooser.getActionSourceListener());
        ActionSourceListener levelSource = new ActionSourceListener(actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                int level = CoverageDisplay.this.findIndexFromName(CoverageDisplay.this.levelNames, e.getValue().toString());
                if (level != -1 && level != CoverageDisplay.this.currentLevel) {
                    CoverageDisplay.this.currentLevel = level;
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        CoverageDisplay.this.draw(true);
                    } else {
                        CoverageDisplay.this.redrawLater();
                    }
                }
            }
        };
        levelCoordinator.addActionSourceListener(levelSource);
        actionName = "time";
        ActionCoordinator timeCoordinator = new ActionCoordinator(actionName);
        timeCoordinator.addActionSourceListener(this.timeChooser.getActionSourceListener());
        ActionSourceListener timeSource = new ActionSourceListener(actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                int time = CoverageDisplay.this.findIndexFromName(CoverageDisplay.this.timeNames, e.getValue().toString());
                if (time != -1 && time != CoverageDisplay.this.currentTime) {
                    CoverageDisplay.this.currentTime = time;
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        CoverageDisplay.this.draw(true);
                    } else {
                        CoverageDisplay.this.redrawLater();
                    }
                }
            }
        };
        timeCoordinator.addActionSourceListener(timeSource);
        actionName = "ensemble";
        ActionCoordinator ensembleCoordinator = new ActionCoordinator(actionName);
        ensembleCoordinator.addActionSourceListener(this.ensembleChooser.getActionSourceListener());
        ActionSourceListener ensembleSource = new ActionSourceListener(actionName){

            @Override
            public void actionPerformed(ActionValueEvent e) {
                int ensIndex = CoverageDisplay.this.findIndexFromName(CoverageDisplay.this.ensembleNames, e.getValue().toString());
                if (ensIndex != -1 && ensIndex != CoverageDisplay.this.currentEnsemble) {
                    CoverageDisplay.this.currentEnsemble = ensIndex;
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        CoverageDisplay.this.draw(true);
                    } else {
                        CoverageDisplay.this.redrawLater();
                    }
                }
            }
        };
        ensembleCoordinator.addActionSourceListener(ensembleSource);
    }

    private void makeNavPanelWiring() {
        this.navPanel.addNewProjectionListener(new NewProjectionListener(){

            @Override
            public void actionPerformed(NewProjectionEvent e) {
                if (Debug.isSet("event/NewProjection")) {
                    System.out.println("Controller got NewProjectionEvent " + CoverageDisplay.this.navPanel.getMapArea());
                }
                if (CoverageDisplay.this.eventsOK && CoverageDisplay.this.renderMap != null) {
                    CoverageDisplay.this.renderMap.setProjection(e.getProjection());
                    CoverageDisplay.this.renderGrid.setProjection(e.getProjection());
                    CoverageDisplay.this.drawH(false);
                }
            }
        });
        this.navPanel.addNewMapAreaListener(new NewMapAreaListener(){

            @Override
            public void actionPerformed(NewMapAreaEvent e) {
                if (Debug.isSet("event/NewMapArea")) {
                    System.out.println("Controller got NewMapAreaEvent " + CoverageDisplay.this.navPanel.getMapArea());
                }
                CoverageDisplay.this.drawH(false);
            }
        });
    }

    private int findIndexFromName(List<NamedObject> list, String name) {
        for (int idx = 0; idx < list.size(); ++idx) {
            NamedObject no = list.get(idx);
            if (!name.equals(no.getName())) continue;
            return idx;
        }
        log.error("findIndexFromName cant find " + name);
        return -1;
    }

    public void save() {
        this.store.putBoolean("navToolbarAction", (Boolean)this.navToolbarAction.getValue("state"));
        this.store.putBoolean("moveToolbarAction", (Boolean)this.moveToolbarAction.getValue("state"));
        if (this.projManager != null) {
            this.projManager.storePersistentData();
        }
        this.store.put(GEOTIFF_FILECHOOSER_DEFAULTDIR, this.geotiffFileChooser.getCurrentDirectory());
        this.store.putBeanObject(LastMapAreaName, this.navPanel.getMapArea());
        this.store.putBeanObject(LastProjectionName, this.navPanel.getProjectionImpl());
        this.store.putBeanObject(ColorScaleName, this.colorScale);
        this.store.putBoolean("showGridAction", (Boolean)this.showGridAction.getValue("state"));
        this.store.putBoolean("showContoursAction", (Boolean)this.showContoursAction.getValue("state"));
        this.store.putBoolean("showContourLabelsAction", (Boolean)this.showContourLabelsAction.getValue("state"));
    }

    private void setSelected(boolean b) {
        this.selected = b;
        this.navToolbarAction.setEnabled(b);
        this.moveToolbarAction.setEnabled(b);
        this.redrawAction.setEnabled(b);
        this.minmaxHorizAction.setEnabled(b);
        this.minmaxLogAction.setEnabled(b);
        this.minmaxHoldAction.setEnabled(b);
        this.fieldLoopAction.setEnabled(b);
        this.levelLoopAction.setEnabled(b);
        this.timeLoopAction.setEnabled(b);
        this.navPanel.setEnabledActions(b);
    }

    public void addMapBean(MapBean mb) {
        this.mapBeanMenu.addAction(mb.getActionDesc(), mb.getIcon(), mb.getAction());
        if (this.mapBeanCount == 0) {
            this.setMapRenderer(mb.getRenderer());
        }
        ++this.mapBeanCount;
        mb.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Renderer")) {
                    CoverageDisplay.this.setMapRenderer((Renderer)e.getNewValue());
                }
            }
        });
    }

    void setMapRenderer(Renderer mapRenderer) {
        this.renderMap = mapRenderer;
        mapRenderer.setProjection(this.navPanel.getProjectionImpl());
        mapRenderer.setColor(this.mapColor);
        this.redrawLater();
    }

    public void setDataset(InvDataset ds) {
        if (ds == null) {
            return;
        }
        OpenDatasetTask openTask = new OpenDatasetTask(ds);
        ProgressMonitor pm = new ProgressMonitor(openTask);
        pm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("success")) {
                    CoverageDisplay.this.showDataset();
                    CoverageDisplay.this.datasetNameLabel.setText("Dataset:  " + CoverageDisplay.this.coverageDataset.getLocation());
                    CoverageDisplay.this.setSelected(true);
                    CoverageDisplay.this.gtWindow.hide();
                }
            }
        });
        pm.start(this, "Open Dataset " + ds.getName(), 100);
    }

    boolean showDataset() {
        List<Coverage> grids = this.coverageDataset.getCoverages();
        if (grids == null || grids.size() == 0) {
            JOptionPane.showMessageDialog(null, "No gridded fields in file " + this.coverageDataset.getTitle());
            return false;
        }
        this.currentField = grids.get(0);
        this.currentSlice = 0;
        this.currentLevel = 0;
        this.currentTime = 0;
        this.currentEnsemble = 0;
        this.currentRunTime = 0;
        this.eventsOK = false;
        this.renderGrid.setCoverage(this.currentField);
        this.setFields(grids);
        this.setField(this.currentField);
        ProjectionImpl dataProjection = this.currentField.getCoordinateSystem().getProjection();
        if (dataProjection != null) {
            this.setProjection(dataProjection);
        }
        this.eventsOK = true;
        return true;
    }

    public void setDataMinMaxType(ColorScale.MinMaxType type) {
        this.renderGrid.setDataMinMaxType(type);
        this.redrawLater();
    }

    public void setDataset(CoverageDataset coverageDataset) {
        this.coverageDataset = coverageDataset;
        this.startOK = false;
        this.showDataset();
        this.datasetNameLabel.setText("Dataset:  " + coverageDataset.getLocation());
    }

    void setFields(List<Coverage> fields) {
        this.fieldChooser.setCollection(fields.iterator());
    }

    private boolean setField(Object fld) {
        NamedObject no;
        Coverage gg = null;
        if (fld instanceof Coverage) {
            gg = (Coverage)fld;
        } else if (fld instanceof String) {
            gg = this.coverageDataset.findCoverage((String)fld);
        } else if (fld instanceof NamedObject) {
            gg = this.coverageDataset.findCoverage(((NamedObject)fld).getName());
        }
        if (null == gg) {
            return false;
        }
        this.renderGrid.setCoverage(gg);
        this.currentField = gg;
        CoverageCS gcs = gg.getCoordinateSystem();
        if (gcs.getVerticalAxis() != null && gcs.getVerticalAxis() instanceof CoordinateAxis1D) {
            CoordinateAxis1D vaxis = (CoordinateAxis1D)gcs.getVerticalAxis();
            this.levelNames = vaxis.getNames();
            if (this.levelNames == null || this.currentLevel >= this.levelNames.size()) {
                this.currentLevel = 0;
            }
            this.setChooserWanted("level", true);
            List<NamedObject> levels = vaxis.getNames();
            this.levelChooser.setCollection(levels.iterator(), true);
            no = levels.get(this.currentLevel);
            this.levelChooser.setSelectedByName(no.getName());
        } else {
            this.levelNames = new ArrayList<NamedObject>();
            this.setChooserWanted("level", false);
        }
        if (gcs.getTimeAxis() != null && gcs.getTimeAxis() instanceof CoordinateAxis1DTime) {
            CoordinateAxis1DTime taxis = (CoordinateAxis1DTime)gcs.getTimeAxis();
            this.timeNames = taxis.getNames();
            if (this.timeNames == null || this.currentTime >= this.timeNames.size()) {
                this.currentTime = 0;
            }
            this.hasDependentTimeAxis = true;
            this.setChooserWanted("time", true);
            List<NamedObject> names = taxis.getNames();
            this.timeChooser.setCollection(names.iterator(), true);
            no = names.get(this.currentTime);
            this.timeChooser.setSelectedByName(no.getName());
        } else {
            this.timeNames = new ArrayList<NamedObject>();
            this.hasDependentTimeAxis = false;
            this.setChooserWanted("time", false);
        }
        this.addChoosers();
        this.fieldChooser.setToolTipText(gg.getShortName());
        this.colorScalePanel.setUnitString(gg.getUnitsString());
        return true;
    }

    void setDrawHorizAndVert(boolean drawHoriz, boolean drawVert) {
        this.drawingPanel.removeAll();
        if (drawHoriz && drawVert) {
            this.drawingPanel.add((Component)this.navPanel, "Center");
        } else if (drawHoriz) {
            this.drawingPanel.add((Component)this.navPanel, "Center");
        } else if (drawVert) {
            this.drawingPanel.add((Component)this.navPanel, "Center");
        }
    }

    public void setProjection(ProjectionImpl p) {
        this.project = p;
        if (this.renderMap != null) {
            this.renderMap.setProjection(p);
        }
        this.renderGrid.setProjection(p);
        this.navPanel.setProjectionImpl(p);
        this.redrawLater();
    }

    void start(boolean ok) {
        this.startOK = ok;
        this.renderGrid.makeStridedGrid();
    }

    synchronized void draw(boolean immediate) {
        if (!this.startOK) {
            return;
        }
        this.renderGrid.setLevel(this.currentLevel);
        this.renderGrid.setTime(this.currentTime);
        if (this.drawHorizOn) {
            this.drawH(immediate);
        }
    }

    private void drawH(boolean immediate) {
        long tookTime;
        if (!this.startOK) {
            return;
        }
        boolean already = this.redrawTimer.isRunning();
        if (this.debugThread && already) {
            System.out.println("redrawLater canceled ");
        }
        if (already) {
            this.redrawTimer.stop();
        }
        long tstart = System.currentTimeMillis();
        Graphics2D gNP = this.navPanel.getBufferedImageGraphics();
        if (gNP == null) {
            return;
        }
        gNP.setBackground(this.navPanel.getBackgroundColor());
        gNP.fill(gNP.getClipBounds());
        long startTime = System.currentTimeMillis();
        this.renderGrid.renderPlanView(gNP, this.atI);
        if (Debug.isSet("timing/GridDraw")) {
            tookTime = System.currentTimeMillis() - startTime;
            System.out.println("timing.GridDraw: " + (double)tookTime * 0.001 + " seconds");
        }
        if (this.renderMap != null) {
            startTime = System.currentTimeMillis();
            this.renderMap.draw(gNP, this.atI);
            if (Debug.isSet("timing/MapDraw")) {
                tookTime = System.currentTimeMillis() - startTime;
                System.out.println("timing/MapDraw: " + (double)tookTime * 0.001 + " seconds");
            }
        }
        if (immediate) {
            this.navPanel.drawG();
        } else {
            this.navPanel.repaint();
        }
        gNP.dispose();
        if (Debug.isSet("timing/total")) {
            tookTime = System.currentTimeMillis() - tstart;
            System.out.println("timing.total: " + (double)tookTime * 0.001 + " seconds");
        }
    }

    private synchronized void redrawLater() {
        boolean already = this.redrawTimer.isRunning();
        if (this.debugThread) {
            System.out.println("redrawLater isRunning= " + already);
        }
        if (already) {
            this.redrawTimer.restart();
        } else {
            this.redrawTimer.start();
        }
    }

    public ProjectionManager getProjectionManager() {
        if (null != this.projManager) {
            return this.projManager;
        }
        this.projManager = new ProjectionManager(this.parent, this.store);
        this.projManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("ProjectionImpl")) {
                    ProjectionImpl p = (ProjectionImpl)e.getNewValue();
                    p = p.constructCopy();
                    CoverageDisplay.this.setProjection(p);
                }
            }
        });
        return this.projManager;
    }

    private void addChoosers() {
        this.fieldPanel.removeAll();
        for (int i = 0; i < this.choosers.size(); ++i) {
            Chooser c = this.choosers.get(i);
            if (!c.isWanted) continue;
            this.fieldPanel.add(c.field);
        }
    }

    private void setChooserWanted(String name, boolean want) {
        for (Chooser chooser : this.choosers) {
            if (!chooser.name.equals(name)) continue;
            chooser.isWanted = want;
        }
    }

    private void addToolbarOption(String toolbarName, JToolBar toolbar, AbstractAction act) {
        boolean wantsToolbar = this.store.getBoolean(toolbarName, true);
        if (wantsToolbar) {
            this.toolPanel.add(toolbar);
        }
    }

    private void addActionsToMenus(JMenu datasetMenu, JMenu configMenu, JMenu toolMenu) {
        BAMutil.addActionToMenu(datasetMenu, this.showDatasetInfoAction);
        JMenu toolbarMenu = new JMenu("Toolbars");
        toolbarMenu.setMnemonic('T');
        configMenu.add(toolbarMenu);
        BAMutil.addActionToMenu(toolbarMenu, this.navToolbarAction);
        BAMutil.addActionToMenu(toolbarMenu, this.moveToolbarAction);
        BAMutil.addActionToMenu(configMenu, this.chooseProjectionAction);
        BAMutil.addActionToMenu(configMenu, this.saveCurrentProjectionAction);
        JMenu displayMenu = new JMenu("Display control");
        displayMenu.setMnemonic('D');
        BAMutil.addActionToMenu(displayMenu, this.showGridAction);
        BAMutil.addActionToMenu(displayMenu, this.showContoursAction);
        BAMutil.addActionToMenu(displayMenu, this.showContourLabelsAction);
        BAMutil.addActionToMenu(displayMenu, this.redrawAction);
        toolMenu.add(displayMenu);
        JMenu loopMenu = new JMenu("Loop control");
        loopMenu.setMnemonic('L');
        BAMutil.addActionToMenu(loopMenu, this.fieldLoopAction);
        BAMutil.addActionToMenu(loopMenu, this.levelLoopAction);
        BAMutil.addActionToMenu(loopMenu, this.timeLoopAction);
        toolMenu.add(loopMenu);
        JMenu mmMenu = new JMenu("ColorScale min/max");
        mmMenu.setMnemonic('C');
        BAMutil.addActionToMenu(mmMenu, this.minmaxHorizAction);
        BAMutil.addActionToMenu(mmMenu, this.minmaxLogAction);
        BAMutil.addActionToMenu(mmMenu, this.minmaxHoldAction);
        toolMenu.add(mmMenu);
        JMenu zoomMenu = new JMenu("Zoom/Pan");
        zoomMenu.setMnemonic('Z');
        this.navPanel.addActionsToMenu(zoomMenu);
        toolMenu.add(zoomMenu);
    }

    private class OpenDatasetTask
    extends ProgressMonitorTask
    implements CancelTask {
        ThreddsDataFactory factory = new ThreddsDataFactory();
        InvDataset invds;

        OpenDatasetTask(InvDataset ds) {
            this.invds = ds;
        }

        @Override
        public void run() {
            NetcdfDataset dataset = null;
            CoverageDatasetImpl gridDataset = null;
            Formatter errlog = new Formatter();
            try {
                dataset = this.factory.openDataset(this.invds, true, (CancelTask)this, errlog);
                gridDataset = new CoverageDatasetImpl(dataset, errlog);
            }
            catch (IOException e) {
                this.setError("Failed to open datset: " + errlog);
            }
            boolean bl = this.success = !this.cancel && gridDataset != null;
            if (this.success) {
                CoverageDisplay.this.setDataset(gridDataset);
            }
            this.done = true;
        }
    }

    private class LoopControlAction
    extends AbstractAction {
        SuperComboBox scbox;

        LoopControlAction(SuperComboBox cbox) {
            this.scbox = cbox;
            BAMutil.setActionProperties(this, null, cbox.getName(), false, 0, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.scbox.getLoopControl().show();
        }
    }

    private class Chooser {
        boolean isWanted;
        String name;
        SuperComboBox field;

        Chooser(String name, SuperComboBox field, boolean want) {
            this.name = name;
            this.field = field;
            this.isWanted = want;
        }
    }
}

