/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import ucar.nc2.ui.event.ActionValueEvent;
import ucar.nc2.ui.event.ActionValueListener;
import ucar.nc2.util.ListenerManager;

public class FileBrowser
extends JPanel {
    public static final String APP_TITLE = "FileBro";
    private FileSystemView fileSystemView;
    private File currentFile;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private JTable table;
    private JProgressBar progressBar;
    private FileTableModel fileTableModel;
    private ListSelectionListener listSelectionListener;
    private boolean cellSizesSet = false;
    private int rowIconPadding = 6;
    private JButton openFile;
    private JButton printFile;
    private JButton editFile;
    private JLabel fileName;
    private JTextField path;
    private JLabel date;
    private JLabel size;
    private JCheckBox readable;
    private JCheckBox writable;
    private JCheckBox executable;
    private JRadioButton isDirectory;
    private JRadioButton isFile;
    ListenerManager lm = new ListenerManager("ucar.nc2.ui.event.ActionValueListener", "ucar.nc2.ui.event.ActionValueEvent", "actionPerformed");

    public void setRoot(File rootDir) {
        if (!rootDir.isDirectory()) {
            return;
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        root.setUserObject(rootDir);
        for (File file : rootDir.listFiles()) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(file);
            root.add(node);
        }
        this.treeModel = new DefaultTreeModel(root);
        this.tree.setModel(this.treeModel);
        this.showRootFile();
    }

    public void addActionValueListener(ActionValueListener l) {
        this.lm.addListener(l);
    }

    public FileBrowser() {
        this.makeGui();
    }

    private void makeGui() {
        int ii;
        File[] roots;
        this.setLayout(new BorderLayout(3, 3));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.fileSystemView = FileSystemView.getFileSystemView();
        JPanel detailView = new JPanel(new BorderLayout(3, 3));
        this.table = new JTable();
        this.table.setSelectionMode(0);
        this.table.setAutoCreateRowSorter(true);
        this.table.setShowVerticalLines(false);
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                int row = FileBrowser.this.table.getSelectionModel().getLeadSelectionIndex();
                FileBrowser.this.setFileDetails(((FileTableModel)FileBrowser.this.table.getModel()).getFile(row));
            }
        };
        this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        JScrollPane tableScroll = new JScrollPane(this.table);
        Dimension d = tableScroll.getPreferredSize();
        tableScroll.setPreferredSize(new Dimension((int)d.getWidth(), (int)d.getHeight() / 2));
        detailView.add((Component)tableScroll, "Center");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.treeModel = new DefaultTreeModel(root);
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent tse) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tse.getPath().getLastPathComponent();
                FileBrowser.this.showChildren(node);
                FileBrowser.this.setFileDetails((File)node.getUserObject());
            }
        };
        for (File fileSystemRoot : roots = this.fileSystemView.getRoots()) {
            File[] files;
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(fileSystemRoot);
            root.add(node);
            for (File file : files = this.fileSystemView.getFiles(fileSystemRoot, true)) {
                if (!file.isDirectory()) continue;
                node.add(new DefaultMutableTreeNode(file));
            }
        }
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.addTreeSelectionListener(treeSelectionListener);
        this.tree.setCellRenderer(new FileTreeCellRenderer());
        this.tree.expandRow(0);
        JScrollPane treeScroll = new JScrollPane(this.tree);
        this.tree.setVisibleRowCount(15);
        Dimension preferredSize = treeScroll.getPreferredSize();
        Dimension widePreferred = new Dimension(200, (int)preferredSize.getHeight());
        treeScroll.setPreferredSize(widePreferred);
        JPanel fileMainDetails = new JPanel(new BorderLayout(4, 2));
        fileMainDetails.setBorder(new EmptyBorder(0, 6, 0, 6));
        JPanel fileDetailsLabels = new JPanel(new GridLayout(0, 1, 2, 2));
        fileMainDetails.add((Component)fileDetailsLabels, "West");
        JPanel fileDetailsValues = new JPanel(new GridLayout(0, 1, 2, 2));
        fileMainDetails.add((Component)fileDetailsValues, "Center");
        fileDetailsLabels.add(new JLabel("File", 11));
        this.fileName = new JLabel();
        fileDetailsValues.add(this.fileName);
        fileDetailsLabels.add(new JLabel("Path/name", 11));
        this.path = new JTextField(5);
        this.path.setEditable(false);
        fileDetailsValues.add(this.path);
        fileDetailsLabels.add(new JLabel("Last Modified", 11));
        this.date = new JLabel();
        fileDetailsValues.add(this.date);
        fileDetailsLabels.add(new JLabel("File size", 11));
        this.size = new JLabel();
        fileDetailsValues.add(this.size);
        fileDetailsLabels.add(new JLabel("Type", 11));
        JPanel flags = new JPanel(new FlowLayout(3, 4, 0));
        this.isDirectory = new JRadioButton("Directory");
        flags.add(this.isDirectory);
        this.isFile = new JRadioButton("File");
        flags.add(this.isFile);
        fileDetailsValues.add(flags);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        JButton locateFile = new JButton("Locate");
        locateFile.setMnemonic('l');
        locateFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    System.out.println("Locate: " + FileBrowser.this.currentFile.getParentFile());
                    ActionValueEvent event = new ActionValueEvent(ae.getSource(), "Locate", FileBrowser.this.currentFile.getParentFile());
                    FileBrowser.this.lm.sendEvent(event);
                }
                catch (Throwable t) {
                    FileBrowser.this.showThrowable(t);
                }
                FileBrowser.this.repaint();
            }
        });
        toolBar.add(locateFile);
        this.openFile = new JButton("Open");
        this.openFile.setMnemonic('o');
        this.openFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    System.out.println("Open: " + FileBrowser.this.currentFile);
                    ActionValueEvent event = new ActionValueEvent(ae.getSource(), "Open", FileBrowser.this.currentFile);
                    FileBrowser.this.lm.sendEvent(event);
                }
                catch (Throwable t) {
                    FileBrowser.this.showThrowable(t);
                }
                FileBrowser.this.repaint();
            }
        });
        toolBar.add(this.openFile);
        flags.add(new JLabel("::  Flags"));
        this.readable = new JCheckBox("Read  ");
        this.readable.setMnemonic('a');
        flags.add(this.readable);
        this.writable = new JCheckBox("Write  ");
        this.writable.setMnemonic('w');
        flags.add(this.writable);
        this.executable = new JCheckBox("Execute");
        this.executable.setMnemonic('x');
        flags.add(this.executable);
        int count = fileDetailsLabels.getComponentCount();
        for (ii = 0; ii < count; ++ii) {
            fileDetailsLabels.getComponent(ii).setEnabled(false);
        }
        count = flags.getComponentCount();
        for (ii = 0; ii < count; ++ii) {
            flags.getComponent(ii).setEnabled(false);
        }
        JPanel fileView = new JPanel(new BorderLayout(3, 3));
        fileView.add((Component)toolBar, "North");
        fileView.add((Component)fileMainDetails, "Center");
        detailView.add((Component)fileView, "South");
        JSplitPane splitPane = new JSplitPane(1, treeScroll, detailView);
        this.add((Component)splitPane, "Center");
        JPanel simpleOutput = new JPanel(new BorderLayout(3, 3));
        this.progressBar = new JProgressBar();
        simpleOutput.add((Component)this.progressBar, "East");
        this.progressBar.setVisible(false);
        this.add((Component)simpleOutput, "South");
    }

    public void showRootFile() {
        this.tree.setSelectionInterval(0, 0);
    }

    private void showThrowable(Throwable t) {
        t.printStackTrace();
        JOptionPane.showMessageDialog(this, t.toString(), t.getMessage(), 0);
        this.repaint();
    }

    private void setTableData(final File[] files) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FileBrowser.this.fileTableModel == null) {
                    FileBrowser.this.fileTableModel = new FileTableModel();
                    FileBrowser.this.table.setModel(FileBrowser.this.fileTableModel);
                }
                FileBrowser.this.table.getSelectionModel().removeListSelectionListener(FileBrowser.this.listSelectionListener);
                FileBrowser.this.fileTableModel.setFiles(files);
                FileBrowser.this.table.getSelectionModel().addListSelectionListener(FileBrowser.this.listSelectionListener);
                if (!FileBrowser.this.cellSizesSet) {
                    Icon icon = FileBrowser.this.fileSystemView.getSystemIcon(files[0]);
                    FileBrowser.this.table.setRowHeight(icon.getIconHeight() + FileBrowser.this.rowIconPadding);
                    FileBrowser.this.setColumnWidth(0, -1);
                    FileBrowser.this.setColumnWidth(3, 60);
                    FileBrowser.this.table.getColumnModel().getColumn(3).setMaxWidth(120);
                    FileBrowser.this.setColumnWidth(4, -1);
                    FileBrowser.this.setColumnWidth(5, -1);
                    FileBrowser.this.setColumnWidth(6, -1);
                    FileBrowser.this.setColumnWidth(7, -1);
                    FileBrowser.this.setColumnWidth(8, -1);
                    FileBrowser.this.setColumnWidth(9, -1);
                    FileBrowser.this.cellSizesSet = true;
                }
            }
        });
    }

    private void setColumnWidth(int column, int width) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (width < 0) {
            JLabel label = new JLabel((String)tableColumn.getHeaderValue());
            Dimension preferred = label.getPreferredSize();
            width = (int)preferred.getWidth() + 14;
        }
        tableColumn.setPreferredWidth(width);
        tableColumn.setMaxWidth(width);
        tableColumn.setMinWidth(width);
    }

    private void showChildren(final DefaultMutableTreeNode node) {
        this.tree.setEnabled(false);
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
        SwingWorker<Void, File> worker = new SwingWorker<Void, File>(){

            @Override
            public Void doInBackground() {
                File file = (File)node.getUserObject();
                if (file.isDirectory()) {
                    File[] files = FileBrowser.this.fileSystemView.getFiles(file, true);
                    if (node.isLeaf()) {
                        for (File child : files) {
                            if (!child.isDirectory()) continue;
                            this.publish(child);
                        }
                    }
                    FileBrowser.this.setTableData(files);
                }
                return null;
            }

            @Override
            protected void process(List<File> chunks) {
                for (File child : chunks) {
                    node.add(new DefaultMutableTreeNode(child));
                }
            }

            @Override
            protected void done() {
                FileBrowser.this.progressBar.setIndeterminate(false);
                FileBrowser.this.progressBar.setVisible(false);
                FileBrowser.this.tree.setEnabled(true);
            }
        };
        worker.execute();
    }

    private void setFileDetails(File file) {
        this.currentFile = file;
        Icon icon = this.fileSystemView.getSystemIcon(file);
        this.fileName.setIcon(icon);
        this.fileName.setText(this.fileSystemView.getSystemDisplayName(file));
        this.path.setText(file.getPath());
        this.date.setText(new Date(file.lastModified()).toString());
        this.size.setText(file.length() + " bytes");
        this.readable.setSelected(file.canRead());
        this.writable.setSelected(file.canWrite());
        this.executable.setSelected(file.canExecute());
        this.isDirectory.setSelected(file.isDirectory());
        this.isFile.setSelected(file.isFile());
        JFrame f = (JFrame)this.getTopLevelAncestor();
        if (f != null) {
            f.setTitle("FileBro :: " + this.fileSystemView.getSystemDisplayName(file));
        }
        this.repaint();
    }

    class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -7799441088157759804L;
        private FileSystemView fileSystemView;
        private JLabel label = new JLabel();

        FileTreeCellRenderer() {
            this.label.setOpaque(true);
            this.fileSystemView = FileSystemView.getFileSystemView();
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            File file = (File)node.getUserObject();
            this.label.setIcon(this.fileSystemView.getSystemIcon(file));
            this.label.setText(this.fileSystemView.getSystemDisplayName(file));
            this.label.setToolTipText(file.getPath());
            if (selected) {
                this.label.setBackground(this.backgroundSelectionColor);
                this.label.setForeground(this.textSelectionColor);
            } else {
                this.label.setBackground(this.backgroundNonSelectionColor);
                this.label.setForeground(this.textNonSelectionColor);
            }
            return this.label;
        }
    }

    class FileTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -6101682212645378856L;
        private File[] files;
        private FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        private String[] columns = new String[]{"Icon", "File", "Path/name", "Size", "Last Modified", "R", "W", "E", "D", "F"};

        FileTableModel() {
            this(new File[0]);
        }

        FileTableModel(File[] files) {
            this.files = files;
        }

        @Override
        public Object getValueAt(int row, int column) {
            File file = this.files[row];
            switch (column) {
                case 0: {
                    return this.fileSystemView.getSystemIcon(file);
                }
                case 1: {
                    return this.fileSystemView.getSystemDisplayName(file);
                }
                case 2: {
                    return file.getPath();
                }
                case 3: {
                    return file.length();
                }
                case 4: {
                    return file.lastModified();
                }
                case 5: {
                    return file.canRead();
                }
                case 6: {
                    return file.canWrite();
                }
                case 7: {
                    return file.canExecute();
                }
                case 8: {
                    return file.isDirectory();
                }
                case 9: {
                    return file.isFile();
                }
            }
            System.err.println("Logic Error");
            return "";
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return ImageIcon.class;
                }
                case 3: {
                    return Long.class;
                }
                case 4: {
                    return Date.class;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public int getRowCount() {
            return this.files.length;
        }

        public File getFile(int row) {
            return this.files[row];
        }

        public void setFiles(File[] files) {
            this.files = files;
            this.fireTableDataChanged();
        }
    }
}

