/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.File;
import java.util.Formatter;
import java.util.regex.Pattern;
import net.jcip.annotations.ThreadSafe;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public class CollectionSpecParser {
    private final String spec;
    private final String rootDir;
    private final boolean subdirs;
    private final Pattern filter;
    private final String dateFormatMark;

    public CollectionSpecParser(String collectionSpec, Formatter errlog) {
        int posFilter;
        this.spec = collectionSpec.trim();
        int posGlob = collectionSpec.indexOf("/**/");
        if (posGlob > 0) {
            this.rootDir = collectionSpec.substring(0, posGlob);
            posFilter = posGlob + 3;
            this.subdirs = true;
        } else {
            this.subdirs = false;
            posFilter = collectionSpec.lastIndexOf(47);
            this.rootDir = posFilter > 0 ? collectionSpec.substring(0, posFilter) : System.getProperty("user.dir");
        }
        File locFile = new File(this.rootDir);
        if (!locFile.exists() && errlog != null) {
            errlog.format(" Directory %s does not exist %n", this.rootDir);
        }
        String filter = null;
        if (posFilter < collectionSpec.length() - 2) {
            filter = collectionSpec.substring(posFilter + 1);
        }
        if (filter != null) {
            int posFormat = filter.indexOf(35);
            if (posFormat >= 0) {
                int posFormat2 = filter.lastIndexOf(35);
                if (posFormat != posFormat2) {
                    this.dateFormatMark = filter.substring(0, posFormat2);
                    filter = StringUtil2.remove(filter, 35);
                    StringBuilder sb = new StringBuilder(filter);
                    for (int i = posFormat; i < posFormat2 - 1; ++i) {
                        sb.setCharAt(i, '.');
                    }
                    String regExp = sb.toString();
                    this.filter = Pattern.compile(regExp);
                } else {
                    this.dateFormatMark = filter;
                    String regExp = filter.substring(0, posFormat) + "*";
                    this.filter = Pattern.compile(regExp);
                }
            } else {
                this.dateFormatMark = null;
                this.filter = Pattern.compile(filter);
            }
        } else {
            this.dateFormatMark = null;
            this.filter = null;
        }
    }

    public String getSpec() {
        return this.spec;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public boolean wantSubdirs() {
        return this.subdirs;
    }

    public Pattern getFilter() {
        return this.filter;
    }

    public String getDateFormatMark() {
        return this.dateFormatMark;
    }

    public String toString() {
        return "CollectionSpecParser{\n   topDir='" + this.rootDir + '\'' + "\n   subdirs=" + this.subdirs + "\n   regExp='" + this.filter + '\'' + "\n   dateFormatMark='" + this.dateFormatMark + '\'' + "\n}";
    }

    private static void doit(String spec, Formatter errlog) {
        CollectionSpecParser specp = new CollectionSpecParser(spec, errlog);
        System.out.printf("spec= %s%n%s%n", spec, specp);
        String err = errlog.toString();
        if (err.length() > 0) {
            System.out.printf("%s%n", err);
        }
        System.out.printf("-----------------------------------%n", new Object[0]);
    }

    public static void main(String[] arg) {
        CollectionSpecParser.doit("/data/ldm/pub/native/grid/NCEP/GFS/Alaska_191km/**/GFS_Alaska_191km_#yyyyMMdd_HHmm#\\.grib1$", new Formatter());
        CollectionSpecParser.doit("Q:/grid/grib/grib1/data/agg/.*\\.grb", new Formatter());
        CollectionSpecParser.doit("/data/ldm/pub/decoded/netcdf/surface/metar/**/Surface_METAR_#yyyyMMdd_HHmm#\\.nc", new Formatter());
        CollectionSpecParser.doit("/data/ldm/pub/decoded/netcdf/surface/metar/**/Surface_METAR_#yyyyMMdd_HHmm#.nc", new Formatter());
        CollectionSpecParser.doit("/data/ldm/pub/decoded/netcdf/surface/metar/**/Surface_METAR_#yyyyMMdd_HHmm", new Formatter());
        CollectionSpecParser.doit("/data/ldm/pub/decoded/netcdf/surface/metar/Surface_METAR_#yyyyMMdd_HHmm", new Formatter());
        CollectionSpecParser.doit("/data/ldm/pub/decoded/netcdf/surface/metar/Surface_METAR_#yyyyMMdd_HHmm#.nc", new Formatter());
        CollectionSpecParser.doit("/data/ldm/pub/decoded/netcdf/surface/metar/Surface_METAR_yyyyMMdd_HHmm.nc", new Formatter());
        CollectionSpecParser.doit("/data/ldm/pub/decoded/netcdf/surface/metar/", new Formatter());
        CollectionSpecParser.doit("/data/ldm/pub/decoded/netcdf/surface/metar/**/", new Formatter());
        CollectionSpecParser.doit("/data/ldm/pub/decoded/netcdf/surface/metar/**/*", new Formatter());
        CollectionSpecParser.doit("/data/ldm/pub/decoded/netcdf/surface/metar/*", new Formatter());
        CollectionSpecParser.doit("/data/ldm/pub/decoded/netcdf/surface/metar/T*.T", new Formatter());
    }
}

