/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.writer;

import java.io.IOException;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategy;
import ucar.unidata.io.RandomAccessFile;

public class Grib2NetcdfWriter
implements AutoCloseable {
    String fileIn;
    NetcdfFileWriter writer;
    private static int allOnes = -1;
    private static int mask23 = -1;
    private static int mask19 = -16;
    private static int mask15 = -256;
    private static int mask11 = -4096;
    private static int mask07 = -65536;
    private static int mask03 = -1048576;
    private static int mask00 = -8388608;

    public Grib2NetcdfWriter(String fileIn, String fileOut) throws IOException {
        this.fileIn = fileIn;
        Nc4Chunking chunker = Nc4ChunkingStrategy.factory(Nc4Chunking.Strategy.grib, 9, true);
        this.writer = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf4, fileOut, chunker);
    }

    public void write() throws IOException {
        try (RandomAccessFile raf = RandomAccessFile.acquire(this.fileIn);){
            Grib2RecordScanner scanner = new Grib2RecordScanner(raf);
            while (scanner.hasNext()) {
                Grib2Record gr = scanner.next();
                float[] data = gr.readData(raf);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = Grib2NetcdfWriter.bitShave(data[i], mask11);
                    if (i % 10 != 0) continue;
                    System.out.println();
                }
            }
        }
    }

    public static int getBitMask(int bitN) {
        if (bitN >= 23) {
            return allOnes;
        }
        return allOnes << 23 - bitN;
    }

    public static float bitShave(float value, int bitMask) {
        if (Float.isNaN(value)) {
            return value;
        }
        int bits = Float.floatToRawIntBits(value);
        int shave = bits & bitMask;
        float result = Float.intBitsToFloat(shave);
        return result;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public static void main2(String[] args) {
        String fileIn = "Q:/cdmUnitTest/formats/grib2/ds.mint.bin";
        String fileOut = "C:/tmp/ds.mint.bin";
        try (Grib2NetcdfWriter writer = new Grib2NetcdfWriter(fileIn, fileOut);){
            writer.write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < 24; ++i) {
            System.out.printf("%d == %8d == 0x%s == 0x%s%n", i, Grib2NetcdfWriter.getBitMask(i), Integer.toHexString(Grib2NetcdfWriter.getBitMask(i)), Integer.toBinaryString(Grib2NetcdfWriter.getBitMask(i)));
        }
    }
}

