/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.LegacyQTTools;
import loci.formats.Location;
import loci.formats.MetadataStore;
import loci.formats.ReflectException;
import loci.formats.ReflectedUniverse;

public class LegacyQTReader
extends FormatReader {
    protected LegacyQTTools tools;
    protected ReflectedUniverse r;
    protected int[] times;
    protected Image image;

    public LegacyQTReader() {
        super("QuickTime", "mov");
    }

    public LegacyQTReader(Hashtable idMap) {
        super("QuickTime", "mov");
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        buf = ImageTools.getBytes(this.openImage(no), false, 3);
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        try {
            this.r.setVar("time", this.times[no]);
            this.r.exec("moviePlayer.setTime(time)");
            this.r.exec("qtip.redraw(null)");
            this.r.exec("qtip.updateConsumers(null)");
        }
        catch (ReflectException re) {
            throw new FormatException("Open movie failed", re);
        }
        return ImageTools.makeBuffered(this.image);
    }

    public void close(boolean fileOnly) throws IOException {
        try {
            if (this.r.getVar("openMovieFile") != null) {
                this.r.exec("openMovieFile.close()");
                if (!fileOnly) {
                    this.r.exec("m.disposeQTObject()");
                    this.r.exec("imageTrack.disposeQTObject()");
                    this.r.exec("QTSession.close()");
                }
            }
        }
        catch (ReflectException e) {
            IOException io = new IOException("Close movie failed");
            io.initCause(e);
            throw io;
        }
        if (!fileOnly) {
            this.currentId = null;
        }
    }

    public void close() throws IOException {
        this.close(false);
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("LegacyQTReader.initFile(" + id + ")");
        }
        this.status("Checking for QuickTime Java");
        if (this.tools == null) {
            this.tools = new LegacyQTTools();
            this.r = this.tools.getUniverse();
        }
        if (this.tools.isQTExpired()) {
            throw new FormatException("Your version of QuickTime for Java has expired. Please reinstall QuickTime for Java from http://www.apple.com/quicktime/");
        }
        if (!this.tools.canDoQT()) {
            throw new FormatException("QuickTime for Java is required to read some QuickTime files. Please install QuickTime for Java from http://www.apple.com/quicktime/");
        }
        super.initFile(id);
        this.status("Reading movie dimensions");
        try {
            Integer w;
            this.r.exec("QTSession.open()");
            Location file = new Location(id);
            this.r.setVar("path", file.getAbsolutePath());
            this.r.exec("qtf = new QTFile(path)");
            this.r.exec("openMovieFile = OpenMovieFile.asRead(qtf)");
            this.r.exec("m = Movie.fromFile(openMovieFile)");
            int numTracks = (Integer)this.r.exec("m.getTrackCount()");
            int trackMostLikely = 0;
            int trackNum = 0;
            while (++trackNum <= numTracks && trackMostLikely == 0) {
                this.r.setVar("trackNum", trackNum);
                this.r.exec("imageTrack = m.getTrack(trackNum)");
                this.r.exec("d = imageTrack.getSize()");
                w = (Integer)this.r.exec("d.getWidth()");
                if (w <= 0) continue;
                trackMostLikely = trackNum;
            }
            this.r.setVar("trackMostLikely", trackMostLikely);
            this.r.exec("imageTrack = m.getTrack(trackMostLikely)");
            this.r.exec("d = imageTrack.getSize()");
            w = (Integer)this.r.exec("d.getWidth()");
            Integer h2 = (Integer)this.r.exec("d.getHeight()");
            this.r.exec("moviePlayer = new MoviePlayer(m)");
            this.r.setVar("dim", new Dimension(w, h2));
            ImageProducer qtip = (ImageProducer)this.r.exec("qtip = new QTImageProducer(moviePlayer, dim)");
            this.image = Toolkit.getDefaultToolkit().createImage(qtip);
            this.r.setVar("zero", 0);
            this.r.setVar("one", 1.0f);
            this.r.exec("timeInfo = new TimeInfo(zero, zero)");
            this.r.exec("moviePlayer.setTime(zero)");
            Vector<Integer> v = new Vector<Integer>();
            int time = 0;
            Integer q = new Integer(time);
            do {
                v.add(q);
                this.r.exec("timeInfo = imageTrack.getNextInterestingTime(StdQTConstants.nextTimeMediaSample, timeInfo.time, one)");
            } while ((time = (q = (Integer)this.r.getVar("timeInfo.time")).intValue()) >= 0);
            this.core.imageCount[0] = v.size();
            this.times = new int[this.core.imageCount[0]];
            for (int i = 0; i < this.times.length; ++i) {
                q = (Integer)v.elementAt(i);
                this.times[i] = q;
            }
            this.status("Populating metadata");
            BufferedImage img = ImageTools.makeBuffered(this.image);
            this.core.sizeX[0] = img.getWidth();
            this.core.sizeY[0] = img.getHeight();
            this.core.sizeZ[0] = 1;
            this.core.sizeC[0] = img.getRaster().getNumBands();
            this.core.sizeT[0] = this.core.imageCount[0];
            this.core.pixelType[0] = ImageTools.getPixelType(img);
            this.core.currentOrder[0] = "XYCTZ";
            this.core.rgb[0] = true;
            this.core.interleaved[0] = false;
            this.core.littleEndian[0] = false;
            this.core.indexed[0] = false;
            this.core.falseColor[0] = false;
            MetadataStore store = this.getMetadataStore();
            store.setImage(this.currentId, null, null, null);
            FormatTools.populatePixels(store, this);
            for (int i = 0; i < this.core.sizeC[0]; ++i) {
                store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
            }
        }
        catch (ReflectException e) {
            throw new FormatException("Open movie failed", e);
        }
    }
}

