/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Timestamp;
import java.nio.ByteBuffer;
import java.util.Calendar;

public class CheckpointEnd
implements Loggable {
    private static final byte ROOT_LSN_MASK = 1;
    private static final byte CLEANED_FILES_MASK = 2;
    private String invoker;
    private Timestamp endTime;
    private long checkpointStartLsn;
    private boolean rootLsnExists;
    private long rootLsn;
    private long firstActiveLsn;
    private long lastLocalNodeId;
    private long lastReplicatedNodeId;
    private long lastLocalDbId;
    private long lastReplicatedDbId;
    private long lastLocalTxnId;
    private long lastReplicatedTxnId;
    private long lastLocalExtinctionId;
    private long lastReplicatedExtinctionId;
    private long id;
    private boolean cleanedFilesToDelete;

    public CheckpointEnd(String invoker, long checkpointStartLsn, long rootLsn, long firstActiveLsn, long lastLocalNodeId, long lastReplicatedNodeId, long lastLocalDbId, long lastReplicatedDbId, long lastLocalTxnId, long lastReplicatedTxnId, long lastLocalExtinctionId, long lastReplicatedExtinctionId, long id, boolean cleanedFilesToDelete) {
        this.invoker = invoker == null ? "" : invoker;
        Calendar cal = Calendar.getInstance();
        this.endTime = new Timestamp(cal.getTime().getTime());
        this.checkpointStartLsn = checkpointStartLsn;
        this.rootLsn = rootLsn;
        this.rootLsnExists = rootLsn != -1L;
        this.firstActiveLsn = firstActiveLsn == -1L ? checkpointStartLsn : firstActiveLsn;
        this.lastLocalNodeId = lastLocalNodeId;
        this.lastReplicatedNodeId = lastReplicatedNodeId;
        this.lastLocalDbId = lastLocalDbId;
        this.lastReplicatedDbId = lastReplicatedDbId;
        this.lastLocalTxnId = lastLocalTxnId;
        this.lastReplicatedTxnId = lastReplicatedTxnId;
        this.lastLocalExtinctionId = lastLocalExtinctionId;
        this.lastReplicatedExtinctionId = lastReplicatedExtinctionId;
        this.id = id;
        this.cleanedFilesToDelete = cleanedFilesToDelete;
    }

    public CheckpointEnd() {
        this.checkpointStartLsn = -1L;
        this.rootLsn = -1L;
        this.firstActiveLsn = -1L;
    }

    public String getInvoker() {
        return this.invoker;
    }

    @Override
    public int getLogSize() {
        int size = LogUtils.getStringLogSize(this.invoker) + LogUtils.getTimestampLogSize(this.endTime) + LogUtils.getPackedLongLogSize(this.checkpointStartLsn) + 1 + LogUtils.getPackedLongLogSize(this.firstActiveLsn) + LogUtils.getPackedLongLogSize(this.lastLocalNodeId) + LogUtils.getPackedLongLogSize(this.lastReplicatedNodeId) + LogUtils.getPackedLongLogSize(this.lastLocalDbId) + LogUtils.getPackedLongLogSize(this.lastReplicatedDbId) + LogUtils.getPackedLongLogSize(this.lastLocalTxnId) + LogUtils.getPackedLongLogSize(this.lastReplicatedTxnId) + LogUtils.getPackedLongLogSize(this.lastLocalExtinctionId) + LogUtils.getPackedLongLogSize(this.lastReplicatedExtinctionId) + LogUtils.getPackedLongLogSize(this.id);
        if (this.rootLsnExists) {
            size += LogUtils.getPackedLongLogSize(this.rootLsn);
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeString(logBuffer, this.invoker);
        LogUtils.writeTimestamp(logBuffer, this.endTime);
        LogUtils.writePackedLong(logBuffer, this.checkpointStartLsn);
        byte flags = 0;
        if (this.rootLsnExists) {
            flags = (byte)(flags | 1);
        }
        if (this.cleanedFilesToDelete) {
            flags = (byte)(flags | 2);
        }
        logBuffer.put(flags);
        if (this.rootLsnExists) {
            LogUtils.writePackedLong(logBuffer, this.rootLsn);
        }
        LogUtils.writePackedLong(logBuffer, this.firstActiveLsn);
        LogUtils.writePackedLong(logBuffer, this.lastLocalNodeId);
        LogUtils.writePackedLong(logBuffer, this.lastReplicatedNodeId);
        LogUtils.writePackedLong(logBuffer, this.lastLocalDbId);
        LogUtils.writePackedLong(logBuffer, this.lastReplicatedDbId);
        LogUtils.writePackedLong(logBuffer, this.lastLocalTxnId);
        LogUtils.writePackedLong(logBuffer, this.lastReplicatedTxnId);
        LogUtils.writePackedLong(logBuffer, this.lastLocalExtinctionId);
        LogUtils.writePackedLong(logBuffer, this.lastReplicatedExtinctionId);
        LogUtils.writePackedLong(logBuffer, this.id);
    }

    @Override
    public void readFromLog(ByteBuffer logBuffer, int entryVersion) {
        boolean version6OrLater = entryVersion >= 6;
        this.invoker = LogUtils.readString(logBuffer, !version6OrLater, entryVersion);
        this.endTime = LogUtils.readTimestamp(logBuffer, !version6OrLater);
        this.checkpointStartLsn = LogUtils.readLong(logBuffer, !version6OrLater);
        byte flags = logBuffer.get();
        boolean bl = this.rootLsnExists = (flags & 1) != 0;
        if (this.rootLsnExists) {
            this.rootLsn = LogUtils.readLong(logBuffer, !version6OrLater);
        }
        this.cleanedFilesToDelete = entryVersion >= 7 ? (flags & 2) != 0 : true;
        this.firstActiveLsn = LogUtils.readLong(logBuffer, !version6OrLater);
        this.lastLocalNodeId = LogUtils.readLong(logBuffer, !version6OrLater);
        if (version6OrLater) {
            this.lastReplicatedNodeId = LogUtils.readPackedLong(logBuffer);
        }
        if (version6OrLater) {
            this.lastLocalDbId = LogUtils.readPackedLong(logBuffer);
            this.lastReplicatedDbId = LogUtils.readPackedLong(logBuffer);
        } else {
            this.lastLocalDbId = LogUtils.readInt(logBuffer);
        }
        this.lastLocalTxnId = LogUtils.readLong(logBuffer, !version6OrLater);
        if (version6OrLater) {
            this.lastReplicatedTxnId = LogUtils.readPackedLong(logBuffer);
        }
        if (entryVersion >= 17) {
            this.lastLocalExtinctionId = LogUtils.readPackedLong(logBuffer);
            this.lastReplicatedExtinctionId = LogUtils.readPackedLong(logBuffer);
        }
        this.id = LogUtils.readLong(logBuffer, !version6OrLater);
        if (entryVersion >= 8 && entryVersion <= 10) {
            LogUtils.readPackedLong(logBuffer);
            LogUtils.readPackedInt(logBuffer);
            int nAvgLNSizes = LogUtils.readPackedInt(logBuffer);
            for (int i = 0; i < nAvgLNSizes; ++i) {
                LogUtils.readPackedInt(logBuffer);
                LogUtils.readPackedInt(logBuffer);
                LogUtils.readPackedInt(logBuffer);
                LogUtils.readPackedInt(logBuffer);
            }
        }
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<CkptEnd invoker=\"").append(this.invoker);
        sb.append("\" time=\"").append(this.endTime);
        sb.append("\" lastLocalNodeId=\"").append(this.lastLocalNodeId);
        sb.append("\" lastReplicatedNodeId=\"").append(this.lastReplicatedNodeId);
        sb.append("\" lastLocalDbId=\"").append(this.lastLocalDbId);
        sb.append("\" lastReplicatedDbId=\"").append(this.lastReplicatedDbId);
        sb.append("\" lastLocalTxnId=\"").append(this.lastLocalTxnId);
        sb.append("\" lastReplicatedTxnId=\"").append(this.lastReplicatedTxnId);
        sb.append("\" lastLocalExtinctionId=\"").append(this.lastLocalExtinctionId);
        sb.append("\" lastReplicatedExtinctionId=\"").append(this.lastReplicatedExtinctionId);
        sb.append("\" id=\"").append(this.id);
        sb.append("\" rootExists=\"").append(this.rootLsnExists);
        sb.append("\">");
        sb.append("<ckptStart>");
        sb.append(DbLsn.toString(this.checkpointStartLsn));
        sb.append("</ckptStart>");
        if (this.rootLsnExists) {
            sb.append("<root>");
            sb.append(DbLsn.toString(this.rootLsn));
            sb.append("</root>");
        }
        sb.append("<firstActive>");
        sb.append(DbLsn.toString(this.firstActiveLsn));
        sb.append("</firstActive>");
        sb.append("</CkptEnd>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("time=").append(this.endTime);
        sb.append(" lastLocalNodeId=").append(this.lastLocalNodeId);
        sb.append(" lastReplicatedNodeId=").append(this.lastReplicatedNodeId);
        sb.append(" lastLocalDbId=").append(this.lastLocalDbId);
        sb.append(" lastReplicatedDbId=").append(this.lastReplicatedDbId);
        sb.append(" lastLocalTxnId=").append(this.lastLocalTxnId);
        sb.append(" lastReplicatedTxnId=").append(this.lastReplicatedTxnId);
        sb.append(" lastLocalExtinctionId=").append(this.lastLocalExtinctionId);
        sb.append(" lastReplicatedExtinctionId=").append(this.lastReplicatedExtinctionId);
        sb.append(" id=").append(this.id);
        sb.append(" rootExists=").append(this.rootLsnExists);
        sb.append(" ckptStartLsn=").append(DbLsn.getNoFormatString(this.checkpointStartLsn));
        if (this.rootLsnExists) {
            sb.append(" root=").append(DbLsn.getNoFormatString(this.rootLsn));
        }
        sb.append(" firstActive=").append(DbLsn.getNoFormatString(this.firstActiveLsn));
        return sb.toString();
    }

    long getCheckpointStartLsn() {
        return this.checkpointStartLsn;
    }

    long getRootLsn() {
        return this.rootLsn;
    }

    long getFirstActiveLsn() {
        return this.firstActiveLsn;
    }

    long getLastLocalNodeId() {
        return this.lastLocalNodeId;
    }

    long getLastReplicatedNodeId() {
        return this.lastReplicatedNodeId;
    }

    long getLastLocalDbId() {
        return this.lastLocalDbId;
    }

    long getLastReplicatedDbId() {
        return this.lastReplicatedDbId;
    }

    long getLastLocalTxnId() {
        return this.lastLocalTxnId;
    }

    long getLastReplicatedTxnId() {
        return this.lastReplicatedTxnId;
    }

    long getLastLocalExtinctionId() {
        return this.lastLocalExtinctionId;
    }

    long getLastReplicatedExtinctionId() {
        return this.lastReplicatedExtinctionId;
    }

    public long getId() {
        return this.id;
    }

    public boolean getCleanedFilesToDelete() {
        return this.cleanedFilesToDelete;
    }
}

