/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import ucar.httpservices.HTTPSession;

public abstract class HTTPUtil {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset ASCII = Charset.forName("US-ASCII");

    static byte[] readbinaryfile(InputStream stream) throws IOException {
        int cnt;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] tmp = new byte[65536];
        while ((cnt = stream.read(tmp)) > 0) {
            bytes.write(tmp, 0, cnt);
        }
        return bytes.toByteArray();
    }

    public static File fillTempFile(String base, String content) throws IOException {
        File tmpdir;
        String tmppath = System.getenv("TEMP");
        if (tmppath == null || tmppath.length() == 0) {
            tmppath = "/tmp";
        }
        if (!(tmpdir = new File(tmppath)).exists() || !tmpdir.canWrite()) {
            throw new IOException("Cannot create temp file: no tmp dir");
        }
        try {
            int index = base.lastIndexOf(46);
            if (index < 0) {
                index = base.length();
            }
            String suffix = base.substring(index, base.length());
            String prefix = base.substring(0, index);
            if (prefix.length() == 0) {
                throw new IOException("Malformed base: " + base);
            }
            File f = File.createTempFile(prefix, suffix, tmpdir);
            FileOutputStream fw = new FileOutputStream(f);
            fw.write(content.getBytes(UTF8));
            fw.close();
            return f;
        }
        catch (IOException e) {
            throw new IOException("Cannot create temp file", e);
        }
    }

    static boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    static boolean schemeEquals(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null ^ s2 == null) {
            return false;
        }
        if (s1.length() == 0 ^ s2.length() == 0) {
            return true;
        }
        return s1.equals(s2);
    }

    public static URI parseToURI(String u) throws URISyntaxException {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < u.length()) {
            char c;
            if ((c = u.charAt(i++)) == '\\') {
                if (i + 1 == u.length()) {
                    throw new URISyntaxException(u, "Trailing '' at end of url");
                }
                buf.append("%5c");
                c = u.charAt(i++);
                buf.append(String.format("%%%02x", c));
                continue;
            }
            buf.append(c);
        }
        return new URI(buf.toString());
    }

    static URI uriExclude(URI uri, URIPart ... excludes) {
        URIBuilder urib = new URIBuilder();
        EnumSet<URIPart[]> set = EnumSet.of(excludes[0], excludes);
        block11: for (URIPart part : URIPart.values()) {
            if (set.contains((Object)part)) continue;
            switch (part) {
                case SCHEME: {
                    urib.setScheme(uri.getScheme());
                    continue block11;
                }
                case USERINFO: {
                    urib.setUserInfo(uri.getUserInfo());
                    continue block11;
                }
                case HOST: {
                    urib.setHost(uri.getHost());
                    continue block11;
                }
                case PORT: {
                    urib.setPort(uri.getPort());
                    continue block11;
                }
                case PATH: {
                    urib.setPath(uri.getPath());
                    continue block11;
                }
                case QUERY: {
                    urib.setCustomQuery(uri.getQuery());
                    continue block11;
                }
                case FRAGMENT: {
                    urib.setFragment(uri.getFragment());
                }
            }
        }
        try {
            return urib.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected static HTTPSession.Settings merge(HTTPSession.Settings globalsettings, HTTPSession.Settings localsettings) {
        HTTPSession.Settings merge = new HTTPSession.Settings();
        for (String key : globalsettings.getKeys()) {
            merge.setParameter(key, globalsettings.getParameter(key));
        }
        for (String key : localsettings.getKeys()) {
            merge.setParameter(key, localsettings.getParameter(key));
        }
        return merge;
    }

    static String nullify(String s) {
        if (s != null && s.length() == 0) {
            s = null;
        }
        return s;
    }

    String joinList(List<String> list, String delim) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                buf.append(delim);
            }
            buf.append(list.get(i));
        }
        return buf.toString();
    }

    public static String canonicalpath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.replace('\\', '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    static class ContentEncodingInterceptor
    extends InterceptCommon
    implements HttpResponseInterceptor {
        ContentEncodingInterceptor() {
        }

        @Override
        public synchronized void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity;
            String value;
            if (response == null) {
                return;
            }
            Header[] hdrs = response.getAllHeaders();
            if (hdrs == null) {
                return;
            }
            boolean modified = false;
            for (int i = 0; i < hdrs.length; ++i) {
                Header h = hdrs[i];
                if (!h.getName().equalsIgnoreCase("content-encoding") || !(value = h.getValue()).trim().toLowerCase().endsWith("-endian")) continue;
                hdrs[i] = new BasicHeader("X-Content-Encoding", value);
                modified = true;
            }
            if (modified) {
                response.setHeaders(hdrs);
            }
            if ((entity = response.getEntity()) != null && (ceheader = entity.getContentEncoding()) != null && (value = ceheader.getValue()).trim().toLowerCase().endsWith("-endian")) {
                boolean bl = false;
            }
        }
    }

    public static class InterceptRequest
    extends InterceptCommon
    implements HttpRequestInterceptor {
        @Override
        public synchronized void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            this.request = request;
            this.context = context;
            if (this.printheaders) {
                this.printHeaders();
            } else if (this.request != null) {
                Header[] hdrs = this.request.getAllHeaders();
                for (int i = 0; i < hdrs.length; ++i) {
                    this.headers.add(hdrs[i]);
                }
            }
        }
    }

    public static class InterceptResponse
    extends InterceptCommon
    implements HttpResponseInterceptor {
        @Override
        public synchronized void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            this.response = response;
            this.context = context;
            if (this.printheaders) {
                this.printHeaders();
            } else if (this.response != null) {
                Header[] hdrs = this.response.getAllHeaders();
                for (int i = 0; i < hdrs.length; ++i) {
                    this.headers.add(hdrs[i]);
                }
            }
        }
    }

    static abstract class InterceptCommon {
        protected HttpContext context = null;
        protected List<Header> headers = new ArrayList<Header>();
        protected HttpRequest request = null;
        protected HttpResponse response = null;
        protected boolean printheaders = false;

        InterceptCommon() {
        }

        public InterceptCommon setPrint(boolean tf) {
            this.printheaders = tf;
            return this;
        }

        public void clear() {
            this.context = null;
            this.headers.clear();
            this.request = null;
            this.response = null;
        }

        synchronized HttpRequest getRequest() {
            return this.request;
        }

        synchronized HttpResponse getResponse() {
            return this.response;
        }

        synchronized HttpContext getContext() {
            return this.context;
        }

        public synchronized HttpEntity getRequestEntity() {
            if (this.request != null && this.request instanceof HttpEntityEnclosingRequest) {
                return ((HttpEntityEnclosingRequest)this.request).getEntity();
            }
            return null;
        }

        synchronized HttpEntity getResponseEntity() {
            if (this.response != null) {
                return this.response.getEntity();
            }
            return null;
        }

        public synchronized List<Header> getHeaders(String key) {
            ArrayList<Header> keyh = new ArrayList<Header>();
            for (Header h : this.headers) {
                if (!h.getName().equalsIgnoreCase(key.trim())) continue;
                keyh.add(h);
            }
            return keyh;
        }

        synchronized List<Header> getHeaders() {
            return this.headers;
        }

        void printHeaders() {
            Header[] hdrs;
            if (this.request != null) {
                hdrs = this.request.getAllHeaders();
                if (hdrs == null) {
                    hdrs = new Header[]{};
                }
                System.err.println("Request Headers:");
                for (Header h : hdrs) {
                    System.err.println(h.toString());
                }
            }
            if (this.response != null) {
                hdrs = this.response.getAllHeaders();
                if (hdrs == null) {
                    hdrs = new Header[]{};
                }
                System.err.println("Response Headers:");
                for (Header h : hdrs) {
                    System.err.println(h.toString());
                }
            }
            System.err.flush();
        }
    }

    static enum URIPart {
        SCHEME,
        USERINFO,
        HOST,
        PORT,
        PATH,
        QUERY,
        FRAGMENT;

    }
}

