/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.BackupArchiveLocation;
import com.sleepycat.je.BackupFileCopy;
import com.sleepycat.je.cleaner.EraserAbortException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.SnapshotManifest;
import com.sleepycat.je.util.DbBackup;
import com.sleepycat.je.utilint.CronScheduleParser;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.URL;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BackupManager {
    public static volatile long timeMultiplier = Long.getLong("com.sleepycat.je.test.timeMultiplier", 0L);
    static volatile TestHook<Path> createSnapshotHook = null;
    static volatile TestHook<Path> saveManifestHook = null;
    static volatile TestHook<Void> writeSnapshotInfoHook = null;
    static volatile TestHook<SnapshotManifest> copySnapshotFileHook = null;
    private static final String SNAPSHOT_SUBDIRECTORY = "snapshots";
    private static final String SNAPSHOT_INFO = "snapInfo.properties";
    static final Pattern SNAPSHOT_PATTERN = Pattern.compile("\\d\\d[01][0-9][0-3][0-9][0-2]\\d");
    private static final String SNAPSHOT_COMPLETE = "snapComplete";
    public static final String SNAPSHOT_MANIFEST = "manifest.json";
    private static final int SOFT_SHUTDOWN_WAIT_MS = 3000;
    private static final long INITIAL_RETRY_WAIT_MS = 1000L;
    private static final long MAX_RETRY_WAIT_MS = 3600000L;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    private static final Calendar utcCalendar;
    private final EnvironmentImpl envImpl;
    private final Path envHomeDir;
    private final String nodeName;
    private final Logger logger;
    private volatile boolean runBackup;
    private volatile String backupSchedule;
    private volatile String backupCopyClass;
    private volatile File backupCopyConfig;
    private volatile BackupFileCopy backupCopy;
    private volatile String backupLocationClass;
    private volatile File backupLocationConfig;
    private volatile BackupArchiveLocation backupLocation;
    private volatile boolean shutdownRequested;
    private volatile SnapshotTimeInfo snapshotTimeInfo;
    private volatile SnapshotThread snapshotThread;
    private volatile CopyThread copyThread;

    public BackupManager(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.envHomeDir = Paths.get(envImpl.getEnvironmentHome().getPath(), new String[0]);
        this.nodeName = BackupManager.getNodeName(envImpl);
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.init();
    }

    private synchronized void init() {
        DbConfigManager configManager = this.envImpl.getConfigManager();
        this.runBackup = configManager.getBoolean(EnvironmentParams.ENV_RUN_BACKUP);
        this.backupSchedule = configManager.get(EnvironmentParams.BACKUP_SCHEDULE);
        this.backupCopyClass = configManager.get(EnvironmentParams.BACKUP_COPY_CLASS);
        this.backupCopyConfig = new File(configManager.get(EnvironmentParams.BACKUP_COPY_CONFIG));
        this.backupLocationClass = configManager.get(EnvironmentParams.BACKUP_LOCATION_CLASS);
        this.backupLocationConfig = new File(configManager.get(EnvironmentParams.BACKUP_LOCATION_CONFIG));
        if (timeMultiplier != 0L) {
            LoggerUtils.info(this.logger, this.envImpl, "Creating snapshots using time multiplier: " + timeMultiplier);
        }
    }

    synchronized void startThreads() {
        if (this.runBackup && this.snapshotThread == null) {
            this.snapshotThread = new SnapshotThread(this.envImpl);
            this.snapshotThread.start();
        }
    }

    private synchronized BackupFileCopy getBackupCopy() throws IOException, InterruptedException {
        if (this.backupCopy == null) {
            BackupFileCopy inst = BackupManager.getImplementationInstance(BackupFileCopy.class, this.backupCopyClass);
            inst.initialize(this.backupCopyConfig);
            this.backupCopy = inst;
        }
        return this.backupCopy;
    }

    private synchronized BackupArchiveLocation getBackupLocation() throws IOException, InterruptedException {
        if (this.backupLocation == null) {
            BackupArchiveLocation inst = BackupManager.getImplementationInstance(BackupArchiveLocation.class, this.backupLocationClass);
            inst.initialize(this.nodeName, this.backupLocationConfig);
            this.backupLocation = inst;
        }
        return this.backupLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initiateSoftShutdown() {
        BackupManager backupManager = this;
        synchronized (backupManager) {
            if (this.shutdownRequested) {
                return;
            }
            this.shutdownRequested = true;
        }
        if (this.snapshotThread != null) {
            this.snapshotThread.initiateSoftShutdown();
        }
        if (this.copyThread != null) {
            this.copyThread.initiateSoftShutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownThreads() {
        BackupManager backupManager = this;
        synchronized (backupManager) {
            this.shutdownRequested = true;
        }
        if (this.snapshotThread != null) {
            this.snapshotThread.shutdown();
        }
        if (this.copyThread != null) {
            this.copyThread.shutdown();
        }
    }

    boolean getShutdownRequested() {
        return this.shutdownRequested;
    }

    StoppableThread getSnapshotThread() {
        return this.snapshotThread;
    }

    StoppableThread getCopyThread() {
        return this.copyThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CronScheduleParser createSnapshotScheduleParser(String cronSchedule) {
        if (!cronSchedule.startsWith("0")) {
            throw new IllegalArgumentException("Schedule must start with '0': " + cronSchedule);
        }
        Calendar calendar = utcCalendar;
        synchronized (calendar) {
            utcCalendar.setTimeInMillis(BackupManager.currentTimeMs());
            return new CronScheduleParser(cronSchedule, utcCalendar);
        }
    }

    private void createNextSnapshot() throws IOException, InterruptedException {
        Path snapshotsSubdir = this.envHomeDir.resolve(SNAPSHOT_SUBDIRECTORY);
        if (Files.notExists(snapshotsSubdir, new LinkOption[0])) {
            Files.createDirectory(snapshotsSubdir, new FileAttribute[0]);
        }
        this.updateSnapshotTimeInfo();
        Path snapshotDir = this.getSnapshotDir(this.snapshotTimeInfo.previous);
        if (!this.isSnapshotComplete(snapshotDir)) {
            this.deleteSnapshot(snapshotDir);
            this.createSnapshot(snapshotDir);
        }
        this.wakeUpCopyThread();
    }

    private synchronized void updateSnapshotTimeInfo() {
        this.snapshotTimeInfo = this.snapshotTimeInfo == null ? new SnapshotTimeInfo(this.backupSchedule) : this.snapshotTimeInfo.update(this.backupSchedule);
    }

    private Path getSnapshotDir(long timeMs) {
        return BackupManager.getSnapshotDir(timeMs, this.envHomeDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path getSnapshotDir(long timeMs, Path envHomeDir) {
        String snap;
        Calendar calendar = utcCalendar;
        synchronized (calendar) {
            utcCalendar.setTimeInMillis(timeMs);
            snap = String.format("%02d%02d%02d%02d", utcCalendar.get(1) % 100, utcCalendar.get(2) + 1, utcCalendar.get(5), utcCalendar.get(11));
        }
        return envHomeDir.resolve(Paths.get(SNAPSHOT_SUBDIRECTORY, snap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getSnapshotTimeMs(String snapshot) {
        if (snapshot.length() != 8) {
            throw new IllegalArgumentException("Wrong length for snapshot: '" + snapshot + "'");
        }
        int year = Integer.valueOf(snapshot.substring(0, 2));
        int month = Integer.valueOf(snapshot.substring(2, 4));
        int day = Integer.valueOf(snapshot.substring(4, 6));
        int hour = Integer.valueOf(snapshot.substring(6, 8));
        Calendar calendar = utcCalendar;
        synchronized (calendar) {
            utcCalendar.setTimeInMillis(BackupManager.currentTimeMs());
            int century = 100 * (utcCalendar.get(1) / 100);
            try {
                utcCalendar.set(1, year + century);
                utcCalendar.set(2, month - 1);
                utcCalendar.set(5, day);
                utcCalendar.set(11, hour);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Bad format for snapshot: '" + snapshot + "': " + e.getMessage(), e);
            }
            return utcCalendar.getTimeInMillis();
        }
    }

    private boolean isSnapshotComplete(Path snapshotDir) {
        return Files.exists(snapshotDir.resolve(SNAPSHOT_COMPLETE), new LinkOption[0]);
    }

    private void createSnapshot(Path snapshotDir) throws IOException, InterruptedException {
        if (this.logger.isLoggable(Level.FINE)) {
            LoggerUtils.fine(this.logger, this.envImpl, "Creating snapshot: " + snapshotDir.getFileName() + ", now: " + BackupManager.formatTime(BackupManager.currentTimeMs()));
        }
        long startTimeMs = BackupManager.currentTimeMs();
        assert (TestHookExecute.doHookIfSet(createSnapshotHook, snapshotDir));
        assert (TestHookExecute.doIOHookIfSet(createSnapshotHook));
        try {
            Files.createDirectory(snapshotDir, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            throw new IllegalStateException("Snapshot directory should not already exist: " + snapshotDir, e);
        }
        DbBackup dbBackup = new DbBackup(this.envImpl);
        dbBackup.startBackup();
        try {
            String[] logFiles;
            long backupStartTimeMs = BackupManager.currentTimeMs() + 1000L;
            this.writeSnapshotInfo(backupStartTimeMs, snapshotDir);
            for (String logFile : logFiles = dbBackup.getLogFilesInSnapshot()) {
                Path logFilePath = Paths.get(logFile, new String[0]);
                Files.createLink(snapshotDir.resolve(logFilePath.getFileName()), this.envHomeDir.resolve(logFilePath));
            }
            BackupManager.forceFile(snapshotDir);
            Files.createFile(snapshotDir.resolve(SNAPSHOT_COMPLETE), new FileAttribute[0]);
            BackupManager.forceFile(snapshotDir);
            long startWaitTime = Math.max(backupStartTimeMs - BackupManager.currentTimeMs(), 0L);
            if (startWaitTime > 0L) {
                BackupManager.sleepMs(startWaitTime);
            }
            long creationTimeMs = BackupManager.currentTimeMs() - startTimeMs;
            LoggerUtils.info(this.logger, this.envImpl, "Created snapshot: " + snapshotDir.getFileName() + ", number of log files: " + logFiles.length + ", creation time: " + creationTimeMs + " ms, start wait time: " + startWaitTime + " ms");
        }
        catch (FileAlreadyExistsException e) {
            throw new IllegalStateException("Snapshot directory should not already contain file: " + e.getFile(), e);
        }
        finally {
            dbBackup.endBackup();
        }
    }

    public static void forceFile(Path path) throws IOException {
        try (FileChannel channel = FileChannel.open(path, new OpenOption[0]);){
            channel.force(true);
        }
    }

    private synchronized void wakeUpCopyThread() {
        if (this.shutdownRequested) {
            return;
        }
        LoggerUtils.fine(this.logger, this.envImpl, "Waking up snapshot copy thread");
        if (this.copyThread == null) {
            this.copyThread = new CopyThread(this.envImpl);
            this.copyThread.start();
        } else {
            this.copyThread.wakeUp();
        }
    }

    private void writeSnapshotInfo(long backupStartTimeMs, Path snapshotDir) throws IOException {
        SnapshotInfo info = new SnapshotInfo(backupStartTimeMs, this.envImpl.getEndOfLog(), this.envImpl.getIsMaster());
        assert (TestHookExecute.doHookIfSet(writeSnapshotInfoHook));
        Path snapshotInfo = snapshotDir.resolve(SNAPSHOT_INFO);
        Files.write(snapshotInfo, info.serialize(), StandardOpenOption.CREATE_NEW);
        BackupManager.forceFile(snapshotInfo);
    }

    private SnapshotInfo readSnapshotInfo(Path snapshotDir) throws IOException {
        return SnapshotInfo.deserialize(Files.readAllBytes(snapshotDir.resolve(SNAPSHOT_INFO)));
    }

    private void copyLatestSnapshot() throws IOException, InterruptedException {
        LatestSnapshotInfo info = this.getLatestSnapshotInfo();
        this.copySnapshot(info.snapshotDir, info.parentSnapshotDir, info.parent);
    }

    private LatestSnapshotInfo getLatestSnapshotInfo() throws IOException {
        LatestSnapshotInfo info = new LatestSnapshotInfo();
        this.withSnapshots(s2 -> s2.sorted(Collections.reverseOrder()).forEach(p -> {
            try {
                if (info.snapshotDir == null) {
                    info.snapshotDir = p;
                    return;
                }
                if (!this.isSnapshotComplete((Path)p)) {
                    this.deleteSnapshot((Path)p);
                    return;
                }
                SnapshotManifest manifest = this.getManifest((Path)p);
                if (manifest == null) {
                    this.deleteSnapshot((Path)p);
                } else if (info.parentSnapshotDir == null) {
                    info.parentSnapshotDir = p;
                    info.parent = manifest;
                } else {
                    this.deleteSnapshot((Path)p);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }));
        return info;
    }

    private void copySnapshot(@Nullable Path snapshotDir, @Nullable Path parentSnapshotDir, @Nullable SnapshotManifest parent) throws IOException, InterruptedException {
        if (snapshotDir == null || !this.isSnapshotComplete(snapshotDir)) {
            return;
        }
        SnapshotManifest base = this.getManifest(snapshotDir);
        if (base == null) {
            base = this.createNewSnapshotManifest(snapshotDir, parent);
            this.saveManifest(base, snapshotDir);
            if (parentSnapshotDir != null) {
                this.deleteSnapshot(parentSnapshotDir);
            }
        } else if (base.getIsComplete()) {
            LoggerUtils.finer(this.logger, this.envImpl, "Latest snapshot is already complete: " + snapshotDir.getFileName());
            if (parentSnapshotDir != null) {
                this.deleteSnapshot(parentSnapshotDir);
            }
            return;
        }
        this.copySnapshotFiles(base, snapshotDir);
    }

    private SnapshotManifest.LogFileInfo getLogFileInfo(String logFile, Path snapshotDir, @Nullable Map<String, SnapshotManifest.LogFileInfo> parentSnapshotFiles, long startTimeMs) throws IOException {
        SnapshotManifest.LogFileInfo parentInfo;
        SnapshotManifest.LogFileInfo logFileInfo = parentInfo = parentSnapshotFiles != null ? parentSnapshotFiles.get(logFile) : null;
        if (parentInfo != null && parentInfo.getIsCopied()) {
            long logFileModTimeMs = BackupManager.fileLastModifiedTimeMs(snapshotDir.resolve(logFile));
            if (logFileModTimeMs < startTimeMs) {
                return parentInfo;
            }
            String msg = "Detected erasure since last copy of log file: " + logFile + ", log file modify time: " + BackupManager.formatTime(logFileModTimeMs) + ", snapshot start time: " + BackupManager.formatTime(startTimeMs);
            LoggerUtils.info(this.logger, this.envImpl, msg);
        }
        return new SnapshotManifest.LogFileInfo(BackupManager.getSnapshotName(snapshotDir), this.nodeName);
    }

    static long fileLastModifiedTimeMs(Path file) throws IOException {
        long modTime = Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
        return timeMultiplier == 0L ? modTime + 1000L : modTime * timeMultiplier + 1000L;
    }

    private void copySnapshotFiles(SnapshotManifest base, Path snapshotDir) throws IOException, InterruptedException {
        if (this.logger.isLoggable(Level.FINE)) {
            LoggerUtils.fine(this.logger, this.envImpl, "Copying snapshot: " + snapshotDir.getFileName() + ", now: " + BackupManager.formatTime(BackupManager.currentTimeMs()));
        }
        int copied = 0;
        int erased = 0;
        boolean cannotComplete = false;
        long startTimeMs = BackupManager.currentTimeMs();
        for (Map.Entry<String, SnapshotManifest.LogFileInfo> e : base.getSnapshotFiles().entrySet()) {
            SnapshotManifest.LogFileInfo snapshotInfo;
            SnapshotManifest.LogFileInfo erasedInfo;
            String logFile = e.getKey();
            SnapshotManifest.LogFileInfo info = e.getValue();
            Path logFilePath = snapshotDir.resolve(logFile);
            assert (TestHookExecute.doHookIfSet(copySnapshotFileHook, base));
            if (info.getIsCopied()) {
                if (Files.notExists(logFilePath, new LinkOption[0])) continue;
                if (BackupManager.fileLastModifiedTimeMs(logFilePath) < info.getCopyStartTimeMs()) {
                    Files.delete(logFilePath);
                    continue;
                }
            }
            if ((erasedInfo = (SnapshotManifest.LogFileInfo)base.getErasedFiles().get(logFile)) != null && erasedInfo.getIsCopied()) {
                Files.deleteIfExists(logFilePath);
                continue;
            }
            base = this.copyLogFile(logFilePath, base);
            ++copied;
            if (base.getErasedFiles().containsKey(logFile)) {
                ++erased;
            }
            if ((snapshotInfo = (SnapshotManifest.LogFileInfo)base.getSnapshotFiles().get(logFile)) == null || !snapshotInfo.getIsCopied()) {
                cannotComplete = true;
            }
            this.saveManifest(base, snapshotDir);
            Files.delete(logFilePath);
        }
        if (!cannotComplete) {
            SnapshotManifest newManifest = new SnapshotManifest.Builder(base).setIsComplete(true).build();
            this.saveManifest(newManifest, snapshotDir);
        }
        long copyTimeMs = BackupManager.currentTimeMs() - startTimeMs;
        this.envImpl.noteBackupCopyFilesMs(copyTimeMs);
        this.envImpl.noteBackupCopyFilesCount(copied);
        String msg = "Done copying snapshot: " + snapshotDir.getFileName() + ", complete: " + !cannotComplete + ", copied files: " + copied + ", erased files: " + erased + ", copy time: " + copyTimeMs + " ms";
        LoggerUtils.info(this.logger, this.envImpl, msg);
    }

    private SnapshotManifest createNewSnapshotManifest(Path snapshotDir, @Nullable SnapshotManifest parent) throws IOException {
        SnapshotManifest.Builder newManifest = new SnapshotManifest.Builder();
        SnapshotInfo snapshotInfo = this.readSnapshotInfo(snapshotDir);
        newManifest.setSequence(parent != null ? parent.getSequence() + 1 : 1).setSnapshot(BackupManager.getSnapshotName(snapshotDir)).setStartTimeMs(snapshotInfo.startTimeMs).setNodeName(this.nodeName).setEndOfLog(snapshotInfo.endOfLog).setIsMaster(snapshotInfo.isMaster);
        SortedMap<String, SnapshotManifest.LogFileInfo> parentSnapshotFiles = parent != null ? parent.getSnapshotFiles() : null;
        SortedMap<String, SnapshotManifest.LogFileInfo> snapshotFiles = newManifest.getSnapshotFiles();
        BackupManager.withLogFiles(snapshotDir, s2 -> s2.forEach(p -> {
            String logFile = BackupManager.getFileNameString(p);
            try {
                snapshotFiles.put(logFile, this.getLogFileInfo(logFile, snapshotDir, parentSnapshotFiles, snapshotInfo.startTimeMs));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }));
        return newManifest.build();
    }

    private SnapshotManifest copyLogFile(Path logFilePath, SnapshotManifest base) throws IOException, InterruptedException {
        LoggerUtils.fine(this.logger, this.envImpl, "Copying snapshot log file: " + logFilePath.getFileName());
        SnapshotManifest.Builder newManifest = new SnapshotManifest.Builder(base);
        long copyStartTimeMs = BackupManager.currentTimeMs();
        String checksum = this.copyFile(logFilePath, base.getSnapshot());
        newManifest.setLastFileCopiedTimeMs(BackupManager.currentTimeMs());
        long logFileModifyTimeMs = BackupManager.fileLastModifiedTimeMs(logFilePath);
        boolean isErased = logFileModifyTimeMs > base.getStartTimeMs();
        String logFile = BackupManager.getFileNameString(logFilePath);
        SnapshotManifest.LogFileInfo logFileInfo = new SnapshotManifest.LogFileInfo(checksum, copyStartTimeMs, base);
        if (isErased) {
            String msg = "Detected erasure during copy of log file: " + logFile + ", log file modify time: " + BackupManager.formatTime(logFileModifyTimeMs) + ", snapshot start time: " + BackupManager.formatTime(base.getStartTimeMs());
            LoggerUtils.info(this.logger, this.envImpl, msg);
            newManifest.getErasedFiles().put(logFile, logFileInfo);
        } else {
            newManifest.getSnapshotFiles().put(logFile, logFileInfo);
        }
        return newManifest.build();
    }

    private String copyFile(Path path, String snapshot) throws IOException, InterruptedException {
        return this.copyFile(path, BackupManager.getFileNameString(path), snapshot);
    }

    private String copyFile(Path path, String archiveFileName, String snapshot) throws IOException, InterruptedException {
        URL archiveFile = this.getBackupLocation().getArchiveLocation(snapshot + "/" + archiveFileName);
        long retryWait = 1000L;
        while (true) {
            try {
                byte[] checksum = this.getBackupCopy().copy(path.toFile(), archiveFile);
                return BackupManager.checksumToHex(checksum);
            }
            catch (InterruptedIOException | ClosedByInterruptException e) {
                throw e;
            }
            catch (IOException e) {
                LoggerUtils.info(this.logger, this.envImpl, "Problem copying snapshot file: " + path + ", retrying in: " + retryWait + " ms, exception: " + this.getExceptionStringForLogging(e));
                BackupManager.sleepMs(retryWait);
                retryWait = Math.min(retryWait * 2L, 3600000L);
                continue;
            }
            break;
        }
    }

    private void saveManifest(SnapshotManifest manifest, Path snapshotDir) throws IOException, InterruptedException {
        assert (TestHookExecute.doHookIfSet(saveManifestHook, snapshotDir));
        assert (TestHookExecute.doIOHookIfSet(saveManifestHook));
        Path path = snapshotDir.resolve(SNAPSHOT_MANIFEST);
        Path newPath = snapshotDir.resolve("manifest.json.new");
        Path oldPath = snapshotDir.resolve("manifest.json.old");
        if (Files.exists(newPath, new LinkOption[0])) {
            LoggerUtils.finer(this.logger, this.envImpl, "Removing incomplete snapshot manifest: " + newPath);
            Files.delete(newPath);
        }
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.exists(oldPath, new LinkOption[0])) {
                LoggerUtils.finer(this.logger, this.envImpl, "Removing obsolete snapshot manifest: " + oldPath);
                Files.delete(oldPath);
            }
            Files.move(path, oldPath, StandardCopyOption.ATOMIC_MOVE);
            BackupManager.forceFile(snapshotDir);
        }
        Files.write(newPath, manifest.serialize(), StandardOpenOption.SYNC, StandardOpenOption.CREATE_NEW);
        BackupManager.forceFile(newPath);
        this.copyFile(newPath, SNAPSHOT_MANIFEST, manifest.getSnapshot());
        Files.move(newPath, path, StandardCopyOption.ATOMIC_MOVE);
        BackupManager.forceFile(snapshotDir);
        if (Files.exists(oldPath, new LinkOption[0])) {
            Files.delete(oldPath);
        }
    }

    private @Nullable SnapshotManifest getManifest(Path snapshotDir) throws IOException {
        Path path = snapshotDir.resolve(SNAPSHOT_MANIFEST);
        Path oldPath = snapshotDir.resolve("manifest.json.old");
        Path newPath = snapshotDir.resolve("manifest.json.new");
        if (Files.exists(newPath, new LinkOption[0])) {
            LoggerUtils.finer(this.logger, this.envImpl, "Removing incomplete snapshot manifest: " + newPath);
            Files.delete(newPath);
        }
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.exists(oldPath, new LinkOption[0])) {
                LoggerUtils.finer(this.logger, this.envImpl, "Removing obsolete snapshot manifest: " + oldPath);
                Files.delete(oldPath);
            }
        } else if (Files.exists(oldPath, new LinkOption[0])) {
            LoggerUtils.finer(this.logger, this.envImpl, "Restoring old snapshot manifest: " + oldPath);
            Files.move(oldPath, path, StandardCopyOption.ATOMIC_MOVE);
        } else {
            return null;
        }
        return SnapshotManifest.deserialize(Files.readAllBytes(path));
    }

    private void deleteSnapshot(Path snapshotDir) throws IOException {
        if (Files.notExists(snapshotDir, new LinkOption[0])) {
            return;
        }
        LoggerUtils.fine(this.logger, this.envImpl, "Deleting snapshot: " + snapshotDir.getFileName());
        Path snapshotComplete = snapshotDir.resolve(SNAPSHOT_COMPLETE);
        if (Files.exists(snapshotComplete, new LinkOption[0])) {
            Files.delete(snapshotComplete);
            BackupManager.forceFile(snapshotDir);
        }
        try (Stream<Path> filesStream = Files.find(snapshotDir, 1, (p, a) -> !p.equals(snapshotDir), new FileVisitOption[0]);){
            filesStream.forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            Files.delete(snapshotDir);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static <C> Constructor<? extends C> getImplementationClassConstructor(Class<? extends C> type, String className) {
        Class<C> classType;
        if (!Modifier.isInterface(type.getModifiers())) {
            throw new IllegalArgumentException("Type must be an interface: " + type.getName());
        }
        try {
            classType = Class.forName(className).asSubclass(type);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found: " + className, e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Class " + className + " must implement " + type.getName(), e);
        }
        if (Modifier.isAbstract(classType.getModifiers())) {
            throw new IllegalArgumentException("Class must not be abstract: " + className);
        }
        try {
            return classType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + className + " does not provide a public no-arguments constructor", e);
        }
    }

    public static <C> C getImplementationInstance(Class<C> type, String className) {
        C instance;
        Constructor<C> constructor = BackupManager.getImplementationClassConstructor(type, className);
        try {
            instance = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class " + className + " must be accessible", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Class " + className + " must not be abstract", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Class " + className + " constructor failed: " + e.getMessage(), e);
        }
        return instance;
    }

    public static long currentTimeMs() {
        long now = System.currentTimeMillis();
        return timeMultiplier == 0L ? now : now * timeMultiplier;
    }

    static void waitMs(Object object, long timeMs) throws InterruptedException {
        if (timeMs < 1L) {
            throw new IllegalArgumentException("timeMs is too small: " + timeMs);
        }
        object.wait(BackupManager.computeWaitTimeMs(timeMs));
    }

    private static long computeWaitTimeMs(long waitTimeMs) {
        return timeMultiplier == 0L ? waitTimeMs : Math.max(1L, waitTimeMs / timeMultiplier);
    }

    public static void sleepMs(long timeMs) throws InterruptedException {
        if (timeMs < 1L) {
            throw new IllegalArgumentException("timeMs is too small: " + timeMs);
        }
        long wait = BackupManager.computeWaitTimeMs(timeMs);
        long until = BackupManager.currentTimeMs() + wait;
        do {
            Thread.sleep(wait);
        } while ((wait = until - BackupManager.currentTimeMs()) > 0L);
    }

    public static String checksumToHex(byte[] checksum) {
        String value = new BigInteger(1, checksum).toString(16);
        int zeros = 2 * checksum.length - value.length();
        if (zeros == 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < zeros; ++i) {
            sb.append('0');
        }
        sb.append(value);
        return sb.toString();
    }

    private void withSnapshots(Consumer<Stream<Path>> consumer) throws IOException {
        Path snapshotsSubdir = this.envHomeDir.resolve(SNAPSHOT_SUBDIRECTORY);
        try (Stream<Path> snapshots = Files.find(snapshotsSubdir, 1, (p, a) -> !snapshotsSubdir.equals(p), new FileVisitOption[0]);){
            consumer.accept(snapshots);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static void withLogFiles(Path snapshotDir, Consumer<Stream<Path>> consumer) throws IOException {
        try (Stream<Path> stream = Files.find(snapshotDir, 1, (p, a) -> BackupManager.getFileNameString(p).endsWith(".jdb"), new FileVisitOption[0]);){
            consumer.accept(stream);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static String getFileNameString(Path path) {
        return path.getFileName().toString();
    }

    private static String getNodeName(EnvironmentImpl envImpl) {
        String nodeName = envImpl.getNodeName();
        return nodeName != null ? nodeName : envImpl.getName();
    }

    private static String getSnapshotName(Path snapshotDir) {
        String fileName = BackupManager.getFileNameString(snapshotDir);
        if (!SNAPSHOT_PATTERN.matcher(fileName).matches()) {
            throw new IllegalArgumentException("Bad snapshot directory: " + snapshotDir);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String formatTime(long millis) {
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            return dateFormat.format(new Date(millis));
        }
    }

    private String getExceptionStringForLogging(Throwable e) {
        return this.logger.isLoggable(Level.FINE) ? LoggerUtils.getStackTrace(e) : e.toString();
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    }

    private static class LatestSnapshotInfo {
        Path snapshotDir;
        Path parentSnapshotDir;
        SnapshotManifest parent;

        private LatestSnapshotInfo() {
        }
    }

    private class CopyThread
    extends StoppableThread {
        CopyThread(EnvironmentImpl envImpl) {
            super(envImpl, "JEBackupCopy");
        }

        void shutdown() {
            if (this.shutdownDone(BackupManager.this.logger)) {
                return;
            }
            this.shutdownThread(BackupManager.this.logger);
        }

        @Override
        protected Logger getLogger() {
            return BackupManager.this.logger;
        }

        @Override
        protected int initiateSoftShutdown() {
            BackupManager.this.shutdownRequested = true;
            this.wakeUp();
            return 3000;
        }

        @Override
        public void run() {
            long retryWait = 1000L;
            while (!BackupManager.this.shutdownRequested) {
                boolean waitingToRetry = false;
                try {
                    try {
                        BackupManager.this.copyLatestSnapshot();
                        retryWait = 1000L;
                        try {
                            this.sleepFor(Long.MAX_VALUE);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    catch (InterruptedIOException | ClosedByInterruptException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        LoggerUtils.info(BackupManager.this.logger, this.envImpl, "Problem copying snapshot, retrying in: " + retryWait + " ms, exception: " + BackupManager.this.getExceptionStringForLogging(e));
                        waitingToRetry = true;
                        this.sleepFor(retryWait);
                        retryWait = Math.min(retryWait * 2L, 3600000L);
                    }
                }
                catch (InterruptedIOException | InterruptedException | ClosedByInterruptException e) {
                    CopyThread.interrupted();
                    String msg = "Interrupted while" + (waitingToRetry ? " waiting to retry" : "") + " copying snapshot, exception: " + BackupManager.this.getExceptionStringForLogging(e);
                    LoggerUtils.fine(BackupManager.this.logger, this.envImpl, msg);
                    retryWait = 1000L;
                }
                catch (RuntimeException e) {
                    if (this.envImpl.isValid()) {
                        LoggerUtils.severe(BackupManager.this.logger, this.envImpl, "Shutting down backups because of unexpected exception when copying snapshot: " + LoggerUtils.getStackTrace(e));
                    }
                    this.initiateSoftShutdown();
                    break;
                }
                catch (Error e) {
                    if (this.envImpl.isValid()) {
                        StoppableThread.handleUncaughtException(BackupManager.this.logger, this.envImpl, this, e);
                    }
                    this.initiateSoftShutdown();
                    break;
                }
            }
        }

        private void sleepFor(long delay) throws InterruptedException {
            if (delay > 0L) {
                BackupManager.sleepMs(delay);
            }
        }

        synchronized void wakeUp() {
            this.interrupt();
        }
    }

    private static class SnapshotInfo {
        final long startTimeMs;
        final long endOfLog;
        final boolean isMaster;

        SnapshotInfo(long startTimeMs, long endOfLog, boolean isMaster) {
            this.startTimeMs = startTimeMs;
            this.endOfLog = endOfLog;
            this.isMaster = isMaster;
        }

        byte[] serialize() {
            Properties props = new Properties();
            props.setProperty("startTimeMs", String.valueOf(this.startTimeMs));
            props.setProperty("endOfLog", String.valueOf(this.endOfLog));
            props.setProperty("isMaster", String.valueOf(this.isMaster));
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                props.store(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8), "SnapshotInfo");
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected problem serializing snapshot info: " + e.getMessage(), e);
            }
        }

        static SnapshotInfo deserialize(byte[] bytes) throws IOException {
            Properties props = new Properties();
            props.load(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8));
            try {
                return new SnapshotInfo(Long.parseLong(props.getProperty("startTimeMs", "")), Long.parseLong(props.getProperty("endOfLog", "")), Boolean.parseBoolean(props.getProperty("isMaster")));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Problem deserializing snapshot info: " + e.getMessage(), e);
            }
        }
    }

    static class SnapshotTimeInfo {
        private final String schedule;
        final long next;
        private final long interval;
        final long previous;

        SnapshotTimeInfo(String schedule) {
            this.schedule = schedule;
            CronScheduleParser parser = BackupManager.createSnapshotScheduleParser(schedule);
            this.next = parser.getTime() + parser.getDelayTime();
            this.interval = parser.getInterval();
            this.previous = this.next - this.interval;
        }

        private SnapshotTimeInfo(String schedule, long next, long interval) {
            this.schedule = schedule;
            this.next = next;
            this.interval = interval;
            this.previous = next - interval;
        }

        SnapshotTimeInfo update(String newSchedule) {
            long newNext;
            if (!newSchedule.equals(this.schedule)) {
                return new SnapshotTimeInfo(newSchedule);
            }
            long now = BackupManager.currentTimeMs();
            if (this.next > now) {
                return this;
            }
            for (newNext = this.next + this.interval; newNext < now; newNext += this.interval) {
            }
            return new SnapshotTimeInfo(newSchedule, newNext, this.interval);
        }

        public String toString() {
            return "SnapshotTimeInfo[schedule='" + this.schedule + "' next=" + this.next + "(" + BackupManager.formatTime(this.next) + ") interval=" + this.interval + " previous=" + this.previous + "(" + BackupManager.formatTime(this.previous) + ")]";
        }
    }

    private class SnapshotThread
    extends StoppableThread {
        SnapshotThread(EnvironmentImpl envImpl) {
            super(envImpl, "JEBackupSnapshot");
        }

        void shutdown() {
            if (this.shutdownDone(BackupManager.this.logger)) {
                return;
            }
            this.shutdownThread(BackupManager.this.logger);
        }

        @Override
        protected Logger getLogger() {
            return BackupManager.this.logger;
        }

        @Override
        protected int initiateSoftShutdown() {
            BackupManager.this.shutdownRequested = true;
            this.wakeUp();
            return 3000;
        }

        @Override
        public void run() {
            long retryWait = 1000L;
            while (!BackupManager.this.shutdownRequested) {
                try {
                    try {
                        BackupManager.this.createNextSnapshot();
                        retryWait = 1000L;
                        this.sleepFor(((BackupManager)BackupManager.this).snapshotTimeInfo.next - BackupManager.currentTimeMs());
                    }
                    catch (InterruptedIOException | ClosedByInterruptException iOException) {
                    }
                    catch (EraserAbortException | IOException e) {
                        long wait = Math.min(retryWait, ((BackupManager)BackupManager.this).snapshotTimeInfo.next - BackupManager.currentTimeMs());
                        LoggerUtils.warning(BackupManager.this.logger, this.envImpl, "Problem creating snapshot, retrying in: " + wait + " ms, exception: " + BackupManager.this.getExceptionStringForLogging(e));
                        this.sleepFor(wait);
                        retryWait = Math.min(retryWait * 2L, 3600000L);
                    }
                }
                catch (InterruptedException e) {
                }
                catch (RuntimeException e) {
                    if (this.envImpl.isValid()) {
                        LoggerUtils.severe(BackupManager.this.logger, this.envImpl, "Shutting down backups because of unexpected exception when creating snapshot: " + LoggerUtils.getStackTrace(e));
                    }
                    this.initiateSoftShutdown();
                    break;
                }
                catch (Error e) {
                    if (this.envImpl.isValid()) {
                        StoppableThread.handleUncaughtException(BackupManager.this.logger, this.envImpl, this, e);
                    }
                    this.initiateSoftShutdown();
                    break;
                }
            }
        }

        private void sleepFor(long delay) throws InterruptedException {
            if (delay > 0L) {
                BackupManager.sleepMs(delay);
            }
        }

        private void wakeUp() {
            this.interrupt();
        }
    }
}

