/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;

class DirtyINMap {
    static final boolean DIRTY_SET_DEBUG_TRACE = false;
    private final EnvironmentImpl envImpl;
    private final SortedMap<Integer, Pair<Map<Long, Checkpointer.CheckpointReference>, Map<Long, Checkpointer.CheckpointReference>>> levelMap;
    private int numEntries;
    private final Set<DatabaseId> mapLNsToFlush;
    private final Map<DatabaseImpl, Integer> highestFlushLevels;
    private CkptState ckptState;
    private boolean ckptFlushAll;
    private boolean ckptFlushExtraLevel;

    DirtyINMap(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.levelMap = new TreeMap<Integer, Pair<Map<Long, Checkpointer.CheckpointReference>, Map<Long, Checkpointer.CheckpointReference>>>();
        this.numEntries = 0;
        this.mapLNsToFlush = new HashSet<DatabaseId>();
        this.highestFlushLevels = new IdentityHashMap<DatabaseImpl, Integer>();
        this.ckptState = CkptState.NONE;
    }

    synchronized Provisional coordinateEvictionWithCheckpoint(DatabaseImpl db, int targetLevel, IN parent) {
        if (this.ckptState == CkptState.DIRTY_MAP_INCOMPLETE && parent != null) {
            this.selectForCheckpoint(parent, -1);
            this.saveMapLNsToFlush(parent);
        }
        if (db.isDeferredWriteMode()) {
            return Provisional.YES;
        }
        if (this.ckptState == CkptState.DIRTY_MAP_INCOMPLETE && parent != null) {
            return Provisional.YES;
        }
        if (this.ckptState == CkptState.DIRTY_MAP_COMPLETE && targetLevel < this.getHighestFlushLevel(db)) {
            return Provisional.YES;
        }
        return Provisional.NO;
    }

    void coordinateSplitWithCheckpoint(IN newSibling) {
        assert (newSibling.isLatchExclusiveOwner());
        this.selectDirtyBINChildrenForCheckpoint(newSibling);
    }

    synchronized void beginCheckpoint(boolean flushAll, boolean flushExtraLevel) {
        assert (this.levelMap.isEmpty());
        assert (this.mapLNsToFlush.isEmpty());
        assert (this.highestFlushLevels.isEmpty());
        assert (this.numEntries == 0);
        assert (this.ckptState == CkptState.NONE);
        this.ckptState = CkptState.DIRTY_MAP_INCOMPLETE;
        this.ckptFlushAll = flushAll;
        this.ckptFlushExtraLevel = flushExtraLevel;
    }

    synchronized void reset() {
        this.removeCostFromMemoryBudget();
        this.levelMap.clear();
        this.mapLNsToFlush.clear();
        this.highestFlushLevels.clear();
        this.numEntries = 0;
        this.ckptState = CkptState.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectDirtyINsForCheckpoint() {
        Object in22;
        assert (this.ckptState == CkptState.DIRTY_MAP_INCOMPLETE);
        INList inMemINs = this.envImpl.getInMemoryINs();
        inMemINs.memRecalcBegin();
        boolean completed = false;
        try {
            for (Object in22 : inMemINs) {
                ((IN)in22).latchShared(CacheMode.UNCHANGED);
                try {
                    if (!((IN)in22).getInListResident()) continue;
                    inMemINs.memRecalcIterate((IN)in22);
                    if (((IN)in22).getDirty() && !((Node)in22).isBIN()) {
                        this.selectForCheckpoint((IN)in22, -1);
                    }
                    this.selectDirtyBINChildrenForCheckpoint((IN)in22);
                    this.saveMapLNsToFlush((IN)in22);
                }
                finally {
                    ((IN)in22).releaseLatch();
                    continue;
                }
                TestHookExecute.doHookIfSet(Checkpointer.examineINForCheckpointHook, in22);
            }
            completed = true;
        }
        finally {
            inMemINs.memRecalcEnd(completed);
        }
        HashMap maxFlushDbs = new HashMap();
        in22 = this;
        synchronized (in22) {
            for (DatabaseImpl databaseImpl : this.highestFlushLevels.keySet()) {
                if (this.highestFlushLevels.get(databaseImpl) != null) continue;
                maxFlushDbs.put(databaseImpl, null);
            }
        }
        DbTree dbTree = this.envImpl.getDbTree();
        for (Map.Entry entry : maxFlushDbs.entrySet()) {
            entry.setValue(dbTree.getHighestLevel((DatabaseImpl)entry.getKey()));
        }
        Object object = this;
        synchronized (object) {
            for (Map.Entry entry : maxFlushDbs.entrySet()) {
                this.highestFlushLevels.put((DatabaseImpl)entry.getKey(), (Integer)entry.getValue());
            }
        }
        object = this;
        synchronized (object) {
            this.addCostToMemoryBudget();
            this.ckptState = CkptState.DIRTY_MAP_COMPLETE;
        }
    }

    private synchronized void selectForCheckpoint(IN in, int index) {
        if (this.ckptState != CkptState.DIRTY_MAP_INCOMPLETE) {
            return;
        }
        DatabaseImpl db = in.getDatabase();
        if (db.isTemporary()) {
            return;
        }
        this.addIN(in, index, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectDirtyBINChildrenForCheckpoint(IN in) {
        if (in.getNormalizedLevel() != 2) {
            return;
        }
        for (int i = 0; i < in.getNEntries(); ++i) {
            IN bin = (IN)in.getTarget(i);
            if (bin != null) {
                boolean latchBinHere;
                boolean bl = latchBinHere = !bin.isLatchOwner();
                if (latchBinHere) {
                    bin.latchShared(CacheMode.UNCHANGED);
                }
                try {
                    if (!bin.getDirty()) continue;
                    this.selectForCheckpoint(bin, -1);
                    continue;
                }
                finally {
                    if (latchBinHere) {
                        bin.releaseLatch();
                    }
                }
            }
            if (!in.isOffHeapBINDirty(i)) continue;
            this.selectForCheckpoint(in, i);
        }
    }

    private void updateFlushLevels(Integer level, DatabaseImpl db, boolean isBIN, boolean isRoot) {
        if (this.ckptFlushAll || db.isDurableDeferredWrite()) {
            if (!this.highestFlushLevels.containsKey(db)) {
                this.highestFlushLevels.put(db, null);
            }
        } else {
            Integer highestLevelSeen;
            if ((this.ckptFlushExtraLevel || isBIN) && !isRoot) {
                level = level + 1;
            }
            if ((highestLevelSeen = this.highestFlushLevels.get(db)) == null || level > highestLevelSeen) {
                this.highestFlushLevels.put(db, level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectDirtyINsForDbSync(DatabaseImpl dbImpl) {
        assert (this.ckptState == CkptState.NONE);
        DatabaseId dbId = dbImpl.getId();
        for (IN in : this.envImpl.getInMemoryINs()) {
            if (!in.getDatabaseId().equals(dbId)) continue;
            in.latch(CacheMode.UNCHANGED);
            try {
                if (!in.getInListResident() || !in.getDirty()) continue;
                this.addIN(in, -1, false, false);
            }
            finally {
                in.releaseLatch();
            }
        }
        this.highestFlushLevels.put(dbImpl, this.envImpl.getDbTree().getHighestLevel(dbImpl));
        this.addCostToMemoryBudget();
    }

    synchronized int getHighestFlushLevel(DatabaseImpl db) {
        assert (this.ckptState != CkptState.DIRTY_MAP_INCOMPLETE);
        Integer val = this.highestFlushLevels.get(db);
        return val != null ? val : -1;
    }

    synchronized int getNumLevels() {
        return this.levelMap.size();
    }

    private synchronized void addCostToMemoryBudget() {
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        long cost = (long)this.numEntries * (long)MemoryBudget.CHECKPOINT_REFERENCE_SIZE;
        mb.updateAdminMemoryUsage(cost);
    }

    private synchronized void removeCostFromMemoryBudget() {
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        long cost = (long)this.numEntries * (long)MemoryBudget.CHECKPOINT_REFERENCE_SIZE;
        mb.updateAdminMemoryUsage(0L - cost);
    }

    synchronized void addIN(IN in, int index, boolean updateFlushLevels, boolean updateMemoryBudget) {
        boolean added;
        TreeMap<Long, Checkpointer.CheckpointReference> nodeMap;
        TreeMap<Long, Checkpointer.CheckpointReference> lsnMap;
        boolean isBin;
        byte[] idKey;
        boolean isRoot;
        long nodeId;
        long lsn;
        Integer level;
        if (index >= 0) {
            level = in.getLevel() - 1;
            lsn = in.getLsn(index);
            nodeId = -1L;
            isRoot = false;
            idKey = in.getKey(index);
            isBin = true;
        } else {
            level = in.getLevel();
            lsn = in.getLastLoggedLsn();
            nodeId = in.getNodeId();
            isRoot = in.isRoot();
            idKey = in.getIdentifierKey();
            isBin = in.isBIN();
        }
        Pair pairOfMaps = (Pair)this.levelMap.get(level);
        if (pairOfMaps != null) {
            lsnMap = (TreeMap<Long, Checkpointer.CheckpointReference>)pairOfMaps.first();
            nodeMap = (TreeMap<Long, Checkpointer.CheckpointReference>)pairOfMaps.second();
        } else {
            lsnMap = new TreeMap<Long, Checkpointer.CheckpointReference>();
            nodeMap = new TreeMap<Long, Checkpointer.CheckpointReference>();
            pairOfMaps = new Pair(lsnMap, nodeMap);
            this.levelMap.put(level, pairOfMaps);
        }
        DatabaseImpl db = in.getDatabase();
        Checkpointer.CheckpointReference ref = new Checkpointer.CheckpointReference(db.getId(), nodeId, level, isRoot, idKey, lsn);
        if (lsn != -1L) {
            added = lsnMap.put(lsn, ref) == null;
        } else {
            assert (nodeId >= 0L);
            assert (db.isDeferredWriteMode());
            boolean bl = added = nodeMap.put(nodeId, ref) == null;
        }
        if (!added) {
            return;
        }
        ++this.numEntries;
        if (updateFlushLevels) {
            this.updateFlushLevels(level, db, isBin, isRoot);
        }
        if (updateMemoryBudget) {
            MemoryBudget mb = this.envImpl.getMemoryBudget();
            mb.updateAdminMemoryUsage(MemoryBudget.CHECKPOINT_REFERENCE_SIZE);
        }
    }

    synchronized Integer getLowestLevelSet() {
        return this.levelMap.firstKey();
    }

    synchronized void removeLevel(Integer level) {
        this.levelMap.remove(level);
    }

    synchronized Checkpointer.CheckpointReference removeNode(int level, long lsn, long nodeId) {
        Checkpointer.CheckpointReference ref;
        Pair pairOfMaps = (Pair)this.levelMap.get(level);
        if (pairOfMaps == null) {
            return null;
        }
        Map lsnMap = (Map)pairOfMaps.first();
        Map nodeMap = (Map)pairOfMaps.second();
        if (lsn != -1L && (ref = (Checkpointer.CheckpointReference)lsnMap.remove(lsn)) != null) {
            return ref;
        }
        if (nodeId >= 0L && (ref = (Checkpointer.CheckpointReference)nodeMap.remove(nodeId)) != null) {
            return ref;
        }
        return null;
    }

    synchronized Checkpointer.CheckpointReference removeNextNode(Integer level) {
        Map map;
        Pair pairOfMaps = (Pair)this.levelMap.get(level);
        if (pairOfMaps == null) {
            return null;
        }
        if (!((Map)pairOfMaps.first()).isEmpty()) {
            map = (Map)pairOfMaps.first();
        } else if (!((Map)pairOfMaps.second()).isEmpty()) {
            map = (Map)pairOfMaps.second();
        } else {
            return null;
        }
        Iterator iter = map.entrySet().iterator();
        assert (iter.hasNext());
        Checkpointer.CheckpointReference ref = (Checkpointer.CheckpointReference)iter.next().getValue();
        iter.remove();
        return ref;
    }

    private synchronized void saveMapLNsToFlush(IN in) {
        if (in.isBIN() && in.getDatabase().getId().equals(DbTree.ID_DB_ID)) {
            for (int i = 0; i < in.getNEntries(); ++i) {
                MapLN ln = (MapLN)in.getTarget(i);
                if (ln == null || !ln.getDatabase().isCheckpointNeeded()) continue;
                this.mapLNsToFlush.add(ln.getDatabase().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushMapLNs(long checkpointStart) {
        HashSet<DatabaseId> mapLNsCopy;
        DirtyINMap dirtyINMap = this;
        synchronized (dirtyINMap) {
            assert (this.ckptState != CkptState.DIRTY_MAP_INCOMPLETE);
            if (this.mapLNsToFlush.isEmpty()) {
                mapLNsCopy = null;
            } else {
                mapLNsCopy = new HashSet<DatabaseId>(this.mapLNsToFlush);
                this.mapLNsToFlush.clear();
            }
        }
        if (mapLNsCopy != null) {
            DbTree dbTree = this.envImpl.getDbTree();
            for (DatabaseId dbId : mapLNsCopy) {
                this.envImpl.checkDiskLimitViolation();
                DatabaseImpl db = dbTree.getDb(dbId);
                try {
                    if (db == null || !db.isCheckpointNeeded()) continue;
                    dbTree.modifyDbRoot(db, checkpointStart, true);
                }
                finally {
                    dbTree.releaseDb(db);
                }
            }
        }
    }

    void flushRoot(long checkpointStart) {
        DbTree dbTree = this.envImpl.getDbTree();
        if (dbTree.getDb(DbTree.ID_DB_ID).isCheckpointNeeded() || dbTree.getDb(DbTree.NAME_DB_ID).isCheckpointNeeded()) {
            this.envImpl.logMapTreeRoot(checkpointStart);
        }
    }

    synchronized int getNumEntries() {
        return this.numEntries;
    }

    private void traceDirtySet() {
        assert (false);
        StringBuilder sb = new StringBuilder();
        sb.append("Ckpt dirty set");
        for (Integer level : this.levelMap.keySet()) {
            Pair pairOfMaps = (Pair)this.levelMap.get(level);
            Map lsnMap = (Map)pairOfMaps.first();
            Map nodeMap = (Map)pairOfMaps.second();
            sb.append("\nlevel = 0x").append(Integer.toHexString(level));
            sb.append(" lsnMap = ").append(lsnMap.size());
            sb.append(" nodeMap = ").append(nodeMap.size());
        }
        sb.append("\ndbId:highestFlushLevel");
        for (DatabaseImpl db : this.highestFlushLevels.keySet()) {
            sb.append(' ').append(db.getId()).append(':');
            sb.append((int)(this.highestFlushLevels.get(db) & 0xFFFF));
        }
        LoggerUtils.logMsg(this.envImpl.getLogger(), this.envImpl, Level.INFO, sb.toString());
    }

    static enum CkptState {
        NONE,
        DIRTY_MAP_INCOMPLETE,
        DIRTY_MAP_COMPLETE;

    }
}

