/*
 * Decompiled with CFR 0.152.
 */
package org.n52.oxf.xmlbeans.tools;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.oxf.xmlbeans.parser.XMLBeansParser;
import org.n52.oxf.xmlbeans.parser.XMLHandlingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLBeansTools {
    public static final XmlOptions OMIT_XML_FRAGMENTS = new XmlOptions();
    public static final XmlOptions FAST = new XmlOptions(OMIT_XML_FRAGMENTS);
    public static final XmlOptions PRETTYPRINT = new XmlOptions(OMIT_XML_FRAGMENTS);

    public static Node getDomNode(XmlObject xmlobj, String name) throws XmlException {
        Node domNode = xmlobj.getDomNode();
        if (domNode == null) {
            throw new XmlException("No DOM node found where to extract" + name + " element.");
        }
        name = XMLBeansTools.stripPrefix(name);
        NodeList childList = domNode.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node node = childList.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().equals(name)) continue;
            return node;
        }
        return null;
    }

    private static String stripPrefix(String name) {
        return name.substring(name.indexOf(":") + 1);
    }

    public static String getElement(XmlObject doc, String element) throws XMLHandlingException {
        try {
            for (Method method : doc.getClass().getMethods()) {
                if (!method.getName().equals(element)) continue;
                return method.invoke((Object)doc, (Object[])null).toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new XMLHandlingException("cannot extract '" + element + "' from " + doc.schemaType().getName().toString(), e);
        }
    }

    public static String objectToString(XmlObject doc) throws XMLHandlingException {
        return XMLBeansTools.objectToString(doc, true);
    }

    public static String objectToString(XmlObject doc, boolean validate) throws XMLHandlingException {
        return XMLBeansTools.objectToString(doc, validate, false);
    }

    public static String objectToString(XmlObject doc, boolean validate, boolean prettyprint) throws XMLHandlingException {
        if (validate) {
            XMLBeansParser.strictValidate(doc);
        }
        if (prettyprint) {
            return doc.xmlText(PRETTYPRINT);
        }
        return doc.xmlText(FAST);
    }

    public static void writeObject(XmlObject doc, PrintWriter out) throws IOException {
        doc.save(out, PRETTYPRINT);
    }

    public static void writeObject(XmlObject doc, PrintWriter out, boolean validate) throws IOException, XMLHandlingException {
        if (validate) {
            XMLBeansParser.strictValidate(doc);
        }
        XMLBeansTools.writeObject(doc, out);
    }

    public static Node getDomNode(XmlObject input) throws XMLHandlingException {
        try {
            XmlObject rootNode = XMLBeansTools.getRootNode(input);
            return rootNode.getDomNode();
        }
        catch (Throwable t) {
            throw new XMLHandlingException(t.getMessage(), t);
        }
    }

    private static XmlObject getRootNode(XmlObject input) {
        return input.selectPath("/*")[0];
    }

    public static XmlObject qualifySubstitutionGroup(XmlObject xobj, QName newInstance) {
        return XMLBeansTools.qualifySubstitutionGroup(xobj, newInstance, null);
    }

    public static XmlObject qualifySubstitutionGroup(XmlObject xobj, QName newInstance, SchemaType newType) {
        XmlObject substitute = null;
        if (newType != null && (substitute = xobj.substitute(newInstance, newType)) != null && substitute.schemaType() == newType && substitute.getDomNode().getLocalName().equals(newInstance.getLocalPart())) {
            return substitute;
        }
        XmlCursor cursor = xobj.newCursor();
        cursor.setName(newInstance);
        QName qName = new QName("http://www.w3.org/2001/XMLSchema-instance", "type");
        cursor.removeAttribute(qName);
        cursor.dispose();
        return null;
    }

    public static String stripText(XmlObject[] elems) {
        if (elems != null && elems.length > 0) {
            return XMLBeansTools.stripText(elems[0]);
        }
        return null;
    }

    public static String stripText(XmlObject elem) {
        Node child;
        if (elem != null && (child = elem.getDomNode().getFirstChild()) != null) {
            return XMLBeansTools.toString(child).trim();
        }
        return null;
    }

    private static String toString(Node xml) {
        short type = xml.getNodeType();
        if (type == 3) {
            return xml.getNodeValue();
        }
        XMLSerializer serializer = new XMLSerializer();
        serializer.setNamespaces(true);
        OutputFormat formatter = new OutputFormat();
        formatter.setOmitXMLDeclaration(false);
        formatter.setIndenting(true);
        serializer.setOutputFormat(formatter);
        StringWriter writer = new StringWriter();
        serializer.setOutputCharStream((Writer)writer);
        try {
            if (type == 9) {
                serializer.serialize((Document)xml);
            } else {
                serializer.serialize((Element)xml);
            }
        }
        catch (IOException error) {
            throw new RuntimeException(error.getMessage(), error);
        }
        return writer.toString();
    }

    static {
        OMIT_XML_FRAGMENTS.setSaveOuter();
        PRETTYPRINT.setUseDefaultNamespace();
        PRETTYPRINT.setSavePrettyPrint();
        FAST.setUseDefaultNamespace();
    }
}

