/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogStatDefinition;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;

class FSyncManager {
    private final EnvironmentImpl envImpl;
    private final long timeout;
    private final Object mgrMutex;
    private volatile boolean workInProgress;
    private FSyncGroup nextFSyncWaiters;
    private final StatGroup stats;
    private final LongStat nFSyncRequests;
    private final AtomicLongStat nFSyncs;
    private final LongStat nTimeouts;
    private final LongStat nRequests;
    private TestHook<Object> flushHook;

    FSyncManager(EnvironmentImpl envImpl) {
        this.timeout = envImpl.getConfigManager().getDuration(EnvironmentParams.LOG_FSYNC_TIMEOUT);
        this.envImpl = envImpl;
        this.mgrMutex = new Object();
        this.workInProgress = false;
        this.nextFSyncWaiters = new FSyncGroup(this.timeout, envImpl);
        this.stats = new StatGroup("FSyncManager", "FSyncManager statistics");
        this.nFSyncRequests = new LongStat(this.stats, LogStatDefinition.FSYNCMGR_FSYNC_REQUESTS);
        this.nFSyncs = new AtomicLongStat(this.stats, LogStatDefinition.FSYNCMGR_FSYNCS);
        this.nTimeouts = new LongStat(this.stats, LogStatDefinition.FSYNCMGR_TIMEOUTS);
        this.nRequests = new LongStat(this.stats, LogStatDefinition.FSYNCMGR_N_GROUP_COMMIT_REQUESTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAndSync(boolean fsyncRequired) throws DatabaseException {
        FSyncGroup myGroup;
        boolean doWork = false;
        boolean isLeader = false;
        boolean needToWait = false;
        FSyncGroup inProgressGroup = null;
        Object object = this.mgrMutex;
        synchronized (object) {
            this.nRequests.increment();
            if (fsyncRequired) {
                this.nFSyncRequests.increment();
            }
            myGroup = this.nextFSyncWaiters;
            myGroup.setDoFsync(fsyncRequired);
            if (this.workInProgress) {
                needToWait = true;
            } else {
                isLeader = true;
                doWork = true;
                this.workInProgress = true;
                inProgressGroup = this.nextFSyncWaiters;
                this.nextFSyncWaiters = new FSyncGroup(this.timeout, this.envImpl);
            }
        }
        if (needToWait) {
            int waitStatus = myGroup.waitForEvent();
            if (waitStatus == FSyncGroup.DO_LEADER_FSYNC) {
                Object object2 = this.mgrMutex;
                synchronized (object2) {
                    if (this.workInProgress) {
                        doWork = true;
                    } else {
                        isLeader = true;
                        doWork = true;
                        this.workInProgress = true;
                        inProgressGroup = myGroup;
                        this.nextFSyncWaiters = new FSyncGroup(this.timeout, this.envImpl);
                    }
                }
            }
            if (waitStatus == FSyncGroup.DO_TIMEOUT_FSYNC) {
                doWork = true;
                Object object3 = this.mgrMutex;
                synchronized (object3) {
                    this.nTimeouts.increment();
                }
            }
        }
        if (doWork) {
            if (myGroup.getDoFsync()) {
                this.envImpl.getLogManager().flushBeforeSync();
            } else {
                this.envImpl.getLogManager().flushNoSync();
            }
            TestHookExecute.doHookIfSet(this.flushHook);
            if (myGroup.getDoFsync()) {
                this.executeFSync();
                this.nFSyncs.increment();
            }
            Object object4 = this.mgrMutex;
            synchronized (object4) {
                if (isLeader) {
                    inProgressGroup.wakeupAll();
                    this.nextFSyncWaiters.wakeupOne();
                    this.workInProgress = false;
                }
            }
        }
    }

    long getNFSyncRequests() {
        return this.nFSyncRequests.get();
    }

    long getNFSyncs() {
        return this.nFSyncs.get();
    }

    long getNTimeouts() {
        return this.nTimeouts.get();
    }

    StatGroup loadStats(StatsConfig config) {
        return this.stats.cloneGroup(config.getClear());
    }

    protected void executeFSync() throws DatabaseException {
        this.envImpl.getFileManager().syncLogEnd();
    }

    public void setFlushLogHook(TestHook<Object> hook) {
        this.flushHook = hook;
    }

    static class FSyncGroup {
        static int DO_TIMEOUT_FSYNC = 0;
        static int DO_LEADER_FSYNC = 1;
        static int NO_FSYNC_NEEDED = 2;
        private volatile boolean doFsync = false;
        private volatile boolean workDone;
        private final long fsyncTimeout;
        private boolean leaderExists;
        private final EnvironmentImpl envImpl;

        FSyncGroup(long fsyncTimeout, EnvironmentImpl envImpl) {
            this.fsyncTimeout = fsyncTimeout;
            this.workDone = false;
            this.leaderExists = false;
            this.envImpl = envImpl;
        }

        synchronized boolean getLeader() {
            if (this.workDone) {
                return false;
            }
            if (this.leaderExists) {
                return false;
            }
            this.leaderExists = true;
            return true;
        }

        synchronized int waitForEvent() throws ThreadInterruptedException {
            int status;
            block5: {
                long now;
                status = NO_FSYNC_NEEDED;
                if (this.workDone) break block5;
                long startTime = System.currentTimeMillis();
                do {
                    try {
                        this.wait(this.fsyncTimeout);
                    }
                    catch (InterruptedException e) {
                        throw new ThreadInterruptedException(this.envImpl, "Unexpected interrupt while waiting for write or fsync", (Throwable)e);
                    }
                    if (this.workDone) {
                        status = NO_FSYNC_NEEDED;
                    } else {
                        if (this.leaderExists) continue;
                        this.leaderExists = true;
                        status = DO_LEADER_FSYNC;
                    }
                    break block5;
                } while ((now = System.currentTimeMillis()) - startTime <= this.fsyncTimeout);
                status = DO_TIMEOUT_FSYNC;
            }
            return status;
        }

        synchronized void setDoFsync(boolean doSync) {
            this.doFsync |= doSync;
        }

        synchronized boolean getDoFsync() {
            return this.doFsync;
        }

        synchronized void wakeupAll() {
            this.workDone = true;
            this.notifyAll();
        }

        synchronized void wakeupOne() {
            this.notify();
        }
    }
}

