/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DataShadow;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayListener;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.ThingImpl;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;

public abstract class DataImpl
extends ThingImpl
implements Data {
    MathType Type;
    private transient DataImpl parent;
    private static DisplayImplJ2D rdisplay = null;
    private static Object lock = new Object();

    public DataImpl(MathType type) {
        this.Type = type;
        this.parent = null;
    }

    public DataImpl local() {
        return this;
    }

    void setParent(DataImpl p) {
        this.parent = p;
    }

    public MathType getType() {
        return this.Type;
    }

    public void notifyReferences() throws VisADException, RemoteException {
        super.notifyReferences();
        if (this.parent != null) {
            this.parent.notifyReferences();
        }
    }

    public Data binary(Data data, int op, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        MathType dtype = data.getType();
        MathType new_type = this.Type.binary(dtype, op, new Vector());
        return this.binary(data, op, new_type, sampling_mode, error_mode);
    }

    public Data binary(Data data, int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        throw new TypeException("DataImpl.binary");
    }

    public Data add(Data data) throws VisADException, RemoteException {
        return this.binary(data, 1, 100, 202);
    }

    public Data subtract(Data data) throws VisADException, RemoteException {
        return this.binary(data, 2, 100, 202);
    }

    public Data multiply(Data data) throws VisADException, RemoteException {
        return this.binary(data, 4, 100, 202);
    }

    public Data divide(Data data) throws VisADException, RemoteException {
        return this.binary(data, 5, 100, 202);
    }

    public Data pow(Data data) throws VisADException, RemoteException {
        return this.binary(data, 7, 100, 202);
    }

    public Data max(Data data) throws VisADException, RemoteException {
        return this.binary(data, 9, 100, 202);
    }

    public Data min(Data data) throws VisADException, RemoteException {
        return this.binary(data, 10, 100, 202);
    }

    public Data atan2(Data data) throws VisADException, RemoteException {
        return this.binary(data, 11, 100, 202);
    }

    public Data atan2Degrees(Data data) throws VisADException, RemoteException {
        return this.binary(data, 12, 100, 202);
    }

    public Data remainder(Data data) throws VisADException, RemoteException {
        return this.binary(data, 15, 100, 202);
    }

    public Data add(Data data, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.binary(data, 1, sampling_mode, error_mode);
    }

    public Data subtract(Data data, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.binary(data, 2, sampling_mode, error_mode);
    }

    public Data multiply(Data data, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.binary(data, 4, sampling_mode, error_mode);
    }

    public Data divide(Data data, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.binary(data, 5, sampling_mode, error_mode);
    }

    public Data pow(Data data, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.binary(data, 7, sampling_mode, error_mode);
    }

    public Data max(Data data, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.binary(data, 9, sampling_mode, error_mode);
    }

    public Data min(Data data, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.binary(data, 10, sampling_mode, error_mode);
    }

    public Data atan2(Data data, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.binary(data, 11, sampling_mode, error_mode);
    }

    public Data atan2Degrees(Data data, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.binary(data, 12, sampling_mode, error_mode);
    }

    public Data remainder(Data data, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.binary(data, 15, sampling_mode, error_mode);
    }

    public Data unary(int op, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        MathType new_type = this.Type.unary(op, new Vector());
        return this.unary(op, new_type, sampling_mode, error_mode);
    }

    public Data unary(int op, MathType new_type, int sampling_mode, int error_mode) throws VisADException, RemoteException {
        throw new TypeException("DataImpl: unary");
    }

    public Data changeMathType(MathType new_type) throws VisADException, RemoteException {
        return this.unary(42, new_type, 100, 202);
    }

    public Data abs() throws VisADException, RemoteException {
        return this.unary(21, 100, 202);
    }

    public Data acos() throws VisADException, RemoteException {
        return this.unary(22, 100, 202);
    }

    public Data acosDegrees() throws VisADException, RemoteException {
        return this.unary(23, 100, 202);
    }

    public Data asin() throws VisADException, RemoteException {
        return this.unary(24, 100, 202);
    }

    public Data asinDegrees() throws VisADException, RemoteException {
        return this.unary(25, 100, 202);
    }

    public Data atan() throws VisADException, RemoteException {
        return this.unary(26, 100, 202);
    }

    public Data atanDegrees() throws VisADException, RemoteException {
        return this.unary(27, 100, 202);
    }

    public Data ceil() throws VisADException, RemoteException {
        return this.unary(28, 100, 202);
    }

    public Data cos() throws VisADException, RemoteException {
        return this.unary(29, 100, 202);
    }

    public Data cosDegrees() throws VisADException, RemoteException {
        return this.unary(30, 100, 202);
    }

    public Data exp() throws VisADException, RemoteException {
        return this.unary(31, 100, 202);
    }

    public Data floor() throws VisADException, RemoteException {
        return this.unary(32, 100, 202);
    }

    public Data log() throws VisADException, RemoteException {
        return this.unary(33, 100, 202);
    }

    public Data rint() throws VisADException, RemoteException {
        return this.unary(34, 100, 202);
    }

    public Data round() throws VisADException, RemoteException {
        return this.unary(35, 100, 202);
    }

    public Data sin() throws VisADException, RemoteException {
        return this.unary(36, 100, 202);
    }

    public Data sinDegrees() throws VisADException, RemoteException {
        return this.unary(37, 100, 202);
    }

    public Data sqrt() throws VisADException, RemoteException {
        return this.unary(38, 100, 202);
    }

    public Data tan() throws VisADException, RemoteException {
        return this.unary(39, 100, 202);
    }

    public Data tanDegrees() throws VisADException, RemoteException {
        return this.unary(40, 100, 202);
    }

    public Data negate() throws VisADException, RemoteException {
        return this.unary(41, 100, 202);
    }

    public Data abs(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(21, sampling_mode, error_mode);
    }

    public Data acos(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(22, sampling_mode, error_mode);
    }

    public Data acosDegrees(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(23, sampling_mode, error_mode);
    }

    public Data asin(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(24, sampling_mode, error_mode);
    }

    public Data asinDegrees(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(25, sampling_mode, error_mode);
    }

    public Data atan(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(26, sampling_mode, error_mode);
    }

    public Data atanDegrees(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(27, sampling_mode, error_mode);
    }

    public Data ceil(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(28, sampling_mode, error_mode);
    }

    public Data cos(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(29, sampling_mode, error_mode);
    }

    public Data cosDegrees(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(30, sampling_mode, error_mode);
    }

    public Data exp(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(31, sampling_mode, error_mode);
    }

    public Data floor(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(32, sampling_mode, error_mode);
    }

    public Data log(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(33, sampling_mode, error_mode);
    }

    public Data rint(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(34, sampling_mode, error_mode);
    }

    public Data round(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(35, sampling_mode, error_mode);
    }

    public Data sin(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(36, sampling_mode, error_mode);
    }

    public Data sinDegrees(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(37, sampling_mode, error_mode);
    }

    public Data sqrt(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(38, sampling_mode, error_mode);
    }

    public Data tan(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(39, sampling_mode, error_mode);
    }

    public Data tanDegrees(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(40, sampling_mode, error_mode);
    }

    public Data negate(int sampling_mode, int error_mode) throws VisADException, RemoteException {
        return this.unary(41, sampling_mode, error_mode);
    }

    static int invertOp(int op) throws VisADException {
        switch (op) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 13;
            }
            case 12: {
                return 14;
            }
            case 13: {
                return 11;
            }
            case 14: {
                return 12;
            }
            case 15: {
                return 16;
            }
            case 16: {
                return 15;
            }
        }
        throw new ArithmeticException("DataImpl.invertOp: illegal operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] computeRanges(RealType[] reals) throws VisADException, RemoteException {
        Object object = lock;
        synchronized (object) {
            if (rdisplay == null) {
                rdisplay = new DisplayImplJ2D("dummy", 4, 4);
            }
            if (reals == null || reals.length == 0) {
                return null;
            }
            int n = reals.length;
            ScalarMap[] maps = new ScalarMap[n];
            for (int i = 0; i < n; ++i) {
                maps[i] = new ScalarMap(reals[i], Display.Shape);
                rdisplay.addMap(maps[i]);
            }
            rdisplay.disableAction();
            DataReferenceImpl ref = new DataReferenceImpl("dummy");
            ref.setData(this);
            rdisplay.reAutoScale();
            rdisplay.addReference(ref);
            new Syncher();
            double[][] ranges = new double[n][];
            for (int i = 0; i < n; ++i) {
                ranges[i] = maps[i].getRange();
            }
            rdisplay.removeReference(ref);
            rdisplay.clearMaps();
            return ranges;
        }
    }

    public DataShadow computeRanges(ShadowType type, int n) throws VisADException, RemoteException {
        double[][] ranges = new double[2][n];
        for (int i = 0; i < n; ++i) {
            ranges[0][i] = Double.MAX_VALUE;
            ranges[1][i] = -1.7976931348623157E308;
        }
        DataShadow shadow = new DataShadow(ranges);
        return this.computeRanges(type, shadow);
    }

    DataShadow computeReferenceRanges(ShadowRealTupleType shad_type, CoordinateSystem coord_in, Unit[] units_in, DataShadow shadow, ShadowRealTupleType shad_ref, double[][] ranges) throws VisADException {
        RealTupleType type = (RealTupleType)shad_type.Type;
        RealTupleType ref = (RealTupleType)shad_ref.Type;
        int n = ranges[0].length;
        int len = 1;
        int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            len = 5 * len;
            indices[i] = 0;
        }
        double[][] vals = new double[n][len];
        block8: for (int j = 0; j < len; ++j) {
            int i;
            block9: for (i = 0; i < n; ++i) {
                switch (indices[i]) {
                    case 0: {
                        vals[i][j] = ranges[0][i];
                        continue block9;
                    }
                    case 1: {
                        vals[i][j] = 0.75 * ranges[0][i] + 0.25 * ranges[1][i];
                        continue block9;
                    }
                    case 2: {
                        vals[i][j] = 0.5 * (ranges[0][i] + ranges[1][i]);
                        continue block9;
                    }
                    case 3: {
                        vals[i][j] = 0.25 * ranges[0][i] + 0.75 * ranges[1][i];
                        continue block9;
                    }
                    case 4: {
                        vals[i][j] = ranges[1][i];
                    }
                }
            }
            for (i = 0; i < n; ++i) {
                int n2 = i;
                indices[n2] = indices[n2] + 1;
                if (indices[i] != 5) continue block8;
                indices[i] = 0;
            }
        }
        vals = CoordinateSystem.transformCoordinates(ref, ref.getCoordinateSystem(), ref.getDefaultUnits(), null, type, coord_in, units_in, null, vals);
        for (int i = 0; i < n; ++i) {
            double min2 = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            for (int j = 0; j < len; ++j) {
                double val = vals[i][j];
                if (val != val) continue;
                min2 = Math.min(min2, val);
                max = Math.max(max, val);
            }
            int index = ((ShadowRealType)shad_ref.getComponent(i)).getIndex();
            if (index < 0) continue;
            if (min2 == min2) {
                shadow.ranges[0][index] = Math.min(shadow.ranges[0][index], min2);
            }
            if (max != max) continue;
            shadow.ranges[1][index] = Math.max(shadow.ranges[1][index], max);
        }
        return shadow;
    }

    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        return this;
    }

    public Data __add__(Data data) throws VisADException, RemoteException {
        return this.add(data);
    }

    public Data __sub__(Data data) throws VisADException, RemoteException {
        return this.subtract(data);
    }

    public Data __mul__(Data data) throws VisADException, RemoteException {
        return this.multiply(data);
    }

    public Data __div__(Data data) throws VisADException, RemoteException {
        return this.divide(data);
    }

    public Data __pow__(Data data) throws VisADException, RemoteException {
        return this.pow(data);
    }

    public Data __mod__(Data data) throws VisADException, RemoteException {
        return this.remainder(data);
    }

    public Data __neg__() throws VisADException, RemoteException {
        return this.negate();
    }

    public Data __add__(double data) throws VisADException, RemoteException {
        return this.add(new Real(data));
    }

    public Data __radd__(double data) throws VisADException, RemoteException {
        return this.add(new Real(data));
    }

    public Data __sub__(double data) throws VisADException, RemoteException {
        return this.subtract(new Real(data));
    }

    public Data __rsub__(double data) throws VisADException, RemoteException {
        return new Real(data).subtract(this);
    }

    public Data __mul__(double data) throws VisADException, RemoteException {
        return this.multiply(new Real(data));
    }

    public Data __rmul__(double data) throws VisADException, RemoteException {
        return this.multiply(new Real(data));
    }

    public Data __div__(double data) throws VisADException, RemoteException {
        return this.divide(new Real(data));
    }

    public Data __rdiv__(double data) throws VisADException, RemoteException {
        return new Real(data).divide(this);
    }

    public Data __pow__(double data) throws VisADException, RemoteException {
        if (data == 2.0) {
            return this.multiply(this);
        }
        if (data == 3.0) {
            return this.multiply(this.multiply(this));
        }
        if (data == 4.0) {
            return this.multiply(this.multiply(this.multiply(this)));
        }
        return this.pow(new Real(data));
    }

    public Data __rpow__(double data) throws VisADException, RemoteException {
        return new Real(data).pow(this);
    }

    public Data __mod__(double data) throws VisADException, RemoteException {
        return this.remainder(new Real(data));
    }

    public Data __rmod__(double data) throws VisADException, RemoteException {
        return new Real(data).remainder(this);
    }

    public Object dataClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataImpl clone = (DataImpl)super.clone();
        clone.parent = null;
        rdisplay = null;
        lock = new Object();
        return clone;
    }

    public String toString() {
        try {
            return this.longString("");
        }
        catch (VisADException e) {
            return e.toString();
        }
        catch (RemoteException e) {
            return e.toString();
        }
    }

    public String longString() throws VisADException, RemoteException {
        return this.longString("");
    }

    public String longString(String pre) throws VisADException, RemoteException {
        throw new TypeException("DataImpl.longString");
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        RealType[] types3d = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Radius};
        RealTupleType earth_location3d = new RealTupleType(types3d);
        RealType vis_radiance = RealType.getRealType("vis_radiance");
        RealType ir_radiance = RealType.getRealType("ir_radiance");
        RealType[] types2 = new RealType[]{vis_radiance, ir_radiance};
        RealTupleType radiance = new RealTupleType(types2);
        FunctionType grid_tuple = new FunctionType(earth_location3d, radiance);
        int size3d = 6;
        float level = 2.5f;
        FlatField grid3d = FlatField.makeField(grid_tuple, size3d, false);
        RealType[] types = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Radius, vis_radiance, ir_radiance, RealType.Time};
        double[][] ranges = grid3d.computeRanges(types);
        for (int i = 0; i < ranges.length; ++i) {
            System.out.println(types[i] + ": " + ranges[i][0] + " to " + ranges[i][1]);
        }
        System.out.println(" ");
        FunctionType func = new FunctionType(radiance, RealType.Time);
        Integer2DSet fset = new Integer2DSet(2, 2);
        FlatField ff = new FlatField(func, fset);
        ff.setSamples(new float[][]{{0.0f, -1.0f, 1.0f, 2.0f}});
        ranges = ff.computeRanges(types);
        for (int i = 0; i < ranges.length; ++i) {
            System.out.println(types[i] + ": " + ranges[i][0] + " to " + ranges[i][1]);
        }
        System.exit(0);
    }

    public class Syncher
    implements DisplayListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Syncher() {
            try {
                Syncher syncher = this;
                synchronized (syncher) {
                    rdisplay.addDisplayListener(this);
                    rdisplay.enableAction();
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            rdisplay.removeDisplayListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void displayChanged(DisplayEvent e) throws VisADException, RemoteException {
            if (e.getId() == 2) {
                Syncher syncher = this;
                synchronized (syncher) {
                    this.notify();
                }
            }
        }
    }
}

