/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.nc2.constants.CDM;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

public class NcepMnemonic {
    private static final Pattern fields3 = Pattern.compile("^\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s*\\|");
    private static final Pattern fields2 = Pattern.compile("^\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|");
    private static final Pattern fields5 = Pattern.compile("^\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|");
    private static final Pattern ints6 = Pattern.compile("^\\d{6}");
    private static final int XlocalCutoff = 48;
    private static final int YlocalCutoff = 192;
    private static final boolean debugTable = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean read(InputStream ios, BufrTables.Tables tables) throws IOException {
        if (ios == null) {
            return false;
        }
        if (tables.b == null) {
            tables.b = new TableB("fake", "fake");
        }
        if (tables.d == null) {
            tables.d = new TableD("fake", "fake");
        }
        HashMap<String, String> number = new HashMap<String, String>();
        HashMap<String, String> desc = new HashMap<String, String>();
        HashMap<String, String> mnseq = new HashMap<String, String>();
        try {
            String string;
            Matcher m3;
            String fxy;
            Object line;
            String line2;
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, CDM.utf8Charset));
            do {
                if ((line2 = dataIS.readLine()) != null) continue;
                throw new RuntimeException("Bad NCEP mnemonic BUFR table ");
            } while (!line2.contains("MNEMONIC"));
            while ((line = dataIS.readLine()) != null && !((String)line).contains("MNEMONIC")) {
                Matcher m32;
                if (((String)line).contains("----") || ((String)line).startsWith("*") || ((String)line).startsWith("|       ") || !(m32 = fields3.matcher((CharSequence)line)).find()) continue;
                String string2 = m32.group(1).trim();
                fxy = m32.group(2).trim();
                if (fxy.startsWith("3")) {
                    number.put(string2, fxy);
                    desc.put(string2, m32.group(3).replace("TABLE D ENTRY - ", "").trim());
                    continue;
                }
                if (fxy.startsWith("0")) {
                    number.put(string2, fxy);
                    desc.put(string2, m32.group(3).replace("TABLE B ENTRY - ", "").trim());
                    continue;
                }
                if (!fxy.startsWith("A")) continue;
                number.put(string2, fxy);
                desc.put(string2, m32.group(3).replace("TABLE A ENTRY - ", "").trim());
            }
            while ((line = dataIS.readLine()) != null && !((String)line).contains("MNEMONIC")) {
                if (((String)line).contains("----") || ((String)line).startsWith("|       ") || ((String)line).startsWith("*") || !(m3 = fields2.matcher((CharSequence)line)).find()) continue;
                String string3 = m3.group(1).trim();
                if (mnseq.containsKey(string3)) {
                    String value = (String)mnseq.get(string3);
                    value = value + " " + m3.group(2);
                    mnseq.put(string3, value);
                    continue;
                }
                mnseq.put(string3, m3.group(2));
            }
            for (Map.Entry entry : mnseq.entrySet()) {
                String seq = (String)entry.getValue();
                seq = seq.replaceAll("\\<", "1-1-0 0-31-0 ");
                seq = seq.replaceAll("\\>", "");
                seq = seq.replaceAll("\\{", "1-1-0 0-31-1 ");
                seq = seq.replaceAll("\\}", "");
                seq = seq.replaceAll("\\(", "1-1-0 0-31-2 ");
                seq = seq.replaceAll("\\)", "");
                StringTokenizer stoke = new StringTokenizer(seq, " ");
                ArrayList<Short> list = new ArrayList<Short>();
                while (stoke.hasMoreTokens()) {
                    String mn = stoke.nextToken();
                    if (mn.charAt(1) == '-') {
                        list.add(Descriptor.getFxy(mn));
                        continue;
                    }
                    m3 = ints6.matcher(mn);
                    if (m3.find()) {
                        String F = mn.substring(0, 1);
                        String X = NcepMnemonic.removeLeading0(mn.substring(1, 3));
                        String Y = NcepMnemonic.removeLeading0(mn.substring(3));
                        list.add(Descriptor.getFxy(F + "-" + X + "-" + Y));
                        continue;
                    }
                    if (mn.startsWith("\"")) {
                        int idx = mn.lastIndexOf(34);
                        String count = mn.substring(idx + 1);
                        list.add(Descriptor.getFxy("1-1-" + count));
                        mn = mn.substring(1, idx);
                    }
                    if (mn.startsWith(".")) {
                        String des = mn.substring(mn.length() - 4);
                        mn = mn.replace(des, "....");
                    }
                    String fxy2 = (String)number.get(mn);
                    String F = fxy2.substring(0, 1);
                    String X = NcepMnemonic.removeLeading0(fxy2.substring(1, 3));
                    String Y = NcepMnemonic.removeLeading0(fxy2.substring(3));
                    list.add(Descriptor.getFxy(F + "-" + X + "-" + Y));
                }
                String fxy3 = (String)number.get(entry.getKey());
                String X = NcepMnemonic.removeLeading0(fxy3.substring(1, 3));
                String Y = NcepMnemonic.removeLeading0(fxy3.substring(3));
                if (48 > Integer.parseInt(X) && 192 > Integer.parseInt(Y)) continue;
                short seqX = Short.parseShort(X.trim());
                short seqY = Short.parseShort(Y.trim());
                tables.d.addDescriptor(seqX, seqY, (String)entry.getKey(), list);
            }
            ArrayList<Short> list = new ArrayList<Short>();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-2"));
            tables.d.addDescriptor((short)60, (short)1, "", list);
            list = new ArrayList();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-1"));
            tables.d.addDescriptor((short)60, (short)2, "", list);
            list = new ArrayList();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-1"));
            tables.d.addDescriptor((short)60, (short)3, "", list);
            list = new ArrayList();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-0"));
            tables.d.addDescriptor((short)60, (short)4, "", list);
            while ((string = dataIS.readLine()) != null) {
                if (string.contains("MNEMONIC")) {
                    break;
                }
                if (string.startsWith("|       ") || string.startsWith("*") || !(m3 = fields5.matcher(string)).find() || m3.group(1).equals("") || !number.containsKey(m3.group(1).trim())) continue;
                fxy = (String)number.get(m3.group(1).trim());
                String X = fxy.substring(1, 3);
                String Y = fxy.substring(3);
                String mnu2 = m3.group(1).trim();
                String descr = (String)desc.get(mnu2);
                short x = Short.parseShort(X.trim());
                short y = Short.parseShort(Y.trim());
                if (48 > x && 192 > y) continue;
                int scale = Integer.parseInt(m3.group(2).trim());
                int refVal = Integer.parseInt(m3.group(3).trim());
                int width = Integer.parseInt(m3.group(4).trim());
                String units = m3.group(5).trim();
                tables.b.addDescriptor(x, y, scale, refVal, width, mnu2, units, descr);
            }
        }
        finally {
            ios.close();
        }
        tables.b.addDescriptor((short)63, (short)0, 0, 0, 16, "Byte count", "Numeric", null);
        return true;
    }

    private static String removeLeading0(String number) {
        if (number.length() == 2 && number.startsWith("0")) {
            number = number.substring(1);
        } else if (number.length() == 3 && number.startsWith("00")) {
            number = number.substring(2);
        } else if (number.length() == 3 && number.startsWith("0")) {
            number = number.substring(1);
        }
        return number;
    }

    private static void readSubCategories(String fileIn, PrintStream out, String token) throws IOException {
        System.out.printf("%s%n", fileIn);
        try (FileInputStream in = new FileInputStream(fileIn);){
            String line;
            BufferedReader dataIS = new BufferedReader(new InputStreamReader((InputStream)in, CDM.utf8Charset));
            while ((line = dataIS.readLine()) != null) {
                int pos;
                int posb = line.indexOf("DISCONTINUED");
                if (posb > 0 || (posb = line.indexOf("NO LONGER")) > 0 || (posb = line.indexOf("WAS REPLACED")) > 0 || (pos = line.indexOf(token)) < 0) continue;
                System.out.printf("%s%n", line);
                boolean is31 = token.equals("031-");
                String subline = is31 ? line.substring(pos) : line.substring(pos + token.length());
                int pos2 = subline.indexOf(32);
                String catS = subline.substring(0, pos2);
                String desc = subline.substring(pos2 + 1);
                int cat = Integer.parseInt(catS.substring(0, 3));
                int subcat = Integer.parseInt(catS.substring(4, 7));
                desc = StringUtil2.remove(desc, 124).trim();
                out.printf("%d; %d; %s%n", cat, subcat, desc);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String fileOut = "resource:/resources/bufrTables/local/ncep/DataSubCategories.csv";
        try (PrintStream pout = new PrintStream(fileOut, "UTF-8");){
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.000.txt", pout, "MSG TYPE ");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.001.txt", pout, "MESSAGE TYPE ");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.002.txt", pout, "MSG TYPE ");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.003.txt", pout, "MTYP ");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.004.txt", pout, "MSG TYPE ");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.005.txt", pout, "MSG TYPE ");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.006.txt", pout, "M TYPE ");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.007.txt", pout, "MTYPE ");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.008.txt", pout, "MSG TYPE ");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.012.txt", pout, "M TYPE ");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.021.txt", pout, "MTYP ");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.031.txt", pout, "031-");
            NcepMnemonic.readSubCategories("C:/dev/github/thredds/bufr/src/main/sources/ncep/bufrtab.255.txt", pout, "MTYP ");
        }
        System.out.printf("=======================================%n", new Object[0]);
        System.out.printf("%s%n", IO.readFile(fileOut));
        System.exit(0);
        String location = "resource:/resources/bufrTables/local/ncep/ncep.bufrtab.ETACLS1";
        try (InputStream ios = BufrTables.openStream(location);){
            BufrTables.Tables tables = new BufrTables.Tables();
            NcepMnemonic.read(ios, tables);
            Formatter out = new Formatter(System.out);
            tables.b.show(out);
            tables.d.show(out);
        }
    }
}

