/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import loci.formats.DataTools;
import loci.formats.FormatException;
import loci.formats.codec.BaseCodec;
import loci.formats.codec.Codec;

public class MSVideoCodec
extends BaseCodec
implements Codec {
    public byte[] compress(byte[] data, int x, int y, int[] dims, Object options) throws FormatException {
        throw new FormatException("MS Video 1 compression not supported.");
    }

    public byte[] decompress(byte[] data, Object options) throws FormatException {
        int y;
        if (options == null || !(options instanceof Object[])) {
            return null;
        }
        Object[] optionsArray = (Object[])options;
        int bitsPerPixel = (Integer)optionsArray[0];
        int width = (Integer)optionsArray[1];
        int height = (Integer)optionsArray[2];
        byte[] lastImage = (byte[])optionsArray[3];
        int pt = 0;
        int blocksPerRow = (width + 3) / 4;
        int blocksPerColumn = (height + 3) / 4;
        int row = 0;
        int column = 0;
        byte[] bytes = new byte[width * height];
        short[] shorts = new short[width * height];
        while (pt < data.length && row < width && column < height) {
            int ndx;
            int x;
            int y2;
            short a = (short)(data[pt++] & 0xFF);
            short b = (short)(data[pt++] & 0xFF);
            if (a == 0 && b == 0 && pt >= data.length) break;
            if (b >= 132 && b < 136) {
                int skip = (b - 132) * 256 + a;
                for (int i = 0; i < skip; ++i) {
                    if (lastImage != null) {
                        for (y2 = 0; y2 < 4; ++y2) {
                            for (x = 0; x < 4 && row + x < width && column + y2 < height; ++x) {
                                ndx = width * (column + y2) + row + x;
                                int oldNdx = width * (height - 1 - y2 - column) + row + x;
                                if (bitsPerPixel == 8) {
                                    bytes[ndx] = lastImage[oldNdx];
                                    continue;
                                }
                                byte red = lastImage[oldNdx];
                                byte green = lastImage[oldNdx + width * height];
                                byte blue = lastImage[oldNdx + 2 * width * height];
                                shorts[ndx] = (short)((blue & 0x1F) << 10 | (green & 0x1F) << 5 | red & 0x1F);
                            }
                        }
                    }
                    if ((row += 4) < width) continue;
                    row = 0;
                    column += 4;
                }
                continue;
            }
            if (b >= 0 && b < 128) {
                if (bitsPerPixel == 8) {
                    byte colorA = data[pt++];
                    byte colorB = data[pt++];
                    for (y2 = 0; y2 < 4; ++y2) {
                        for (x = 3; x >= 0; --x) {
                            ndx = width * (column + y2) + row + x;
                            short flag = y2 < 2 ? b : a;
                            int shift = 4 - 4 * (y2 % 2) + x;
                            int cmp = 1 << shift;
                            bytes[ndx] = (flag & cmp) == cmp ? colorA : colorB;
                        }
                    }
                } else {
                    short check1 = DataTools.bytesToShort(data, pt, true);
                    short check2 = DataTools.bytesToShort(data, pt += 2, true);
                    pt += 2;
                    if ((check1 & 0x8000) == 32768) {
                        short q1a = check1;
                        short q1b = check2;
                        short q2a = DataTools.bytesToShort(data, pt, true);
                        short q2b = DataTools.bytesToShort(data, pt += 2, true);
                        short q3a = DataTools.bytesToShort(data, pt += 2, true);
                        short q3b = DataTools.bytesToShort(data, pt += 2, true);
                        short q4a = DataTools.bytesToShort(data, pt += 2, true);
                        short q4b = DataTools.bytesToShort(data, pt += 2, true);
                        pt += 2;
                        for (int y3 = 0; y3 < 4; ++y3) {
                            for (int x2 = 3; x2 >= 0; --x2) {
                                short colorA;
                                int ndx2 = width * (column + y3) + row + x2;
                                short s2 = x2 < 2 ? (y3 < 2 ? q3a : q1a) : (colorA = y3 < 2 ? q4a : q2a);
                                short colorB = x2 < 2 ? (y3 < 2 ? q3b : q1b) : (y3 < 2 ? q4b : q2b);
                                short flag = y3 < 2 ? b : a;
                                int shift = 4 - 4 * (y3 % 2) + x2;
                                int cmp = 1 << shift;
                                shorts[ndx2] = (flag & cmp) == cmp ? colorA : colorB;
                            }
                        }
                    } else {
                        short colorA = check1;
                        short colorB = check2;
                        for (int y4 = 0; y4 < 4; ++y4) {
                            int ndx3;
                            for (int x3 = 3; x3 >= 0 && (ndx3 = width * (column + y4) + row + x3) < shorts.length; --x3) {
                                short flag = y4 < 2 ? b : a;
                                int shift = 4 - 4 * (y4 % 2) + x3;
                                int cmp = 1 << shift;
                                shorts[ndx3] = (flag & cmp) == cmp ? colorA : colorB;
                            }
                        }
                    }
                }
                if ((row += 4) < width) continue;
                row = 0;
                column += 4;
                continue;
            }
            if (bitsPerPixel == 8 && 144 < b) {
                byte[] colors = new byte[8];
                System.arraycopy(data, pt, colors, 0, colors.length);
                pt += colors.length;
                for (int y5 = 0; y5 < 4; ++y5) {
                    for (int x4 = 3; x4 >= 0; --x4) {
                        byte colorA;
                        int ndx4 = width * (column + y5) + row + x4;
                        byte by = y5 < 2 ? (x4 < 2 ? colors[4] : colors[6]) : (colorA = x4 < 2 ? colors[0] : colors[2]);
                        byte colorB = y5 < 2 ? (x4 < 2 ? colors[5] : colors[7]) : (x4 < 2 ? colors[1] : colors[3]);
                        short flag = y5 < 2 ? b : a;
                        int shift = 4 - 4 * (y5 % 2) + x4;
                        int cmp = 1 << shift;
                        bytes[ndx4] = (flag & cmp) == cmp ? colorA : colorB;
                    }
                }
                continue;
            }
            for (int y6 = 0; y6 < 4; ++y6) {
                for (int x5 = 0; x5 < 4; ++x5) {
                    int ndx5 = width * (column + y6) + row + x5;
                    if (bitsPerPixel == 8) {
                        bytes[ndx5] = (byte)(a & 0xFF);
                        continue;
                    }
                    shorts[ndx5] = (short)((b << 8 | a) & 0xFFFF);
                }
            }
            if ((row += 4) < width) continue;
            row = 0;
            column += 4;
        }
        if (bitsPerPixel == 8) {
            byte[] tmp = bytes;
            bytes = new byte[tmp.length];
            for (y = 0; y < height; ++y) {
                System.arraycopy(tmp, y * width, bytes, (height - y - 1) * width, width);
            }
            return bytes;
        }
        byte[] b = new byte[width * height * 3];
        for (y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int off = y * width + x;
                int dest = (height - y - 1) * width + x;
                b[dest + 2 * width * height] = (byte)((shorts[off] & 0x7C00) >> 10);
                b[dest + width * height] = (byte)((shorts[off] & 0x3E0) >> 5);
                b[dest] = (byte)(shorts[off] & 0x1F);
            }
        }
        return b;
    }
}

