/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.rep.stream.WireRecord;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;

public class InputWireRecord
extends WireRecord {
    private final LogEntry logEntry;

    InputWireRecord(ByteBuffer msgBuffer) throws DatabaseException {
        byte entryType = msgBuffer.get();
        int entryVersion = LogUtils.readInt(msgBuffer);
        int itemSize = LogUtils.readInt(msgBuffer);
        VLSN vlsn = new VLSN(LogUtils.readLong(msgBuffer));
        this.header = new LogEntryHeader(entryType, entryVersion, itemSize, vlsn);
        ByteBuffer entryBuffer = msgBuffer.slice();
        entryBuffer.limit(itemSize);
        this.logEntry = this.instantiateEntry(entryBuffer);
    }

    InputWireRecord(byte entryType, int entryVersion, int itemSize, VLSN vlsn, ByteBuffer entryBuffer) throws DatabaseException {
        this.header = new LogEntryHeader(entryType, entryVersion, itemSize, vlsn);
        this.logEntry = LogEntryType.findType(this.header.getType()).getNewLogEntry();
        this.logEntry.readEntry(this.header, entryBuffer, true);
    }

    public VLSN getVLSN() {
        return this.header.getVLSN();
    }

    public byte getEntryType() {
        return this.header.getType();
    }

    public LogEntry getLogEntry() {
        return this.logEntry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.header.dumpRep(sb);
        sb.append(" ");
        this.logEntry.dumpRep(sb);
        return sb.toString();
    }

    public String dumpLogEntry() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.header);
        sb.append(" ").append(this.logEntry);
        return sb.toString();
    }
}

