/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryFloatMatrix
implements BinaryObject {
    private static final boolean fasterButUglier = true;

    public static final int computeBytes(float[][] matrix) {
        if (matrix == null) {
            return 4;
        }
        int len = 4;
        for (int i = 0; i < matrix.length; ++i) {
            len += 4 + matrix[i].length * 4;
        }
        return len;
    }

    public static final float[][] read(BinaryReader reader) throws IOException {
        DataInput file = reader.getInput();
        int len = file.readInt();
        if (len < 0) {
            return null;
        }
        float[][] matrix = new float[len][];
        for (int i = 0; i < len; ++i) {
            int len2 = file.readInt();
            matrix[i] = new float[len2];
            for (int j = 0; j < len2; ++j) {
                matrix[i][j] = file.readFloat();
            }
        }
        return matrix;
    }

    public static final void write(BinaryWriter writer, float[][] matrix, Object token) throws IOException {
        DataOutput file = writer.getOutput();
        if (matrix == null) {
            file.writeInt(-1);
        } else {
            byte[] buf = new byte[4 + matrix.length * (4 + 4 * matrix[0].length)];
            int bufIdx = 0;
            int l = matrix.length;
            for (int b = 3; b >= 0; --b) {
                buf[bufIdx + b] = (byte)(l & 0xFF);
                l >>= 8;
            }
            bufIdx += 4;
            for (int i = 0; i < matrix.length; ++i) {
                int len = matrix[i].length;
                int l2 = len;
                for (int b = 3; b >= 0; --b) {
                    buf[bufIdx + b] = (byte)(l2 & 0xFF);
                    l2 >>= 8;
                }
                bufIdx += 4;
                for (int j = 0; j < len; ++j) {
                    int x = Float.floatToIntBits(matrix[i][j]);
                    for (int b = 3; b >= 0; --b) {
                        buf[bufIdx + b] = (byte)(x & 0xFF);
                        x >>= 8;
                    }
                    bufIdx += 4;
                }
            }
            file.write(buf);
        }
    }
}

