/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util.verify;

import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.util.verify.BtreeVerifier;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.PollCondition;
import com.sleepycat.je.utilint.StoppableThread;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ReservedFilesAutoRepair
extends StoppableThread {
    public static int START_DELAY_S = 90;
    private final BtreeVerifier verifier;
    private boolean enabled;
    private boolean noThrottle;
    private boolean initialized;
    private volatile boolean running;
    private volatile boolean completed;

    public ReservedFilesAutoRepair(EnvironmentImpl envImpl) {
        super(envImpl, "RepairReservedFiles-" + envImpl.getName());
        this.verifier = new BtreeVerifier(envImpl);
    }

    public boolean startOrCheck(DbConfigManager configMgr) {
        if (this.initialized) {
            return this.running;
        }
        this.initialized = true;
        DbTree dbTree = this.envImpl.getDbTree();
        this.parseConfig(configMgr);
        if (!this.enabled) {
            if (dbTree.isAutoRepairReservedFilesDone()) {
                dbTree.clearAutoRepairReservedFilesDone();
                this.dirtyDbTree(dbTree);
            }
            return false;
        }
        if (dbTree.isAutoRepairReservedFilesDone()) {
            return false;
        }
        VerifyConfig verifyConfig = new VerifyConfig();
        verifyConfig.setRepairReservedFiles(true);
        verifyConfig.setBatchSize(configMgr.getInt(EnvironmentParams.VERIFY_BTREE_BATCH_SIZE));
        if (this.noThrottle) {
            verifyConfig.setBatchDelay(0L, TimeUnit.MILLISECONDS);
        } else {
            verifyConfig.setBatchDelay(configMgr.getDuration(EnvironmentParams.VERIFY_BTREE_BATCH_DELAY), TimeUnit.MILLISECONDS);
        }
        this.verifier.setBtreeVerifyConfig(verifyConfig);
        this.running = true;
        this.start();
        return true;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public Logger getLogger() {
        return this.envImpl.getLogger();
    }

    public void requestShutdown() {
        this.verifier.setStopVerifyFlag(true);
    }

    @Override
    protected int initiateSoftShutdown() {
        this.requestShutdown();
        return (int)TimeUnit.SECONDS.toMillis(5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean success;
            if (PollCondition.await(50L, TimeUnit.SECONDS.toMillis(START_DELAY_S), this.verifier::getStopVerifyFlag)) {
                return;
            }
            int exCount = 0;
            try {
                this.verifier.verifyAll();
                success = !this.verifier.hasRepairWarnings();
            }
            catch (RuntimeException e) {
                success = false;
                exCount = 1;
                LoggerUtils.severe(this.getLogger(), this.envImpl, LoggerUtils.getStackTrace(e));
            }
            if (success) {
                LoggerUtils.info(this.getLogger(), this.envImpl, "Reserved file repair complete");
                DbTree dbTree = this.envImpl.getDbTree();
                dbTree.setAutoRepairReservedFilesDone();
                this.dirtyDbTree(dbTree);
            } else {
                LoggerUtils.warning(this.getLogger(), this.envImpl, "Reserved file repair not complete. lockConflicts=" + this.verifier.getRepairLockConflicts() + " maybeExtinct=" + this.verifier.getRepairMaybeExtinct() + " runtimeExceptions=" + (this.verifier.getRepairRuntimeExceptions() + exCount));
            }
            this.envImpl.getDataVerifier().configVerifyTask(this.envImpl.getConfigManager());
            this.completed = true;
        }
        finally {
            this.running = false;
        }
    }

    private void dirtyDbTree(DbTree dbTree) {
        dbTree.getIdDatabaseImpl().setDirty();
    }

    private void parseConfig(DbConfigManager configMgr) {
        String paramName = EnvironmentParams.AUTO_RESERVED_FILE_REPAIR.getName();
        String param = configMgr.get(EnvironmentParams.AUTO_RESERVED_FILE_REPAIR);
        if (param == null) {
            throw new IllegalArgumentException(paramName + " is null");
        }
        this.enabled = false;
        this.noThrottle = false;
        switch (param) {
            case "off": {
                break;
            }
            case "on": {
                this.enabled = true;
                break;
            }
            case "on.noThrottle": {
                this.enabled = true;
                this.noThrottle = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(paramName + " is not 'off', 'on' or 'on.noThrottle': " + param);
            }
        }
    }
}

