/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.point.standard.Join;
import ucar.nc2.ft.point.standard.JoinArray;
import ucar.nc2.ft.point.standard.JoinMuiltdimStructure;
import ucar.nc2.ft.point.standard.JoinParentIndex;
import ucar.nc2.ft.point.standard.PointDatasetStandardFactory;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableAnalyzer;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurer;
import ucar.nc2.util.IO;

public class PointConfigXML {
    private TableConfig tc;
    private String tableConfigurerClass;
    private static boolean debugXML = false;
    private static boolean debugURL = false;
    private static boolean showParsedXML = false;

    public static void writeConfigXML(FeatureDatasetPoint pfd, Formatter f) {
        if (!(pfd instanceof PointDatasetStandardFactory.PointDatasetStandard)) {
            f.format("%s not instance of PointDatasetStandard%n", pfd.getLocation());
            return;
        }
        PointDatasetStandardFactory.PointDatasetStandard spfd = (PointDatasetStandardFactory.PointDatasetStandard)pfd;
        TableAnalyzer analyser = spfd.getTableAnalyzer();
        TableConfig config = analyser.getTableConfig();
        TableConfigurer tc = analyser.getTableConfigurer();
        if (tc == null) {
            f.format("%s has no TableConfig%n", pfd.getLocation());
            return;
        }
        PointConfigXML writer = new PointConfigXML();
        try {
            writer.writeConfigXML(config, tc.getClass().getName(), f);
        }
        catch (IOException e) {
            f.format("%s error writing=%s%n", pfd.getLocation(), e.getMessage());
        }
    }

    public void writeConfigXML(TableConfig tc, String tableConfigurerClass, Formatter sf) throws IOException {
        this.tc = tc;
        this.tableConfigurerClass = tableConfigurerClass;
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        sf.format("%s", fmt.outputString(this.makeDocument()));
    }

    public Document makeDocument() {
        Element rootElem = new Element("pointConfig");
        Document doc = new Document(rootElem);
        if (this.tableConfigurerClass != null) {
            rootElem.addContent(new Element("tableConfigurer").setAttribute("class", this.tableConfigurerClass));
        }
        if (this.tc.featureType != null) {
            rootElem.setAttribute("featureType", this.tc.featureType.toString());
        }
        rootElem.addContent(this.writeTable(this.tc));
        return doc;
    }

    private Element writeTable(TableConfig config) {
        Element tableElem = new Element("table");
        if (config.type != null) {
            tableElem.setAttribute("type", config.type.toString());
            switch (config.type) {
                case ArrayStructure: {
                    tableElem.setAttribute("dimension", config.dimName);
                    break;
                }
                case Construct: {
                    break;
                }
                case Contiguous: {
                    if (config.start != null) {
                        tableElem.setAttribute("start", config.start);
                    }
                    if (config.numRecords == null) break;
                    tableElem.setAttribute("numRecords", config.numRecords);
                    break;
                }
                case LinkedList: {
                    tableElem.setAttribute("start", config.start);
                    tableElem.setAttribute("next", config.next);
                    break;
                }
                case MultidimInner: {
                    tableElem.setAttribute("structName", config.structName);
                }
                case MultidimInnerPsuedo: {
                    tableElem.setAttribute("dim0", config.outerName);
                    tableElem.setAttribute("dim1", config.innerName);
                    tableElem.setAttribute("subtype", config.structureType.toString());
                    break;
                }
                case MultidimInner3D: {
                    break;
                }
                case MultidimInnerPsuedo3D: {
                    break;
                }
                case MultidimStructure: {
                    tableElem.setAttribute("structName", config.structName);
                    break;
                }
                case NestedStructure: {
                    tableElem.setAttribute("structName", config.structName);
                    break;
                }
                case ParentId: 
                case ParentIndex: {
                    tableElem.setAttribute("parentIndex", config.parentIndex);
                    break;
                }
                case Singleton: {
                    break;
                }
                case Structure: {
                    tableElem.setAttribute("subtype", config.structureType.toString());
                    switch (config.structureType) {
                        case Structure: {
                            tableElem.setAttribute("structName", config.structName);
                            break;
                        }
                        case PsuedoStructure: {
                            tableElem.setAttribute("dim", config.dimName);
                            break;
                        }
                        case PsuedoStructure2D: {
                            tableElem.setAttribute("dim0", config.dimName);
                            tableElem.setAttribute("dim1", config.outerName);
                        }
                    }
                    break;
                }
                case Top: {
                    tableElem.setAttribute("structName", config.structName);
                }
            }
        }
        ArrayList<String> varNames = config.vars == null ? new ArrayList<String>() : new ArrayList<String>(config.vars);
        for (Table.CoordName coord : Table.CoordName.values()) {
            this.addCoord(tableElem, config, coord, varNames);
        }
        if (config.vars != null) {
            for (String col : varNames) {
                tableElem.addContent(new Element("variable").addContent(col));
            }
        }
        if (config.extraJoin != null) {
            for (Join j : config.extraJoin) {
                if (j instanceof JoinArray) {
                    tableElem.addContent(this.writeJoinArray((JoinArray)j));
                    continue;
                }
                if (j instanceof JoinMuiltdimStructure) {
                    tableElem.addContent(this.writeJoinMuiltdimStructure((JoinMuiltdimStructure)j));
                    continue;
                }
                if (!(j instanceof JoinParentIndex)) continue;
                tableElem.addContent(this.writeJoinParentIndex((JoinParentIndex)j));
            }
        }
        if (config.children != null) {
            for (TableConfig child : config.children) {
                tableElem.addContent(this.writeTable(child));
            }
        }
        return tableElem;
    }

    private void addCoord(Element tableElem, TableConfig table, Table.CoordName type, List<String> varNames) {
        String name = table.findCoordinateVariableName(type);
        if (name != null) {
            Element elem = new Element("coordinate").setAttribute("type", type.name());
            elem.addContent(name);
            tableElem.addContent(elem);
            varNames.remove(name);
        }
    }

    private Element writeJoinArray(JoinArray join) {
        Element joinElem = new Element("join");
        joinElem.setAttribute("class", join.getClass().toString());
        if (join.type != null) {
            joinElem.setAttribute("type", join.type.toString());
        }
        if (join.v != null) {
            joinElem.addContent(new Element("variable").addContent(join.v.getFullName()));
        }
        joinElem.addContent(new Element("param").addContent(Integer.toString(join.param)));
        return joinElem;
    }

    private JoinArray readJoinArray(NetcdfDataset ds, Element joinElement) {
        JoinArray.Type type = JoinArray.Type.valueOf(joinElement.getAttributeValue("type"));
        Element paramElem = joinElement.getChild("param");
        String paramS = paramElem.getText();
        Integer param = Integer.parseInt(paramS);
        Element varElem = joinElement.getChild("variable");
        String varName = varElem.getText();
        VariableDS v = (VariableDS)ds.findVariable(varName);
        return new JoinArray(v, type, param);
    }

    private Element writeJoinMuiltdimStructure(JoinMuiltdimStructure join) {
        Element joinElem = new Element("join");
        joinElem.setAttribute("class", join.getClass().toString());
        if (join.parentStructure != null) {
            joinElem.addContent(new Element("parentStructure").addContent(join.parentStructure.getFullName()));
        }
        joinElem.addContent(new Element("dimLength").setAttribute("value", Integer.toString(join.dimLength)));
        return joinElem;
    }

    private Element writeJoinParentIndex(JoinParentIndex join) {
        Element joinElem = new Element("join");
        joinElem.setAttribute("class", join.getClass().toString());
        if (join.parentStructure != null) {
            joinElem.addContent(new Element("parentStructure").addContent(join.parentStructure.getFullName()));
        }
        if (join.parentIndex != null) {
            joinElem.addContent(new Element("parentIndex").addContent(join.parentIndex));
        }
        return joinElem;
    }

    public TableConfig readConfigXMLfromResource(String resourceLocation, FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        try (InputStream is = cl.getResourceAsStream(resourceLocation);){
            Document doc;
            if (is == null) {
                throw new FileNotFoundException(resourceLocation);
            }
            if (debugXML) {
                System.out.println(" PointConfig URL = <" + resourceLocation + ">");
                try (InputStream is2 = cl.getResourceAsStream(resourceLocation);){
                    System.out.println(" contents=\n" + IO.readContents(is2));
                }
            }
            try {
                SAXBuilder builder = new SAXBuilder(false);
                builder.setExpandEntities(false);
                if (debugURL) {
                    System.out.println(" PointConfig URL = <" + resourceLocation + ">");
                }
                doc = builder.build(is);
            }
            catch (JDOMException e) {
                throw new IOException(e.getMessage());
            }
            if (debugXML) {
                System.out.println(" SAXBuilder done");
            }
            if (showParsedXML) {
                XMLOutputter xmlOut = new XMLOutputter();
                System.out.println("*** PointConfig/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
            }
            Element configElem = doc.getRootElement();
            String featureType = configElem.getAttributeValue("featureType");
            Element tableElem = configElem.getChild("table");
            assert (tableElem != null);
            TableConfig tc = this.parseTableConfig(ds, tableElem, null);
            tc.featureType = FeatureType.valueOf(featureType);
            TableConfig tableConfig = tc;
            return tableConfig;
        }
    }

    public TableConfig readConfigXML(String fileLocation, FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder(false);
            builder.setExpandEntities(false);
            if (debugURL) {
                System.out.println(" PointConfig URL = <" + fileLocation + ">");
            }
            doc = builder.build(fileLocation);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        if (debugXML) {
            System.out.println(" SAXBuilder done");
        }
        if (showParsedXML) {
            XMLOutputter xmlOut = new XMLOutputter();
            System.out.println("*** PointConfig/showParsedXML = \n" + xmlOut.outputString(doc) + "\n*******");
        }
        Element configElem = doc.getRootElement();
        String featureType = configElem.getAttributeValue("featureType");
        Element tableElem = configElem.getChild("table");
        TableConfig tc = this.parseTableConfig(ds, tableElem, null);
        tc.featureType = FeatureType.valueOf(featureType);
        return tc;
    }

    private TableConfig parseTableConfig(NetcdfDataset ds, Element tableElem, TableConfig parent) {
        String typeS = tableElem.getAttributeValue("type");
        Table.Type ttype = Table.Type.valueOf(typeS);
        String name = tableElem.getAttributeValue("name");
        TableConfig tc = new TableConfig(ttype, name);
        switch (ttype) {
            case ArrayStructure: {
                tc.dimName = tableElem.getAttributeValue("dimension");
                break;
            }
            case Construct: {
                break;
            }
            case Contiguous: {
                tc.numRecords = tableElem.getAttributeValue("numRecords");
                tc.start = tableElem.getAttributeValue("start");
                break;
            }
            case LinkedList: {
                tc.start = tableElem.getAttributeValue("start");
                tc.next = tableElem.getAttributeValue("next");
                break;
            }
            case MultidimInner: {
                tc.structName = tableElem.getAttributeValue("structName");
            }
            case MultidimInnerPsuedo: {
                tc.dimName = tc.outerName = tableElem.getAttributeValue("dim0");
                tc.innerName = tableElem.getAttributeValue("dim1");
                tc.structureType = TableConfig.StructureType.valueOf(tableElem.getAttributeValue("subtype"));
                assert (parent != null);
                this.makeMultidimInner(ds, parent, tc);
                break;
            }
            case MultidimInner3D: {
                break;
            }
            case MultidimInnerPsuedo3D: {
                break;
            }
            case MultidimStructure: {
                tc.structName = tableElem.getAttributeValue("structName");
                break;
            }
            case NestedStructure: {
                tc.structName = tableElem.getAttributeValue("structName");
                break;
            }
            case ParentId: 
            case ParentIndex: {
                tc.parentIndex = tableElem.getAttributeValue("parentIndex");
                break;
            }
            case Singleton: {
                break;
            }
            case Structure: {
                tc.structureType = TableConfig.StructureType.valueOf(tableElem.getAttributeValue("subtype"));
                switch (tc.structureType) {
                    case Structure: {
                        tc.structName = tableElem.getAttributeValue("structName");
                        break;
                    }
                    case PsuedoStructure: {
                        tc.dimName = tableElem.getAttributeValue("dim");
                        break;
                    }
                    case PsuedoStructure2D: {
                        tc.dimName = tableElem.getAttributeValue("dim0");
                        tc.outerName = tableElem.getAttributeValue("dim1");
                    }
                }
                break;
            }
            case Top: {
                tc.structName = tableElem.getAttributeValue("structName");
            }
        }
        List<Element> coordList = tableElem.getChildren("coordinate");
        for (Element element : coordList) {
            String coordNameType = element.getAttributeValue("type");
            Table.CoordName coordName = Table.CoordName.valueOf(coordNameType);
            tc.setCoordinateVariableName(coordName, element.getText());
        }
        List<Element> joinList = tableElem.getChildren("join");
        for (Element joinElem : joinList) {
            tc.addJoin(this.readJoinArray(ds, joinElem));
        }
        List<Element> list = tableElem.getChildren("table");
        for (Element nestedTable : list) {
            tc.addChild(this.parseTableConfig(ds, nestedTable, tc));
        }
        return tc;
    }

    private void makeMultidimInner(NetcdfDataset ds, TableConfig parentTable, TableConfig childTable) {
        Dimension parentDim = ds.findDimension(parentTable.dimName);
        Dimension childDim = ds.findDimension(childTable.innerName);
        List<Variable> vars = ds.getVariables();
        ArrayList<String> parentVars = new ArrayList<String>(vars.size());
        ArrayList<String> obsVars = new ArrayList<String>(vars.size());
        for (Variable orgV : vars) {
            Dimension dim0;
            if (orgV instanceof Structure || (dim0 = orgV.getDimension(0)) == null || !dim0.equals(parentDim)) continue;
            if (orgV.getRank() == 1 || orgV.getRank() == 2 && orgV.getDataType() == DataType.CHAR) {
                parentVars.add(orgV.getShortName());
                continue;
            }
            Dimension dim1 = orgV.getDimension(1);
            if (dim1 == null || !dim1.equals(childDim)) continue;
            obsVars.add(orgV.getShortName());
        }
        parentTable.vars = parentVars;
        childTable.vars = obsVars;
    }
}

