/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class HSVCoordinateSystem
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{CommonUnit.degree, null, null};

    public HSVCoordinateSystem(RealTupleType reference) throws VisADException {
        super(reference, coordinate_system_units);
    }

    HSVCoordinateSystem(RealTupleType reference, boolean b) {
        super(reference, coordinate_system_units, b);
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[3][len];
        int j = 0;
        double f = 0.0;
        double p = 0.0;
        double q = 0.0;
        double t = 0.0;
        block7: for (int i = 0; i < len; ++i) {
            double h2 = tuples[0][i] % 360.0;
            if (h2 < 0.0) {
                h2 += 360.0;
            }
            double s2 = Math.max(0.0, Math.min(1.0, tuples[1][i]));
            double v = Math.max(0.0, Math.min(1.0, tuples[2][i]));
            if (s2 == 0.0) {
                value[0][i] = v;
                value[1][i] = v;
                value[2][i] = v;
                continue;
            }
            j = (int)Math.floor(h2 /= 60.0);
            f = h2 - (double)j;
            p = v * (1.0 - s2);
            q = v * (1.0 - s2 * f);
            t = v * (1.0 - s2 * (1.0 - f));
            switch (j) {
                case 0: {
                    value[0][i] = v;
                    value[1][i] = t;
                    value[2][i] = p;
                    continue block7;
                }
                case 1: {
                    value[0][i] = q;
                    value[1][i] = v;
                    value[2][i] = p;
                    continue block7;
                }
                case 2: {
                    value[0][i] = p;
                    value[1][i] = v;
                    value[2][i] = t;
                    continue block7;
                }
                case 3: {
                    value[0][i] = p;
                    value[1][i] = q;
                    value[2][i] = v;
                    continue block7;
                }
                case 4: {
                    value[0][i] = t;
                    value[1][i] = p;
                    value[2][i] = v;
                    continue block7;
                }
                default: {
                    value[0][i] = v;
                    value[1][i] = p;
                    value[2][i] = q;
                }
            }
        }
        return value;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[3][len];
        for (int i = 0; i < len; ++i) {
            double h2;
            double r = Math.max(0.0, Math.min(1.0, tuples[0][i]));
            double g2 = Math.max(0.0, Math.min(1.0, tuples[1][i]));
            double b = Math.max(0.0, Math.min(1.0, tuples[2][i]));
            double max = Math.max(r, Math.max(g2, b));
            double min2 = Math.min(r, Math.min(g2, b));
            value[2][i] = max;
            double d = value[1][i] = max != 0.0 ? (max - min2) / max : 0.0;
            if (value[1][i] == 0.0) {
                value[2][i] = 0.0;
                continue;
            }
            double rc = (max - r) / (max - min2);
            double gc = (max - g2) / (max - min2);
            double bc = (max - b) / (max - min2);
            if (r == max) {
                h2 = bc - gc;
            } else if (g2 == max) {
                h2 = 2.0 + rc - bc;
            } else if (b == max) {
                h2 = 4.0 + gc - rc;
            } else {
                throw new CoordinateSystemException("HSVCoordinateSystem: bad h");
            }
            h2 = 60.0 * h2;
            if (h2 < 0.0) {
                h2 += 360.0;
            }
            value[2][i] = h2;
        }
        return value;
    }

    public float[][] toReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[3][len];
        int j = 0;
        float f = 0.0f;
        float p = 0.0f;
        float q = 0.0f;
        float t = 0.0f;
        block7: for (int i = 0; i < len; ++i) {
            float h2 = tuples[0][i] % 360.0f;
            if (h2 < 0.0f) {
                h2 += 360.0f;
            }
            float s2 = Math.max(0.0f, Math.min(1.0f, tuples[1][i]));
            float v = Math.max(0.0f, Math.min(1.0f, tuples[2][i]));
            if (s2 == 0.0f) {
                value[0][i] = v;
                value[1][i] = v;
                value[2][i] = v;
                continue;
            }
            j = (int)Math.floor(h2 /= 60.0f);
            f = h2 - (float)j;
            p = v * (1.0f - s2);
            q = v * (1.0f - s2 * f);
            t = v * (1.0f - s2 * (1.0f - f));
            switch (j) {
                case 0: {
                    value[0][i] = v;
                    value[1][i] = t;
                    value[2][i] = p;
                    continue block7;
                }
                case 1: {
                    value[0][i] = q;
                    value[1][i] = v;
                    value[2][i] = p;
                    continue block7;
                }
                case 2: {
                    value[0][i] = p;
                    value[1][i] = v;
                    value[2][i] = t;
                    continue block7;
                }
                case 3: {
                    value[0][i] = p;
                    value[1][i] = q;
                    value[2][i] = v;
                    continue block7;
                }
                case 4: {
                    value[0][i] = t;
                    value[1][i] = p;
                    value[2][i] = v;
                    continue block7;
                }
                default: {
                    value[0][i] = v;
                    value[1][i] = p;
                    value[2][i] = q;
                }
            }
        }
        return value;
    }

    public float[][] fromReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[3][len];
        for (int i = 0; i < len; ++i) {
            float h2;
            float r = Math.max(0.0f, Math.min(1.0f, tuples[0][i]));
            float g2 = Math.max(0.0f, Math.min(1.0f, tuples[1][i]));
            float b = Math.max(0.0f, Math.min(1.0f, tuples[2][i]));
            float max = Math.max(r, Math.max(g2, b));
            float min2 = Math.min(r, Math.min(g2, b));
            value[2][i] = max;
            float f = value[1][i] = max != 0.0f ? (max - min2) / max : 0.0f;
            if (value[1][i] == 0.0f) {
                value[2][i] = 0.0f;
                continue;
            }
            float rc = (max - r) / (max - min2);
            float gc = (max - g2) / (max - min2);
            float bc = (max - b) / (max - min2);
            if (r == max) {
                h2 = bc - gc;
            } else if (g2 == max) {
                h2 = 2.0f + rc - bc;
            } else if (b == max) {
                h2 = 4.0f + gc - rc;
            } else {
                throw new CoordinateSystemException("HSVCoordinateSystem: bad h");
            }
            h2 = 60.0f * h2;
            if (h2 < 0.0f) {
                h2 += 360.0f;
            }
            value[2][i] = h2;
        }
        return value;
    }

    public boolean equals(Object cs) {
        return cs instanceof HSVCoordinateSystem;
    }
}

