/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleExpression
extends Expression {
    LocalVariableReference[] slots = new LocalVariableReference[0];

    public void setVariables(List<LocalVariableReference> refs) {
        this.slots = new LocalVariableReference[refs.size()];
        this.slots = refs.toArray(this.slots);
    }

    public LocalVariableReference[] getSlots() {
        return this.slots;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return new ExternalObjectType(Object.class, th.getConfiguration());
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = (LocalVariableReference)visitor.typeCheck(this.slots[i], contextItemType);
        }
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return Arrays.asList((Expression[])this.slots).iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (original != this.slots[i]) continue;
            this.slots[i] = (LocalVariableReference)replacement;
            return true;
        }
        return false;
    }

    @Override
    public Expression copy() {
        LocalVariableReference[] refs2 = new LocalVariableReference[this.slots.length];
        for (int i = 0; i < this.slots.length; ++i) {
            refs2[i] = (LocalVariableReference)this.slots[i].copy();
        }
        TupleExpression t2 = new TupleExpression();
        t2.slots = refs2;
        return t2;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("tuple");
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i].explain(out);
        }
        out.endElement();
    }

    @Override
    public Tuple evaluateItem(XPathContext context) throws XPathException {
        ValueRepresentation[] tuple = new ValueRepresentation[this.slots.length];
        for (int i = 0; i < this.slots.length; ++i) {
            tuple[i] = this.slots[i].evaluateVariable(context);
        }
        return new Tuple(tuple);
    }

    public void setCurrentTuple(XPathContext context, Tuple tuple) {
        ValueRepresentation[] members = tuple.getMembers();
        for (int i = 0; i < this.slots.length; ++i) {
            context.setLocalVariable(this.slots[i].getBinding().getLocalSlotNumber(), members[i]);
        }
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0;
    }
}

