/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.util.Date;
import net.jcip.annotations.ThreadSafe;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateListener;
import thredds.inventory.CollectionUpdateType;

@ThreadSafe
public enum CollectionUpdater {
    INSTANCE;

    private static final Logger startupLogger;
    private static final String DCM_NAME = "dcm";
    private static final String LOGGER = "logger";
    private static final String UpdateType = "updateType";
    private static final long startupWait = 3000L;
    private static boolean disabled;
    private Scheduler scheduler = null;
    private boolean failed = false;
    private boolean isTdm = false;

    public void setTdm(boolean tdm) {
        this.isTdm = tdm;
    }

    public boolean isTdm() {
        return this.isTdm;
    }

    private CollectionUpdater() {
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.start();
        }
        catch (Throwable e) {
            this.failed = true;
            throw new RuntimeException("quartz scheduler failed to initialize", e);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void scheduleTasks(FeatureCollectionConfig config, CollectionUpdateListener manager, Logger logger) {
        block23: {
            JobDataMap map;
            String jobName;
            block22: {
                FeatureCollectionConfig.UpdateConfig updateConfig;
                if (disabled || this.failed) {
                    return;
                }
                FeatureCollectionConfig.UpdateConfig updateConfig2 = updateConfig = this.isTdm ? config.tdmConfig : config.updateConfig;
                if (updateConfig == null) {
                    return;
                }
                jobName = manager.getCollectionName();
                map = new JobDataMap();
                map.put(DCM_NAME, (Object)manager);
                if (logger != null) {
                    map.put(LOGGER, (Object)logger);
                }
                JobDetail updateJob = JobBuilder.newJob(UpdateCollectionJob.class).withIdentity(jobName, "UpdateCollection").storeDurably().usingJobData(map).build();
                try {
                    if (!this.scheduler.checkExists(updateJob.getKey())) {
                        this.scheduler.addJob(updateJob, false);
                    } else if (logger != null) {
                        logger.warn("cronExecutor failed to add updateJob for " + updateJob.getKey() + ". Another Job exists with that identification.");
                    }
                }
                catch (Throwable e) {
                    if (logger != null) {
                        logger.error("cronExecutor failed to add updateJob for " + config, e);
                    }
                    return;
                }
                if (updateConfig.startupType != CollectionUpdateType.never) {
                    map = new JobDataMap();
                    map.put(UpdateType, (Object)updateConfig.startupType);
                    Date runTime = new Date(new Date().getTime() + 3000L);
                    SimpleTrigger startupTrigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, "startup").startAt(runTime).forJob(updateJob).usingJobData(map).build();
                    try {
                        this.scheduler.scheduleJob(startupTrigger);
                        if (logger != null) {
                            logger.info("Schedule startup scan force={} for '{}' at {}", updateConfig.startupType.toString(), config.collectionName, runTime);
                        }
                    }
                    catch (Throwable e) {
                        if (logger != null) {
                            logger.error("cronExecutor failed to schedule startup Job for " + config, e);
                        }
                        return;
                    }
                }
                if (updateConfig.rescan != null) {
                    map = new JobDataMap();
                    map.put(UpdateType, (Object)updateConfig.updateType);
                    CronTrigger rescanTrigger = TriggerBuilder.newTrigger().withIdentity(jobName, "rescan").withSchedule(CronScheduleBuilder.cronSchedule(updateConfig.rescan)).forJob(updateJob).usingJobData(map).build();
                    try {
                        this.scheduler.scheduleJob(rescanTrigger);
                        if (logger != null) {
                            logger.info("Schedule recurring scan for '{}' cronExpr={}", (Object)config.collectionName, (Object)updateConfig.rescan);
                        }
                    }
                    catch (Throwable e) {
                        if (logger == null) break block22;
                        logger.error("cronExecutor failed to schedule cron Job", e);
                    }
                }
            }
            FeatureCollectionConfig.ProtoConfig pconfig = config.protoConfig;
            if (pconfig.change != null) {
                JobDataMap pmap = new JobDataMap();
                pmap.put(DCM_NAME, (Object)manager);
                map.put(LOGGER, (Object)logger);
                JobDetail protoJob = JobBuilder.newJob(ChangeProtoJob.class).withIdentity(jobName, "UpdateProto").usingJobData(pmap).storeDurably().build();
                try {
                    CronTrigger protoTrigger = TriggerBuilder.newTrigger().withIdentity(jobName, "rereadProto").withSchedule(CronScheduleBuilder.cronSchedule(pconfig.change)).build();
                    this.scheduler.scheduleJob(protoJob, protoTrigger);
                    if (logger != null) {
                        logger.info("Schedule proto update for '{}' cronExpr={}", (Object)config.collectionName, (Object)pconfig.change);
                    }
                }
                catch (Throwable e) {
                    if (logger == null) break block23;
                    logger.error("cronExecutor failed to schedule RereadProtoJob", e);
                }
            }
        }
    }

    public void shutdown() {
        if (this.scheduler == null) {
            return;
        }
        try {
            this.scheduler.shutdown(true);
            Logger logServerStartup = LoggerFactory.getLogger("serverStartup");
            logServerStartup.info("Scheduler shutdown");
        }
        catch (Throwable e) {
            startupLogger.error("Scheduler failed to shutdown", e);
            this.scheduler = null;
        }
    }

    public void triggerUpdate(String collectionName, CollectionUpdateType triggerType) {
        JobDataMap map = new JobDataMap();
        map.put(UpdateType, (Object)triggerType);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(collectionName + "-trigger", triggerType.toString()).forJob(collectionName, "UpdateCollection").usingJobData(map).startNow().build();
        try {
            this.scheduler.scheduleJob(trigger);
        }
        catch (Throwable e) {
            startupLogger.error("triggerUpdate failed", e);
        }
    }

    static {
        startupLogger = LoggerFactory.getLogger(CollectionUpdater.class);
        disabled = false;
    }

    public static class ChangeProtoJob
    implements Job {
        @Override
        public void execute(JobExecutionContext context) throws JobExecutionException {
            block3: {
                CollectionUpdateListener manager = (CollectionUpdateListener)context.getJobDetail().getJobDataMap().get(CollectionUpdater.DCM_NAME);
                Logger loggerfc = (Logger)context.getJobDetail().getJobDataMap().get(CollectionUpdater.LOGGER);
                try {
                    if (loggerfc != null) {
                        loggerfc.info("ResetProto for {}", (Object)manager.getCollectionName());
                    }
                }
                catch (Throwable e) {
                    if (loggerfc == null) break block3;
                    loggerfc.error("ChangeProtoJob.execute failed collection=" + manager.getCollectionName(), e);
                }
            }
        }
    }

    public static class UpdateCollectionJob
    implements Job {
        @Override
        public void execute(JobExecutionContext context) throws JobExecutionException {
            block2: {
                CollectionUpdateListener manager = (CollectionUpdateListener)context.getJobDetail().getJobDataMap().get(CollectionUpdater.DCM_NAME);
                Logger loggerfc = (Logger)context.getJobDetail().getJobDataMap().get(CollectionUpdater.LOGGER);
                CollectionUpdateType type = (CollectionUpdateType)((Object)context.getTrigger().getJobDataMap().get(CollectionUpdater.UpdateType));
                String groupName = context.getTrigger().getKey().getGroup();
                try {
                    manager.sendEvent(type);
                    startupLogger.debug("CollectionUpdate {} on {}", (Object)type, (Object)manager.getCollectionName());
                }
                catch (Throwable e) {
                    if (loggerfc == null) break block2;
                    loggerfc.error("UpdateCollectionJob.execute " + groupName + " failed collection=" + manager.getCollectionName(), e);
                }
            }
        }
    }
}

