/*
 * Decompiled with CFR 0.152.
 */
package thredds.logs;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import ucar.unidata.util.StringUtil2;

public class PathMatcher {
    private final TreeMap<String, Match> treeMap = new TreeMap(new PathComparator());
    private static boolean debug = false;

    public void put(String root) {
        this.treeMap.put(root, new Match(root));
    }

    public Match get(String key) {
        return this.treeMap.get(key);
    }

    public Iterator iterator() {
        return this.treeMap.values().iterator();
    }

    public Match match(String path) {
        SortedMap<String, Match> tail = this.treeMap.tailMap(path);
        if (tail.isEmpty()) {
            return null;
        }
        String after = tail.firstKey();
        if (path.startsWith(after)) {
            return this.treeMap.get(after);
        }
        for (String key : tail.keySet()) {
            if (path.startsWith(key)) {
                return this.treeMap.get(key);
            }
            if (StringUtil2.match(path, key) != 0) continue;
            break;
        }
        return null;
    }

    private void doit(String s) {
        System.out.println(s + " == " + this.match(s));
    }

    public static void main(String[] args) {
        PathMatcher m = new PathMatcher();
        m.put("/thredds/dods/test/longer");
        m.put("/thredds/dods/test");
        m.put("/thredds/dods/tester");
        m.put("/thredds/dods/short");
        m.put("/actionable");
        m.put("myworld");
        m.put("mynot");
        m.put("ncmodels");
        m.put("ncmodels/bzipped");
        m.doit("nope");
        m.doit("/thredds/dods/test");
        m.doit("/thredds/dods/test/lo");
        m.doit("/thredds/dods/test/longer/donger");
        m.doit("myworldly");
        m.doit("/my");
        m.doit("mysnot");
        debug = true;
        m.doit("ncmodels/canonical");
    }

    private static class PathComparator
    implements Comparator<String>,
    Serializable {
        private PathComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int compare = -1 * o1.compareTo(o2);
            if (debug) {
                System.out.println(" compare " + o1 + " to " + o2 + " = " + compare);
            }
            return compare;
        }
    }

    public static class Match {
        public String root;

        Match(String root) {
            this.root = root;
        }
    }
}

