/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import ucar.nc2.ui.table.JTreeTable;
import ucar.nc2.ui.table.TableRow;
import ucar.nc2.ui.table.TreeTableModelSorted;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.MyMouseAdapter;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.util.ListenerManager;
import ucar.util.prefs.PreferencesExt;

public class JTreeTableSorted
extends JPanel {
    private static Icon sortDownIcon = BAMutil.getIcon("SortDown", true);
    private static Icon sortUpIcon = BAMutil.getIcon("SortUp", true);
    private static Icon threadSortIcon = BAMutil.getIcon("ThreadSorted", true);
    private static Icon threadUnSortIcon = BAMutil.getIcon("ThreadUnsorted", true);
    private JTreeTable table;
    private TreeTableModelSorted model;
    private ThreadHeaderRenderer threadHeaderRenderer = null;
    private int threadCol = -1;
    private TableRow selectedRow;
    private JScrollPane scrollPane;
    private PopupMenu popupMenu = null;
    private PopupAction[] acts;
    private boolean treeSort;
    private boolean useThreads;
    private ListenerManager lm;
    private ListSelectionEvent listSelectionEvent = null;
    private MouseAdapter allowSortColChangeMouseListener;
    private boolean allowSortColChange = false;
    private boolean debug = false;
    private boolean debugSetPath = false;
    private boolean debugEvent = false;

    public JTreeTableSorted(TreeTableModelSorted m, boolean allowSortColChange) {
        this.model = m;
        this.useThreads = this.model.useThreads();
        this.treeSort = this.model.isTreeSort();
        this.table = new JTreeTable(this.model);
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, "Center");
        this.table.setAutoResizeMode(2);
        TableColumnModel tcm = this.table.getColumnModel();
        int ncolwt = this.useThreads ? this.table.getColumnCount() - 1 : this.table.getColumnCount();
        for (int i = 0; i < ncolwt; ++i) {
            TableColumn tc = tcm.getColumn(i);
            tc.setHeaderRenderer(new SortedHeaderRenderer(this.model.getColumnName(i), i));
        }
        if (this.useThreads) {
            this.threadCol = ncolwt;
            this.threadHeaderRenderer = new ThreadHeaderRenderer(this.threadCol);
            tcm.getColumn(this.threadCol).setHeaderRenderer(this.threadHeaderRenderer);
        }
        this.popupMenu = new PopupMenu(this.table.getTableHeader(), "Visible");
        int ncols = this.model.getColumnCount();
        this.acts = new PopupAction[ncols];
        for (int i = 0; i < ncols; ++i) {
            this.acts[i] = new PopupAction(this.model.getColumnName(i));
            this.popupMenu.addActionCheckBox(this.model.getColumnName(i), this.acts[i], true);
        }
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && JTreeTableSorted.this.lm.hasListeners() && JTreeTableSorted.this.listSelectionEvent == null) {
                    JTreeTableSorted.this.listSelectionEvent = e;
                    if (JTreeTableSorted.this.debugEvent) {
                        System.out.println(" JTreeTableSorted message selected = " + e);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JTreeTableSorted.this.lm.sendEvent(JTreeTableSorted.this.listSelectionEvent);
                            JTreeTableSorted.this.listSelectionEvent = null;
                        }
                    });
                }
            }
        });
        this.allowSortColChangeMouseListener = new MyMouseAdapter(){

            @Override
            public void click(MouseEvent e) {
                TableColumnModel tcm2 = JTreeTableSorted.this.table.getColumnModel();
                int colIdx = tcm2.getColumnIndexAtX(e.getX());
                int colNo = JTreeTableSorted.this.table.convertColumnIndexToModel(colIdx);
                JTreeTableSorted.this.selectedRow = JTreeTableSorted.this.getSelectedRow();
                if (JTreeTableSorted.this.debug) {
                    System.out.println("----selectedRow = " + JTreeTableSorted.this.selectedRow);
                }
                if (colNo == JTreeTableSorted.this.threadCol) {
                    JTreeTableSorted.this.threadHeaderRenderer.setOn(!((JTreeTableSorted)JTreeTableSorted.this).threadHeaderRenderer.isOn);
                    JTreeTableSorted.this.model.setThreadsOn(((JTreeTableSorted)JTreeTableSorted.this).threadHeaderRenderer.isOn);
                    JTreeTableSorted.this.model.sort();
                } else {
                    boolean reverse = JTreeTableSorted.this.model.sort(colNo);
                    JTreeTableSorted.this.setSortCol(colNo, reverse);
                }
                JTreeTableSorted.this.table.fireDataChanged();
                JTreeTableSorted.this.invokeSetPath();
            }
        };
        this.allowSortColChange(allowSortColChange);
        this.lm = new ListenerManager("javax.swing.event.ListSelectionListener", "javax.swing.event.ListSelectionEvent", "valueChanged");
        this.setSortCol(this.model.getSortCol(), this.model.getReverse());
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.lm.addListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.lm.removeListener(l);
    }

    public void allowSortColChange(boolean allow) {
        JTableHeader hdr = this.table.getTableHeader();
        if (allow && !this.allowSortColChange) {
            hdr.addMouseListener(this.allowSortColChangeMouseListener);
        } else if (!allow && this.allowSortColChange) {
            hdr.removeMouseListener(this.allowSortColChangeMouseListener);
        }
        this.allowSortColChange = allow;
    }

    public TreeTableModelSorted getModel() {
        return this.model;
    }

    public JTable getTable() {
        return this.table;
    }

    public TableRow getRow(int row) {
        return this.model.getRow(this.table.getPathForRow(row));
    }

    public void restoreState(PreferencesExt store) {
        Object colWidths;
        if (store == null) {
            return;
        }
        int ncols = this.table.getColumnCount();
        int[] modelIndex = (int[])store.getBean("ColumnOrder", null);
        if (modelIndex != null && modelIndex.length == ncols) {
            boolean[] visible = new boolean[ncols];
            for (int aModelIndex : modelIndex) {
                if (aModelIndex >= ncols) continue;
                visible[aModelIndex] = true;
            }
            for (int i = 0; i < ncols; ++i) {
                if (visible[i]) continue;
                this.acts[i].hideColumn();
                this.acts[i].putValue("state", new Boolean(false));
            }
            TableColumnModel tcm = this.table.getColumnModel();
            int n = Math.min(modelIndex.length, this.table.getColumnCount());
            for (int i = 0; i < n; ++i) {
                TableColumn tc = tcm.getColumn(i);
                tc.setModelIndex(modelIndex[i]);
                String name = this.model.getColumnName(modelIndex[i]);
                tc.setHeaderValue(name);
                tc.setIdentifier(name);
                if (this.useThreads && modelIndex[i] == this.threadCol) {
                    this.threadHeaderRenderer = new ThreadHeaderRenderer(this.threadCol);
                    tc.setHeaderRenderer(this.threadHeaderRenderer);
                    continue;
                }
                tc.setHeaderRenderer(new SortedHeaderRenderer(name, modelIndex[i]));
            }
        }
        if ((colWidths = store.getBean("ColumnWidths", null)) == null) {
            return;
        }
        int[] size = (int[])colWidths;
        this.setColumnWidths(size);
        if (this.debug) {
            System.out.println(" read widths = ");
            for (int aSize : size) {
                System.out.print(" " + aSize);
            }
            System.out.println();
        }
        boolean isThreadsOn = store.getBoolean("isThreadsOn", false);
        if (this.useThreads) {
            this.model.setThreadsOn(isThreadsOn);
            this.threadHeaderRenderer.setOn(isThreadsOn);
        }
        int colNo = store.getInt("SortOnCol", 0);
        boolean reverse = store.getBoolean("SortReverse", false);
        this.model.setSortCol(colNo);
        this.model.setReverse(reverse);
        this.setSortCol(colNo, reverse);
        this.model.sort();
        this.table.fireDataChanged();
    }

    private void setColumnWidths(int[] sizes) {
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            int maxw = sizes == null || i >= sizes.length ? 10 : sizes[i];
            tc.setPreferredWidth(maxw);
        }
    }

    public void setColOn(int colno, boolean state, int pos) {
        this.acts[colno].putValue("state", new Boolean(state));
        if (state) {
            this.acts[colno].addAtPos(pos);
        } else {
            this.acts[colno].hideColumn();
        }
    }

    @Override
    public void registerKeyboardAction(ActionListener act, KeyStroke key, int when) {
        this.table.registerKeyboardAction(act, key, when);
    }

    public void setFontSize(int size) {
        this.table.setFont(this.table.getFont().deriveFont((float)size));
    }

    public void saveState(PreferencesExt store) {
        if (store == null) {
            return;
        }
        int ncols = this.table.getColumnCount();
        int[] size = new int[ncols];
        int[] modelIndex = new int[ncols];
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < ncols; ++i) {
            TableColumn tc = tcm.getColumn(i);
            size[i] = tc.getWidth();
            modelIndex[i] = tc.getModelIndex();
        }
        store.putBeanObject("ColumnWidths", size);
        store.putBeanObject("ColumnOrder", modelIndex);
        store.putInt("SortOnCol", this.model.getSortCol());
        store.putBoolean("SortReverse", this.model.getReverse());
        store.putBoolean("isThreadsOn", this.model.isThreadsOn());
        if (this.debug) {
            System.out.println(" store widths = ");
            for (int aSize : size) {
                System.out.print(" " + aSize);
            }
            System.out.println();
        }
    }

    public ArrayList getRows() {
        return this.model.getRows();
    }

    public void setRows(ArrayList rows) {
        this.model.setRows(rows);
        this.table.fireDataChanged();
    }

    public TableRow getSelectedRow() {
        return this.model.getRow(this.table.getSelectionPath());
    }

    public Iterator getSelectedRows() {
        TreePath[] paths = this.table.getSelectionPaths();
        if (paths == null || paths.length < 1) {
            return null;
        }
        HashSet set = new HashSet(2 * paths.length);
        for (TreePath path : paths) {
            this.model.addRowsToSetFromPath(this.table.getTree(), path, set);
        }
        return set.iterator();
    }

    public void setSelectedRow(int rowno) {
        if (rowno < 0 || rowno >= this.model.getRowCount()) {
            return;
        }
        if (this.debugSetPath) {
            System.out.println("TreeTableSorted setSelected " + rowno);
        }
        this.selectedRow = this.model.getRow(rowno);
        TreePath path = this.model.getPath(this.selectedRow);
        if (path != null) {
            this.table.setSelectionPath(path);
        }
        this.invokeSetPath();
        this.ensureRowIsVisible(rowno);
    }

    private void invokeSetPath() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath path = JTreeTableSorted.this.model.getPath(JTreeTableSorted.this.selectedRow);
                if (path != null) {
                    int rowno = JTreeTableSorted.this.table.setSelectionPath(path);
                    if (rowno >= 0) {
                        JTreeTableSorted.this.ensureRowIsVisible(rowno);
                    }
                    if (JTreeTableSorted.this.debugSetPath) {
                        System.out.println("----reset selectedRow = " + rowno + " " + path);
                    }
                }
            }
        });
    }

    public void incrSelected(boolean increment) {
        int rowno = this.table.incrSelected(increment);
        if (rowno > 0) {
            this.ensureRowIsVisible(rowno);
        }
    }

    public void setDefaultRenderer(Class columnClass, TableCellRenderer renderer) {
        this.table.setDefaultRenderer(columnClass, renderer);
    }

    public int[] getModelIndex() {
        int[] modelIndex = new int[this.model.getColumnCount()];
        try {
            TableColumnModel tcm = this.table.getColumnModel();
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                TableColumn tc = tcm.getColumn(i);
                modelIndex[i] = tc.getModelIndex();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return modelIndex;
    }

    private void ensureRowIsVisible(int nRow) {
        Rectangle visibleRect = this.table.getCellRect(nRow, 0, true);
        if (this.debugSetPath) {
            System.out.println("----ensureRowIsVisible = " + visibleRect);
        }
        if (visibleRect != null) {
            visibleRect.x = this.scrollPane.getViewport().getViewPosition().x;
            this.table.scrollRectToVisible(visibleRect);
            this.table.repaint();
        }
    }

    public void setSortCol(int sortCol, boolean reverse) {
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tc = tcm.getColumn(i);
            SortedHeaderRenderer shr = (SortedHeaderRenderer)tc.getHeaderRenderer();
            shr.setSortCol(sortCol, reverse);
        }
    }

    private class ThreadHeaderRenderer
    extends SortedHeaderRenderer {
        JPanel sort;
        JPanel unsort;
        boolean isOn;

        ThreadHeaderRenderer(int modelCol) {
            super(modelCol);
            this.isOn = false;
            this.sort = new JPanel(new BorderLayout());
            this.sort.setBorder(new BevelBorder(0));
            this.sort.add((Component)new JLabel(threadSortIcon), "Center");
            this.unsort = new JPanel(new BorderLayout());
            this.unsort.setBorder(new BevelBorder(0));
            this.unsort.add((Component)new JLabel(threadUnSortIcon), "Center");
            this.comp = this.unsort;
        }

        void setOn(boolean setOn) {
            this.isOn = setOn;
            this.comp = this.isOn ? this.sort : this.unsort;
        }

        @Override
        void setSortCol(int sortCol, boolean reverse) {
        }
    }

    private class SortedHeaderRenderer
    implements TableCellRenderer {
        int modelCol;
        Component comp;
        JPanel compPanel;
        JLabel upLabel;
        JLabel downLabel;
        boolean hasSortIndicator = false;
        boolean reverse = false;

        protected SortedHeaderRenderer(int modelCol) {
            this.modelCol = modelCol;
        }

        SortedHeaderRenderer(String name, int modelCol) {
            this.modelCol = modelCol;
            this.upLabel = new JLabel(sortUpIcon);
            this.downLabel = new JLabel(sortDownIcon);
            this.compPanel = new JPanel(new BorderLayout());
            this.compPanel.setBorder(new BevelBorder(0));
            this.compPanel.add((Component)new JLabel(name), "Center");
            this.comp = this.compPanel;
        }

        void setSortCol(int sortCol, boolean reverse) {
            if (sortCol == this.modelCol) {
                if (!this.hasSortIndicator) {
                    this.compPanel.add((Component)(reverse ? this.upLabel : this.downLabel), "East");
                } else if (reverse != this.reverse) {
                    this.compPanel.remove(1);
                    this.compPanel.add((Component)(reverse ? this.upLabel : this.downLabel), "East");
                }
                this.reverse = reverse;
                this.hasSortIndicator = true;
            } else if (this.hasSortIndicator) {
                this.compPanel.remove(1);
                this.hasSortIndicator = false;
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.comp;
        }
    }

    private class PopupAction
    extends AbstractAction {
        private String id;
        private TableColumn tc = null;

        PopupAction(String id) {
            this.id = id;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean state = (Boolean)this.getValue("state");
            TableColumnModel tcm = JTreeTableSorted.this.table.getColumnModel();
            if (state) {
                if (this.tc != null) {
                    tcm.addColumn(this.tc);
                }
            } else {
                this.hideColumn();
            }
            JTreeTableSorted.this.revalidate();
        }

        public void addAtPos(int pos) {
            if (this.tc == null) {
                return;
            }
            TableColumnModel tcm = JTreeTableSorted.this.table.getColumnModel();
            try {
                tcm.addColumn(this.tc);
                int idx = tcm.getColumnIndex(this.id);
                tcm.moveColumn(idx, 0);
            }
            catch (Exception e) {
                System.out.println("addAtPos failed" + e);
            }
        }

        public void hideColumn() {
            TableColumnModel tcm = JTreeTableSorted.this.table.getColumnModel();
            int idx = tcm.getColumnIndex(this.id);
            this.tc = tcm.getColumn(idx);
            tcm.removeColumn(this.tc);
        }
    }
}

