/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionAbstract;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.ma2.DataType;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.grib1.Grib1Gds;
import ucar.nc2.grib.grib1.Grib1Index;
import ucar.nc2.grib.grib1.Grib1ParamLevel;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionBitMap;
import ucar.nc2.grib.grib1.Grib1SectionGridDefinition;
import ucar.nc2.grib.grib1.Grib1SectionIndicator;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.Grib1Variable;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.ui.grib.Grib1CollectionPanel;
import ucar.nc2.ui.grib.Grib2DataPanel;
import ucar.nc2.ui.widget.BAMutil;
import ucar.nc2.ui.widget.FileManager;
import ucar.nc2.ui.widget.IndependentWindow;
import ucar.nc2.ui.widget.PopupMenu;
import ucar.nc2.ui.widget.TextHistoryPane;
import ucar.nc2.util.Misc;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTable;

public class Grib1DataTable
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(Grib2DataPanel.class);
    private PreferencesExt prefs;
    private BeanTable param1BeanTable;
    private BeanTable record1BeanTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoPopup;
    private TextHistoryPane infoPopup2;
    private TextHistoryPane drsInfo;
    private IndependentWindow infoWindow;
    private IndependentWindow infoWindow2;
    private FileManager fileChooser;
    private String spec;
    private MCollection dcm;
    private List<MFile> fileList;
    private Grib1Customizer cust;
    private FeatureCollectionConfig config = new FeatureCollectionConfig();

    public Grib1DataTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.param1BeanTable = new BeanTable(Grib1ParameterBean.class, (PreferencesExt)prefs.node("Param1Bean"), false, "UniquePDSVariables", "from Grib2Input.getRecords()", null);
        this.param1BeanTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Grib1ParameterBean pb = (Grib1ParameterBean)Grib1DataTable.this.param1BeanTable.getSelectedBean();
                if (pb != null) {
                    Grib1DataTable.this.record1BeanTable.setBeans(pb.getRecordBeans());
                }
            }
        });
        PopupMenu varPopup = new PopupMenu(this.param1BeanTable.getJTable(), "Options");
        varPopup.addAction("Show raw PDS bytes", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1ParameterBean pb = (Grib1ParameterBean)Grib1DataTable.this.param1BeanTable.getSelectedBean();
                if (pb != null) {
                    Formatter f = new Formatter();
                    Grib1CollectionPanel.showRawPds(pb.pds, f);
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show processed PDS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1ParameterBean pbean = (Grib1ParameterBean)Grib1DataTable.this.param1BeanTable.getSelectedBean();
                if (pbean != null) {
                    Formatter f = new Formatter();
                    pbean.pds.showPds(Grib1DataTable.this.cust, f);
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        this.record1BeanTable = new BeanTable(Grib1RecordBean.class, (PreferencesExt)prefs.node("Record2Bean"), false, "DataRepresentation", "from Grib2Input.getRecords()", null);
        varPopup = new PopupMenu(this.record1BeanTable.getJTable(), "Options");
        varPopup.addAction("Show raw PDS bytes", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1RecordBean bean = (Grib1RecordBean)Grib1DataTable.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib1CollectionPanel.showRawPds(bean.pds, f);
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show Complete Grib1 Record", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1RecordBean bean = (Grib1RecordBean)Grib1DataTable.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    String filename = ((MFile)Grib1DataTable.this.fileList.get(bean.gr.getFile())).getPath();
                    Grib1CollectionPanel.showCompleteRecord(Grib1DataTable.this.cust, bean.gr, filename, f);
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Compare Grib1 Records", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib1DataTable.this.record1BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    Grib1RecordBean bean1 = (Grib1RecordBean)list.get(0);
                    Grib1RecordBean bean2 = (Grib1RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    Grib1DataTable.this.compare(bean1, bean2, f);
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Compare Data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List list = Grib1DataTable.this.record1BeanTable.getSelectedBeans();
                if (list.size() == 2) {
                    Grib1RecordBean bean1 = (Grib1RecordBean)list.get(0);
                    Grib1RecordBean bean2 = (Grib1RecordBean)list.get(1);
                    Formatter f = new Formatter();
                    Grib1DataTable.this.compareData(bean1, bean2, f);
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show Data Cubic Interpolation", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1RecordBean bean = (Grib1RecordBean)Grib1DataTable.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib1DataTable.this.showData(bean, true, GribData.InterpolationMethod.cubic, f);
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show Data Max/Min", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1RecordBean bean = (Grib1RecordBean)Grib1DataTable.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib1DataTable.this.showData(bean, false, GribData.InterpolationMethod.none, f);
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show Data Raw", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1RecordBean bean = (Grib1RecordBean)Grib1DataTable.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib1DataTable.this.showData(bean, true, GribData.InterpolationMethod.none, f);
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Show Data Linear Interpretation", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1RecordBean bean = (Grib1RecordBean)Grib1DataTable.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    Grib1DataTable.this.showData(bean, true, GribData.InterpolationMethod.none, f);
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Extract GribRecord to File", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List beans = Grib1DataTable.this.record1BeanTable.getSelectedBeans();
                if (beans.size() > 0) {
                    Grib1DataTable.this.writeToFile(beans);
                }
            }
        });
        varPopup.addAction("Show Bitmap", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1RecordBean bean = (Grib1RecordBean)Grib1DataTable.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    try {
                        Grib1DataTable.this.showBitmap(bean, f);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        varPopup.addAction("Compute Scale/offset of data", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Grib1RecordBean bean = (Grib1RecordBean)Grib1DataTable.this.record1BeanTable.getSelectedBean();
                if (bean != null) {
                    Formatter f = new Formatter();
                    GribData.calcScaleOffset(bean, f);
                    Grib1DataTable.this.infoPopup2.setText(f.toString());
                    Grib1DataTable.this.infoPopup2.gotoTop();
                    Grib1DataTable.this.infoWindow2.show();
                }
            }
        });
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.infoPopup2 = new TextHistoryPane();
        this.infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup2);
        this.infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", new Rectangle(300, 300, 500, 300)));
        this.drsInfo = new TextHistoryPane();
        this.setLayout(new BorderLayout());
        this.split2 = new JSplitPane(0, false, this.param1BeanTable, this.record1BeanTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.split2, this.drsInfo);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.param1BeanTable.saveState(false);
        this.record1BeanTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putBeanObject("InfoWindowBounds2", this.infoWindow2.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
    }

    public void setCollection(String spec) throws IOException {
        this.spec = spec;
        this.cust = null;
        Formatter f = new Formatter();
        this.dcm = this.scanCollection(spec, f);
        if (this.dcm == null) {
            JOptionPane.showMessageDialog(this, "Collection is null\n" + f.toString());
            return;
        }
        HashMap<Integer, Grib1ParameterBean> pdsSet = new HashMap<Integer, Grib1ParameterBean>();
        HashMap<Integer, Grib1SectionGridDefinition> gdsSet = new HashMap<Integer, Grib1SectionGridDefinition>();
        ArrayList<Grib1ParameterBean> params = new ArrayList<Grib1ParameterBean>();
        int fileno = 0;
        for (MFile mfile : this.fileList) {
            f.format("%n %s%n", mfile.getPath());
            RandomAccessFile raf = new RandomAccessFile(mfile.getPath(), "r");
            Throwable throwable = null;
            try {
                raf.order(ByteOrder.BIG_ENDIAN);
                this.processGribFile(mfile, fileno++, raf, pdsSet, gdsSet, params, f);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (raf == null) continue;
                if (throwable != null) {
                    try {
                        raf.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                raf.close();
            }
        }
        this.param1BeanTable.setBeans(params);
    }

    private void processGribFile(MFile mfile, int fileno, RandomAccessFile raf, Map<Integer, Grib1ParameterBean> pdsSet, Map<Integer, Grib1SectionGridDefinition> gdsSet, List<Grib1ParameterBean> params, Formatter f) throws IOException {
        Grib1Index index = new Grib1Index();
        if (!index.readIndex(mfile.getPath(), mfile.getLastModified())) {
            index.makeIndex(mfile.getPath(), null);
        }
        for (Grib1SectionGridDefinition gds : index.getGds()) {
            int hash = gds.getGDS().hashCode();
            if (gdsSet.get(hash) != null) continue;
            gdsSet.put(hash, gds);
        }
        for (Grib1Record gr : index.getRecords()) {
            if (this.cust == null) {
                this.cust = Grib1Customizer.factory(gr, null);
            }
            gr.setFile(fileno);
            int id = Grib1Variable.cdmVariableHash(this.cust, gr, 0, FeatureCollectionConfig.useTableVersionDef, FeatureCollectionConfig.intvMergeDef, FeatureCollectionConfig.useCenterDef);
            Grib1ParameterBean bean = pdsSet.get(id);
            if (bean == null) {
                bean = new Grib1ParameterBean(gr);
                pdsSet.put(id, bean);
                params.add(bean);
            }
            bean.addRecord(gr, raf);
        }
    }

    private MCollection scanCollection(String spec, Formatter f) {
        MCollection dc = null;
        try {
            dc = CollectionAbstract.open(spec, spec, null, f);
            this.fileList = Misc.getList(dc.getFilesSorted());
            return dc;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            f.format(sw.toString(), new Object[0]);
            if (dc != null) {
                dc.close();
            }
            return null;
        }
    }

    public void showCollection(Formatter f) {
        if (this.dcm == null) {
            if (this.spec == null) {
                return;
            }
            this.dcm = this.scanCollection(this.spec, f);
            if (this.dcm == null) {
                return;
            }
        }
        f.format("dcm = %s%n", this.dcm);
        try {
            for (MFile mfile : this.dcm.getFilesSorted()) {
                f.format("  %s%n", mfile.getPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap groups = new HashMap();
        for (Object o : this.param1BeanTable.getBeans()) {
            Grib1ParameterBean p = (Grib1ParameterBean)o;
            int gdsHash = p.gr.getGDSsection().getGDS().hashCode();
            TreeSet<Integer> group = (TreeSet<Integer>)groups.get(gdsHash);
            if (group == null) {
                group = new TreeSet<Integer>();
                groups.put(gdsHash, group);
            }
            for (Grib1RecordBean r : p.getRecordBeans()) {
                group.add(r.gr.getFile());
            }
        }
    }

    public void checkProblems(Formatter f) {
        this.checkDuplicates(f);
    }

    private void checkDuplicates(Formatter f) {
        HashSet<Long> pdsMap = new HashSet<Long>();
        int dups = 0;
        int count = 0;
        HashMap<CalendarDate, DateCount> dateMap = new HashMap<CalendarDate, DateCount>();
        List params = this.param1BeanTable.getBeans();
        for (Grib1ParameterBean param : params) {
            for (Grib1RecordBean record : param.getRecordBeans()) {
                CalendarDate d = record.gr.getReferenceDate();
                DateCount dc = (DateCount)dateMap.get(d);
                if (dc == null) {
                    dc = new DateCount(d);
                    dateMap.put(d, dc);
                }
                ++dc.count;
                Grib1SectionProductDefinition pdss = record.gr.getPDSsection();
                long crc = pdss.calcCRC();
                if (pdsMap.contains(crc)) {
                    ++dups;
                } else {
                    pdsMap.add(crc);
                }
                ++count;
            }
        }
        f.format("PDS duplicates = %d / %d%n%n", dups, count);
        ArrayList dcList = new ArrayList(dateMap.values());
        Collections.sort(dcList);
        f.format("Run Dates%n", new Object[0]);
        int total = 0;
        for (DateCount dc : dcList) {
            f.format(" %s == %d%n", dc.d, dc.count);
            total += dc.count;
        }
        f.format("total records = %d%n", total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(List beans) {
        if (this.fileChooser == null) {
            this.fileChooser = new FileManager(null, null, null, (PreferencesExt)this.prefs.node("FileManager"));
        }
        FileOutputStream fos = null;
        java.io.RandomAccessFile raf = null;
        try {
            String filename = null;
            boolean append = false;
            int n = 0;
            MFile curr = null;
            for (Object o : beans) {
                Grib1RecordBean bean = (Grib1RecordBean)o;
                MFile mfile = this.fileList.get(bean.gr.getFile());
                if (curr == null || curr != mfile) {
                    if (raf != null) {
                        raf.close();
                    }
                    raf = new java.io.RandomAccessFile(mfile.getPath(), "r");
                    curr = mfile;
                }
                if (fos == null) {
                    String defloc = mfile.getPath();
                    filename = this.fileChooser.chooseFilenameToSave(defloc + ".grib2");
                    if (filename == null) {
                        return;
                    }
                    File f = new File(filename);
                    append = f.exists();
                    fos = new FileOutputStream(filename, append);
                }
                Grib1SectionIndicator is = bean.gr.getIs();
                int size = (int)is.getMessageLength();
                long startPos = is.getStartPos();
                if (startPos < 0L) {
                    JOptionPane.showMessageDialog(this, "Old index does not have message start - record not written");
                }
                byte[] rb = new byte[size];
                raf.seek(startPos);
                raf.readFully(rb);
                fos.write(rb);
                ++n;
            }
            JOptionPane.showMessageDialog(this, filename + ": " + n + " records successfully written, append=" + append);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ex.getMessage());
            ex.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (raf != null) {
                    raf.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void compareData(Grib1RecordBean bean1, Grib1RecordBean bean2, Formatter f) {
        float[] data1 = null;
        float[] data2 = null;
        try {
            data1 = bean1.readData();
            data2 = bean2.readData();
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        Misc.compare(data1, data2, f);
    }

    private void compare(Grib1RecordBean bean1, Grib1RecordBean bean2, Formatter f) {
        Grib1CollectionPanel.compare(bean1.gr.getPDSsection(), bean2.gr.getPDSsection(), f);
        Grib1CollectionPanel.compare(bean1.gr.getGDSsection(), bean2.gr.getGDSsection(), f);
    }

    private void showData(Grib1RecordBean bean1, boolean showData, GribData.InterpolationMethod method, Formatter f) {
        float[] data;
        try {
            data = bean1.readData(method);
        }
        catch (IOException e) {
            f.format("IOException %s", e.getMessage());
            return;
        }
        float max = -3.4028235E38f;
        float min = Float.MAX_VALUE;
        for (float fd : data) {
            if (showData) {
                f.format("%f%n", Float.valueOf(fd));
            }
            if (Float.isNaN(fd)) continue;
            max = Math.max(fd, max);
            min = Math.min(fd, min);
        }
        f.format("max = %f%n", Float.valueOf(max));
        f.format("min = %f%n", Float.valueOf(min));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showBitmap(Grib1RecordBean bean1, Formatter f) throws IOException {
        byte[] bitmap;
        try (RandomAccessFile raf = null;){
            raf = bean1.getRaf();
            Grib1SectionBitMap bms = bean1.gr.getBitMapSection();
            f.format("%s%n", bms);
            bitmap = bms.getBitmap(raf);
        }
        if (bitmap == null) {
            f.format(" no bitmap%n", new Object[0]);
            return;
        }
        int count = 0;
        int bits = 0;
        for (byte b : bitmap) {
            short s = DataType.unsignedByteToShort(b);
            bits += Long.bitCount(s);
            f.format("%8s", Long.toBinaryString(s));
            if (++count % 10 != 0) continue;
            f.format("%n", new Object[0]);
        }
        f.format("%n%n#bits on = %d%n", bits);
        f.format("bitmap size = %d%n", 8 * count);
    }

    static void showBytes(Formatter f, byte[] buff) {
        for (int n : buff) {
            int ub;
            int n2 = ub = n < 0 ? n + 256 : n;
            if (n >= 32 && n < 127) {
                f.format("%s", Character.valueOf((char)ub));
                continue;
            }
            f.format("(%d)", ub);
        }
    }

    public static void main(String[] arg) {
        float add_offset = 143.988f;
        float scale_factor = 6.14654E-4f;
        float fd = 339.029f;
        System.out.printf("res = %f%n", Float.valueOf(scale_factor / 2.0f));
        int packed_data = Math.round((fd - add_offset) / scale_factor);
        float unpacked_data = (float)packed_data * scale_factor + add_offset;
        float diff = Math.abs(fd - unpacked_data);
        System.out.printf("***   org=%f, packed_data=%d unpacked=%f diff = %f%n", Float.valueOf(fd), packed_data, Float.valueOf(unpacked_data), Float.valueOf(diff));
        unpacked_data = (float)(++packed_data) * scale_factor + add_offset;
        diff = Math.abs(fd - unpacked_data);
        System.out.printf("***   org=%f, packed_data+1=%d unpacked=%f diff = %f%n", Float.valueOf(fd), packed_data, Float.valueOf(unpacked_data), Float.valueOf(diff));
        unpacked_data = (float)(packed_data -= 2) * scale_factor + add_offset;
        diff = Math.abs(fd - unpacked_data);
        System.out.printf("***   org=%f, packed_data-1=%d unpacked=%f diff = %f%n", Float.valueOf(fd), packed_data, Float.valueOf(unpacked_data), Float.valueOf(diff));
    }

    public class Grib1RecordBean
    implements GribData.Bean {
        Grib1Record gr;
        Grib1SectionGridDefinition gds;
        Grib1SectionProductDefinition pds;
        Grib1ParamLevel plevel;
        Grib1ParamTime ptime;
        GribData.Info info;
        Grib1Gds gdss;
        double minimum;
        double maximum;
        double scale;

        public Grib1RecordBean() {
        }

        public Grib1RecordBean(Grib1Record m, RandomAccessFile raf) throws IOException {
            this.gr = m;
            this.gds = this.gr.getGDSsection();
            this.pds = this.gr.getPDSsection();
            this.gdss = this.gds.getGDS();
            this.plevel = Grib1DataTable.this.cust.getParamLevel(this.pds);
            this.ptime = this.gr.getParamTime(Grib1DataTable.this.cust);
            this.info = this.gr.getBinaryDataInfo(raf);
            double pow10 = Math.pow(10.0, -this.getDecScale());
            this.minimum = (float)(pow10 * (double)this.info.referenceValue);
            this.scale = (float)(pow10 * Math.pow(2.0, this.getBinScale()));
            double maxPacked = Math.pow(2.0, this.getNBits()) - 1.0;
            this.maximum = this.minimum + this.scale * maxPacked;
        }

        public String getTimeCoord() {
            if (this.ptime.isInterval()) {
                int[] intv = this.ptime.getInterval();
                return intv[0] + "-" + intv[1] + "(" + this.ptime.getIntervalSize() + ")";
            }
            return Integer.toString(this.ptime.getForecastTime());
        }

        public String getLevel() {
            if (Grib1DataTable.this.cust.isLayer(this.pds.getLevelType())) {
                return this.plevel.getValue1() + "-" + this.plevel.getValue2();
            }
            return Float.toString(this.plevel.getValue1());
        }

        public long getPos() {
            return this.gr.getDataSection().getStartingPosition();
        }

        public final int getFile() {
            return this.gr.getFile();
        }

        @Override
        public float[] readData() throws IOException {
            return this.readData(GribData.getInterpolationMethod());
        }

        public float[] readData(GribData.InterpolationMethod method) throws IOException {
            int fileno = this.gr.getFile();
            MFile mfile = (MFile)Grib1DataTable.this.fileList.get(fileno);
            try (RandomAccessFile raf = new RandomAccessFile(mfile.getPath(), "r");){
                raf.order(0);
                float[] fArray = this.gr.readDataRaw(raf, method);
                return fArray;
            }
        }

        @Override
        public int getNBits() {
            return this.info.numberOfBits;
        }

        @Override
        public long getDataLength() {
            return this.info.dataLength;
        }

        @Override
        public long getMsgLength() {
            return this.info.msgLength;
        }

        @Override
        public int getBinScale() {
            return this.info.binaryScaleFactor;
        }

        @Override
        public int getDecScale() {
            return this.info.decimalScaleFactor;
        }

        @Override
        public double getMinimum() {
            return this.minimum;
        }

        @Override
        public double getMaximum() {
            return this.maximum;
        }

        @Override
        public double getScale() {
            return this.scale;
        }

        public int getNDataPoints() {
            return this.info.ndataPoints;
        }

        public int getNPoints() {
            return this.info.nPoints;
        }

        public String getDataType() {
            return this.info.getDataTypeS();
        }

        public String getGridPoint() {
            return this.info.getGridPointS();
        }

        public String getPacking() {
            return this.info.getPackingS();
        }

        public float getAvgBits() {
            float len = this.getDataLength();
            int n = this.gdss.getNx() * this.gdss.getNy();
            return n == 0 ? 0.0f : len * 8.0f / (float)n;
        }

        void showDataRecord(Formatter f) {
            int fileno = this.gr.getFile();
            MFile mfile = (MFile)Grib1DataTable.this.fileList.get(fileno);
            try (RandomAccessFile raf = new RandomAccessFile(mfile.getPath(), "r");){
                raf.order(0);
                this.gr.showDataInfo(raf, f);
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error("showDataRecord", e);
            }
        }

        RandomAccessFile getRaf() throws IOException {
            int fileno = this.gr.getFile();
            MFile mfile = (MFile)Grib1DataTable.this.fileList.get(fileno);
            return new RandomAccessFile(mfile.getPath(), "r");
        }
    }

    public class Grib1ParameterBean {
        Grib1Record gr;
        Grib1SectionIndicator id;
        Grib1SectionProductDefinition pds;
        List<Grib1RecordBean> records;
        Grib1Parameter param;
        private int minBits;
        private int maxBits;
        private int minBinscale;
        private int maxBinscale;
        private int minDecscale;
        private int maxDecscale;
        private float nbits = -1.0f;
        private float avgbits;
        private float compress;

        public Grib1ParameterBean() {
        }

        public Grib1ParameterBean(Grib1Record r) throws IOException {
            this.gr = r;
            this.pds = r.getPDSsection();
            this.id = r.getIs();
            this.records = new ArrayList<Grib1RecordBean>();
            this.param = Grib1DataTable.this.cust.getParameter(this.pds.getCenter(), this.pds.getSubCenter(), this.pds.getTableVersion(), this.pds.getParameterNumber());
        }

        void addRecord(Grib1Record r, RandomAccessFile raf) throws IOException {
            this.records.add(new Grib1RecordBean(r, raf));
        }

        List<Grib1RecordBean> getRecordBeans() {
            return this.records;
        }

        public String getName() {
            if (this.param == null) {
                return null;
            }
            return Grib1Iosp.makeVariableName(Grib1DataTable.this.cust, ((Grib1DataTable)Grib1DataTable.this).config.gribConfig, this.pds);
        }

        public String getUnit() {
            return this.param == null ? null : this.param.getUnit();
        }

        public int getParamNo() {
            return this.pds.getParameterNumber();
        }

        public int getNRecords() {
            return this.records.size();
        }

        public int getLevelType() {
            return this.pds.getLevelType();
        }

        public final String getLevelName() {
            Grib1ParamLevel plevel = Grib1DataTable.this.cust.getParamLevel(this.pds);
            return plevel.getNameShort();
        }

        public String getNBits() {
            this.calcBits();
            if (this.minBits == this.maxBits) {
                return Integer.toString(this.minBits);
            }
            return this.minBits + "-" + this.maxBits;
        }

        public String getBinScale() {
            this.calcBits();
            if (this.minBinscale == this.maxBinscale) {
                return Integer.toString(this.minBinscale);
            }
            return this.minBinscale + "," + this.maxBinscale;
        }

        public String getDecScale() {
            this.calcBits();
            if (this.minDecscale == this.maxDecscale) {
                return Integer.toString(this.minDecscale);
            }
            return this.minDecscale + "," + this.maxDecscale;
        }

        public float getAvgBits() {
            this.calcBits();
            return this.avgbits;
        }

        public float getCompress() {
            this.calcBits();
            return this.compress;
        }

        private void calcBits() {
            if (this.nbits >= 0.0f) {
                return;
            }
            this.nbits = 0.0f;
            int count = 0;
            this.minBits = Integer.MAX_VALUE;
            this.minBinscale = Integer.MAX_VALUE;
            this.minDecscale = Integer.MAX_VALUE;
            for (Grib1RecordBean bean : this.records) {
                this.minBits = Math.min(this.minBits, bean.getNBits());
                this.maxBits = Math.max(this.maxBits, bean.getNBits());
                this.minBinscale = Math.min(this.minBinscale, bean.getBinScale());
                this.maxBinscale = Math.max(this.maxBinscale, bean.getBinScale());
                this.minDecscale = Math.min(this.minDecscale, bean.getDecScale());
                this.maxDecscale = Math.max(this.maxDecscale, bean.getDecScale());
                this.nbits += (float)bean.getNBits();
                this.avgbits += bean.getAvgBits();
                ++count;
            }
            this.compress = this.nbits / this.avgbits;
            if (count > 0) {
                this.nbits /= (float)count;
                this.avgbits /= (float)count;
            }
        }
    }

    private static class DateCount
    implements Comparable<DateCount> {
        CalendarDate d;
        int count;

        private DateCount(CalendarDate d) {
            this.d = d;
        }

        @Override
        public int compareTo(DateCount o) {
            return this.d.compareTo(o.d);
        }
    }
}

