/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import ucar.nc2.ui.widget.ProgressMonitorTask;

public class ProgressMonitor {
    private javax.swing.ProgressMonitor pm;
    private ProgressMonitorTask task;
    private Timer timer;
    private Thread taskThread;
    private int millisToPopup = 100;
    private int millisToDecideToPopup = 100;
    private int secs = 0;
    private EventListenerList listenerList = new EventListenerList();

    public ProgressMonitor(ProgressMonitorTask task) {
        this(task, 1000, 1000);
    }

    public ProgressMonitor(ProgressMonitorTask task, int millisToPopup, int millisToDecideToPopup) {
        this.task = task;
        this.millisToPopup = millisToPopup;
        this.millisToDecideToPopup = millisToDecideToPopup;
    }

    public ProgressMonitorTask getTask() {
        return this.task;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    private void fireEvent(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    public void start(Component top, String taskName, int progressMaxCount) {
        this.pm = new javax.swing.ProgressMonitor(top, taskName, "", 0, progressMaxCount);
        this.pm.setMillisToDecideToPopup(this.millisToDecideToPopup);
        this.pm.setMillisToPopup(this.millisToPopup);
        this.taskThread = new Thread(this.task);
        this.taskThread.start();
        ActionListener watcher = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressMonitor.this.secs++;
                if (ProgressMonitor.this.pm.isCanceled()) {
                    ProgressMonitor.this.task.cancel();
                } else {
                    String note = ProgressMonitor.this.task.getNote();
                    ProgressMonitor.this.pm.setNote(note == null ? ProgressMonitor.this.secs + " secs" : note);
                    int progress = ProgressMonitor.this.task.getProgress();
                    ProgressMonitor.this.pm.setProgress(progress <= 0 ? ProgressMonitor.this.secs : progress);
                }
                if (ProgressMonitor.this.task.isDone()) {
                    ProgressMonitor.this.timer.stop();
                    ProgressMonitor.this.pm.close();
                    if (ProgressMonitor.this.task.isError()) {
                        JOptionPane.showMessageDialog(null, ProgressMonitor.this.task.getErrorMessage());
                    }
                    if (ProgressMonitor.this.task.isSuccess()) {
                        ProgressMonitor.this.fireEvent(new ActionEvent(this, 0, "success"));
                    } else if (ProgressMonitor.this.task.isError()) {
                        ProgressMonitor.this.fireEvent(new ActionEvent(this, 0, "error"));
                    } else if (ProgressMonitor.this.task.isCancel()) {
                        ProgressMonitor.this.fireEvent(new ActionEvent(this, 0, "cancel"));
                    } else {
                        ProgressMonitor.this.fireEvent(new ActionEvent(this, 0, "done"));
                    }
                }
            }
        };
        this.timer = new Timer(1000, watcher);
        this.timer.start();
    }
}

