#ifdef Fortran2003
Module netcdf_nf_data

! Module for Netcdf FORTRAN 2003 nf parameters. This includes all the
! error condition parameters, external data types, fill values etc.

 
! Written by: Richard Weed
!             Engineering Research Center
!             Mississippi State University
!             rweed@erc.msstate.edu
           
! Version 1. Sept. 2005- initial Cray X1 version for netcdf 3.6,0
! Version 2. Apr. 2005 - updated to be consistent with netcdf 3.6.1

! This module is provided as a replacement for part of the netcdf.inc
! include file. It does not include the version 2 compatibility section
! and the external statements for the nf_ functions. The latter are not
! needed if you use the interfaces in module_netcdf_nf_interfaces. The
! version 2 compatability code is not supported by this module. Use
! netcdf.inc instead 

 Implicit NONE

!------------------------------ Define parameters first -----------------------

! Default external data types 

 Integer, Parameter :: NF_NAT      = 0
 Integer, Parameter :: NF_BYTE     = 1
 Integer, Parameter :: NF_INT1     = NF_BYTE
 Integer, Parameter :: NF_CHAR     = 2
 Integer, Parameter :: NF_SHORT    = 3
 Integer, Parameter :: NF_INT2     = NF_SHORT
 Integer, Parameter :: NF_INT      = 4
 Integer, Parameter :: NF_FLOAT    = 5
 Integer, Parameter :: NF_REAL     = NF_FLOAT
 Integer, Parameter :: NF_DOUBLE   = 6
 Integer, Parameter :: NF_UBYTE    = 7
 Integer, Parameter :: NF_USHORT   = 8
 Integer, Parameter :: NF_UINT     = 9
 Integer, Parameter :: NF_INT64    = 10
 Integer, Parameter :: NF_UINT64   = 11
 Integer, Parameter :: NF_STRING   = 12
 Integer, Parameter :: NF_VLEN     = 13
 Integer, Parameter :: NF_OPAQUE   = 14
 Integer, Parameter :: NF_ENUM     = 15
 Integer, Parameter :: NF_COMPOUND = 16

! Default fill values

 Integer, Parameter :: NF_FILL_BYTE    = -127
 Integer, Parameter :: NF_FILL_INT1    = NF_FILL_BYTE
 Integer, Parameter :: NF_FILL_CHAR    = 0
 Integer, Parameter :: NF_FILL_SHORT   = -32767
 Integer, Parameter :: NF_FILL_INT2    = NF_FILL_SHORT
 Integer, Parameter :: NF_FILL_INT     = -2147483647
 Real(4), Parameter :: NF_FILL_FLOAT   = 9.9692099683868690E+36
 Real(4), Parameter :: NF_FILL_REAL    = NF_FILL_FLOAT
 Real(8), Parameter :: NF_FILL_DOUBLE  = 9.9692099683868690E+36

! Mode flags for opening and creating datasets

 Integer, Parameter :: NF_NOWRITE                = 0
 Integer, Parameter :: NF_WRITE                  = 1
 Integer, Parameter :: NF_CLOBBER                = 0
 Integer, Parameter :: NF_NOCLOBBER              = 4
 Integer, Parameter :: NF_FILL                   = 0
 Integer, Parameter :: NF_NOFILL                 = 256
 Integer, Parameter :: NF_LOCK                   = 1024
 Integer, Parameter :: NF_SHARE                  = 2048
 Integer, Parameter :: NF_64BIT_OFFSET           = 512
 Integer, Parameter :: NF_SIZEHINT_DEFAULT       = 0
 Integer, Parameter :: NF_ALIGN_CHUNK            = -1
 Integer, Parameter :: NF_FORMAT_CLASSIC         = 1
 Integer, Parameter :: NF_FORMAT_64BIT           = 2
 Integer, Parameter :: NF_FORMAT_NETCDF4         = 3
 Integer, Parameter :: NF_FORMAT_NETCDF4_CLASSIC = 4

! Unlimited dimension size argument and global attibute ID

 Integer, Parameter :: NF_UNLIMITED = 0
 Integer, Parameter :: NF_GLOBAL    = 0

! Implementation limits (WARNING!  SHOULD BE THE SAME AS C INTERFACE)

 Integer, Parameter :: NF_MAX_DIMS     = 1024
 Integer, Parameter :: NF_MAX_ATTRS    = 8192
 Integer, Parameter :: NF_MAX_VARS     = 8192
 Integer, Parameter :: NF_MAX_NAME     = 256
 Integer, Parameter :: NF_MAX_VAR_DIMS = NF_MAX_DIMS

! Error codes

 Integer, Parameter :: NF_NOERR        =  0
 Integer, Parameter :: NF_EBADID       = -33
 Integer, Parameter :: NF_EEXIST       = -35
 Integer, Parameter :: NF_EINVAL       = -36
 Integer, Parameter :: NF_EPERM        = -37
 Integer, Parameter :: NF_ENOTINDEFINE = -38
 Integer, Parameter :: NF_EINDEFINE    = -39
 Integer, Parameter :: NF_EINVALCOORDS = -40
 Integer, Parameter :: NF_EMAXDIMS     = -41
 Integer, Parameter :: NF_ENAMEINUSE   = -42
 Integer, Parameter :: NF_ENOTATT      = -43
 Integer, Parameter :: NF_EMAXATTS     = -44
 Integer, Parameter :: NF_EBADTYPE     = -45
 Integer, Parameter :: NF_EBADDIM      = -46
 Integer, Parameter :: NF_EUNLIMPOS    = -47
 Integer, Parameter :: NF_EMAXVARS     = -48
 Integer, Parameter :: NF_ENOTVAR      = -49
 Integer, Parameter :: NF_EGLOBAL      = -50
 Integer, Parameter :: NF_ENOTNC       = -51
 Integer, Parameter :: NF_ESTS         = -52
 Integer, Parameter :: NF_EMAXNAME     = -53
 Integer, Parameter :: NF_EUNLIMIT     = -54
 Integer, Parameter :: NF_ENORECVARS   = -55
 Integer, Parameter :: NF_ECHAR        = -56
 Integer, Parameter :: NF_EEDGE        = -57
 Integer, Parameter :: NF_ESTRIDE      = -58
 Integer, Parameter :: NF_EBADNAME     = -59
 Integer, Parameter :: NF_ERANGE       = -60
 Integer, Parameter :: NF_ENOMEM       = -61
 Integer, Parameter :: NF_EVARSIZE     = -62
 Integer, Parameter :: NF_EDIMSIZE     = -63
 Integer, Parameter :: NF_ETRUNC       = -64

! Error handling codes

 Integer, Parameter :: NF_FATAL   = 1
 Integer, Parameter :: NF_VERBOSE = 2

!--------------------------- End Module netcdf_nf_data ------------------------
End Module netcdf_nf_data
#endif
