#ifdef Fortran2003
!---------- Routines to put/get attribute data of various data types ----------

! Replacement for fort-attio.c

! Written by: Richard Weed
!             Engineering Research Center
!             Mississippi State University
!             rweed@erc.msstate.edu

! Version 1.: Sept. 2005 - Initial Cray X1 version
! Version 2.: May 2006   - Updated to support g95
          
!--------------------------------- nf_put_att_text ---------------------------
 Function nf_put_att_text(ncid, varid, name, nlen, text) RESULT(status)

! Write variable or global attribute text string to dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid, nlen
 Character(LEN=*), Intent(IN) :: name, text

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer(KIND=C_SIZE_T) :: cnlen
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cnlen = nlen

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_put_att_text(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), cnlen, &
           text)

 status = cstatus

 End Function nf_put_att_text
!--------------------------------- nf_put_att_text_a ------------------------
 Function nf_put_att_text_a(ncid, varid, name, nlen, text) RESULT(status)

! Write variable or global attribute array of characters to dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid, nlen
 Character(LEN=*), Intent(IN) :: name
 Character(LEN=1), Intent(IN) :: text(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer(KIND=C_SIZE_T) :: cnlen
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cnlen = nlen

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_put_att_text(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), cnlen, &
                           text)

 status = cstatus

 End Function nf_put_att_text_a
!--------------------------------- nf_put_att_int1 -------------------------
 Function nf_put_att_int1(ncid, varid, name, xtype, nlen, i1vals) &
                             RESULT(status)

! Write variable or global attribute byte data to dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid, nlen, xtype

 Character(LEN=*), Intent(IN) :: name
 Integer(KIND=KINT1), Intent(IN) :: i1vals(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer(KIND=C_SIZE_T) :: cnlen
 Integer :: ie, inull

 If (C_SIGNED_CHAR < 0) Then ! schar not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf
 
 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cnlen = nlen

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_put_att_schar(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), &
                           f2c_xtype(xtype), cnlen, i1vals) 

 status = cstatus

 End Function nf_put_att_int1
!--------------------------------- nf_put_att_int2 -------------------------
 Function nf_put_att_int2(ncid, varid, name, xtype, nlen, i2vals) &
                             RESULT(status)

! Write variable or global attribute 16 bit integer data to data ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid, nlen, xtype

 Character(LEN=*), Intent(IN) :: name
 Integer(KIND=KINT2), Intent(IN) :: i2vals(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer(KIND=C_SIZE_T) :: cnlen
 Integer :: ie, inull

 If (C_SHORT < 0) Then ! short not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf
 
 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cnlen = nlen

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_put_att_short(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), &
                            f2c_xtype(xtype), cnlen, i2vals) 

 status = cstatus

 End Function nf_put_att_int2
!--------------------------------- nf_put_att_int --------------------------
 Function nf_put_att_int(ncid, varid, name, xtype, nlen, ivals) &
                            RESULT(status)

! Write variable or global attribute default integer data to dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid, nlen, xtype

 Character(LEN=*), Intent(IN) :: name
 Integer, Intent(IN) :: ivals(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer(KIND=C_SIZE_T) :: cnlen
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cnlen = nlen

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_put_att_int(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), &
                          f2c_xtype(xtype), cnlen, ivals) 

 status = cstatus

 End Function nf_put_att_int
!--------------------------------- nf_put_att_real -------------------------
 Function nf_put_att_real(ncid, varid, name, xtype, nlen, rvals) &
                             RESULT(status)

! Write variable or global attribute Real(4) data to dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid, nlen, xtype

 Character(LEN=*), Intent(IN) :: name
 Real(4), Intent(IN) :: rvals(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer(KIND=C_SIZE_T) :: cnlen
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cnlen = nlen

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_put_att_float(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), &
                            f2c_xtype(xtype), cnlen, rvals) 

 status = cstatus

 End Function nf_put_att_real
!--------------------------------- nf_put_att_double -----------------------
 Function nf_put_att_double(ncid, varid, name, xtype, nlen, dvals) &
                               RESULT(status)

! Write variable or global attribute Real(8) to dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid, nlen, xtype

 Character(LEN=*), Intent(IN) :: name
 Real(8), Intent(IN) :: dvals(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer(KIND=C_SIZE_T) :: cnlen
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cnlen = nlen

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_put_att_double(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), &
                             f2c_xtype(xtype), cnlen, dvals) 

 status = cstatus

 End Function nf_put_att_double
!--------------------------------- nf_get_att_text -----------------------
 Function nf_get_att_text(ncid, varid, name, text) RESULT(status)

! Read variable or global attribute character string from dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Character(LEN=*), Intent(IN)  :: name
 Character(LEN=*), Intent(OUT) ::  text

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 text = REPEAT(" ", LEN(text))

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_get_att_text(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), text)

 status = cstatus

 End Function nf_get_att_text
!--------------------------------- nf_get_att_text_a -----------------------
 Function nf_get_att_text_a(ncid, varid, name, text) RESULT(status)

! Read variable or global attribute array of characters from dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Character(LEN=*), Intent(IN)  :: name
 Character(LEN=1), Intent(OUT) ::  text(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_get_att_text(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), text)

 status = cstatus

 End Function nf_get_att_text_a
!--------------------------------- nf_get_att_int1 -------------------------
 Function nf_get_att_int1(ncid, varid, name, i1vals) RESULT(status)

! Read variable or global attribute BYTE integer data from dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid

 Character(LEN=*), Intent(IN) :: name
 Integer(KIND=KINT1), Intent(OUT) :: i1vals(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer :: ie, inull

 If (C_SIGNED_CHAR < 0) Then ! schar not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf
 
 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_get_att_schar(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), i1vals)

 status = cstatus

 End Function nf_get_att_int1
!--------------------------------- nf_get_att_int2 --------------------------
 Function nf_get_att_int2(ncid, varid, name, i2vals) RESULT(status)

! Read variable or global attribute 16 bit integer data from dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid

 Character(LEN=*), Intent(IN) :: name
 Integer(KIND=KINT2), Intent(OUT) :: i2vals(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer :: ie, inull

 If (C_SHORT < 0) Then ! short not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf
 
 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_get_att_short(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), i2vals) 

 status = cstatus

 End Function nf_get_att_int2
!--------------------------------- nf_get_att_int ---------------------------
 Function nf_get_att_int(ncid, varid, name, ivals) RESULT(status)

! Read variable or global attribute default Integer data from dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid

 Character(LEN=*), Intent(IN) :: name
 Integer, Intent(OUT) :: ivals(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_get_att_int(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), ivals)

 status = cstatus

 End Function nf_get_att_int
!--------------------------------- nf_get_att_real -------------------------
 Function nf_get_att_real(ncid, varid, name, rvals) RESULT(status)

! Read variable or global attribute Real(4) data from dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid

 Character(LEN=*), Intent(IN) :: name
 Real(4), Intent(OUT) :: rvals(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_get_att_float(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), rvals) 

 status = cstatus

 End Function nf_get_att_real
!--------------------------------- nf_get_att_double -----------------------
 Function nf_get_att_double(ncid, varid, name, dvals) RESULT(status)

! Read variable or global attribute Real(8) data from dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid

 Character(LEN=*), Intent(IN) :: name
 Real(8), Intent(OUT) :: dvals(*)

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie = inull-1
 ie = MAX(1,ie)
  
 cstatus = nc_get_att_double(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), dvals)

 status = cstatus

 End Function nf_get_att_double
#endif
