#ifdef Fortran2003
!------- Routines for defining, obtaining, etc. global dimension info ------ 

! Replacement for fort-dim.c

! Written by: Richard Weed
!             Engineering Research Center
!             Mississippi State University
!             rweed@erc.msstate.edu

! Version 1.: Sept. 2005 - Initial Cray X1 version
! Version 2.: May   2006 - Updated to support g95
          
!-------------------------------- nf_def_dim -------------------------------
 Function nf_def_dim(ncid, name, dlen, dimid) RESULT (status)

! Adds new dimensions to the NetCDF dataset given dimension name,
! and length. Returns dimension id

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)  :: ncid, dlen
 Integer, Intent(OUT) :: dimid
 Character(LEN=*), Intent(IN)  :: name

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cdimid, cstatus
 Integer(KIND=C_SIZE_T) :: cdlen
 Integer :: inull, ie

 cncid = ncid
 cdlen = dlen

 dimid  = -1
 cdimid = -1

! Check to see if a C null character was appended in FORTRAN

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie=inull-1
 ie = MAX(1,ie)
 
 cstatus = nc_def_dim(cncid, name(1:ie)//C_NULL_CHAR, cdlen, cdimid)

 If (cdimid == -1) Then  ! Return dimid=-1
   dimid = -1
 Else                    ! Add 1 to get FORTRAN dimid
   dimid = cdimid+1
 EndIf

 status = cstatus

 End Function nf_def_dim
!-------------------------------- nf_inq_dim -------------------------------
 Function nf_inq_dim(ncid, dimid, name, dlen) RESULT (status)

! Get dimension name and length for a given dimid from NetCDF dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)           :: ncid, dimid
 Integer, Intent(OUT)          :: dlen
 Character(LEN=*), Intent(OUT)  :: name
 
 Integer :: status

 Integer(KIND=C_INT) :: cncid, cdimid, cstatus
 Integer(KIND=C_SIZE_T) :: cdlen
 Integer :: inull, ie, nlen
 Character(LEN=NC_MAX_NAME) :: tmpname 

 cncid   = ncid
 cdimid  = dimid - 1   ! Subtract 1 to get C dimid
 tmpname = REPEAT(" ", LEN(tmpname))
 name    = REPEAT(" ", LEN(name))
 nlen = LEN(name)

! Get tmpname and cdlen from C interface

 cstatus = nc_inq_dim(cncid, cdimid, tmpname, cdlen)

! Find first C null character in tmpname if present and set end of string

 ie = LEN_TRIM(tmpname)
 inull = SCAN(tmpname, C_NULL_CHAR)
 if (inull /= 0) ie=inull-1
 ie = MIN(nlen, MAX(1,ie)) ! limit ie to >=1 and <= LEN(name)

! Set name to tmpname. tmpname string will be trunctated if name is not big 
! enough to hold tmpname

 name(1:ie) = tmpname(1:ie)

 dlen = cdlen
 status = cstatus

 End Function nf_inq_dim
!-------------------------------- nf_inq_dimid -----------------------------
 Function nf_inq_dimid(ncid, name, dimid) RESULT (status)

! Get dimension id for a given dimension name from dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)  :: ncid
 Integer, Intent(OUT) :: dimid
 Character(LEN=*), Intent(IN)  :: name

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cdimid, cstatus
 Integer :: inull, ie

 cncid = ncid

! Check to see if a C null character was appended in FORTRAN

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie=inull-1
 ie = MAX(1,ie)
 
 cstatus = nc_inq_dimid(cncid, name(1:ie)//C_NULL_CHAR, cdimid)

! add one to get FORTRAN dimid if not = -1

 If (cdimid == -1 ) Then
   dimid = -1
 Else
   dimid = cdimid + 1
 EndIf

 status = cstatus

 End Function nf_inq_dimid
!-------------------------------- nf_inq_dimlen ----------------------------
 Function nf_inq_dimlen(ncid, dimid, dlen) RESULT (status)

! Get dimension length for a given dimid from NetCDF dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)           :: ncid, dimid
 Integer, Intent(OUT)          :: dlen

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cdimid, cstatus
 Integer(KIND=C_SIZE_T) :: cdlen

 cncid   = ncid
 cdimid  = dimid - 1 ! Subtract 1 to get C dimid

 cstatus = nc_inq_dimlen(cncid, cdimid, cdlen)

 dlen = cdlen
 status = cstatus

 End Function nf_inq_dimlen
!-------------------------------- nf_inq_dimname ---------------------------
 Function nf_inq_dimname (ncid, dimid, name) RESULT (status)

! Get dimension name for a given dimid from NetCDF dataset ncid

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)           :: ncid, dimid
 Character(LEN=*), Intent(OUT)  :: name

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cdimid, cstatus
 Integer :: inull, ie, nlen
 Character(LEN=NC_MAX_NAME) :: tmpname 

 cncid   = ncid
 cdimid  = dimid - 1 ! Subtract 1 to get C dimid
 tmpname = REPEAT(" ", LEN(tmpname))
 name    = REPEAT(" ", LEN(name))
 nlen = LEN(name)

! Get tmpname and cdlen from C interface

 cstatus = nc_inq_dimname(cncid, cdimid, tmpname)

! Find first C null character in tmpname if present and set end of string

 ie = LEN_TRIM(tmpname)
 inull = SCAN(tmpname, C_NULL_CHAR)
 if (inull /= 0) ie=inull-1
 ie = MIN(nlen, MAX(1,ie)) ! limit ie to >=1 and <= LEN(name)

! Set name to tmpname. tmpname string will be truncated if name is not big 
! enough to hold tmpname

 name(1:ie) = tmpname(1:ie)

 status = cstatus

 End Function nf_inq_dimname
!-------------------------------- nf_rename_dim ----------------------------
 Function nf_rename_dim(ncid, dimid, name) RESULT (status)

! Rename dimension name for a given dimension id

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)  :: ncid, dimid
 Character(LEN=*), Intent(IN)  :: name

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cdimid, cstatus
 Integer :: inull, ie

 cncid  = ncid
 cdimid = dimid - 1 ! Subtract 1 to get C dimid

! Check to see if a C null character was appended in FORTRAN

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 if (inull /= 0) ie=inull-1
 ie = MAX(1,ie)
 
 cstatus = nc_rename_dim(cncid, cdimid, name(1:ie)//C_NULL_CHAR)

 status = cstatus

 End Function nf_rename_dim
#endif
