#ifdef Fortran2003
!---------- Routines for defining and obtaining info about attributes --------

! Replacement for fort-genatt.c

! Written by: Richard Weed
!             Engineering Research Center
!             Mississippi State University
!             rweed@erc.msstate.edu

! Version 1.: Sept. 2005 - Initial Cray X1 version
! Version 2.: May   2006 - Updated to support g95
          
!-------------------------------- nf_inq_att ---------------------------------
 Function nf_inq_att(ncid, varid, name, xtype, nlen) RESULT(status)

! Get attribute data type and length for a given varid and name

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)  :: ncid, varid
 Integer, Intent(OUT) :: nlen, xtype
 Character(LEN=*), Intent(IN) :: name

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cstatus, cvarid
 Integer(KIND=C_SIZE_T) :: cnlen
! Type(nc_type) :: cxtype
 Integer(KIND=C_INT) :: cxtype
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid

! Check to see if a C null character was added to name in calling program

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 If (inull /= 0) ie = inull-1
 ie = MAX(1,ie)

 cstatus = nc_inq_att(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), cxtype, cnlen)
 xtype = cxtype
 nlen = cnlen

 status = cstatus

 End Function nf_inq_att
!-------------------------------- nf_inq_atttype ---------------------------
 Function nf_inq_atttype(ncid, varid, name, xtype) RESULT(status)

! Get attribute type for a given varid and name

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)  :: ncid, varid
 Integer, Intent(OUT) :: xtype
 Character(LEN=*), Intent(IN) :: name

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cstatus, cvarid
! Type(nc_type) :: cxtype
 Integer(KIND=C_INT) :: cxtype
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid

! Check to see if a C null character was added to name in calling program

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 If (inull /= 0) ie = inull-1
 ie = MAX(1,ie)

 cstatus = nc_inq_atttype(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), cxtype)
 xtype = cxtype

 status = cstatus

 End Function nf_inq_atttype
!-------------------------------- nf_inq_attlen ----------------------------
 Function nf_inq_attlen(ncid, varid, name, nlen) RESULT(status)

! Get attribute length for a given varid and name

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)  :: ncid, varid
 Integer, Intent(OUT) :: nlen
 Character(LEN=*), Intent(IN) :: name

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cstatus, cvarid
 Integer(KIND=C_SIZE_T) :: cnlen
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid

! Check to see if a C null character was added to name in calling program

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 If (inull /= 0) ie = inull-1
 ie = MAX(1,ie)

 cstatus = nc_inq_attlen(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), cnlen)
 nlen = cnlen

 status = cstatus

 End Function nf_inq_attlen
!-------------------------------- nf_inq_attid -----------------------------
 Function nf_inq_attid(ncid, varid, name, attnum) RESULT(status)

! Get attribute id for a given varid and name

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)  :: ncid, varid
 Integer, Intent(OUT) :: attnum
 Character(LEN=*), Intent(IN) :: name

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cstatus, cattnum, cvarid
 Integer :: ie, inull

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid

! Check to see if a C null character was added to name in calling program

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 If (inull /= 0) ie = inull-1
 ie = MAX(1,ie)

 cstatus = nc_inq_attid(cncid, cvarid, (name(1:ie)//C_NULL_CHAR), cattnum)
 
 attnum = cattnum + 1 ! add 1 to get FORTRAN att id

 status = cstatus

 End Function nf_inq_attid
!-------------------------------- nf_inq_attname ---------------------------
 Function nf_inq_attname(ncid, varid, attnum, name) RESULT(status)

! Get attribute name for a given varid and attribute number

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)  :: ncid, varid, attnum
 Character(LEN=*), Intent(OUT) :: name

 Integer :: status

 Integer(KIND=C_INT) :: cncid, cstatus, cattnum, cvarid

 Character(LEN=(LEN(name)+1)) :: tmpname
 Integer :: ie, inull, nlen

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid and att num
 cattnum = attnum - 1
 nlen = LEN(name)
 name = REPEAT(" ",nlen)
 tmpname = REPEAT(" ",LEN(tmpname)) ! init to blanks

 cstatus = nc_inq_attname(cncid, cvarid, cattnum, tmpname)

! Strip of any C null characters and load only the part
! of tmpname that will fit in name

 ie = LEN_TRIM(tmpname)
 inull = SCAN(tmpname, C_NULL_CHAR)
 If (inull /= 0) ie = inull-1
 ie = MIN(nlen, MAX(1,ie)) ! limit ie to >=1 and <= LEN(name)

 name(1:ie) = tmpname(1:ie)

 status = cstatus

 End Function nf_inq_attname
!-------------------------------- nf_copy_att ------------------------------
 Function nf_copy_att(ncid_in, varid_in, name, ncid_out, varid_out) &
                         RESULT(status)

! Copy attribute name with varid_in from one netcdf file to another
! with new varid_out 

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)  :: ncid_in, varid_in, ncid_out, varid_out 
 Character(LEN=*), Intent(IN) :: name

 Integer :: status

 Integer :: ie, inull

 Integer(KIND=C_INT) :: cncidin, cncidout,cvaridin, cvaridout, cstatus

 cncidin = ncid_in
 cvaridin = varid_in - 1
 cncidout = ncid_out
 cvaridout = varid_out - 1

! Check to see if a C null character was added to name in calling program

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 If (inull /= 0) ie = inull-1
 ie = MAX(1,ie)

 cstatus = nc_copy_att(cncidin, cvaridin, (name(1:ie)//C_NULL_CHAR), &
                       cncidout, cvaridout)

 status = cstatus

 End Function nf_copy_att
!-------------------------------- nf_rename_att ----------------------------
 Function nf_rename_att(ncid, varid, name, newname) RESULT(status)

! Rename an attribute to newname givin varid 

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)  :: ncid, varid
 Character(LEN=*), Intent(IN) :: name, newname

 Integer :: status

 Integer :: ie1, ie2, inull

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid

! Check to see if a C null character was added to name and newname 
! in calling program

 inull = 0
 ie1 = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 If (inull /= 0) ie1 = inull-1
 ie1 = MAX(1,ie1)

 inull = 0
 ie2 = LEN_TRIM(newname)
 inull = SCAN(newname, C_NULL_CHAR)
 If (inull /= 0) ie2 = inull-1
 ie2 = MAX(1,ie2)

 cstatus = nc_rename_att(cncid, cvarid, (name(1:ie1)//C_NULL_CHAR), &
                         (newname(1:ie2)//C_NULL_CHAR))

 status = cstatus

 End Function nf_rename_att
!-------------------------------- nf_del_att -------------------------------
 Function nf_del_att(ncid, varid, name) RESULT(status)

! Delete an attribute givne varid and name 

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN)  :: ncid, varid
 Character(LEN=*), Intent(IN) :: name

 Integer :: status

 Integer :: ie, inull

 Integer(KIND=C_INT) :: cncid, cvarid, cstatus

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid

! Check to see if a C null character was added to name in calling program

 ie = LEN_TRIM(name)
 inull = SCAN(name, C_NULL_CHAR)
 If (inull /= 0) ie = inull-1
 ie = MAX(1,ie)

 cstatus = nc_del_att(cncid, cvarid, (name(1:ie)//C_NULL_CHAR))

 status = cstatus

 End Function nf_del_att
#endif
