#ifdef Fortran2003
!----- Routines to put/get single data items of a variety of data types ------

! Replacement for fort-var1io.c

! Written by: Richard Weed
!             Engineering Research Center
!             Mississippi State University
!             rweed@erc.msstate.edu

! Version 1.: Sept. 2005 - Initial Cray X1 version
! Version 2.: May   2006 - Updated to support g95
!                          Updated to pass ndex as C_PTR variable
          
!--------------------------------- nf_put_var1_text ------------------------
 Function nf_put_var1_text(ncid, varid, ndex, chval) RESULT(status)

! Write out a single character variable to location vector ndex in dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Character(LEN=1), Intent(IN) :: chval

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)
 Type(C_PTR) :: cndexptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex = 0
 
 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! reverse array order and subtract 1 to get C index 
     cndex(1:ndims) = ndex(ndims:1:-1)-1
   EndIf
   cndexptr = C_LOC(cndex)
 EndIf

 cstatus = nc_put_var1_text(cncid, cvarid, cndexptr, chval)
 status = cstatus

 End Function nf_put_var1_text
!--------------------------------- nf_put_var1_int1 ------------------------
 Function nf_put_var1_int1(ncid, varid, ndex, ival) RESULT(status)

! Write out a 8 bit integer variable to location vector ndex in dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Integer(KIND=KINT1), Intent(IN) :: ival

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)
 Type(C_PTR) :: cndexptr
 Integer(KIND=CINT1) :: cival

 If (C_SIGNED_CHAR < 0) Then ! schar not supported by processor exit
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex = 0
 cival = ival

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! reverse array order and subtract 1 to get C index 
     cndex(1:ndims) = ndex(ndims:1:-1)-1
   EndIf
   cndexptr = C_LOC(cndex)
 EndIf

 cstatus = nc_put_var1_schar(cncid, cvarid, cndexptr, cival)
 status = cstatus

 End Function nf_put_var1_int1
!--------------------------------- nf_put_var1_int2 ------------------------
 Function nf_put_var1_int2(ncid, varid, ndex, ival) RESULT(status)

! Write out a 16 bit integer variable to location vector ndex in dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Integer(KIND=KINT2), Intent(IN) :: ival

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)
 Type(C_PTR) :: cndexptr
 Integer(KIND=CINT2) :: cival

 If (C_SHORT < 0) Then ! short not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex = 0
 cival = ival

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! reverse array order and subtract 1 to get C index 
     cndex(1:ndims) = ndex(ndims:1:-1)-1
   EndIf
   cndexptr = C_LOC(cndex)
 EndIf

 cstatus = nc_put_var1_short(cncid, cvarid, cndexptr, cival)
 status = cstatus

 End Function nf_put_var1_int2
!--------------------------------- nf_put_var1_int -------------------------
 Function nf_put_var1_int(ncid, varid, ndex, ival) RESULT(status)

! Write out a default integer variable to location vector ndex to dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Integer, Intent(IN) :: ival

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Type(C_PTR) :: cndexptr
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)
 Integer(KIND=C_INT) :: cival

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex = 0
 cival = ival

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! reverse array order and subtract 1 to get C index 
     cndex(1:ndims) = ndex(ndims:1:-1)-1
   EndIf
   cndexptr = C_LOC(cndex)
 EndIf

 cstatus = nc_put_var1_int(cncid, cvarid, cndexptr, cival)
 status = cstatus

 End Function nf_put_var1_int
!--------------------------------- nf_put_var1_real ------------------------
 Function nf_put_var1_real(ncid, varid, ndex, rval) RESULT(status)

! Write out a 32 bit real variable to location vector ndex in dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Real(4), Intent(IN) :: rval

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Type(C_PTR) :: cndexptr
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! reverse array order and subtract 1 to get C index 
     cndex(1:ndims) = ndex(ndims:1:-1)-1
   EndIf
   cndexptr = C_LOC(cndex)
 EndIf

 cstatus = nc_put_var1_float(cncid, cvarid, cndexptr, rval)
 status = cstatus

 End Function nf_put_var1_real
!--------------------------------- nf_put_var1_double ----------------------
 Function nf_put_var1_double(ncid, varid, ndex, dval) RESULT(status)

! Write out a 64 bit real variable to location vector ndex in dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Real(8), Intent(IN) :: dval

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Type(C_PTR) :: cndexptr
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims) ! get varid dimension

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims >0) Then
     cndex(1:ndims) = ndex(ndims:1:-1)-1
   EndIf
   cndexptr = C_LOC(cndex)
 EndIf

 cstatus = nc_put_var1_double(cncid, cvarid, cndexptr, dval)
 status = cstatus

 End Function nf_put_var1_double
!--------------------------------- nf_get_var1_text ------------------------
 Function nf_get_var1_text(ncid, varid, ndex, chval) RESULT(status)

! Read in a single character variable from location vector ndex in dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Character(LEN=1), Intent(OUT) :: chval

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Type(C_PTR) :: cndexptr
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex =  0
 chval = ' '
 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! reverse array order and subtract 1 to get C index 
     cndex(1:ndims) = ndex(ndims:1:-1) -1
   EndIf
   cndexptr = C_LOC(cndex)
  EndIf
 
 cstatus = nc_get_var1_text(cncid, cvarid, cndexptr, chval)
 status = cstatus

 End Function nf_get_var1_text
!--------------------------------- nf_get_var1_int1 ------------------------
 Function nf_get_var1_int1(ncid, varid, ndex, ival) RESULT(status)

! Read in a 8 bit integer variable from location vector ndex in dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Integer(KIND=KINT1), Intent(OUT) :: ival

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)
 Type(C_PTR) :: cndexptr
 Integer(KIND=CINT1) :: cival

 If (C_SIGNED_CHAR < 0) Then ! schar not supported by processor exit
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! reverse array order and subtract 1 to get C index 
     cndex(1:ndims) = ndex(ndims:1:-1)-1
   EndIf
   cndexptr = C_LOC(cndex)
 EndIf
 
 cstatus = nc_get_var1_schar(cncid, cvarid, cndexptr, cival)
 ival = cival
 status = cstatus

 End Function nf_get_var1_int1
!--------------------------------- nf_get_var1_int2 ------------------------
 Function nf_get_var1_int2(ncid, varid, ndex, ival) RESULT(status)

! Read in a 16 bit integer variable from location vector ndex in dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Integer(KIND=KINT2), Intent(OUT) :: ival

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)
 Type(C_PTR) :: cndexptr
 Integer(KIND=CINT2) :: cival

 If (C_SHORT < 0) Then ! short not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! reverse array order and subtract 1 to get C index 
     cndex(1:ndims) = ndex(ndims:1:-1)-1
   EndIf
   cndexptr = C_LOC(cndex)
 EndIf

 cstatus = nc_get_var1_short(cncid, cvarid, cndexptr, cival)
 
 ival = cival
 status = cstatus

 End Function nf_get_var1_int2
!--------------------------------- nf_get_var1_int -------------------------
 Function nf_get_var1_int(ncid, varid, ndex, ival) RESULT(status)

! Read in 32 bit integer variable from location vector ndex in dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Integer, Intent(OUT) :: ival

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)
 Type(C_PTR) :: cndexptr
 Integer(KIND=C_INT) :: cival

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! reverse array order and subtract 1 to get C index 
     cndex(1:ndims) = ndex(ndims:1:-1)-1
   EndIf
   cndexptr = C_LOC(cndex)
 EndIf

 cstatus = nc_get_var1_int(cncid, cvarid, cndexptr, cival)
 ival = cival
 status = cstatus

 End Function nf_get_var1_int
!--------------------------------- nf_get_var1_real ------------------------
 Function nf_get_var1_real(ncid, varid, ndex, rval) RESULT(status)

! Read in a 32 bit real variable to location vector ndex in dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Real(4), Intent(OUT) :: rval

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)
 Type(C_PTR) :: cndexptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! reverse array order and subtract 1 to get C index 
     cndex(1:ndims) = ndex(ndims:1:-1)-1
   EndIf
   cndexptr = C_LOC(cndex)
 EndIf

 cstatus = nc_get_var1_float(cncid, cvarid, cndexptr, rval)
 status = cstatus

 End Function nf_get_var1_real
!--------------------------------- nf_get_var1_double ----------------------
 Function nf_get_var1_double(ncid, varid, ndex, dval) RESULT(status)

! Read in a 64 bit real variable to location vector ndex in dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: ndex(*)
 Real(8), Intent(OUT) :: dval

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cndex(NC_MAX_DIMS)
 Type(C_PTR) :: cndexptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract one to get C varid
 cndex = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims) ! get varid dimension

 cndexptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! reverse array order and subtract 1 to get C index 
     cndex(1:ndims) = ndex(ndims:1:-1)-1
   EndIf
   cndexptr = C_LOC(cndex)
 EndIf

 cstatus = nc_get_var1_double(cncid, cvarid, cndexptr, dval)
 status = cstatus

 End Function nf_get_var1_double
#endif
