#ifdef Fortran2003
!- Array/string put/get routines given start, count, stride, and map vectors - 

! Replacement for fort-varmio.c

! Written by: Richard Weed
!             Engineering Research Center
!             Mississippi State University
!             rweed@erc.msstate.edu

! Version 1.: Sept. 2005 - Initial Cray X1 version
! Version 2.: May   2006 - Updated to support g95
!                          Updated to pass start, counts, strides, and
!                          maps as C_PTR variables

!--------------------------------- nf_put_varm_text ----------------------
 Function nf_put_varm_text(ncid, varid, start, counts, strides, maps, &
                           text) RESULT(status)

! Write out a character string to dataset given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Character(LEN=*), Intent(IN) :: text 

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid

 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0 

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_put_varm_text(cncid, cvarid, cstartptr, ccountsptr, &
                            cstridesptr, cmapsptr, text)
 status = cstatus

 End Function nf_put_varm_text
!--------------------------------- nf_put_varm_text_a ----------------------
 Function nf_put_varm_text_a(ncid, varid, start, counts, strides, maps, &
                                text) RESULT(status)

! Write out array of characters to dataset given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Character(LEN=1), Intent(IN) :: text(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_put_varm_text(cncid, cvarid, cstartptr, ccountsptr, &
                            cstridesptr, cmapsptr, text) 
 status = cstatus

 End Function nf_put_varm_text_a
!--------------------------------- nf_put_varm_int1 ------------------------
 Function nf_put_varm_int1(ncid, varid, start, counts, strides, maps, &
                              i1vals) RESULT(status)

! Write out 8 bit integer array given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Integer(KIND=KINT1), Intent(IN) :: i1vals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 If (C_SIGNED_CHAR < 0) Then ! schar not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_put_varm_schar(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, cmapsptr, i1vals) 
 status = cstatus

 End Function nf_put_varm_int1
!--------------------------------- nf_put_varm_int2 ------------------------
 Function nf_put_varm_int2(ncid, varid, start, counts, strides, maps, &
                           i2vals) RESULT(status)

! Write out 16 bit integer array given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Integer(KIND=KINT2), Intent(IN) :: i2vals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 If (C_SHORT < 0) Then ! short not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_put_varm_short(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, cmapsptr, i2vals) 
 status = cstatus

 End Function nf_put_varm_int2
!--------------------------------- nf_put_varm_int -------------------------
 Function nf_put_varm_int(ncid, varid, start, counts, strides, maps, &
                             ivals) RESULT(status)

! Write out default integer array given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Integer, Intent(IN) :: ivals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_put_varm_int(cncid, cvarid, cstartptr, ccountsptr, &
                           cstridesptr, cmapsptr, ivals) 
 status = cstatus

 End Function nf_put_varm_int
!--------------------------------- nf_put_varm_real ------------------------
 Function nf_put_varm_real(ncid, varid, start, counts, strides, maps, &
                              rvals) RESULT(status)

! Write out 32 bit real array given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Real(4), Intent(IN) :: rvals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT)    :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_put_varm_float(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, cmapsptr, rvals) 
 status = cstatus

 End Function nf_put_varm_real
!--------------------------------- nf_put_varm_double ----------------------
 Function nf_put_varm_double(ncid, varid, start, counts, strides, maps, &
                                dvals) RESULT(status)

! Write out 64 bit real array given start, count, stride, and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Real(8), Intent(IN) :: dvals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid

 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf
  
 cstatus = nc_put_varm_double(cncid, cvarid, cstartptr, ccountsptr, &
                              cstridesptr, cmapsptr, dvals) 
 status = cstatus

 End Function nf_put_varm_double
!--------------------------------- nf_get_varm_text ----------------------
 Function nf_get_varm_text(ncid, varid, start, counts, strides, maps, &
                           text) RESULT(status)

! Read in a character string to dataset given start, count, stride, and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Character(LEN=*), Intent(OUT) :: text 

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0
 text = REPEAT(" ",LEN(text))

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_get_varm_text(cncid, cvarid, cstartptr, ccountsptr, &
                            cstridesptr, cmapsptr, text) 
 status = cstatus

 End Function nf_get_varm_text
!--------------------------------- nf_get_varm_text_a ----------------------
 Function nf_get_varm_text_a(ncid, varid, start, counts, strides, maps, &
                                text) RESULT(status)

! Read in array of characters from dataset given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Character(LEN=1), Intent(OUT) :: text(*) 

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_get_varm_text(cncid, cvarid, cstartptr, ccountsptr, &
                            cstridesptr, cmapsptr, text) 
 status = cstatus

 End Function nf_get_varm_text_a
!--------------------------------- nf_get_varm_int1 ------------------------
 Function nf_get_varm_int1(ncid, varid, start, counts, strides, maps, &
                              i1vals) RESULT(status)

! Read in 8 bit integer array given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Integer(KIND=KINT1), Intent(OUT) :: i1vals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 If (C_SIGNED_CHAR < 0) Then ! schar not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_get_varm_schar(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, cmapsptr, i1vals) 
 status = cstatus

 End Function nf_get_varm_int1
!--------------------------------- nf_get_varm_int2 ------------------------
 Function nf_get_varm_int2(ncid, varid, start, counts, strides, maps, &
                              i2vals) RESULT(status)

! Read in 16 bit integer array given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Integer(KIND=KINT2), Intent(OUT) :: i2vals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 If (C_SHORT < 0) Then ! short not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_get_varm_short(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, cmapsptr, i2vals) 
 status = cstatus

 End Function nf_get_varm_int2
!--------------------------------- nf_get_varm_int -------------------------
 Function nf_get_varm_int(ncid, varid, start, counts, strides, maps, &
                             ivals) RESULT(status)

! Read in default integer array given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Integer, Intent(OUT) :: ivals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_get_varm_int(cncid, cvarid, cstartptr, ccountsptr, &
                           cstridesptr, cmapsptr, ivals) 
 status = cstatus

 End Function nf_get_varm_int
!--------------------------------- nf_get_varm_real ------------------------
 Function nf_get_varm_real(ncid, varid, start, counts, strides, maps, &
                              rvals) RESULT(status)

! Read in 32 bit real array given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Real(4), Intent(OUT) :: rvals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_get_varm_float(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, cmapsptr, rvals) 
 status = cstatus

 End Function nf_get_varm_real
!--------------------------------- nf_get_varm_double ----------------------
 Function nf_get_varm_double(ncid, varid, start, counts, strides, maps, &
                             dvals) RESULT(status)

! Read in 64 bit real array given start, count, stride and map

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*), maps(*)
 Real(8), Intent(OUT) :: dvals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS), cmaps(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr, cmapsptr

 cncid = ncid
 cvarid = varid -1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 cmaps = 0

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 cmapsptr    = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims)   = start(ndims:1:-1)-1
     ccounts(1:ndims)  = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
     cmaps(1:ndims)    = maps(ndims:1:-1)
   EndIf
   cstartptr   = C_LOC(cstart)
   ccountsptr  = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
   cmapsptr    = C_LOC(cmaps)
 EndIf

 cstatus = nc_get_varm_double(cncid, cvarid, cstartptr, ccountsptr, &
                              cstridesptr, cmapsptr, dvals) 
 status = cstatus

 End Function nf_get_varm_double
#endif
