#ifdef Fortran2003
!-------- Array/string put/get routines given start, count, and stride -------

! Replacement for fort-varsio.c

! Written by: Richard Weed
!             Engineering Research Center
!             Mississippi State University
!             rweed@erc.msstate.edu
          
! Version 1.: Sept 2005 - Initial Cray X1 version
! Version 2.: May  2006 - Updated to support g95
!                         Updated to pass start, counts, and strides as
!                         C_PTR variables

!--------------------------------- nf_put_vars_text ----------------------
 Function nf_put_vars_text(ncid, varid, start, counts, strides, text) &
                           RESULT(status)

! Write out a character string given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Character(LEN=*), Intent(IN) :: text 

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 cncid    = ncid
 cvarid   = varid - 1 ! Subtract 1 to get C varid
 cstart   = 0
 ccounts  = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_put_vars_text(cncid, cvarid, cstartptr, ccountsptr, &
                            cstridesptr, text)
 status = cstatus

 End Function nf_put_vars_text
!--------------------------------- nf_put_vars_text_a ----------------------
 Function nf_put_vars_text_a(ncid, varid, start, counts, strides, text) &
                                RESULT(status)

! Write out array of characters given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Character(LEN=1), Intent(IN) :: text(*) 

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_put_vars_text(cncid, cvarid, cstartptr, ccountsptr, &
                            cstridesptr, text)
 status = cstatus

 End Function nf_put_vars_text_a
!--------------------------------- nf_put_vars_int1 ------------------------
 Function nf_put_vars_int1(ncid, varid, start, counts, strides, i1vals) &
                              RESULT(status)

! Write out 8 bit integer array given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Integer(KIND=KINT1), Intent(IN) :: i1vals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 If (C_SIGNED_CHAR < 0) Then ! schar not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_put_vars_schar(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, i1vals)
 status = cstatus

 End Function nf_put_vars_int1
!--------------------------------- nf_put_vars_int2 ------------------------
 Function nf_put_vars_int2(ncid, varid, start, counts, strides, i2vals) &
                              RESULT(status)

! Write out 16 bit integer array given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Integer(KIND=KINT2), Intent(IN) :: i2vals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 If (C_SHORT < 0) Then ! short not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_put_vars_short(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, i2vals)
 status = cstatus

 End Function nf_put_vars_int2
!--------------------------------- nf_put_vars_int -------------------------
 Function nf_put_vars_int(ncid, varid, start, counts, strides, ivals) &
                             RESULT(status)

! Write out default integer array given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Integer, Intent(IN) :: ivals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_put_vars_int(cncid, cvarid, cstartptr, ccountsptr, &
                           cstridesptr, ivals)
 status = cstatus

 End Function nf_put_vars_int
!--------------------------------- nf_put_vars_real ------------------------
 Function nf_put_vars_real(ncid, varid, start, counts, strides, rvals) &
                              RESULT(status)

! Write out 32 bit real array given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Real(4), Intent(IN) :: rvals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_put_vars_float(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, rvals)
 status = cstatus

 End Function nf_put_vars_real
!--------------------------------- nf_put_vars_double ----------------------
 Function nf_put_vars_double(ncid, varid, start, counts, strides, dvals) &
                                RESULT(status)

! Write out 64 bit real array given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Real(8), Intent(IN) :: dvals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_put_vars_double(cncid, cvarid, cstartptr, ccountsptr, &
                              cstridesptr, dvals)
 status = cstatus

 End Function nf_put_vars_double
!--------------------------------- nf_get_vars_text ----------------------
 Function nf_get_vars_text(ncid, varid, start, counts, strides, text) &
                                RESULT(status)

! Read in a character string from  dataset

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Character(LEN=*), Intent(OUT) :: text 

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1
 text = REPEAT(" ", LEN(text))

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_get_vars_text(cncid, cvarid, cstartptr, ccountsptr, &
                            cstridesptr, text)
 status = cstatus

 End Function nf_get_vars_text
!--------------------------------- nf_get_vars_text_a ----------------------
 Function nf_get_vars_text_a(ncid, varid, start, counts, strides, text) &
                                RESULT(status)

! Read in an array of characters given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Character(LEN=1), Intent(OUT) :: text(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_get_vars_text(cncid, cvarid, cstartptr, ccountsptr, &
                            cstridesptr, text)
 status = cstatus

 End Function nf_get_vars_text_a
!--------------------------------- nf_get_vars_int1 ------------------------
 Function nf_get_vars_int1(ncid, varid, start, counts, strides, i1vals) &
                              RESULT(status)

! Read in 8 bit integer array given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Integer(KIND=KINT1), Intent(OUT) :: i1vals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 If (C_SIGNED_CHAR < 0) Then ! schar not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_get_vars_schar(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, i1vals)
 status = cstatus

 End Function nf_get_vars_int1
!--------------------------------- nf_get_vars_int2 ------------------------
 Function nf_get_vars_int2(ncid, varid, start, counts, strides, i2vals) &
                              RESULT(status)

! Read in 16 bit integer array given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Integer(KIND=KINT2), Intent(OUT) :: i2vals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 If (C_SHORT < 0) Then ! short not supported by processor
   status = NC_EBADTYPE
   Return
 EndIf

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_get_vars_short(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, i2vals)
 status = cstatus

 End Function nf_get_vars_int2
!--------------------------------- nf_get_vars_int -------------------------
 Function nf_get_vars_int(ncid, varid, start, counts, strides, ivals) &
                             RESULT(status)

! Read in default integer array given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Integer, Intent(OUT) :: ivals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_get_vars_int(cncid, cvarid, cstartptr, ccountsptr, &
                           cstridesptr, ivals)
 status = cstatus

 End Function nf_get_vars_int
!--------------------------------- nf_get_vars_real ------------------------
 Function nf_get_vars_real(ncid, varid, start, counts, strides, rvals) &
                              RESULT(status)

! Read in 32 bit real array given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Real(4), Intent(OUT) :: rvals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_get_vars_float(cncid, cvarid, cstartptr, ccountsptr, &
                             cstridesptr, rvals)
 status = cstatus

 End Function nf_get_vars_real
!--------------------------------- nf_get_vars_double ----------------------
 Function nf_get_vars_double(ncid, varid, start, counts, strides, dvals) &
                                RESULT(status)

! Read in 64 bit real array given start, count, and stride

 USE netcdf_nc_interfaces

 Implicit NONE

 Integer, Intent(IN) :: ncid, varid
 Integer, Intent(IN) :: start(*), counts(*), strides(*)
 Real(8), Intent(OUT) :: dvals(*)

 Integer :: status

 Integer :: ndims
 Integer(KIND=C_INT) :: cncid, cvarid, cndims, cstat1, cstatus
 Integer(KIND=C_SIZE_T), TARGET :: cstart(NC_MAX_DIMS), ccounts(NC_MAX_DIMS)
 Integer(KIND=C_PTRDIFF_T), TARGET :: cstrides(NC_MAX_DIMS)
 Type(C_PTR) :: cstartptr, ccountsptr, cstridesptr

 cncid = ncid
 cvarid = varid - 1 ! Subtract 1 to get C varid
 cstart = 0
 ccounts = 0
 cstrides = 1

 cstat1 = nc_inq_varndims(cncid, cvarid, cndims)

 cstartptr   = C_NULL_PTR
 ccountsptr  = C_NULL_PTR
 cstridesptr = C_NULL_PTR
 ndims = cndims
 If (cstat1 == NC_NOERR) Then
   If (ndims > 0) Then ! Flip arrays to C order and subtract 1 from start
     cstart(1:ndims) = start(ndims:1:-1)-1
     ccounts(1:ndims) = counts(ndims:1:-1)
     cstrides(1:ndims) = strides(ndims:1:-1)
   EndIf
   cstartptr  = C_LOC(cstart)
   ccountsptr = C_LOC(ccounts)
   cstridesptr = C_LOC(cstrides)
 EndIf

 cstatus = nc_get_vars_double(cncid, cvarid, cstartptr, ccountsptr, &
                              cstridesptr, dvals)
 status = cstatus

 End Function nf_get_vars_double
#endif
