#line 6 "ncx.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 8
/*
 *  Copyright (C) 2014, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id: ncx.m4 2601 2016-11-07 04:54:42Z wkliao $ */

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wunused-parameter"
#endif

#line 22

#line 26


#line 34

#line 41

#line 41
#if HAVE_CONFIG_H
#line 41
#include <config.h>
#line 41
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#line 53

#line 53
#pragma GCC diagnostic ignored "-Wdeprecated"
#line 53
#include "ncx.h"
#line 53
#include "nc3dispatch.h"

#line 72




#ifdef HAVE_INTTYPES_H
#include <inttypes.h> /* uint16_t, uint32_t, uint64_t */
#elif defined(HAVE_STDINT_H)
#include <stdint.h>   /* uint16_t, uint32_t, uint64_t */
#endif

#line 103

#line 121

/*
 * The only error code returned from subroutines in this file is NC_ERANGE,
 * if errors are detected.
 */

/*
 * An external data representation interface.
 */

/* alias poorly named limits.h macros */
#define  SHORT_MAX  SHRT_MAX
#define  SHORT_MIN  SHRT_MIN
#define USHORT_MAX USHRT_MAX
#ifndef LLONG_MAX
#   define LLONG_MAX	9223372036854775807LL
#   define LLONG_MIN	(-LLONG_MAX - 1LL)
#   define ULLONG_MAX	18446744073709551615ULL
#endif
#ifndef LONG_LONG_MAX
#define LONG_LONG_MAX LLONG_MAX
#endif
#ifndef LONGLONG_MAX
#define LONGLONG_MAX LONG_LONG_MAX
#endif
#ifndef LONG_LONG_MIN
#define LONG_LONG_MIN LLONG_MIN
#endif
#ifndef LONGLONG_MIN
#define LONGLONG_MIN LONG_LONG_MIN
#endif
#ifndef ULONG_LONG_MAX
#define ULONG_LONG_MAX ULLONG_MAX
#endif
#ifndef ULONGLONG_MAX
#define ULONGLONG_MAX ULONG_LONG_MAX
#endif
#include <float.h>
#ifndef FLT_MAX /* This POSIX macro missing on some systems */
# ifndef NO_IEEE_FLOAT
# define FLT_MAX 3.40282347e+38f
# else
# error "You will need to define FLT_MAX"
# endif
#endif
/* alias poorly named float.h macros */
#define FLOAT_MAX FLT_MAX
#define FLOAT_MIN (-FLT_MAX)
#define DOUBLE_MAX DBL_MAX
#define DOUBLE_MIN (-DBL_MAX)
#define FLOAT_MAX_EXP FLT_MAX_EXP
#define DOUBLE_MAX_EXP DBL_MAX_EXP
#include <assert.h>
#define UCHAR_MIN 0
#define Min(a,b) ((a) < (b) ? (a) : (b))
#define Max(a,b) ((a) > (b) ? (a) : (b))

#ifndef SIZEOF_UCHAR
#ifdef  SIZEOF_UNSIGNED_CHAR
#define SIZEOF_UCHAR SIZEOF_UNSIGNED_CHAR
#else
#error "unknown SIZEOF_UCHAR"
#endif
#endif

#ifndef SIZEOF_USHORT
#ifdef  SIZEOF_UNSIGNED_SHORT_INT
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT_INT
#elif defined(SIZEOF_UNSIGNED_SHORT)
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT
#else
#error "unknown SIZEOF_USHORT"
#endif
#endif

#ifndef SIZEOF_UINT
#ifdef  SIZEOF_UNSIGNED_INT
#define SIZEOF_UINT SIZEOF_UNSIGNED_INT
#else
#error "unknown SIZEOF_UINT"
#endif
#endif

#ifndef SIZEOF_LONGLONG
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_LONGLONG SIZEOF_LONG_LONG
#else
#error "unknown SIZEOF_LONGLONG"
#endif
#endif

#ifndef SIZEOF_INT64
#ifdef  SIZEOF_LONG_LONG
#define SIZEOF_INT64 SIZEOF_LONG_LONG
#elif defined(SIZEOF_LONGLONG)
#define SIZEOF_INT64 SIZEOF_LONGLONG
#else
#error "unknown SIZEOF_INT64"
#endif
#endif

#ifndef SIZEOF_ULONGLONG
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_ULONGLONG SIZEOF_UNSIGNED_LONG_LONG
#else
#error "unknown SIZEOF_ULONGLONG"
#endif
#endif

#ifndef SIZEOF_UINT64
#ifdef  SIZEOF_UNSIGNED_LONG_LONG
#define SIZEOF_UINT64 SIZEOF_UNSIGNED_LONG_LONG
#elif defined(SIZEOF_ULONGLONG)
#define SIZEOF_UINT64 SIZEOF_ULONGLONG
#else
#error "unknown SIZEOF_UINT64"
#endif
#endif

/*
 * If the machine's float domain is "smaller" than the external one
 * use the machine domain
 */
#if defined(FLT_MAX_EXP) && FLT_MAX_EXP < 128 /* 128 is X_FLT_MAX_EXP */
#undef X_FLOAT_MAX
# define X_FLOAT_MAX FLT_MAX
#undef X_FLOAT_MIN
# define X_FLOAT_MIN (-X_FLOAT_MAX)
#endif

#if defined(_SX) && _SX != 0 /* NEC SUPER UX */
#define LOOPCNT 256    /* must be no longer than hardware vector length */
#if _INT64
#undef  INT_MAX /* workaround cpp bug */
#define INT_MAX  X_INT_MAX
#undef  INT_MIN /* workaround cpp bug */
#define INT_MIN  X_INT_MIN
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  X_INT_MAX
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN  X_INT_MIN
#elif _LONG64
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  4294967295L
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN -4294967295L
#endif
#if !_FLOAT0
#error "FLOAT1 and FLOAT2 not supported"
#endif
#endif /* _SX */

static const char nada[X_ALIGN] = {0, 0, 0, 0};

#ifndef WORDS_BIGENDIAN
/* LITTLE_ENDIAN: DEC and intel */
/*
 * Routines to convert to BIG ENDIAN.
 * Optimize the swapn?b() and swap?b() routines aggressively.
 */

#define SWAP2(a) ( (((a) & 0xff) << 8) | \
                   (((a) >> 8) & 0xff) )

#define SWAP4(a) ( ((a) << 24) | \
                  (((a) <<  8) & 0x00ff0000) | \
                  (((a) >>  8) & 0x0000ff00) | \
                  (((a) >> 24) & 0x000000ff) )

#define SWAP8(a) ( (((a) & 0x00000000000000FFULL) << 56) | \
                   (((a) & 0x000000000000FF00ULL) << 40) | \
                   (((a) & 0x0000000000FF0000ULL) << 24) | \
                   (((a) & 0x00000000FF000000ULL) <<  8) | \
                   (((a) & 0x000000FF00000000ULL) >>  8) | \
                   (((a) & 0x0000FF0000000000ULL) >> 24) | \
                   (((a) & 0x00FF000000000000ULL) >> 40) | \
                   (((a) & 0xFF00000000000000ULL) >> 56) )


inline static void
swapn2b(void *dst, const void *src, size_t nn)
{
    /* it is OK if dst == src */
    int i;
    uint16_t *op = (uint16_t*) dst;
    uint16_t *ip = (uint16_t*) src;
    for (i=0; i<nn; i++) {
        op[i] = ip[i];
        op[i] = (uint16_t)SWAP2(op[i]);
    }
#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *
 *	while (nn-- > 0)
 *	{
 *		*op++ = *(++ip);
 *		*op++ = *(ip++ -1);
 *	}
 */
	while (nn > 3)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		nn -= 4;
	}
	while (nn-- > 0)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
	}
#endif
}

# ifndef vax
inline static void
swap4b(void *dst, const void *src)
{
    /* copy over, make the below swap in-place */
    uint32_t tmp = *(uint32_t*)src;
    tmp = SWAP4(tmp);
    memcpy(dst, &tmp, 4);

    /* Codes below will cause "break strict-aliasing rules" in gcc
    uint32_t *op = (uint32_t*)dst;
    *op = *(uint32_t*)src;
    *op = SWAP4(*op);
    */

    /* Below are copied from netCDF-4.
     * See https://bugtracking.unidata.ucar.edu/browse/NCF-338
     * Quote "One issue we are wrestling with is how compilers optimize this
     * code.  For some reason, we are actually needing to add an artificial
     * move to a 4 byte space to get it to work.  I think what is happening is
     * that the optimizer is bit shifting within a double, which is incorrect.
     * The following code actually does work correctly.
     *  This is in Linux land, gcc.
     *
     * However, the above in-place byte-swap does not appear affected by this.
     */
#if 0
    uint32_t *ip = (uint32_t*)src;
    uint32_t tempOut;  /* cannot use pointer when gcc O2 optimizer is used */
    tempOut = SWAP4(*ip);

    *(float *)dst = *(float *)(&tempOut);
#endif

    /* OLD implementation that results in four load and four store CPU
       instructions
    char *op = dst;
    const char *ip = src;
    op[0] = ip[3];
    op[1] = ip[2];
    op[2] = ip[1];
    op[3] = ip[0];
    */

}
# endif /* !vax */

inline static void
swapn4b(void *dst, const void *src, size_t nn)
{
    int i;
    uint32_t *op = (uint32_t*) dst;
    uint32_t *ip = (uint32_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        op[i] = ip[i];
        op[i] = SWAP4(op[i]);
    }

#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while (nn-- > 0)
 *	{
 *		op[0] = ip[3];
 *		op[1] = ip[2];
 *		op[2] = ip[1];
 *		op[3] = ip[0];
 *		op += 4;
 *		ip += 4;
 *	}
 */
	while (nn > 3)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op[8] = ip[11];
		op[9] = ip[10];
		op[10] = ip[9];
		op[11] = ip[8];
		op[12] = ip[15];
		op[13] = ip[14];
		op[14] = ip[13];
		op[15] = ip[12];
		op += 16;
		ip += 16;
		nn -= 4;
	}
	while (nn-- > 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op += 4;
		ip += 4;
	}
#endif
}

# ifndef vax
inline static void
swap8b(void *dst, const void *src)
{
#ifdef FLOAT_WORDS_BIGENDIAN
    /* copy over, make the below swap in-place */
    *(uint64_t*)dst = *(uint64_t*)src;

    uint32_t *op = (uint32_t*)dst;
    *op = SWAP4(*op);
    op = (uint32_t*)((char*)dst+4);
    *op = SWAP4(*op);
#else
    uint64_t *op = (uint64_t*)dst;
    /* copy over, make the below swap in-place */
    *op = *(uint64_t*)src;
    *op = SWAP8(*op);
#endif

#if 0
	char *op = dst;
	const char *ip = src;
#  ifndef FLOAT_WORDS_BIGENDIAN
	op[0] = ip[7];
	op[1] = ip[6];
	op[2] = ip[5];
	op[3] = ip[4];
	op[4] = ip[3];
	op[5] = ip[2];
	op[6] = ip[1];
	op[7] = ip[0];
#  else
	op[0] = ip[3];
	op[1] = ip[2];
	op[2] = ip[1];
	op[3] = ip[0];
	op[4] = ip[7];
	op[5] = ip[6];
	op[6] = ip[5];
	op[7] = ip[4];
#endif
#endif
}
# endif /* !vax */

# ifndef vax
inline static void
swapn8b(void *dst, const void *src, size_t nn)
{
#ifdef FLOAT_WORDS_BIGENDIAN
    int i;
    uint64_t *dst_p = (uint64_t*) dst;
    uint64_t *src_p = (uint64_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        dst_p[i] = src_p[i];
        uint32_t *op = (uint32_t*)(&dst_p[i]);
        *op = SWAP4(*op);
        op = (uint32_t*)((char*)op+4);
        *op = SWAP4(*op);
    }
#else
    int i;
    uint64_t *op = (uint64_t*) dst;
    uint64_t *ip = (uint64_t*) src;
    for (i=0; i<nn; i++) {
        /* copy over, make the below swap in-place */
        op[i] = ip[i];
        op[i] = SWAP8(op[i]);
    }
#endif

#if 0
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while (nn-- > 0)
 *	{
 *		op[0] = ip[7];
 *		op[1] = ip[6];
 *		op[2] = ip[5];
 *		op[3] = ip[4];
 *		op[4] = ip[3];
 *		op[5] = ip[2];
 *		op[6] = ip[1];
 *		op[7] = ip[0];
 *		op += 8;
 *		ip += 8;
 *	}
 */
#  ifndef FLOAT_WORDS_BIGENDIAN
	while (nn > 1)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op[8] = ip[15];
		op[9] = ip[14];
		op[10] = ip[13];
		op[11] = ip[12];
		op[12] = ip[11];
		op[13] = ip[10];
		op[14] = ip[9];
		op[15] = ip[8];
		op += 16;
		ip += 16;
		nn -= 2;
	}
	while (nn-- > 0)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op += 8;
		ip += 8;
	}
#  else
	while (nn-- > 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op += 8;
		ip += 8;
	}
#endif
#endif
}
# endif /* !vax */

#endif /* LITTLE_ENDIAN */

#line 622

#line 626

#line 638

#line 653


/*
 * Primitive numeric conversion functions.
 */

#line 681

#line 729

#line 762

#line 808

/* x_schar */
/* x_uchar */

/* We don't implement any x_schar and x_uchar primitives. */


/* external NC_SHORT --------------------------------------------------------*/

#if SHORT_MAX == X_SHORT_MAX
typedef short ix_short;
#define SIZEOF_IX_SHORT SIZEOF_SHORT
#define IX_SHORT_MAX SHORT_MAX
#elif INT_MAX >= X_SHORT_MAX
typedef int ix_short;
#define SIZEOF_IX_SHORT SIZEOF_INT
#define IX_SHORT_MAX INT_MAX
#elif LONG_MAX >= X_SHORT_MAX
typedef long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG
#define IX_SHORT_MAX LONG_MAX
#elif LLONG_MAX >= X_SHORT_MAX
typedef long long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONGLONG
#define IX_SHORT_MAX LLONG_MAX
#else
#error "ix_short implementation"
#endif

static void
get_ix_short(const void *xp, ix_short *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_short)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_short)(*ip | *cp);
}

static void
put_ix_short(void *xp, const ix_short *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 860
ncx_get_short_schar(const void *xp, schar *ip)
#line 860
{
#line 860
    int err=NC_NOERR;
#line 860
    ix_short xx;
#line 860
    get_ix_short(xp, &xx);
#line 860

#line 860
#if IX_SHORT_MAX > SCHAR_MAX
#line 860
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 860
#ifdef ERANGE_FILL
#line 860
        *ip = NC_FILL_BYTE;
#line 860
        return NC_ERANGE;
#line 860
#else
#line 860
        err = NC_ERANGE;
#line 860
#endif
#line 860
    }
#line 860
#endif
#line 860

#line 860

#line 860
    *ip = (schar) xx;
#line 860
    return err;
#line 860
}
#line 860

static int
#line 861
ncx_get_short_short(const void *xp, short *ip)
#line 861
{
#line 861
    int err=NC_NOERR;
#line 861
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 861
    get_ix_short(xp, (ix_short *)ip);
#line 861
#else
#line 861
    ix_short xx;
#line 861
    get_ix_short(xp, &xx);
#line 861

#line 861
#if IX_SHORT_MAX > SHORT_MAX
#line 861
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 861
#ifdef ERANGE_FILL
#line 861
        *ip = NC_FILL_SHORT;
#line 861
        return NC_ERANGE;
#line 861
#else
#line 861
        err = NC_ERANGE;
#line 861
#endif
#line 861
    }
#line 861
#endif
#line 861

#line 861

#line 861
    *ip = (short) xx;
#line 861
#endif
#line 861
    return err;
#line 861
}
#line 861

static int
#line 862
ncx_get_short_int(const void *xp, int *ip)
#line 862
{
#line 862
    int err=NC_NOERR;
#line 862
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 862
    get_ix_short(xp, (ix_short *)ip);
#line 862
#else
#line 862
    ix_short xx;
#line 862
    get_ix_short(xp, &xx);
#line 862

#line 862
#if IX_SHORT_MAX > INT_MAX
#line 862
    if (xx > INT_MAX || xx < INT_MIN) {
#line 862
#ifdef ERANGE_FILL
#line 862
        *ip = NC_FILL_INT;
#line 862
        return NC_ERANGE;
#line 862
#else
#line 862
        err = NC_ERANGE;
#line 862
#endif
#line 862
    }
#line 862
#endif
#line 862

#line 862

#line 862
    *ip = (int) xx;
#line 862
#endif
#line 862
    return err;
#line 862
}
#line 862

static int
#line 863
ncx_get_short_long(const void *xp, long *ip)
#line 863
{
#line 863
    int err=NC_NOERR;
#line 863
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 863
    get_ix_short(xp, (ix_short *)ip);
#line 863
#else
#line 863
    ix_short xx;
#line 863
    get_ix_short(xp, &xx);
#line 863

#line 863
#if IX_SHORT_MAX > LONG_MAX
#line 863
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 863
#ifdef ERANGE_FILL
#line 863
        *ip = NC_FILL_INT;
#line 863
        return NC_ERANGE;
#line 863
#else
#line 863
        err = NC_ERANGE;
#line 863
#endif
#line 863
    }
#line 863
#endif
#line 863

#line 863

#line 863
    *ip = (long) xx;
#line 863
#endif
#line 863
    return err;
#line 863
}
#line 863

static int
#line 864
ncx_get_short_longlong(const void *xp, longlong *ip)
#line 864
{
#line 864
    int err=NC_NOERR;
#line 864
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 864
    get_ix_short(xp, (ix_short *)ip);
#line 864
#else
#line 864
    ix_short xx;
#line 864
    get_ix_short(xp, &xx);
#line 864

#line 864
#if IX_SHORT_MAX > LONGLONG_MAX
#line 864
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 864
#ifdef ERANGE_FILL
#line 864
        *ip = NC_FILL_INT64;
#line 864
        return NC_ERANGE;
#line 864
#else
#line 864
        err = NC_ERANGE;
#line 864
#endif
#line 864
    }
#line 864
#endif
#line 864

#line 864

#line 864
    *ip = (longlong) xx;
#line 864
#endif
#line 864
    return err;
#line 864
}
#line 864

static int
#line 865
ncx_get_short_ushort(const void *xp, ushort *ip)
#line 865
{
#line 865
    int err=NC_NOERR;
#line 865
    ix_short xx;
#line 865
    get_ix_short(xp, &xx);
#line 865

#line 865
#if IX_SHORT_MAX > USHORT_MAX
#line 865
    if (xx > USHORT_MAX) {
#line 865
#ifdef ERANGE_FILL
#line 865
        *ip = NC_FILL_USHORT;
#line 865
        return NC_ERANGE;
#line 865
#else
#line 865
        err = NC_ERANGE;
#line 865
#endif
#line 865
    }
#line 865
#endif
#line 865

#line 865
    if (xx < 0) {
#line 865
#ifdef ERANGE_FILL
#line 865
        *ip = NC_FILL_USHORT;
#line 865
        return NC_ERANGE;
#line 865
#else
#line 865
        err = NC_ERANGE; /* because ip is unsigned */
#line 865
#endif
#line 865
    }
#line 865
    *ip = (ushort) xx;
#line 865
    return err;
#line 865
}
#line 865

static int
#line 866
ncx_get_short_uchar(const void *xp, uchar *ip)
#line 866
{
#line 866
    int err=NC_NOERR;
#line 866
    ix_short xx;
#line 866
    get_ix_short(xp, &xx);
#line 866

#line 866
#if IX_SHORT_MAX > UCHAR_MAX
#line 866
    if (xx > UCHAR_MAX) {
#line 866
#ifdef ERANGE_FILL
#line 866
        *ip = NC_FILL_UBYTE;
#line 866
        return NC_ERANGE;
#line 866
#else
#line 866
        err = NC_ERANGE;
#line 866
#endif
#line 866
    }
#line 866
#endif
#line 866

#line 866
    if (xx < 0) {
#line 866
#ifdef ERANGE_FILL
#line 866
        *ip = NC_FILL_UBYTE;
#line 866
        return NC_ERANGE;
#line 866
#else
#line 866
        err = NC_ERANGE; /* because ip is unsigned */
#line 866
#endif
#line 866
    }
#line 866
    *ip = (uchar) xx;
#line 866
    return err;
#line 866
}
#line 866

static int
#line 867
ncx_get_short_uint(const void *xp, uint *ip)
#line 867
{
#line 867
    int err=NC_NOERR;
#line 867
    ix_short xx;
#line 867
    get_ix_short(xp, &xx);
#line 867

#line 867
#if IX_SHORT_MAX > UINT_MAX
#line 867
    if (xx > UINT_MAX) {
#line 867
#ifdef ERANGE_FILL
#line 867
        *ip = NC_FILL_UINT;
#line 867
        return NC_ERANGE;
#line 867
#else
#line 867
        err = NC_ERANGE;
#line 867
#endif
#line 867
    }
#line 867
#endif
#line 867

#line 867
    if (xx < 0) {
#line 867
#ifdef ERANGE_FILL
#line 867
        *ip = NC_FILL_UINT;
#line 867
        return NC_ERANGE;
#line 867
#else
#line 867
        err = NC_ERANGE; /* because ip is unsigned */
#line 867
#endif
#line 867
    }
#line 867
    *ip = (uint) xx;
#line 867
    return err;
#line 867
}
#line 867

static int
#line 868
ncx_get_short_ulonglong(const void *xp, ulonglong *ip)
#line 868
{
#line 868
    int err=NC_NOERR;
#line 868
    ix_short xx;
#line 868
    get_ix_short(xp, &xx);
#line 868

#line 868
#if IX_SHORT_MAX > ULONGLONG_MAX
#line 868
    if (xx > ULONGLONG_MAX) {
#line 868
#ifdef ERANGE_FILL
#line 868
        *ip = NC_FILL_UINT64;
#line 868
        return NC_ERANGE;
#line 868
#else
#line 868
        err = NC_ERANGE;
#line 868
#endif
#line 868
    }
#line 868
#endif
#line 868

#line 868
    if (xx < 0) {
#line 868
#ifdef ERANGE_FILL
#line 868
        *ip = NC_FILL_UINT64;
#line 868
        return NC_ERANGE;
#line 868
#else
#line 868
        err = NC_ERANGE; /* because ip is unsigned */
#line 868
#endif
#line 868
    }
#line 868
    *ip = (ulonglong) xx;
#line 868
    return err;
#line 868
}
#line 868

static int
#line 869
ncx_get_short_float(const void *xp, float *ip)
#line 869
{
#line 869
	ix_short xx;
#line 869
	get_ix_short(xp, &xx);
#line 869
	*ip = (float)xx;
#line 869
	return NC_NOERR;
#line 869
}
#line 869

static int
#line 870
ncx_get_short_double(const void *xp, double *ip)
#line 870
{
#line 870
	ix_short xx;
#line 870
	get_ix_short(xp, &xx);
#line 870
	*ip = (double)xx;
#line 870
	return NC_NOERR;
#line 870
}
#line 870


static int
ncx_put_short_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
		*cp++ = 0xff;
	else
		*cp++ = 0;
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_short_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 893
ncx_put_short_short(void *xp, const short *ip, void *fillp)
#line 893
{
#line 893
    int err=NC_NOERR;
#line 893
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 893
    put_ix_short(xp, (const ix_short *)ip);
#line 893
#else
#line 893
    ix_short xx = NC_FILL_SHORT;
#line 893

#line 893
#if IX_SHORT_MAX < SHORT_MAX
#line 893
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 893
        
#line 893
#ifdef ERANGE_FILL
#line 893
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 893
#endif
#line 893
        err = NC_ERANGE;
#line 893
    }
#line 893
#ifdef ERANGE_FILL
#line 893
    else
#line 893
#endif
#line 893
#endif
#line 893
        xx = (ix_short)*ip;
#line 893

#line 893
    put_ix_short(xp, &xx);
#line 893
#endif
#line 893
    return err;
#line 893
}
#line 893

static int
#line 894
ncx_put_short_int(void *xp, const int *ip, void *fillp)
#line 894
{
#line 894
    int err=NC_NOERR;
#line 894
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 894
    put_ix_short(xp, (const ix_short *)ip);
#line 894
#else
#line 894
    ix_short xx = NC_FILL_SHORT;
#line 894

#line 894
#if IX_SHORT_MAX < INT_MAX
#line 894
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 894
        
#line 894
#ifdef ERANGE_FILL
#line 894
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 894
#endif
#line 894
        err = NC_ERANGE;
#line 894
    }
#line 894
#ifdef ERANGE_FILL
#line 894
    else
#line 894
#endif
#line 894
#endif
#line 894
        xx = (ix_short)*ip;
#line 894

#line 894
    put_ix_short(xp, &xx);
#line 894
#endif
#line 894
    return err;
#line 894
}
#line 894

static int
#line 895
ncx_put_short_long(void *xp, const long *ip, void *fillp)
#line 895
{
#line 895
    int err=NC_NOERR;
#line 895
#if SIZEOF_IX_SHORT == SIZEOF_LONG && IX_SHORT_MAX == LONG_MAX
#line 895
    put_ix_short(xp, (const ix_short *)ip);
#line 895
#else
#line 895
    ix_short xx = NC_FILL_SHORT;
#line 895

#line 895
#if IX_SHORT_MAX < LONG_MAX
#line 895
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 895
        
#line 895
#ifdef ERANGE_FILL
#line 895
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 895
#endif
#line 895
        err = NC_ERANGE;
#line 895
    }
#line 895
#ifdef ERANGE_FILL
#line 895
    else
#line 895
#endif
#line 895
#endif
#line 895
        xx = (ix_short)*ip;
#line 895

#line 895
    put_ix_short(xp, &xx);
#line 895
#endif
#line 895
    return err;
#line 895
}
#line 895

static int
#line 896
ncx_put_short_longlong(void *xp, const longlong *ip, void *fillp)
#line 896
{
#line 896
    int err=NC_NOERR;
#line 896
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 896
    put_ix_short(xp, (const ix_short *)ip);
#line 896
#else
#line 896
    ix_short xx = NC_FILL_SHORT;
#line 896

#line 896
#if IX_SHORT_MAX < LONGLONG_MAX
#line 896
    if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 896
        
#line 896
#ifdef ERANGE_FILL
#line 896
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 896
#endif
#line 896
        err = NC_ERANGE;
#line 896
    }
#line 896
#ifdef ERANGE_FILL
#line 896
    else
#line 896
#endif
#line 896
#endif
#line 896
        xx = (ix_short)*ip;
#line 896

#line 896
    put_ix_short(xp, &xx);
#line 896
#endif
#line 896
    return err;
#line 896
}
#line 896

static int
#line 897
ncx_put_short_ushort(void *xp, const ushort *ip, void *fillp)
#line 897
{
#line 897
    int err=NC_NOERR;
#line 897
    ix_short xx = NC_FILL_SHORT;
#line 897

#line 897
#if IX_SHORT_MAX < USHORT_MAX
#line 897
    if (*ip > IX_SHORT_MAX) {
#line 897
        
#line 897
#ifdef ERANGE_FILL
#line 897
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 897
#endif
#line 897
        err = NC_ERANGE;
#line 897
    }
#line 897
#ifdef ERANGE_FILL
#line 897
    else
#line 897
#endif
#line 897
#endif
#line 897
        xx = (ix_short)*ip;
#line 897

#line 897
    put_ix_short(xp, &xx);
#line 897
    return err;
#line 897
}
#line 897

static int
#line 898
ncx_put_short_uint(void *xp, const uint *ip, void *fillp)
#line 898
{
#line 898
    int err=NC_NOERR;
#line 898
    ix_short xx = NC_FILL_SHORT;
#line 898

#line 898
#if IX_SHORT_MAX < UINT_MAX
#line 898
    if (*ip > IX_SHORT_MAX) {
#line 898
        
#line 898
#ifdef ERANGE_FILL
#line 898
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 898
#endif
#line 898
        err = NC_ERANGE;
#line 898
    }
#line 898
#ifdef ERANGE_FILL
#line 898
    else
#line 898
#endif
#line 898
#endif
#line 898
        xx = (ix_short)*ip;
#line 898

#line 898
    put_ix_short(xp, &xx);
#line 898
    return err;
#line 898
}
#line 898

static int
#line 899
ncx_put_short_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 899
{
#line 899
    int err=NC_NOERR;
#line 899
    ix_short xx = NC_FILL_SHORT;
#line 899

#line 899
#if IX_SHORT_MAX < ULONGLONG_MAX
#line 899
    if (*ip > IX_SHORT_MAX) {
#line 899
        
#line 899
#ifdef ERANGE_FILL
#line 899
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 899
#endif
#line 899
        err = NC_ERANGE;
#line 899
    }
#line 899
#ifdef ERANGE_FILL
#line 899
    else
#line 899
#endif
#line 899
#endif
#line 899
        xx = (ix_short)*ip;
#line 899

#line 899
    put_ix_short(xp, &xx);
#line 899
    return err;
#line 899
}
#line 899

static int
#line 900
ncx_put_short_float(void *xp, const float *ip, void *fillp)
#line 900
{
#line 900
    int err=NC_NOERR;
#line 900
    ix_short xx = NC_FILL_SHORT;
#line 900

#line 900
    if (*ip > (double)X_SHORT_MAX || *ip < (double)X_SHORT_MIN) {
#line 900
        
#line 900
#ifdef ERANGE_FILL
#line 900
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 900
#endif
#line 900
        err = NC_ERANGE;
#line 900
    }
#line 900
#ifdef ERANGE_FILL
#line 900
    else
#line 900
#endif
#line 900
        xx = (ix_short)*ip;
#line 900

#line 900
    put_ix_short(xp, &xx);
#line 900
    return err;
#line 900
}
#line 900

static int
#line 901
ncx_put_short_double(void *xp, const double *ip, void *fillp)
#line 901
{
#line 901
    int err=NC_NOERR;
#line 901
    ix_short xx = NC_FILL_SHORT;
#line 901

#line 901
    if (*ip > X_SHORT_MAX || *ip < X_SHORT_MIN) {
#line 901
        
#line 901
#ifdef ERANGE_FILL
#line 901
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 901
#endif
#line 901
        err = NC_ERANGE;
#line 901
    }
#line 901
#ifdef ERANGE_FILL
#line 901
    else
#line 901
#endif
#line 901
        xx = (ix_short)*ip;
#line 901

#line 901
    put_ix_short(xp, &xx);
#line 901
    return err;
#line 901
}
#line 901


/* external NC_USHORT -------------------------------------------------------*/

#if USHORT_MAX == X_USHORT_MAX
typedef unsigned short ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_USHORT
#define IX_USHORT_MAX USHORT_MAX
#elif UINT_MAX >= X_USHORT_MAX
typedef unsigned int ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_UINT
#define IX_USHORT_MAX UINT_MAX
#elif ULONG_MAX >= X_USHORT_MAX
typedef unsigned long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONG
#define IX_USHORT_MAX ULONG_MAX
#elif ULLONG_MAX >= X_USHORT_MAX
typedef unsigned long long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONGLONG
#define IX_USHORT_MAX ULLONG_MAX
#else
#error "ix_ushort implementation"
#endif

static void
get_ix_ushort(const void *xp, ix_ushort *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = (ix_ushort)(*cp++ << 8);
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if (*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip = (ix_ushort)(*ip | *cp);
}

static void
put_ix_ushort(void *xp, const ix_ushort *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (uchar)((*ip) >> 8);
	*cp   = (uchar)((*ip) & 0xff);
}

static int
#line 948
ncx_get_ushort_schar(const void *xp, schar *ip)
#line 948
{
#line 948
    int err=NC_NOERR;
#line 948
    ix_ushort xx;
#line 948
    get_ix_ushort(xp, &xx);
#line 948

#line 948
#if IX_USHORT_MAX > SCHAR_MAX
#line 948
    if (xx > SCHAR_MAX) {
#line 948
#ifdef ERANGE_FILL
#line 948
        *ip = NC_FILL_BYTE;
#line 948
        return NC_ERANGE;
#line 948
#else
#line 948
        err = NC_ERANGE;
#line 948
#endif
#line 948
    }
#line 948
#endif
#line 948

#line 948

#line 948
    *ip = (schar) xx;
#line 948
    return err;
#line 948
}
#line 948

static int
#line 949
ncx_get_ushort_short(const void *xp, short *ip)
#line 949
{
#line 949
    int err=NC_NOERR;
#line 949
    ix_ushort xx;
#line 949
    get_ix_ushort(xp, &xx);
#line 949

#line 949
#if IX_USHORT_MAX > SHORT_MAX
#line 949
    if (xx > SHORT_MAX) {
#line 949
#ifdef ERANGE_FILL
#line 949
        *ip = NC_FILL_SHORT;
#line 949
        return NC_ERANGE;
#line 949
#else
#line 949
        err = NC_ERANGE;
#line 949
#endif
#line 949
    }
#line 949
#endif
#line 949

#line 949

#line 949
    *ip = (short) xx;
#line 949
    return err;
#line 949
}
#line 949

static int
#line 950
ncx_get_ushort_int(const void *xp, int *ip)
#line 950
{
#line 950
    int err=NC_NOERR;
#line 950
    ix_ushort xx;
#line 950
    get_ix_ushort(xp, &xx);
#line 950

#line 950
#if IX_USHORT_MAX > INT_MAX
#line 950
    if (xx > INT_MAX) {
#line 950
#ifdef ERANGE_FILL
#line 950
        *ip = NC_FILL_INT;
#line 950
        return NC_ERANGE;
#line 950
#else
#line 950
        err = NC_ERANGE;
#line 950
#endif
#line 950
    }
#line 950
#endif
#line 950

#line 950

#line 950
    *ip = (int) xx;
#line 950
    return err;
#line 950
}
#line 950

static int
#line 951
ncx_get_ushort_long(const void *xp, long *ip)
#line 951
{
#line 951
    int err=NC_NOERR;
#line 951
    ix_ushort xx;
#line 951
    get_ix_ushort(xp, &xx);
#line 951

#line 951
#if IX_USHORT_MAX > LONG_MAX
#line 951
    if (xx > LONG_MAX) {
#line 951
#ifdef ERANGE_FILL
#line 951
        *ip = NC_FILL_INT;
#line 951
        return NC_ERANGE;
#line 951
#else
#line 951
        err = NC_ERANGE;
#line 951
#endif
#line 951
    }
#line 951
#endif
#line 951

#line 951

#line 951
    *ip = (long) xx;
#line 951
    return err;
#line 951
}
#line 951

static int
#line 952
ncx_get_ushort_longlong(const void *xp, longlong *ip)
#line 952
{
#line 952
    int err=NC_NOERR;
#line 952
    ix_ushort xx;
#line 952
    get_ix_ushort(xp, &xx);
#line 952

#line 952
#if IX_USHORT_MAX > LONGLONG_MAX
#line 952
    if (xx > LONGLONG_MAX) {
#line 952
#ifdef ERANGE_FILL
#line 952
        *ip = NC_FILL_INT64;
#line 952
        return NC_ERANGE;
#line 952
#else
#line 952
        err = NC_ERANGE;
#line 952
#endif
#line 952
    }
#line 952
#endif
#line 952

#line 952

#line 952
    *ip = (longlong) xx;
#line 952
    return err;
#line 952
}
#line 952

static int
#line 953
ncx_get_ushort_ushort(const void *xp, ushort *ip)
#line 953
{
#line 953
    int err=NC_NOERR;
#line 953
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 953
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 953
#else
#line 953
    ix_ushort xx;
#line 953
    get_ix_ushort(xp, &xx);
#line 953

#line 953
#if IX_USHORT_MAX > USHORT_MAX
#line 953
    if (xx > USHORT_MAX) {
#line 953
#ifdef ERANGE_FILL
#line 953
        *ip = NC_FILL_USHORT;
#line 953
        return NC_ERANGE;
#line 953
#else
#line 953
        err = NC_ERANGE;
#line 953
#endif
#line 953
    }
#line 953
#endif
#line 953

#line 953

#line 953
    *ip = (ushort) xx;
#line 953
#endif
#line 953
    return err;
#line 953
}
#line 953

static int
#line 954
ncx_get_ushort_uchar(const void *xp, uchar *ip)
#line 954
{
#line 954
    int err=NC_NOERR;
#line 954
#if SIZEOF_IX_USHORT == SIZEOF_UCHAR && IX_USHORT_MAX == UCHAR_MAX
#line 954
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 954
#else
#line 954
    ix_ushort xx;
#line 954
    get_ix_ushort(xp, &xx);
#line 954

#line 954
#if IX_USHORT_MAX > UCHAR_MAX
#line 954
    if (xx > UCHAR_MAX) {
#line 954
#ifdef ERANGE_FILL
#line 954
        *ip = NC_FILL_UBYTE;
#line 954
        return NC_ERANGE;
#line 954
#else
#line 954
        err = NC_ERANGE;
#line 954
#endif
#line 954
    }
#line 954
#endif
#line 954

#line 954

#line 954
    *ip = (uchar) xx;
#line 954
#endif
#line 954
    return err;
#line 954
}
#line 954

static int
#line 955
ncx_get_ushort_uint(const void *xp, uint *ip)
#line 955
{
#line 955
    int err=NC_NOERR;
#line 955
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 955
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 955
#else
#line 955
    ix_ushort xx;
#line 955
    get_ix_ushort(xp, &xx);
#line 955

#line 955
#if IX_USHORT_MAX > UINT_MAX
#line 955
    if (xx > UINT_MAX) {
#line 955
#ifdef ERANGE_FILL
#line 955
        *ip = NC_FILL_UINT;
#line 955
        return NC_ERANGE;
#line 955
#else
#line 955
        err = NC_ERANGE;
#line 955
#endif
#line 955
    }
#line 955
#endif
#line 955

#line 955

#line 955
    *ip = (uint) xx;
#line 955
#endif
#line 955
    return err;
#line 955
}
#line 955

static int
#line 956
ncx_get_ushort_ulonglong(const void *xp, ulonglong *ip)
#line 956
{
#line 956
    int err=NC_NOERR;
#line 956
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 956
    get_ix_ushort(xp, (ix_ushort *)ip);
#line 956
#else
#line 956
    ix_ushort xx;
#line 956
    get_ix_ushort(xp, &xx);
#line 956

#line 956
#if IX_USHORT_MAX > ULONGLONG_MAX
#line 956
    if (xx > ULONGLONG_MAX) {
#line 956
#ifdef ERANGE_FILL
#line 956
        *ip = NC_FILL_UINT64;
#line 956
        return NC_ERANGE;
#line 956
#else
#line 956
        err = NC_ERANGE;
#line 956
#endif
#line 956
    }
#line 956
#endif
#line 956

#line 956

#line 956
    *ip = (ulonglong) xx;
#line 956
#endif
#line 956
    return err;
#line 956
}
#line 956

static int
#line 957
ncx_get_ushort_float(const void *xp, float *ip)
#line 957
{
#line 957
	ix_ushort xx;
#line 957
	get_ix_ushort(xp, &xx);
#line 957
	*ip = (float)xx;
#line 957
	return NC_NOERR;
#line 957
}
#line 957

static int
#line 958
ncx_get_ushort_double(const void *xp, double *ip)
#line 958
{
#line 958
	ix_ushort xx;
#line 958
	get_ix_ushort(xp, &xx);
#line 958
	*ip = (double)xx;
#line 958
	return NC_NOERR;
#line 958
}
#line 958


static int
ncx_put_ushort_schar(void *xp, const schar *ip, void *fillp)
{
    int err=NC_NOERR;
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 2);
#ifndef WORDS_BIGENDIAN
        swapn2b(xp, xp, 1);
#endif
        return NC_ERANGE;
#else
        err = NC_ERANGE;
#endif
    }

    cp = (uchar *) xp;
    if (*ip & 0x80)
        *cp++ = 0xff;
    else
        *cp++ = 0;
    *cp = (uchar)*ip;

    return err;
}

static int
ncx_put_ushort_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 996
ncx_put_ushort_short(void *xp, const short *ip, void *fillp)
#line 996
{
#line 996
    int err=NC_NOERR;
#line 996
    ix_ushort xx = NC_FILL_USHORT;
#line 996

#line 996
#if IX_USHORT_MAX < SHORT_MAX
#line 996
    if (*ip > IX_USHORT_MAX) {
#line 996
        
#line 996
#ifdef ERANGE_FILL
#line 996
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 996
#endif
#line 996
        err = NC_ERANGE;
#line 996
    }
#line 996
#ifdef ERANGE_FILL
#line 996
    else
#line 996
#endif
#line 996
#endif
#line 996
    if (*ip < 0) {
#line 996
        
#line 996
#ifdef ERANGE_FILL
#line 996
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 996
#endif
#line 996
        err = NC_ERANGE; /* because xp is unsigned */
#line 996
    }
#line 996
#ifdef ERANGE_FILL
#line 996
    else
#line 996
#endif
#line 996
        xx = (ix_ushort)*ip;
#line 996

#line 996
    put_ix_ushort(xp, &xx);
#line 996
    return err;
#line 996
}
#line 996

static int
#line 997
ncx_put_ushort_int(void *xp, const int *ip, void *fillp)
#line 997
{
#line 997
    int err=NC_NOERR;
#line 997
    ix_ushort xx = NC_FILL_USHORT;
#line 997

#line 997
#if IX_USHORT_MAX < INT_MAX
#line 997
    if (*ip > IX_USHORT_MAX) {
#line 997
        
#line 997
#ifdef ERANGE_FILL
#line 997
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 997
#endif
#line 997
        err = NC_ERANGE;
#line 997
    }
#line 997
#ifdef ERANGE_FILL
#line 997
    else
#line 997
#endif
#line 997
#endif
#line 997
    if (*ip < 0) {
#line 997
        
#line 997
#ifdef ERANGE_FILL
#line 997
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 997
#endif
#line 997
        err = NC_ERANGE; /* because xp is unsigned */
#line 997
    }
#line 997
#ifdef ERANGE_FILL
#line 997
    else
#line 997
#endif
#line 997
        xx = (ix_ushort)*ip;
#line 997

#line 997
    put_ix_ushort(xp, &xx);
#line 997
    return err;
#line 997
}
#line 997

static int
#line 998
ncx_put_ushort_long(void *xp, const long *ip, void *fillp)
#line 998
{
#line 998
    int err=NC_NOERR;
#line 998
    ix_ushort xx = NC_FILL_USHORT;
#line 998

#line 998
#if IX_USHORT_MAX < LONG_MAX
#line 998
    if (*ip > IX_USHORT_MAX) {
#line 998
        
#line 998
#ifdef ERANGE_FILL
#line 998
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 998
#endif
#line 998
        err = NC_ERANGE;
#line 998
    }
#line 998
#ifdef ERANGE_FILL
#line 998
    else
#line 998
#endif
#line 998
#endif
#line 998
    if (*ip < 0) {
#line 998
        
#line 998
#ifdef ERANGE_FILL
#line 998
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 998
#endif
#line 998
        err = NC_ERANGE; /* because xp is unsigned */
#line 998
    }
#line 998
#ifdef ERANGE_FILL
#line 998
    else
#line 998
#endif
#line 998
        xx = (ix_ushort)*ip;
#line 998

#line 998
    put_ix_ushort(xp, &xx);
#line 998
    return err;
#line 998
}
#line 998

static int
#line 999
ncx_put_ushort_longlong(void *xp, const longlong *ip, void *fillp)
#line 999
{
#line 999
    int err=NC_NOERR;
#line 999
    ix_ushort xx = NC_FILL_USHORT;
#line 999

#line 999
#if IX_USHORT_MAX < LONGLONG_MAX
#line 999
    if (*ip > IX_USHORT_MAX) {
#line 999
        
#line 999
#ifdef ERANGE_FILL
#line 999
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 999
#endif
#line 999
        err = NC_ERANGE;
#line 999
    }
#line 999
#ifdef ERANGE_FILL
#line 999
    else
#line 999
#endif
#line 999
#endif
#line 999
    if (*ip < 0) {
#line 999
        
#line 999
#ifdef ERANGE_FILL
#line 999
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 999
#endif
#line 999
        err = NC_ERANGE; /* because xp is unsigned */
#line 999
    }
#line 999
#ifdef ERANGE_FILL
#line 999
    else
#line 999
#endif
#line 999
        xx = (ix_ushort)*ip;
#line 999

#line 999
    put_ix_ushort(xp, &xx);
#line 999
    return err;
#line 999
}
#line 999

static int
#line 1000
ncx_put_ushort_ushort(void *xp, const ushort *ip, void *fillp)
#line 1000
{
#line 1000
    int err=NC_NOERR;
#line 1000
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 1000
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1000
#else
#line 1000
    ix_ushort xx = NC_FILL_USHORT;
#line 1000

#line 1000
#if IX_USHORT_MAX < USHORT_MAX
#line 1000
    if (*ip > IX_USHORT_MAX) {
#line 1000
        
#line 1000
#ifdef ERANGE_FILL
#line 1000
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1000
#endif
#line 1000
        err = NC_ERANGE;
#line 1000
    }
#line 1000
#ifdef ERANGE_FILL
#line 1000
    else
#line 1000
#endif
#line 1000
#endif
#line 1000
        xx = (ix_ushort)*ip;
#line 1000

#line 1000
    put_ix_ushort(xp, &xx);
#line 1000
#endif
#line 1000
    return err;
#line 1000
}
#line 1000

static int
#line 1001
ncx_put_ushort_uint(void *xp, const uint *ip, void *fillp)
#line 1001
{
#line 1001
    int err=NC_NOERR;
#line 1001
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 1001
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1001
#else
#line 1001
    ix_ushort xx = NC_FILL_USHORT;
#line 1001

#line 1001
#if IX_USHORT_MAX < UINT_MAX
#line 1001
    if (*ip > IX_USHORT_MAX) {
#line 1001
        
#line 1001
#ifdef ERANGE_FILL
#line 1001
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1001
#endif
#line 1001
        err = NC_ERANGE;
#line 1001
    }
#line 1001
#ifdef ERANGE_FILL
#line 1001
    else
#line 1001
#endif
#line 1001
#endif
#line 1001
        xx = (ix_ushort)*ip;
#line 1001

#line 1001
    put_ix_ushort(xp, &xx);
#line 1001
#endif
#line 1001
    return err;
#line 1001
}
#line 1001

static int
#line 1002
ncx_put_ushort_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1002
{
#line 1002
    int err=NC_NOERR;
#line 1002
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 1002
    put_ix_ushort(xp, (const ix_ushort *)ip);
#line 1002
#else
#line 1002
    ix_ushort xx = NC_FILL_USHORT;
#line 1002

#line 1002
#if IX_USHORT_MAX < ULONGLONG_MAX
#line 1002
    if (*ip > IX_USHORT_MAX) {
#line 1002
        
#line 1002
#ifdef ERANGE_FILL
#line 1002
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1002
#endif
#line 1002
        err = NC_ERANGE;
#line 1002
    }
#line 1002
#ifdef ERANGE_FILL
#line 1002
    else
#line 1002
#endif
#line 1002
#endif
#line 1002
        xx = (ix_ushort)*ip;
#line 1002

#line 1002
    put_ix_ushort(xp, &xx);
#line 1002
#endif
#line 1002
    return err;
#line 1002
}
#line 1002

static int
#line 1003
ncx_put_ushort_float(void *xp, const float *ip, void *fillp)
#line 1003
{
#line 1003
    int err=NC_NOERR;
#line 1003
    ix_ushort xx = NC_FILL_USHORT;
#line 1003

#line 1003
    if (*ip > (double)X_USHORT_MAX || *ip < 0) {
#line 1003
        
#line 1003
#ifdef ERANGE_FILL
#line 1003
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1003
#endif
#line 1003
        err = NC_ERANGE;
#line 1003
    }
#line 1003
#ifdef ERANGE_FILL
#line 1003
    else
#line 1003
#endif
#line 1003
        xx = (ix_ushort)*ip;
#line 1003

#line 1003
    put_ix_ushort(xp, &xx);
#line 1003
    return err;
#line 1003
}
#line 1003

static int
#line 1004
ncx_put_ushort_double(void *xp, const double *ip, void *fillp)
#line 1004
{
#line 1004
    int err=NC_NOERR;
#line 1004
    ix_ushort xx = NC_FILL_USHORT;
#line 1004

#line 1004
    if (*ip > X_USHORT_MAX || *ip < 0) {
#line 1004
        
#line 1004
#ifdef ERANGE_FILL
#line 1004
            if (fillp != NULL) memcpy(&xx, fillp, 2);
#line 1004
#endif
#line 1004
        err = NC_ERANGE;
#line 1004
    }
#line 1004
#ifdef ERANGE_FILL
#line 1004
    else
#line 1004
#endif
#line 1004
        xx = (ix_ushort)*ip;
#line 1004

#line 1004
    put_ix_ushort(xp, &xx);
#line 1004
    return err;
#line 1004
}
#line 1004


/* external NC_INT ----------------------------------------------------------*/

#if SHORT_MAX == X_INT_MAX
typedef short ix_int;
#define SIZEOF_IX_INT SIZEOF_SHORT
#define IX_INT_MAX SHORT_MAX
#elif INT_MAX  >= X_INT_MAX
typedef int ix_int;
#define SIZEOF_IX_INT SIZEOF_INT
#define IX_INT_MAX INT_MAX
#elif LONG_MAX  >= X_INT_MAX
typedef long ix_int;
#define SIZEOF_IX_INT SIZEOF_LONG
#define IX_INT_MAX LONG_MAX
#else
#error "ix_int implementation"
#endif


static void
get_ix_int(const void *xp, ix_int *ip)
{
	const uchar *cp = (const uchar *) xp;

#if INT_MAX  >= X_INT_MAX
	*ip = (ix_int)((unsigned)(*cp++) << 24);
#else
	*ip = *cp++ << 24;
#endif
#if SIZEOF_IX_INT > X_SIZEOF_INT
	if (*ip & 0x80000000)
	{
		/* extern is negative */
		*ip |= (~(0xffffffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= (*cp++ << 16);
	*ip |= (*cp++ << 8);
	*ip |= *cp;
}

static void
put_ix_int(void *xp, const ix_int *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)( (*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 1059
ncx_get_int_int(const void *xp, int *ip)
#line 1059
{
#line 1059
    int err=NC_NOERR;
#line 1059
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 1059
    get_ix_int(xp, (ix_int *)ip);
#line 1059
#else
#line 1059
    ix_int xx;
#line 1059
    get_ix_int(xp, &xx);
#line 1059

#line 1059
#if IX_INT_MAX > INT_MAX
#line 1059
    if (xx > INT_MAX || xx < INT_MIN) {
#line 1059
#ifdef ERANGE_FILL
#line 1059
        *ip = NC_FILL_INT;
#line 1059
        return NC_ERANGE;
#line 1059
#else
#line 1059
        err = NC_ERANGE;
#line 1059
#endif
#line 1059
    }
#line 1059
#endif
#line 1059

#line 1059

#line 1059
    *ip = (int) xx;
#line 1059
#endif
#line 1059
    return err;
#line 1059
}
#line 1059

#endif
static int
#line 1061
ncx_get_int_schar(const void *xp, schar *ip)
#line 1061
{
#line 1061
    int err=NC_NOERR;
#line 1061
    ix_int xx;
#line 1061
    get_ix_int(xp, &xx);
#line 1061

#line 1061
#if IX_INT_MAX > SCHAR_MAX
#line 1061
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 1061
#ifdef ERANGE_FILL
#line 1061
        *ip = NC_FILL_BYTE;
#line 1061
        return NC_ERANGE;
#line 1061
#else
#line 1061
        err = NC_ERANGE;
#line 1061
#endif
#line 1061
    }
#line 1061
#endif
#line 1061

#line 1061

#line 1061
    *ip = (schar) xx;
#line 1061
    return err;
#line 1061
}
#line 1061

static int
#line 1062
ncx_get_int_short(const void *xp, short *ip)
#line 1062
{
#line 1062
    int err=NC_NOERR;
#line 1062
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 1062
    get_ix_int(xp, (ix_int *)ip);
#line 1062
#else
#line 1062
    ix_int xx;
#line 1062
    get_ix_int(xp, &xx);
#line 1062

#line 1062
#if IX_INT_MAX > SHORT_MAX
#line 1062
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 1062
#ifdef ERANGE_FILL
#line 1062
        *ip = NC_FILL_SHORT;
#line 1062
        return NC_ERANGE;
#line 1062
#else
#line 1062
        err = NC_ERANGE;
#line 1062
#endif
#line 1062
    }
#line 1062
#endif
#line 1062

#line 1062

#line 1062
    *ip = (short) xx;
#line 1062
#endif
#line 1062
    return err;
#line 1062
}
#line 1062

static int
#line 1063
ncx_get_int_long(const void *xp, long *ip)
#line 1063
{
#line 1063
    int err=NC_NOERR;
#line 1063
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 1063
    get_ix_int(xp, (ix_int *)ip);
#line 1063
#else
#line 1063
    ix_int xx;
#line 1063
    get_ix_int(xp, &xx);
#line 1063

#line 1063
#if IX_INT_MAX > LONG_MAX
#line 1063
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 1063
#ifdef ERANGE_FILL
#line 1063
        *ip = NC_FILL_INT;
#line 1063
        return NC_ERANGE;
#line 1063
#else
#line 1063
        err = NC_ERANGE;
#line 1063
#endif
#line 1063
    }
#line 1063
#endif
#line 1063

#line 1063

#line 1063
    *ip = (long) xx;
#line 1063
#endif
#line 1063
    return err;
#line 1063
}
#line 1063

static int
#line 1064
ncx_get_int_longlong(const void *xp, longlong *ip)
#line 1064
{
#line 1064
    int err=NC_NOERR;
#line 1064
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 1064
    get_ix_int(xp, (ix_int *)ip);
#line 1064
#else
#line 1064
    ix_int xx;
#line 1064
    get_ix_int(xp, &xx);
#line 1064

#line 1064
#if IX_INT_MAX > LONGLONG_MAX
#line 1064
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 1064
#ifdef ERANGE_FILL
#line 1064
        *ip = NC_FILL_INT64;
#line 1064
        return NC_ERANGE;
#line 1064
#else
#line 1064
        err = NC_ERANGE;
#line 1064
#endif
#line 1064
    }
#line 1064
#endif
#line 1064

#line 1064

#line 1064
    *ip = (longlong) xx;
#line 1064
#endif
#line 1064
    return err;
#line 1064
}
#line 1064

static int
#line 1065
ncx_get_int_ushort(const void *xp, ushort *ip)
#line 1065
{
#line 1065
    int err=NC_NOERR;
#line 1065
    ix_int xx;
#line 1065
    get_ix_int(xp, &xx);
#line 1065

#line 1065
#if IX_INT_MAX > USHORT_MAX
#line 1065
    if (xx > USHORT_MAX) {
#line 1065
#ifdef ERANGE_FILL
#line 1065
        *ip = NC_FILL_USHORT;
#line 1065
        return NC_ERANGE;
#line 1065
#else
#line 1065
        err = NC_ERANGE;
#line 1065
#endif
#line 1065
    }
#line 1065
#endif
#line 1065

#line 1065
    if (xx < 0) {
#line 1065
#ifdef ERANGE_FILL
#line 1065
        *ip = NC_FILL_USHORT;
#line 1065
        return NC_ERANGE;
#line 1065
#else
#line 1065
        err = NC_ERANGE; /* because ip is unsigned */
#line 1065
#endif
#line 1065
    }
#line 1065
    *ip = (ushort) xx;
#line 1065
    return err;
#line 1065
}
#line 1065

static int
#line 1066
ncx_get_int_uchar(const void *xp, uchar *ip)
#line 1066
{
#line 1066
    int err=NC_NOERR;
#line 1066
    ix_int xx;
#line 1066
    get_ix_int(xp, &xx);
#line 1066

#line 1066
#if IX_INT_MAX > UCHAR_MAX
#line 1066
    if (xx > UCHAR_MAX) {
#line 1066
#ifdef ERANGE_FILL
#line 1066
        *ip = NC_FILL_UBYTE;
#line 1066
        return NC_ERANGE;
#line 1066
#else
#line 1066
        err = NC_ERANGE;
#line 1066
#endif
#line 1066
    }
#line 1066
#endif
#line 1066

#line 1066
    if (xx < 0) {
#line 1066
#ifdef ERANGE_FILL
#line 1066
        *ip = NC_FILL_UBYTE;
#line 1066
        return NC_ERANGE;
#line 1066
#else
#line 1066
        err = NC_ERANGE; /* because ip is unsigned */
#line 1066
#endif
#line 1066
    }
#line 1066
    *ip = (uchar) xx;
#line 1066
    return err;
#line 1066
}
#line 1066

static int
#line 1067
ncx_get_int_uint(const void *xp, uint *ip)
#line 1067
{
#line 1067
    int err=NC_NOERR;
#line 1067
    ix_int xx;
#line 1067
    get_ix_int(xp, &xx);
#line 1067

#line 1067
#if IX_INT_MAX > UINT_MAX
#line 1067
    if (xx > UINT_MAX) {
#line 1067
#ifdef ERANGE_FILL
#line 1067
        *ip = NC_FILL_UINT;
#line 1067
        return NC_ERANGE;
#line 1067
#else
#line 1067
        err = NC_ERANGE;
#line 1067
#endif
#line 1067
    }
#line 1067
#endif
#line 1067

#line 1067
    if (xx < 0) {
#line 1067
#ifdef ERANGE_FILL
#line 1067
        *ip = NC_FILL_UINT;
#line 1067
        return NC_ERANGE;
#line 1067
#else
#line 1067
        err = NC_ERANGE; /* because ip is unsigned */
#line 1067
#endif
#line 1067
    }
#line 1067
    *ip = (uint) xx;
#line 1067
    return err;
#line 1067
}
#line 1067

static int
#line 1068
ncx_get_int_ulonglong(const void *xp, ulonglong *ip)
#line 1068
{
#line 1068
    int err=NC_NOERR;
#line 1068
    ix_int xx;
#line 1068
    get_ix_int(xp, &xx);
#line 1068

#line 1068
#if IX_INT_MAX > ULONGLONG_MAX
#line 1068
    if (xx > ULONGLONG_MAX) {
#line 1068
#ifdef ERANGE_FILL
#line 1068
        *ip = NC_FILL_UINT64;
#line 1068
        return NC_ERANGE;
#line 1068
#else
#line 1068
        err = NC_ERANGE;
#line 1068
#endif
#line 1068
    }
#line 1068
#endif
#line 1068

#line 1068
    if (xx < 0) {
#line 1068
#ifdef ERANGE_FILL
#line 1068
        *ip = NC_FILL_UINT64;
#line 1068
        return NC_ERANGE;
#line 1068
#else
#line 1068
        err = NC_ERANGE; /* because ip is unsigned */
#line 1068
#endif
#line 1068
    }
#line 1068
    *ip = (ulonglong) xx;
#line 1068
    return err;
#line 1068
}
#line 1068

static int
#line 1069
ncx_get_int_float(const void *xp, float *ip)
#line 1069
{
#line 1069
	ix_int xx;
#line 1069
	get_ix_int(xp, &xx);
#line 1069
	*ip = (float)xx;
#line 1069
	return NC_NOERR;
#line 1069
}
#line 1069

static int
#line 1070
ncx_get_int_double(const void *xp, double *ip)
#line 1070
{
#line 1070
	ix_int xx;
#line 1070
	get_ix_int(xp, &xx);
#line 1070
	*ip = (double)xx;
#line 1070
	return NC_NOERR;
#line 1070
}
#line 1070


static int
ncx_put_int_schar(void *xp, const schar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	if (*ip & 0x80)
	{
		*cp++ = 0xff;
		*cp++ = 0xff;
		*cp++ = 0xff;
	}
	else
	{
		*cp++ = 0x00;
		*cp++ = 0x00;
		*cp++ = 0x00;
	}
	*cp = (uchar)*ip;
	return NC_NOERR;
}

static int
ncx_put_int_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_INT != SIZEOF_INT
static int
#line 1104
ncx_put_int_int(void *xp, const int *ip, void *fillp)
#line 1104
{
#line 1104
    int err=NC_NOERR;
#line 1104
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 1104
    put_ix_int(xp, (const ix_int *)ip);
#line 1104
#else
#line 1104
    ix_int xx = NC_FILL_INT;
#line 1104

#line 1104
#if IX_INT_MAX < INT_MAX
#line 1104
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1104
        
#line 1104
#ifdef ERANGE_FILL
#line 1104
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1104
#endif
#line 1104
        err = NC_ERANGE;
#line 1104
    }
#line 1104
#ifdef ERANGE_FILL
#line 1104
    else
#line 1104
#endif
#line 1104
#endif
#line 1104
        xx = (ix_int)*ip;
#line 1104

#line 1104
    put_ix_int(xp, &xx);
#line 1104
#endif
#line 1104
    return err;
#line 1104
}
#line 1104

#endif
static int
#line 1106
ncx_put_int_short(void *xp, const short *ip, void *fillp)
#line 1106
{
#line 1106
    int err=NC_NOERR;
#line 1106
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 1106
    put_ix_int(xp, (const ix_int *)ip);
#line 1106
#else
#line 1106
    ix_int xx = NC_FILL_INT;
#line 1106

#line 1106
#if IX_INT_MAX < SHORT_MAX
#line 1106
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1106
        
#line 1106
#ifdef ERANGE_FILL
#line 1106
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1106
#endif
#line 1106
        err = NC_ERANGE;
#line 1106
    }
#line 1106
#ifdef ERANGE_FILL
#line 1106
    else
#line 1106
#endif
#line 1106
#endif
#line 1106
        xx = (ix_int)*ip;
#line 1106

#line 1106
    put_ix_int(xp, &xx);
#line 1106
#endif
#line 1106
    return err;
#line 1106
}
#line 1106

static int
#line 1107
ncx_put_int_long(void *xp, const long *ip, void *fillp)
#line 1107
{
#line 1107
    int err=NC_NOERR;
#line 1107
#if SIZEOF_IX_INT == SIZEOF_LONG && IX_INT_MAX == LONG_MAX
#line 1107
    put_ix_int(xp, (const ix_int *)ip);
#line 1107
#else
#line 1107
    ix_int xx = NC_FILL_INT;
#line 1107

#line 1107
#if IX_INT_MAX < LONG_MAX
#line 1107
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1107
        
#line 1107
#ifdef ERANGE_FILL
#line 1107
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1107
#endif
#line 1107
        err = NC_ERANGE;
#line 1107
    }
#line 1107
#ifdef ERANGE_FILL
#line 1107
    else
#line 1107
#endif
#line 1107
#endif
#line 1107
        xx = (ix_int)*ip;
#line 1107

#line 1107
    put_ix_int(xp, &xx);
#line 1107
#endif
#line 1107
    return err;
#line 1107
}
#line 1107

static int
#line 1108
ncx_put_int_longlong(void *xp, const longlong *ip, void *fillp)
#line 1108
{
#line 1108
    int err=NC_NOERR;
#line 1108
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 1108
    put_ix_int(xp, (const ix_int *)ip);
#line 1108
#else
#line 1108
    ix_int xx = NC_FILL_INT;
#line 1108

#line 1108
#if IX_INT_MAX < LONGLONG_MAX
#line 1108
    if (*ip > IX_INT_MAX || *ip < X_INT_MIN) {
#line 1108
        
#line 1108
#ifdef ERANGE_FILL
#line 1108
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1108
#endif
#line 1108
        err = NC_ERANGE;
#line 1108
    }
#line 1108
#ifdef ERANGE_FILL
#line 1108
    else
#line 1108
#endif
#line 1108
#endif
#line 1108
        xx = (ix_int)*ip;
#line 1108

#line 1108
    put_ix_int(xp, &xx);
#line 1108
#endif
#line 1108
    return err;
#line 1108
}
#line 1108

static int
#line 1109
ncx_put_int_ushort(void *xp, const ushort *ip, void *fillp)
#line 1109
{
#line 1109
    int err=NC_NOERR;
#line 1109
    ix_int xx = NC_FILL_INT;
#line 1109

#line 1109
#if IX_INT_MAX < USHORT_MAX
#line 1109
    if (*ip > IX_INT_MAX) {
#line 1109
        
#line 1109
#ifdef ERANGE_FILL
#line 1109
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1109
#endif
#line 1109
        err = NC_ERANGE;
#line 1109
    }
#line 1109
#ifdef ERANGE_FILL
#line 1109
    else
#line 1109
#endif
#line 1109
#endif
#line 1109
        xx = (ix_int)*ip;
#line 1109

#line 1109
    put_ix_int(xp, &xx);
#line 1109
    return err;
#line 1109
}
#line 1109

static int
#line 1110
ncx_put_int_uint(void *xp, const uint *ip, void *fillp)
#line 1110
{
#line 1110
    int err=NC_NOERR;
#line 1110
    ix_int xx = NC_FILL_INT;
#line 1110

#line 1110
#if IX_INT_MAX < UINT_MAX
#line 1110
    if (*ip > IX_INT_MAX) {
#line 1110
        
#line 1110
#ifdef ERANGE_FILL
#line 1110
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1110
#endif
#line 1110
        err = NC_ERANGE;
#line 1110
    }
#line 1110
#ifdef ERANGE_FILL
#line 1110
    else
#line 1110
#endif
#line 1110
#endif
#line 1110
        xx = (ix_int)*ip;
#line 1110

#line 1110
    put_ix_int(xp, &xx);
#line 1110
    return err;
#line 1110
}
#line 1110

static int
#line 1111
ncx_put_int_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1111
{
#line 1111
    int err=NC_NOERR;
#line 1111
    ix_int xx = NC_FILL_INT;
#line 1111

#line 1111
#if IX_INT_MAX < ULONGLONG_MAX
#line 1111
    if (*ip > IX_INT_MAX) {
#line 1111
        
#line 1111
#ifdef ERANGE_FILL
#line 1111
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1111
#endif
#line 1111
        err = NC_ERANGE;
#line 1111
    }
#line 1111
#ifdef ERANGE_FILL
#line 1111
    else
#line 1111
#endif
#line 1111
#endif
#line 1111
        xx = (ix_int)*ip;
#line 1111

#line 1111
    put_ix_int(xp, &xx);
#line 1111
    return err;
#line 1111
}
#line 1111

static int
#line 1112
ncx_put_int_float(void *xp, const float *ip, void *fillp)
#line 1112
{
#line 1112
    int err=NC_NOERR;
#line 1112
    ix_int xx = NC_FILL_INT;
#line 1112

#line 1112
    if (*ip > (double)X_INT_MAX || *ip < (double)X_INT_MIN) {
#line 1112
        
#line 1112
#ifdef ERANGE_FILL
#line 1112
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1112
#endif
#line 1112
        err = NC_ERANGE;
#line 1112
    }
#line 1112
#ifdef ERANGE_FILL
#line 1112
    else
#line 1112
#endif
#line 1112
        xx = (ix_int)*ip;
#line 1112

#line 1112
    put_ix_int(xp, &xx);
#line 1112
    return err;
#line 1112
}
#line 1112

static int
#line 1113
ncx_put_int_double(void *xp, const double *ip, void *fillp)
#line 1113
{
#line 1113
    int err=NC_NOERR;
#line 1113
    ix_int xx = NC_FILL_INT;
#line 1113

#line 1113
    if (*ip > X_INT_MAX || *ip < X_INT_MIN) {
#line 1113
        
#line 1113
#ifdef ERANGE_FILL
#line 1113
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1113
#endif
#line 1113
        err = NC_ERANGE;
#line 1113
    }
#line 1113
#ifdef ERANGE_FILL
#line 1113
    else
#line 1113
#endif
#line 1113
        xx = (ix_int)*ip;
#line 1113

#line 1113
    put_ix_int(xp, &xx);
#line 1113
    return err;
#line 1113
}
#line 1113



/* external NC_UINT ---------------------------------------------------------*/

#if USHORT_MAX == X_UINT_MAX
typedef ushort ix_uint;
#define SIZEOF_IX_UINT SIZEOF_USHORT
#define IX_UINT_MAX USHORT_MAX
#elif UINT_MAX  >= X_UINT_MAX
typedef uint ix_uint;
#define SIZEOF_IX_UINT SIZEOF_UINT
#define IX_UINT_MAX UINT_MAX
#elif ULONG_MAX  >= X_UINT_MAX
typedef ulong ix_uint;
#define SIZEOF_IX_UINT SIZEOF_ULONG
#define IX_UINT_MAX ULONG_MAX
#else
#error "ix_uint implementation"
#endif


static void
get_ix_uint(const void *xp, ix_uint *ip)
{
	const uchar *cp = (const uchar *) xp;

	*ip = (ix_uint)(*cp++ << 24);
	*ip = (ix_uint)(*ip | (ix_uint)(*cp++ << 16));
	*ip = (ix_uint)(*ip | (ix_uint)(*cp++ << 8));
	*ip = (ix_uint)(*ip | *cp);
}

static void
put_ix_uint(void *xp, const ix_uint *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (uchar)((*ip) >> 24);
	*cp++ = (uchar)(((*ip) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ip) & 0x0000ff00) >>  8);
	*cp   = (uchar)( (*ip) & 0x000000ff);
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 1158
ncx_get_uint_uint(const void *xp, uint *ip)
#line 1158
{
#line 1158
    int err=NC_NOERR;
#line 1158
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 1158
    get_ix_uint(xp, (ix_uint *)ip);
#line 1158
#else
#line 1158
    ix_uint xx;
#line 1158
    get_ix_uint(xp, &xx);
#line 1158

#line 1158
#if IX_UINT_MAX > UINT_MAX
#line 1158
    if (xx > UINT_MAX) {
#line 1158
#ifdef ERANGE_FILL
#line 1158
        *ip = NC_FILL_UINT;
#line 1158
        return NC_ERANGE;
#line 1158
#else
#line 1158
        err = NC_ERANGE;
#line 1158
#endif
#line 1158
    }
#line 1158
#endif
#line 1158

#line 1158

#line 1158
    *ip = (uint) xx;
#line 1158
#endif
#line 1158
    return err;
#line 1158
}
#line 1158

#endif

static int
#line 1161
ncx_get_uint_schar(const void *xp, schar *ip)
#line 1161
{
#line 1161
    int err=NC_NOERR;
#line 1161
    ix_uint xx;
#line 1161
    get_ix_uint(xp, &xx);
#line 1161

#line 1161
#if IX_UINT_MAX > SCHAR_MAX
#line 1161
    if (xx > SCHAR_MAX) {
#line 1161
#ifdef ERANGE_FILL
#line 1161
        *ip = NC_FILL_BYTE;
#line 1161
        return NC_ERANGE;
#line 1161
#else
#line 1161
        err = NC_ERANGE;
#line 1161
#endif
#line 1161
    }
#line 1161
#endif
#line 1161

#line 1161

#line 1161
    *ip = (schar) xx;
#line 1161
    return err;
#line 1161
}
#line 1161

static int
#line 1162
ncx_get_uint_short(const void *xp, short *ip)
#line 1162
{
#line 1162
    int err=NC_NOERR;
#line 1162
    ix_uint xx;
#line 1162
    get_ix_uint(xp, &xx);
#line 1162

#line 1162
#if IX_UINT_MAX > SHORT_MAX
#line 1162
    if (xx > SHORT_MAX) {
#line 1162
#ifdef ERANGE_FILL
#line 1162
        *ip = NC_FILL_SHORT;
#line 1162
        return NC_ERANGE;
#line 1162
#else
#line 1162
        err = NC_ERANGE;
#line 1162
#endif
#line 1162
    }
#line 1162
#endif
#line 1162

#line 1162

#line 1162
    *ip = (short) xx;
#line 1162
    return err;
#line 1162
}
#line 1162

static int
#line 1163
ncx_get_uint_int(const void *xp, int *ip)
#line 1163
{
#line 1163
    int err=NC_NOERR;
#line 1163
    ix_uint xx;
#line 1163
    get_ix_uint(xp, &xx);
#line 1163

#line 1163
#if IX_UINT_MAX > INT_MAX
#line 1163
    if (xx > INT_MAX) {
#line 1163
#ifdef ERANGE_FILL
#line 1163
        *ip = NC_FILL_INT;
#line 1163
        return NC_ERANGE;
#line 1163
#else
#line 1163
        err = NC_ERANGE;
#line 1163
#endif
#line 1163
    }
#line 1163
#endif
#line 1163

#line 1163

#line 1163
    *ip = (int) xx;
#line 1163
    return err;
#line 1163
}
#line 1163

static int
#line 1164
ncx_get_uint_long(const void *xp, long *ip)
#line 1164
{
#line 1164
    int err=NC_NOERR;
#line 1164
    ix_uint xx;
#line 1164
    get_ix_uint(xp, &xx);
#line 1164

#line 1164
#if IX_UINT_MAX > LONG_MAX
#line 1164
    if (xx > LONG_MAX) {
#line 1164
#ifdef ERANGE_FILL
#line 1164
        *ip = NC_FILL_INT;
#line 1164
        return NC_ERANGE;
#line 1164
#else
#line 1164
        err = NC_ERANGE;
#line 1164
#endif
#line 1164
    }
#line 1164
#endif
#line 1164

#line 1164

#line 1164
    *ip = (long) xx;
#line 1164
    return err;
#line 1164
}
#line 1164

static int
#line 1165
ncx_get_uint_longlong(const void *xp, longlong *ip)
#line 1165
{
#line 1165
    int err=NC_NOERR;
#line 1165
    ix_uint xx;
#line 1165
    get_ix_uint(xp, &xx);
#line 1165

#line 1165
#if IX_UINT_MAX > LONGLONG_MAX
#line 1165
    if (xx > LONGLONG_MAX) {
#line 1165
#ifdef ERANGE_FILL
#line 1165
        *ip = NC_FILL_INT64;
#line 1165
        return NC_ERANGE;
#line 1165
#else
#line 1165
        err = NC_ERANGE;
#line 1165
#endif
#line 1165
    }
#line 1165
#endif
#line 1165

#line 1165

#line 1165
    *ip = (longlong) xx;
#line 1165
    return err;
#line 1165
}
#line 1165

static int
#line 1166
ncx_get_uint_ushort(const void *xp, ushort *ip)
#line 1166
{
#line 1166
    int err=NC_NOERR;
#line 1166
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 1166
    get_ix_uint(xp, (ix_uint *)ip);
#line 1166
#else
#line 1166
    ix_uint xx;
#line 1166
    get_ix_uint(xp, &xx);
#line 1166

#line 1166
#if IX_UINT_MAX > USHORT_MAX
#line 1166
    if (xx > USHORT_MAX) {
#line 1166
#ifdef ERANGE_FILL
#line 1166
        *ip = NC_FILL_USHORT;
#line 1166
        return NC_ERANGE;
#line 1166
#else
#line 1166
        err = NC_ERANGE;
#line 1166
#endif
#line 1166
    }
#line 1166
#endif
#line 1166

#line 1166

#line 1166
    *ip = (ushort) xx;
#line 1166
#endif
#line 1166
    return err;
#line 1166
}
#line 1166

static int
#line 1167
ncx_get_uint_uchar(const void *xp, uchar *ip)
#line 1167
{
#line 1167
    int err=NC_NOERR;
#line 1167
#if SIZEOF_IX_UINT == SIZEOF_UCHAR && IX_UINT_MAX == UCHAR_MAX
#line 1167
    get_ix_uint(xp, (ix_uint *)ip);
#line 1167
#else
#line 1167
    ix_uint xx;
#line 1167
    get_ix_uint(xp, &xx);
#line 1167

#line 1167
#if IX_UINT_MAX > UCHAR_MAX
#line 1167
    if (xx > UCHAR_MAX) {
#line 1167
#ifdef ERANGE_FILL
#line 1167
        *ip = NC_FILL_UBYTE;
#line 1167
        return NC_ERANGE;
#line 1167
#else
#line 1167
        err = NC_ERANGE;
#line 1167
#endif
#line 1167
    }
#line 1167
#endif
#line 1167

#line 1167

#line 1167
    *ip = (uchar) xx;
#line 1167
#endif
#line 1167
    return err;
#line 1167
}
#line 1167

static int
#line 1168
ncx_get_uint_ulonglong(const void *xp, ulonglong *ip)
#line 1168
{
#line 1168
    int err=NC_NOERR;
#line 1168
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 1168
    get_ix_uint(xp, (ix_uint *)ip);
#line 1168
#else
#line 1168
    ix_uint xx;
#line 1168
    get_ix_uint(xp, &xx);
#line 1168

#line 1168
#if IX_UINT_MAX > ULONGLONG_MAX
#line 1168
    if (xx > ULONGLONG_MAX) {
#line 1168
#ifdef ERANGE_FILL
#line 1168
        *ip = NC_FILL_UINT64;
#line 1168
        return NC_ERANGE;
#line 1168
#else
#line 1168
        err = NC_ERANGE;
#line 1168
#endif
#line 1168
    }
#line 1168
#endif
#line 1168

#line 1168

#line 1168
    *ip = (ulonglong) xx;
#line 1168
#endif
#line 1168
    return err;
#line 1168
}
#line 1168

static int
#line 1169
ncx_get_uint_float(const void *xp, float *ip)
#line 1169
{
#line 1169
	ix_uint xx;
#line 1169
	get_ix_uint(xp, &xx);
#line 1169
	*ip = (float)xx;
#line 1169
	return NC_NOERR;
#line 1169
}
#line 1169

static int
#line 1170
ncx_get_uint_double(const void *xp, double *ip)
#line 1170
{
#line 1170
	ix_uint xx;
#line 1170
	get_ix_uint(xp, &xx);
#line 1170
	*ip = (double)xx;
#line 1170
	return NC_NOERR;
#line 1170
}
#line 1170


static int
ncx_put_uint_schar(void *xp, const schar *ip, void *fillp)
{
    uchar *cp;
    if (*ip < 0) {
#ifdef ERANGE_FILL
        if (fillp != NULL) memcpy(xp, fillp, 4);
#ifndef WORDS_BIGENDIAN
        swapn4b(xp, xp, 1);
#endif
#endif
        return NC_ERANGE;
    }

    cp = (uchar *) xp;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp++ = 0x00;
    *cp = (uchar)*ip;

    return NC_NOERR;
}

static int
ncx_put_uint_uchar(void *xp, const uchar *ip, void *fillp)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 1207
ncx_put_uint_uint(void *xp, const uint *ip, void *fillp)
#line 1207
{
#line 1207
    int err=NC_NOERR;
#line 1207
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 1207
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1207
#else
#line 1207
    ix_uint xx = NC_FILL_UINT;
#line 1207

#line 1207
#if IX_UINT_MAX < UINT_MAX
#line 1207
    if (*ip > IX_UINT_MAX) {
#line 1207
        
#line 1207
#ifdef ERANGE_FILL
#line 1207
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1207
#endif
#line 1207
        err = NC_ERANGE;
#line 1207
    }
#line 1207
#ifdef ERANGE_FILL
#line 1207
    else
#line 1207
#endif
#line 1207
#endif
#line 1207
        xx = (ix_uint)*ip;
#line 1207

#line 1207
    put_ix_uint(xp, &xx);
#line 1207
#endif
#line 1207
    return err;
#line 1207
}
#line 1207

#endif

static int
#line 1210
ncx_put_uint_short(void *xp, const short *ip, void *fillp)
#line 1210
{
#line 1210
    int err=NC_NOERR;
#line 1210
    ix_uint xx = NC_FILL_UINT;
#line 1210

#line 1210
#if IX_UINT_MAX < SHORT_MAX
#line 1210
    if (*ip > IX_UINT_MAX) {
#line 1210
        
#line 1210
#ifdef ERANGE_FILL
#line 1210
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1210
#endif
#line 1210
        err = NC_ERANGE;
#line 1210
    }
#line 1210
#ifdef ERANGE_FILL
#line 1210
    else
#line 1210
#endif
#line 1210
#endif
#line 1210
    if (*ip < 0) {
#line 1210
        
#line 1210
#ifdef ERANGE_FILL
#line 1210
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1210
#endif
#line 1210
        err = NC_ERANGE; /* because xp is unsigned */
#line 1210
    }
#line 1210
#ifdef ERANGE_FILL
#line 1210
    else
#line 1210
#endif
#line 1210
        xx = (ix_uint)*ip;
#line 1210

#line 1210
    put_ix_uint(xp, &xx);
#line 1210
    return err;
#line 1210
}
#line 1210

static int
#line 1211
ncx_put_uint_int(void *xp, const int *ip, void *fillp)
#line 1211
{
#line 1211
    int err=NC_NOERR;
#line 1211
    ix_uint xx = NC_FILL_UINT;
#line 1211

#line 1211
#if IX_UINT_MAX < INT_MAX
#line 1211
    if (*ip > IX_UINT_MAX) {
#line 1211
        
#line 1211
#ifdef ERANGE_FILL
#line 1211
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1211
#endif
#line 1211
        err = NC_ERANGE;
#line 1211
    }
#line 1211
#ifdef ERANGE_FILL
#line 1211
    else
#line 1211
#endif
#line 1211
#endif
#line 1211
    if (*ip < 0) {
#line 1211
        
#line 1211
#ifdef ERANGE_FILL
#line 1211
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1211
#endif
#line 1211
        err = NC_ERANGE; /* because xp is unsigned */
#line 1211
    }
#line 1211
#ifdef ERANGE_FILL
#line 1211
    else
#line 1211
#endif
#line 1211
        xx = (ix_uint)*ip;
#line 1211

#line 1211
    put_ix_uint(xp, &xx);
#line 1211
    return err;
#line 1211
}
#line 1211

static int
#line 1212
ncx_put_uint_long(void *xp, const long *ip, void *fillp)
#line 1212
{
#line 1212
    int err=NC_NOERR;
#line 1212
    ix_uint xx = NC_FILL_UINT;
#line 1212

#line 1212
#if IX_UINT_MAX < LONG_MAX
#line 1212
    if (*ip > IX_UINT_MAX) {
#line 1212
        
#line 1212
#ifdef ERANGE_FILL
#line 1212
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1212
#endif
#line 1212
        err = NC_ERANGE;
#line 1212
    }
#line 1212
#ifdef ERANGE_FILL
#line 1212
    else
#line 1212
#endif
#line 1212
#endif
#line 1212
    if (*ip < 0) {
#line 1212
        
#line 1212
#ifdef ERANGE_FILL
#line 1212
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1212
#endif
#line 1212
        err = NC_ERANGE; /* because xp is unsigned */
#line 1212
    }
#line 1212
#ifdef ERANGE_FILL
#line 1212
    else
#line 1212
#endif
#line 1212
        xx = (ix_uint)*ip;
#line 1212

#line 1212
    put_ix_uint(xp, &xx);
#line 1212
    return err;
#line 1212
}
#line 1212

static int
#line 1213
ncx_put_uint_longlong(void *xp, const longlong *ip, void *fillp)
#line 1213
{
#line 1213
    int err=NC_NOERR;
#line 1213
    ix_uint xx = NC_FILL_UINT;
#line 1213

#line 1213
#if IX_UINT_MAX < LONGLONG_MAX
#line 1213
    if (*ip > IX_UINT_MAX) {
#line 1213
        
#line 1213
#ifdef ERANGE_FILL
#line 1213
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1213
#endif
#line 1213
        err = NC_ERANGE;
#line 1213
    }
#line 1213
#ifdef ERANGE_FILL
#line 1213
    else
#line 1213
#endif
#line 1213
#endif
#line 1213
    if (*ip < 0) {
#line 1213
        
#line 1213
#ifdef ERANGE_FILL
#line 1213
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1213
#endif
#line 1213
        err = NC_ERANGE; /* because xp is unsigned */
#line 1213
    }
#line 1213
#ifdef ERANGE_FILL
#line 1213
    else
#line 1213
#endif
#line 1213
        xx = (ix_uint)*ip;
#line 1213

#line 1213
    put_ix_uint(xp, &xx);
#line 1213
    return err;
#line 1213
}
#line 1213

static int
#line 1214
ncx_put_uint_ushort(void *xp, const ushort *ip, void *fillp)
#line 1214
{
#line 1214
    int err=NC_NOERR;
#line 1214
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 1214
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1214
#else
#line 1214
    ix_uint xx = NC_FILL_UINT;
#line 1214

#line 1214
#if IX_UINT_MAX < USHORT_MAX
#line 1214
    if (*ip > IX_UINT_MAX) {
#line 1214
        
#line 1214
#ifdef ERANGE_FILL
#line 1214
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1214
#endif
#line 1214
        err = NC_ERANGE;
#line 1214
    }
#line 1214
#ifdef ERANGE_FILL
#line 1214
    else
#line 1214
#endif
#line 1214
#endif
#line 1214
        xx = (ix_uint)*ip;
#line 1214

#line 1214
    put_ix_uint(xp, &xx);
#line 1214
#endif
#line 1214
    return err;
#line 1214
}
#line 1214

static int
#line 1215
ncx_put_uint_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1215
{
#line 1215
    int err=NC_NOERR;
#line 1215
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 1215
    put_ix_uint(xp, (const ix_uint *)ip);
#line 1215
#else
#line 1215
    ix_uint xx = NC_FILL_UINT;
#line 1215

#line 1215
#if IX_UINT_MAX < ULONGLONG_MAX
#line 1215
    if (*ip > IX_UINT_MAX) {
#line 1215
        
#line 1215
#ifdef ERANGE_FILL
#line 1215
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1215
#endif
#line 1215
        err = NC_ERANGE;
#line 1215
    }
#line 1215
#ifdef ERANGE_FILL
#line 1215
    else
#line 1215
#endif
#line 1215
#endif
#line 1215
        xx = (ix_uint)*ip;
#line 1215

#line 1215
    put_ix_uint(xp, &xx);
#line 1215
#endif
#line 1215
    return err;
#line 1215
}
#line 1215

static int
#line 1216
ncx_put_uint_float(void *xp, const float *ip, void *fillp)
#line 1216
{
#line 1216
    int err=NC_NOERR;
#line 1216
    ix_uint xx = NC_FILL_UINT;
#line 1216

#line 1216
    if (*ip > (double)X_UINT_MAX || *ip < 0) {
#line 1216
        
#line 1216
#ifdef ERANGE_FILL
#line 1216
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1216
#endif
#line 1216
        err = NC_ERANGE;
#line 1216
    }
#line 1216
#ifdef ERANGE_FILL
#line 1216
    else
#line 1216
#endif
#line 1216
        xx = (ix_uint)*ip;
#line 1216

#line 1216
    put_ix_uint(xp, &xx);
#line 1216
    return err;
#line 1216
}
#line 1216

static int
#line 1217
ncx_put_uint_double(void *xp, const double *ip, void *fillp)
#line 1217
{
#line 1217
    int err=NC_NOERR;
#line 1217
    ix_uint xx = NC_FILL_UINT;
#line 1217

#line 1217
    if (*ip > X_UINT_MAX || *ip < 0) {
#line 1217
        
#line 1217
#ifdef ERANGE_FILL
#line 1217
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1217
#endif
#line 1217
        err = NC_ERANGE;
#line 1217
    }
#line 1217
#ifdef ERANGE_FILL
#line 1217
    else
#line 1217
#endif
#line 1217
        xx = (ix_uint)*ip;
#line 1217

#line 1217
    put_ix_uint(xp, &xx);
#line 1217
    return err;
#line 1217
}
#line 1217



/* external NC_FLOAT --------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)

inline static void
get_ix_float(const void *xp, float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_FLOAT);
#else
	swap4b(ip, xp);
#endif
}

inline static void
put_ix_float(void *xp, const float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_FLOAT);
#else
	swap4b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE single precision floating point looks like on a Vax */
struct	ieee_single {
	unsigned int	exp_hi       : 7;
	unsigned int	sign         : 1;
	unsigned int 	mant_hi      : 7;
	unsigned int	exp_lo       : 1;
	unsigned int	mant_lo_hi   : 8;
	unsigned int	mant_lo_lo   : 8;
};

/* Vax single precision floating point */
struct	vax_single {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
};

#define VAX_SNG_BIAS	0x81
#define IEEE_SNG_BIAS	0x7f

static struct sgl_limits {
	struct vax_single s;
	struct ieee_single ieee;
} max = {
	{ 0x7f, 0xff, 0x0, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0x1, 0x0, 0x0 }		/* Max IEEE */
};
static struct sgl_limits min = {
	{ 0x0, 0x0, 0x0, 0x0 },	/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 }		/* Min IEEE */
};

#line 1331
static void
get_ix_float(const void *xp, float *ip)
{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 1334
		const struct ieee_single *const isp =
#line 1334
			 (const struct ieee_single *) xp;
#line 1334
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 1334

#line 1334
		switch(exp) {
#line 1334
		case 0 :
#line 1334
			/* ieee subnormal */
#line 1334
			if (isp->mant_hi == min.ieee.mant_hi
#line 1334
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 1334
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 1334
			{
#line 1334
				*vsp = min.s;
#line 1334
			}
#line 1334
			else
#line 1334
			{
#line 1334
				unsigned mantissa = (isp->mant_hi << 16)
#line 1334
					 | isp->mant_lo_hi << 8
#line 1334
					 | isp->mant_lo_lo;
#line 1334
				unsigned tmp = mantissa >> 20;
#line 1334
				if (tmp >= 4) {
#line 1334
					vsp->exp = 2;
#line 1334
				} else if (tmp >= 2) {
#line 1334
					vsp->exp = 1;
#line 1334
				} else {
#line 1334
					*vsp = min.s;
#line 1334
					break;
#line 1334
				} /* else */
#line 1334
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 1334
				tmp <<= 3 - vsp->exp;
#line 1334
				vsp->mantissa2 = tmp;
#line 1334
				vsp->mantissa1 = (tmp >> 16);
#line 1334
			}
#line 1334
			break;
#line 1334
		case 0xfe :
#line 1334
		case 0xff :
#line 1334
			*vsp = max.s;
#line 1334
			break;
#line 1334
		default :
#line 1334
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 1334
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 1334
			vsp->mantissa1 = isp->mant_hi;
#line 1334
		}
#line 1334

#line 1334
		vsp->sign = isp->sign;
#line 1334

}

#line 1388

static void
put_ix_float(void *xp, const float *ip)
{
		const struct vax_single *const vsp =
#line 1392
			 (const struct vax_single *)ip;
#line 1392
		struct ieee_single *const isp = (struct ieee_single *) xp;
#line 1392

#line 1392
		switch(vsp->exp){
#line 1392
		case 0 :
#line 1392
			/* all vax float with zero exponent map to zero */
#line 1392
			*isp = min.ieee;
#line 1392
			break;
#line 1392
		case 2 :
#line 1392
		case 1 :
#line 1392
		{
#line 1392
			/* These will map to subnormals */
#line 1392
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 1392
					 | vsp->mantissa2;
#line 1392
			mantissa >>= 3 - vsp->exp;
#line 1392
			mantissa += (1 << (20 + vsp->exp));
#line 1392
			isp->mant_lo_lo = mantissa;
#line 1392
			isp->mant_lo_hi = mantissa >> 8;
#line 1392
			isp->mant_hi = mantissa >> 16;
#line 1392
			isp->exp_lo = 0;
#line 1392
			isp->exp_hi = 0;
#line 1392
		}
#line 1392
			break;
#line 1392
		case 0xff : /* max.s.exp */
#line 1392
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 1392
			    vsp->mantissa1 == max.s.mantissa1)
#line 1392
			{
#line 1392
				/* map largest vax float to ieee infinity */
#line 1392
				*isp = max.ieee;
#line 1392
				break;
#line 1392
			} /* else, fall thru */
#line 1392
		default :
#line 1392
		{
#line 1392
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 1392
			isp->exp_hi = exp >> 1;
#line 1392
			isp->exp_lo = exp;
#line 1392
			isp->mant_lo_lo = vsp->mantissa2;
#line 1392
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 1392
			isp->mant_hi = vsp->mantissa1;
#line 1392
		}
#line 1392
		}
#line 1392

#line 1392
		isp->sign = vsp->sign;
#line 1392

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

/*
 * Return the number of bytes until the next "word" boundary
 * N.B. This is based on the very weird YMP address structure,
 * which puts the address within a word in the leftmost 3 bits
 * of the address.
 */
static size_t
word_align(const void *vp)
{
	const size_t rem = ((size_t)vp >> (64 - 3)) & 0x7;
	return (rem != 0);
}

struct ieee_single_hi {
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
	unsigned int	pad	:32;
};
typedef struct ieee_single_hi ieee_single_hi;

struct ieee_single_lo {
	unsigned int	pad	:32;
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
};
typedef struct ieee_single_lo ieee_single_lo;

static const int ieee_single_bias = 0x7f;

struct ieee_double {
	unsigned int	sign	: 1;
	unsigned int	 exp	:11;
	unsigned int	mant	:52;
};
typedef struct ieee_double ieee_double;

static const int ieee_double_bias = 0x3ff;

#if defined(NO_IEEE_FLOAT)

struct cray_single {
	unsigned int	sign	: 1;
	unsigned int	 exp	:15;
	unsigned int	mant	:48;
};
typedef struct cray_single cray_single;

static const int cs_ieis_bias = 0x4000 - 0x7f;

static const int cs_id_bias = 0x4000 - 0x3ff;

#line 1527

static void
get_ix_float(const void *xp, float *ip)
{

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1535

#line 1535
		if (isp->exp == 0)
#line 1535
		{
#line 1535
			/* ieee subnormal */
#line 1535
			*ip = (double)isp->mant;
#line 1535
			if (isp->mant != 0)
#line 1535
			{
#line 1535
				csp->exp -= (ieee_single_bias + 22);
#line 1535
			}
#line 1535
		}
#line 1535
		else
#line 1535
		{
#line 1535
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1535
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1535
			csp->mant |= (1 << (48 - 1));
#line 1535
		}
#line 1535
		csp->sign = isp->sign;
#line 1535

#line 1535

	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1540

#line 1540
		if (isp->exp == 0)
#line 1540
		{
#line 1540
			/* ieee subnormal */
#line 1540
			*ip = (double)isp->mant;
#line 1540
			if (isp->mant != 0)
#line 1540
			{
#line 1540
				csp->exp -= (ieee_single_bias + 22);
#line 1540
			}
#line 1540
		}
#line 1540
		else
#line 1540
		{
#line 1540
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1540
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1540
			csp->mant |= (1 << (48 - 1));
#line 1540
		}
#line 1540
		csp->sign = isp->sign;
#line 1540

#line 1540

	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1550
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1550

#line 1550
	isp->sign = csp->sign;
#line 1550

#line 1550
	if (ieee_exp >= 0xff)
#line 1550
	{
#line 1550
		/* NC_ERANGE => ieee Inf */
#line 1550
		isp->exp = 0xff;
#line 1550
		isp->mant = 0x0;
#line 1550
	}
#line 1550
	else if (ieee_exp > 0)
#line 1550
	{
#line 1550
		/* normal ieee representation */
#line 1550
		isp->exp  = ieee_exp;
#line 1550
		/* assumes cray rep is in normal form */
#line 1550
		assert(csp->mant & 0x800000000000);
#line 1550
		isp->mant = (((csp->mant << 1) &
#line 1550
				0xffffffffffff) >> (48 - 23));
#line 1550
	}
#line 1550
	else if (ieee_exp > -23)
#line 1550
	{
#line 1550
		/* ieee subnormal, right shift */
#line 1550
		const int rshift = (48 - 23 - ieee_exp);
#line 1550

#line 1550
		isp->mant = csp->mant >> rshift;
#line 1550

#line 1550
#if 0
#line 1550
		if (csp->mant & (1 << (rshift -1)))
#line 1550
		{
#line 1550
			/* round up */
#line 1550
			isp->mant++;
#line 1550
		}
#line 1550
#endif
#line 1550

#line 1550
		isp->exp  = 0;
#line 1550
	}
#line 1550
	else
#line 1550
	{
#line 1550
		/* smaller than ieee can represent */
#line 1550
		isp->exp = 0;
#line 1550
		isp->mant = 0;
#line 1550
	}
#line 1550

	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1555
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1555

#line 1555
	isp->sign = csp->sign;
#line 1555

#line 1555
	if (ieee_exp >= 0xff)
#line 1555
	{
#line 1555
		/* NC_ERANGE => ieee Inf */
#line 1555
		isp->exp = 0xff;
#line 1555
		isp->mant = 0x0;
#line 1555
	}
#line 1555
	else if (ieee_exp > 0)
#line 1555
	{
#line 1555
		/* normal ieee representation */
#line 1555
		isp->exp  = ieee_exp;
#line 1555
		/* assumes cray rep is in normal form */
#line 1555
		assert(csp->mant & 0x800000000000);
#line 1555
		isp->mant = (((csp->mant << 1) &
#line 1555
				0xffffffffffff) >> (48 - 23));
#line 1555
	}
#line 1555
	else if (ieee_exp > -23)
#line 1555
	{
#line 1555
		/* ieee subnormal, right shift */
#line 1555
		const int rshift = (48 - 23 - ieee_exp);
#line 1555

#line 1555
		isp->mant = csp->mant >> rshift;
#line 1555

#line 1555
#if 0
#line 1555
		if (csp->mant & (1 << (rshift -1)))
#line 1555
		{
#line 1555
			/* round up */
#line 1555
			isp->mant++;
#line 1555
		}
#line 1555
#endif
#line 1555

#line 1555
		isp->exp  = 0;
#line 1555
	}
#line 1555
	else
#line 1555
	{
#line 1555
		/* smaller than ieee can represent */
#line 1555
		isp->exp = 0;
#line 1555
		isp->mant = 0;
#line 1555
	}
#line 1555

	}
}

#else
	/* IEEE Cray with only doubles */
static void
get_ix_float(const void *xp, float *ip)
{

	ieee_double *idp = (ieee_double *) ip;

	if (word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		if (isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	const ieee_double *idp = (const ieee_double *) ip;
	if (word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
		if (idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
}
#endif

#else
#error "ix_float implementation"
#endif

#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_get_float_float(const void *xp, float *ip, void *fillp)
{
	/* TODO */
	get_ix_float(xp, ip);
	return NC_NOERR;
}
#endif

#define ix_float float

static int
#line 1642
ncx_get_float_schar(const void *xp, schar *ip)
#line 1642
{
#line 1642
	ix_float xx;
#line 1642
	get_ix_float(xp, &xx);
#line 1642
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1642
#ifdef ERANGE_FILL
#line 1642
            *ip = NC_FILL_BYTE;
#line 1642
#endif
#line 1642
            return NC_ERANGE;
#line 1642
        }
#line 1642
	*ip = (schar)xx;
#line 1642
	return NC_NOERR;
#line 1642
}
#line 1642

static int
#line 1643
ncx_get_float_short(const void *xp, short *ip)
#line 1643
{
#line 1643
	ix_float xx;
#line 1643
	get_ix_float(xp, &xx);
#line 1643
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1643
#ifdef ERANGE_FILL
#line 1643
            *ip = NC_FILL_SHORT;
#line 1643
#endif
#line 1643
            return NC_ERANGE;
#line 1643
        }
#line 1643
	*ip = (short)xx;
#line 1643
	return NC_NOERR;
#line 1643
}
#line 1643

static int
#line 1644
ncx_get_float_int(const void *xp, int *ip)
#line 1644
{
#line 1644
	ix_float xx;
#line 1644
	get_ix_float(xp, &xx);
#line 1644
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1644
#ifdef ERANGE_FILL
#line 1644
            *ip = NC_FILL_INT;
#line 1644
#endif
#line 1644
            return NC_ERANGE;
#line 1644
        }
#line 1644
	*ip = (int)xx;
#line 1644
	return NC_NOERR;
#line 1644
}
#line 1644

static int
#line 1645
ncx_get_float_long(const void *xp, long *ip)
#line 1645
{
#line 1645
	ix_float xx;
#line 1645
	get_ix_float(xp, &xx);
#line 1645
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1645
#ifdef ERANGE_FILL
#line 1645
            *ip = NC_FILL_INT;
#line 1645
#endif
#line 1645
            return NC_ERANGE;
#line 1645
        }
#line 1645
	*ip = (long)xx;
#line 1645
	return NC_NOERR;
#line 1645
}
#line 1645

static int
#line 1646
ncx_get_float_double(const void *xp, double *ip)
#line 1646
{
#line 1646
	ix_float xx;
#line 1646
	get_ix_float(xp, &xx);
#line 1646
	*ip = (double)xx;
#line 1646
	return NC_NOERR;
#line 1646
}
#line 1646

static int
#line 1647
ncx_get_float_longlong(const void *xp, longlong *ip)
#line 1647
{
#line 1647
	ix_float xx;
#line 1647
	get_ix_float(xp, &xx);
#line 1647
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1647
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1647
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1647
#ifdef ERANGE_FILL
#line 1647
            *ip = NC_FILL_INT64;
#line 1647
#endif
#line 1647
            return NC_ERANGE;
#line 1647
        }
#line 1647
	else *ip = (longlong)xx;
#line 1647
	return NC_NOERR;
#line 1647
}
#line 1647

static int
#line 1648
ncx_get_float_uchar(const void *xp, uchar *ip)
#line 1648
{
#line 1648
	ix_float xx;
#line 1648
	get_ix_float(xp, &xx);
#line 1648
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1648
#ifdef ERANGE_FILL
#line 1648
            *ip = NC_FILL_UBYTE;
#line 1648
#endif
#line 1648
            return NC_ERANGE;
#line 1648
        }
#line 1648
	*ip = (uchar)xx;
#line 1648
	return NC_NOERR;
#line 1648
}
#line 1648

static int
#line 1649
ncx_get_float_ushort(const void *xp, ushort *ip)
#line 1649
{
#line 1649
	ix_float xx;
#line 1649
	get_ix_float(xp, &xx);
#line 1649
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1649
#ifdef ERANGE_FILL
#line 1649
            *ip = NC_FILL_USHORT;
#line 1649
#endif
#line 1649
            return NC_ERANGE;
#line 1649
        }
#line 1649
	*ip = (ushort)xx;
#line 1649
	return NC_NOERR;
#line 1649
}
#line 1649

static int
#line 1650
ncx_get_float_uint(const void *xp, uint *ip)
#line 1650
{
#line 1650
	ix_float xx;
#line 1650
	get_ix_float(xp, &xx);
#line 1650
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1650
#ifdef ERANGE_FILL
#line 1650
            *ip = NC_FILL_UINT;
#line 1650
#endif
#line 1650
            return NC_ERANGE;
#line 1650
        }
#line 1650
	*ip = (uint)xx;
#line 1650
	return NC_NOERR;
#line 1650
}
#line 1650

static int
#line 1651
ncx_get_float_ulonglong(const void *xp, ulonglong *ip)
#line 1651
{
#line 1651
	ix_float xx;
#line 1651
	get_ix_float(xp, &xx);
#line 1651
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1651
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1651
#ifdef ERANGE_FILL
#line 1651
            *ip = NC_FILL_UINT64;
#line 1651
#endif
#line 1651
            return NC_ERANGE;
#line 1651
        }
#line 1651
	else *ip = (ulonglong)xx;
#line 1651
	return NC_NOERR;
#line 1651
}
#line 1651


#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_put_float_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    float *_ip=ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    float tmp;
#endif
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
        
#line 1664
#ifdef ERANGE_FILL
#line 1664
            if (fillp != NULL) memcpy(&tmp, fillp, 4);
#line 1664
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_float(xp, _ip);
    return err;
}
#endif

static int
#line 1676
ncx_put_float_schar(void *xp, const schar *ip, void *fillp)
#line 1676
{
#line 1676
    int err=NC_NOERR;
#line 1676
    ix_float xx = NC_FILL_FLOAT;
#line 1676

#line 1676
    
#line 1676
        xx = (ix_float)*ip;
#line 1676

#line 1676
    put_ix_float(xp, &xx);
#line 1676
    return err;
#line 1676
}
#line 1676

static int
#line 1677
ncx_put_float_short(void *xp, const short *ip, void *fillp)
#line 1677
{
#line 1677
    int err=NC_NOERR;
#line 1677
    ix_float xx = NC_FILL_FLOAT;
#line 1677

#line 1677
    
#line 1677
        xx = (ix_float)*ip;
#line 1677

#line 1677
    put_ix_float(xp, &xx);
#line 1677
    return err;
#line 1677
}
#line 1677

static int
#line 1678
ncx_put_float_int(void *xp, const int *ip, void *fillp)
#line 1678
{
#line 1678
    int err=NC_NOERR;
#line 1678
    ix_float xx = NC_FILL_FLOAT;
#line 1678

#line 1678
    
#line 1678
        xx = (ix_float)*ip;
#line 1678

#line 1678
    put_ix_float(xp, &xx);
#line 1678
    return err;
#line 1678
}
#line 1678

static int
#line 1679
ncx_put_float_long(void *xp, const long *ip, void *fillp)
#line 1679
{
#line 1679
    int err=NC_NOERR;
#line 1679
    ix_float xx = NC_FILL_FLOAT;
#line 1679

#line 1679
    
#line 1679
        xx = (ix_float)*ip;
#line 1679

#line 1679
    put_ix_float(xp, &xx);
#line 1679
    return err;
#line 1679
}
#line 1679

static int
#line 1680
ncx_put_float_double(void *xp, const double *ip, void *fillp)
#line 1680
{
#line 1680
    int err=NC_NOERR;
#line 1680
    ix_float xx = NC_FILL_FLOAT;
#line 1680

#line 1680
    if (*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) {
#line 1680
        
#line 1680
#ifdef ERANGE_FILL
#line 1680
            if (fillp != NULL) memcpy(&xx, fillp, 4);
#line 1680
#endif
#line 1680
        err = NC_ERANGE;
#line 1680
    }
#line 1680
#ifdef ERANGE_FILL
#line 1680
    else
#line 1680
#endif
#line 1680
        xx = (ix_float)*ip;
#line 1680

#line 1680
    put_ix_float(xp, &xx);
#line 1680
    return err;
#line 1680
}
#line 1680

static int
#line 1681
ncx_put_float_longlong(void *xp, const longlong *ip, void *fillp)
#line 1681
{
#line 1681
    int err=NC_NOERR;
#line 1681
    ix_float xx = NC_FILL_FLOAT;
#line 1681

#line 1681
    
#line 1681
        xx = (ix_float)*ip;
#line 1681

#line 1681
    put_ix_float(xp, &xx);
#line 1681
    return err;
#line 1681
}
#line 1681

static int
#line 1682
ncx_put_float_uchar(void *xp, const uchar *ip, void *fillp)
#line 1682
{
#line 1682
    int err=NC_NOERR;
#line 1682
    ix_float xx = NC_FILL_FLOAT;
#line 1682

#line 1682
    
#line 1682
        xx = (ix_float)*ip;
#line 1682

#line 1682
    put_ix_float(xp, &xx);
#line 1682
    return err;
#line 1682
}
#line 1682

static int
#line 1683
ncx_put_float_ushort(void *xp, const ushort *ip, void *fillp)
#line 1683
{
#line 1683
    int err=NC_NOERR;
#line 1683
    ix_float xx = NC_FILL_FLOAT;
#line 1683

#line 1683
    
#line 1683
        xx = (ix_float)*ip;
#line 1683

#line 1683
    put_ix_float(xp, &xx);
#line 1683
    return err;
#line 1683
}
#line 1683

static int
#line 1684
ncx_put_float_uint(void *xp, const uint *ip, void *fillp)
#line 1684
{
#line 1684
    int err=NC_NOERR;
#line 1684
    ix_float xx = NC_FILL_FLOAT;
#line 1684

#line 1684
    
#line 1684
        xx = (ix_float)*ip;
#line 1684

#line 1684
    put_ix_float(xp, &xx);
#line 1684
    return err;
#line 1684
}
#line 1684

static int
#line 1685
ncx_put_float_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 1685
{
#line 1685
    int err=NC_NOERR;
#line 1685
    ix_float xx = NC_FILL_FLOAT;
#line 1685

#line 1685
    
#line 1685
        xx = (ix_float)*ip;
#line 1685

#line 1685
    put_ix_float(xp, &xx);
#line 1685
    return err;
#line 1685
}
#line 1685



/* external NC_DOUBLE -------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE  && !defined(NO_IEEE_FLOAT)

static void
get_ix_double(const void *xp, double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, SIZEOF_DOUBLE);
#else
	swap8b(ip, xp);
#endif
}

static void
put_ix_double(void *xp, const double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_DOUBLE);
#else
	swap8b(xp, ip);
#endif
}

#elif defined(vax) && vax != 0

/* What IEEE double precision floating point looks like on a Vax */
struct	ieee_double {
	unsigned int	exp_hi   : 7;
	unsigned int	sign     : 1;
	unsigned int 	mant_6   : 4;
	unsigned int	exp_lo   : 4;
	unsigned int	mant_5   : 8;
	unsigned int	mant_4   : 8;

	unsigned int	mant_lo  : 32;
};

/* Vax double precision floating point */
struct  vax_double {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
	unsigned int	mantissa3 : 16;
	unsigned int	mantissa4 : 16;
};

#define VAX_DBL_BIAS	0x81
#define IEEE_DBL_BIAS	0x3ff
#define MASK(nbits)	((1 << nbits) - 1)

static const struct dbl_limits {
	struct	vax_double d;
	struct	ieee_double ieee;
} dbl_limits[2] = {
	{{ 0x7f, 0xff, 0x0, 0xffff, 0xffff, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0}}, /* Max IEEE */
	{{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},		/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}, /* Min IEEE */
};


#line 1799
static void
get_ix_double(const void *xp, double *ip)
{
	struct vax_double *const vdp =
#line 1802
			 (struct vax_double *)ip;
#line 1802
	const struct ieee_double *const idp =
#line 1802
			 (const struct ieee_double *) xp;
#line 1802
	{
#line 1802
		const struct dbl_limits *lim;
#line 1802
		int ii;
#line 1802
		for (ii = 0, lim = dbl_limits;
#line 1802
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 1802
			ii++, lim++)
#line 1802
		{
#line 1802
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 1802
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 1802
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 1802
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 1802
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 1802
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 1802
				)
#line 1802
			{
#line 1802
				*vdp = lim->d;
#line 1802
				goto doneit;
#line 1802
			}
#line 1802
		}
#line 1802
	}
#line 1802
	{
#line 1802
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 1802
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 1802
	}
#line 1802
	{
#line 1802
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 1802
				 | (idp->mant_5 << 8)
#line 1802
				 | idp->mant_4);
#line 1802
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 1802
		vdp->mantissa1 = (mant_hi >> 13);
#line 1802
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 1802
				| (mant_lo >> 29);
#line 1802
		vdp->mantissa3 = (mant_lo >> 13);
#line 1802
		vdp->mantissa4 = (mant_lo << 3);
#line 1802
	}
#line 1802
	doneit:
#line 1802
		vdp->sign = idp->sign;
#line 1802

}


#line 1872
static void
put_ix_double(void *xp, const double *ip)
{
	const struct vax_double *const vdp =
#line 1875
			(const struct vax_double *)ip;
#line 1875
	struct ieee_double *const idp =
#line 1875
			 (struct ieee_double *) xp;
#line 1875

#line 1875
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 1875
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 1875
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 1875
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 1875
		(vdp->exp == dbl_limits[0].d.exp))
#line 1875
	{
#line 1875
		*idp = dbl_limits[0].ieee;
#line 1875
		goto shipit;
#line 1875
	}
#line 1875
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 1875
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 1875
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 1875
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 1875
		(vdp->exp == dbl_limits[1].d.exp))
#line 1875
	{
#line 1875
		*idp = dbl_limits[1].ieee;
#line 1875
		goto shipit;
#line 1875
	}
#line 1875

#line 1875
	{
#line 1875
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 1875

#line 1875
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 1875
			(vdp->mantissa3 << 13) |
#line 1875
			((vdp->mantissa4 >> 3) & MASK(13));
#line 1875

#line 1875
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 1875
				 | (vdp->mantissa2 >> 3);
#line 1875

#line 1875
		if ((vdp->mantissa4 & 7) > 4)
#line 1875
		{
#line 1875
			/* round up */
#line 1875
			mant_lo++;
#line 1875
			if (mant_lo == 0)
#line 1875
			{
#line 1875
				mant_hi++;
#line 1875
				if (mant_hi > 0xffffff)
#line 1875
				{
#line 1875
					mant_hi = 0;
#line 1875
					exp++;
#line 1875
				}
#line 1875
			}
#line 1875
		}
#line 1875

#line 1875
		idp->mant_lo = SWAP4(mant_lo);
#line 1875
		idp->mant_6 = mant_hi >> 16;
#line 1875
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 1875
		idp->mant_4 = mant_hi;
#line 1875
		idp->exp_hi = exp >> 4;
#line 1875
		idp->exp_lo = exp;
#line 1875
	}
#line 1875

#line 1875
	shipit:
#line 1875
		idp->sign = vdp->sign;
#line 1875

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

static void
get_ix_double(const void *xp, double *ip)
{
	const ieee_double *idp = (const ieee_double *) xp;
	cray_single *csp = (cray_single *) ip;

	if (idp->exp == 0)
	{
		/* ieee subnormal */
		*ip = (double)idp->mant;
		if (idp->mant != 0)
		{
			csp->exp -= (ieee_double_bias + 51);
		}
	}
	else
	{
		csp->exp  = idp->exp + cs_id_bias + 1;
		csp->mant = idp->mant >> (52 - 48 + 1);
		csp->mant |= (1 << (48 - 1));
	}
	csp->sign = idp->sign;
}

static void
put_ix_double(void *xp, const double *ip)
{
	ieee_double *idp = (ieee_double *) xp;
	const cray_single *csp = (const cray_single *) ip;

	int ieee_exp = csp->exp - cs_id_bias -1;

	idp->sign = csp->sign;

	if (ieee_exp >= 0x7ff)
	{
		/* NC_ERANGE => ieee Inf */
		idp->exp = 0x7ff;
		idp->mant = 0x0;
	}
	else if (ieee_exp > 0)
	{
		/* normal ieee representation */
		idp->exp  = ieee_exp;
		/* assumes cray rep is in normal form */
		assert(csp->mant & 0x800000000000);
		idp->mant = (((csp->mant << 1) &
				0xffffffffffff) << (52 - 48));
	}
	else if (ieee_exp >= (-(52 -48)))
	{
		/* ieee subnormal, left shift */
		const int lshift = (52 - 48) + ieee_exp;
		idp->mant = csp->mant << lshift;
		idp->exp  = 0;
	}
	else if (ieee_exp >= -52)
	{
		/* ieee subnormal, right shift */
		const int rshift = (- (52 - 48) - ieee_exp);

		idp->mant = csp->mant >> rshift;

#if 0
		if (csp->mant & (1 << (rshift -1)))
		{
			/* round up */
			idp->mant++;
		}
#endif

		idp->exp  = 0;
	}
	else
	{
		/* smaller than ieee can represent */
		idp->exp = 0;
		idp->mant = 0;
	}
}
#else
#error "ix_double implementation"
#endif

#define ix_double double

static int
#line 1967
ncx_get_double_schar(const void *xp, schar *ip)
#line 1967
{
#line 1967
	ix_double xx;
#line 1967
	get_ix_double(xp, &xx);
#line 1967
	if (xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) {
#line 1967
#ifdef ERANGE_FILL
#line 1967
            *ip = NC_FILL_BYTE;
#line 1967
#endif
#line 1967
            return NC_ERANGE;
#line 1967
        }
#line 1967
	*ip = (schar)xx;
#line 1967
	return NC_NOERR;
#line 1967
}
#line 1967

static int
#line 1968
ncx_get_double_short(const void *xp, short *ip)
#line 1968
{
#line 1968
	ix_double xx;
#line 1968
	get_ix_double(xp, &xx);
#line 1968
	if (xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) {
#line 1968
#ifdef ERANGE_FILL
#line 1968
            *ip = NC_FILL_SHORT;
#line 1968
#endif
#line 1968
            return NC_ERANGE;
#line 1968
        }
#line 1968
	*ip = (short)xx;
#line 1968
	return NC_NOERR;
#line 1968
}
#line 1968

static int
#line 1969
ncx_get_double_int(const void *xp, int *ip)
#line 1969
{
#line 1969
	ix_double xx;
#line 1969
	get_ix_double(xp, &xx);
#line 1969
	if (xx > (double)INT_MAX || xx < (double)INT_MIN) {
#line 1969
#ifdef ERANGE_FILL
#line 1969
            *ip = NC_FILL_INT;
#line 1969
#endif
#line 1969
            return NC_ERANGE;
#line 1969
        }
#line 1969
	*ip = (int)xx;
#line 1969
	return NC_NOERR;
#line 1969
}
#line 1969

static int
#line 1970
ncx_get_double_long(const void *xp, long *ip)
#line 1970
{
#line 1970
	ix_double xx;
#line 1970
	get_ix_double(xp, &xx);
#line 1970
	if (xx > (double)LONG_MAX || xx < (double)LONG_MIN) {
#line 1970
#ifdef ERANGE_FILL
#line 1970
            *ip = NC_FILL_INT;
#line 1970
#endif
#line 1970
            return NC_ERANGE;
#line 1970
        }
#line 1970
	*ip = (long)xx;
#line 1970
	return NC_NOERR;
#line 1970
}
#line 1970

static int
#line 1971
ncx_get_double_longlong(const void *xp, longlong *ip)
#line 1971
{
#line 1971
	ix_double xx;
#line 1971
	get_ix_double(xp, &xx);
#line 1971
	if (xx == LONGLONG_MAX)      *ip = LONGLONG_MAX;
#line 1971
	else if (xx == LONGLONG_MIN) *ip = LONGLONG_MIN;
#line 1971
	else if (xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) {
#line 1971
#ifdef ERANGE_FILL
#line 1971
            *ip = NC_FILL_INT64;
#line 1971
#endif
#line 1971
            return NC_ERANGE;
#line 1971
        }
#line 1971
	else *ip = (longlong)xx;
#line 1971
	return NC_NOERR;
#line 1971
}
#line 1971

static int
#line 1972
ncx_get_double_uchar(const void *xp, uchar *ip)
#line 1972
{
#line 1972
	ix_double xx;
#line 1972
	get_ix_double(xp, &xx);
#line 1972
	if (xx > (double)UCHAR_MAX || xx < 0) {
#line 1972
#ifdef ERANGE_FILL
#line 1972
            *ip = NC_FILL_UBYTE;
#line 1972
#endif
#line 1972
            return NC_ERANGE;
#line 1972
        }
#line 1972
	*ip = (uchar)xx;
#line 1972
	return NC_NOERR;
#line 1972
}
#line 1972

static int
#line 1973
ncx_get_double_ushort(const void *xp, ushort *ip)
#line 1973
{
#line 1973
	ix_double xx;
#line 1973
	get_ix_double(xp, &xx);
#line 1973
	if (xx > (double)USHORT_MAX || xx < 0) {
#line 1973
#ifdef ERANGE_FILL
#line 1973
            *ip = NC_FILL_USHORT;
#line 1973
#endif
#line 1973
            return NC_ERANGE;
#line 1973
        }
#line 1973
	*ip = (ushort)xx;
#line 1973
	return NC_NOERR;
#line 1973
}
#line 1973

static int
#line 1974
ncx_get_double_uint(const void *xp, uint *ip)
#line 1974
{
#line 1974
	ix_double xx;
#line 1974
	get_ix_double(xp, &xx);
#line 1974
	if (xx > (double)UINT_MAX || xx < 0) {
#line 1974
#ifdef ERANGE_FILL
#line 1974
            *ip = NC_FILL_UINT;
#line 1974
#endif
#line 1974
            return NC_ERANGE;
#line 1974
        }
#line 1974
	*ip = (uint)xx;
#line 1974
	return NC_NOERR;
#line 1974
}
#line 1974

static int
#line 1975
ncx_get_double_ulonglong(const void *xp, ulonglong *ip)
#line 1975
{
#line 1975
	ix_double xx;
#line 1975
	get_ix_double(xp, &xx);
#line 1975
	if (xx == ULONGLONG_MAX)      *ip = ULONGLONG_MAX;
#line 1975
	else if (xx > (double)ULONGLONG_MAX || xx < 0) {
#line 1975
#ifdef ERANGE_FILL
#line 1975
            *ip = NC_FILL_UINT64;
#line 1975
#endif
#line 1975
            return NC_ERANGE;
#line 1975
        }
#line 1975
	else *ip = (ulonglong)xx;
#line 1975
	return NC_NOERR;
#line 1975
}
#line 1975


static int
ncx_get_double_float(const void *xp, float *ip)
{
    double xx;
    get_ix_double(xp, &xx);
    if (xx > FLT_MAX) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = FLT_MAX;
#endif
        return NC_ERANGE;
    }
    if (xx < (-FLT_MAX)) {
#ifdef ERANGE_FILL
        *ip = NC_FILL_FLOAT;
#else
        *ip = (-FLT_MAX);
#endif
        return NC_ERANGE;
    }
    *ip = (float) xx;
    return NC_NOERR;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_get_double_double(const void *xp, double *ip, void *fillp)
{
	/* TODO */
	get_ix_double(xp, ip);
	return NC_NOERR;
}
#endif

static int
#line 2012
ncx_put_double_schar(void *xp, const schar *ip, void *fillp)
#line 2012
{
#line 2012
    int err=NC_NOERR;
#line 2012
    ix_double xx = NC_FILL_DOUBLE;
#line 2012

#line 2012
    
#line 2012
        xx = (ix_double)*ip;
#line 2012

#line 2012
    put_ix_double(xp, &xx);
#line 2012
    return err;
#line 2012
}
#line 2012

static int
#line 2013
ncx_put_double_uchar(void *xp, const uchar *ip, void *fillp)
#line 2013
{
#line 2013
    int err=NC_NOERR;
#line 2013
    ix_double xx = NC_FILL_DOUBLE;
#line 2013

#line 2013
    
#line 2013
        xx = (ix_double)*ip;
#line 2013

#line 2013
    put_ix_double(xp, &xx);
#line 2013
    return err;
#line 2013
}
#line 2013

static int
#line 2014
ncx_put_double_short(void *xp, const short *ip, void *fillp)
#line 2014
{
#line 2014
    int err=NC_NOERR;
#line 2014
    ix_double xx = NC_FILL_DOUBLE;
#line 2014

#line 2014
    
#line 2014
        xx = (ix_double)*ip;
#line 2014

#line 2014
    put_ix_double(xp, &xx);
#line 2014
    return err;
#line 2014
}
#line 2014

static int
#line 2015
ncx_put_double_ushort(void *xp, const ushort *ip, void *fillp)
#line 2015
{
#line 2015
    int err=NC_NOERR;
#line 2015
    ix_double xx = NC_FILL_DOUBLE;
#line 2015

#line 2015
    
#line 2015
        xx = (ix_double)*ip;
#line 2015

#line 2015
    put_ix_double(xp, &xx);
#line 2015
    return err;
#line 2015
}
#line 2015

static int
#line 2016
ncx_put_double_int(void *xp, const int *ip, void *fillp)
#line 2016
{
#line 2016
    int err=NC_NOERR;
#line 2016
    ix_double xx = NC_FILL_DOUBLE;
#line 2016

#line 2016
    
#line 2016
        xx = (ix_double)*ip;
#line 2016

#line 2016
    put_ix_double(xp, &xx);
#line 2016
    return err;
#line 2016
}
#line 2016

static int
#line 2017
ncx_put_double_long(void *xp, const long *ip, void *fillp)
#line 2017
{
#line 2017
    int err=NC_NOERR;
#line 2017
    ix_double xx = NC_FILL_DOUBLE;
#line 2017

#line 2017
    
#line 2017
        xx = (ix_double)*ip;
#line 2017

#line 2017
    put_ix_double(xp, &xx);
#line 2017
    return err;
#line 2017
}
#line 2017

static int
#line 2018
ncx_put_double_uint(void *xp, const uint *ip, void *fillp)
#line 2018
{
#line 2018
    int err=NC_NOERR;
#line 2018
    ix_double xx = NC_FILL_DOUBLE;
#line 2018

#line 2018
    
#line 2018
        xx = (ix_double)*ip;
#line 2018

#line 2018
    put_ix_double(xp, &xx);
#line 2018
    return err;
#line 2018
}
#line 2018

static int
#line 2019
ncx_put_double_longlong(void *xp, const longlong *ip, void *fillp)
#line 2019
{
#line 2019
    int err=NC_NOERR;
#line 2019
    ix_double xx = NC_FILL_DOUBLE;
#line 2019

#line 2019
    
#line 2019
        xx = (ix_double)*ip;
#line 2019

#line 2019
    put_ix_double(xp, &xx);
#line 2019
    return err;
#line 2019
}
#line 2019

static int
#line 2020
ncx_put_double_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2020
{
#line 2020
    int err=NC_NOERR;
#line 2020
    ix_double xx = NC_FILL_DOUBLE;
#line 2020

#line 2020
    
#line 2020
        xx = (ix_double)*ip;
#line 2020

#line 2020
    put_ix_double(xp, &xx);
#line 2020
    return err;
#line 2020
}
#line 2020


static int
ncx_put_double_float(void *xp, const float *ip, void *fillp)
{
    int err=NC_NOERR;
    double xx = NC_FILL_DOUBLE;
#if 1	/* TODO: figure this out (if condition below will never be true)*/
    if ((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN) {
        
#line 2029
#ifdef ERANGE_FILL
#line 2029
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2029
#endif
        err = NC_ERANGE;
    }
#ifdef ERANGE_FILL
    else
#endif
#endif
        xx = (double) *ip;

    put_ix_double(xp, &xx);
    return err;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_put_double_double(void *xp, const double *ip, void *fillp)
{
    int err=NC_NOERR;
    double *_ip = ip;
#ifdef NO_IEEE_FLOAT
#ifdef ERANGE_FILL
    double tmp=NC_FILL_DOUBLE;
#endif
    if (*ip > X_DOUBLE_MAX || *ip < X_DOUBLE_MIN) {
        
#line 2053
#ifdef ERANGE_FILL
#line 2053
            if (fillp != NULL) memcpy(&tmp, fillp, 8);
#line 2053
#endif
#ifdef ERANGE_FILL
        _ip = &tmp;
#endif
        err = NC_ERANGE;
    }
#endif
    put_ix_double(xp, _ip);
    return err;
}
#endif


/* external NC_INT64 --------------------------------------------------------*/

#if SHORT_MAX == X_INT64_MAX
typedef short ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_SHORT
#define IX_INT64_MAX SHORT_MAX
#elif LONG_LONG_MAX  >= X_INT64_MAX
typedef longlong ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONGLONG
#define IX_INT64_MAX LONG_LONG_MAX
#elif LONG_MAX  >= X_INT64_MAX
typedef long ix_int64;
#define SIZEOF_IX_INT64 SIZEOF_LONG
#define IX_INT64_MAX LONG_MAX
#else
#error "ix_int64 implementation"
#endif


static void
get_ix_int64(const void *xp, ix_int64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((ix_int64)(*cp++) << 56);
    *ip |= ((ix_int64)(*cp++) << 48);
    *ip |= ((ix_int64)(*cp++) << 40);
    *ip |= ((ix_int64)(*cp++) << 32);
    *ip |= ((ix_int64)(*cp++) << 24);
    *ip |= ((ix_int64)(*cp++) << 16);
    *ip |= ((ix_int64)(*cp++) <<  8);
    *ip |=  (ix_int64)*cp;
}

static void
put_ix_int64(void *xp, const ix_int64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffLL);
}

#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 2116
ncx_get_longlong_longlong(const void *xp, longlong *ip)
#line 2116
{
#line 2116
    int err=NC_NOERR;
#line 2116
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 2116
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2116
#else
#line 2116
    ix_int64 xx;
#line 2116
    get_ix_int64(xp, &xx);
#line 2116

#line 2116
#if IX_INT64_MAX > LONGLONG_MAX
#line 2116
    if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) {
#line 2116
#ifdef ERANGE_FILL
#line 2116
        *ip = NC_FILL_INT64;
#line 2116
        return NC_ERANGE;
#line 2116
#else
#line 2116
        err = NC_ERANGE;
#line 2116
#endif
#line 2116
    }
#line 2116
#endif
#line 2116

#line 2116

#line 2116
    *ip = (longlong) xx;
#line 2116
#endif
#line 2116
    return err;
#line 2116
}
#line 2116

#endif
static int
#line 2118
ncx_get_longlong_schar(const void *xp, schar *ip)
#line 2118
{
#line 2118
    int err=NC_NOERR;
#line 2118
    ix_int64 xx;
#line 2118
    get_ix_int64(xp, &xx);
#line 2118

#line 2118
#if IX_INT64_MAX > SCHAR_MAX
#line 2118
    if (xx > SCHAR_MAX || xx < SCHAR_MIN) {
#line 2118
#ifdef ERANGE_FILL
#line 2118
        *ip = NC_FILL_BYTE;
#line 2118
        return NC_ERANGE;
#line 2118
#else
#line 2118
        err = NC_ERANGE;
#line 2118
#endif
#line 2118
    }
#line 2118
#endif
#line 2118

#line 2118

#line 2118
    *ip = (schar) xx;
#line 2118
    return err;
#line 2118
}
#line 2118

static int
#line 2119
ncx_get_longlong_short(const void *xp, short *ip)
#line 2119
{
#line 2119
    int err=NC_NOERR;
#line 2119
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 2119
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2119
#else
#line 2119
    ix_int64 xx;
#line 2119
    get_ix_int64(xp, &xx);
#line 2119

#line 2119
#if IX_INT64_MAX > SHORT_MAX
#line 2119
    if (xx > SHORT_MAX || xx < SHORT_MIN) {
#line 2119
#ifdef ERANGE_FILL
#line 2119
        *ip = NC_FILL_SHORT;
#line 2119
        return NC_ERANGE;
#line 2119
#else
#line 2119
        err = NC_ERANGE;
#line 2119
#endif
#line 2119
    }
#line 2119
#endif
#line 2119

#line 2119

#line 2119
    *ip = (short) xx;
#line 2119
#endif
#line 2119
    return err;
#line 2119
}
#line 2119

static int
#line 2120
ncx_get_longlong_int(const void *xp, int *ip)
#line 2120
{
#line 2120
    int err=NC_NOERR;
#line 2120
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 2120
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2120
#else
#line 2120
    ix_int64 xx;
#line 2120
    get_ix_int64(xp, &xx);
#line 2120

#line 2120
#if IX_INT64_MAX > INT_MAX
#line 2120
    if (xx > INT_MAX || xx < INT_MIN) {
#line 2120
#ifdef ERANGE_FILL
#line 2120
        *ip = NC_FILL_INT;
#line 2120
        return NC_ERANGE;
#line 2120
#else
#line 2120
        err = NC_ERANGE;
#line 2120
#endif
#line 2120
    }
#line 2120
#endif
#line 2120

#line 2120

#line 2120
    *ip = (int) xx;
#line 2120
#endif
#line 2120
    return err;
#line 2120
}
#line 2120

static int
#line 2121
ncx_get_longlong_long(const void *xp, long *ip)
#line 2121
{
#line 2121
    int err=NC_NOERR;
#line 2121
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 2121
    get_ix_int64(xp, (ix_int64 *)ip);
#line 2121
#else
#line 2121
    ix_int64 xx;
#line 2121
    get_ix_int64(xp, &xx);
#line 2121

#line 2121
#if IX_INT64_MAX > LONG_MAX
#line 2121
    if (xx > LONG_MAX || xx < LONG_MIN) {
#line 2121
#ifdef ERANGE_FILL
#line 2121
        *ip = NC_FILL_INT;
#line 2121
        return NC_ERANGE;
#line 2121
#else
#line 2121
        err = NC_ERANGE;
#line 2121
#endif
#line 2121
    }
#line 2121
#endif
#line 2121

#line 2121

#line 2121
    *ip = (long) xx;
#line 2121
#endif
#line 2121
    return err;
#line 2121
}
#line 2121

static int
#line 2122
ncx_get_longlong_ushort(const void *xp, ushort *ip)
#line 2122
{
#line 2122
    int err=NC_NOERR;
#line 2122
    ix_int64 xx;
#line 2122
    get_ix_int64(xp, &xx);
#line 2122

#line 2122
#if IX_INT64_MAX > USHORT_MAX
#line 2122
    if (xx > USHORT_MAX) {
#line 2122
#ifdef ERANGE_FILL
#line 2122
        *ip = NC_FILL_USHORT;
#line 2122
        return NC_ERANGE;
#line 2122
#else
#line 2122
        err = NC_ERANGE;
#line 2122
#endif
#line 2122
    }
#line 2122
#endif
#line 2122

#line 2122
    if (xx < 0) {
#line 2122
#ifdef ERANGE_FILL
#line 2122
        *ip = NC_FILL_USHORT;
#line 2122
        return NC_ERANGE;
#line 2122
#else
#line 2122
        err = NC_ERANGE; /* because ip is unsigned */
#line 2122
#endif
#line 2122
    }
#line 2122
    *ip = (ushort) xx;
#line 2122
    return err;
#line 2122
}
#line 2122

static int
#line 2123
ncx_get_longlong_uchar(const void *xp, uchar *ip)
#line 2123
{
#line 2123
    int err=NC_NOERR;
#line 2123
    ix_int64 xx;
#line 2123
    get_ix_int64(xp, &xx);
#line 2123

#line 2123
#if IX_INT64_MAX > UCHAR_MAX
#line 2123
    if (xx > UCHAR_MAX) {
#line 2123
#ifdef ERANGE_FILL
#line 2123
        *ip = NC_FILL_UBYTE;
#line 2123
        return NC_ERANGE;
#line 2123
#else
#line 2123
        err = NC_ERANGE;
#line 2123
#endif
#line 2123
    }
#line 2123
#endif
#line 2123

#line 2123
    if (xx < 0) {
#line 2123
#ifdef ERANGE_FILL
#line 2123
        *ip = NC_FILL_UBYTE;
#line 2123
        return NC_ERANGE;
#line 2123
#else
#line 2123
        err = NC_ERANGE; /* because ip is unsigned */
#line 2123
#endif
#line 2123
    }
#line 2123
    *ip = (uchar) xx;
#line 2123
    return err;
#line 2123
}
#line 2123

static int
#line 2124
ncx_get_longlong_uint(const void *xp, uint *ip)
#line 2124
{
#line 2124
    int err=NC_NOERR;
#line 2124
    ix_int64 xx;
#line 2124
    get_ix_int64(xp, &xx);
#line 2124

#line 2124
#if IX_INT64_MAX > UINT_MAX
#line 2124
    if (xx > UINT_MAX) {
#line 2124
#ifdef ERANGE_FILL
#line 2124
        *ip = NC_FILL_UINT;
#line 2124
        return NC_ERANGE;
#line 2124
#else
#line 2124
        err = NC_ERANGE;
#line 2124
#endif
#line 2124
    }
#line 2124
#endif
#line 2124

#line 2124
    if (xx < 0) {
#line 2124
#ifdef ERANGE_FILL
#line 2124
        *ip = NC_FILL_UINT;
#line 2124
        return NC_ERANGE;
#line 2124
#else
#line 2124
        err = NC_ERANGE; /* because ip is unsigned */
#line 2124
#endif
#line 2124
    }
#line 2124
    *ip = (uint) xx;
#line 2124
    return err;
#line 2124
}
#line 2124

static int
#line 2125
ncx_get_longlong_ulonglong(const void *xp, ulonglong *ip)
#line 2125
{
#line 2125
    int err=NC_NOERR;
#line 2125
    ix_int64 xx;
#line 2125
    get_ix_int64(xp, &xx);
#line 2125

#line 2125
#if IX_INT64_MAX > ULONGLONG_MAX
#line 2125
    if (xx > ULONGLONG_MAX) {
#line 2125
#ifdef ERANGE_FILL
#line 2125
        *ip = NC_FILL_UINT64;
#line 2125
        return NC_ERANGE;
#line 2125
#else
#line 2125
        err = NC_ERANGE;
#line 2125
#endif
#line 2125
    }
#line 2125
#endif
#line 2125

#line 2125
    if (xx < 0) {
#line 2125
#ifdef ERANGE_FILL
#line 2125
        *ip = NC_FILL_UINT64;
#line 2125
        return NC_ERANGE;
#line 2125
#else
#line 2125
        err = NC_ERANGE; /* because ip is unsigned */
#line 2125
#endif
#line 2125
    }
#line 2125
    *ip = (ulonglong) xx;
#line 2125
    return err;
#line 2125
}
#line 2125

static int
#line 2126
ncx_get_longlong_float(const void *xp, float *ip)
#line 2126
{
#line 2126
	ix_int64 xx;
#line 2126
	get_ix_int64(xp, &xx);
#line 2126
	*ip = (float)xx;
#line 2126
	return NC_NOERR;
#line 2126
}
#line 2126

static int
#line 2127
ncx_get_longlong_double(const void *xp, double *ip)
#line 2127
{
#line 2127
	ix_int64 xx;
#line 2127
	get_ix_int64(xp, &xx);
#line 2127
	*ip = (double)xx;
#line 2127
	return NC_NOERR;
#line 2127
}
#line 2127


#if X_SIZEOF_INT64 != SIZEOF_LONGLONG
static int
#line 2130
ncx_put_longlong_longlong(void *xp, const longlong *ip, void *fillp)
#line 2130
{
#line 2130
    int err=NC_NOERR;
#line 2130
#if SIZEOF_IX_INT64 == SIZEOF_LONGLONG && IX_INT64_MAX == LONGLONG_MAX
#line 2130
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2130
#else
#line 2130
    ix_int64 xx = NC_FILL_INT64;
#line 2130

#line 2130
#if IX_INT64_MAX < LONGLONG_MAX
#line 2130
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2130
        
#line 2130
#ifdef ERANGE_FILL
#line 2130
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2130
#endif
#line 2130
        err = NC_ERANGE;
#line 2130
    }
#line 2130
#ifdef ERANGE_FILL
#line 2130
    else
#line 2130
#endif
#line 2130
#endif
#line 2130
        xx = (ix_int64)*ip;
#line 2130

#line 2130
    put_ix_int64(xp, &xx);
#line 2130
#endif
#line 2130
    return err;
#line 2130
}
#line 2130

#endif
static int
#line 2132
ncx_put_longlong_schar(void *xp, const schar *ip, void *fillp)
#line 2132
{
#line 2132
    int err=NC_NOERR;
#line 2132
    ix_int64 xx = NC_FILL_INT64;
#line 2132

#line 2132
#if IX_INT64_MAX < SCHAR_MAX
#line 2132
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2132
        
#line 2132
#ifdef ERANGE_FILL
#line 2132
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2132
#endif
#line 2132
        err = NC_ERANGE;
#line 2132
    }
#line 2132
#ifdef ERANGE_FILL
#line 2132
    else
#line 2132
#endif
#line 2132
#endif
#line 2132
        xx = (ix_int64)*ip;
#line 2132

#line 2132
    put_ix_int64(xp, &xx);
#line 2132
    return err;
#line 2132
}
#line 2132

static int
#line 2133
ncx_put_longlong_short(void *xp, const short *ip, void *fillp)
#line 2133
{
#line 2133
    int err=NC_NOERR;
#line 2133
#if SIZEOF_IX_INT64 == SIZEOF_SHORT && IX_INT64_MAX == SHORT_MAX
#line 2133
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2133
#else
#line 2133
    ix_int64 xx = NC_FILL_INT64;
#line 2133

#line 2133
#if IX_INT64_MAX < SHORT_MAX
#line 2133
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2133
        
#line 2133
#ifdef ERANGE_FILL
#line 2133
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2133
#endif
#line 2133
        err = NC_ERANGE;
#line 2133
    }
#line 2133
#ifdef ERANGE_FILL
#line 2133
    else
#line 2133
#endif
#line 2133
#endif
#line 2133
        xx = (ix_int64)*ip;
#line 2133

#line 2133
    put_ix_int64(xp, &xx);
#line 2133
#endif
#line 2133
    return err;
#line 2133
}
#line 2133

static int
#line 2134
ncx_put_longlong_int(void *xp, const int *ip, void *fillp)
#line 2134
{
#line 2134
    int err=NC_NOERR;
#line 2134
#if SIZEOF_IX_INT64 == SIZEOF_INT && IX_INT64_MAX == INT_MAX
#line 2134
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2134
#else
#line 2134
    ix_int64 xx = NC_FILL_INT64;
#line 2134

#line 2134
#if IX_INT64_MAX < INT_MAX
#line 2134
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2134
        
#line 2134
#ifdef ERANGE_FILL
#line 2134
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2134
#endif
#line 2134
        err = NC_ERANGE;
#line 2134
    }
#line 2134
#ifdef ERANGE_FILL
#line 2134
    else
#line 2134
#endif
#line 2134
#endif
#line 2134
        xx = (ix_int64)*ip;
#line 2134

#line 2134
    put_ix_int64(xp, &xx);
#line 2134
#endif
#line 2134
    return err;
#line 2134
}
#line 2134

static int
#line 2135
ncx_put_longlong_long(void *xp, const long *ip, void *fillp)
#line 2135
{
#line 2135
    int err=NC_NOERR;
#line 2135
#if SIZEOF_IX_INT64 == SIZEOF_LONG && IX_INT64_MAX == LONG_MAX
#line 2135
    put_ix_int64(xp, (const ix_int64 *)ip);
#line 2135
#else
#line 2135
    ix_int64 xx = NC_FILL_INT64;
#line 2135

#line 2135
#if IX_INT64_MAX < LONG_MAX
#line 2135
    if (*ip > IX_INT64_MAX || *ip < X_INT64_MIN) {
#line 2135
        
#line 2135
#ifdef ERANGE_FILL
#line 2135
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2135
#endif
#line 2135
        err = NC_ERANGE;
#line 2135
    }
#line 2135
#ifdef ERANGE_FILL
#line 2135
    else
#line 2135
#endif
#line 2135
#endif
#line 2135
        xx = (ix_int64)*ip;
#line 2135

#line 2135
    put_ix_int64(xp, &xx);
#line 2135
#endif
#line 2135
    return err;
#line 2135
}
#line 2135

static int
#line 2136
ncx_put_longlong_ushort(void *xp, const ushort *ip, void *fillp)
#line 2136
{
#line 2136
    int err=NC_NOERR;
#line 2136
    ix_int64 xx = NC_FILL_INT64;
#line 2136

#line 2136
#if IX_INT64_MAX < USHORT_MAX
#line 2136
    if (*ip > IX_INT64_MAX) {
#line 2136
        
#line 2136
#ifdef ERANGE_FILL
#line 2136
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2136
#endif
#line 2136
        err = NC_ERANGE;
#line 2136
    }
#line 2136
#ifdef ERANGE_FILL
#line 2136
    else
#line 2136
#endif
#line 2136
#endif
#line 2136
        xx = (ix_int64)*ip;
#line 2136

#line 2136
    put_ix_int64(xp, &xx);
#line 2136
    return err;
#line 2136
}
#line 2136

static int
#line 2137
ncx_put_longlong_uchar(void *xp, const uchar *ip, void *fillp)
#line 2137
{
#line 2137
    int err=NC_NOERR;
#line 2137
    ix_int64 xx = NC_FILL_INT64;
#line 2137

#line 2137
#if IX_INT64_MAX < UCHAR_MAX
#line 2137
    if (*ip > IX_INT64_MAX) {
#line 2137
        
#line 2137
#ifdef ERANGE_FILL
#line 2137
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2137
#endif
#line 2137
        err = NC_ERANGE;
#line 2137
    }
#line 2137
#ifdef ERANGE_FILL
#line 2137
    else
#line 2137
#endif
#line 2137
#endif
#line 2137
        xx = (ix_int64)*ip;
#line 2137

#line 2137
    put_ix_int64(xp, &xx);
#line 2137
    return err;
#line 2137
}
#line 2137

static int
#line 2138
ncx_put_longlong_uint(void *xp, const uint *ip, void *fillp)
#line 2138
{
#line 2138
    int err=NC_NOERR;
#line 2138
    ix_int64 xx = NC_FILL_INT64;
#line 2138

#line 2138
#if IX_INT64_MAX < UINT_MAX
#line 2138
    if (*ip > IX_INT64_MAX) {
#line 2138
        
#line 2138
#ifdef ERANGE_FILL
#line 2138
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2138
#endif
#line 2138
        err = NC_ERANGE;
#line 2138
    }
#line 2138
#ifdef ERANGE_FILL
#line 2138
    else
#line 2138
#endif
#line 2138
#endif
#line 2138
        xx = (ix_int64)*ip;
#line 2138

#line 2138
    put_ix_int64(xp, &xx);
#line 2138
    return err;
#line 2138
}
#line 2138

static int
#line 2139
ncx_put_longlong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2139
{
#line 2139
    int err=NC_NOERR;
#line 2139
    ix_int64 xx = NC_FILL_INT64;
#line 2139

#line 2139
#if IX_INT64_MAX < ULONGLONG_MAX
#line 2139
    if (*ip > IX_INT64_MAX) {
#line 2139
        
#line 2139
#ifdef ERANGE_FILL
#line 2139
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2139
#endif
#line 2139
        err = NC_ERANGE;
#line 2139
    }
#line 2139
#ifdef ERANGE_FILL
#line 2139
    else
#line 2139
#endif
#line 2139
#endif
#line 2139
        xx = (ix_int64)*ip;
#line 2139

#line 2139
    put_ix_int64(xp, &xx);
#line 2139
    return err;
#line 2139
}
#line 2139

static int
#line 2140
ncx_put_longlong_float(void *xp, const float *ip, void *fillp)
#line 2140
{
#line 2140
    int err=NC_NOERR;
#line 2140
    ix_int64 xx = NC_FILL_INT64;
#line 2140

#line 2140
    if (*ip > (double)X_INT64_MAX || *ip < (double)X_INT64_MIN) {
#line 2140
        
#line 2140
#ifdef ERANGE_FILL
#line 2140
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2140
#endif
#line 2140
        err = NC_ERANGE;
#line 2140
    }
#line 2140
#ifdef ERANGE_FILL
#line 2140
    else
#line 2140
#endif
#line 2140
        xx = (ix_int64)*ip;
#line 2140

#line 2140
    put_ix_int64(xp, &xx);
#line 2140
    return err;
#line 2140
}
#line 2140

static int
#line 2141
ncx_put_longlong_double(void *xp, const double *ip, void *fillp)
#line 2141
{
#line 2141
    int err=NC_NOERR;
#line 2141
    ix_int64 xx = NC_FILL_INT64;
#line 2141

#line 2141
    if (*ip > X_INT64_MAX || *ip < X_INT64_MIN) {
#line 2141
        
#line 2141
#ifdef ERANGE_FILL
#line 2141
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2141
#endif
#line 2141
        err = NC_ERANGE;
#line 2141
    }
#line 2141
#ifdef ERANGE_FILL
#line 2141
    else
#line 2141
#endif
#line 2141
        xx = (ix_int64)*ip;
#line 2141

#line 2141
    put_ix_int64(xp, &xx);
#line 2141
    return err;
#line 2141
}
#line 2141



/* external NC_UINT64 -------------------------------------------------------*/

#if USHORT_MAX == X_UINT64_MAX
typedef ushort ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_USHORT
#define IX_UINT64_MAX USHORT_MAX
#elif ULONG_LONG_MAX  >= X_UINT64_MAX
typedef ulonglong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONGLONG
#define IX_UINT64_MAX ULONG_LONG_MAX
#elif ULONG_MAX  >= X_UINT64_MAX
typedef ulong ix_uint64;
#define SIZEOF_IX_UINT64 SIZEOF_ULONG
#define IX_UINT64_MAX ULONG_MAX
#else
#error "ix_uint64 implementation"
#endif


static void
get_ix_uint64(const void *xp, ix_uint64 *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((ix_uint64)(*cp++) << 56);
    *ip |= ((ix_uint64)(*cp++) << 48);
    *ip |= ((ix_uint64)(*cp++) << 40);
    *ip |= ((ix_uint64)(*cp++) << 32);
    *ip |= ((ix_uint64)(*cp++) << 24);
    *ip |= ((ix_uint64)(*cp++) << 16);
    *ip |= ((ix_uint64)(*cp++) <<  8);
    *ip |=  (ix_uint64)*cp;
}

static void
put_ix_uint64(void *xp, const ix_uint64 *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (uchar)((*ip) >> 56);
    *cp++ = (uchar)(((*ip) & 0x00ff000000000000ULL) >> 48);
    *cp++ = (uchar)(((*ip) & 0x0000ff0000000000ULL) >> 40);
    *cp++ = (uchar)(((*ip) & 0x000000ff00000000ULL) >> 32);
    *cp++ = (uchar)(((*ip) & 0x00000000ff000000ULL) >> 24);
    *cp++ = (uchar)(((*ip) & 0x0000000000ff0000ULL) >> 16);
    *cp++ = (uchar)(((*ip) & 0x000000000000ff00ULL) >>  8);
    *cp   = (uchar)( (*ip) & 0x00000000000000ffULL);
}

#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 2194
ncx_get_ulonglong_ulonglong(const void *xp, ulonglong *ip)
#line 2194
{
#line 2194
    int err=NC_NOERR;
#line 2194
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 2194
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2194
#else
#line 2194
    ix_uint64 xx;
#line 2194
    get_ix_uint64(xp, &xx);
#line 2194

#line 2194
#if IX_UINT64_MAX > ULONGLONG_MAX
#line 2194
    if (xx > ULONGLONG_MAX) {
#line 2194
#ifdef ERANGE_FILL
#line 2194
        *ip = NC_FILL_UINT64;
#line 2194
        return NC_ERANGE;
#line 2194
#else
#line 2194
        err = NC_ERANGE;
#line 2194
#endif
#line 2194
    }
#line 2194
#endif
#line 2194

#line 2194

#line 2194
    *ip = (ulonglong) xx;
#line 2194
#endif
#line 2194
    return err;
#line 2194
}
#line 2194

#endif
static int
#line 2196
ncx_get_ulonglong_schar(const void *xp, schar *ip)
#line 2196
{
#line 2196
    int err=NC_NOERR;
#line 2196
    ix_uint64 xx;
#line 2196
    get_ix_uint64(xp, &xx);
#line 2196

#line 2196
#if IX_UINT64_MAX > SCHAR_MAX
#line 2196
    if (xx > SCHAR_MAX) {
#line 2196
#ifdef ERANGE_FILL
#line 2196
        *ip = NC_FILL_BYTE;
#line 2196
        return NC_ERANGE;
#line 2196
#else
#line 2196
        err = NC_ERANGE;
#line 2196
#endif
#line 2196
    }
#line 2196
#endif
#line 2196

#line 2196

#line 2196
    *ip = (schar) xx;
#line 2196
    return err;
#line 2196
}
#line 2196

static int
#line 2197
ncx_get_ulonglong_short(const void *xp, short *ip)
#line 2197
{
#line 2197
    int err=NC_NOERR;
#line 2197
    ix_uint64 xx;
#line 2197
    get_ix_uint64(xp, &xx);
#line 2197

#line 2197
#if IX_UINT64_MAX > SHORT_MAX
#line 2197
    if (xx > SHORT_MAX) {
#line 2197
#ifdef ERANGE_FILL
#line 2197
        *ip = NC_FILL_SHORT;
#line 2197
        return NC_ERANGE;
#line 2197
#else
#line 2197
        err = NC_ERANGE;
#line 2197
#endif
#line 2197
    }
#line 2197
#endif
#line 2197

#line 2197

#line 2197
    *ip = (short) xx;
#line 2197
    return err;
#line 2197
}
#line 2197

static int
#line 2198
ncx_get_ulonglong_int(const void *xp, int *ip)
#line 2198
{
#line 2198
    int err=NC_NOERR;
#line 2198
    ix_uint64 xx;
#line 2198
    get_ix_uint64(xp, &xx);
#line 2198

#line 2198
#if IX_UINT64_MAX > INT_MAX
#line 2198
    if (xx > INT_MAX) {
#line 2198
#ifdef ERANGE_FILL
#line 2198
        *ip = NC_FILL_INT;
#line 2198
        return NC_ERANGE;
#line 2198
#else
#line 2198
        err = NC_ERANGE;
#line 2198
#endif
#line 2198
    }
#line 2198
#endif
#line 2198

#line 2198

#line 2198
    *ip = (int) xx;
#line 2198
    return err;
#line 2198
}
#line 2198

static int
#line 2199
ncx_get_ulonglong_long(const void *xp, long *ip)
#line 2199
{
#line 2199
    int err=NC_NOERR;
#line 2199
    ix_uint64 xx;
#line 2199
    get_ix_uint64(xp, &xx);
#line 2199

#line 2199
#if IX_UINT64_MAX > LONG_MAX
#line 2199
    if (xx > LONG_MAX) {
#line 2199
#ifdef ERANGE_FILL
#line 2199
        *ip = NC_FILL_INT;
#line 2199
        return NC_ERANGE;
#line 2199
#else
#line 2199
        err = NC_ERANGE;
#line 2199
#endif
#line 2199
    }
#line 2199
#endif
#line 2199

#line 2199

#line 2199
    *ip = (long) xx;
#line 2199
    return err;
#line 2199
}
#line 2199

static int
#line 2200
ncx_get_ulonglong_longlong(const void *xp, longlong *ip)
#line 2200
{
#line 2200
    int err=NC_NOERR;
#line 2200
    ix_uint64 xx;
#line 2200
    get_ix_uint64(xp, &xx);
#line 2200

#line 2200
#if IX_UINT64_MAX > LONGLONG_MAX
#line 2200
    if (xx > LONGLONG_MAX) {
#line 2200
#ifdef ERANGE_FILL
#line 2200
        *ip = NC_FILL_INT64;
#line 2200
        return NC_ERANGE;
#line 2200
#else
#line 2200
        err = NC_ERANGE;
#line 2200
#endif
#line 2200
    }
#line 2200
#endif
#line 2200

#line 2200

#line 2200
    *ip = (longlong) xx;
#line 2200
    return err;
#line 2200
}
#line 2200

static int
#line 2201
ncx_get_ulonglong_ushort(const void *xp, ushort *ip)
#line 2201
{
#line 2201
    int err=NC_NOERR;
#line 2201
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 2201
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2201
#else
#line 2201
    ix_uint64 xx;
#line 2201
    get_ix_uint64(xp, &xx);
#line 2201

#line 2201
#if IX_UINT64_MAX > USHORT_MAX
#line 2201
    if (xx > USHORT_MAX) {
#line 2201
#ifdef ERANGE_FILL
#line 2201
        *ip = NC_FILL_USHORT;
#line 2201
        return NC_ERANGE;
#line 2201
#else
#line 2201
        err = NC_ERANGE;
#line 2201
#endif
#line 2201
    }
#line 2201
#endif
#line 2201

#line 2201

#line 2201
    *ip = (ushort) xx;
#line 2201
#endif
#line 2201
    return err;
#line 2201
}
#line 2201

static int
#line 2202
ncx_get_ulonglong_uchar(const void *xp, uchar *ip)
#line 2202
{
#line 2202
    int err=NC_NOERR;
#line 2202
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 2202
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2202
#else
#line 2202
    ix_uint64 xx;
#line 2202
    get_ix_uint64(xp, &xx);
#line 2202

#line 2202
#if IX_UINT64_MAX > UCHAR_MAX
#line 2202
    if (xx > UCHAR_MAX) {
#line 2202
#ifdef ERANGE_FILL
#line 2202
        *ip = NC_FILL_UBYTE;
#line 2202
        return NC_ERANGE;
#line 2202
#else
#line 2202
        err = NC_ERANGE;
#line 2202
#endif
#line 2202
    }
#line 2202
#endif
#line 2202

#line 2202

#line 2202
    *ip = (uchar) xx;
#line 2202
#endif
#line 2202
    return err;
#line 2202
}
#line 2202

static int
#line 2203
ncx_get_ulonglong_uint(const void *xp, uint *ip)
#line 2203
{
#line 2203
    int err=NC_NOERR;
#line 2203
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 2203
    get_ix_uint64(xp, (ix_uint64 *)ip);
#line 2203
#else
#line 2203
    ix_uint64 xx;
#line 2203
    get_ix_uint64(xp, &xx);
#line 2203

#line 2203
#if IX_UINT64_MAX > UINT_MAX
#line 2203
    if (xx > UINT_MAX) {
#line 2203
#ifdef ERANGE_FILL
#line 2203
        *ip = NC_FILL_UINT;
#line 2203
        return NC_ERANGE;
#line 2203
#else
#line 2203
        err = NC_ERANGE;
#line 2203
#endif
#line 2203
    }
#line 2203
#endif
#line 2203

#line 2203

#line 2203
    *ip = (uint) xx;
#line 2203
#endif
#line 2203
    return err;
#line 2203
}
#line 2203

static int
#line 2204
ncx_get_ulonglong_float(const void *xp, float *ip)
#line 2204
{
#line 2204
	ix_uint64 xx;
#line 2204
	get_ix_uint64(xp, &xx);
#line 2204
	*ip = (float)xx;
#line 2204
	return NC_NOERR;
#line 2204
}
#line 2204

static int
#line 2205
ncx_get_ulonglong_double(const void *xp, double *ip)
#line 2205
{
#line 2205
	ix_uint64 xx;
#line 2205
	get_ix_uint64(xp, &xx);
#line 2205
	*ip = (double)xx;
#line 2205
	return NC_NOERR;
#line 2205
}
#line 2205


#if X_SIZEOF_UINT64 != SIZEOF_ULONGLONG
static int
#line 2208
ncx_put_ulonglong_ulonglong(void *xp, const ulonglong *ip, void *fillp)
#line 2208
{
#line 2208
    int err=NC_NOERR;
#line 2208
#if SIZEOF_IX_UINT64 == SIZEOF_ULONGLONG && IX_UINT64_MAX == ULONGLONG_MAX
#line 2208
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2208
#else
#line 2208
    ix_uint64 xx = NC_FILL_UINT64;
#line 2208

#line 2208
#if IX_UINT64_MAX < ULONGLONG_MAX
#line 2208
    if (*ip > IX_UINT64_MAX) {
#line 2208
        
#line 2208
#ifdef ERANGE_FILL
#line 2208
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2208
#endif
#line 2208
        err = NC_ERANGE;
#line 2208
    }
#line 2208
#ifdef ERANGE_FILL
#line 2208
    else
#line 2208
#endif
#line 2208
#endif
#line 2208
        xx = (ix_uint64)*ip;
#line 2208

#line 2208
    put_ix_uint64(xp, &xx);
#line 2208
#endif
#line 2208
    return err;
#line 2208
}
#line 2208

#endif
static int
#line 2210
ncx_put_ulonglong_schar(void *xp, const schar *ip, void *fillp)
#line 2210
{
#line 2210
    int err=NC_NOERR;
#line 2210
    ix_uint64 xx = NC_FILL_UINT64;
#line 2210

#line 2210
#if IX_UINT64_MAX < SCHAR_MAX
#line 2210
    if (*ip > IX_UINT64_MAX) {
#line 2210
        
#line 2210
#ifdef ERANGE_FILL
#line 2210
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2210
#endif
#line 2210
        err = NC_ERANGE;
#line 2210
    }
#line 2210
#ifdef ERANGE_FILL
#line 2210
    else
#line 2210
#endif
#line 2210
#endif
#line 2210
    if (*ip < 0) {
#line 2210
        
#line 2210
#ifdef ERANGE_FILL
#line 2210
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2210
#endif
#line 2210
        err = NC_ERANGE; /* because xp is unsigned */
#line 2210
    }
#line 2210
#ifdef ERANGE_FILL
#line 2210
    else
#line 2210
#endif
#line 2210
        xx = (ix_uint64)*ip;
#line 2210

#line 2210
    put_ix_uint64(xp, &xx);
#line 2210
    return err;
#line 2210
}
#line 2210

static int
#line 2211
ncx_put_ulonglong_short(void *xp, const short *ip, void *fillp)
#line 2211
{
#line 2211
    int err=NC_NOERR;
#line 2211
    ix_uint64 xx = NC_FILL_UINT64;
#line 2211

#line 2211
#if IX_UINT64_MAX < SHORT_MAX
#line 2211
    if (*ip > IX_UINT64_MAX) {
#line 2211
        
#line 2211
#ifdef ERANGE_FILL
#line 2211
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2211
#endif
#line 2211
        err = NC_ERANGE;
#line 2211
    }
#line 2211
#ifdef ERANGE_FILL
#line 2211
    else
#line 2211
#endif
#line 2211
#endif
#line 2211
    if (*ip < 0) {
#line 2211
        
#line 2211
#ifdef ERANGE_FILL
#line 2211
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2211
#endif
#line 2211
        err = NC_ERANGE; /* because xp is unsigned */
#line 2211
    }
#line 2211
#ifdef ERANGE_FILL
#line 2211
    else
#line 2211
#endif
#line 2211
        xx = (ix_uint64)*ip;
#line 2211

#line 2211
    put_ix_uint64(xp, &xx);
#line 2211
    return err;
#line 2211
}
#line 2211

static int
#line 2212
ncx_put_ulonglong_int(void *xp, const int *ip, void *fillp)
#line 2212
{
#line 2212
    int err=NC_NOERR;
#line 2212
    ix_uint64 xx = NC_FILL_UINT64;
#line 2212

#line 2212
#if IX_UINT64_MAX < INT_MAX
#line 2212
    if (*ip > IX_UINT64_MAX) {
#line 2212
        
#line 2212
#ifdef ERANGE_FILL
#line 2212
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2212
#endif
#line 2212
        err = NC_ERANGE;
#line 2212
    }
#line 2212
#ifdef ERANGE_FILL
#line 2212
    else
#line 2212
#endif
#line 2212
#endif
#line 2212
    if (*ip < 0) {
#line 2212
        
#line 2212
#ifdef ERANGE_FILL
#line 2212
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2212
#endif
#line 2212
        err = NC_ERANGE; /* because xp is unsigned */
#line 2212
    }
#line 2212
#ifdef ERANGE_FILL
#line 2212
    else
#line 2212
#endif
#line 2212
        xx = (ix_uint64)*ip;
#line 2212

#line 2212
    put_ix_uint64(xp, &xx);
#line 2212
    return err;
#line 2212
}
#line 2212

static int
#line 2213
ncx_put_ulonglong_long(void *xp, const long *ip, void *fillp)
#line 2213
{
#line 2213
    int err=NC_NOERR;
#line 2213
    ix_uint64 xx = NC_FILL_UINT64;
#line 2213

#line 2213
#if IX_UINT64_MAX < LONG_MAX
#line 2213
    if (*ip > IX_UINT64_MAX) {
#line 2213
        
#line 2213
#ifdef ERANGE_FILL
#line 2213
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2213
#endif
#line 2213
        err = NC_ERANGE;
#line 2213
    }
#line 2213
#ifdef ERANGE_FILL
#line 2213
    else
#line 2213
#endif
#line 2213
#endif
#line 2213
    if (*ip < 0) {
#line 2213
        
#line 2213
#ifdef ERANGE_FILL
#line 2213
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2213
#endif
#line 2213
        err = NC_ERANGE; /* because xp is unsigned */
#line 2213
    }
#line 2213
#ifdef ERANGE_FILL
#line 2213
    else
#line 2213
#endif
#line 2213
        xx = (ix_uint64)*ip;
#line 2213

#line 2213
    put_ix_uint64(xp, &xx);
#line 2213
    return err;
#line 2213
}
#line 2213

static int
#line 2214
ncx_put_ulonglong_longlong(void *xp, const longlong *ip, void *fillp)
#line 2214
{
#line 2214
    int err=NC_NOERR;
#line 2214
    ix_uint64 xx = NC_FILL_UINT64;
#line 2214

#line 2214
#if IX_UINT64_MAX < LONGLONG_MAX
#line 2214
    if (*ip > IX_UINT64_MAX) {
#line 2214
        
#line 2214
#ifdef ERANGE_FILL
#line 2214
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2214
#endif
#line 2214
        err = NC_ERANGE;
#line 2214
    }
#line 2214
#ifdef ERANGE_FILL
#line 2214
    else
#line 2214
#endif
#line 2214
#endif
#line 2214
    if (*ip < 0) {
#line 2214
        
#line 2214
#ifdef ERANGE_FILL
#line 2214
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2214
#endif
#line 2214
        err = NC_ERANGE; /* because xp is unsigned */
#line 2214
    }
#line 2214
#ifdef ERANGE_FILL
#line 2214
    else
#line 2214
#endif
#line 2214
        xx = (ix_uint64)*ip;
#line 2214

#line 2214
    put_ix_uint64(xp, &xx);
#line 2214
    return err;
#line 2214
}
#line 2214

static int
#line 2215
ncx_put_ulonglong_uchar(void *xp, const uchar *ip, void *fillp)
#line 2215
{
#line 2215
    int err=NC_NOERR;
#line 2215
#if SIZEOF_IX_UINT64 == SIZEOF_UCHAR && IX_UINT64_MAX == UCHAR_MAX
#line 2215
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2215
#else
#line 2215
    ix_uint64 xx = NC_FILL_UINT64;
#line 2215

#line 2215
#if IX_UINT64_MAX < UCHAR_MAX
#line 2215
    if (*ip > IX_UINT64_MAX) {
#line 2215
        
#line 2215
#ifdef ERANGE_FILL
#line 2215
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2215
#endif
#line 2215
        err = NC_ERANGE;
#line 2215
    }
#line 2215
#ifdef ERANGE_FILL
#line 2215
    else
#line 2215
#endif
#line 2215
#endif
#line 2215
        xx = (ix_uint64)*ip;
#line 2215

#line 2215
    put_ix_uint64(xp, &xx);
#line 2215
#endif
#line 2215
    return err;
#line 2215
}
#line 2215

static int
#line 2216
ncx_put_ulonglong_ushort(void *xp, const ushort *ip, void *fillp)
#line 2216
{
#line 2216
    int err=NC_NOERR;
#line 2216
#if SIZEOF_IX_UINT64 == SIZEOF_USHORT && IX_UINT64_MAX == USHORT_MAX
#line 2216
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2216
#else
#line 2216
    ix_uint64 xx = NC_FILL_UINT64;
#line 2216

#line 2216
#if IX_UINT64_MAX < USHORT_MAX
#line 2216
    if (*ip > IX_UINT64_MAX) {
#line 2216
        
#line 2216
#ifdef ERANGE_FILL
#line 2216
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2216
#endif
#line 2216
        err = NC_ERANGE;
#line 2216
    }
#line 2216
#ifdef ERANGE_FILL
#line 2216
    else
#line 2216
#endif
#line 2216
#endif
#line 2216
        xx = (ix_uint64)*ip;
#line 2216

#line 2216
    put_ix_uint64(xp, &xx);
#line 2216
#endif
#line 2216
    return err;
#line 2216
}
#line 2216

static int
#line 2217
ncx_put_ulonglong_uint(void *xp, const uint *ip, void *fillp)
#line 2217
{
#line 2217
    int err=NC_NOERR;
#line 2217
#if SIZEOF_IX_UINT64 == SIZEOF_UINT && IX_UINT64_MAX == UINT_MAX
#line 2217
    put_ix_uint64(xp, (const ix_uint64 *)ip);
#line 2217
#else
#line 2217
    ix_uint64 xx = NC_FILL_UINT64;
#line 2217

#line 2217
#if IX_UINT64_MAX < UINT_MAX
#line 2217
    if (*ip > IX_UINT64_MAX) {
#line 2217
        
#line 2217
#ifdef ERANGE_FILL
#line 2217
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2217
#endif
#line 2217
        err = NC_ERANGE;
#line 2217
    }
#line 2217
#ifdef ERANGE_FILL
#line 2217
    else
#line 2217
#endif
#line 2217
#endif
#line 2217
        xx = (ix_uint64)*ip;
#line 2217

#line 2217
    put_ix_uint64(xp, &xx);
#line 2217
#endif
#line 2217
    return err;
#line 2217
}
#line 2217

static int
#line 2218
ncx_put_ulonglong_float(void *xp, const float *ip, void *fillp)
#line 2218
{
#line 2218
    int err=NC_NOERR;
#line 2218
    ix_uint64 xx = NC_FILL_UINT64;
#line 2218

#line 2218
    if (*ip > (double)X_UINT64_MAX || *ip < 0) {
#line 2218
        
#line 2218
#ifdef ERANGE_FILL
#line 2218
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2218
#endif
#line 2218
        err = NC_ERANGE;
#line 2218
    }
#line 2218
#ifdef ERANGE_FILL
#line 2218
    else
#line 2218
#endif
#line 2218
        xx = (ix_uint64)*ip;
#line 2218

#line 2218
    put_ix_uint64(xp, &xx);
#line 2218
    return err;
#line 2218
}
#line 2218

static int
#line 2219
ncx_put_ulonglong_double(void *xp, const double *ip, void *fillp)
#line 2219
{
#line 2219
    int err=NC_NOERR;
#line 2219
    ix_uint64 xx = NC_FILL_UINT64;
#line 2219

#line 2219
    if (*ip > X_UINT64_MAX || *ip < 0) {
#line 2219
        
#line 2219
#ifdef ERANGE_FILL
#line 2219
            if (fillp != NULL) memcpy(&xx, fillp, 8);
#line 2219
#endif
#line 2219
        err = NC_ERANGE;
#line 2219
    }
#line 2219
#ifdef ERANGE_FILL
#line 2219
    else
#line 2219
#endif
#line 2219
        xx = (ix_uint64)*ip;
#line 2219

#line 2219
    put_ix_uint64(xp, &xx);
#line 2219
    return err;
#line 2219
}
#line 2219



/* x_size_t */

#if SIZEOF_SIZE_T < X_SIZEOF_SIZE_T
#error "x_size_t implementation"
/* netcdf requires size_t which can hold a values from 0 to 2^32 -1 */
#endif

int
ncx_put_size_t(void **xpp, const size_t *ulp)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
	assert(*ulp <= X_SIZE_MAX);

	*cp++ = (uchar)((*ulp) >> 24);
	*cp++ = (uchar)(((*ulp) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ulp) & 0x0000ff00) >>  8);
	*cp   = (uchar)((*ulp) & 0x000000ff);

	*xpp = (void *)((char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

int
ncx_get_size_t(const void **xpp,  size_t *ulp)
{
	/* similar to get_ix_int */
	const uchar *cp = (const uchar *) *xpp;

	*ulp  = (unsigned)(*cp++) << 24;
	*ulp |= (*cp++ << 16);
	*ulp |= (*cp++ << 8);
	*ulp |= *cp;

	*xpp = (const void *)((const char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

/* x_off_t */

int
ncx_put_off_t(void **xpp, const off_t *lp, size_t sizeof_off_t)
{
	/* No negative offsets stored in netcdf */
	if (*lp < 0) {
	  /* Assume this is an overflow of a 32-bit int... */
	  return NC_ERANGE;
	}

	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;

	if (sizeof_off_t == 4) {
		*cp++ = (uchar) ((*lp)               >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
	} else {
#if SIZEOF_OFF_T == 4
/* Write a 64-bit offset on a system with only a 32-bit offset */
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;

		*cp++ = (uchar)(((*lp) & 0xff000000) >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
#else
		*cp++ = (uchar) ((*lp)                          >> 56);
		*cp++ = (uchar)(((*lp) & 0x00ff000000000000LL) >> 48);
		*cp++ = (uchar)(((*lp) & 0x0000ff0000000000LL) >> 40);
		*cp++ = (uchar)(((*lp) & 0x000000ff00000000LL) >> 32);
		*cp++ = (uchar)(((*lp) & 0x00000000ff000000LL) >> 24);
		*cp++ = (uchar)(((*lp) & 0x0000000000ff0000LL) >> 16);
		*cp++ = (uchar)(((*lp) & 0x000000000000ff00LL) >>  8);
		*cp   = (uchar)( (*lp) & 0x00000000000000ffLL);
#endif
	}
	*xpp = (void *)((char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

int
ncx_get_off_t(const void **xpp, off_t *lp, size_t sizeof_off_t)
{
	/* similar to get_ix_int() */
	const uchar *cp = (const uchar *) *xpp;
	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

 	if (sizeof_off_t == 4) {
		*lp =  (off_t)(*cp++ << 24);
		*lp |= (off_t)(*cp++ << 16);
		*lp |= (off_t)(*cp++ <<  8);
		*lp |= (off_t)*cp;
	} else {
#if SIZEOF_OFF_T == 4
/* Read a 64-bit offset on a system with only a 32-bit offset */
/* If the offset overflows, set an error code and return */
		*lp =  ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |= ((off_t)(*cp++));
/*
 * lp now contains the upper 32-bits of the 64-bit offset.  if lp is
 * not zero, then the dataset is larger than can be represented
 * on this system.  Set an error code and return.
 */
		if (*lp != 0) {
		  return NC_ERANGE;
		}

		*lp  = ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;

		if (*lp < 0) {
		  /*
		   * If this fails, then the offset is >2^31, but less
		   * than 2^32 which is not allowed, but is not caught
		   * by the previous check
		   */
		  return NC_ERANGE;
		}
#else
		*lp =  ((off_t)(*cp++) << 56);
		*lp |= ((off_t)(*cp++) << 48);
		*lp |= ((off_t)(*cp++) << 40);
		*lp |= ((off_t)(*cp++) << 32);
		*lp |= ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;
#endif
	}
	*xpp = (const void *)((const char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

/*----< ncx_get_uint32() >------------------------------------------*/
int
ncx_get_uint32(const void **xpp, uint *ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ip, *xpp, SIZEOF_UINT);
#else
    const uchar *cp = (const uchar *) *xpp;

    *ip = (uint)(*cp++ << 24);
    *ip = (uint)(*ip | (uint)(*cp++ << 16));
    *ip = (uint)(*ip | (uint)(*cp++ <<  8));
    *ip = (uint)(*ip | *cp);
#endif
    /* advance *xpp 4 bytes */
    *xpp = (void *)((const char *)(*xpp) + 4);

    return NC_NOERR;
}

/*----< ncx_get_uint64() >------------------------------------------*/
int
ncx_get_uint64(const void **xpp, unsigned long long *ullp)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(ullp, *xpp, SIZEOF_UINT64);
#else
    const uchar *cp = (const uchar *) *xpp;

    /* below is the same as calling swap8b(ullp, *xpp) */
    *ullp = (unsigned long long)(*cp++) << 56;
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 48);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 40);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 32);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 24);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) << 16);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp++) <<  8);
    *ullp = (unsigned long long)(*ullp | (unsigned long long)(*cp));
#endif
    /* advance *xpp 8 bytes */
    *xpp = (void *)((const char *)(*xpp) + 8);

    return NC_NOERR;
}

/*---< ncx_put_uint32() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 32-bit integer) to xpp in Big Endian
 * form and advance *xpp 4 bytes
 */
int
ncx_put_uint32(void **xpp, const unsigned int ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT);
#else
    /* bitwise shifts below are to produce an integer in Big Endian */
    uchar *cp = (uchar *) *xpp;
    *cp++ = (uchar)((ip & 0xff000000) >> 24);
    *cp++ = (uchar)((ip & 0x00ff0000) >> 16);
    *cp++ = (uchar)((ip & 0x0000ff00) >>  8);
    *cp   = (uchar)( ip & 0x000000ff);
#endif
    /* advance *xpp 4 bytes */
    *xpp  = (void *)((char *)(*xpp) + 4);

    return NC_NOERR;
}

/*---< ncx_put_uint64() >-------------------------------------------*/
/* copy the contents of ip (an unsigned 64-bit integer) to xpp in Big Endian
 * form and advance *xpp 8 bytes
 */
int
ncx_put_uint64(void **xpp, const unsigned long long ip)
{
#ifdef WORDS_BIGENDIAN
    /* use memcpy instead of assignment to avoid BUS_ADRALN alignment error on
     * some system, such as HPUX */
    (void) memcpy(*xpp, &ip, X_SIZEOF_UINT64);
#else
    uchar *cp = (uchar *) *xpp;
    /* below is the same as calling swap8b(*xpp, &ip) */
    *cp++ = (uchar) (ip                         >> 56);
    *cp++ = (uchar)((ip & 0x00ff000000000000LL) >> 48);
    *cp++ = (uchar)((ip & 0x0000ff0000000000LL) >> 40);
    *cp++ = (uchar)((ip & 0x000000ff00000000LL) >> 32);
    *cp++ = (uchar)((ip & 0x00000000ff000000LL) >> 24);
    *cp++ = (uchar)((ip & 0x0000000000ff0000LL) >> 16);
    *cp++ = (uchar)((ip & 0x000000000000ff00LL) >>  8);
    *cp   = (uchar) (ip & 0x00000000000000ffLL);
#endif
    /* advance *xpp 8 bytes */
    *xpp  = (void *)((char *)(*xpp) + 8);

    return NC_NOERR;
}


/*
 * Aggregate numeric conversion functions.
 */
#line 2475

#line 2878

#line 2884

/* schar ---------------------------------------------------------------------*/

#line 2888
int
ncx_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2891
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2891
	return NC_NOERR;
#line 2891

}
int
#line 2893
ncx_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2893
{
#line 2893
    int status = NC_NOERR;
#line 2893
    schar *xp = (schar *)(*xpp);
#line 2893

#line 2893
    while (nelems-- != 0) {
#line 2893
        
#line 2893
        if (*xp < 0) {
#line 2893
#ifdef ERANGE_FILL
#line 2893
            *tp = NC_FILL_UBYTE;
#line 2893
#endif
#line 2893
            status = NC_ERANGE; /* because tp is unsigned */
#line 2893
            
#line 2893
#ifdef ERANGE_FILL
#line 2893
            xp++; tp++; continue;
#line 2893
#endif
#line 2893
        }
#line 2893
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2893
    }
#line 2893

#line 2893
    *xpp = (const void *)xp;
#line 2893
    return status;
#line 2893
}
#line 2893

int
#line 2894
ncx_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2894
{
#line 2894
    int status = NC_NOERR;
#line 2894
    schar *xp = (schar *)(*xpp);
#line 2894

#line 2894
    while (nelems-- != 0) {
#line 2894
        
#line 2894
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2894
    }
#line 2894

#line 2894
    *xpp = (const void *)xp;
#line 2894
    return status;
#line 2894
}
#line 2894

int
#line 2895
ncx_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2895
{
#line 2895
    int status = NC_NOERR;
#line 2895
    schar *xp = (schar *)(*xpp);
#line 2895

#line 2895
    while (nelems-- != 0) {
#line 2895
        
#line 2895
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2895
    }
#line 2895

#line 2895
    *xpp = (const void *)xp;
#line 2895
    return status;
#line 2895
}
#line 2895

int
#line 2896
ncx_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2896
{
#line 2896
    int status = NC_NOERR;
#line 2896
    schar *xp = (schar *)(*xpp);
#line 2896

#line 2896
    while (nelems-- != 0) {
#line 2896
        
#line 2896
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2896
    }
#line 2896

#line 2896
    *xpp = (const void *)xp;
#line 2896
    return status;
#line 2896
}
#line 2896

int
#line 2897
ncx_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2897
{
#line 2897
    int status = NC_NOERR;
#line 2897
    schar *xp = (schar *)(*xpp);
#line 2897

#line 2897
    while (nelems-- != 0) {
#line 2897
        
#line 2897
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2897
    }
#line 2897

#line 2897
    *xpp = (const void *)xp;
#line 2897
    return status;
#line 2897
}
#line 2897

int
#line 2898
ncx_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2898
{
#line 2898
    int status = NC_NOERR;
#line 2898
    schar *xp = (schar *)(*xpp);
#line 2898

#line 2898
    while (nelems-- != 0) {
#line 2898
        
#line 2898
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2898
    }
#line 2898

#line 2898
    *xpp = (const void *)xp;
#line 2898
    return status;
#line 2898
}
#line 2898

int
#line 2899
ncx_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2899
{
#line 2899
    int status = NC_NOERR;
#line 2899
    schar *xp = (schar *)(*xpp);
#line 2899

#line 2899
    while (nelems-- != 0) {
#line 2899
        
#line 2899
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2899
    }
#line 2899

#line 2899
    *xpp = (const void *)xp;
#line 2899
    return status;
#line 2899
}
#line 2899

int
#line 2900
ncx_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2900
{
#line 2900
    int status = NC_NOERR;
#line 2900
    schar *xp = (schar *)(*xpp);
#line 2900

#line 2900
    while (nelems-- != 0) {
#line 2900
        
#line 2900
        if (*xp < 0) {
#line 2900
#ifdef ERANGE_FILL
#line 2900
            *tp = NC_FILL_USHORT;
#line 2900
#endif
#line 2900
            status = NC_ERANGE; /* because tp is unsigned */
#line 2900
            
#line 2900
#ifdef ERANGE_FILL
#line 2900
            xp++; tp++; continue;
#line 2900
#endif
#line 2900
        }
#line 2900
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2900
    }
#line 2900

#line 2900
    *xpp = (const void *)xp;
#line 2900
    return status;
#line 2900
}
#line 2900

int
#line 2901
ncx_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2901
{
#line 2901
    int status = NC_NOERR;
#line 2901
    schar *xp = (schar *)(*xpp);
#line 2901

#line 2901
    while (nelems-- != 0) {
#line 2901
        
#line 2901
        if (*xp < 0) {
#line 2901
#ifdef ERANGE_FILL
#line 2901
            *tp = NC_FILL_UINT;
#line 2901
#endif
#line 2901
            status = NC_ERANGE; /* because tp is unsigned */
#line 2901
            
#line 2901
#ifdef ERANGE_FILL
#line 2901
            xp++; tp++; continue;
#line 2901
#endif
#line 2901
        }
#line 2901
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2901
    }
#line 2901

#line 2901
    *xpp = (const void *)xp;
#line 2901
    return status;
#line 2901
}
#line 2901

int
#line 2902
ncx_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2902
{
#line 2902
    int status = NC_NOERR;
#line 2902
    schar *xp = (schar *)(*xpp);
#line 2902

#line 2902
    while (nelems-- != 0) {
#line 2902
        
#line 2902
        if (*xp < 0) {
#line 2902
#ifdef ERANGE_FILL
#line 2902
            *tp = NC_FILL_UINT64;
#line 2902
#endif
#line 2902
            status = NC_ERANGE; /* because tp is unsigned */
#line 2902
            
#line 2902
#ifdef ERANGE_FILL
#line 2902
            xp++; tp++; continue;
#line 2902
#endif
#line 2902
        }
#line 2902
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2902
    }
#line 2902

#line 2902
    *xpp = (const void *)xp;
#line 2902
    return status;
#line 2902
}
#line 2902


#line 2905
int
ncx_pad_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2908

#line 2908
	if (rndup)
#line 2908
		rndup = X_ALIGN - rndup;
#line 2908

#line 2908
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2908
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2908

#line 2908
	return NC_NOERR;
#line 2908

}
int
#line 2910
ncx_pad_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2910
{
#line 2910
    int status = NC_NOERR;
#line 2910
    size_t rndup = nelems % X_ALIGN;
#line 2910
    schar *xp = (schar *) *xpp;
#line 2910

#line 2910
    if (rndup)
#line 2910
        rndup = X_ALIGN - rndup;
#line 2910

#line 2910
    while (nelems-- != 0) {
#line 2910
        
#line 2910
        if (*xp < 0) {
#line 2910
#ifdef ERANGE_FILL
#line 2910
            *tp = NC_FILL_UBYTE;
#line 2910
#endif
#line 2910
            status = NC_ERANGE; /* because tp is unsigned */
#line 2910
            
#line 2910
#ifdef ERANGE_FILL
#line 2910
            xp++; tp++; continue;
#line 2910
#endif
#line 2910
        }
#line 2910
        *tp++ = (uchar) (signed) (*xp++);  /* type cast from schar to uchar */
#line 2910
    }
#line 2910

#line 2910
    *xpp = (void *)(xp + rndup);
#line 2910
    return status;
#line 2910
}
#line 2910

int
#line 2911
ncx_pad_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2911
{
#line 2911
    int status = NC_NOERR;
#line 2911
    size_t rndup = nelems % X_ALIGN;
#line 2911
    schar *xp = (schar *) *xpp;
#line 2911

#line 2911
    if (rndup)
#line 2911
        rndup = X_ALIGN - rndup;
#line 2911

#line 2911
    while (nelems-- != 0) {
#line 2911
        
#line 2911
        *tp++ = (short)  (*xp++);  /* type cast from schar to short */
#line 2911
    }
#line 2911

#line 2911
    *xpp = (void *)(xp + rndup);
#line 2911
    return status;
#line 2911
}
#line 2911

int
#line 2912
ncx_pad_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2912
{
#line 2912
    int status = NC_NOERR;
#line 2912
    size_t rndup = nelems % X_ALIGN;
#line 2912
    schar *xp = (schar *) *xpp;
#line 2912

#line 2912
    if (rndup)
#line 2912
        rndup = X_ALIGN - rndup;
#line 2912

#line 2912
    while (nelems-- != 0) {
#line 2912
        
#line 2912
        *tp++ = (int)  (*xp++);  /* type cast from schar to int */
#line 2912
    }
#line 2912

#line 2912
    *xpp = (void *)(xp + rndup);
#line 2912
    return status;
#line 2912
}
#line 2912

int
#line 2913
ncx_pad_getn_schar_long(const void **xpp, size_t nelems, long *tp)
#line 2913
{
#line 2913
    int status = NC_NOERR;
#line 2913
    size_t rndup = nelems % X_ALIGN;
#line 2913
    schar *xp = (schar *) *xpp;
#line 2913

#line 2913
    if (rndup)
#line 2913
        rndup = X_ALIGN - rndup;
#line 2913

#line 2913
    while (nelems-- != 0) {
#line 2913
        
#line 2913
        *tp++ = (long)  (*xp++);  /* type cast from schar to long */
#line 2913
    }
#line 2913

#line 2913
    *xpp = (void *)(xp + rndup);
#line 2913
    return status;
#line 2913
}
#line 2913

int
#line 2914
ncx_pad_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2914
{
#line 2914
    int status = NC_NOERR;
#line 2914
    size_t rndup = nelems % X_ALIGN;
#line 2914
    schar *xp = (schar *) *xpp;
#line 2914

#line 2914
    if (rndup)
#line 2914
        rndup = X_ALIGN - rndup;
#line 2914

#line 2914
    while (nelems-- != 0) {
#line 2914
        
#line 2914
        *tp++ = (float)  (*xp++);  /* type cast from schar to float */
#line 2914
    }
#line 2914

#line 2914
    *xpp = (void *)(xp + rndup);
#line 2914
    return status;
#line 2914
}
#line 2914

int
#line 2915
ncx_pad_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2915
{
#line 2915
    int status = NC_NOERR;
#line 2915
    size_t rndup = nelems % X_ALIGN;
#line 2915
    schar *xp = (schar *) *xpp;
#line 2915

#line 2915
    if (rndup)
#line 2915
        rndup = X_ALIGN - rndup;
#line 2915

#line 2915
    while (nelems-- != 0) {
#line 2915
        
#line 2915
        *tp++ = (double)  (*xp++);  /* type cast from schar to double */
#line 2915
    }
#line 2915

#line 2915
    *xpp = (void *)(xp + rndup);
#line 2915
    return status;
#line 2915
}
#line 2915

int
#line 2916
ncx_pad_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2916
{
#line 2916
    int status = NC_NOERR;
#line 2916
    size_t rndup = nelems % X_ALIGN;
#line 2916
    schar *xp = (schar *) *xpp;
#line 2916

#line 2916
    if (rndup)
#line 2916
        rndup = X_ALIGN - rndup;
#line 2916

#line 2916
    while (nelems-- != 0) {
#line 2916
        
#line 2916
        *tp++ = (longlong)  (*xp++);  /* type cast from schar to longlong */
#line 2916
    }
#line 2916

#line 2916
    *xpp = (void *)(xp + rndup);
#line 2916
    return status;
#line 2916
}
#line 2916

int
#line 2917
ncx_pad_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2917
{
#line 2917
    int status = NC_NOERR;
#line 2917
    size_t rndup = nelems % X_ALIGN;
#line 2917
    schar *xp = (schar *) *xpp;
#line 2917

#line 2917
    if (rndup)
#line 2917
        rndup = X_ALIGN - rndup;
#line 2917

#line 2917
    while (nelems-- != 0) {
#line 2917
        
#line 2917
        if (*xp < 0) {
#line 2917
#ifdef ERANGE_FILL
#line 2917
            *tp = NC_FILL_USHORT;
#line 2917
#endif
#line 2917
            status = NC_ERANGE; /* because tp is unsigned */
#line 2917
            
#line 2917
#ifdef ERANGE_FILL
#line 2917
            xp++; tp++; continue;
#line 2917
#endif
#line 2917
        }
#line 2917
        *tp++ = (ushort) (signed) (*xp++);  /* type cast from schar to ushort */
#line 2917
    }
#line 2917

#line 2917
    *xpp = (void *)(xp + rndup);
#line 2917
    return status;
#line 2917
}
#line 2917

int
#line 2918
ncx_pad_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2918
{
#line 2918
    int status = NC_NOERR;
#line 2918
    size_t rndup = nelems % X_ALIGN;
#line 2918
    schar *xp = (schar *) *xpp;
#line 2918

#line 2918
    if (rndup)
#line 2918
        rndup = X_ALIGN - rndup;
#line 2918

#line 2918
    while (nelems-- != 0) {
#line 2918
        
#line 2918
        if (*xp < 0) {
#line 2918
#ifdef ERANGE_FILL
#line 2918
            *tp = NC_FILL_UINT;
#line 2918
#endif
#line 2918
            status = NC_ERANGE; /* because tp is unsigned */
#line 2918
            
#line 2918
#ifdef ERANGE_FILL
#line 2918
            xp++; tp++; continue;
#line 2918
#endif
#line 2918
        }
#line 2918
        *tp++ = (uint) (signed) (*xp++);  /* type cast from schar to uint */
#line 2918
    }
#line 2918

#line 2918
    *xpp = (void *)(xp + rndup);
#line 2918
    return status;
#line 2918
}
#line 2918

int
#line 2919
ncx_pad_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2919
{
#line 2919
    int status = NC_NOERR;
#line 2919
    size_t rndup = nelems % X_ALIGN;
#line 2919
    schar *xp = (schar *) *xpp;
#line 2919

#line 2919
    if (rndup)
#line 2919
        rndup = X_ALIGN - rndup;
#line 2919

#line 2919
    while (nelems-- != 0) {
#line 2919
        
#line 2919
        if (*xp < 0) {
#line 2919
#ifdef ERANGE_FILL
#line 2919
            *tp = NC_FILL_UINT64;
#line 2919
#endif
#line 2919
            status = NC_ERANGE; /* because tp is unsigned */
#line 2919
            
#line 2919
#ifdef ERANGE_FILL
#line 2919
            xp++; tp++; continue;
#line 2919
#endif
#line 2919
        }
#line 2919
        *tp++ = (ulonglong) (signed) (*xp++);  /* type cast from schar to ulonglong */
#line 2919
    }
#line 2919

#line 2919
    *xpp = (void *)(xp + rndup);
#line 2919
    return status;
#line 2919
}
#line 2919


#line 2922
int
ncx_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2925
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2925

#line 2925
	return NC_NOERR;
#line 2925

}
int
#line 2927
ncx_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2927
{
#line 2927
    int status = NC_NOERR;
#line 2927
    schar *xp = (schar *) *xpp;
#line 2927

#line 2927
    while (nelems-- != 0) {
#line 2927
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2927
            
#line 2927
#ifdef ERANGE_FILL
#line 2927
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2927
#endif
#line 2927
            status = NC_ERANGE;
#line 2927
            
#line 2927
#ifdef ERANGE_FILL
#line 2927
            xp++; tp++; continue;
#line 2927
#endif
#line 2927
        }
#line 2927
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2927
    }
#line 2927

#line 2927
    *xpp = (void *)xp;
#line 2927
    return status;
#line 2927
}
#line 2927

int
#line 2928
ncx_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2928
{
#line 2928
    int status = NC_NOERR;
#line 2928
    schar *xp = (schar *) *xpp;
#line 2928

#line 2928
    while (nelems-- != 0) {
#line 2928
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2928
            
#line 2928
#ifdef ERANGE_FILL
#line 2928
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2928
#endif
#line 2928
            status = NC_ERANGE;
#line 2928
            
#line 2928
#ifdef ERANGE_FILL
#line 2928
            xp++; tp++; continue;
#line 2928
#endif
#line 2928
        }
#line 2928
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2928
    }
#line 2928

#line 2928
    *xpp = (void *)xp;
#line 2928
    return status;
#line 2928
}
#line 2928

int
#line 2929
ncx_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2929
{
#line 2929
    int status = NC_NOERR;
#line 2929
    schar *xp = (schar *) *xpp;
#line 2929

#line 2929
    while (nelems-- != 0) {
#line 2929
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2929
            
#line 2929
#ifdef ERANGE_FILL
#line 2929
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2929
#endif
#line 2929
            status = NC_ERANGE;
#line 2929
            
#line 2929
#ifdef ERANGE_FILL
#line 2929
            xp++; tp++; continue;
#line 2929
#endif
#line 2929
        }
#line 2929
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2929
    }
#line 2929

#line 2929
    *xpp = (void *)xp;
#line 2929
    return status;
#line 2929
}
#line 2929

int
#line 2930
ncx_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2930
{
#line 2930
    int status = NC_NOERR;
#line 2930
    schar *xp = (schar *) *xpp;
#line 2930

#line 2930
    while (nelems-- != 0) {
#line 2930
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2930
            
#line 2930
#ifdef ERANGE_FILL
#line 2930
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2930
#endif
#line 2930
            status = NC_ERANGE;
#line 2930
            
#line 2930
#ifdef ERANGE_FILL
#line 2930
            xp++; tp++; continue;
#line 2930
#endif
#line 2930
        }
#line 2930
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2930
    }
#line 2930

#line 2930
    *xpp = (void *)xp;
#line 2930
    return status;
#line 2930
}
#line 2930

int
#line 2931
ncx_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2931
{
#line 2931
    int status = NC_NOERR;
#line 2931
    schar *xp = (schar *) *xpp;
#line 2931

#line 2931
    while (nelems-- != 0) {
#line 2931
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2931
            
#line 2931
#ifdef ERANGE_FILL
#line 2931
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2931
#endif
#line 2931
            status = NC_ERANGE;
#line 2931
            
#line 2931
#ifdef ERANGE_FILL
#line 2931
            xp++; tp++; continue;
#line 2931
#endif
#line 2931
        }
#line 2931
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2931
    }
#line 2931

#line 2931
    *xpp = (void *)xp;
#line 2931
    return status;
#line 2931
}
#line 2931

int
#line 2932
ncx_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2932
{
#line 2932
    int status = NC_NOERR;
#line 2932
    schar *xp = (schar *) *xpp;
#line 2932

#line 2932
    while (nelems-- != 0) {
#line 2932
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2932
            
#line 2932
#ifdef ERANGE_FILL
#line 2932
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2932
#endif
#line 2932
            status = NC_ERANGE;
#line 2932
            
#line 2932
#ifdef ERANGE_FILL
#line 2932
            xp++; tp++; continue;
#line 2932
#endif
#line 2932
        }
#line 2932
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2932
    }
#line 2932

#line 2932
    *xpp = (void *)xp;
#line 2932
    return status;
#line 2932
}
#line 2932

int
#line 2933
ncx_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2933
{
#line 2933
    int status = NC_NOERR;
#line 2933
    schar *xp = (schar *) *xpp;
#line 2933

#line 2933
    while (nelems-- != 0) {
#line 2933
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2933
            
#line 2933
#ifdef ERANGE_FILL
#line 2933
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2933
#endif
#line 2933
            status = NC_ERANGE;
#line 2933
            
#line 2933
#ifdef ERANGE_FILL
#line 2933
            xp++; tp++; continue;
#line 2933
#endif
#line 2933
        }
#line 2933
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2933
    }
#line 2933

#line 2933
    *xpp = (void *)xp;
#line 2933
    return status;
#line 2933
}
#line 2933

int
#line 2934
ncx_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2934
{
#line 2934
    int status = NC_NOERR;
#line 2934
    schar *xp = (schar *) *xpp;
#line 2934

#line 2934
    while (nelems-- != 0) {
#line 2934
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2934
            
#line 2934
#ifdef ERANGE_FILL
#line 2934
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2934
#endif
#line 2934
            status = NC_ERANGE;
#line 2934
            
#line 2934
#ifdef ERANGE_FILL
#line 2934
            xp++; tp++; continue;
#line 2934
#endif
#line 2934
        }
#line 2934
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2934
    }
#line 2934

#line 2934
    *xpp = (void *)xp;
#line 2934
    return status;
#line 2934
}
#line 2934

int
#line 2935
ncx_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2935
{
#line 2935
    int status = NC_NOERR;
#line 2935
    schar *xp = (schar *) *xpp;
#line 2935

#line 2935
    while (nelems-- != 0) {
#line 2935
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2935
            
#line 2935
#ifdef ERANGE_FILL
#line 2935
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2935
#endif
#line 2935
            status = NC_ERANGE;
#line 2935
            
#line 2935
#ifdef ERANGE_FILL
#line 2935
            xp++; tp++; continue;
#line 2935
#endif
#line 2935
        }
#line 2935
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2935
    }
#line 2935

#line 2935
    *xpp = (void *)xp;
#line 2935
    return status;
#line 2935
}
#line 2935

int
#line 2936
ncx_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2936
{
#line 2936
    int status = NC_NOERR;
#line 2936
    schar *xp = (schar *) *xpp;
#line 2936

#line 2936
    while (nelems-- != 0) {
#line 2936
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2936
            
#line 2936
#ifdef ERANGE_FILL
#line 2936
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2936
#endif
#line 2936
            status = NC_ERANGE;
#line 2936
            
#line 2936
#ifdef ERANGE_FILL
#line 2936
            xp++; tp++; continue;
#line 2936
#endif
#line 2936
        }
#line 2936
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2936
    }
#line 2936

#line 2936
    *xpp = (void *)xp;
#line 2936
    return status;
#line 2936
}
#line 2936


#line 2939
int
ncx_pad_putn_schar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2942

#line 2942
	if (rndup)
#line 2942
		rndup = X_ALIGN - rndup;
#line 2942

#line 2942
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 2942
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2942

#line 2942
	if (rndup)
#line 2942
	{
#line 2942
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 2942
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2942
	}
#line 2942

#line 2942
	return NC_NOERR;
#line 2942

}
int
#line 2944
ncx_pad_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 2944
{
#line 2944
    int status = NC_NOERR;
#line 2944
    size_t rndup = nelems % X_ALIGN;
#line 2944
    schar *xp = (schar *) *xpp;
#line 2944

#line 2944
    if (rndup) rndup = X_ALIGN - rndup;
#line 2944

#line 2944
    while (nelems-- != 0) {
#line 2944
        if (*tp > (uchar)X_SCHAR_MAX ) {
#line 2944
            
#line 2944
#ifdef ERANGE_FILL
#line 2944
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2944
#endif
#line 2944
            status = NC_ERANGE;
#line 2944
            
#line 2944
#ifdef ERANGE_FILL
#line 2944
            xp++; tp++; continue;
#line 2944
#endif
#line 2944
        }
#line 2944
        *xp++ = (schar)  *tp++; /* type cast from uchar to schar */
#line 2944
    }
#line 2944

#line 2944

#line 2944
    if (rndup) {
#line 2944
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2944
        xp += rndup;
#line 2944
    }
#line 2944

#line 2944
    *xpp = (void *)xp;
#line 2944
    return status;
#line 2944
}
#line 2944

int
#line 2945
ncx_pad_putn_schar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 2945
{
#line 2945
    int status = NC_NOERR;
#line 2945
    size_t rndup = nelems % X_ALIGN;
#line 2945
    schar *xp = (schar *) *xpp;
#line 2945

#line 2945
    if (rndup) rndup = X_ALIGN - rndup;
#line 2945

#line 2945
    while (nelems-- != 0) {
#line 2945
        if (*tp > (short)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2945
            
#line 2945
#ifdef ERANGE_FILL
#line 2945
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2945
#endif
#line 2945
            status = NC_ERANGE;
#line 2945
            
#line 2945
#ifdef ERANGE_FILL
#line 2945
            xp++; tp++; continue;
#line 2945
#endif
#line 2945
        }
#line 2945
        *xp++ = (schar)  *tp++; /* type cast from short to schar */
#line 2945
    }
#line 2945

#line 2945

#line 2945
    if (rndup) {
#line 2945
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2945
        xp += rndup;
#line 2945
    }
#line 2945

#line 2945
    *xpp = (void *)xp;
#line 2945
    return status;
#line 2945
}
#line 2945

int
#line 2946
ncx_pad_putn_schar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 2946
{
#line 2946
    int status = NC_NOERR;
#line 2946
    size_t rndup = nelems % X_ALIGN;
#line 2946
    schar *xp = (schar *) *xpp;
#line 2946

#line 2946
    if (rndup) rndup = X_ALIGN - rndup;
#line 2946

#line 2946
    while (nelems-- != 0) {
#line 2946
        if (*tp > (int)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2946
            
#line 2946
#ifdef ERANGE_FILL
#line 2946
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2946
#endif
#line 2946
            status = NC_ERANGE;
#line 2946
            
#line 2946
#ifdef ERANGE_FILL
#line 2946
            xp++; tp++; continue;
#line 2946
#endif
#line 2946
        }
#line 2946
        *xp++ = (schar)  *tp++; /* type cast from int to schar */
#line 2946
    }
#line 2946

#line 2946

#line 2946
    if (rndup) {
#line 2946
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2946
        xp += rndup;
#line 2946
    }
#line 2946

#line 2946
    *xpp = (void *)xp;
#line 2946
    return status;
#line 2946
}
#line 2946

int
#line 2947
ncx_pad_putn_schar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 2947
{
#line 2947
    int status = NC_NOERR;
#line 2947
    size_t rndup = nelems % X_ALIGN;
#line 2947
    schar *xp = (schar *) *xpp;
#line 2947

#line 2947
    if (rndup) rndup = X_ALIGN - rndup;
#line 2947

#line 2947
    while (nelems-- != 0) {
#line 2947
        if (*tp > (long)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2947
            
#line 2947
#ifdef ERANGE_FILL
#line 2947
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2947
#endif
#line 2947
            status = NC_ERANGE;
#line 2947
            
#line 2947
#ifdef ERANGE_FILL
#line 2947
            xp++; tp++; continue;
#line 2947
#endif
#line 2947
        }
#line 2947
        *xp++ = (schar)  *tp++; /* type cast from long to schar */
#line 2947
    }
#line 2947

#line 2947

#line 2947
    if (rndup) {
#line 2947
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2947
        xp += rndup;
#line 2947
    }
#line 2947

#line 2947
    *xpp = (void *)xp;
#line 2947
    return status;
#line 2947
}
#line 2947

int
#line 2948
ncx_pad_putn_schar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 2948
{
#line 2948
    int status = NC_NOERR;
#line 2948
    size_t rndup = nelems % X_ALIGN;
#line 2948
    schar *xp = (schar *) *xpp;
#line 2948

#line 2948
    if (rndup) rndup = X_ALIGN - rndup;
#line 2948

#line 2948
    while (nelems-- != 0) {
#line 2948
        if (*tp > (float)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2948
            
#line 2948
#ifdef ERANGE_FILL
#line 2948
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2948
#endif
#line 2948
            status = NC_ERANGE;
#line 2948
            
#line 2948
#ifdef ERANGE_FILL
#line 2948
            xp++; tp++; continue;
#line 2948
#endif
#line 2948
        }
#line 2948
        *xp++ = (schar)  *tp++; /* type cast from float to schar */
#line 2948
    }
#line 2948

#line 2948

#line 2948
    if (rndup) {
#line 2948
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2948
        xp += rndup;
#line 2948
    }
#line 2948

#line 2948
    *xpp = (void *)xp;
#line 2948
    return status;
#line 2948
}
#line 2948

int
#line 2949
ncx_pad_putn_schar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 2949
{
#line 2949
    int status = NC_NOERR;
#line 2949
    size_t rndup = nelems % X_ALIGN;
#line 2949
    schar *xp = (schar *) *xpp;
#line 2949

#line 2949
    if (rndup) rndup = X_ALIGN - rndup;
#line 2949

#line 2949
    while (nelems-- != 0) {
#line 2949
        if (*tp > (double)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2949
            
#line 2949
#ifdef ERANGE_FILL
#line 2949
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2949
#endif
#line 2949
            status = NC_ERANGE;
#line 2949
            
#line 2949
#ifdef ERANGE_FILL
#line 2949
            xp++; tp++; continue;
#line 2949
#endif
#line 2949
        }
#line 2949
        *xp++ = (schar)  *tp++; /* type cast from double to schar */
#line 2949
    }
#line 2949

#line 2949

#line 2949
    if (rndup) {
#line 2949
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2949
        xp += rndup;
#line 2949
    }
#line 2949

#line 2949
    *xpp = (void *)xp;
#line 2949
    return status;
#line 2949
}
#line 2949

int
#line 2950
ncx_pad_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 2950
{
#line 2950
    int status = NC_NOERR;
#line 2950
    size_t rndup = nelems % X_ALIGN;
#line 2950
    schar *xp = (schar *) *xpp;
#line 2950

#line 2950
    if (rndup) rndup = X_ALIGN - rndup;
#line 2950

#line 2950
    while (nelems-- != 0) {
#line 2950
        if (*tp > (longlong)X_SCHAR_MAX || *tp < X_SCHAR_MIN) {
#line 2950
            
#line 2950
#ifdef ERANGE_FILL
#line 2950
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2950
#endif
#line 2950
            status = NC_ERANGE;
#line 2950
            
#line 2950
#ifdef ERANGE_FILL
#line 2950
            xp++; tp++; continue;
#line 2950
#endif
#line 2950
        }
#line 2950
        *xp++ = (schar)  *tp++; /* type cast from longlong to schar */
#line 2950
    }
#line 2950

#line 2950

#line 2950
    if (rndup) {
#line 2950
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2950
        xp += rndup;
#line 2950
    }
#line 2950

#line 2950
    *xpp = (void *)xp;
#line 2950
    return status;
#line 2950
}
#line 2950

int
#line 2951
ncx_pad_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 2951
{
#line 2951
    int status = NC_NOERR;
#line 2951
    size_t rndup = nelems % X_ALIGN;
#line 2951
    schar *xp = (schar *) *xpp;
#line 2951

#line 2951
    if (rndup) rndup = X_ALIGN - rndup;
#line 2951

#line 2951
    while (nelems-- != 0) {
#line 2951
        if (*tp > (ushort)X_SCHAR_MAX ) {
#line 2951
            
#line 2951
#ifdef ERANGE_FILL
#line 2951
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2951
#endif
#line 2951
            status = NC_ERANGE;
#line 2951
            
#line 2951
#ifdef ERANGE_FILL
#line 2951
            xp++; tp++; continue;
#line 2951
#endif
#line 2951
        }
#line 2951
        *xp++ = (schar)  *tp++; /* type cast from ushort to schar */
#line 2951
    }
#line 2951

#line 2951

#line 2951
    if (rndup) {
#line 2951
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2951
        xp += rndup;
#line 2951
    }
#line 2951

#line 2951
    *xpp = (void *)xp;
#line 2951
    return status;
#line 2951
}
#line 2951

int
#line 2952
ncx_pad_putn_schar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 2952
{
#line 2952
    int status = NC_NOERR;
#line 2952
    size_t rndup = nelems % X_ALIGN;
#line 2952
    schar *xp = (schar *) *xpp;
#line 2952

#line 2952
    if (rndup) rndup = X_ALIGN - rndup;
#line 2952

#line 2952
    while (nelems-- != 0) {
#line 2952
        if (*tp > (uint)X_SCHAR_MAX ) {
#line 2952
            
#line 2952
#ifdef ERANGE_FILL
#line 2952
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2952
#endif
#line 2952
            status = NC_ERANGE;
#line 2952
            
#line 2952
#ifdef ERANGE_FILL
#line 2952
            xp++; tp++; continue;
#line 2952
#endif
#line 2952
        }
#line 2952
        *xp++ = (schar)  *tp++; /* type cast from uint to schar */
#line 2952
    }
#line 2952

#line 2952

#line 2952
    if (rndup) {
#line 2952
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2952
        xp += rndup;
#line 2952
    }
#line 2952

#line 2952
    *xpp = (void *)xp;
#line 2952
    return status;
#line 2952
}
#line 2952

int
#line 2953
ncx_pad_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 2953
{
#line 2953
    int status = NC_NOERR;
#line 2953
    size_t rndup = nelems % X_ALIGN;
#line 2953
    schar *xp = (schar *) *xpp;
#line 2953

#line 2953
    if (rndup) rndup = X_ALIGN - rndup;
#line 2953

#line 2953
    while (nelems-- != 0) {
#line 2953
        if (*tp > (ulonglong)X_SCHAR_MAX ) {
#line 2953
            
#line 2953
#ifdef ERANGE_FILL
#line 2953
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 2953
#endif
#line 2953
            status = NC_ERANGE;
#line 2953
            
#line 2953
#ifdef ERANGE_FILL
#line 2953
            xp++; tp++; continue;
#line 2953
#endif
#line 2953
        }
#line 2953
        *xp++ = (schar)  *tp++; /* type cast from ulonglong to schar */
#line 2953
    }
#line 2953

#line 2953

#line 2953
    if (rndup) {
#line 2953
        (void) memcpy(xp, nada, (size_t)rndup);
#line 2953
        xp += rndup;
#line 2953
    }
#line 2953

#line 2953
    *xpp = (void *)xp;
#line 2953
    return status;
#line 2953
}
#line 2953



/* uchar ---------------------------------------------------------------------*/
#line 2959
int
ncx_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *)(*xpp);

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
       	    status = NC_ERANGE;
            
#line 2969
#ifdef ERANGE_FILL
#line 2969
            xp++; tp++; continue;
#line 2969
#endif
        }
	*tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (const void *)xp;
    return status;
}
#line 2978
int
ncx_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		(void) memcpy(tp, *xpp, (size_t)nelems);
#line 2981
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2981
	return NC_NOERR;
#line 2981

}
int
#line 2983
ncx_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 2983
{
#line 2983
    int status = NC_NOERR;
#line 2983
    uchar *xp = (uchar *)(*xpp);
#line 2983

#line 2983
    while (nelems-- != 0) {
#line 2983
        
#line 2983
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 2983
    }
#line 2983

#line 2983
    *xpp = (const void *)xp;
#line 2983
    return status;
#line 2983
}
#line 2983

int
#line 2984
ncx_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 2984
{
#line 2984
    int status = NC_NOERR;
#line 2984
    uchar *xp = (uchar *)(*xpp);
#line 2984

#line 2984
    while (nelems-- != 0) {
#line 2984
        
#line 2984
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 2984
    }
#line 2984

#line 2984
    *xpp = (const void *)xp;
#line 2984
    return status;
#line 2984
}
#line 2984

int
#line 2985
ncx_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 2985
{
#line 2985
    int status = NC_NOERR;
#line 2985
    uchar *xp = (uchar *)(*xpp);
#line 2985

#line 2985
    while (nelems-- != 0) {
#line 2985
        
#line 2985
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 2985
    }
#line 2985

#line 2985
    *xpp = (const void *)xp;
#line 2985
    return status;
#line 2985
}
#line 2985

int
#line 2986
ncx_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 2986
{
#line 2986
    int status = NC_NOERR;
#line 2986
    uchar *xp = (uchar *)(*xpp);
#line 2986

#line 2986
    while (nelems-- != 0) {
#line 2986
        
#line 2986
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 2986
    }
#line 2986

#line 2986
    *xpp = (const void *)xp;
#line 2986
    return status;
#line 2986
}
#line 2986

int
#line 2987
ncx_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 2987
{
#line 2987
    int status = NC_NOERR;
#line 2987
    uchar *xp = (uchar *)(*xpp);
#line 2987

#line 2987
    while (nelems-- != 0) {
#line 2987
        
#line 2987
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 2987
    }
#line 2987

#line 2987
    *xpp = (const void *)xp;
#line 2987
    return status;
#line 2987
}
#line 2987

int
#line 2988
ncx_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2988
{
#line 2988
    int status = NC_NOERR;
#line 2988
    uchar *xp = (uchar *)(*xpp);
#line 2988

#line 2988
    while (nelems-- != 0) {
#line 2988
        
#line 2988
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 2988
    }
#line 2988

#line 2988
    *xpp = (const void *)xp;
#line 2988
    return status;
#line 2988
}
#line 2988

int
#line 2989
ncx_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2989
{
#line 2989
    int status = NC_NOERR;
#line 2989
    uchar *xp = (uchar *)(*xpp);
#line 2989

#line 2989
    while (nelems-- != 0) {
#line 2989
        
#line 2989
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 2989
    }
#line 2989

#line 2989
    *xpp = (const void *)xp;
#line 2989
    return status;
#line 2989
}
#line 2989

int
#line 2990
ncx_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2990
{
#line 2990
    int status = NC_NOERR;
#line 2990
    uchar *xp = (uchar *)(*xpp);
#line 2990

#line 2990
    while (nelems-- != 0) {
#line 2990
        
#line 2990
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 2990
    }
#line 2990

#line 2990
    *xpp = (const void *)xp;
#line 2990
    return status;
#line 2990
}
#line 2990

int
#line 2991
ncx_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2991
{
#line 2991
    int status = NC_NOERR;
#line 2991
    uchar *xp = (uchar *)(*xpp);
#line 2991

#line 2991
    while (nelems-- != 0) {
#line 2991
        
#line 2991
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 2991
    }
#line 2991

#line 2991
    *xpp = (const void *)xp;
#line 2991
    return status;
#line 2991
}
#line 2991


#line 2994
int
ncx_pad_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*xp > SCHAR_MAX) {
            *tp = NC_FILL_BYTE;
            status = NC_ERANGE;
            
#line 3007
#ifdef ERANGE_FILL
#line 3007
            xp++; tp++; continue;
#line 3007
#endif
        }
        *tp++ = (schar) *xp++; /* type cast from uchar to schar */
    }

    *xpp = (void *)(xp + rndup);
    return status;
}
#line 3016
int
ncx_pad_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 3019

#line 3019
	if (rndup)
#line 3019
		rndup = X_ALIGN - rndup;
#line 3019

#line 3019
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3019
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3019

#line 3019
	return NC_NOERR;
#line 3019

}
int
#line 3021
ncx_pad_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 3021
{
#line 3021
    int status = NC_NOERR;
#line 3021
    size_t rndup = nelems % X_ALIGN;
#line 3021
    uchar *xp = (uchar *) *xpp;
#line 3021

#line 3021
    if (rndup)
#line 3021
        rndup = X_ALIGN - rndup;
#line 3021

#line 3021
    while (nelems-- != 0) {
#line 3021
        
#line 3021
        *tp++ = (short)  (*xp++);  /* type cast from uchar to short */
#line 3021
    }
#line 3021

#line 3021
    *xpp = (void *)(xp + rndup);
#line 3021
    return status;
#line 3021
}
#line 3021

int
#line 3022
ncx_pad_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 3022
{
#line 3022
    int status = NC_NOERR;
#line 3022
    size_t rndup = nelems % X_ALIGN;
#line 3022
    uchar *xp = (uchar *) *xpp;
#line 3022

#line 3022
    if (rndup)
#line 3022
        rndup = X_ALIGN - rndup;
#line 3022

#line 3022
    while (nelems-- != 0) {
#line 3022
        
#line 3022
        *tp++ = (int)  (*xp++);  /* type cast from uchar to int */
#line 3022
    }
#line 3022

#line 3022
    *xpp = (void *)(xp + rndup);
#line 3022
    return status;
#line 3022
}
#line 3022

int
#line 3023
ncx_pad_getn_uchar_long(const void **xpp, size_t nelems, long *tp)
#line 3023
{
#line 3023
    int status = NC_NOERR;
#line 3023
    size_t rndup = nelems % X_ALIGN;
#line 3023
    uchar *xp = (uchar *) *xpp;
#line 3023

#line 3023
    if (rndup)
#line 3023
        rndup = X_ALIGN - rndup;
#line 3023

#line 3023
    while (nelems-- != 0) {
#line 3023
        
#line 3023
        *tp++ = (long)  (*xp++);  /* type cast from uchar to long */
#line 3023
    }
#line 3023

#line 3023
    *xpp = (void *)(xp + rndup);
#line 3023
    return status;
#line 3023
}
#line 3023

int
#line 3024
ncx_pad_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 3024
{
#line 3024
    int status = NC_NOERR;
#line 3024
    size_t rndup = nelems % X_ALIGN;
#line 3024
    uchar *xp = (uchar *) *xpp;
#line 3024

#line 3024
    if (rndup)
#line 3024
        rndup = X_ALIGN - rndup;
#line 3024

#line 3024
    while (nelems-- != 0) {
#line 3024
        
#line 3024
        *tp++ = (float)  (*xp++);  /* type cast from uchar to float */
#line 3024
    }
#line 3024

#line 3024
    *xpp = (void *)(xp + rndup);
#line 3024
    return status;
#line 3024
}
#line 3024

int
#line 3025
ncx_pad_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 3025
{
#line 3025
    int status = NC_NOERR;
#line 3025
    size_t rndup = nelems % X_ALIGN;
#line 3025
    uchar *xp = (uchar *) *xpp;
#line 3025

#line 3025
    if (rndup)
#line 3025
        rndup = X_ALIGN - rndup;
#line 3025

#line 3025
    while (nelems-- != 0) {
#line 3025
        
#line 3025
        *tp++ = (double)  (*xp++);  /* type cast from uchar to double */
#line 3025
    }
#line 3025

#line 3025
    *xpp = (void *)(xp + rndup);
#line 3025
    return status;
#line 3025
}
#line 3025

int
#line 3026
ncx_pad_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3026
{
#line 3026
    int status = NC_NOERR;
#line 3026
    size_t rndup = nelems % X_ALIGN;
#line 3026
    uchar *xp = (uchar *) *xpp;
#line 3026

#line 3026
    if (rndup)
#line 3026
        rndup = X_ALIGN - rndup;
#line 3026

#line 3026
    while (nelems-- != 0) {
#line 3026
        
#line 3026
        *tp++ = (longlong)  (*xp++);  /* type cast from uchar to longlong */
#line 3026
    }
#line 3026

#line 3026
    *xpp = (void *)(xp + rndup);
#line 3026
    return status;
#line 3026
}
#line 3026

int
#line 3027
ncx_pad_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3027
{
#line 3027
    int status = NC_NOERR;
#line 3027
    size_t rndup = nelems % X_ALIGN;
#line 3027
    uchar *xp = (uchar *) *xpp;
#line 3027

#line 3027
    if (rndup)
#line 3027
        rndup = X_ALIGN - rndup;
#line 3027

#line 3027
    while (nelems-- != 0) {
#line 3027
        
#line 3027
        *tp++ = (ushort)  (*xp++);  /* type cast from uchar to ushort */
#line 3027
    }
#line 3027

#line 3027
    *xpp = (void *)(xp + rndup);
#line 3027
    return status;
#line 3027
}
#line 3027

int
#line 3028
ncx_pad_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 3028
{
#line 3028
    int status = NC_NOERR;
#line 3028
    size_t rndup = nelems % X_ALIGN;
#line 3028
    uchar *xp = (uchar *) *xpp;
#line 3028

#line 3028
    if (rndup)
#line 3028
        rndup = X_ALIGN - rndup;
#line 3028

#line 3028
    while (nelems-- != 0) {
#line 3028
        
#line 3028
        *tp++ = (uint)  (*xp++);  /* type cast from uchar to uint */
#line 3028
    }
#line 3028

#line 3028
    *xpp = (void *)(xp + rndup);
#line 3028
    return status;
#line 3028
}
#line 3028

int
#line 3029
ncx_pad_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3029
{
#line 3029
    int status = NC_NOERR;
#line 3029
    size_t rndup = nelems % X_ALIGN;
#line 3029
    uchar *xp = (uchar *) *xpp;
#line 3029

#line 3029
    if (rndup)
#line 3029
        rndup = X_ALIGN - rndup;
#line 3029

#line 3029
    while (nelems-- != 0) {
#line 3029
        
#line 3029
        *tp++ = (ulonglong)  (*xp++);  /* type cast from uchar to ulonglong */
#line 3029
    }
#line 3029

#line 3029
    *xpp = (void *)(xp + rndup);
#line 3029
    return status;
#line 3029
}
#line 3029


#line 3032
int
ncx_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    uchar *xp = (uchar *) *xpp;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 3040
#ifdef ERANGE_FILL
#line 3040
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3040
#endif
            status = NC_ERANGE;
            
#line 3042
#ifdef ERANGE_FILL
#line 3042
            xp++; tp++; continue;
#line 3042
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    *xpp = (void *)xp;
    return status;
}
#line 3051
int
ncx_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3054
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3054

#line 3054
	return NC_NOERR;
#line 3054

}
int
#line 3056
ncx_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3056
{
#line 3056
    int status = NC_NOERR;
#line 3056
    uchar *xp = (uchar *) *xpp;
#line 3056

#line 3056
    while (nelems-- != 0) {
#line 3056
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 3056
            
#line 3056
#ifdef ERANGE_FILL
#line 3056
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3056
#endif
#line 3056
            status = NC_ERANGE;
#line 3056
            
#line 3056
#ifdef ERANGE_FILL
#line 3056
            xp++; tp++; continue;
#line 3056
#endif
#line 3056
        }
#line 3056
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 3056
    }
#line 3056

#line 3056
    *xpp = (void *)xp;
#line 3056
    return status;
#line 3056
}
#line 3056

int
#line 3057
ncx_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3057
{
#line 3057
    int status = NC_NOERR;
#line 3057
    uchar *xp = (uchar *) *xpp;
#line 3057

#line 3057
    while (nelems-- != 0) {
#line 3057
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 3057
            
#line 3057
#ifdef ERANGE_FILL
#line 3057
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3057
#endif
#line 3057
            status = NC_ERANGE;
#line 3057
            
#line 3057
#ifdef ERANGE_FILL
#line 3057
            xp++; tp++; continue;
#line 3057
#endif
#line 3057
        }
#line 3057
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 3057
    }
#line 3057

#line 3057
    *xpp = (void *)xp;
#line 3057
    return status;
#line 3057
}
#line 3057

int
#line 3058
ncx_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3058
{
#line 3058
    int status = NC_NOERR;
#line 3058
    uchar *xp = (uchar *) *xpp;
#line 3058

#line 3058
    while (nelems-- != 0) {
#line 3058
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 3058
            
#line 3058
#ifdef ERANGE_FILL
#line 3058
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3058
#endif
#line 3058
            status = NC_ERANGE;
#line 3058
            
#line 3058
#ifdef ERANGE_FILL
#line 3058
            xp++; tp++; continue;
#line 3058
#endif
#line 3058
        }
#line 3058
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 3058
    }
#line 3058

#line 3058
    *xpp = (void *)xp;
#line 3058
    return status;
#line 3058
}
#line 3058

int
#line 3059
ncx_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3059
{
#line 3059
    int status = NC_NOERR;
#line 3059
    uchar *xp = (uchar *) *xpp;
#line 3059

#line 3059
    while (nelems-- != 0) {
#line 3059
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 3059
            
#line 3059
#ifdef ERANGE_FILL
#line 3059
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3059
#endif
#line 3059
            status = NC_ERANGE;
#line 3059
            
#line 3059
#ifdef ERANGE_FILL
#line 3059
            xp++; tp++; continue;
#line 3059
#endif
#line 3059
        }
#line 3059
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 3059
    }
#line 3059

#line 3059
    *xpp = (void *)xp;
#line 3059
    return status;
#line 3059
}
#line 3059

int
#line 3060
ncx_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3060
{
#line 3060
    int status = NC_NOERR;
#line 3060
    uchar *xp = (uchar *) *xpp;
#line 3060

#line 3060
    while (nelems-- != 0) {
#line 3060
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 3060
            
#line 3060
#ifdef ERANGE_FILL
#line 3060
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3060
#endif
#line 3060
            status = NC_ERANGE;
#line 3060
            
#line 3060
#ifdef ERANGE_FILL
#line 3060
            xp++; tp++; continue;
#line 3060
#endif
#line 3060
        }
#line 3060
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 3060
    }
#line 3060

#line 3060
    *xpp = (void *)xp;
#line 3060
    return status;
#line 3060
}
#line 3060

int
#line 3061
ncx_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3061
{
#line 3061
    int status = NC_NOERR;
#line 3061
    uchar *xp = (uchar *) *xpp;
#line 3061

#line 3061
    while (nelems-- != 0) {
#line 3061
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 3061
            
#line 3061
#ifdef ERANGE_FILL
#line 3061
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3061
#endif
#line 3061
            status = NC_ERANGE;
#line 3061
            
#line 3061
#ifdef ERANGE_FILL
#line 3061
            xp++; tp++; continue;
#line 3061
#endif
#line 3061
        }
#line 3061
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 3061
    }
#line 3061

#line 3061
    *xpp = (void *)xp;
#line 3061
    return status;
#line 3061
}
#line 3061

int
#line 3062
ncx_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3062
{
#line 3062
    int status = NC_NOERR;
#line 3062
    uchar *xp = (uchar *) *xpp;
#line 3062

#line 3062
    while (nelems-- != 0) {
#line 3062
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 3062
            
#line 3062
#ifdef ERANGE_FILL
#line 3062
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3062
#endif
#line 3062
            status = NC_ERANGE;
#line 3062
            
#line 3062
#ifdef ERANGE_FILL
#line 3062
            xp++; tp++; continue;
#line 3062
#endif
#line 3062
        }
#line 3062
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 3062
    }
#line 3062

#line 3062
    *xpp = (void *)xp;
#line 3062
    return status;
#line 3062
}
#line 3062

int
#line 3063
ncx_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3063
{
#line 3063
    int status = NC_NOERR;
#line 3063
    uchar *xp = (uchar *) *xpp;
#line 3063

#line 3063
    while (nelems-- != 0) {
#line 3063
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 3063
            
#line 3063
#ifdef ERANGE_FILL
#line 3063
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3063
#endif
#line 3063
            status = NC_ERANGE;
#line 3063
            
#line 3063
#ifdef ERANGE_FILL
#line 3063
            xp++; tp++; continue;
#line 3063
#endif
#line 3063
        }
#line 3063
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 3063
    }
#line 3063

#line 3063
    *xpp = (void *)xp;
#line 3063
    return status;
#line 3063
}
#line 3063

int
#line 3064
ncx_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3064
{
#line 3064
    int status = NC_NOERR;
#line 3064
    uchar *xp = (uchar *) *xpp;
#line 3064

#line 3064
    while (nelems-- != 0) {
#line 3064
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 3064
            
#line 3064
#ifdef ERANGE_FILL
#line 3064
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3064
#endif
#line 3064
            status = NC_ERANGE;
#line 3064
            
#line 3064
#ifdef ERANGE_FILL
#line 3064
            xp++; tp++; continue;
#line 3064
#endif
#line 3064
        }
#line 3064
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 3064
    }
#line 3064

#line 3064
    *xpp = (void *)xp;
#line 3064
    return status;
#line 3064
}
#line 3064


#line 3067
int
ncx_pad_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
{
    int status = NC_NOERR;
    size_t rndup = nelems % X_ALIGN;
    uchar *xp = (uchar *) *xpp;

    if (rndup) rndup = X_ALIGN - rndup;

    while (nelems-- != 0) {
        if (*tp < 0) {
            
#line 3078
#ifdef ERANGE_FILL
#line 3078
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3078
#endif
            status = NC_ERANGE;
            
#line 3080
#ifdef ERANGE_FILL
#line 3080
            xp++; tp++; continue;
#line 3080
#endif
        }
        *xp++ = (uchar) (signed) *tp++; /* type cast from schar to uchar */
    }

    if (rndup) {
        (void) memcpy(xp, nada, (size_t)rndup);
        xp += rndup;
    }

    *xpp = (void *)xp;
    return status;
}
#line 3094
int
ncx_pad_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
{
		size_t rndup = nelems % X_ALIGN;
#line 3097

#line 3097
	if (rndup)
#line 3097
		rndup = X_ALIGN - rndup;
#line 3097

#line 3097
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3097
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3097

#line 3097
	if (rndup)
#line 3097
	{
#line 3097
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3097
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3097
	}
#line 3097

#line 3097
	return NC_NOERR;
#line 3097

}
int
#line 3099
ncx_pad_putn_uchar_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3099
{
#line 3099
    int status = NC_NOERR;
#line 3099
    size_t rndup = nelems % X_ALIGN;
#line 3099
    uchar *xp = (uchar *) *xpp;
#line 3099

#line 3099
    if (rndup) rndup = X_ALIGN - rndup;
#line 3099

#line 3099
    while (nelems-- != 0) {
#line 3099
        if (*tp > (short)X_UCHAR_MAX || *tp < 0) {
#line 3099
            
#line 3099
#ifdef ERANGE_FILL
#line 3099
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3099
#endif
#line 3099
            status = NC_ERANGE;
#line 3099
            
#line 3099
#ifdef ERANGE_FILL
#line 3099
            xp++; tp++; continue;
#line 3099
#endif
#line 3099
        }
#line 3099
        *xp++ = (uchar) (signed) *tp++; /* type cast from short to uchar */
#line 3099
    }
#line 3099

#line 3099

#line 3099
    if (rndup) {
#line 3099
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3099
        xp += rndup;
#line 3099
    }
#line 3099

#line 3099
    *xpp = (void *)xp;
#line 3099
    return status;
#line 3099
}
#line 3099

int
#line 3100
ncx_pad_putn_uchar_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3100
{
#line 3100
    int status = NC_NOERR;
#line 3100
    size_t rndup = nelems % X_ALIGN;
#line 3100
    uchar *xp = (uchar *) *xpp;
#line 3100

#line 3100
    if (rndup) rndup = X_ALIGN - rndup;
#line 3100

#line 3100
    while (nelems-- != 0) {
#line 3100
        if (*tp > (int)X_UCHAR_MAX || *tp < 0) {
#line 3100
            
#line 3100
#ifdef ERANGE_FILL
#line 3100
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3100
#endif
#line 3100
            status = NC_ERANGE;
#line 3100
            
#line 3100
#ifdef ERANGE_FILL
#line 3100
            xp++; tp++; continue;
#line 3100
#endif
#line 3100
        }
#line 3100
        *xp++ = (uchar) (signed) *tp++; /* type cast from int to uchar */
#line 3100
    }
#line 3100

#line 3100

#line 3100
    if (rndup) {
#line 3100
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3100
        xp += rndup;
#line 3100
    }
#line 3100

#line 3100
    *xpp = (void *)xp;
#line 3100
    return status;
#line 3100
}
#line 3100

int
#line 3101
ncx_pad_putn_uchar_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3101
{
#line 3101
    int status = NC_NOERR;
#line 3101
    size_t rndup = nelems % X_ALIGN;
#line 3101
    uchar *xp = (uchar *) *xpp;
#line 3101

#line 3101
    if (rndup) rndup = X_ALIGN - rndup;
#line 3101

#line 3101
    while (nelems-- != 0) {
#line 3101
        if (*tp > (long)X_UCHAR_MAX || *tp < 0) {
#line 3101
            
#line 3101
#ifdef ERANGE_FILL
#line 3101
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3101
#endif
#line 3101
            status = NC_ERANGE;
#line 3101
            
#line 3101
#ifdef ERANGE_FILL
#line 3101
            xp++; tp++; continue;
#line 3101
#endif
#line 3101
        }
#line 3101
        *xp++ = (uchar) (signed) *tp++; /* type cast from long to uchar */
#line 3101
    }
#line 3101

#line 3101

#line 3101
    if (rndup) {
#line 3101
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3101
        xp += rndup;
#line 3101
    }
#line 3101

#line 3101
    *xpp = (void *)xp;
#line 3101
    return status;
#line 3101
}
#line 3101

int
#line 3102
ncx_pad_putn_uchar_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3102
{
#line 3102
    int status = NC_NOERR;
#line 3102
    size_t rndup = nelems % X_ALIGN;
#line 3102
    uchar *xp = (uchar *) *xpp;
#line 3102

#line 3102
    if (rndup) rndup = X_ALIGN - rndup;
#line 3102

#line 3102
    while (nelems-- != 0) {
#line 3102
        if (*tp > (float)X_UCHAR_MAX || *tp < 0) {
#line 3102
            
#line 3102
#ifdef ERANGE_FILL
#line 3102
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3102
#endif
#line 3102
            status = NC_ERANGE;
#line 3102
            
#line 3102
#ifdef ERANGE_FILL
#line 3102
            xp++; tp++; continue;
#line 3102
#endif
#line 3102
        }
#line 3102
        *xp++ = (uchar) (signed) *tp++; /* type cast from float to uchar */
#line 3102
    }
#line 3102

#line 3102

#line 3102
    if (rndup) {
#line 3102
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3102
        xp += rndup;
#line 3102
    }
#line 3102

#line 3102
    *xpp = (void *)xp;
#line 3102
    return status;
#line 3102
}
#line 3102

int
#line 3103
ncx_pad_putn_uchar_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3103
{
#line 3103
    int status = NC_NOERR;
#line 3103
    size_t rndup = nelems % X_ALIGN;
#line 3103
    uchar *xp = (uchar *) *xpp;
#line 3103

#line 3103
    if (rndup) rndup = X_ALIGN - rndup;
#line 3103

#line 3103
    while (nelems-- != 0) {
#line 3103
        if (*tp > (double)X_UCHAR_MAX || *tp < 0) {
#line 3103
            
#line 3103
#ifdef ERANGE_FILL
#line 3103
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3103
#endif
#line 3103
            status = NC_ERANGE;
#line 3103
            
#line 3103
#ifdef ERANGE_FILL
#line 3103
            xp++; tp++; continue;
#line 3103
#endif
#line 3103
        }
#line 3103
        *xp++ = (uchar) (signed) *tp++; /* type cast from double to uchar */
#line 3103
    }
#line 3103

#line 3103

#line 3103
    if (rndup) {
#line 3103
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3103
        xp += rndup;
#line 3103
    }
#line 3103

#line 3103
    *xpp = (void *)xp;
#line 3103
    return status;
#line 3103
}
#line 3103

int
#line 3104
ncx_pad_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3104
{
#line 3104
    int status = NC_NOERR;
#line 3104
    size_t rndup = nelems % X_ALIGN;
#line 3104
    uchar *xp = (uchar *) *xpp;
#line 3104

#line 3104
    if (rndup) rndup = X_ALIGN - rndup;
#line 3104

#line 3104
    while (nelems-- != 0) {
#line 3104
        if (*tp > (longlong)X_UCHAR_MAX || *tp < 0) {
#line 3104
            
#line 3104
#ifdef ERANGE_FILL
#line 3104
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3104
#endif
#line 3104
            status = NC_ERANGE;
#line 3104
            
#line 3104
#ifdef ERANGE_FILL
#line 3104
            xp++; tp++; continue;
#line 3104
#endif
#line 3104
        }
#line 3104
        *xp++ = (uchar) (signed) *tp++; /* type cast from longlong to uchar */
#line 3104
    }
#line 3104

#line 3104

#line 3104
    if (rndup) {
#line 3104
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3104
        xp += rndup;
#line 3104
    }
#line 3104

#line 3104
    *xpp = (void *)xp;
#line 3104
    return status;
#line 3104
}
#line 3104

int
#line 3105
ncx_pad_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3105
{
#line 3105
    int status = NC_NOERR;
#line 3105
    size_t rndup = nelems % X_ALIGN;
#line 3105
    uchar *xp = (uchar *) *xpp;
#line 3105

#line 3105
    if (rndup) rndup = X_ALIGN - rndup;
#line 3105

#line 3105
    while (nelems-- != 0) {
#line 3105
        if (*tp > (ushort)X_UCHAR_MAX ) {
#line 3105
            
#line 3105
#ifdef ERANGE_FILL
#line 3105
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3105
#endif
#line 3105
            status = NC_ERANGE;
#line 3105
            
#line 3105
#ifdef ERANGE_FILL
#line 3105
            xp++; tp++; continue;
#line 3105
#endif
#line 3105
        }
#line 3105
        *xp++ = (uchar)  *tp++; /* type cast from ushort to uchar */
#line 3105
    }
#line 3105

#line 3105

#line 3105
    if (rndup) {
#line 3105
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3105
        xp += rndup;
#line 3105
    }
#line 3105

#line 3105
    *xpp = (void *)xp;
#line 3105
    return status;
#line 3105
}
#line 3105

int
#line 3106
ncx_pad_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3106
{
#line 3106
    int status = NC_NOERR;
#line 3106
    size_t rndup = nelems % X_ALIGN;
#line 3106
    uchar *xp = (uchar *) *xpp;
#line 3106

#line 3106
    if (rndup) rndup = X_ALIGN - rndup;
#line 3106

#line 3106
    while (nelems-- != 0) {
#line 3106
        if (*tp > (uint)X_UCHAR_MAX ) {
#line 3106
            
#line 3106
#ifdef ERANGE_FILL
#line 3106
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3106
#endif
#line 3106
            status = NC_ERANGE;
#line 3106
            
#line 3106
#ifdef ERANGE_FILL
#line 3106
            xp++; tp++; continue;
#line 3106
#endif
#line 3106
        }
#line 3106
        *xp++ = (uchar)  *tp++; /* type cast from uint to uchar */
#line 3106
    }
#line 3106

#line 3106

#line 3106
    if (rndup) {
#line 3106
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3106
        xp += rndup;
#line 3106
    }
#line 3106

#line 3106
    *xpp = (void *)xp;
#line 3106
    return status;
#line 3106
}
#line 3106

int
#line 3107
ncx_pad_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3107
{
#line 3107
    int status = NC_NOERR;
#line 3107
    size_t rndup = nelems % X_ALIGN;
#line 3107
    uchar *xp = (uchar *) *xpp;
#line 3107

#line 3107
    if (rndup) rndup = X_ALIGN - rndup;
#line 3107

#line 3107
    while (nelems-- != 0) {
#line 3107
        if (*tp > (ulonglong)X_UCHAR_MAX ) {
#line 3107
            
#line 3107
#ifdef ERANGE_FILL
#line 3107
            if (fillp != NULL) memcpy(xp, fillp, 1);
#line 3107
#endif
#line 3107
            status = NC_ERANGE;
#line 3107
            
#line 3107
#ifdef ERANGE_FILL
#line 3107
            xp++; tp++; continue;
#line 3107
#endif
#line 3107
        }
#line 3107
        *xp++ = (uchar)  *tp++; /* type cast from ulonglong to uchar */
#line 3107
    }
#line 3107

#line 3107

#line 3107
    if (rndup) {
#line 3107
        (void) memcpy(xp, nada, (size_t)rndup);
#line 3107
        xp += rndup;
#line 3107
    }
#line 3107

#line 3107
    *xpp = (void *)xp;
#line 3107
    return status;
#line 3107
}
#line 3107


/* short ---------------------------------------------------------------------*/

#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_SHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 3125
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 3125
{
#line 3125
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3125

#line 3125
 /* basic algorithm is:
#line 3125
  *   - ensure sane alignment of input data
#line 3125
  *   - copy (conversion happens automatically) input data
#line 3125
  *     to output
#line 3125
  *   - update xpp to point at next unconverted input, and tp to point
#line 3125
  *     at next location for converted output
#line 3125
  */
#line 3125
  long i, j, ni;
#line 3125
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3125
  short *xp;
#line 3125
  int nrange = 0;         /* number of range errors */
#line 3125
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3125
  long cxp = (long) *((char**)xpp);
#line 3125

#line 3125
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3125
  /* sjl: manually stripmine so we can limit amount of
#line 3125
   * vector work space reserved to LOOPCNT elements. Also
#line 3125
   * makes vectorisation easy */
#line 3125
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3125
    ni=Min(nelems-j,LOOPCNT);
#line 3125
    if (realign) {
#line 3125
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3125
      xp = tmp;
#line 3125
    } else {
#line 3125
      xp = (short *) *xpp;
#line 3125
    }
#line 3125
   /* copy the next block */
#line 3125
#pragma cdir loopcnt=LOOPCNT
#line 3125
#pragma cdir shortloop
#line 3125
    for (i=0; i<ni; i++) {
#line 3125
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3125
     /* test for range errors (not always needed but do it anyway) */
#line 3125
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3125
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3125
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3125
    }
#line 3125
   /* update xpp and tp */
#line 3125
    if (realign) xp = (short *) *xpp;
#line 3125
    xp += ni;
#line 3125
    tp += ni;
#line 3125
    *xpp = (void*)xp;
#line 3125
  }
#line 3125
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3125

#line 3125
#else   /* not SX */
#line 3125
	const char *xp = (const char *) *xpp;
#line 3125
	int status = NC_NOERR;
#line 3125

#line 3125
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3125
	{
#line 3125
		const int lstatus = ncx_get_short_short(xp, tp);
#line 3125
		if (status == NC_NOERR) /* report the first encountered error */
#line 3125
			status = lstatus;
#line 3125
	}
#line 3125

#line 3125
	*xpp = (const void *)xp;
#line 3125
	return status;
#line 3125
#endif
#line 3125
}
#line 3125

#endif
int
#line 3127
ncx_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 3127
{
#line 3127
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3127

#line 3127
 /* basic algorithm is:
#line 3127
  *   - ensure sane alignment of input data
#line 3127
  *   - copy (conversion happens automatically) input data
#line 3127
  *     to output
#line 3127
  *   - update xpp to point at next unconverted input, and tp to point
#line 3127
  *     at next location for converted output
#line 3127
  */
#line 3127
  long i, j, ni;
#line 3127
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3127
  short *xp;
#line 3127
  int nrange = 0;         /* number of range errors */
#line 3127
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3127
  long cxp = (long) *((char**)xpp);
#line 3127

#line 3127
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3127
  /* sjl: manually stripmine so we can limit amount of
#line 3127
   * vector work space reserved to LOOPCNT elements. Also
#line 3127
   * makes vectorisation easy */
#line 3127
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3127
    ni=Min(nelems-j,LOOPCNT);
#line 3127
    if (realign) {
#line 3127
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3127
      xp = tmp;
#line 3127
    } else {
#line 3127
      xp = (short *) *xpp;
#line 3127
    }
#line 3127
   /* copy the next block */
#line 3127
#pragma cdir loopcnt=LOOPCNT
#line 3127
#pragma cdir shortloop
#line 3127
    for (i=0; i<ni; i++) {
#line 3127
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3127
     /* test for range errors (not always needed but do it anyway) */
#line 3127
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3127
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3127
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3127
    }
#line 3127
   /* update xpp and tp */
#line 3127
    if (realign) xp = (short *) *xpp;
#line 3127
    xp += ni;
#line 3127
    tp += ni;
#line 3127
    *xpp = (void*)xp;
#line 3127
  }
#line 3127
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3127

#line 3127
#else   /* not SX */
#line 3127
	const char *xp = (const char *) *xpp;
#line 3127
	int status = NC_NOERR;
#line 3127

#line 3127
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3127
	{
#line 3127
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 3127
		if (status == NC_NOERR) /* report the first encountered error */
#line 3127
			status = lstatus;
#line 3127
	}
#line 3127

#line 3127
	*xpp = (const void *)xp;
#line 3127
	return status;
#line 3127
#endif
#line 3127
}
#line 3127

int
#line 3128
ncx_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 3128
{
#line 3128
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3128

#line 3128
 /* basic algorithm is:
#line 3128
  *   - ensure sane alignment of input data
#line 3128
  *   - copy (conversion happens automatically) input data
#line 3128
  *     to output
#line 3128
  *   - update xpp to point at next unconverted input, and tp to point
#line 3128
  *     at next location for converted output
#line 3128
  */
#line 3128
  long i, j, ni;
#line 3128
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3128
  short *xp;
#line 3128
  int nrange = 0;         /* number of range errors */
#line 3128
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3128
  long cxp = (long) *((char**)xpp);
#line 3128

#line 3128
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3128
  /* sjl: manually stripmine so we can limit amount of
#line 3128
   * vector work space reserved to LOOPCNT elements. Also
#line 3128
   * makes vectorisation easy */
#line 3128
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3128
    ni=Min(nelems-j,LOOPCNT);
#line 3128
    if (realign) {
#line 3128
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3128
      xp = tmp;
#line 3128
    } else {
#line 3128
      xp = (short *) *xpp;
#line 3128
    }
#line 3128
   /* copy the next block */
#line 3128
#pragma cdir loopcnt=LOOPCNT
#line 3128
#pragma cdir shortloop
#line 3128
    for (i=0; i<ni; i++) {
#line 3128
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3128
     /* test for range errors (not always needed but do it anyway) */
#line 3128
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3128
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3128
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3128
    }
#line 3128
   /* update xpp and tp */
#line 3128
    if (realign) xp = (short *) *xpp;
#line 3128
    xp += ni;
#line 3128
    tp += ni;
#line 3128
    *xpp = (void*)xp;
#line 3128
  }
#line 3128
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3128

#line 3128
#else   /* not SX */
#line 3128
	const char *xp = (const char *) *xpp;
#line 3128
	int status = NC_NOERR;
#line 3128

#line 3128
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3128
	{
#line 3128
		const int lstatus = ncx_get_short_int(xp, tp);
#line 3128
		if (status == NC_NOERR) /* report the first encountered error */
#line 3128
			status = lstatus;
#line 3128
	}
#line 3128

#line 3128
	*xpp = (const void *)xp;
#line 3128
	return status;
#line 3128
#endif
#line 3128
}
#line 3128

int
#line 3129
ncx_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 3129
{
#line 3129
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3129

#line 3129
 /* basic algorithm is:
#line 3129
  *   - ensure sane alignment of input data
#line 3129
  *   - copy (conversion happens automatically) input data
#line 3129
  *     to output
#line 3129
  *   - update xpp to point at next unconverted input, and tp to point
#line 3129
  *     at next location for converted output
#line 3129
  */
#line 3129
  long i, j, ni;
#line 3129
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3129
  short *xp;
#line 3129
  int nrange = 0;         /* number of range errors */
#line 3129
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3129
  long cxp = (long) *((char**)xpp);
#line 3129

#line 3129
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3129
  /* sjl: manually stripmine so we can limit amount of
#line 3129
   * vector work space reserved to LOOPCNT elements. Also
#line 3129
   * makes vectorisation easy */
#line 3129
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3129
    ni=Min(nelems-j,LOOPCNT);
#line 3129
    if (realign) {
#line 3129
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3129
      xp = tmp;
#line 3129
    } else {
#line 3129
      xp = (short *) *xpp;
#line 3129
    }
#line 3129
   /* copy the next block */
#line 3129
#pragma cdir loopcnt=LOOPCNT
#line 3129
#pragma cdir shortloop
#line 3129
    for (i=0; i<ni; i++) {
#line 3129
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3129
     /* test for range errors (not always needed but do it anyway) */
#line 3129
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3129
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3129
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3129
    }
#line 3129
   /* update xpp and tp */
#line 3129
    if (realign) xp = (short *) *xpp;
#line 3129
    xp += ni;
#line 3129
    tp += ni;
#line 3129
    *xpp = (void*)xp;
#line 3129
  }
#line 3129
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3129

#line 3129
#else   /* not SX */
#line 3129
	const char *xp = (const char *) *xpp;
#line 3129
	int status = NC_NOERR;
#line 3129

#line 3129
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3129
	{
#line 3129
		const int lstatus = ncx_get_short_long(xp, tp);
#line 3129
		if (status == NC_NOERR) /* report the first encountered error */
#line 3129
			status = lstatus;
#line 3129
	}
#line 3129

#line 3129
	*xpp = (const void *)xp;
#line 3129
	return status;
#line 3129
#endif
#line 3129
}
#line 3129

int
#line 3130
ncx_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 3130
{
#line 3130
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3130

#line 3130
 /* basic algorithm is:
#line 3130
  *   - ensure sane alignment of input data
#line 3130
  *   - copy (conversion happens automatically) input data
#line 3130
  *     to output
#line 3130
  *   - update xpp to point at next unconverted input, and tp to point
#line 3130
  *     at next location for converted output
#line 3130
  */
#line 3130
  long i, j, ni;
#line 3130
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3130
  short *xp;
#line 3130
  int nrange = 0;         /* number of range errors */
#line 3130
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3130
  long cxp = (long) *((char**)xpp);
#line 3130

#line 3130
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3130
  /* sjl: manually stripmine so we can limit amount of
#line 3130
   * vector work space reserved to LOOPCNT elements. Also
#line 3130
   * makes vectorisation easy */
#line 3130
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3130
    ni=Min(nelems-j,LOOPCNT);
#line 3130
    if (realign) {
#line 3130
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3130
      xp = tmp;
#line 3130
    } else {
#line 3130
      xp = (short *) *xpp;
#line 3130
    }
#line 3130
   /* copy the next block */
#line 3130
#pragma cdir loopcnt=LOOPCNT
#line 3130
#pragma cdir shortloop
#line 3130
    for (i=0; i<ni; i++) {
#line 3130
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3130
     /* test for range errors (not always needed but do it anyway) */
#line 3130
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3130
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3130
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3130
    }
#line 3130
   /* update xpp and tp */
#line 3130
    if (realign) xp = (short *) *xpp;
#line 3130
    xp += ni;
#line 3130
    tp += ni;
#line 3130
    *xpp = (void*)xp;
#line 3130
  }
#line 3130
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3130

#line 3130
#else   /* not SX */
#line 3130
	const char *xp = (const char *) *xpp;
#line 3130
	int status = NC_NOERR;
#line 3130

#line 3130
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3130
	{
#line 3130
		const int lstatus = ncx_get_short_float(xp, tp);
#line 3130
		if (status == NC_NOERR) /* report the first encountered error */
#line 3130
			status = lstatus;
#line 3130
	}
#line 3130

#line 3130
	*xpp = (const void *)xp;
#line 3130
	return status;
#line 3130
#endif
#line 3130
}
#line 3130

int
#line 3131
ncx_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 3131
{
#line 3131
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3131

#line 3131
 /* basic algorithm is:
#line 3131
  *   - ensure sane alignment of input data
#line 3131
  *   - copy (conversion happens automatically) input data
#line 3131
  *     to output
#line 3131
  *   - update xpp to point at next unconverted input, and tp to point
#line 3131
  *     at next location for converted output
#line 3131
  */
#line 3131
  long i, j, ni;
#line 3131
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3131
  short *xp;
#line 3131
  int nrange = 0;         /* number of range errors */
#line 3131
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3131
  long cxp = (long) *((char**)xpp);
#line 3131

#line 3131
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3131
  /* sjl: manually stripmine so we can limit amount of
#line 3131
   * vector work space reserved to LOOPCNT elements. Also
#line 3131
   * makes vectorisation easy */
#line 3131
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3131
    ni=Min(nelems-j,LOOPCNT);
#line 3131
    if (realign) {
#line 3131
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3131
      xp = tmp;
#line 3131
    } else {
#line 3131
      xp = (short *) *xpp;
#line 3131
    }
#line 3131
   /* copy the next block */
#line 3131
#pragma cdir loopcnt=LOOPCNT
#line 3131
#pragma cdir shortloop
#line 3131
    for (i=0; i<ni; i++) {
#line 3131
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3131
     /* test for range errors (not always needed but do it anyway) */
#line 3131
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3131
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3131
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3131
    }
#line 3131
   /* update xpp and tp */
#line 3131
    if (realign) xp = (short *) *xpp;
#line 3131
    xp += ni;
#line 3131
    tp += ni;
#line 3131
    *xpp = (void*)xp;
#line 3131
  }
#line 3131
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3131

#line 3131
#else   /* not SX */
#line 3131
	const char *xp = (const char *) *xpp;
#line 3131
	int status = NC_NOERR;
#line 3131

#line 3131
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3131
	{
#line 3131
		const int lstatus = ncx_get_short_double(xp, tp);
#line 3131
		if (status == NC_NOERR) /* report the first encountered error */
#line 3131
			status = lstatus;
#line 3131
	}
#line 3131

#line 3131
	*xpp = (const void *)xp;
#line 3131
	return status;
#line 3131
#endif
#line 3131
}
#line 3131

int
#line 3132
ncx_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3132
{
#line 3132
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3132

#line 3132
 /* basic algorithm is:
#line 3132
  *   - ensure sane alignment of input data
#line 3132
  *   - copy (conversion happens automatically) input data
#line 3132
  *     to output
#line 3132
  *   - update xpp to point at next unconverted input, and tp to point
#line 3132
  *     at next location for converted output
#line 3132
  */
#line 3132
  long i, j, ni;
#line 3132
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3132
  short *xp;
#line 3132
  int nrange = 0;         /* number of range errors */
#line 3132
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3132
  long cxp = (long) *((char**)xpp);
#line 3132

#line 3132
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3132
  /* sjl: manually stripmine so we can limit amount of
#line 3132
   * vector work space reserved to LOOPCNT elements. Also
#line 3132
   * makes vectorisation easy */
#line 3132
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3132
    ni=Min(nelems-j,LOOPCNT);
#line 3132
    if (realign) {
#line 3132
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3132
      xp = tmp;
#line 3132
    } else {
#line 3132
      xp = (short *) *xpp;
#line 3132
    }
#line 3132
   /* copy the next block */
#line 3132
#pragma cdir loopcnt=LOOPCNT
#line 3132
#pragma cdir shortloop
#line 3132
    for (i=0; i<ni; i++) {
#line 3132
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3132
     /* test for range errors (not always needed but do it anyway) */
#line 3132
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3132
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3132
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3132
    }
#line 3132
   /* update xpp and tp */
#line 3132
    if (realign) xp = (short *) *xpp;
#line 3132
    xp += ni;
#line 3132
    tp += ni;
#line 3132
    *xpp = (void*)xp;
#line 3132
  }
#line 3132
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3132

#line 3132
#else   /* not SX */
#line 3132
	const char *xp = (const char *) *xpp;
#line 3132
	int status = NC_NOERR;
#line 3132

#line 3132
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3132
	{
#line 3132
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 3132
		if (status == NC_NOERR) /* report the first encountered error */
#line 3132
			status = lstatus;
#line 3132
	}
#line 3132

#line 3132
	*xpp = (const void *)xp;
#line 3132
	return status;
#line 3132
#endif
#line 3132
}
#line 3132

int
#line 3133
ncx_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3133
{
#line 3133
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3133

#line 3133
 /* basic algorithm is:
#line 3133
  *   - ensure sane alignment of input data
#line 3133
  *   - copy (conversion happens automatically) input data
#line 3133
  *     to output
#line 3133
  *   - update xpp to point at next unconverted input, and tp to point
#line 3133
  *     at next location for converted output
#line 3133
  */
#line 3133
  long i, j, ni;
#line 3133
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3133
  short *xp;
#line 3133
  int nrange = 0;         /* number of range errors */
#line 3133
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3133
  long cxp = (long) *((char**)xpp);
#line 3133

#line 3133
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3133
  /* sjl: manually stripmine so we can limit amount of
#line 3133
   * vector work space reserved to LOOPCNT elements. Also
#line 3133
   * makes vectorisation easy */
#line 3133
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3133
    ni=Min(nelems-j,LOOPCNT);
#line 3133
    if (realign) {
#line 3133
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3133
      xp = tmp;
#line 3133
    } else {
#line 3133
      xp = (short *) *xpp;
#line 3133
    }
#line 3133
   /* copy the next block */
#line 3133
#pragma cdir loopcnt=LOOPCNT
#line 3133
#pragma cdir shortloop
#line 3133
    for (i=0; i<ni; i++) {
#line 3133
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3133
     /* test for range errors (not always needed but do it anyway) */
#line 3133
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3133
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3133
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3133
    }
#line 3133
   /* update xpp and tp */
#line 3133
    if (realign) xp = (short *) *xpp;
#line 3133
    xp += ni;
#line 3133
    tp += ni;
#line 3133
    *xpp = (void*)xp;
#line 3133
  }
#line 3133
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3133

#line 3133
#else   /* not SX */
#line 3133
	const char *xp = (const char *) *xpp;
#line 3133
	int status = NC_NOERR;
#line 3133

#line 3133
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3133
	{
#line 3133
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 3133
		if (status == NC_NOERR) /* report the first encountered error */
#line 3133
			status = lstatus;
#line 3133
	}
#line 3133

#line 3133
	*xpp = (const void *)xp;
#line 3133
	return status;
#line 3133
#endif
#line 3133
}
#line 3133

int
#line 3134
ncx_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3134
{
#line 3134
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3134

#line 3134
 /* basic algorithm is:
#line 3134
  *   - ensure sane alignment of input data
#line 3134
  *   - copy (conversion happens automatically) input data
#line 3134
  *     to output
#line 3134
  *   - update xpp to point at next unconverted input, and tp to point
#line 3134
  *     at next location for converted output
#line 3134
  */
#line 3134
  long i, j, ni;
#line 3134
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3134
  short *xp;
#line 3134
  int nrange = 0;         /* number of range errors */
#line 3134
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3134
  long cxp = (long) *((char**)xpp);
#line 3134

#line 3134
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3134
  /* sjl: manually stripmine so we can limit amount of
#line 3134
   * vector work space reserved to LOOPCNT elements. Also
#line 3134
   * makes vectorisation easy */
#line 3134
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3134
    ni=Min(nelems-j,LOOPCNT);
#line 3134
    if (realign) {
#line 3134
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3134
      xp = tmp;
#line 3134
    } else {
#line 3134
      xp = (short *) *xpp;
#line 3134
    }
#line 3134
   /* copy the next block */
#line 3134
#pragma cdir loopcnt=LOOPCNT
#line 3134
#pragma cdir shortloop
#line 3134
    for (i=0; i<ni; i++) {
#line 3134
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3134
     /* test for range errors (not always needed but do it anyway) */
#line 3134
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3134
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3134
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3134
    }
#line 3134
   /* update xpp and tp */
#line 3134
    if (realign) xp = (short *) *xpp;
#line 3134
    xp += ni;
#line 3134
    tp += ni;
#line 3134
    *xpp = (void*)xp;
#line 3134
  }
#line 3134
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3134

#line 3134
#else   /* not SX */
#line 3134
	const char *xp = (const char *) *xpp;
#line 3134
	int status = NC_NOERR;
#line 3134

#line 3134
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3134
	{
#line 3134
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 3134
		if (status == NC_NOERR) /* report the first encountered error */
#line 3134
			status = lstatus;
#line 3134
	}
#line 3134

#line 3134
	*xpp = (const void *)xp;
#line 3134
	return status;
#line 3134
#endif
#line 3134
}
#line 3134

int
#line 3135
ncx_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 3135
{
#line 3135
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3135

#line 3135
 /* basic algorithm is:
#line 3135
  *   - ensure sane alignment of input data
#line 3135
  *   - copy (conversion happens automatically) input data
#line 3135
  *     to output
#line 3135
  *   - update xpp to point at next unconverted input, and tp to point
#line 3135
  *     at next location for converted output
#line 3135
  */
#line 3135
  long i, j, ni;
#line 3135
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3135
  short *xp;
#line 3135
  int nrange = 0;         /* number of range errors */
#line 3135
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3135
  long cxp = (long) *((char**)xpp);
#line 3135

#line 3135
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3135
  /* sjl: manually stripmine so we can limit amount of
#line 3135
   * vector work space reserved to LOOPCNT elements. Also
#line 3135
   * makes vectorisation easy */
#line 3135
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3135
    ni=Min(nelems-j,LOOPCNT);
#line 3135
    if (realign) {
#line 3135
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3135
      xp = tmp;
#line 3135
    } else {
#line 3135
      xp = (short *) *xpp;
#line 3135
    }
#line 3135
   /* copy the next block */
#line 3135
#pragma cdir loopcnt=LOOPCNT
#line 3135
#pragma cdir shortloop
#line 3135
    for (i=0; i<ni; i++) {
#line 3135
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3135
     /* test for range errors (not always needed but do it anyway) */
#line 3135
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3135
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3135
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3135
    }
#line 3135
   /* update xpp and tp */
#line 3135
    if (realign) xp = (short *) *xpp;
#line 3135
    xp += ni;
#line 3135
    tp += ni;
#line 3135
    *xpp = (void*)xp;
#line 3135
  }
#line 3135
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3135

#line 3135
#else   /* not SX */
#line 3135
	const char *xp = (const char *) *xpp;
#line 3135
	int status = NC_NOERR;
#line 3135

#line 3135
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3135
	{
#line 3135
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 3135
		if (status == NC_NOERR) /* report the first encountered error */
#line 3135
			status = lstatus;
#line 3135
	}
#line 3135

#line 3135
	*xpp = (const void *)xp;
#line 3135
	return status;
#line 3135
#endif
#line 3135
}
#line 3135

int
#line 3136
ncx_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3136
{
#line 3136
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3136

#line 3136
 /* basic algorithm is:
#line 3136
  *   - ensure sane alignment of input data
#line 3136
  *   - copy (conversion happens automatically) input data
#line 3136
  *     to output
#line 3136
  *   - update xpp to point at next unconverted input, and tp to point
#line 3136
  *     at next location for converted output
#line 3136
  */
#line 3136
  long i, j, ni;
#line 3136
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3136
  short *xp;
#line 3136
  int nrange = 0;         /* number of range errors */
#line 3136
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3136
  long cxp = (long) *((char**)xpp);
#line 3136

#line 3136
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3136
  /* sjl: manually stripmine so we can limit amount of
#line 3136
   * vector work space reserved to LOOPCNT elements. Also
#line 3136
   * makes vectorisation easy */
#line 3136
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3136
    ni=Min(nelems-j,LOOPCNT);
#line 3136
    if (realign) {
#line 3136
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_SHORT));
#line 3136
      xp = tmp;
#line 3136
    } else {
#line 3136
      xp = (short *) *xpp;
#line 3136
    }
#line 3136
   /* copy the next block */
#line 3136
#pragma cdir loopcnt=LOOPCNT
#line 3136
#pragma cdir shortloop
#line 3136
    for (i=0; i<ni; i++) {
#line 3136
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3136
     /* test for range errors (not always needed but do it anyway) */
#line 3136
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3136
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3136
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3136
    }
#line 3136
   /* update xpp and tp */
#line 3136
    if (realign) xp = (short *) *xpp;
#line 3136
    xp += ni;
#line 3136
    tp += ni;
#line 3136
    *xpp = (void*)xp;
#line 3136
  }
#line 3136
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3136

#line 3136
#else   /* not SX */
#line 3136
	const char *xp = (const char *) *xpp;
#line 3136
	int status = NC_NOERR;
#line 3136

#line 3136
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3136
	{
#line 3136
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 3136
		if (status == NC_NOERR) /* report the first encountered error */
#line 3136
			status = lstatus;
#line 3136
	}
#line 3136

#line 3136
	*xpp = (const void *)xp;
#line 3136
	return status;
#line 3136
#endif
#line 3136
}
#line 3136


int
#line 3138
ncx_pad_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 3138
{
#line 3138
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3138

#line 3138
	const char *xp = (const char *) *xpp;
#line 3138
	int status = NC_NOERR;
#line 3138

#line 3138
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3138
	{
#line 3138
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 3138
		if (status == NC_NOERR) /* report the first encountered error */
#line 3138
			status = lstatus;
#line 3138
	}
#line 3138

#line 3138
	if (rndup != 0)
#line 3138
		xp += X_SIZEOF_SHORT;
#line 3138

#line 3138
	*xpp = (void *)xp;
#line 3138
	return status;
#line 3138
}
#line 3138

int
#line 3139
ncx_pad_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3139
{
#line 3139
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3139

#line 3139
	const char *xp = (const char *) *xpp;
#line 3139
	int status = NC_NOERR;
#line 3139

#line 3139
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3139
	{
#line 3139
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 3139
		if (status == NC_NOERR) /* report the first encountered error */
#line 3139
			status = lstatus;
#line 3139
	}
#line 3139

#line 3139
	if (rndup != 0)
#line 3139
		xp += X_SIZEOF_SHORT;
#line 3139

#line 3139
	*xpp = (void *)xp;
#line 3139
	return status;
#line 3139
}
#line 3139

int
#line 3140
ncx_pad_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 3140
{
#line 3140
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3140

#line 3140
	const char *xp = (const char *) *xpp;
#line 3140
	int status = NC_NOERR;
#line 3140

#line 3140
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3140
	{
#line 3140
		const int lstatus = ncx_get_short_short(xp, tp);
#line 3140
		if (status == NC_NOERR) /* report the first encountered error */
#line 3140
			status = lstatus;
#line 3140
	}
#line 3140

#line 3140
	if (rndup != 0)
#line 3140
		xp += X_SIZEOF_SHORT;
#line 3140

#line 3140
	*xpp = (void *)xp;
#line 3140
	return status;
#line 3140
}
#line 3140

int
#line 3141
ncx_pad_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 3141
{
#line 3141
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3141

#line 3141
	const char *xp = (const char *) *xpp;
#line 3141
	int status = NC_NOERR;
#line 3141

#line 3141
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3141
	{
#line 3141
		const int lstatus = ncx_get_short_int(xp, tp);
#line 3141
		if (status == NC_NOERR) /* report the first encountered error */
#line 3141
			status = lstatus;
#line 3141
	}
#line 3141

#line 3141
	if (rndup != 0)
#line 3141
		xp += X_SIZEOF_SHORT;
#line 3141

#line 3141
	*xpp = (void *)xp;
#line 3141
	return status;
#line 3141
}
#line 3141

int
#line 3142
ncx_pad_getn_short_long(const void **xpp, size_t nelems, long *tp)
#line 3142
{
#line 3142
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3142

#line 3142
	const char *xp = (const char *) *xpp;
#line 3142
	int status = NC_NOERR;
#line 3142

#line 3142
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3142
	{
#line 3142
		const int lstatus = ncx_get_short_long(xp, tp);
#line 3142
		if (status == NC_NOERR) /* report the first encountered error */
#line 3142
			status = lstatus;
#line 3142
	}
#line 3142

#line 3142
	if (rndup != 0)
#line 3142
		xp += X_SIZEOF_SHORT;
#line 3142

#line 3142
	*xpp = (void *)xp;
#line 3142
	return status;
#line 3142
}
#line 3142

int
#line 3143
ncx_pad_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 3143
{
#line 3143
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3143

#line 3143
	const char *xp = (const char *) *xpp;
#line 3143
	int status = NC_NOERR;
#line 3143

#line 3143
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3143
	{
#line 3143
		const int lstatus = ncx_get_short_float(xp, tp);
#line 3143
		if (status == NC_NOERR) /* report the first encountered error */
#line 3143
			status = lstatus;
#line 3143
	}
#line 3143

#line 3143
	if (rndup != 0)
#line 3143
		xp += X_SIZEOF_SHORT;
#line 3143

#line 3143
	*xpp = (void *)xp;
#line 3143
	return status;
#line 3143
}
#line 3143

int
#line 3144
ncx_pad_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 3144
{
#line 3144
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3144

#line 3144
	const char *xp = (const char *) *xpp;
#line 3144
	int status = NC_NOERR;
#line 3144

#line 3144
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3144
	{
#line 3144
		const int lstatus = ncx_get_short_double(xp, tp);
#line 3144
		if (status == NC_NOERR) /* report the first encountered error */
#line 3144
			status = lstatus;
#line 3144
	}
#line 3144

#line 3144
	if (rndup != 0)
#line 3144
		xp += X_SIZEOF_SHORT;
#line 3144

#line 3144
	*xpp = (void *)xp;
#line 3144
	return status;
#line 3144
}
#line 3144

int
#line 3145
ncx_pad_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 3145
{
#line 3145
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3145

#line 3145
	const char *xp = (const char *) *xpp;
#line 3145
	int status = NC_NOERR;
#line 3145

#line 3145
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3145
	{
#line 3145
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 3145
		if (status == NC_NOERR) /* report the first encountered error */
#line 3145
			status = lstatus;
#line 3145
	}
#line 3145

#line 3145
	if (rndup != 0)
#line 3145
		xp += X_SIZEOF_SHORT;
#line 3145

#line 3145
	*xpp = (void *)xp;
#line 3145
	return status;
#line 3145
}
#line 3145

int
#line 3146
ncx_pad_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3146
{
#line 3146
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3146

#line 3146
	const char *xp = (const char *) *xpp;
#line 3146
	int status = NC_NOERR;
#line 3146

#line 3146
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3146
	{
#line 3146
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 3146
		if (status == NC_NOERR) /* report the first encountered error */
#line 3146
			status = lstatus;
#line 3146
	}
#line 3146

#line 3146
	if (rndup != 0)
#line 3146
		xp += X_SIZEOF_SHORT;
#line 3146

#line 3146
	*xpp = (void *)xp;
#line 3146
	return status;
#line 3146
}
#line 3146

int
#line 3147
ncx_pad_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3147
{
#line 3147
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3147

#line 3147
	const char *xp = (const char *) *xpp;
#line 3147
	int status = NC_NOERR;
#line 3147

#line 3147
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3147
	{
#line 3147
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 3147
		if (status == NC_NOERR) /* report the first encountered error */
#line 3147
			status = lstatus;
#line 3147
	}
#line 3147

#line 3147
	if (rndup != 0)
#line 3147
		xp += X_SIZEOF_SHORT;
#line 3147

#line 3147
	*xpp = (void *)xp;
#line 3147
	return status;
#line 3147
}
#line 3147

int
#line 3148
ncx_pad_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3148
{
#line 3148
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3148

#line 3148
	const char *xp = (const char *) *xpp;
#line 3148
	int status = NC_NOERR;
#line 3148

#line 3148
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3148
	{
#line 3148
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 3148
		if (status == NC_NOERR) /* report the first encountered error */
#line 3148
			status = lstatus;
#line 3148
	}
#line 3148

#line 3148
	if (rndup != 0)
#line 3148
		xp += X_SIZEOF_SHORT;
#line 3148

#line 3148
	*xpp = (void *)xp;
#line 3148
	return status;
#line 3148
}
#line 3148


#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_SHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 3164
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3164
{
#line 3164
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3164

#line 3164
 /* basic algorithm is:
#line 3164
  *   - ensure sane alignment of output data
#line 3164
  *   - copy (conversion happens automatically) input data
#line 3164
  *     to output
#line 3164
  *   - update tp to point at next unconverted input, and xpp to point
#line 3164
  *     at next location for converted output
#line 3164
  */
#line 3164
  long i, j, ni;
#line 3164
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3164
  short *xp;
#line 3164
  int nrange = 0;         /* number of range errors */
#line 3164
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3164
  long cxp = (long) *((char**)xpp);
#line 3164

#line 3164
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3164
  /* sjl: manually stripmine so we can limit amount of
#line 3164
   * vector work space reserved to LOOPCNT elements. Also
#line 3164
   * makes vectorisation easy */
#line 3164
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3164
    ni=Min(nelems-j,LOOPCNT);
#line 3164
    if (realign) {
#line 3164
      xp = tmp;
#line 3164
    } else {
#line 3164
      xp = (short *) *xpp;
#line 3164
    }
#line 3164
   /* copy the next block */
#line 3164
#pragma cdir loopcnt=LOOPCNT
#line 3164
#pragma cdir shortloop
#line 3164
    for (i=0; i<ni; i++) {
#line 3164
      /* the normal case: */
#line 3164
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3164
     /* test for range errors (not always needed but do it anyway) */
#line 3164
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3164
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3164
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3164
    }
#line 3164
   /* copy workspace back if necessary */
#line 3164
    if (realign) {
#line 3164
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3164
      xp = (short *) *xpp;
#line 3164
    }
#line 3164
   /* update xpp and tp */
#line 3164
    xp += ni;
#line 3164
    tp += ni;
#line 3164
    *xpp = (void*)xp;
#line 3164
  }
#line 3164
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3164

#line 3164
#else   /* not SX */
#line 3164

#line 3164
	char *xp = (char *) *xpp;
#line 3164
	int status = NC_NOERR;
#line 3164

#line 3164
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3164
	{
#line 3164
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 3164
		if (status == NC_NOERR) /* report the first encountered error */
#line 3164
			status = lstatus;
#line 3164
	}
#line 3164

#line 3164
	*xpp = (void *)xp;
#line 3164
	return status;
#line 3164
#endif
#line 3164
}
#line 3164

#endif
int
#line 3166
ncx_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3166
{
#line 3166
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3166

#line 3166
 /* basic algorithm is:
#line 3166
  *   - ensure sane alignment of output data
#line 3166
  *   - copy (conversion happens automatically) input data
#line 3166
  *     to output
#line 3166
  *   - update tp to point at next unconverted input, and xpp to point
#line 3166
  *     at next location for converted output
#line 3166
  */
#line 3166
  long i, j, ni;
#line 3166
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3166
  short *xp;
#line 3166
  int nrange = 0;         /* number of range errors */
#line 3166
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3166
  long cxp = (long) *((char**)xpp);
#line 3166

#line 3166
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3166
  /* sjl: manually stripmine so we can limit amount of
#line 3166
   * vector work space reserved to LOOPCNT elements. Also
#line 3166
   * makes vectorisation easy */
#line 3166
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3166
    ni=Min(nelems-j,LOOPCNT);
#line 3166
    if (realign) {
#line 3166
      xp = tmp;
#line 3166
    } else {
#line 3166
      xp = (short *) *xpp;
#line 3166
    }
#line 3166
   /* copy the next block */
#line 3166
#pragma cdir loopcnt=LOOPCNT
#line 3166
#pragma cdir shortloop
#line 3166
    for (i=0; i<ni; i++) {
#line 3166
      /* the normal case: */
#line 3166
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3166
     /* test for range errors (not always needed but do it anyway) */
#line 3166
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3166
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3166
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3166
    }
#line 3166
   /* copy workspace back if necessary */
#line 3166
    if (realign) {
#line 3166
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3166
      xp = (short *) *xpp;
#line 3166
    }
#line 3166
   /* update xpp and tp */
#line 3166
    xp += ni;
#line 3166
    tp += ni;
#line 3166
    *xpp = (void*)xp;
#line 3166
  }
#line 3166
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3166

#line 3166
#else   /* not SX */
#line 3166

#line 3166
	char *xp = (char *) *xpp;
#line 3166
	int status = NC_NOERR;
#line 3166

#line 3166
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3166
	{
#line 3166
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 3166
		if (status == NC_NOERR) /* report the first encountered error */
#line 3166
			status = lstatus;
#line 3166
	}
#line 3166

#line 3166
	*xpp = (void *)xp;
#line 3166
	return status;
#line 3166
#endif
#line 3166
}
#line 3166

int
#line 3167
ncx_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3167
{
#line 3167
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3167

#line 3167
 /* basic algorithm is:
#line 3167
  *   - ensure sane alignment of output data
#line 3167
  *   - copy (conversion happens automatically) input data
#line 3167
  *     to output
#line 3167
  *   - update tp to point at next unconverted input, and xpp to point
#line 3167
  *     at next location for converted output
#line 3167
  */
#line 3167
  long i, j, ni;
#line 3167
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3167
  short *xp;
#line 3167
  int nrange = 0;         /* number of range errors */
#line 3167
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3167
  long cxp = (long) *((char**)xpp);
#line 3167

#line 3167
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3167
  /* sjl: manually stripmine so we can limit amount of
#line 3167
   * vector work space reserved to LOOPCNT elements. Also
#line 3167
   * makes vectorisation easy */
#line 3167
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3167
    ni=Min(nelems-j,LOOPCNT);
#line 3167
    if (realign) {
#line 3167
      xp = tmp;
#line 3167
    } else {
#line 3167
      xp = (short *) *xpp;
#line 3167
    }
#line 3167
   /* copy the next block */
#line 3167
#pragma cdir loopcnt=LOOPCNT
#line 3167
#pragma cdir shortloop
#line 3167
    for (i=0; i<ni; i++) {
#line 3167
      /* the normal case: */
#line 3167
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3167
     /* test for range errors (not always needed but do it anyway) */
#line 3167
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3167
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3167
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3167
    }
#line 3167
   /* copy workspace back if necessary */
#line 3167
    if (realign) {
#line 3167
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3167
      xp = (short *) *xpp;
#line 3167
    }
#line 3167
   /* update xpp and tp */
#line 3167
    xp += ni;
#line 3167
    tp += ni;
#line 3167
    *xpp = (void*)xp;
#line 3167
  }
#line 3167
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3167

#line 3167
#else   /* not SX */
#line 3167

#line 3167
	char *xp = (char *) *xpp;
#line 3167
	int status = NC_NOERR;
#line 3167

#line 3167
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3167
	{
#line 3167
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 3167
		if (status == NC_NOERR) /* report the first encountered error */
#line 3167
			status = lstatus;
#line 3167
	}
#line 3167

#line 3167
	*xpp = (void *)xp;
#line 3167
	return status;
#line 3167
#endif
#line 3167
}
#line 3167

int
#line 3168
ncx_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3168
{
#line 3168
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3168

#line 3168
 /* basic algorithm is:
#line 3168
  *   - ensure sane alignment of output data
#line 3168
  *   - copy (conversion happens automatically) input data
#line 3168
  *     to output
#line 3168
  *   - update tp to point at next unconverted input, and xpp to point
#line 3168
  *     at next location for converted output
#line 3168
  */
#line 3168
  long i, j, ni;
#line 3168
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3168
  short *xp;
#line 3168
  int nrange = 0;         /* number of range errors */
#line 3168
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3168
  long cxp = (long) *((char**)xpp);
#line 3168

#line 3168
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3168
  /* sjl: manually stripmine so we can limit amount of
#line 3168
   * vector work space reserved to LOOPCNT elements. Also
#line 3168
   * makes vectorisation easy */
#line 3168
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3168
    ni=Min(nelems-j,LOOPCNT);
#line 3168
    if (realign) {
#line 3168
      xp = tmp;
#line 3168
    } else {
#line 3168
      xp = (short *) *xpp;
#line 3168
    }
#line 3168
   /* copy the next block */
#line 3168
#pragma cdir loopcnt=LOOPCNT
#line 3168
#pragma cdir shortloop
#line 3168
    for (i=0; i<ni; i++) {
#line 3168
      /* the normal case: */
#line 3168
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3168
     /* test for range errors (not always needed but do it anyway) */
#line 3168
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3168
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3168
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3168
    }
#line 3168
   /* copy workspace back if necessary */
#line 3168
    if (realign) {
#line 3168
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3168
      xp = (short *) *xpp;
#line 3168
    }
#line 3168
   /* update xpp and tp */
#line 3168
    xp += ni;
#line 3168
    tp += ni;
#line 3168
    *xpp = (void*)xp;
#line 3168
  }
#line 3168
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3168

#line 3168
#else   /* not SX */
#line 3168

#line 3168
	char *xp = (char *) *xpp;
#line 3168
	int status = NC_NOERR;
#line 3168

#line 3168
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3168
	{
#line 3168
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 3168
		if (status == NC_NOERR) /* report the first encountered error */
#line 3168
			status = lstatus;
#line 3168
	}
#line 3168

#line 3168
	*xpp = (void *)xp;
#line 3168
	return status;
#line 3168
#endif
#line 3168
}
#line 3168

int
#line 3169
ncx_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3169
{
#line 3169
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3169

#line 3169
 /* basic algorithm is:
#line 3169
  *   - ensure sane alignment of output data
#line 3169
  *   - copy (conversion happens automatically) input data
#line 3169
  *     to output
#line 3169
  *   - update tp to point at next unconverted input, and xpp to point
#line 3169
  *     at next location for converted output
#line 3169
  */
#line 3169
  long i, j, ni;
#line 3169
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3169
  short *xp;
#line 3169
  int nrange = 0;         /* number of range errors */
#line 3169
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3169
  long cxp = (long) *((char**)xpp);
#line 3169

#line 3169
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3169
  /* sjl: manually stripmine so we can limit amount of
#line 3169
   * vector work space reserved to LOOPCNT elements. Also
#line 3169
   * makes vectorisation easy */
#line 3169
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3169
    ni=Min(nelems-j,LOOPCNT);
#line 3169
    if (realign) {
#line 3169
      xp = tmp;
#line 3169
    } else {
#line 3169
      xp = (short *) *xpp;
#line 3169
    }
#line 3169
   /* copy the next block */
#line 3169
#pragma cdir loopcnt=LOOPCNT
#line 3169
#pragma cdir shortloop
#line 3169
    for (i=0; i<ni; i++) {
#line 3169
      /* the normal case: */
#line 3169
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3169
     /* test for range errors (not always needed but do it anyway) */
#line 3169
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3169
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3169
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3169
    }
#line 3169
   /* copy workspace back if necessary */
#line 3169
    if (realign) {
#line 3169
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3169
      xp = (short *) *xpp;
#line 3169
    }
#line 3169
   /* update xpp and tp */
#line 3169
    xp += ni;
#line 3169
    tp += ni;
#line 3169
    *xpp = (void*)xp;
#line 3169
  }
#line 3169
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3169

#line 3169
#else   /* not SX */
#line 3169

#line 3169
	char *xp = (char *) *xpp;
#line 3169
	int status = NC_NOERR;
#line 3169

#line 3169
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3169
	{
#line 3169
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 3169
		if (status == NC_NOERR) /* report the first encountered error */
#line 3169
			status = lstatus;
#line 3169
	}
#line 3169

#line 3169
	*xpp = (void *)xp;
#line 3169
	return status;
#line 3169
#endif
#line 3169
}
#line 3169

int
#line 3170
ncx_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3170
{
#line 3170
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3170

#line 3170
 /* basic algorithm is:
#line 3170
  *   - ensure sane alignment of output data
#line 3170
  *   - copy (conversion happens automatically) input data
#line 3170
  *     to output
#line 3170
  *   - update tp to point at next unconverted input, and xpp to point
#line 3170
  *     at next location for converted output
#line 3170
  */
#line 3170
  long i, j, ni;
#line 3170
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3170
  short *xp;
#line 3170
  int nrange = 0;         /* number of range errors */
#line 3170
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3170
  long cxp = (long) *((char**)xpp);
#line 3170

#line 3170
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3170
  /* sjl: manually stripmine so we can limit amount of
#line 3170
   * vector work space reserved to LOOPCNT elements. Also
#line 3170
   * makes vectorisation easy */
#line 3170
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3170
    ni=Min(nelems-j,LOOPCNT);
#line 3170
    if (realign) {
#line 3170
      xp = tmp;
#line 3170
    } else {
#line 3170
      xp = (short *) *xpp;
#line 3170
    }
#line 3170
   /* copy the next block */
#line 3170
#pragma cdir loopcnt=LOOPCNT
#line 3170
#pragma cdir shortloop
#line 3170
    for (i=0; i<ni; i++) {
#line 3170
      /* the normal case: */
#line 3170
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3170
     /* test for range errors (not always needed but do it anyway) */
#line 3170
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3170
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3170
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3170
    }
#line 3170
   /* copy workspace back if necessary */
#line 3170
    if (realign) {
#line 3170
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3170
      xp = (short *) *xpp;
#line 3170
    }
#line 3170
   /* update xpp and tp */
#line 3170
    xp += ni;
#line 3170
    tp += ni;
#line 3170
    *xpp = (void*)xp;
#line 3170
  }
#line 3170
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3170

#line 3170
#else   /* not SX */
#line 3170

#line 3170
	char *xp = (char *) *xpp;
#line 3170
	int status = NC_NOERR;
#line 3170

#line 3170
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3170
	{
#line 3170
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 3170
		if (status == NC_NOERR) /* report the first encountered error */
#line 3170
			status = lstatus;
#line 3170
	}
#line 3170

#line 3170
	*xpp = (void *)xp;
#line 3170
	return status;
#line 3170
#endif
#line 3170
}
#line 3170

int
#line 3171
ncx_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3171
{
#line 3171
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3171

#line 3171
 /* basic algorithm is:
#line 3171
  *   - ensure sane alignment of output data
#line 3171
  *   - copy (conversion happens automatically) input data
#line 3171
  *     to output
#line 3171
  *   - update tp to point at next unconverted input, and xpp to point
#line 3171
  *     at next location for converted output
#line 3171
  */
#line 3171
  long i, j, ni;
#line 3171
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3171
  short *xp;
#line 3171
  int nrange = 0;         /* number of range errors */
#line 3171
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3171
  long cxp = (long) *((char**)xpp);
#line 3171

#line 3171
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3171
  /* sjl: manually stripmine so we can limit amount of
#line 3171
   * vector work space reserved to LOOPCNT elements. Also
#line 3171
   * makes vectorisation easy */
#line 3171
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3171
    ni=Min(nelems-j,LOOPCNT);
#line 3171
    if (realign) {
#line 3171
      xp = tmp;
#line 3171
    } else {
#line 3171
      xp = (short *) *xpp;
#line 3171
    }
#line 3171
   /* copy the next block */
#line 3171
#pragma cdir loopcnt=LOOPCNT
#line 3171
#pragma cdir shortloop
#line 3171
    for (i=0; i<ni; i++) {
#line 3171
      /* the normal case: */
#line 3171
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3171
     /* test for range errors (not always needed but do it anyway) */
#line 3171
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3171
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3171
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 3171
    }
#line 3171
   /* copy workspace back if necessary */
#line 3171
    if (realign) {
#line 3171
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3171
      xp = (short *) *xpp;
#line 3171
    }
#line 3171
   /* update xpp and tp */
#line 3171
    xp += ni;
#line 3171
    tp += ni;
#line 3171
    *xpp = (void*)xp;
#line 3171
  }
#line 3171
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3171

#line 3171
#else   /* not SX */
#line 3171

#line 3171
	char *xp = (char *) *xpp;
#line 3171
	int status = NC_NOERR;
#line 3171

#line 3171
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3171
	{
#line 3171
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 3171
		if (status == NC_NOERR) /* report the first encountered error */
#line 3171
			status = lstatus;
#line 3171
	}
#line 3171

#line 3171
	*xpp = (void *)xp;
#line 3171
	return status;
#line 3171
#endif
#line 3171
}
#line 3171

int
#line 3172
ncx_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3172
{
#line 3172
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3172

#line 3172
 /* basic algorithm is:
#line 3172
  *   - ensure sane alignment of output data
#line 3172
  *   - copy (conversion happens automatically) input data
#line 3172
  *     to output
#line 3172
  *   - update tp to point at next unconverted input, and xpp to point
#line 3172
  *     at next location for converted output
#line 3172
  */
#line 3172
  long i, j, ni;
#line 3172
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3172
  short *xp;
#line 3172
  int nrange = 0;         /* number of range errors */
#line 3172
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3172
  long cxp = (long) *((char**)xpp);
#line 3172

#line 3172
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3172
  /* sjl: manually stripmine so we can limit amount of
#line 3172
   * vector work space reserved to LOOPCNT elements. Also
#line 3172
   * makes vectorisation easy */
#line 3172
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3172
    ni=Min(nelems-j,LOOPCNT);
#line 3172
    if (realign) {
#line 3172
      xp = tmp;
#line 3172
    } else {
#line 3172
      xp = (short *) *xpp;
#line 3172
    }
#line 3172
   /* copy the next block */
#line 3172
#pragma cdir loopcnt=LOOPCNT
#line 3172
#pragma cdir shortloop
#line 3172
    for (i=0; i<ni; i++) {
#line 3172
      /* the normal case: */
#line 3172
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3172
     /* test for range errors (not always needed but do it anyway) */
#line 3172
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3172
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3172
      nrange += tp[i] > X_SHORT_MAX ;
#line 3172
    }
#line 3172
   /* copy workspace back if necessary */
#line 3172
    if (realign) {
#line 3172
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3172
      xp = (short *) *xpp;
#line 3172
    }
#line 3172
   /* update xpp and tp */
#line 3172
    xp += ni;
#line 3172
    tp += ni;
#line 3172
    *xpp = (void*)xp;
#line 3172
  }
#line 3172
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3172

#line 3172
#else   /* not SX */
#line 3172

#line 3172
	char *xp = (char *) *xpp;
#line 3172
	int status = NC_NOERR;
#line 3172

#line 3172
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3172
	{
#line 3172
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 3172
		if (status == NC_NOERR) /* report the first encountered error */
#line 3172
			status = lstatus;
#line 3172
	}
#line 3172

#line 3172
	*xpp = (void *)xp;
#line 3172
	return status;
#line 3172
#endif
#line 3172
}
#line 3172

int
#line 3173
ncx_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3173
{
#line 3173
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3173

#line 3173
 /* basic algorithm is:
#line 3173
  *   - ensure sane alignment of output data
#line 3173
  *   - copy (conversion happens automatically) input data
#line 3173
  *     to output
#line 3173
  *   - update tp to point at next unconverted input, and xpp to point
#line 3173
  *     at next location for converted output
#line 3173
  */
#line 3173
  long i, j, ni;
#line 3173
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3173
  short *xp;
#line 3173
  int nrange = 0;         /* number of range errors */
#line 3173
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3173
  long cxp = (long) *((char**)xpp);
#line 3173

#line 3173
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3173
  /* sjl: manually stripmine so we can limit amount of
#line 3173
   * vector work space reserved to LOOPCNT elements. Also
#line 3173
   * makes vectorisation easy */
#line 3173
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3173
    ni=Min(nelems-j,LOOPCNT);
#line 3173
    if (realign) {
#line 3173
      xp = tmp;
#line 3173
    } else {
#line 3173
      xp = (short *) *xpp;
#line 3173
    }
#line 3173
   /* copy the next block */
#line 3173
#pragma cdir loopcnt=LOOPCNT
#line 3173
#pragma cdir shortloop
#line 3173
    for (i=0; i<ni; i++) {
#line 3173
      /* the normal case: */
#line 3173
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3173
     /* test for range errors (not always needed but do it anyway) */
#line 3173
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3173
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3173
      nrange += tp[i] > X_SHORT_MAX ;
#line 3173
    }
#line 3173
   /* copy workspace back if necessary */
#line 3173
    if (realign) {
#line 3173
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3173
      xp = (short *) *xpp;
#line 3173
    }
#line 3173
   /* update xpp and tp */
#line 3173
    xp += ni;
#line 3173
    tp += ni;
#line 3173
    *xpp = (void*)xp;
#line 3173
  }
#line 3173
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3173

#line 3173
#else   /* not SX */
#line 3173

#line 3173
	char *xp = (char *) *xpp;
#line 3173
	int status = NC_NOERR;
#line 3173

#line 3173
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3173
	{
#line 3173
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 3173
		if (status == NC_NOERR) /* report the first encountered error */
#line 3173
			status = lstatus;
#line 3173
	}
#line 3173

#line 3173
	*xpp = (void *)xp;
#line 3173
	return status;
#line 3173
#endif
#line 3173
}
#line 3173

int
#line 3174
ncx_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3174
{
#line 3174
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3174

#line 3174
 /* basic algorithm is:
#line 3174
  *   - ensure sane alignment of output data
#line 3174
  *   - copy (conversion happens automatically) input data
#line 3174
  *     to output
#line 3174
  *   - update tp to point at next unconverted input, and xpp to point
#line 3174
  *     at next location for converted output
#line 3174
  */
#line 3174
  long i, j, ni;
#line 3174
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3174
  short *xp;
#line 3174
  int nrange = 0;         /* number of range errors */
#line 3174
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3174
  long cxp = (long) *((char**)xpp);
#line 3174

#line 3174
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3174
  /* sjl: manually stripmine so we can limit amount of
#line 3174
   * vector work space reserved to LOOPCNT elements. Also
#line 3174
   * makes vectorisation easy */
#line 3174
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3174
    ni=Min(nelems-j,LOOPCNT);
#line 3174
    if (realign) {
#line 3174
      xp = tmp;
#line 3174
    } else {
#line 3174
      xp = (short *) *xpp;
#line 3174
    }
#line 3174
   /* copy the next block */
#line 3174
#pragma cdir loopcnt=LOOPCNT
#line 3174
#pragma cdir shortloop
#line 3174
    for (i=0; i<ni; i++) {
#line 3174
      /* the normal case: */
#line 3174
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3174
     /* test for range errors (not always needed but do it anyway) */
#line 3174
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3174
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3174
      nrange += tp[i] > X_SHORT_MAX ;
#line 3174
    }
#line 3174
   /* copy workspace back if necessary */
#line 3174
    if (realign) {
#line 3174
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3174
      xp = (short *) *xpp;
#line 3174
    }
#line 3174
   /* update xpp and tp */
#line 3174
    xp += ni;
#line 3174
    tp += ni;
#line 3174
    *xpp = (void*)xp;
#line 3174
  }
#line 3174
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3174

#line 3174
#else   /* not SX */
#line 3174

#line 3174
	char *xp = (char *) *xpp;
#line 3174
	int status = NC_NOERR;
#line 3174

#line 3174
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3174
	{
#line 3174
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 3174
		if (status == NC_NOERR) /* report the first encountered error */
#line 3174
			status = lstatus;
#line 3174
	}
#line 3174

#line 3174
	*xpp = (void *)xp;
#line 3174
	return status;
#line 3174
#endif
#line 3174
}
#line 3174

int
#line 3175
ncx_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3175
{
#line 3175
#if defined(_SX) && _SX != 0 && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 3175

#line 3175
 /* basic algorithm is:
#line 3175
  *   - ensure sane alignment of output data
#line 3175
  *   - copy (conversion happens automatically) input data
#line 3175
  *     to output
#line 3175
  *   - update tp to point at next unconverted input, and xpp to point
#line 3175
  *     at next location for converted output
#line 3175
  */
#line 3175
  long i, j, ni;
#line 3175
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 3175
  short *xp;
#line 3175
  int nrange = 0;         /* number of range errors */
#line 3175
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3175
  long cxp = (long) *((char**)xpp);
#line 3175

#line 3175
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 3175
  /* sjl: manually stripmine so we can limit amount of
#line 3175
   * vector work space reserved to LOOPCNT elements. Also
#line 3175
   * makes vectorisation easy */
#line 3175
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3175
    ni=Min(nelems-j,LOOPCNT);
#line 3175
    if (realign) {
#line 3175
      xp = tmp;
#line 3175
    } else {
#line 3175
      xp = (short *) *xpp;
#line 3175
    }
#line 3175
   /* copy the next block */
#line 3175
#pragma cdir loopcnt=LOOPCNT
#line 3175
#pragma cdir shortloop
#line 3175
    for (i=0; i<ni; i++) {
#line 3175
      /* the normal case: */
#line 3175
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 3175
     /* test for range errors (not always needed but do it anyway) */
#line 3175
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3175
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3175
      nrange += tp[i] > X_SHORT_MAX ;
#line 3175
    }
#line 3175
   /* copy workspace back if necessary */
#line 3175
    if (realign) {
#line 3175
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_SHORT);
#line 3175
      xp = (short *) *xpp;
#line 3175
    }
#line 3175
   /* update xpp and tp */
#line 3175
    xp += ni;
#line 3175
    tp += ni;
#line 3175
    *xpp = (void*)xp;
#line 3175
  }
#line 3175
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3175

#line 3175
#else   /* not SX */
#line 3175

#line 3175
	char *xp = (char *) *xpp;
#line 3175
	int status = NC_NOERR;
#line 3175

#line 3175
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3175
	{
#line 3175
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 3175
		if (status == NC_NOERR) /* report the first encountered error */
#line 3175
			status = lstatus;
#line 3175
	}
#line 3175

#line 3175
	*xpp = (void *)xp;
#line 3175
	return status;
#line 3175
#endif
#line 3175
}
#line 3175


int
#line 3177
ncx_pad_putn_short_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3177
{
#line 3177
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3177

#line 3177
	char *xp = (char *) *xpp;
#line 3177
	int status = NC_NOERR;
#line 3177

#line 3177
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3177
	{
#line 3177
		int lstatus = ncx_put_short_schar(xp, tp, fillp);
#line 3177
		if (status == NC_NOERR) /* report the first encountered error */
#line 3177
			status = lstatus;
#line 3177
	}
#line 3177

#line 3177
	if (rndup != 0)
#line 3177
	{
#line 3177
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3177
		xp += X_SIZEOF_SHORT;
#line 3177
	}
#line 3177

#line 3177
	*xpp = (void *)xp;
#line 3177
	return status;
#line 3177
}
#line 3177

int
#line 3178
ncx_pad_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3178
{
#line 3178
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3178

#line 3178
	char *xp = (char *) *xpp;
#line 3178
	int status = NC_NOERR;
#line 3178

#line 3178
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3178
	{
#line 3178
		int lstatus = ncx_put_short_uchar(xp, tp, fillp);
#line 3178
		if (status == NC_NOERR) /* report the first encountered error */
#line 3178
			status = lstatus;
#line 3178
	}
#line 3178

#line 3178
	if (rndup != 0)
#line 3178
	{
#line 3178
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3178
		xp += X_SIZEOF_SHORT;
#line 3178
	}
#line 3178

#line 3178
	*xpp = (void *)xp;
#line 3178
	return status;
#line 3178
}
#line 3178

int
#line 3179
ncx_pad_putn_short_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3179
{
#line 3179
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3179

#line 3179
	char *xp = (char *) *xpp;
#line 3179
	int status = NC_NOERR;
#line 3179

#line 3179
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3179
	{
#line 3179
		int lstatus = ncx_put_short_short(xp, tp, fillp);
#line 3179
		if (status == NC_NOERR) /* report the first encountered error */
#line 3179
			status = lstatus;
#line 3179
	}
#line 3179

#line 3179
	if (rndup != 0)
#line 3179
	{
#line 3179
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3179
		xp += X_SIZEOF_SHORT;
#line 3179
	}
#line 3179

#line 3179
	*xpp = (void *)xp;
#line 3179
	return status;
#line 3179
}
#line 3179

int
#line 3180
ncx_pad_putn_short_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3180
{
#line 3180
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3180

#line 3180
	char *xp = (char *) *xpp;
#line 3180
	int status = NC_NOERR;
#line 3180

#line 3180
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3180
	{
#line 3180
		int lstatus = ncx_put_short_int(xp, tp, fillp);
#line 3180
		if (status == NC_NOERR) /* report the first encountered error */
#line 3180
			status = lstatus;
#line 3180
	}
#line 3180

#line 3180
	if (rndup != 0)
#line 3180
	{
#line 3180
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3180
		xp += X_SIZEOF_SHORT;
#line 3180
	}
#line 3180

#line 3180
	*xpp = (void *)xp;
#line 3180
	return status;
#line 3180
}
#line 3180

int
#line 3181
ncx_pad_putn_short_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3181
{
#line 3181
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3181

#line 3181
	char *xp = (char *) *xpp;
#line 3181
	int status = NC_NOERR;
#line 3181

#line 3181
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3181
	{
#line 3181
		int lstatus = ncx_put_short_long(xp, tp, fillp);
#line 3181
		if (status == NC_NOERR) /* report the first encountered error */
#line 3181
			status = lstatus;
#line 3181
	}
#line 3181

#line 3181
	if (rndup != 0)
#line 3181
	{
#line 3181
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3181
		xp += X_SIZEOF_SHORT;
#line 3181
	}
#line 3181

#line 3181
	*xpp = (void *)xp;
#line 3181
	return status;
#line 3181
}
#line 3181

int
#line 3182
ncx_pad_putn_short_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3182
{
#line 3182
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3182

#line 3182
	char *xp = (char *) *xpp;
#line 3182
	int status = NC_NOERR;
#line 3182

#line 3182
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3182
	{
#line 3182
		int lstatus = ncx_put_short_float(xp, tp, fillp);
#line 3182
		if (status == NC_NOERR) /* report the first encountered error */
#line 3182
			status = lstatus;
#line 3182
	}
#line 3182

#line 3182
	if (rndup != 0)
#line 3182
	{
#line 3182
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3182
		xp += X_SIZEOF_SHORT;
#line 3182
	}
#line 3182

#line 3182
	*xpp = (void *)xp;
#line 3182
	return status;
#line 3182
}
#line 3182

int
#line 3183
ncx_pad_putn_short_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3183
{
#line 3183
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3183

#line 3183
	char *xp = (char *) *xpp;
#line 3183
	int status = NC_NOERR;
#line 3183

#line 3183
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3183
	{
#line 3183
		int lstatus = ncx_put_short_double(xp, tp, fillp);
#line 3183
		if (status == NC_NOERR) /* report the first encountered error */
#line 3183
			status = lstatus;
#line 3183
	}
#line 3183

#line 3183
	if (rndup != 0)
#line 3183
	{
#line 3183
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3183
		xp += X_SIZEOF_SHORT;
#line 3183
	}
#line 3183

#line 3183
	*xpp = (void *)xp;
#line 3183
	return status;
#line 3183
}
#line 3183

int
#line 3184
ncx_pad_putn_short_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3184
{
#line 3184
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3184

#line 3184
	char *xp = (char *) *xpp;
#line 3184
	int status = NC_NOERR;
#line 3184

#line 3184
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3184
	{
#line 3184
		int lstatus = ncx_put_short_uint(xp, tp, fillp);
#line 3184
		if (status == NC_NOERR) /* report the first encountered error */
#line 3184
			status = lstatus;
#line 3184
	}
#line 3184

#line 3184
	if (rndup != 0)
#line 3184
	{
#line 3184
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3184
		xp += X_SIZEOF_SHORT;
#line 3184
	}
#line 3184

#line 3184
	*xpp = (void *)xp;
#line 3184
	return status;
#line 3184
}
#line 3184

int
#line 3185
ncx_pad_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3185
{
#line 3185
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3185

#line 3185
	char *xp = (char *) *xpp;
#line 3185
	int status = NC_NOERR;
#line 3185

#line 3185
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3185
	{
#line 3185
		int lstatus = ncx_put_short_longlong(xp, tp, fillp);
#line 3185
		if (status == NC_NOERR) /* report the first encountered error */
#line 3185
			status = lstatus;
#line 3185
	}
#line 3185

#line 3185
	if (rndup != 0)
#line 3185
	{
#line 3185
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3185
		xp += X_SIZEOF_SHORT;
#line 3185
	}
#line 3185

#line 3185
	*xpp = (void *)xp;
#line 3185
	return status;
#line 3185
}
#line 3185

int
#line 3186
ncx_pad_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3186
{
#line 3186
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3186

#line 3186
	char *xp = (char *) *xpp;
#line 3186
	int status = NC_NOERR;
#line 3186

#line 3186
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3186
	{
#line 3186
		int lstatus = ncx_put_short_ulonglong(xp, tp, fillp);
#line 3186
		if (status == NC_NOERR) /* report the first encountered error */
#line 3186
			status = lstatus;
#line 3186
	}
#line 3186

#line 3186
	if (rndup != 0)
#line 3186
	{
#line 3186
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3186
		xp += X_SIZEOF_SHORT;
#line 3186
	}
#line 3186

#line 3186
	*xpp = (void *)xp;
#line 3186
	return status;
#line 3186
}
#line 3186

int
#line 3187
ncx_pad_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3187
{
#line 3187
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3187

#line 3187
	char *xp = (char *) *xpp;
#line 3187
	int status = NC_NOERR;
#line 3187

#line 3187
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 3187
	{
#line 3187
		int lstatus = ncx_put_short_ushort(xp, tp, fillp);
#line 3187
		if (status == NC_NOERR) /* report the first encountered error */
#line 3187
			status = lstatus;
#line 3187
	}
#line 3187

#line 3187
	if (rndup != 0)
#line 3187
	{
#line 3187
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_SHORT));
#line 3187
		xp += X_SIZEOF_SHORT;
#line 3187
	}
#line 3187

#line 3187
	*xpp = (void *)xp;
#line 3187
	return status;
#line 3187
}
#line 3187



/* ushort --------------------------------------------------------------------*/

#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, unsigned short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_USHORT);
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 3206
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3206
{
#line 3206
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3206

#line 3206
 /* basic algorithm is:
#line 3206
  *   - ensure sane alignment of input data
#line 3206
  *   - copy (conversion happens automatically) input data
#line 3206
  *     to output
#line 3206
  *   - update xpp to point at next unconverted input, and tp to point
#line 3206
  *     at next location for converted output
#line 3206
  */
#line 3206
  long i, j, ni;
#line 3206
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3206
  ushort *xp;
#line 3206
  int nrange = 0;         /* number of range errors */
#line 3206
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3206
  long cxp = (long) *((char**)xpp);
#line 3206

#line 3206
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3206
  /* sjl: manually stripmine so we can limit amount of
#line 3206
   * vector work space reserved to LOOPCNT elements. Also
#line 3206
   * makes vectorisation easy */
#line 3206
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3206
    ni=Min(nelems-j,LOOPCNT);
#line 3206
    if (realign) {
#line 3206
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3206
      xp = tmp;
#line 3206
    } else {
#line 3206
      xp = (ushort *) *xpp;
#line 3206
    }
#line 3206
   /* copy the next block */
#line 3206
#pragma cdir loopcnt=LOOPCNT
#line 3206
#pragma cdir shortloop
#line 3206
    for (i=0; i<ni; i++) {
#line 3206
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3206
     /* test for range errors (not always needed but do it anyway) */
#line 3206
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3206
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3206
      nrange += xp[i] > USHORT_MAX ;
#line 3206
    }
#line 3206
   /* update xpp and tp */
#line 3206
    if (realign) xp = (ushort *) *xpp;
#line 3206
    xp += ni;
#line 3206
    tp += ni;
#line 3206
    *xpp = (void*)xp;
#line 3206
  }
#line 3206
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3206

#line 3206
#else   /* not SX */
#line 3206
	const char *xp = (const char *) *xpp;
#line 3206
	int status = NC_NOERR;
#line 3206

#line 3206
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3206
	{
#line 3206
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 3206
		if (status == NC_NOERR) /* report the first encountered error */
#line 3206
			status = lstatus;
#line 3206
	}
#line 3206

#line 3206
	*xpp = (const void *)xp;
#line 3206
	return status;
#line 3206
#endif
#line 3206
}
#line 3206

#endif
int
#line 3208
ncx_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 3208
{
#line 3208
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3208

#line 3208
 /* basic algorithm is:
#line 3208
  *   - ensure sane alignment of input data
#line 3208
  *   - copy (conversion happens automatically) input data
#line 3208
  *     to output
#line 3208
  *   - update xpp to point at next unconverted input, and tp to point
#line 3208
  *     at next location for converted output
#line 3208
  */
#line 3208
  long i, j, ni;
#line 3208
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3208
  ushort *xp;
#line 3208
  int nrange = 0;         /* number of range errors */
#line 3208
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3208
  long cxp = (long) *((char**)xpp);
#line 3208

#line 3208
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3208
  /* sjl: manually stripmine so we can limit amount of
#line 3208
   * vector work space reserved to LOOPCNT elements. Also
#line 3208
   * makes vectorisation easy */
#line 3208
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3208
    ni=Min(nelems-j,LOOPCNT);
#line 3208
    if (realign) {
#line 3208
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3208
      xp = tmp;
#line 3208
    } else {
#line 3208
      xp = (ushort *) *xpp;
#line 3208
    }
#line 3208
   /* copy the next block */
#line 3208
#pragma cdir loopcnt=LOOPCNT
#line 3208
#pragma cdir shortloop
#line 3208
    for (i=0; i<ni; i++) {
#line 3208
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3208
     /* test for range errors (not always needed but do it anyway) */
#line 3208
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3208
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3208
      nrange += xp[i] > SCHAR_MAX ;
#line 3208
    }
#line 3208
   /* update xpp and tp */
#line 3208
    if (realign) xp = (ushort *) *xpp;
#line 3208
    xp += ni;
#line 3208
    tp += ni;
#line 3208
    *xpp = (void*)xp;
#line 3208
  }
#line 3208
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3208

#line 3208
#else   /* not SX */
#line 3208
	const char *xp = (const char *) *xpp;
#line 3208
	int status = NC_NOERR;
#line 3208

#line 3208
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3208
	{
#line 3208
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 3208
		if (status == NC_NOERR) /* report the first encountered error */
#line 3208
			status = lstatus;
#line 3208
	}
#line 3208

#line 3208
	*xpp = (const void *)xp;
#line 3208
	return status;
#line 3208
#endif
#line 3208
}
#line 3208

int
#line 3209
ncx_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 3209
{
#line 3209
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3209

#line 3209
 /* basic algorithm is:
#line 3209
  *   - ensure sane alignment of input data
#line 3209
  *   - copy (conversion happens automatically) input data
#line 3209
  *     to output
#line 3209
  *   - update xpp to point at next unconverted input, and tp to point
#line 3209
  *     at next location for converted output
#line 3209
  */
#line 3209
  long i, j, ni;
#line 3209
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3209
  ushort *xp;
#line 3209
  int nrange = 0;         /* number of range errors */
#line 3209
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3209
  long cxp = (long) *((char**)xpp);
#line 3209

#line 3209
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3209
  /* sjl: manually stripmine so we can limit amount of
#line 3209
   * vector work space reserved to LOOPCNT elements. Also
#line 3209
   * makes vectorisation easy */
#line 3209
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3209
    ni=Min(nelems-j,LOOPCNT);
#line 3209
    if (realign) {
#line 3209
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3209
      xp = tmp;
#line 3209
    } else {
#line 3209
      xp = (ushort *) *xpp;
#line 3209
    }
#line 3209
   /* copy the next block */
#line 3209
#pragma cdir loopcnt=LOOPCNT
#line 3209
#pragma cdir shortloop
#line 3209
    for (i=0; i<ni; i++) {
#line 3209
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3209
     /* test for range errors (not always needed but do it anyway) */
#line 3209
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3209
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3209
      nrange += xp[i] > SHORT_MAX ;
#line 3209
    }
#line 3209
   /* update xpp and tp */
#line 3209
    if (realign) xp = (ushort *) *xpp;
#line 3209
    xp += ni;
#line 3209
    tp += ni;
#line 3209
    *xpp = (void*)xp;
#line 3209
  }
#line 3209
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3209

#line 3209
#else   /* not SX */
#line 3209
	const char *xp = (const char *) *xpp;
#line 3209
	int status = NC_NOERR;
#line 3209

#line 3209
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3209
	{
#line 3209
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 3209
		if (status == NC_NOERR) /* report the first encountered error */
#line 3209
			status = lstatus;
#line 3209
	}
#line 3209

#line 3209
	*xpp = (const void *)xp;
#line 3209
	return status;
#line 3209
#endif
#line 3209
}
#line 3209

int
#line 3210
ncx_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 3210
{
#line 3210
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3210

#line 3210
 /* basic algorithm is:
#line 3210
  *   - ensure sane alignment of input data
#line 3210
  *   - copy (conversion happens automatically) input data
#line 3210
  *     to output
#line 3210
  *   - update xpp to point at next unconverted input, and tp to point
#line 3210
  *     at next location for converted output
#line 3210
  */
#line 3210
  long i, j, ni;
#line 3210
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3210
  ushort *xp;
#line 3210
  int nrange = 0;         /* number of range errors */
#line 3210
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3210
  long cxp = (long) *((char**)xpp);
#line 3210

#line 3210
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3210
  /* sjl: manually stripmine so we can limit amount of
#line 3210
   * vector work space reserved to LOOPCNT elements. Also
#line 3210
   * makes vectorisation easy */
#line 3210
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3210
    ni=Min(nelems-j,LOOPCNT);
#line 3210
    if (realign) {
#line 3210
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3210
      xp = tmp;
#line 3210
    } else {
#line 3210
      xp = (ushort *) *xpp;
#line 3210
    }
#line 3210
   /* copy the next block */
#line 3210
#pragma cdir loopcnt=LOOPCNT
#line 3210
#pragma cdir shortloop
#line 3210
    for (i=0; i<ni; i++) {
#line 3210
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3210
     /* test for range errors (not always needed but do it anyway) */
#line 3210
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3210
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3210
      nrange += xp[i] > INT_MAX ;
#line 3210
    }
#line 3210
   /* update xpp and tp */
#line 3210
    if (realign) xp = (ushort *) *xpp;
#line 3210
    xp += ni;
#line 3210
    tp += ni;
#line 3210
    *xpp = (void*)xp;
#line 3210
  }
#line 3210
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3210

#line 3210
#else   /* not SX */
#line 3210
	const char *xp = (const char *) *xpp;
#line 3210
	int status = NC_NOERR;
#line 3210

#line 3210
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3210
	{
#line 3210
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 3210
		if (status == NC_NOERR) /* report the first encountered error */
#line 3210
			status = lstatus;
#line 3210
	}
#line 3210

#line 3210
	*xpp = (const void *)xp;
#line 3210
	return status;
#line 3210
#endif
#line 3210
}
#line 3210

int
#line 3211
ncx_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 3211
{
#line 3211
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3211

#line 3211
 /* basic algorithm is:
#line 3211
  *   - ensure sane alignment of input data
#line 3211
  *   - copy (conversion happens automatically) input data
#line 3211
  *     to output
#line 3211
  *   - update xpp to point at next unconverted input, and tp to point
#line 3211
  *     at next location for converted output
#line 3211
  */
#line 3211
  long i, j, ni;
#line 3211
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3211
  ushort *xp;
#line 3211
  int nrange = 0;         /* number of range errors */
#line 3211
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3211
  long cxp = (long) *((char**)xpp);
#line 3211

#line 3211
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3211
  /* sjl: manually stripmine so we can limit amount of
#line 3211
   * vector work space reserved to LOOPCNT elements. Also
#line 3211
   * makes vectorisation easy */
#line 3211
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3211
    ni=Min(nelems-j,LOOPCNT);
#line 3211
    if (realign) {
#line 3211
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3211
      xp = tmp;
#line 3211
    } else {
#line 3211
      xp = (ushort *) *xpp;
#line 3211
    }
#line 3211
   /* copy the next block */
#line 3211
#pragma cdir loopcnt=LOOPCNT
#line 3211
#pragma cdir shortloop
#line 3211
    for (i=0; i<ni; i++) {
#line 3211
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3211
     /* test for range errors (not always needed but do it anyway) */
#line 3211
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3211
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3211
      nrange += xp[i] > LONG_MAX ;
#line 3211
    }
#line 3211
   /* update xpp and tp */
#line 3211
    if (realign) xp = (ushort *) *xpp;
#line 3211
    xp += ni;
#line 3211
    tp += ni;
#line 3211
    *xpp = (void*)xp;
#line 3211
  }
#line 3211
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3211

#line 3211
#else   /* not SX */
#line 3211
	const char *xp = (const char *) *xpp;
#line 3211
	int status = NC_NOERR;
#line 3211

#line 3211
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3211
	{
#line 3211
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 3211
		if (status == NC_NOERR) /* report the first encountered error */
#line 3211
			status = lstatus;
#line 3211
	}
#line 3211

#line 3211
	*xpp = (const void *)xp;
#line 3211
	return status;
#line 3211
#endif
#line 3211
}
#line 3211

int
#line 3212
ncx_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 3212
{
#line 3212
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3212

#line 3212
 /* basic algorithm is:
#line 3212
  *   - ensure sane alignment of input data
#line 3212
  *   - copy (conversion happens automatically) input data
#line 3212
  *     to output
#line 3212
  *   - update xpp to point at next unconverted input, and tp to point
#line 3212
  *     at next location for converted output
#line 3212
  */
#line 3212
  long i, j, ni;
#line 3212
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3212
  ushort *xp;
#line 3212
  int nrange = 0;         /* number of range errors */
#line 3212
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3212
  long cxp = (long) *((char**)xpp);
#line 3212

#line 3212
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3212
  /* sjl: manually stripmine so we can limit amount of
#line 3212
   * vector work space reserved to LOOPCNT elements. Also
#line 3212
   * makes vectorisation easy */
#line 3212
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3212
    ni=Min(nelems-j,LOOPCNT);
#line 3212
    if (realign) {
#line 3212
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3212
      xp = tmp;
#line 3212
    } else {
#line 3212
      xp = (ushort *) *xpp;
#line 3212
    }
#line 3212
   /* copy the next block */
#line 3212
#pragma cdir loopcnt=LOOPCNT
#line 3212
#pragma cdir shortloop
#line 3212
    for (i=0; i<ni; i++) {
#line 3212
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3212
     /* test for range errors (not always needed but do it anyway) */
#line 3212
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3212
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3212
      nrange += xp[i] > FLOAT_MAX ;
#line 3212
    }
#line 3212
   /* update xpp and tp */
#line 3212
    if (realign) xp = (ushort *) *xpp;
#line 3212
    xp += ni;
#line 3212
    tp += ni;
#line 3212
    *xpp = (void*)xp;
#line 3212
  }
#line 3212
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3212

#line 3212
#else   /* not SX */
#line 3212
	const char *xp = (const char *) *xpp;
#line 3212
	int status = NC_NOERR;
#line 3212

#line 3212
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3212
	{
#line 3212
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 3212
		if (status == NC_NOERR) /* report the first encountered error */
#line 3212
			status = lstatus;
#line 3212
	}
#line 3212

#line 3212
	*xpp = (const void *)xp;
#line 3212
	return status;
#line 3212
#endif
#line 3212
}
#line 3212

int
#line 3213
ncx_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 3213
{
#line 3213
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3213

#line 3213
 /* basic algorithm is:
#line 3213
  *   - ensure sane alignment of input data
#line 3213
  *   - copy (conversion happens automatically) input data
#line 3213
  *     to output
#line 3213
  *   - update xpp to point at next unconverted input, and tp to point
#line 3213
  *     at next location for converted output
#line 3213
  */
#line 3213
  long i, j, ni;
#line 3213
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3213
  ushort *xp;
#line 3213
  int nrange = 0;         /* number of range errors */
#line 3213
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3213
  long cxp = (long) *((char**)xpp);
#line 3213

#line 3213
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3213
  /* sjl: manually stripmine so we can limit amount of
#line 3213
   * vector work space reserved to LOOPCNT elements. Also
#line 3213
   * makes vectorisation easy */
#line 3213
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3213
    ni=Min(nelems-j,LOOPCNT);
#line 3213
    if (realign) {
#line 3213
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3213
      xp = tmp;
#line 3213
    } else {
#line 3213
      xp = (ushort *) *xpp;
#line 3213
    }
#line 3213
   /* copy the next block */
#line 3213
#pragma cdir loopcnt=LOOPCNT
#line 3213
#pragma cdir shortloop
#line 3213
    for (i=0; i<ni; i++) {
#line 3213
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3213
     /* test for range errors (not always needed but do it anyway) */
#line 3213
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3213
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3213
      nrange += xp[i] > DOUBLE_MAX ;
#line 3213
    }
#line 3213
   /* update xpp and tp */
#line 3213
    if (realign) xp = (ushort *) *xpp;
#line 3213
    xp += ni;
#line 3213
    tp += ni;
#line 3213
    *xpp = (void*)xp;
#line 3213
  }
#line 3213
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3213

#line 3213
#else   /* not SX */
#line 3213
	const char *xp = (const char *) *xpp;
#line 3213
	int status = NC_NOERR;
#line 3213

#line 3213
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3213
	{
#line 3213
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 3213
		if (status == NC_NOERR) /* report the first encountered error */
#line 3213
			status = lstatus;
#line 3213
	}
#line 3213

#line 3213
	*xpp = (const void *)xp;
#line 3213
	return status;
#line 3213
#endif
#line 3213
}
#line 3213

int
#line 3214
ncx_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3214
{
#line 3214
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3214

#line 3214
 /* basic algorithm is:
#line 3214
  *   - ensure sane alignment of input data
#line 3214
  *   - copy (conversion happens automatically) input data
#line 3214
  *     to output
#line 3214
  *   - update xpp to point at next unconverted input, and tp to point
#line 3214
  *     at next location for converted output
#line 3214
  */
#line 3214
  long i, j, ni;
#line 3214
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3214
  ushort *xp;
#line 3214
  int nrange = 0;         /* number of range errors */
#line 3214
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3214
  long cxp = (long) *((char**)xpp);
#line 3214

#line 3214
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3214
  /* sjl: manually stripmine so we can limit amount of
#line 3214
   * vector work space reserved to LOOPCNT elements. Also
#line 3214
   * makes vectorisation easy */
#line 3214
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3214
    ni=Min(nelems-j,LOOPCNT);
#line 3214
    if (realign) {
#line 3214
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3214
      xp = tmp;
#line 3214
    } else {
#line 3214
      xp = (ushort *) *xpp;
#line 3214
    }
#line 3214
   /* copy the next block */
#line 3214
#pragma cdir loopcnt=LOOPCNT
#line 3214
#pragma cdir shortloop
#line 3214
    for (i=0; i<ni; i++) {
#line 3214
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3214
     /* test for range errors (not always needed but do it anyway) */
#line 3214
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3214
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3214
      nrange += xp[i] > LONGLONG_MAX ;
#line 3214
    }
#line 3214
   /* update xpp and tp */
#line 3214
    if (realign) xp = (ushort *) *xpp;
#line 3214
    xp += ni;
#line 3214
    tp += ni;
#line 3214
    *xpp = (void*)xp;
#line 3214
  }
#line 3214
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3214

#line 3214
#else   /* not SX */
#line 3214
	const char *xp = (const char *) *xpp;
#line 3214
	int status = NC_NOERR;
#line 3214

#line 3214
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3214
	{
#line 3214
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 3214
		if (status == NC_NOERR) /* report the first encountered error */
#line 3214
			status = lstatus;
#line 3214
	}
#line 3214

#line 3214
	*xpp = (const void *)xp;
#line 3214
	return status;
#line 3214
#endif
#line 3214
}
#line 3214

int
#line 3215
ncx_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3215
{
#line 3215
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3215

#line 3215
 /* basic algorithm is:
#line 3215
  *   - ensure sane alignment of input data
#line 3215
  *   - copy (conversion happens automatically) input data
#line 3215
  *     to output
#line 3215
  *   - update xpp to point at next unconverted input, and tp to point
#line 3215
  *     at next location for converted output
#line 3215
  */
#line 3215
  long i, j, ni;
#line 3215
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3215
  ushort *xp;
#line 3215
  int nrange = 0;         /* number of range errors */
#line 3215
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3215
  long cxp = (long) *((char**)xpp);
#line 3215

#line 3215
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3215
  /* sjl: manually stripmine so we can limit amount of
#line 3215
   * vector work space reserved to LOOPCNT elements. Also
#line 3215
   * makes vectorisation easy */
#line 3215
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3215
    ni=Min(nelems-j,LOOPCNT);
#line 3215
    if (realign) {
#line 3215
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3215
      xp = tmp;
#line 3215
    } else {
#line 3215
      xp = (ushort *) *xpp;
#line 3215
    }
#line 3215
   /* copy the next block */
#line 3215
#pragma cdir loopcnt=LOOPCNT
#line 3215
#pragma cdir shortloop
#line 3215
    for (i=0; i<ni; i++) {
#line 3215
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3215
     /* test for range errors (not always needed but do it anyway) */
#line 3215
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3215
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3215
      nrange += xp[i] > UCHAR_MAX ;
#line 3215
    }
#line 3215
   /* update xpp and tp */
#line 3215
    if (realign) xp = (ushort *) *xpp;
#line 3215
    xp += ni;
#line 3215
    tp += ni;
#line 3215
    *xpp = (void*)xp;
#line 3215
  }
#line 3215
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3215

#line 3215
#else   /* not SX */
#line 3215
	const char *xp = (const char *) *xpp;
#line 3215
	int status = NC_NOERR;
#line 3215

#line 3215
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3215
	{
#line 3215
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 3215
		if (status == NC_NOERR) /* report the first encountered error */
#line 3215
			status = lstatus;
#line 3215
	}
#line 3215

#line 3215
	*xpp = (const void *)xp;
#line 3215
	return status;
#line 3215
#endif
#line 3215
}
#line 3215

int
#line 3216
ncx_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 3216
{
#line 3216
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3216

#line 3216
 /* basic algorithm is:
#line 3216
  *   - ensure sane alignment of input data
#line 3216
  *   - copy (conversion happens automatically) input data
#line 3216
  *     to output
#line 3216
  *   - update xpp to point at next unconverted input, and tp to point
#line 3216
  *     at next location for converted output
#line 3216
  */
#line 3216
  long i, j, ni;
#line 3216
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3216
  ushort *xp;
#line 3216
  int nrange = 0;         /* number of range errors */
#line 3216
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3216
  long cxp = (long) *((char**)xpp);
#line 3216

#line 3216
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3216
  /* sjl: manually stripmine so we can limit amount of
#line 3216
   * vector work space reserved to LOOPCNT elements. Also
#line 3216
   * makes vectorisation easy */
#line 3216
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3216
    ni=Min(nelems-j,LOOPCNT);
#line 3216
    if (realign) {
#line 3216
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3216
      xp = tmp;
#line 3216
    } else {
#line 3216
      xp = (ushort *) *xpp;
#line 3216
    }
#line 3216
   /* copy the next block */
#line 3216
#pragma cdir loopcnt=LOOPCNT
#line 3216
#pragma cdir shortloop
#line 3216
    for (i=0; i<ni; i++) {
#line 3216
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3216
     /* test for range errors (not always needed but do it anyway) */
#line 3216
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3216
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3216
      nrange += xp[i] > UINT_MAX ;
#line 3216
    }
#line 3216
   /* update xpp and tp */
#line 3216
    if (realign) xp = (ushort *) *xpp;
#line 3216
    xp += ni;
#line 3216
    tp += ni;
#line 3216
    *xpp = (void*)xp;
#line 3216
  }
#line 3216
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3216

#line 3216
#else   /* not SX */
#line 3216
	const char *xp = (const char *) *xpp;
#line 3216
	int status = NC_NOERR;
#line 3216

#line 3216
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3216
	{
#line 3216
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 3216
		if (status == NC_NOERR) /* report the first encountered error */
#line 3216
			status = lstatus;
#line 3216
	}
#line 3216

#line 3216
	*xpp = (const void *)xp;
#line 3216
	return status;
#line 3216
#endif
#line 3216
}
#line 3216

int
#line 3217
ncx_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3217
{
#line 3217
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3217

#line 3217
 /* basic algorithm is:
#line 3217
  *   - ensure sane alignment of input data
#line 3217
  *   - copy (conversion happens automatically) input data
#line 3217
  *     to output
#line 3217
  *   - update xpp to point at next unconverted input, and tp to point
#line 3217
  *     at next location for converted output
#line 3217
  */
#line 3217
  long i, j, ni;
#line 3217
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3217
  ushort *xp;
#line 3217
  int nrange = 0;         /* number of range errors */
#line 3217
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3217
  long cxp = (long) *((char**)xpp);
#line 3217

#line 3217
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3217
  /* sjl: manually stripmine so we can limit amount of
#line 3217
   * vector work space reserved to LOOPCNT elements. Also
#line 3217
   * makes vectorisation easy */
#line 3217
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3217
    ni=Min(nelems-j,LOOPCNT);
#line 3217
    if (realign) {
#line 3217
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_USHORT));
#line 3217
      xp = tmp;
#line 3217
    } else {
#line 3217
      xp = (ushort *) *xpp;
#line 3217
    }
#line 3217
   /* copy the next block */
#line 3217
#pragma cdir loopcnt=LOOPCNT
#line 3217
#pragma cdir shortloop
#line 3217
    for (i=0; i<ni; i++) {
#line 3217
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3217
     /* test for range errors (not always needed but do it anyway) */
#line 3217
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3217
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3217
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3217
    }
#line 3217
   /* update xpp and tp */
#line 3217
    if (realign) xp = (ushort *) *xpp;
#line 3217
    xp += ni;
#line 3217
    tp += ni;
#line 3217
    *xpp = (void*)xp;
#line 3217
  }
#line 3217
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3217

#line 3217
#else   /* not SX */
#line 3217
	const char *xp = (const char *) *xpp;
#line 3217
	int status = NC_NOERR;
#line 3217

#line 3217
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3217
	{
#line 3217
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 3217
		if (status == NC_NOERR) /* report the first encountered error */
#line 3217
			status = lstatus;
#line 3217
	}
#line 3217

#line 3217
	*xpp = (const void *)xp;
#line 3217
	return status;
#line 3217
#endif
#line 3217
}
#line 3217


int
#line 3219
ncx_pad_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 3219
{
#line 3219
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3219

#line 3219
	const char *xp = (const char *) *xpp;
#line 3219
	int status = NC_NOERR;
#line 3219

#line 3219
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3219
	{
#line 3219
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 3219
		if (status == NC_NOERR) /* report the first encountered error */
#line 3219
			status = lstatus;
#line 3219
	}
#line 3219

#line 3219
	if (rndup != 0)
#line 3219
		xp += X_SIZEOF_USHORT;
#line 3219

#line 3219
	*xpp = (void *)xp;
#line 3219
	return status;
#line 3219
}
#line 3219

int
#line 3220
ncx_pad_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 3220
{
#line 3220
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3220

#line 3220
	const char *xp = (const char *) *xpp;
#line 3220
	int status = NC_NOERR;
#line 3220

#line 3220
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3220
	{
#line 3220
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 3220
		if (status == NC_NOERR) /* report the first encountered error */
#line 3220
			status = lstatus;
#line 3220
	}
#line 3220

#line 3220
	if (rndup != 0)
#line 3220
		xp += X_SIZEOF_USHORT;
#line 3220

#line 3220
	*xpp = (void *)xp;
#line 3220
	return status;
#line 3220
}
#line 3220

int
#line 3221
ncx_pad_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 3221
{
#line 3221
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3221

#line 3221
	const char *xp = (const char *) *xpp;
#line 3221
	int status = NC_NOERR;
#line 3221

#line 3221
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3221
	{
#line 3221
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 3221
		if (status == NC_NOERR) /* report the first encountered error */
#line 3221
			status = lstatus;
#line 3221
	}
#line 3221

#line 3221
	if (rndup != 0)
#line 3221
		xp += X_SIZEOF_USHORT;
#line 3221

#line 3221
	*xpp = (void *)xp;
#line 3221
	return status;
#line 3221
}
#line 3221

int
#line 3222
ncx_pad_getn_ushort_long(const void **xpp, size_t nelems, long *tp)
#line 3222
{
#line 3222
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3222

#line 3222
	const char *xp = (const char *) *xpp;
#line 3222
	int status = NC_NOERR;
#line 3222

#line 3222
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3222
	{
#line 3222
		const int lstatus = ncx_get_ushort_long(xp, tp);
#line 3222
		if (status == NC_NOERR) /* report the first encountered error */
#line 3222
			status = lstatus;
#line 3222
	}
#line 3222

#line 3222
	if (rndup != 0)
#line 3222
		xp += X_SIZEOF_USHORT;
#line 3222

#line 3222
	*xpp = (void *)xp;
#line 3222
	return status;
#line 3222
}
#line 3222

int
#line 3223
ncx_pad_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 3223
{
#line 3223
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3223

#line 3223
	const char *xp = (const char *) *xpp;
#line 3223
	int status = NC_NOERR;
#line 3223

#line 3223
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3223
	{
#line 3223
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 3223
		if (status == NC_NOERR) /* report the first encountered error */
#line 3223
			status = lstatus;
#line 3223
	}
#line 3223

#line 3223
	if (rndup != 0)
#line 3223
		xp += X_SIZEOF_USHORT;
#line 3223

#line 3223
	*xpp = (void *)xp;
#line 3223
	return status;
#line 3223
}
#line 3223

int
#line 3224
ncx_pad_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 3224
{
#line 3224
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3224

#line 3224
	const char *xp = (const char *) *xpp;
#line 3224
	int status = NC_NOERR;
#line 3224

#line 3224
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3224
	{
#line 3224
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 3224
		if (status == NC_NOERR) /* report the first encountered error */
#line 3224
			status = lstatus;
#line 3224
	}
#line 3224

#line 3224
	if (rndup != 0)
#line 3224
		xp += X_SIZEOF_USHORT;
#line 3224

#line 3224
	*xpp = (void *)xp;
#line 3224
	return status;
#line 3224
}
#line 3224

int
#line 3225
ncx_pad_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3225
{
#line 3225
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3225

#line 3225
	const char *xp = (const char *) *xpp;
#line 3225
	int status = NC_NOERR;
#line 3225

#line 3225
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3225
	{
#line 3225
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 3225
		if (status == NC_NOERR) /* report the first encountered error */
#line 3225
			status = lstatus;
#line 3225
	}
#line 3225

#line 3225
	if (rndup != 0)
#line 3225
		xp += X_SIZEOF_USHORT;
#line 3225

#line 3225
	*xpp = (void *)xp;
#line 3225
	return status;
#line 3225
}
#line 3225

int
#line 3226
ncx_pad_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3226
{
#line 3226
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3226

#line 3226
	const char *xp = (const char *) *xpp;
#line 3226
	int status = NC_NOERR;
#line 3226

#line 3226
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3226
	{
#line 3226
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 3226
		if (status == NC_NOERR) /* report the first encountered error */
#line 3226
			status = lstatus;
#line 3226
	}
#line 3226

#line 3226
	if (rndup != 0)
#line 3226
		xp += X_SIZEOF_USHORT;
#line 3226

#line 3226
	*xpp = (void *)xp;
#line 3226
	return status;
#line 3226
}
#line 3226

int
#line 3227
ncx_pad_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 3227
{
#line 3227
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3227

#line 3227
	const char *xp = (const char *) *xpp;
#line 3227
	int status = NC_NOERR;
#line 3227

#line 3227
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3227
	{
#line 3227
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 3227
		if (status == NC_NOERR) /* report the first encountered error */
#line 3227
			status = lstatus;
#line 3227
	}
#line 3227

#line 3227
	if (rndup != 0)
#line 3227
		xp += X_SIZEOF_USHORT;
#line 3227

#line 3227
	*xpp = (void *)xp;
#line 3227
	return status;
#line 3227
}
#line 3227

int
#line 3228
ncx_pad_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3228
{
#line 3228
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3228

#line 3228
	const char *xp = (const char *) *xpp;
#line 3228
	int status = NC_NOERR;
#line 3228

#line 3228
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3228
	{
#line 3228
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 3228
		if (status == NC_NOERR) /* report the first encountered error */
#line 3228
			status = lstatus;
#line 3228
	}
#line 3228

#line 3228
	if (rndup != 0)
#line 3228
		xp += X_SIZEOF_USHORT;
#line 3228

#line 3228
	*xpp = (void *)xp;
#line 3228
	return status;
#line 3228
}
#line 3228

int
#line 3229
ncx_pad_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3229
{
#line 3229
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3229

#line 3229
	const char *xp = (const char *) *xpp;
#line 3229
	int status = NC_NOERR;
#line 3229

#line 3229
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3229
	{
#line 3229
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 3229
		if (status == NC_NOERR) /* report the first encountered error */
#line 3229
			status = lstatus;
#line 3229
	}
#line 3229

#line 3229
	if (rndup != 0)
#line 3229
		xp += X_SIZEOF_USHORT;
#line 3229

#line 3229
	*xpp = (void *)xp;
#line 3229
	return status;
#line 3229
}
#line 3229


#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const unsigned short *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_USHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 3245
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3245
{
#line 3245
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3245

#line 3245
 /* basic algorithm is:
#line 3245
  *   - ensure sane alignment of output data
#line 3245
  *   - copy (conversion happens automatically) input data
#line 3245
  *     to output
#line 3245
  *   - update tp to point at next unconverted input, and xpp to point
#line 3245
  *     at next location for converted output
#line 3245
  */
#line 3245
  long i, j, ni;
#line 3245
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3245
  ushort *xp;
#line 3245
  int nrange = 0;         /* number of range errors */
#line 3245
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3245
  long cxp = (long) *((char**)xpp);
#line 3245

#line 3245
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3245
  /* sjl: manually stripmine so we can limit amount of
#line 3245
   * vector work space reserved to LOOPCNT elements. Also
#line 3245
   * makes vectorisation easy */
#line 3245
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3245
    ni=Min(nelems-j,LOOPCNT);
#line 3245
    if (realign) {
#line 3245
      xp = tmp;
#line 3245
    } else {
#line 3245
      xp = (ushort *) *xpp;
#line 3245
    }
#line 3245
   /* copy the next block */
#line 3245
#pragma cdir loopcnt=LOOPCNT
#line 3245
#pragma cdir shortloop
#line 3245
    for (i=0; i<ni; i++) {
#line 3245
      /* the normal case: */
#line 3245
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3245
     /* test for range errors (not always needed but do it anyway) */
#line 3245
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3245
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3245
      nrange += tp[i] > X_USHORT_MAX ;
#line 3245
    }
#line 3245
   /* copy workspace back if necessary */
#line 3245
    if (realign) {
#line 3245
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3245
      xp = (ushort *) *xpp;
#line 3245
    }
#line 3245
   /* update xpp and tp */
#line 3245
    xp += ni;
#line 3245
    tp += ni;
#line 3245
    *xpp = (void*)xp;
#line 3245
  }
#line 3245
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3245

#line 3245
#else   /* not SX */
#line 3245

#line 3245
	char *xp = (char *) *xpp;
#line 3245
	int status = NC_NOERR;
#line 3245

#line 3245
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3245
	{
#line 3245
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3245
		if (status == NC_NOERR) /* report the first encountered error */
#line 3245
			status = lstatus;
#line 3245
	}
#line 3245

#line 3245
	*xpp = (void *)xp;
#line 3245
	return status;
#line 3245
#endif
#line 3245
}
#line 3245

#endif
int
#line 3247
ncx_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3247
{
#line 3247
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3247

#line 3247
 /* basic algorithm is:
#line 3247
  *   - ensure sane alignment of output data
#line 3247
  *   - copy (conversion happens automatically) input data
#line 3247
  *     to output
#line 3247
  *   - update tp to point at next unconverted input, and xpp to point
#line 3247
  *     at next location for converted output
#line 3247
  */
#line 3247
  long i, j, ni;
#line 3247
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3247
  ushort *xp;
#line 3247
  int nrange = 0;         /* number of range errors */
#line 3247
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3247
  long cxp = (long) *((char**)xpp);
#line 3247

#line 3247
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3247
  /* sjl: manually stripmine so we can limit amount of
#line 3247
   * vector work space reserved to LOOPCNT elements. Also
#line 3247
   * makes vectorisation easy */
#line 3247
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3247
    ni=Min(nelems-j,LOOPCNT);
#line 3247
    if (realign) {
#line 3247
      xp = tmp;
#line 3247
    } else {
#line 3247
      xp = (ushort *) *xpp;
#line 3247
    }
#line 3247
   /* copy the next block */
#line 3247
#pragma cdir loopcnt=LOOPCNT
#line 3247
#pragma cdir shortloop
#line 3247
    for (i=0; i<ni; i++) {
#line 3247
      /* the normal case: */
#line 3247
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3247
     /* test for range errors (not always needed but do it anyway) */
#line 3247
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3247
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3247
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3247
    }
#line 3247
   /* copy workspace back if necessary */
#line 3247
    if (realign) {
#line 3247
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3247
      xp = (ushort *) *xpp;
#line 3247
    }
#line 3247
   /* update xpp and tp */
#line 3247
    xp += ni;
#line 3247
    tp += ni;
#line 3247
    *xpp = (void*)xp;
#line 3247
  }
#line 3247
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3247

#line 3247
#else   /* not SX */
#line 3247

#line 3247
	char *xp = (char *) *xpp;
#line 3247
	int status = NC_NOERR;
#line 3247

#line 3247
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3247
	{
#line 3247
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3247
		if (status == NC_NOERR) /* report the first encountered error */
#line 3247
			status = lstatus;
#line 3247
	}
#line 3247

#line 3247
	*xpp = (void *)xp;
#line 3247
	return status;
#line 3247
#endif
#line 3247
}
#line 3247

int
#line 3248
ncx_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3248
{
#line 3248
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3248

#line 3248
 /* basic algorithm is:
#line 3248
  *   - ensure sane alignment of output data
#line 3248
  *   - copy (conversion happens automatically) input data
#line 3248
  *     to output
#line 3248
  *   - update tp to point at next unconverted input, and xpp to point
#line 3248
  *     at next location for converted output
#line 3248
  */
#line 3248
  long i, j, ni;
#line 3248
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3248
  ushort *xp;
#line 3248
  int nrange = 0;         /* number of range errors */
#line 3248
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3248
  long cxp = (long) *((char**)xpp);
#line 3248

#line 3248
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3248
  /* sjl: manually stripmine so we can limit amount of
#line 3248
   * vector work space reserved to LOOPCNT elements. Also
#line 3248
   * makes vectorisation easy */
#line 3248
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3248
    ni=Min(nelems-j,LOOPCNT);
#line 3248
    if (realign) {
#line 3248
      xp = tmp;
#line 3248
    } else {
#line 3248
      xp = (ushort *) *xpp;
#line 3248
    }
#line 3248
   /* copy the next block */
#line 3248
#pragma cdir loopcnt=LOOPCNT
#line 3248
#pragma cdir shortloop
#line 3248
    for (i=0; i<ni; i++) {
#line 3248
      /* the normal case: */
#line 3248
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3248
     /* test for range errors (not always needed but do it anyway) */
#line 3248
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3248
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3248
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3248
    }
#line 3248
   /* copy workspace back if necessary */
#line 3248
    if (realign) {
#line 3248
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3248
      xp = (ushort *) *xpp;
#line 3248
    }
#line 3248
   /* update xpp and tp */
#line 3248
    xp += ni;
#line 3248
    tp += ni;
#line 3248
    *xpp = (void*)xp;
#line 3248
  }
#line 3248
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3248

#line 3248
#else   /* not SX */
#line 3248

#line 3248
	char *xp = (char *) *xpp;
#line 3248
	int status = NC_NOERR;
#line 3248

#line 3248
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3248
	{
#line 3248
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3248
		if (status == NC_NOERR) /* report the first encountered error */
#line 3248
			status = lstatus;
#line 3248
	}
#line 3248

#line 3248
	*xpp = (void *)xp;
#line 3248
	return status;
#line 3248
#endif
#line 3248
}
#line 3248

int
#line 3249
ncx_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3249
{
#line 3249
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3249

#line 3249
 /* basic algorithm is:
#line 3249
  *   - ensure sane alignment of output data
#line 3249
  *   - copy (conversion happens automatically) input data
#line 3249
  *     to output
#line 3249
  *   - update tp to point at next unconverted input, and xpp to point
#line 3249
  *     at next location for converted output
#line 3249
  */
#line 3249
  long i, j, ni;
#line 3249
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3249
  ushort *xp;
#line 3249
  int nrange = 0;         /* number of range errors */
#line 3249
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3249
  long cxp = (long) *((char**)xpp);
#line 3249

#line 3249
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3249
  /* sjl: manually stripmine so we can limit amount of
#line 3249
   * vector work space reserved to LOOPCNT elements. Also
#line 3249
   * makes vectorisation easy */
#line 3249
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3249
    ni=Min(nelems-j,LOOPCNT);
#line 3249
    if (realign) {
#line 3249
      xp = tmp;
#line 3249
    } else {
#line 3249
      xp = (ushort *) *xpp;
#line 3249
    }
#line 3249
   /* copy the next block */
#line 3249
#pragma cdir loopcnt=LOOPCNT
#line 3249
#pragma cdir shortloop
#line 3249
    for (i=0; i<ni; i++) {
#line 3249
      /* the normal case: */
#line 3249
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3249
     /* test for range errors (not always needed but do it anyway) */
#line 3249
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3249
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3249
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3249
    }
#line 3249
   /* copy workspace back if necessary */
#line 3249
    if (realign) {
#line 3249
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3249
      xp = (ushort *) *xpp;
#line 3249
    }
#line 3249
   /* update xpp and tp */
#line 3249
    xp += ni;
#line 3249
    tp += ni;
#line 3249
    *xpp = (void*)xp;
#line 3249
  }
#line 3249
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3249

#line 3249
#else   /* not SX */
#line 3249

#line 3249
	char *xp = (char *) *xpp;
#line 3249
	int status = NC_NOERR;
#line 3249

#line 3249
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3249
	{
#line 3249
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3249
		if (status == NC_NOERR) /* report the first encountered error */
#line 3249
			status = lstatus;
#line 3249
	}
#line 3249

#line 3249
	*xpp = (void *)xp;
#line 3249
	return status;
#line 3249
#endif
#line 3249
}
#line 3249

int
#line 3250
ncx_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3250
{
#line 3250
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3250

#line 3250
 /* basic algorithm is:
#line 3250
  *   - ensure sane alignment of output data
#line 3250
  *   - copy (conversion happens automatically) input data
#line 3250
  *     to output
#line 3250
  *   - update tp to point at next unconverted input, and xpp to point
#line 3250
  *     at next location for converted output
#line 3250
  */
#line 3250
  long i, j, ni;
#line 3250
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3250
  ushort *xp;
#line 3250
  int nrange = 0;         /* number of range errors */
#line 3250
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3250
  long cxp = (long) *((char**)xpp);
#line 3250

#line 3250
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3250
  /* sjl: manually stripmine so we can limit amount of
#line 3250
   * vector work space reserved to LOOPCNT elements. Also
#line 3250
   * makes vectorisation easy */
#line 3250
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3250
    ni=Min(nelems-j,LOOPCNT);
#line 3250
    if (realign) {
#line 3250
      xp = tmp;
#line 3250
    } else {
#line 3250
      xp = (ushort *) *xpp;
#line 3250
    }
#line 3250
   /* copy the next block */
#line 3250
#pragma cdir loopcnt=LOOPCNT
#line 3250
#pragma cdir shortloop
#line 3250
    for (i=0; i<ni; i++) {
#line 3250
      /* the normal case: */
#line 3250
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3250
     /* test for range errors (not always needed but do it anyway) */
#line 3250
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3250
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3250
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3250
    }
#line 3250
   /* copy workspace back if necessary */
#line 3250
    if (realign) {
#line 3250
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3250
      xp = (ushort *) *xpp;
#line 3250
    }
#line 3250
   /* update xpp and tp */
#line 3250
    xp += ni;
#line 3250
    tp += ni;
#line 3250
    *xpp = (void*)xp;
#line 3250
  }
#line 3250
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3250

#line 3250
#else   /* not SX */
#line 3250

#line 3250
	char *xp = (char *) *xpp;
#line 3250
	int status = NC_NOERR;
#line 3250

#line 3250
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3250
	{
#line 3250
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3250
		if (status == NC_NOERR) /* report the first encountered error */
#line 3250
			status = lstatus;
#line 3250
	}
#line 3250

#line 3250
	*xpp = (void *)xp;
#line 3250
	return status;
#line 3250
#endif
#line 3250
}
#line 3250

int
#line 3251
ncx_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3251
{
#line 3251
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3251

#line 3251
 /* basic algorithm is:
#line 3251
  *   - ensure sane alignment of output data
#line 3251
  *   - copy (conversion happens automatically) input data
#line 3251
  *     to output
#line 3251
  *   - update tp to point at next unconverted input, and xpp to point
#line 3251
  *     at next location for converted output
#line 3251
  */
#line 3251
  long i, j, ni;
#line 3251
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3251
  ushort *xp;
#line 3251
  int nrange = 0;         /* number of range errors */
#line 3251
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3251
  long cxp = (long) *((char**)xpp);
#line 3251

#line 3251
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3251
  /* sjl: manually stripmine so we can limit amount of
#line 3251
   * vector work space reserved to LOOPCNT elements. Also
#line 3251
   * makes vectorisation easy */
#line 3251
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3251
    ni=Min(nelems-j,LOOPCNT);
#line 3251
    if (realign) {
#line 3251
      xp = tmp;
#line 3251
    } else {
#line 3251
      xp = (ushort *) *xpp;
#line 3251
    }
#line 3251
   /* copy the next block */
#line 3251
#pragma cdir loopcnt=LOOPCNT
#line 3251
#pragma cdir shortloop
#line 3251
    for (i=0; i<ni; i++) {
#line 3251
      /* the normal case: */
#line 3251
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3251
     /* test for range errors (not always needed but do it anyway) */
#line 3251
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3251
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3251
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3251
    }
#line 3251
   /* copy workspace back if necessary */
#line 3251
    if (realign) {
#line 3251
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3251
      xp = (ushort *) *xpp;
#line 3251
    }
#line 3251
   /* update xpp and tp */
#line 3251
    xp += ni;
#line 3251
    tp += ni;
#line 3251
    *xpp = (void*)xp;
#line 3251
  }
#line 3251
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3251

#line 3251
#else   /* not SX */
#line 3251

#line 3251
	char *xp = (char *) *xpp;
#line 3251
	int status = NC_NOERR;
#line 3251

#line 3251
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3251
	{
#line 3251
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3251
		if (status == NC_NOERR) /* report the first encountered error */
#line 3251
			status = lstatus;
#line 3251
	}
#line 3251

#line 3251
	*xpp = (void *)xp;
#line 3251
	return status;
#line 3251
#endif
#line 3251
}
#line 3251

int
#line 3252
ncx_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3252
{
#line 3252
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3252

#line 3252
 /* basic algorithm is:
#line 3252
  *   - ensure sane alignment of output data
#line 3252
  *   - copy (conversion happens automatically) input data
#line 3252
  *     to output
#line 3252
  *   - update tp to point at next unconverted input, and xpp to point
#line 3252
  *     at next location for converted output
#line 3252
  */
#line 3252
  long i, j, ni;
#line 3252
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3252
  ushort *xp;
#line 3252
  int nrange = 0;         /* number of range errors */
#line 3252
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3252
  long cxp = (long) *((char**)xpp);
#line 3252

#line 3252
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3252
  /* sjl: manually stripmine so we can limit amount of
#line 3252
   * vector work space reserved to LOOPCNT elements. Also
#line 3252
   * makes vectorisation easy */
#line 3252
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3252
    ni=Min(nelems-j,LOOPCNT);
#line 3252
    if (realign) {
#line 3252
      xp = tmp;
#line 3252
    } else {
#line 3252
      xp = (ushort *) *xpp;
#line 3252
    }
#line 3252
   /* copy the next block */
#line 3252
#pragma cdir loopcnt=LOOPCNT
#line 3252
#pragma cdir shortloop
#line 3252
    for (i=0; i<ni; i++) {
#line 3252
      /* the normal case: */
#line 3252
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3252
     /* test for range errors (not always needed but do it anyway) */
#line 3252
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3252
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3252
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3252
    }
#line 3252
   /* copy workspace back if necessary */
#line 3252
    if (realign) {
#line 3252
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3252
      xp = (ushort *) *xpp;
#line 3252
    }
#line 3252
   /* update xpp and tp */
#line 3252
    xp += ni;
#line 3252
    tp += ni;
#line 3252
    *xpp = (void*)xp;
#line 3252
  }
#line 3252
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3252

#line 3252
#else   /* not SX */
#line 3252

#line 3252
	char *xp = (char *) *xpp;
#line 3252
	int status = NC_NOERR;
#line 3252

#line 3252
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3252
	{
#line 3252
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3252
		if (status == NC_NOERR) /* report the first encountered error */
#line 3252
			status = lstatus;
#line 3252
	}
#line 3252

#line 3252
	*xpp = (void *)xp;
#line 3252
	return status;
#line 3252
#endif
#line 3252
}
#line 3252

int
#line 3253
ncx_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3253
{
#line 3253
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3253

#line 3253
 /* basic algorithm is:
#line 3253
  *   - ensure sane alignment of output data
#line 3253
  *   - copy (conversion happens automatically) input data
#line 3253
  *     to output
#line 3253
  *   - update tp to point at next unconverted input, and xpp to point
#line 3253
  *     at next location for converted output
#line 3253
  */
#line 3253
  long i, j, ni;
#line 3253
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3253
  ushort *xp;
#line 3253
  int nrange = 0;         /* number of range errors */
#line 3253
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3253
  long cxp = (long) *((char**)xpp);
#line 3253

#line 3253
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3253
  /* sjl: manually stripmine so we can limit amount of
#line 3253
   * vector work space reserved to LOOPCNT elements. Also
#line 3253
   * makes vectorisation easy */
#line 3253
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3253
    ni=Min(nelems-j,LOOPCNT);
#line 3253
    if (realign) {
#line 3253
      xp = tmp;
#line 3253
    } else {
#line 3253
      xp = (ushort *) *xpp;
#line 3253
    }
#line 3253
   /* copy the next block */
#line 3253
#pragma cdir loopcnt=LOOPCNT
#line 3253
#pragma cdir shortloop
#line 3253
    for (i=0; i<ni; i++) {
#line 3253
      /* the normal case: */
#line 3253
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3253
     /* test for range errors (not always needed but do it anyway) */
#line 3253
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3253
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3253
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 3253
    }
#line 3253
   /* copy workspace back if necessary */
#line 3253
    if (realign) {
#line 3253
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3253
      xp = (ushort *) *xpp;
#line 3253
    }
#line 3253
   /* update xpp and tp */
#line 3253
    xp += ni;
#line 3253
    tp += ni;
#line 3253
    *xpp = (void*)xp;
#line 3253
  }
#line 3253
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3253

#line 3253
#else   /* not SX */
#line 3253

#line 3253
	char *xp = (char *) *xpp;
#line 3253
	int status = NC_NOERR;
#line 3253

#line 3253
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3253
	{
#line 3253
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3253
		if (status == NC_NOERR) /* report the first encountered error */
#line 3253
			status = lstatus;
#line 3253
	}
#line 3253

#line 3253
	*xpp = (void *)xp;
#line 3253
	return status;
#line 3253
#endif
#line 3253
}
#line 3253

int
#line 3254
ncx_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3254
{
#line 3254
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3254

#line 3254
 /* basic algorithm is:
#line 3254
  *   - ensure sane alignment of output data
#line 3254
  *   - copy (conversion happens automatically) input data
#line 3254
  *     to output
#line 3254
  *   - update tp to point at next unconverted input, and xpp to point
#line 3254
  *     at next location for converted output
#line 3254
  */
#line 3254
  long i, j, ni;
#line 3254
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3254
  ushort *xp;
#line 3254
  int nrange = 0;         /* number of range errors */
#line 3254
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3254
  long cxp = (long) *((char**)xpp);
#line 3254

#line 3254
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3254
  /* sjl: manually stripmine so we can limit amount of
#line 3254
   * vector work space reserved to LOOPCNT elements. Also
#line 3254
   * makes vectorisation easy */
#line 3254
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3254
    ni=Min(nelems-j,LOOPCNT);
#line 3254
    if (realign) {
#line 3254
      xp = tmp;
#line 3254
    } else {
#line 3254
      xp = (ushort *) *xpp;
#line 3254
    }
#line 3254
   /* copy the next block */
#line 3254
#pragma cdir loopcnt=LOOPCNT
#line 3254
#pragma cdir shortloop
#line 3254
    for (i=0; i<ni; i++) {
#line 3254
      /* the normal case: */
#line 3254
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3254
     /* test for range errors (not always needed but do it anyway) */
#line 3254
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3254
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3254
      nrange += tp[i] > X_USHORT_MAX ;
#line 3254
    }
#line 3254
   /* copy workspace back if necessary */
#line 3254
    if (realign) {
#line 3254
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3254
      xp = (ushort *) *xpp;
#line 3254
    }
#line 3254
   /* update xpp and tp */
#line 3254
    xp += ni;
#line 3254
    tp += ni;
#line 3254
    *xpp = (void*)xp;
#line 3254
  }
#line 3254
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3254

#line 3254
#else   /* not SX */
#line 3254

#line 3254
	char *xp = (char *) *xpp;
#line 3254
	int status = NC_NOERR;
#line 3254

#line 3254
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3254
	{
#line 3254
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3254
		if (status == NC_NOERR) /* report the first encountered error */
#line 3254
			status = lstatus;
#line 3254
	}
#line 3254

#line 3254
	*xpp = (void *)xp;
#line 3254
	return status;
#line 3254
#endif
#line 3254
}
#line 3254

int
#line 3255
ncx_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3255
{
#line 3255
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3255

#line 3255
 /* basic algorithm is:
#line 3255
  *   - ensure sane alignment of output data
#line 3255
  *   - copy (conversion happens automatically) input data
#line 3255
  *     to output
#line 3255
  *   - update tp to point at next unconverted input, and xpp to point
#line 3255
  *     at next location for converted output
#line 3255
  */
#line 3255
  long i, j, ni;
#line 3255
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3255
  ushort *xp;
#line 3255
  int nrange = 0;         /* number of range errors */
#line 3255
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3255
  long cxp = (long) *((char**)xpp);
#line 3255

#line 3255
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3255
  /* sjl: manually stripmine so we can limit amount of
#line 3255
   * vector work space reserved to LOOPCNT elements. Also
#line 3255
   * makes vectorisation easy */
#line 3255
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3255
    ni=Min(nelems-j,LOOPCNT);
#line 3255
    if (realign) {
#line 3255
      xp = tmp;
#line 3255
    } else {
#line 3255
      xp = (ushort *) *xpp;
#line 3255
    }
#line 3255
   /* copy the next block */
#line 3255
#pragma cdir loopcnt=LOOPCNT
#line 3255
#pragma cdir shortloop
#line 3255
    for (i=0; i<ni; i++) {
#line 3255
      /* the normal case: */
#line 3255
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3255
     /* test for range errors (not always needed but do it anyway) */
#line 3255
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3255
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3255
      nrange += tp[i] > X_USHORT_MAX ;
#line 3255
    }
#line 3255
   /* copy workspace back if necessary */
#line 3255
    if (realign) {
#line 3255
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3255
      xp = (ushort *) *xpp;
#line 3255
    }
#line 3255
   /* update xpp and tp */
#line 3255
    xp += ni;
#line 3255
    tp += ni;
#line 3255
    *xpp = (void*)xp;
#line 3255
  }
#line 3255
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3255

#line 3255
#else   /* not SX */
#line 3255

#line 3255
	char *xp = (char *) *xpp;
#line 3255
	int status = NC_NOERR;
#line 3255

#line 3255
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3255
	{
#line 3255
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3255
		if (status == NC_NOERR) /* report the first encountered error */
#line 3255
			status = lstatus;
#line 3255
	}
#line 3255

#line 3255
	*xpp = (void *)xp;
#line 3255
	return status;
#line 3255
#endif
#line 3255
}
#line 3255

int
#line 3256
ncx_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3256
{
#line 3256
#if defined(_SX) && _SX != 0 && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 3256

#line 3256
 /* basic algorithm is:
#line 3256
  *   - ensure sane alignment of output data
#line 3256
  *   - copy (conversion happens automatically) input data
#line 3256
  *     to output
#line 3256
  *   - update tp to point at next unconverted input, and xpp to point
#line 3256
  *     at next location for converted output
#line 3256
  */
#line 3256
  long i, j, ni;
#line 3256
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 3256
  ushort *xp;
#line 3256
  int nrange = 0;         /* number of range errors */
#line 3256
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3256
  long cxp = (long) *((char**)xpp);
#line 3256

#line 3256
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 3256
  /* sjl: manually stripmine so we can limit amount of
#line 3256
   * vector work space reserved to LOOPCNT elements. Also
#line 3256
   * makes vectorisation easy */
#line 3256
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3256
    ni=Min(nelems-j,LOOPCNT);
#line 3256
    if (realign) {
#line 3256
      xp = tmp;
#line 3256
    } else {
#line 3256
      xp = (ushort *) *xpp;
#line 3256
    }
#line 3256
   /* copy the next block */
#line 3256
#pragma cdir loopcnt=LOOPCNT
#line 3256
#pragma cdir shortloop
#line 3256
    for (i=0; i<ni; i++) {
#line 3256
      /* the normal case: */
#line 3256
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 3256
     /* test for range errors (not always needed but do it anyway) */
#line 3256
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3256
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3256
      nrange += tp[i] > X_USHORT_MAX ;
#line 3256
    }
#line 3256
   /* copy workspace back if necessary */
#line 3256
    if (realign) {
#line 3256
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_USHORT);
#line 3256
      xp = (ushort *) *xpp;
#line 3256
    }
#line 3256
   /* update xpp and tp */
#line 3256
    xp += ni;
#line 3256
    tp += ni;
#line 3256
    *xpp = (void*)xp;
#line 3256
  }
#line 3256
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3256

#line 3256
#else   /* not SX */
#line 3256

#line 3256
	char *xp = (char *) *xpp;
#line 3256
	int status = NC_NOERR;
#line 3256

#line 3256
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3256
	{
#line 3256
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3256
		if (status == NC_NOERR) /* report the first encountered error */
#line 3256
			status = lstatus;
#line 3256
	}
#line 3256

#line 3256
	*xpp = (void *)xp;
#line 3256
	return status;
#line 3256
#endif
#line 3256
}
#line 3256


int
#line 3258
ncx_pad_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3258
{
#line 3258
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3258

#line 3258
	char *xp = (char *) *xpp;
#line 3258
	int status = NC_NOERR;
#line 3258

#line 3258
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3258
	{
#line 3258
		int lstatus = ncx_put_ushort_schar(xp, tp, fillp);
#line 3258
		if (status == NC_NOERR) /* report the first encountered error */
#line 3258
			status = lstatus;
#line 3258
	}
#line 3258

#line 3258
	if (rndup != 0)
#line 3258
	{
#line 3258
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3258
		xp += X_SIZEOF_USHORT;
#line 3258
	}
#line 3258

#line 3258
	*xpp = (void *)xp;
#line 3258
	return status;
#line 3258
}
#line 3258

int
#line 3259
ncx_pad_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3259
{
#line 3259
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3259

#line 3259
	char *xp = (char *) *xpp;
#line 3259
	int status = NC_NOERR;
#line 3259

#line 3259
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3259
	{
#line 3259
		int lstatus = ncx_put_ushort_uchar(xp, tp, fillp);
#line 3259
		if (status == NC_NOERR) /* report the first encountered error */
#line 3259
			status = lstatus;
#line 3259
	}
#line 3259

#line 3259
	if (rndup != 0)
#line 3259
	{
#line 3259
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3259
		xp += X_SIZEOF_USHORT;
#line 3259
	}
#line 3259

#line 3259
	*xpp = (void *)xp;
#line 3259
	return status;
#line 3259
}
#line 3259

int
#line 3260
ncx_pad_putn_ushort_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3260
{
#line 3260
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3260

#line 3260
	char *xp = (char *) *xpp;
#line 3260
	int status = NC_NOERR;
#line 3260

#line 3260
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3260
	{
#line 3260
		int lstatus = ncx_put_ushort_short(xp, tp, fillp);
#line 3260
		if (status == NC_NOERR) /* report the first encountered error */
#line 3260
			status = lstatus;
#line 3260
	}
#line 3260

#line 3260
	if (rndup != 0)
#line 3260
	{
#line 3260
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3260
		xp += X_SIZEOF_USHORT;
#line 3260
	}
#line 3260

#line 3260
	*xpp = (void *)xp;
#line 3260
	return status;
#line 3260
}
#line 3260

int
#line 3261
ncx_pad_putn_ushort_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3261
{
#line 3261
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3261

#line 3261
	char *xp = (char *) *xpp;
#line 3261
	int status = NC_NOERR;
#line 3261

#line 3261
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3261
	{
#line 3261
		int lstatus = ncx_put_ushort_int(xp, tp, fillp);
#line 3261
		if (status == NC_NOERR) /* report the first encountered error */
#line 3261
			status = lstatus;
#line 3261
	}
#line 3261

#line 3261
	if (rndup != 0)
#line 3261
	{
#line 3261
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3261
		xp += X_SIZEOF_USHORT;
#line 3261
	}
#line 3261

#line 3261
	*xpp = (void *)xp;
#line 3261
	return status;
#line 3261
}
#line 3261

int
#line 3262
ncx_pad_putn_ushort_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3262
{
#line 3262
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3262

#line 3262
	char *xp = (char *) *xpp;
#line 3262
	int status = NC_NOERR;
#line 3262

#line 3262
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3262
	{
#line 3262
		int lstatus = ncx_put_ushort_long(xp, tp, fillp);
#line 3262
		if (status == NC_NOERR) /* report the first encountered error */
#line 3262
			status = lstatus;
#line 3262
	}
#line 3262

#line 3262
	if (rndup != 0)
#line 3262
	{
#line 3262
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3262
		xp += X_SIZEOF_USHORT;
#line 3262
	}
#line 3262

#line 3262
	*xpp = (void *)xp;
#line 3262
	return status;
#line 3262
}
#line 3262

int
#line 3263
ncx_pad_putn_ushort_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3263
{
#line 3263
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3263

#line 3263
	char *xp = (char *) *xpp;
#line 3263
	int status = NC_NOERR;
#line 3263

#line 3263
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3263
	{
#line 3263
		int lstatus = ncx_put_ushort_float(xp, tp, fillp);
#line 3263
		if (status == NC_NOERR) /* report the first encountered error */
#line 3263
			status = lstatus;
#line 3263
	}
#line 3263

#line 3263
	if (rndup != 0)
#line 3263
	{
#line 3263
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3263
		xp += X_SIZEOF_USHORT;
#line 3263
	}
#line 3263

#line 3263
	*xpp = (void *)xp;
#line 3263
	return status;
#line 3263
}
#line 3263

int
#line 3264
ncx_pad_putn_ushort_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3264
{
#line 3264
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3264

#line 3264
	char *xp = (char *) *xpp;
#line 3264
	int status = NC_NOERR;
#line 3264

#line 3264
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3264
	{
#line 3264
		int lstatus = ncx_put_ushort_double(xp, tp, fillp);
#line 3264
		if (status == NC_NOERR) /* report the first encountered error */
#line 3264
			status = lstatus;
#line 3264
	}
#line 3264

#line 3264
	if (rndup != 0)
#line 3264
	{
#line 3264
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3264
		xp += X_SIZEOF_USHORT;
#line 3264
	}
#line 3264

#line 3264
	*xpp = (void *)xp;
#line 3264
	return status;
#line 3264
}
#line 3264

int
#line 3265
ncx_pad_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3265
{
#line 3265
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3265

#line 3265
	char *xp = (char *) *xpp;
#line 3265
	int status = NC_NOERR;
#line 3265

#line 3265
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3265
	{
#line 3265
		int lstatus = ncx_put_ushort_uint(xp, tp, fillp);
#line 3265
		if (status == NC_NOERR) /* report the first encountered error */
#line 3265
			status = lstatus;
#line 3265
	}
#line 3265

#line 3265
	if (rndup != 0)
#line 3265
	{
#line 3265
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3265
		xp += X_SIZEOF_USHORT;
#line 3265
	}
#line 3265

#line 3265
	*xpp = (void *)xp;
#line 3265
	return status;
#line 3265
}
#line 3265

int
#line 3266
ncx_pad_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3266
{
#line 3266
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3266

#line 3266
	char *xp = (char *) *xpp;
#line 3266
	int status = NC_NOERR;
#line 3266

#line 3266
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3266
	{
#line 3266
		int lstatus = ncx_put_ushort_longlong(xp, tp, fillp);
#line 3266
		if (status == NC_NOERR) /* report the first encountered error */
#line 3266
			status = lstatus;
#line 3266
	}
#line 3266

#line 3266
	if (rndup != 0)
#line 3266
	{
#line 3266
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3266
		xp += X_SIZEOF_USHORT;
#line 3266
	}
#line 3266

#line 3266
	*xpp = (void *)xp;
#line 3266
	return status;
#line 3266
}
#line 3266

int
#line 3267
ncx_pad_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3267
{
#line 3267
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3267

#line 3267
	char *xp = (char *) *xpp;
#line 3267
	int status = NC_NOERR;
#line 3267

#line 3267
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3267
	{
#line 3267
		int lstatus = ncx_put_ushort_ulonglong(xp, tp, fillp);
#line 3267
		if (status == NC_NOERR) /* report the first encountered error */
#line 3267
			status = lstatus;
#line 3267
	}
#line 3267

#line 3267
	if (rndup != 0)
#line 3267
	{
#line 3267
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3267
		xp += X_SIZEOF_USHORT;
#line 3267
	}
#line 3267

#line 3267
	*xpp = (void *)xp;
#line 3267
	return status;
#line 3267
}
#line 3267

int
#line 3268
ncx_pad_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3268
{
#line 3268
	const size_t rndup = nelems % X_SIZEOF_SHORT;
#line 3268

#line 3268
	char *xp = (char *) *xpp;
#line 3268
	int status = NC_NOERR;
#line 3268

#line 3268
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 3268
	{
#line 3268
		int lstatus = ncx_put_ushort_ushort(xp, tp, fillp);
#line 3268
		if (status == NC_NOERR) /* report the first encountered error */
#line 3268
			status = lstatus;
#line 3268
	}
#line 3268

#line 3268
	if (rndup != 0)
#line 3268
	{
#line 3268
		(void) memcpy(xp, nada, (size_t)(X_SIZEOF_USHORT));
#line 3268
		xp += X_SIZEOF_USHORT;
#line 3268
	}
#line 3268

#line 3268
	*xpp = (void *)xp;
#line 3268
	return status;
#line 3268
}
#line 3268



/* int -----------------------------------------------------------------------*/

#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_INT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3287
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
#line 3287
{
#line 3287
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3287

#line 3287
 /* basic algorithm is:
#line 3287
  *   - ensure sane alignment of input data
#line 3287
  *   - copy (conversion happens automatically) input data
#line 3287
  *     to output
#line 3287
  *   - update xpp to point at next unconverted input, and tp to point
#line 3287
  *     at next location for converted output
#line 3287
  */
#line 3287
  long i, j, ni;
#line 3287
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3287
  int *xp;
#line 3287
  int nrange = 0;         /* number of range errors */
#line 3287
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3287
  long cxp = (long) *((char**)xpp);
#line 3287

#line 3287
  realign = (cxp & 7) % SIZEOF_INT;
#line 3287
  /* sjl: manually stripmine so we can limit amount of
#line 3287
   * vector work space reserved to LOOPCNT elements. Also
#line 3287
   * makes vectorisation easy */
#line 3287
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3287
    ni=Min(nelems-j,LOOPCNT);
#line 3287
    if (realign) {
#line 3287
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3287
      xp = tmp;
#line 3287
    } else {
#line 3287
      xp = (int *) *xpp;
#line 3287
    }
#line 3287
   /* copy the next block */
#line 3287
#pragma cdir loopcnt=LOOPCNT
#line 3287
#pragma cdir shortloop
#line 3287
    for (i=0; i<ni; i++) {
#line 3287
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3287
     /* test for range errors (not always needed but do it anyway) */
#line 3287
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3287
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3287
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3287
    }
#line 3287
   /* update xpp and tp */
#line 3287
    if (realign) xp = (int *) *xpp;
#line 3287
    xp += ni;
#line 3287
    tp += ni;
#line 3287
    *xpp = (void*)xp;
#line 3287
  }
#line 3287
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3287

#line 3287
#else   /* not SX */
#line 3287
	const char *xp = (const char *) *xpp;
#line 3287
	int status = NC_NOERR;
#line 3287

#line 3287
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3287
	{
#line 3287
		const int lstatus = ncx_get_int_int(xp, tp);
#line 3287
		if (status == NC_NOERR) /* report the first encountered error */
#line 3287
			status = lstatus;
#line 3287
	}
#line 3287

#line 3287
	*xpp = (const void *)xp;
#line 3287
	return status;
#line 3287
#endif
#line 3287
}
#line 3287

#endif
int
#line 3289
ncx_getn_int_schar(const void **xpp, size_t nelems, schar *tp)
#line 3289
{
#line 3289
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3289

#line 3289
 /* basic algorithm is:
#line 3289
  *   - ensure sane alignment of input data
#line 3289
  *   - copy (conversion happens automatically) input data
#line 3289
  *     to output
#line 3289
  *   - update xpp to point at next unconverted input, and tp to point
#line 3289
  *     at next location for converted output
#line 3289
  */
#line 3289
  long i, j, ni;
#line 3289
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3289
  int *xp;
#line 3289
  int nrange = 0;         /* number of range errors */
#line 3289
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3289
  long cxp = (long) *((char**)xpp);
#line 3289

#line 3289
  realign = (cxp & 7) % SIZEOF_INT;
#line 3289
  /* sjl: manually stripmine so we can limit amount of
#line 3289
   * vector work space reserved to LOOPCNT elements. Also
#line 3289
   * makes vectorisation easy */
#line 3289
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3289
    ni=Min(nelems-j,LOOPCNT);
#line 3289
    if (realign) {
#line 3289
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3289
      xp = tmp;
#line 3289
    } else {
#line 3289
      xp = (int *) *xpp;
#line 3289
    }
#line 3289
   /* copy the next block */
#line 3289
#pragma cdir loopcnt=LOOPCNT
#line 3289
#pragma cdir shortloop
#line 3289
    for (i=0; i<ni; i++) {
#line 3289
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3289
     /* test for range errors (not always needed but do it anyway) */
#line 3289
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3289
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3289
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3289
    }
#line 3289
   /* update xpp and tp */
#line 3289
    if (realign) xp = (int *) *xpp;
#line 3289
    xp += ni;
#line 3289
    tp += ni;
#line 3289
    *xpp = (void*)xp;
#line 3289
  }
#line 3289
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3289

#line 3289
#else   /* not SX */
#line 3289
	const char *xp = (const char *) *xpp;
#line 3289
	int status = NC_NOERR;
#line 3289

#line 3289
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3289
	{
#line 3289
		const int lstatus = ncx_get_int_schar(xp, tp);
#line 3289
		if (status == NC_NOERR) /* report the first encountered error */
#line 3289
			status = lstatus;
#line 3289
	}
#line 3289

#line 3289
	*xpp = (const void *)xp;
#line 3289
	return status;
#line 3289
#endif
#line 3289
}
#line 3289

int
#line 3290
ncx_getn_int_short(const void **xpp, size_t nelems, short *tp)
#line 3290
{
#line 3290
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3290

#line 3290
 /* basic algorithm is:
#line 3290
  *   - ensure sane alignment of input data
#line 3290
  *   - copy (conversion happens automatically) input data
#line 3290
  *     to output
#line 3290
  *   - update xpp to point at next unconverted input, and tp to point
#line 3290
  *     at next location for converted output
#line 3290
  */
#line 3290
  long i, j, ni;
#line 3290
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3290
  int *xp;
#line 3290
  int nrange = 0;         /* number of range errors */
#line 3290
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3290
  long cxp = (long) *((char**)xpp);
#line 3290

#line 3290
  realign = (cxp & 7) % SIZEOF_INT;
#line 3290
  /* sjl: manually stripmine so we can limit amount of
#line 3290
   * vector work space reserved to LOOPCNT elements. Also
#line 3290
   * makes vectorisation easy */
#line 3290
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3290
    ni=Min(nelems-j,LOOPCNT);
#line 3290
    if (realign) {
#line 3290
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3290
      xp = tmp;
#line 3290
    } else {
#line 3290
      xp = (int *) *xpp;
#line 3290
    }
#line 3290
   /* copy the next block */
#line 3290
#pragma cdir loopcnt=LOOPCNT
#line 3290
#pragma cdir shortloop
#line 3290
    for (i=0; i<ni; i++) {
#line 3290
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3290
     /* test for range errors (not always needed but do it anyway) */
#line 3290
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3290
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3290
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3290
    }
#line 3290
   /* update xpp and tp */
#line 3290
    if (realign) xp = (int *) *xpp;
#line 3290
    xp += ni;
#line 3290
    tp += ni;
#line 3290
    *xpp = (void*)xp;
#line 3290
  }
#line 3290
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3290

#line 3290
#else   /* not SX */
#line 3290
	const char *xp = (const char *) *xpp;
#line 3290
	int status = NC_NOERR;
#line 3290

#line 3290
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3290
	{
#line 3290
		const int lstatus = ncx_get_int_short(xp, tp);
#line 3290
		if (status == NC_NOERR) /* report the first encountered error */
#line 3290
			status = lstatus;
#line 3290
	}
#line 3290

#line 3290
	*xpp = (const void *)xp;
#line 3290
	return status;
#line 3290
#endif
#line 3290
}
#line 3290

int
#line 3291
ncx_getn_int_long(const void **xpp, size_t nelems, long *tp)
#line 3291
{
#line 3291
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3291

#line 3291
 /* basic algorithm is:
#line 3291
  *   - ensure sane alignment of input data
#line 3291
  *   - copy (conversion happens automatically) input data
#line 3291
  *     to output
#line 3291
  *   - update xpp to point at next unconverted input, and tp to point
#line 3291
  *     at next location for converted output
#line 3291
  */
#line 3291
  long i, j, ni;
#line 3291
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3291
  int *xp;
#line 3291
  int nrange = 0;         /* number of range errors */
#line 3291
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3291
  long cxp = (long) *((char**)xpp);
#line 3291

#line 3291
  realign = (cxp & 7) % SIZEOF_INT;
#line 3291
  /* sjl: manually stripmine so we can limit amount of
#line 3291
   * vector work space reserved to LOOPCNT elements. Also
#line 3291
   * makes vectorisation easy */
#line 3291
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3291
    ni=Min(nelems-j,LOOPCNT);
#line 3291
    if (realign) {
#line 3291
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3291
      xp = tmp;
#line 3291
    } else {
#line 3291
      xp = (int *) *xpp;
#line 3291
    }
#line 3291
   /* copy the next block */
#line 3291
#pragma cdir loopcnt=LOOPCNT
#line 3291
#pragma cdir shortloop
#line 3291
    for (i=0; i<ni; i++) {
#line 3291
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3291
     /* test for range errors (not always needed but do it anyway) */
#line 3291
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3291
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3291
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3291
    }
#line 3291
   /* update xpp and tp */
#line 3291
    if (realign) xp = (int *) *xpp;
#line 3291
    xp += ni;
#line 3291
    tp += ni;
#line 3291
    *xpp = (void*)xp;
#line 3291
  }
#line 3291
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3291

#line 3291
#else   /* not SX */
#line 3291
	const char *xp = (const char *) *xpp;
#line 3291
	int status = NC_NOERR;
#line 3291

#line 3291
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3291
	{
#line 3291
		const int lstatus = ncx_get_int_long(xp, tp);
#line 3291
		if (status == NC_NOERR) /* report the first encountered error */
#line 3291
			status = lstatus;
#line 3291
	}
#line 3291

#line 3291
	*xpp = (const void *)xp;
#line 3291
	return status;
#line 3291
#endif
#line 3291
}
#line 3291

int
#line 3292
ncx_getn_int_float(const void **xpp, size_t nelems, float *tp)
#line 3292
{
#line 3292
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3292

#line 3292
 /* basic algorithm is:
#line 3292
  *   - ensure sane alignment of input data
#line 3292
  *   - copy (conversion happens automatically) input data
#line 3292
  *     to output
#line 3292
  *   - update xpp to point at next unconverted input, and tp to point
#line 3292
  *     at next location for converted output
#line 3292
  */
#line 3292
  long i, j, ni;
#line 3292
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3292
  int *xp;
#line 3292
  int nrange = 0;         /* number of range errors */
#line 3292
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3292
  long cxp = (long) *((char**)xpp);
#line 3292

#line 3292
  realign = (cxp & 7) % SIZEOF_INT;
#line 3292
  /* sjl: manually stripmine so we can limit amount of
#line 3292
   * vector work space reserved to LOOPCNT elements. Also
#line 3292
   * makes vectorisation easy */
#line 3292
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3292
    ni=Min(nelems-j,LOOPCNT);
#line 3292
    if (realign) {
#line 3292
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3292
      xp = tmp;
#line 3292
    } else {
#line 3292
      xp = (int *) *xpp;
#line 3292
    }
#line 3292
   /* copy the next block */
#line 3292
#pragma cdir loopcnt=LOOPCNT
#line 3292
#pragma cdir shortloop
#line 3292
    for (i=0; i<ni; i++) {
#line 3292
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3292
     /* test for range errors (not always needed but do it anyway) */
#line 3292
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3292
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3292
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3292
    }
#line 3292
   /* update xpp and tp */
#line 3292
    if (realign) xp = (int *) *xpp;
#line 3292
    xp += ni;
#line 3292
    tp += ni;
#line 3292
    *xpp = (void*)xp;
#line 3292
  }
#line 3292
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3292

#line 3292
#else   /* not SX */
#line 3292
	const char *xp = (const char *) *xpp;
#line 3292
	int status = NC_NOERR;
#line 3292

#line 3292
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3292
	{
#line 3292
		const int lstatus = ncx_get_int_float(xp, tp);
#line 3292
		if (status == NC_NOERR) /* report the first encountered error */
#line 3292
			status = lstatus;
#line 3292
	}
#line 3292

#line 3292
	*xpp = (const void *)xp;
#line 3292
	return status;
#line 3292
#endif
#line 3292
}
#line 3292

int
#line 3293
ncx_getn_int_double(const void **xpp, size_t nelems, double *tp)
#line 3293
{
#line 3293
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3293

#line 3293
 /* basic algorithm is:
#line 3293
  *   - ensure sane alignment of input data
#line 3293
  *   - copy (conversion happens automatically) input data
#line 3293
  *     to output
#line 3293
  *   - update xpp to point at next unconverted input, and tp to point
#line 3293
  *     at next location for converted output
#line 3293
  */
#line 3293
  long i, j, ni;
#line 3293
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3293
  int *xp;
#line 3293
  int nrange = 0;         /* number of range errors */
#line 3293
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3293
  long cxp = (long) *((char**)xpp);
#line 3293

#line 3293
  realign = (cxp & 7) % SIZEOF_INT;
#line 3293
  /* sjl: manually stripmine so we can limit amount of
#line 3293
   * vector work space reserved to LOOPCNT elements. Also
#line 3293
   * makes vectorisation easy */
#line 3293
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3293
    ni=Min(nelems-j,LOOPCNT);
#line 3293
    if (realign) {
#line 3293
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3293
      xp = tmp;
#line 3293
    } else {
#line 3293
      xp = (int *) *xpp;
#line 3293
    }
#line 3293
   /* copy the next block */
#line 3293
#pragma cdir loopcnt=LOOPCNT
#line 3293
#pragma cdir shortloop
#line 3293
    for (i=0; i<ni; i++) {
#line 3293
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3293
     /* test for range errors (not always needed but do it anyway) */
#line 3293
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3293
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3293
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3293
    }
#line 3293
   /* update xpp and tp */
#line 3293
    if (realign) xp = (int *) *xpp;
#line 3293
    xp += ni;
#line 3293
    tp += ni;
#line 3293
    *xpp = (void*)xp;
#line 3293
  }
#line 3293
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3293

#line 3293
#else   /* not SX */
#line 3293
	const char *xp = (const char *) *xpp;
#line 3293
	int status = NC_NOERR;
#line 3293

#line 3293
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3293
	{
#line 3293
		const int lstatus = ncx_get_int_double(xp, tp);
#line 3293
		if (status == NC_NOERR) /* report the first encountered error */
#line 3293
			status = lstatus;
#line 3293
	}
#line 3293

#line 3293
	*xpp = (const void *)xp;
#line 3293
	return status;
#line 3293
#endif
#line 3293
}
#line 3293

int
#line 3294
ncx_getn_int_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3294
{
#line 3294
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3294

#line 3294
 /* basic algorithm is:
#line 3294
  *   - ensure sane alignment of input data
#line 3294
  *   - copy (conversion happens automatically) input data
#line 3294
  *     to output
#line 3294
  *   - update xpp to point at next unconverted input, and tp to point
#line 3294
  *     at next location for converted output
#line 3294
  */
#line 3294
  long i, j, ni;
#line 3294
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3294
  int *xp;
#line 3294
  int nrange = 0;         /* number of range errors */
#line 3294
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3294
  long cxp = (long) *((char**)xpp);
#line 3294

#line 3294
  realign = (cxp & 7) % SIZEOF_INT;
#line 3294
  /* sjl: manually stripmine so we can limit amount of
#line 3294
   * vector work space reserved to LOOPCNT elements. Also
#line 3294
   * makes vectorisation easy */
#line 3294
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3294
    ni=Min(nelems-j,LOOPCNT);
#line 3294
    if (realign) {
#line 3294
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3294
      xp = tmp;
#line 3294
    } else {
#line 3294
      xp = (int *) *xpp;
#line 3294
    }
#line 3294
   /* copy the next block */
#line 3294
#pragma cdir loopcnt=LOOPCNT
#line 3294
#pragma cdir shortloop
#line 3294
    for (i=0; i<ni; i++) {
#line 3294
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3294
     /* test for range errors (not always needed but do it anyway) */
#line 3294
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3294
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3294
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3294
    }
#line 3294
   /* update xpp and tp */
#line 3294
    if (realign) xp = (int *) *xpp;
#line 3294
    xp += ni;
#line 3294
    tp += ni;
#line 3294
    *xpp = (void*)xp;
#line 3294
  }
#line 3294
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3294

#line 3294
#else   /* not SX */
#line 3294
	const char *xp = (const char *) *xpp;
#line 3294
	int status = NC_NOERR;
#line 3294

#line 3294
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3294
	{
#line 3294
		const int lstatus = ncx_get_int_longlong(xp, tp);
#line 3294
		if (status == NC_NOERR) /* report the first encountered error */
#line 3294
			status = lstatus;
#line 3294
	}
#line 3294

#line 3294
	*xpp = (const void *)xp;
#line 3294
	return status;
#line 3294
#endif
#line 3294
}
#line 3294

int
#line 3295
ncx_getn_int_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3295
{
#line 3295
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3295

#line 3295
 /* basic algorithm is:
#line 3295
  *   - ensure sane alignment of input data
#line 3295
  *   - copy (conversion happens automatically) input data
#line 3295
  *     to output
#line 3295
  *   - update xpp to point at next unconverted input, and tp to point
#line 3295
  *     at next location for converted output
#line 3295
  */
#line 3295
  long i, j, ni;
#line 3295
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3295
  int *xp;
#line 3295
  int nrange = 0;         /* number of range errors */
#line 3295
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3295
  long cxp = (long) *((char**)xpp);
#line 3295

#line 3295
  realign = (cxp & 7) % SIZEOF_INT;
#line 3295
  /* sjl: manually stripmine so we can limit amount of
#line 3295
   * vector work space reserved to LOOPCNT elements. Also
#line 3295
   * makes vectorisation easy */
#line 3295
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3295
    ni=Min(nelems-j,LOOPCNT);
#line 3295
    if (realign) {
#line 3295
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3295
      xp = tmp;
#line 3295
    } else {
#line 3295
      xp = (int *) *xpp;
#line 3295
    }
#line 3295
   /* copy the next block */
#line 3295
#pragma cdir loopcnt=LOOPCNT
#line 3295
#pragma cdir shortloop
#line 3295
    for (i=0; i<ni; i++) {
#line 3295
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3295
     /* test for range errors (not always needed but do it anyway) */
#line 3295
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3295
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3295
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3295
    }
#line 3295
   /* update xpp and tp */
#line 3295
    if (realign) xp = (int *) *xpp;
#line 3295
    xp += ni;
#line 3295
    tp += ni;
#line 3295
    *xpp = (void*)xp;
#line 3295
  }
#line 3295
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3295

#line 3295
#else   /* not SX */
#line 3295
	const char *xp = (const char *) *xpp;
#line 3295
	int status = NC_NOERR;
#line 3295

#line 3295
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3295
	{
#line 3295
		const int lstatus = ncx_get_int_uchar(xp, tp);
#line 3295
		if (status == NC_NOERR) /* report the first encountered error */
#line 3295
			status = lstatus;
#line 3295
	}
#line 3295

#line 3295
	*xpp = (const void *)xp;
#line 3295
	return status;
#line 3295
#endif
#line 3295
}
#line 3295

int
#line 3296
ncx_getn_int_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3296
{
#line 3296
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3296

#line 3296
 /* basic algorithm is:
#line 3296
  *   - ensure sane alignment of input data
#line 3296
  *   - copy (conversion happens automatically) input data
#line 3296
  *     to output
#line 3296
  *   - update xpp to point at next unconverted input, and tp to point
#line 3296
  *     at next location for converted output
#line 3296
  */
#line 3296
  long i, j, ni;
#line 3296
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3296
  int *xp;
#line 3296
  int nrange = 0;         /* number of range errors */
#line 3296
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3296
  long cxp = (long) *((char**)xpp);
#line 3296

#line 3296
  realign = (cxp & 7) % SIZEOF_INT;
#line 3296
  /* sjl: manually stripmine so we can limit amount of
#line 3296
   * vector work space reserved to LOOPCNT elements. Also
#line 3296
   * makes vectorisation easy */
#line 3296
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3296
    ni=Min(nelems-j,LOOPCNT);
#line 3296
    if (realign) {
#line 3296
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3296
      xp = tmp;
#line 3296
    } else {
#line 3296
      xp = (int *) *xpp;
#line 3296
    }
#line 3296
   /* copy the next block */
#line 3296
#pragma cdir loopcnt=LOOPCNT
#line 3296
#pragma cdir shortloop
#line 3296
    for (i=0; i<ni; i++) {
#line 3296
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3296
     /* test for range errors (not always needed but do it anyway) */
#line 3296
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3296
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3296
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3296
    }
#line 3296
   /* update xpp and tp */
#line 3296
    if (realign) xp = (int *) *xpp;
#line 3296
    xp += ni;
#line 3296
    tp += ni;
#line 3296
    *xpp = (void*)xp;
#line 3296
  }
#line 3296
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3296

#line 3296
#else   /* not SX */
#line 3296
	const char *xp = (const char *) *xpp;
#line 3296
	int status = NC_NOERR;
#line 3296

#line 3296
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3296
	{
#line 3296
		const int lstatus = ncx_get_int_ushort(xp, tp);
#line 3296
		if (status == NC_NOERR) /* report the first encountered error */
#line 3296
			status = lstatus;
#line 3296
	}
#line 3296

#line 3296
	*xpp = (const void *)xp;
#line 3296
	return status;
#line 3296
#endif
#line 3296
}
#line 3296

int
#line 3297
ncx_getn_int_uint(const void **xpp, size_t nelems, uint *tp)
#line 3297
{
#line 3297
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3297

#line 3297
 /* basic algorithm is:
#line 3297
  *   - ensure sane alignment of input data
#line 3297
  *   - copy (conversion happens automatically) input data
#line 3297
  *     to output
#line 3297
  *   - update xpp to point at next unconverted input, and tp to point
#line 3297
  *     at next location for converted output
#line 3297
  */
#line 3297
  long i, j, ni;
#line 3297
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3297
  int *xp;
#line 3297
  int nrange = 0;         /* number of range errors */
#line 3297
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3297
  long cxp = (long) *((char**)xpp);
#line 3297

#line 3297
  realign = (cxp & 7) % SIZEOF_INT;
#line 3297
  /* sjl: manually stripmine so we can limit amount of
#line 3297
   * vector work space reserved to LOOPCNT elements. Also
#line 3297
   * makes vectorisation easy */
#line 3297
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3297
    ni=Min(nelems-j,LOOPCNT);
#line 3297
    if (realign) {
#line 3297
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3297
      xp = tmp;
#line 3297
    } else {
#line 3297
      xp = (int *) *xpp;
#line 3297
    }
#line 3297
   /* copy the next block */
#line 3297
#pragma cdir loopcnt=LOOPCNT
#line 3297
#pragma cdir shortloop
#line 3297
    for (i=0; i<ni; i++) {
#line 3297
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3297
     /* test for range errors (not always needed but do it anyway) */
#line 3297
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3297
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3297
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3297
    }
#line 3297
   /* update xpp and tp */
#line 3297
    if (realign) xp = (int *) *xpp;
#line 3297
    xp += ni;
#line 3297
    tp += ni;
#line 3297
    *xpp = (void*)xp;
#line 3297
  }
#line 3297
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3297

#line 3297
#else   /* not SX */
#line 3297
	const char *xp = (const char *) *xpp;
#line 3297
	int status = NC_NOERR;
#line 3297

#line 3297
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3297
	{
#line 3297
		const int lstatus = ncx_get_int_uint(xp, tp);
#line 3297
		if (status == NC_NOERR) /* report the first encountered error */
#line 3297
			status = lstatus;
#line 3297
	}
#line 3297

#line 3297
	*xpp = (const void *)xp;
#line 3297
	return status;
#line 3297
#endif
#line 3297
}
#line 3297

int
#line 3298
ncx_getn_int_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3298
{
#line 3298
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3298

#line 3298
 /* basic algorithm is:
#line 3298
  *   - ensure sane alignment of input data
#line 3298
  *   - copy (conversion happens automatically) input data
#line 3298
  *     to output
#line 3298
  *   - update xpp to point at next unconverted input, and tp to point
#line 3298
  *     at next location for converted output
#line 3298
  */
#line 3298
  long i, j, ni;
#line 3298
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3298
  int *xp;
#line 3298
  int nrange = 0;         /* number of range errors */
#line 3298
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3298
  long cxp = (long) *((char**)xpp);
#line 3298

#line 3298
  realign = (cxp & 7) % SIZEOF_INT;
#line 3298
  /* sjl: manually stripmine so we can limit amount of
#line 3298
   * vector work space reserved to LOOPCNT elements. Also
#line 3298
   * makes vectorisation easy */
#line 3298
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3298
    ni=Min(nelems-j,LOOPCNT);
#line 3298
    if (realign) {
#line 3298
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT));
#line 3298
      xp = tmp;
#line 3298
    } else {
#line 3298
      xp = (int *) *xpp;
#line 3298
    }
#line 3298
   /* copy the next block */
#line 3298
#pragma cdir loopcnt=LOOPCNT
#line 3298
#pragma cdir shortloop
#line 3298
    for (i=0; i<ni; i++) {
#line 3298
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3298
     /* test for range errors (not always needed but do it anyway) */
#line 3298
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3298
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3298
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3298
    }
#line 3298
   /* update xpp and tp */
#line 3298
    if (realign) xp = (int *) *xpp;
#line 3298
    xp += ni;
#line 3298
    tp += ni;
#line 3298
    *xpp = (void*)xp;
#line 3298
  }
#line 3298
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3298

#line 3298
#else   /* not SX */
#line 3298
	const char *xp = (const char *) *xpp;
#line 3298
	int status = NC_NOERR;
#line 3298

#line 3298
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3298
	{
#line 3298
		const int lstatus = ncx_get_int_ulonglong(xp, tp);
#line 3298
		if (status == NC_NOERR) /* report the first encountered error */
#line 3298
			status = lstatus;
#line 3298
	}
#line 3298

#line 3298
	*xpp = (const void *)xp;
#line 3298
	return status;
#line 3298
#endif
#line 3298
}
#line 3298


#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 3314
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3314
{
#line 3314
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3314

#line 3314
 /* basic algorithm is:
#line 3314
  *   - ensure sane alignment of output data
#line 3314
  *   - copy (conversion happens automatically) input data
#line 3314
  *     to output
#line 3314
  *   - update tp to point at next unconverted input, and xpp to point
#line 3314
  *     at next location for converted output
#line 3314
  */
#line 3314
  long i, j, ni;
#line 3314
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3314
  int *xp;
#line 3314
  int nrange = 0;         /* number of range errors */
#line 3314
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3314
  long cxp = (long) *((char**)xpp);
#line 3314

#line 3314
  realign = (cxp & 7) % SIZEOF_INT;
#line 3314
  /* sjl: manually stripmine so we can limit amount of
#line 3314
   * vector work space reserved to LOOPCNT elements. Also
#line 3314
   * makes vectorisation easy */
#line 3314
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3314
    ni=Min(nelems-j,LOOPCNT);
#line 3314
    if (realign) {
#line 3314
      xp = tmp;
#line 3314
    } else {
#line 3314
      xp = (int *) *xpp;
#line 3314
    }
#line 3314
   /* copy the next block */
#line 3314
#pragma cdir loopcnt=LOOPCNT
#line 3314
#pragma cdir shortloop
#line 3314
    for (i=0; i<ni; i++) {
#line 3314
      /* the normal case: */
#line 3314
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3314
     /* test for range errors (not always needed but do it anyway) */
#line 3314
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3314
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3314
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3314
    }
#line 3314
   /* copy workspace back if necessary */
#line 3314
    if (realign) {
#line 3314
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3314
      xp = (int *) *xpp;
#line 3314
    }
#line 3314
   /* update xpp and tp */
#line 3314
    xp += ni;
#line 3314
    tp += ni;
#line 3314
    *xpp = (void*)xp;
#line 3314
  }
#line 3314
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3314

#line 3314
#else   /* not SX */
#line 3314

#line 3314
	char *xp = (char *) *xpp;
#line 3314
	int status = NC_NOERR;
#line 3314

#line 3314
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3314
	{
#line 3314
		int lstatus = ncx_put_int_int(xp, tp, fillp);
#line 3314
		if (status == NC_NOERR) /* report the first encountered error */
#line 3314
			status = lstatus;
#line 3314
	}
#line 3314

#line 3314
	*xpp = (void *)xp;
#line 3314
	return status;
#line 3314
#endif
#line 3314
}
#line 3314

#endif
int
#line 3316
ncx_putn_int_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3316
{
#line 3316
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3316

#line 3316
 /* basic algorithm is:
#line 3316
  *   - ensure sane alignment of output data
#line 3316
  *   - copy (conversion happens automatically) input data
#line 3316
  *     to output
#line 3316
  *   - update tp to point at next unconverted input, and xpp to point
#line 3316
  *     at next location for converted output
#line 3316
  */
#line 3316
  long i, j, ni;
#line 3316
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3316
  int *xp;
#line 3316
  int nrange = 0;         /* number of range errors */
#line 3316
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3316
  long cxp = (long) *((char**)xpp);
#line 3316

#line 3316
  realign = (cxp & 7) % SIZEOF_INT;
#line 3316
  /* sjl: manually stripmine so we can limit amount of
#line 3316
   * vector work space reserved to LOOPCNT elements. Also
#line 3316
   * makes vectorisation easy */
#line 3316
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3316
    ni=Min(nelems-j,LOOPCNT);
#line 3316
    if (realign) {
#line 3316
      xp = tmp;
#line 3316
    } else {
#line 3316
      xp = (int *) *xpp;
#line 3316
    }
#line 3316
   /* copy the next block */
#line 3316
#pragma cdir loopcnt=LOOPCNT
#line 3316
#pragma cdir shortloop
#line 3316
    for (i=0; i<ni; i++) {
#line 3316
      /* the normal case: */
#line 3316
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3316
     /* test for range errors (not always needed but do it anyway) */
#line 3316
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3316
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3316
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3316
    }
#line 3316
   /* copy workspace back if necessary */
#line 3316
    if (realign) {
#line 3316
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3316
      xp = (int *) *xpp;
#line 3316
    }
#line 3316
   /* update xpp and tp */
#line 3316
    xp += ni;
#line 3316
    tp += ni;
#line 3316
    *xpp = (void*)xp;
#line 3316
  }
#line 3316
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3316

#line 3316
#else   /* not SX */
#line 3316

#line 3316
	char *xp = (char *) *xpp;
#line 3316
	int status = NC_NOERR;
#line 3316

#line 3316
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3316
	{
#line 3316
		int lstatus = ncx_put_int_schar(xp, tp, fillp);
#line 3316
		if (status == NC_NOERR) /* report the first encountered error */
#line 3316
			status = lstatus;
#line 3316
	}
#line 3316

#line 3316
	*xpp = (void *)xp;
#line 3316
	return status;
#line 3316
#endif
#line 3316
}
#line 3316

int
#line 3317
ncx_putn_int_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3317
{
#line 3317
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3317

#line 3317
 /* basic algorithm is:
#line 3317
  *   - ensure sane alignment of output data
#line 3317
  *   - copy (conversion happens automatically) input data
#line 3317
  *     to output
#line 3317
  *   - update tp to point at next unconverted input, and xpp to point
#line 3317
  *     at next location for converted output
#line 3317
  */
#line 3317
  long i, j, ni;
#line 3317
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3317
  int *xp;
#line 3317
  int nrange = 0;         /* number of range errors */
#line 3317
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3317
  long cxp = (long) *((char**)xpp);
#line 3317

#line 3317
  realign = (cxp & 7) % SIZEOF_INT;
#line 3317
  /* sjl: manually stripmine so we can limit amount of
#line 3317
   * vector work space reserved to LOOPCNT elements. Also
#line 3317
   * makes vectorisation easy */
#line 3317
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3317
    ni=Min(nelems-j,LOOPCNT);
#line 3317
    if (realign) {
#line 3317
      xp = tmp;
#line 3317
    } else {
#line 3317
      xp = (int *) *xpp;
#line 3317
    }
#line 3317
   /* copy the next block */
#line 3317
#pragma cdir loopcnt=LOOPCNT
#line 3317
#pragma cdir shortloop
#line 3317
    for (i=0; i<ni; i++) {
#line 3317
      /* the normal case: */
#line 3317
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3317
     /* test for range errors (not always needed but do it anyway) */
#line 3317
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3317
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3317
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3317
    }
#line 3317
   /* copy workspace back if necessary */
#line 3317
    if (realign) {
#line 3317
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3317
      xp = (int *) *xpp;
#line 3317
    }
#line 3317
   /* update xpp and tp */
#line 3317
    xp += ni;
#line 3317
    tp += ni;
#line 3317
    *xpp = (void*)xp;
#line 3317
  }
#line 3317
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3317

#line 3317
#else   /* not SX */
#line 3317

#line 3317
	char *xp = (char *) *xpp;
#line 3317
	int status = NC_NOERR;
#line 3317

#line 3317
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3317
	{
#line 3317
		int lstatus = ncx_put_int_short(xp, tp, fillp);
#line 3317
		if (status == NC_NOERR) /* report the first encountered error */
#line 3317
			status = lstatus;
#line 3317
	}
#line 3317

#line 3317
	*xpp = (void *)xp;
#line 3317
	return status;
#line 3317
#endif
#line 3317
}
#line 3317

int
#line 3318
ncx_putn_int_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3318
{
#line 3318
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3318

#line 3318
 /* basic algorithm is:
#line 3318
  *   - ensure sane alignment of output data
#line 3318
  *   - copy (conversion happens automatically) input data
#line 3318
  *     to output
#line 3318
  *   - update tp to point at next unconverted input, and xpp to point
#line 3318
  *     at next location for converted output
#line 3318
  */
#line 3318
  long i, j, ni;
#line 3318
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3318
  int *xp;
#line 3318
  int nrange = 0;         /* number of range errors */
#line 3318
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3318
  long cxp = (long) *((char**)xpp);
#line 3318

#line 3318
  realign = (cxp & 7) % SIZEOF_INT;
#line 3318
  /* sjl: manually stripmine so we can limit amount of
#line 3318
   * vector work space reserved to LOOPCNT elements. Also
#line 3318
   * makes vectorisation easy */
#line 3318
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3318
    ni=Min(nelems-j,LOOPCNT);
#line 3318
    if (realign) {
#line 3318
      xp = tmp;
#line 3318
    } else {
#line 3318
      xp = (int *) *xpp;
#line 3318
    }
#line 3318
   /* copy the next block */
#line 3318
#pragma cdir loopcnt=LOOPCNT
#line 3318
#pragma cdir shortloop
#line 3318
    for (i=0; i<ni; i++) {
#line 3318
      /* the normal case: */
#line 3318
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3318
     /* test for range errors (not always needed but do it anyway) */
#line 3318
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3318
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3318
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3318
    }
#line 3318
   /* copy workspace back if necessary */
#line 3318
    if (realign) {
#line 3318
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3318
      xp = (int *) *xpp;
#line 3318
    }
#line 3318
   /* update xpp and tp */
#line 3318
    xp += ni;
#line 3318
    tp += ni;
#line 3318
    *xpp = (void*)xp;
#line 3318
  }
#line 3318
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3318

#line 3318
#else   /* not SX */
#line 3318

#line 3318
	char *xp = (char *) *xpp;
#line 3318
	int status = NC_NOERR;
#line 3318

#line 3318
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3318
	{
#line 3318
		int lstatus = ncx_put_int_long(xp, tp, fillp);
#line 3318
		if (status == NC_NOERR) /* report the first encountered error */
#line 3318
			status = lstatus;
#line 3318
	}
#line 3318

#line 3318
	*xpp = (void *)xp;
#line 3318
	return status;
#line 3318
#endif
#line 3318
}
#line 3318

int
#line 3319
ncx_putn_int_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3319
{
#line 3319
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3319

#line 3319
 /* basic algorithm is:
#line 3319
  *   - ensure sane alignment of output data
#line 3319
  *   - copy (conversion happens automatically) input data
#line 3319
  *     to output
#line 3319
  *   - update tp to point at next unconverted input, and xpp to point
#line 3319
  *     at next location for converted output
#line 3319
  */
#line 3319
  long i, j, ni;
#line 3319
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3319
  int *xp;
#line 3319
  double d;               /* special case for ncx_putn_int_float */
#line 3319
  int nrange = 0;         /* number of range errors */
#line 3319
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3319
  long cxp = (long) *((char**)xpp);
#line 3319

#line 3319
  realign = (cxp & 7) % SIZEOF_INT;
#line 3319
  /* sjl: manually stripmine so we can limit amount of
#line 3319
   * vector work space reserved to LOOPCNT elements. Also
#line 3319
   * makes vectorisation easy */
#line 3319
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3319
    ni=Min(nelems-j,LOOPCNT);
#line 3319
    if (realign) {
#line 3319
      xp = tmp;
#line 3319
    } else {
#line 3319
      xp = (int *) *xpp;
#line 3319
    }
#line 3319
   /* copy the next block */
#line 3319
#pragma cdir loopcnt=LOOPCNT
#line 3319
#pragma cdir shortloop
#line 3319
    for (i=0; i<ni; i++) {
#line 3319
      /* for some reason int to float, for putn, requires a special case */
#line 3319
      d = tp[i];
#line 3319
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) d));
#line 3319
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3319
    }
#line 3319
   /* copy workspace back if necessary */
#line 3319
    if (realign) {
#line 3319
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3319
      xp = (int *) *xpp;
#line 3319
    }
#line 3319
   /* update xpp and tp */
#line 3319
    xp += ni;
#line 3319
    tp += ni;
#line 3319
    *xpp = (void*)xp;
#line 3319
  }
#line 3319
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3319

#line 3319
#else   /* not SX */
#line 3319

#line 3319
	char *xp = (char *) *xpp;
#line 3319
	int status = NC_NOERR;
#line 3319

#line 3319
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3319
	{
#line 3319
		int lstatus = ncx_put_int_float(xp, tp, fillp);
#line 3319
		if (status == NC_NOERR) /* report the first encountered error */
#line 3319
			status = lstatus;
#line 3319
	}
#line 3319

#line 3319
	*xpp = (void *)xp;
#line 3319
	return status;
#line 3319
#endif
#line 3319
}
#line 3319

int
#line 3320
ncx_putn_int_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3320
{
#line 3320
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3320

#line 3320
 /* basic algorithm is:
#line 3320
  *   - ensure sane alignment of output data
#line 3320
  *   - copy (conversion happens automatically) input data
#line 3320
  *     to output
#line 3320
  *   - update tp to point at next unconverted input, and xpp to point
#line 3320
  *     at next location for converted output
#line 3320
  */
#line 3320
  long i, j, ni;
#line 3320
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3320
  int *xp;
#line 3320
  int nrange = 0;         /* number of range errors */
#line 3320
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3320
  long cxp = (long) *((char**)xpp);
#line 3320

#line 3320
  realign = (cxp & 7) % SIZEOF_INT;
#line 3320
  /* sjl: manually stripmine so we can limit amount of
#line 3320
   * vector work space reserved to LOOPCNT elements. Also
#line 3320
   * makes vectorisation easy */
#line 3320
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3320
    ni=Min(nelems-j,LOOPCNT);
#line 3320
    if (realign) {
#line 3320
      xp = tmp;
#line 3320
    } else {
#line 3320
      xp = (int *) *xpp;
#line 3320
    }
#line 3320
   /* copy the next block */
#line 3320
#pragma cdir loopcnt=LOOPCNT
#line 3320
#pragma cdir shortloop
#line 3320
    for (i=0; i<ni; i++) {
#line 3320
      /* the normal case: */
#line 3320
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3320
     /* test for range errors (not always needed but do it anyway) */
#line 3320
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3320
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3320
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3320
    }
#line 3320
   /* copy workspace back if necessary */
#line 3320
    if (realign) {
#line 3320
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3320
      xp = (int *) *xpp;
#line 3320
    }
#line 3320
   /* update xpp and tp */
#line 3320
    xp += ni;
#line 3320
    tp += ni;
#line 3320
    *xpp = (void*)xp;
#line 3320
  }
#line 3320
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3320

#line 3320
#else   /* not SX */
#line 3320

#line 3320
	char *xp = (char *) *xpp;
#line 3320
	int status = NC_NOERR;
#line 3320

#line 3320
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3320
	{
#line 3320
		int lstatus = ncx_put_int_double(xp, tp, fillp);
#line 3320
		if (status == NC_NOERR) /* report the first encountered error */
#line 3320
			status = lstatus;
#line 3320
	}
#line 3320

#line 3320
	*xpp = (void *)xp;
#line 3320
	return status;
#line 3320
#endif
#line 3320
}
#line 3320

int
#line 3321
ncx_putn_int_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3321
{
#line 3321
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3321

#line 3321
 /* basic algorithm is:
#line 3321
  *   - ensure sane alignment of output data
#line 3321
  *   - copy (conversion happens automatically) input data
#line 3321
  *     to output
#line 3321
  *   - update tp to point at next unconverted input, and xpp to point
#line 3321
  *     at next location for converted output
#line 3321
  */
#line 3321
  long i, j, ni;
#line 3321
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3321
  int *xp;
#line 3321
  int nrange = 0;         /* number of range errors */
#line 3321
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3321
  long cxp = (long) *((char**)xpp);
#line 3321

#line 3321
  realign = (cxp & 7) % SIZEOF_INT;
#line 3321
  /* sjl: manually stripmine so we can limit amount of
#line 3321
   * vector work space reserved to LOOPCNT elements. Also
#line 3321
   * makes vectorisation easy */
#line 3321
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3321
    ni=Min(nelems-j,LOOPCNT);
#line 3321
    if (realign) {
#line 3321
      xp = tmp;
#line 3321
    } else {
#line 3321
      xp = (int *) *xpp;
#line 3321
    }
#line 3321
   /* copy the next block */
#line 3321
#pragma cdir loopcnt=LOOPCNT
#line 3321
#pragma cdir shortloop
#line 3321
    for (i=0; i<ni; i++) {
#line 3321
      /* the normal case: */
#line 3321
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3321
     /* test for range errors (not always needed but do it anyway) */
#line 3321
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3321
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3321
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 3321
    }
#line 3321
   /* copy workspace back if necessary */
#line 3321
    if (realign) {
#line 3321
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3321
      xp = (int *) *xpp;
#line 3321
    }
#line 3321
   /* update xpp and tp */
#line 3321
    xp += ni;
#line 3321
    tp += ni;
#line 3321
    *xpp = (void*)xp;
#line 3321
  }
#line 3321
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3321

#line 3321
#else   /* not SX */
#line 3321

#line 3321
	char *xp = (char *) *xpp;
#line 3321
	int status = NC_NOERR;
#line 3321

#line 3321
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3321
	{
#line 3321
		int lstatus = ncx_put_int_longlong(xp, tp, fillp);
#line 3321
		if (status == NC_NOERR) /* report the first encountered error */
#line 3321
			status = lstatus;
#line 3321
	}
#line 3321

#line 3321
	*xpp = (void *)xp;
#line 3321
	return status;
#line 3321
#endif
#line 3321
}
#line 3321

int
#line 3322
ncx_putn_int_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3322
{
#line 3322
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3322

#line 3322
 /* basic algorithm is:
#line 3322
  *   - ensure sane alignment of output data
#line 3322
  *   - copy (conversion happens automatically) input data
#line 3322
  *     to output
#line 3322
  *   - update tp to point at next unconverted input, and xpp to point
#line 3322
  *     at next location for converted output
#line 3322
  */
#line 3322
  long i, j, ni;
#line 3322
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3322
  int *xp;
#line 3322
  int nrange = 0;         /* number of range errors */
#line 3322
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3322
  long cxp = (long) *((char**)xpp);
#line 3322

#line 3322
  realign = (cxp & 7) % SIZEOF_INT;
#line 3322
  /* sjl: manually stripmine so we can limit amount of
#line 3322
   * vector work space reserved to LOOPCNT elements. Also
#line 3322
   * makes vectorisation easy */
#line 3322
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3322
    ni=Min(nelems-j,LOOPCNT);
#line 3322
    if (realign) {
#line 3322
      xp = tmp;
#line 3322
    } else {
#line 3322
      xp = (int *) *xpp;
#line 3322
    }
#line 3322
   /* copy the next block */
#line 3322
#pragma cdir loopcnt=LOOPCNT
#line 3322
#pragma cdir shortloop
#line 3322
    for (i=0; i<ni; i++) {
#line 3322
      /* the normal case: */
#line 3322
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3322
     /* test for range errors (not always needed but do it anyway) */
#line 3322
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3322
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3322
      nrange += tp[i] > X_INT_MAX ;
#line 3322
    }
#line 3322
   /* copy workspace back if necessary */
#line 3322
    if (realign) {
#line 3322
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3322
      xp = (int *) *xpp;
#line 3322
    }
#line 3322
   /* update xpp and tp */
#line 3322
    xp += ni;
#line 3322
    tp += ni;
#line 3322
    *xpp = (void*)xp;
#line 3322
  }
#line 3322
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3322

#line 3322
#else   /* not SX */
#line 3322

#line 3322
	char *xp = (char *) *xpp;
#line 3322
	int status = NC_NOERR;
#line 3322

#line 3322
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3322
	{
#line 3322
		int lstatus = ncx_put_int_uchar(xp, tp, fillp);
#line 3322
		if (status == NC_NOERR) /* report the first encountered error */
#line 3322
			status = lstatus;
#line 3322
	}
#line 3322

#line 3322
	*xpp = (void *)xp;
#line 3322
	return status;
#line 3322
#endif
#line 3322
}
#line 3322

int
#line 3323
ncx_putn_int_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3323
{
#line 3323
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3323

#line 3323
 /* basic algorithm is:
#line 3323
  *   - ensure sane alignment of output data
#line 3323
  *   - copy (conversion happens automatically) input data
#line 3323
  *     to output
#line 3323
  *   - update tp to point at next unconverted input, and xpp to point
#line 3323
  *     at next location for converted output
#line 3323
  */
#line 3323
  long i, j, ni;
#line 3323
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3323
  int *xp;
#line 3323
  int nrange = 0;         /* number of range errors */
#line 3323
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3323
  long cxp = (long) *((char**)xpp);
#line 3323

#line 3323
  realign = (cxp & 7) % SIZEOF_INT;
#line 3323
  /* sjl: manually stripmine so we can limit amount of
#line 3323
   * vector work space reserved to LOOPCNT elements. Also
#line 3323
   * makes vectorisation easy */
#line 3323
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3323
    ni=Min(nelems-j,LOOPCNT);
#line 3323
    if (realign) {
#line 3323
      xp = tmp;
#line 3323
    } else {
#line 3323
      xp = (int *) *xpp;
#line 3323
    }
#line 3323
   /* copy the next block */
#line 3323
#pragma cdir loopcnt=LOOPCNT
#line 3323
#pragma cdir shortloop
#line 3323
    for (i=0; i<ni; i++) {
#line 3323
      /* the normal case: */
#line 3323
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3323
     /* test for range errors (not always needed but do it anyway) */
#line 3323
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3323
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3323
      nrange += tp[i] > X_INT_MAX ;
#line 3323
    }
#line 3323
   /* copy workspace back if necessary */
#line 3323
    if (realign) {
#line 3323
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3323
      xp = (int *) *xpp;
#line 3323
    }
#line 3323
   /* update xpp and tp */
#line 3323
    xp += ni;
#line 3323
    tp += ni;
#line 3323
    *xpp = (void*)xp;
#line 3323
  }
#line 3323
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3323

#line 3323
#else   /* not SX */
#line 3323

#line 3323
	char *xp = (char *) *xpp;
#line 3323
	int status = NC_NOERR;
#line 3323

#line 3323
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3323
	{
#line 3323
		int lstatus = ncx_put_int_ushort(xp, tp, fillp);
#line 3323
		if (status == NC_NOERR) /* report the first encountered error */
#line 3323
			status = lstatus;
#line 3323
	}
#line 3323

#line 3323
	*xpp = (void *)xp;
#line 3323
	return status;
#line 3323
#endif
#line 3323
}
#line 3323

int
#line 3324
ncx_putn_int_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3324
{
#line 3324
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3324

#line 3324
 /* basic algorithm is:
#line 3324
  *   - ensure sane alignment of output data
#line 3324
  *   - copy (conversion happens automatically) input data
#line 3324
  *     to output
#line 3324
  *   - update tp to point at next unconverted input, and xpp to point
#line 3324
  *     at next location for converted output
#line 3324
  */
#line 3324
  long i, j, ni;
#line 3324
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3324
  int *xp;
#line 3324
  int nrange = 0;         /* number of range errors */
#line 3324
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3324
  long cxp = (long) *((char**)xpp);
#line 3324

#line 3324
  realign = (cxp & 7) % SIZEOF_INT;
#line 3324
  /* sjl: manually stripmine so we can limit amount of
#line 3324
   * vector work space reserved to LOOPCNT elements. Also
#line 3324
   * makes vectorisation easy */
#line 3324
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3324
    ni=Min(nelems-j,LOOPCNT);
#line 3324
    if (realign) {
#line 3324
      xp = tmp;
#line 3324
    } else {
#line 3324
      xp = (int *) *xpp;
#line 3324
    }
#line 3324
   /* copy the next block */
#line 3324
#pragma cdir loopcnt=LOOPCNT
#line 3324
#pragma cdir shortloop
#line 3324
    for (i=0; i<ni; i++) {
#line 3324
      /* the normal case: */
#line 3324
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3324
     /* test for range errors (not always needed but do it anyway) */
#line 3324
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3324
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3324
      nrange += tp[i] > X_INT_MAX ;
#line 3324
    }
#line 3324
   /* copy workspace back if necessary */
#line 3324
    if (realign) {
#line 3324
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3324
      xp = (int *) *xpp;
#line 3324
    }
#line 3324
   /* update xpp and tp */
#line 3324
    xp += ni;
#line 3324
    tp += ni;
#line 3324
    *xpp = (void*)xp;
#line 3324
  }
#line 3324
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3324

#line 3324
#else   /* not SX */
#line 3324

#line 3324
	char *xp = (char *) *xpp;
#line 3324
	int status = NC_NOERR;
#line 3324

#line 3324
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3324
	{
#line 3324
		int lstatus = ncx_put_int_uint(xp, tp, fillp);
#line 3324
		if (status == NC_NOERR) /* report the first encountered error */
#line 3324
			status = lstatus;
#line 3324
	}
#line 3324

#line 3324
	*xpp = (void *)xp;
#line 3324
	return status;
#line 3324
#endif
#line 3324
}
#line 3324

int
#line 3325
ncx_putn_int_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3325
{
#line 3325
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT == SIZEOF_INT
#line 3325

#line 3325
 /* basic algorithm is:
#line 3325
  *   - ensure sane alignment of output data
#line 3325
  *   - copy (conversion happens automatically) input data
#line 3325
  *     to output
#line 3325
  *   - update tp to point at next unconverted input, and xpp to point
#line 3325
  *     at next location for converted output
#line 3325
  */
#line 3325
  long i, j, ni;
#line 3325
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 3325
  int *xp;
#line 3325
  int nrange = 0;         /* number of range errors */
#line 3325
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3325
  long cxp = (long) *((char**)xpp);
#line 3325

#line 3325
  realign = (cxp & 7) % SIZEOF_INT;
#line 3325
  /* sjl: manually stripmine so we can limit amount of
#line 3325
   * vector work space reserved to LOOPCNT elements. Also
#line 3325
   * makes vectorisation easy */
#line 3325
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3325
    ni=Min(nelems-j,LOOPCNT);
#line 3325
    if (realign) {
#line 3325
      xp = tmp;
#line 3325
    } else {
#line 3325
      xp = (int *) *xpp;
#line 3325
    }
#line 3325
   /* copy the next block */
#line 3325
#pragma cdir loopcnt=LOOPCNT
#line 3325
#pragma cdir shortloop
#line 3325
    for (i=0; i<ni; i++) {
#line 3325
      /* the normal case: */
#line 3325
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 3325
     /* test for range errors (not always needed but do it anyway) */
#line 3325
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3325
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3325
      nrange += tp[i] > X_INT_MAX ;
#line 3325
    }
#line 3325
   /* copy workspace back if necessary */
#line 3325
    if (realign) {
#line 3325
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT);
#line 3325
      xp = (int *) *xpp;
#line 3325
    }
#line 3325
   /* update xpp and tp */
#line 3325
    xp += ni;
#line 3325
    tp += ni;
#line 3325
    *xpp = (void*)xp;
#line 3325
  }
#line 3325
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3325

#line 3325
#else   /* not SX */
#line 3325

#line 3325
	char *xp = (char *) *xpp;
#line 3325
	int status = NC_NOERR;
#line 3325

#line 3325
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 3325
	{
#line 3325
		int lstatus = ncx_put_int_ulonglong(xp, tp, fillp);
#line 3325
		if (status == NC_NOERR) /* report the first encountered error */
#line 3325
			status = lstatus;
#line 3325
	}
#line 3325

#line 3325
	*xpp = (void *)xp;
#line 3325
	return status;
#line 3325
#endif
#line 3325
}
#line 3325


/* uint ----------------------------------------------------------------------*/

#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_getn_uint_uint(const void **xpp, size_t nelems, unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UINT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3343
ncx_getn_uint_uint(const void **xpp, size_t nelems, uint *tp)
#line 3343
{
#line 3343
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3343

#line 3343
 /* basic algorithm is:
#line 3343
  *   - ensure sane alignment of input data
#line 3343
  *   - copy (conversion happens automatically) input data
#line 3343
  *     to output
#line 3343
  *   - update xpp to point at next unconverted input, and tp to point
#line 3343
  *     at next location for converted output
#line 3343
  */
#line 3343
  long i, j, ni;
#line 3343
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3343
  uint *xp;
#line 3343
  int nrange = 0;         /* number of range errors */
#line 3343
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3343
  long cxp = (long) *((char**)xpp);
#line 3343

#line 3343
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3343
  /* sjl: manually stripmine so we can limit amount of
#line 3343
   * vector work space reserved to LOOPCNT elements. Also
#line 3343
   * makes vectorisation easy */
#line 3343
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3343
    ni=Min(nelems-j,LOOPCNT);
#line 3343
    if (realign) {
#line 3343
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3343
      xp = tmp;
#line 3343
    } else {
#line 3343
      xp = (uint *) *xpp;
#line 3343
    }
#line 3343
   /* copy the next block */
#line 3343
#pragma cdir loopcnt=LOOPCNT
#line 3343
#pragma cdir shortloop
#line 3343
    for (i=0; i<ni; i++) {
#line 3343
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3343
     /* test for range errors (not always needed but do it anyway) */
#line 3343
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3343
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3343
      nrange += xp[i] > UINT_MAX ;
#line 3343
    }
#line 3343
   /* update xpp and tp */
#line 3343
    if (realign) xp = (uint *) *xpp;
#line 3343
    xp += ni;
#line 3343
    tp += ni;
#line 3343
    *xpp = (void*)xp;
#line 3343
  }
#line 3343
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3343

#line 3343
#else   /* not SX */
#line 3343
	const char *xp = (const char *) *xpp;
#line 3343
	int status = NC_NOERR;
#line 3343

#line 3343
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3343
	{
#line 3343
		const int lstatus = ncx_get_uint_uint(xp, tp);
#line 3343
		if (status == NC_NOERR) /* report the first encountered error */
#line 3343
			status = lstatus;
#line 3343
	}
#line 3343

#line 3343
	*xpp = (const void *)xp;
#line 3343
	return status;
#line 3343
#endif
#line 3343
}
#line 3343

#endif
int
#line 3345
ncx_getn_uint_schar(const void **xpp, size_t nelems, schar *tp)
#line 3345
{
#line 3345
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3345

#line 3345
 /* basic algorithm is:
#line 3345
  *   - ensure sane alignment of input data
#line 3345
  *   - copy (conversion happens automatically) input data
#line 3345
  *     to output
#line 3345
  *   - update xpp to point at next unconverted input, and tp to point
#line 3345
  *     at next location for converted output
#line 3345
  */
#line 3345
  long i, j, ni;
#line 3345
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3345
  uint *xp;
#line 3345
  int nrange = 0;         /* number of range errors */
#line 3345
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3345
  long cxp = (long) *((char**)xpp);
#line 3345

#line 3345
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3345
  /* sjl: manually stripmine so we can limit amount of
#line 3345
   * vector work space reserved to LOOPCNT elements. Also
#line 3345
   * makes vectorisation easy */
#line 3345
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3345
    ni=Min(nelems-j,LOOPCNT);
#line 3345
    if (realign) {
#line 3345
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3345
      xp = tmp;
#line 3345
    } else {
#line 3345
      xp = (uint *) *xpp;
#line 3345
    }
#line 3345
   /* copy the next block */
#line 3345
#pragma cdir loopcnt=LOOPCNT
#line 3345
#pragma cdir shortloop
#line 3345
    for (i=0; i<ni; i++) {
#line 3345
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3345
     /* test for range errors (not always needed but do it anyway) */
#line 3345
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3345
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3345
      nrange += xp[i] > SCHAR_MAX ;
#line 3345
    }
#line 3345
   /* update xpp and tp */
#line 3345
    if (realign) xp = (uint *) *xpp;
#line 3345
    xp += ni;
#line 3345
    tp += ni;
#line 3345
    *xpp = (void*)xp;
#line 3345
  }
#line 3345
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3345

#line 3345
#else   /* not SX */
#line 3345
	const char *xp = (const char *) *xpp;
#line 3345
	int status = NC_NOERR;
#line 3345

#line 3345
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3345
	{
#line 3345
		const int lstatus = ncx_get_uint_schar(xp, tp);
#line 3345
		if (status == NC_NOERR) /* report the first encountered error */
#line 3345
			status = lstatus;
#line 3345
	}
#line 3345

#line 3345
	*xpp = (const void *)xp;
#line 3345
	return status;
#line 3345
#endif
#line 3345
}
#line 3345

int
#line 3346
ncx_getn_uint_short(const void **xpp, size_t nelems, short *tp)
#line 3346
{
#line 3346
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3346

#line 3346
 /* basic algorithm is:
#line 3346
  *   - ensure sane alignment of input data
#line 3346
  *   - copy (conversion happens automatically) input data
#line 3346
  *     to output
#line 3346
  *   - update xpp to point at next unconverted input, and tp to point
#line 3346
  *     at next location for converted output
#line 3346
  */
#line 3346
  long i, j, ni;
#line 3346
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3346
  uint *xp;
#line 3346
  int nrange = 0;         /* number of range errors */
#line 3346
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3346
  long cxp = (long) *((char**)xpp);
#line 3346

#line 3346
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3346
  /* sjl: manually stripmine so we can limit amount of
#line 3346
   * vector work space reserved to LOOPCNT elements. Also
#line 3346
   * makes vectorisation easy */
#line 3346
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3346
    ni=Min(nelems-j,LOOPCNT);
#line 3346
    if (realign) {
#line 3346
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3346
      xp = tmp;
#line 3346
    } else {
#line 3346
      xp = (uint *) *xpp;
#line 3346
    }
#line 3346
   /* copy the next block */
#line 3346
#pragma cdir loopcnt=LOOPCNT
#line 3346
#pragma cdir shortloop
#line 3346
    for (i=0; i<ni; i++) {
#line 3346
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3346
     /* test for range errors (not always needed but do it anyway) */
#line 3346
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3346
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3346
      nrange += xp[i] > SHORT_MAX ;
#line 3346
    }
#line 3346
   /* update xpp and tp */
#line 3346
    if (realign) xp = (uint *) *xpp;
#line 3346
    xp += ni;
#line 3346
    tp += ni;
#line 3346
    *xpp = (void*)xp;
#line 3346
  }
#line 3346
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3346

#line 3346
#else   /* not SX */
#line 3346
	const char *xp = (const char *) *xpp;
#line 3346
	int status = NC_NOERR;
#line 3346

#line 3346
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3346
	{
#line 3346
		const int lstatus = ncx_get_uint_short(xp, tp);
#line 3346
		if (status == NC_NOERR) /* report the first encountered error */
#line 3346
			status = lstatus;
#line 3346
	}
#line 3346

#line 3346
	*xpp = (const void *)xp;
#line 3346
	return status;
#line 3346
#endif
#line 3346
}
#line 3346

int
#line 3347
ncx_getn_uint_int(const void **xpp, size_t nelems, int *tp)
#line 3347
{
#line 3347
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3347

#line 3347
 /* basic algorithm is:
#line 3347
  *   - ensure sane alignment of input data
#line 3347
  *   - copy (conversion happens automatically) input data
#line 3347
  *     to output
#line 3347
  *   - update xpp to point at next unconverted input, and tp to point
#line 3347
  *     at next location for converted output
#line 3347
  */
#line 3347
  long i, j, ni;
#line 3347
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3347
  uint *xp;
#line 3347
  int nrange = 0;         /* number of range errors */
#line 3347
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3347
  long cxp = (long) *((char**)xpp);
#line 3347

#line 3347
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3347
  /* sjl: manually stripmine so we can limit amount of
#line 3347
   * vector work space reserved to LOOPCNT elements. Also
#line 3347
   * makes vectorisation easy */
#line 3347
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3347
    ni=Min(nelems-j,LOOPCNT);
#line 3347
    if (realign) {
#line 3347
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3347
      xp = tmp;
#line 3347
    } else {
#line 3347
      xp = (uint *) *xpp;
#line 3347
    }
#line 3347
   /* copy the next block */
#line 3347
#pragma cdir loopcnt=LOOPCNT
#line 3347
#pragma cdir shortloop
#line 3347
    for (i=0; i<ni; i++) {
#line 3347
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3347
     /* test for range errors (not always needed but do it anyway) */
#line 3347
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3347
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3347
      nrange += xp[i] > INT_MAX ;
#line 3347
    }
#line 3347
   /* update xpp and tp */
#line 3347
    if (realign) xp = (uint *) *xpp;
#line 3347
    xp += ni;
#line 3347
    tp += ni;
#line 3347
    *xpp = (void*)xp;
#line 3347
  }
#line 3347
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3347

#line 3347
#else   /* not SX */
#line 3347
	const char *xp = (const char *) *xpp;
#line 3347
	int status = NC_NOERR;
#line 3347

#line 3347
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3347
	{
#line 3347
		const int lstatus = ncx_get_uint_int(xp, tp);
#line 3347
		if (status == NC_NOERR) /* report the first encountered error */
#line 3347
			status = lstatus;
#line 3347
	}
#line 3347

#line 3347
	*xpp = (const void *)xp;
#line 3347
	return status;
#line 3347
#endif
#line 3347
}
#line 3347

int
#line 3348
ncx_getn_uint_long(const void **xpp, size_t nelems, long *tp)
#line 3348
{
#line 3348
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3348

#line 3348
 /* basic algorithm is:
#line 3348
  *   - ensure sane alignment of input data
#line 3348
  *   - copy (conversion happens automatically) input data
#line 3348
  *     to output
#line 3348
  *   - update xpp to point at next unconverted input, and tp to point
#line 3348
  *     at next location for converted output
#line 3348
  */
#line 3348
  long i, j, ni;
#line 3348
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3348
  uint *xp;
#line 3348
  int nrange = 0;         /* number of range errors */
#line 3348
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3348
  long cxp = (long) *((char**)xpp);
#line 3348

#line 3348
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3348
  /* sjl: manually stripmine so we can limit amount of
#line 3348
   * vector work space reserved to LOOPCNT elements. Also
#line 3348
   * makes vectorisation easy */
#line 3348
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3348
    ni=Min(nelems-j,LOOPCNT);
#line 3348
    if (realign) {
#line 3348
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3348
      xp = tmp;
#line 3348
    } else {
#line 3348
      xp = (uint *) *xpp;
#line 3348
    }
#line 3348
   /* copy the next block */
#line 3348
#pragma cdir loopcnt=LOOPCNT
#line 3348
#pragma cdir shortloop
#line 3348
    for (i=0; i<ni; i++) {
#line 3348
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3348
     /* test for range errors (not always needed but do it anyway) */
#line 3348
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3348
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3348
      nrange += xp[i] > LONG_MAX ;
#line 3348
    }
#line 3348
   /* update xpp and tp */
#line 3348
    if (realign) xp = (uint *) *xpp;
#line 3348
    xp += ni;
#line 3348
    tp += ni;
#line 3348
    *xpp = (void*)xp;
#line 3348
  }
#line 3348
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3348

#line 3348
#else   /* not SX */
#line 3348
	const char *xp = (const char *) *xpp;
#line 3348
	int status = NC_NOERR;
#line 3348

#line 3348
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3348
	{
#line 3348
		const int lstatus = ncx_get_uint_long(xp, tp);
#line 3348
		if (status == NC_NOERR) /* report the first encountered error */
#line 3348
			status = lstatus;
#line 3348
	}
#line 3348

#line 3348
	*xpp = (const void *)xp;
#line 3348
	return status;
#line 3348
#endif
#line 3348
}
#line 3348

int
#line 3349
ncx_getn_uint_float(const void **xpp, size_t nelems, float *tp)
#line 3349
{
#line 3349
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3349

#line 3349
 /* basic algorithm is:
#line 3349
  *   - ensure sane alignment of input data
#line 3349
  *   - copy (conversion happens automatically) input data
#line 3349
  *     to output
#line 3349
  *   - update xpp to point at next unconverted input, and tp to point
#line 3349
  *     at next location for converted output
#line 3349
  */
#line 3349
  long i, j, ni;
#line 3349
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3349
  uint *xp;
#line 3349
  int nrange = 0;         /* number of range errors */
#line 3349
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3349
  long cxp = (long) *((char**)xpp);
#line 3349

#line 3349
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3349
  /* sjl: manually stripmine so we can limit amount of
#line 3349
   * vector work space reserved to LOOPCNT elements. Also
#line 3349
   * makes vectorisation easy */
#line 3349
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3349
    ni=Min(nelems-j,LOOPCNT);
#line 3349
    if (realign) {
#line 3349
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3349
      xp = tmp;
#line 3349
    } else {
#line 3349
      xp = (uint *) *xpp;
#line 3349
    }
#line 3349
   /* copy the next block */
#line 3349
#pragma cdir loopcnt=LOOPCNT
#line 3349
#pragma cdir shortloop
#line 3349
    for (i=0; i<ni; i++) {
#line 3349
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3349
     /* test for range errors (not always needed but do it anyway) */
#line 3349
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3349
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3349
      nrange += xp[i] > FLOAT_MAX ;
#line 3349
    }
#line 3349
   /* update xpp and tp */
#line 3349
    if (realign) xp = (uint *) *xpp;
#line 3349
    xp += ni;
#line 3349
    tp += ni;
#line 3349
    *xpp = (void*)xp;
#line 3349
  }
#line 3349
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3349

#line 3349
#else   /* not SX */
#line 3349
	const char *xp = (const char *) *xpp;
#line 3349
	int status = NC_NOERR;
#line 3349

#line 3349
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3349
	{
#line 3349
		const int lstatus = ncx_get_uint_float(xp, tp);
#line 3349
		if (status == NC_NOERR) /* report the first encountered error */
#line 3349
			status = lstatus;
#line 3349
	}
#line 3349

#line 3349
	*xpp = (const void *)xp;
#line 3349
	return status;
#line 3349
#endif
#line 3349
}
#line 3349

int
#line 3350
ncx_getn_uint_double(const void **xpp, size_t nelems, double *tp)
#line 3350
{
#line 3350
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3350

#line 3350
 /* basic algorithm is:
#line 3350
  *   - ensure sane alignment of input data
#line 3350
  *   - copy (conversion happens automatically) input data
#line 3350
  *     to output
#line 3350
  *   - update xpp to point at next unconverted input, and tp to point
#line 3350
  *     at next location for converted output
#line 3350
  */
#line 3350
  long i, j, ni;
#line 3350
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3350
  uint *xp;
#line 3350
  int nrange = 0;         /* number of range errors */
#line 3350
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3350
  long cxp = (long) *((char**)xpp);
#line 3350

#line 3350
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3350
  /* sjl: manually stripmine so we can limit amount of
#line 3350
   * vector work space reserved to LOOPCNT elements. Also
#line 3350
   * makes vectorisation easy */
#line 3350
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3350
    ni=Min(nelems-j,LOOPCNT);
#line 3350
    if (realign) {
#line 3350
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3350
      xp = tmp;
#line 3350
    } else {
#line 3350
      xp = (uint *) *xpp;
#line 3350
    }
#line 3350
   /* copy the next block */
#line 3350
#pragma cdir loopcnt=LOOPCNT
#line 3350
#pragma cdir shortloop
#line 3350
    for (i=0; i<ni; i++) {
#line 3350
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3350
     /* test for range errors (not always needed but do it anyway) */
#line 3350
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3350
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3350
      nrange += xp[i] > DOUBLE_MAX ;
#line 3350
    }
#line 3350
   /* update xpp and tp */
#line 3350
    if (realign) xp = (uint *) *xpp;
#line 3350
    xp += ni;
#line 3350
    tp += ni;
#line 3350
    *xpp = (void*)xp;
#line 3350
  }
#line 3350
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3350

#line 3350
#else   /* not SX */
#line 3350
	const char *xp = (const char *) *xpp;
#line 3350
	int status = NC_NOERR;
#line 3350

#line 3350
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3350
	{
#line 3350
		const int lstatus = ncx_get_uint_double(xp, tp);
#line 3350
		if (status == NC_NOERR) /* report the first encountered error */
#line 3350
			status = lstatus;
#line 3350
	}
#line 3350

#line 3350
	*xpp = (const void *)xp;
#line 3350
	return status;
#line 3350
#endif
#line 3350
}
#line 3350

int
#line 3351
ncx_getn_uint_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3351
{
#line 3351
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3351

#line 3351
 /* basic algorithm is:
#line 3351
  *   - ensure sane alignment of input data
#line 3351
  *   - copy (conversion happens automatically) input data
#line 3351
  *     to output
#line 3351
  *   - update xpp to point at next unconverted input, and tp to point
#line 3351
  *     at next location for converted output
#line 3351
  */
#line 3351
  long i, j, ni;
#line 3351
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3351
  uint *xp;
#line 3351
  int nrange = 0;         /* number of range errors */
#line 3351
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3351
  long cxp = (long) *((char**)xpp);
#line 3351

#line 3351
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3351
  /* sjl: manually stripmine so we can limit amount of
#line 3351
   * vector work space reserved to LOOPCNT elements. Also
#line 3351
   * makes vectorisation easy */
#line 3351
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3351
    ni=Min(nelems-j,LOOPCNT);
#line 3351
    if (realign) {
#line 3351
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3351
      xp = tmp;
#line 3351
    } else {
#line 3351
      xp = (uint *) *xpp;
#line 3351
    }
#line 3351
   /* copy the next block */
#line 3351
#pragma cdir loopcnt=LOOPCNT
#line 3351
#pragma cdir shortloop
#line 3351
    for (i=0; i<ni; i++) {
#line 3351
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3351
     /* test for range errors (not always needed but do it anyway) */
#line 3351
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3351
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3351
      nrange += xp[i] > LONGLONG_MAX ;
#line 3351
    }
#line 3351
   /* update xpp and tp */
#line 3351
    if (realign) xp = (uint *) *xpp;
#line 3351
    xp += ni;
#line 3351
    tp += ni;
#line 3351
    *xpp = (void*)xp;
#line 3351
  }
#line 3351
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3351

#line 3351
#else   /* not SX */
#line 3351
	const char *xp = (const char *) *xpp;
#line 3351
	int status = NC_NOERR;
#line 3351

#line 3351
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3351
	{
#line 3351
		const int lstatus = ncx_get_uint_longlong(xp, tp);
#line 3351
		if (status == NC_NOERR) /* report the first encountered error */
#line 3351
			status = lstatus;
#line 3351
	}
#line 3351

#line 3351
	*xpp = (const void *)xp;
#line 3351
	return status;
#line 3351
#endif
#line 3351
}
#line 3351

int
#line 3352
ncx_getn_uint_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3352
{
#line 3352
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3352

#line 3352
 /* basic algorithm is:
#line 3352
  *   - ensure sane alignment of input data
#line 3352
  *   - copy (conversion happens automatically) input data
#line 3352
  *     to output
#line 3352
  *   - update xpp to point at next unconverted input, and tp to point
#line 3352
  *     at next location for converted output
#line 3352
  */
#line 3352
  long i, j, ni;
#line 3352
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3352
  uint *xp;
#line 3352
  int nrange = 0;         /* number of range errors */
#line 3352
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3352
  long cxp = (long) *((char**)xpp);
#line 3352

#line 3352
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3352
  /* sjl: manually stripmine so we can limit amount of
#line 3352
   * vector work space reserved to LOOPCNT elements. Also
#line 3352
   * makes vectorisation easy */
#line 3352
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3352
    ni=Min(nelems-j,LOOPCNT);
#line 3352
    if (realign) {
#line 3352
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3352
      xp = tmp;
#line 3352
    } else {
#line 3352
      xp = (uint *) *xpp;
#line 3352
    }
#line 3352
   /* copy the next block */
#line 3352
#pragma cdir loopcnt=LOOPCNT
#line 3352
#pragma cdir shortloop
#line 3352
    for (i=0; i<ni; i++) {
#line 3352
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3352
     /* test for range errors (not always needed but do it anyway) */
#line 3352
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3352
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3352
      nrange += xp[i] > UCHAR_MAX ;
#line 3352
    }
#line 3352
   /* update xpp and tp */
#line 3352
    if (realign) xp = (uint *) *xpp;
#line 3352
    xp += ni;
#line 3352
    tp += ni;
#line 3352
    *xpp = (void*)xp;
#line 3352
  }
#line 3352
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3352

#line 3352
#else   /* not SX */
#line 3352
	const char *xp = (const char *) *xpp;
#line 3352
	int status = NC_NOERR;
#line 3352

#line 3352
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3352
	{
#line 3352
		const int lstatus = ncx_get_uint_uchar(xp, tp);
#line 3352
		if (status == NC_NOERR) /* report the first encountered error */
#line 3352
			status = lstatus;
#line 3352
	}
#line 3352

#line 3352
	*xpp = (const void *)xp;
#line 3352
	return status;
#line 3352
#endif
#line 3352
}
#line 3352

int
#line 3353
ncx_getn_uint_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3353
{
#line 3353
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3353

#line 3353
 /* basic algorithm is:
#line 3353
  *   - ensure sane alignment of input data
#line 3353
  *   - copy (conversion happens automatically) input data
#line 3353
  *     to output
#line 3353
  *   - update xpp to point at next unconverted input, and tp to point
#line 3353
  *     at next location for converted output
#line 3353
  */
#line 3353
  long i, j, ni;
#line 3353
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3353
  uint *xp;
#line 3353
  int nrange = 0;         /* number of range errors */
#line 3353
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3353
  long cxp = (long) *((char**)xpp);
#line 3353

#line 3353
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3353
  /* sjl: manually stripmine so we can limit amount of
#line 3353
   * vector work space reserved to LOOPCNT elements. Also
#line 3353
   * makes vectorisation easy */
#line 3353
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3353
    ni=Min(nelems-j,LOOPCNT);
#line 3353
    if (realign) {
#line 3353
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3353
      xp = tmp;
#line 3353
    } else {
#line 3353
      xp = (uint *) *xpp;
#line 3353
    }
#line 3353
   /* copy the next block */
#line 3353
#pragma cdir loopcnt=LOOPCNT
#line 3353
#pragma cdir shortloop
#line 3353
    for (i=0; i<ni; i++) {
#line 3353
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3353
     /* test for range errors (not always needed but do it anyway) */
#line 3353
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3353
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3353
      nrange += xp[i] > USHORT_MAX ;
#line 3353
    }
#line 3353
   /* update xpp and tp */
#line 3353
    if (realign) xp = (uint *) *xpp;
#line 3353
    xp += ni;
#line 3353
    tp += ni;
#line 3353
    *xpp = (void*)xp;
#line 3353
  }
#line 3353
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3353

#line 3353
#else   /* not SX */
#line 3353
	const char *xp = (const char *) *xpp;
#line 3353
	int status = NC_NOERR;
#line 3353

#line 3353
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3353
	{
#line 3353
		const int lstatus = ncx_get_uint_ushort(xp, tp);
#line 3353
		if (status == NC_NOERR) /* report the first encountered error */
#line 3353
			status = lstatus;
#line 3353
	}
#line 3353

#line 3353
	*xpp = (const void *)xp;
#line 3353
	return status;
#line 3353
#endif
#line 3353
}
#line 3353

int
#line 3354
ncx_getn_uint_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3354
{
#line 3354
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3354

#line 3354
 /* basic algorithm is:
#line 3354
  *   - ensure sane alignment of input data
#line 3354
  *   - copy (conversion happens automatically) input data
#line 3354
  *     to output
#line 3354
  *   - update xpp to point at next unconverted input, and tp to point
#line 3354
  *     at next location for converted output
#line 3354
  */
#line 3354
  long i, j, ni;
#line 3354
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3354
  uint *xp;
#line 3354
  int nrange = 0;         /* number of range errors */
#line 3354
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3354
  long cxp = (long) *((char**)xpp);
#line 3354

#line 3354
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3354
  /* sjl: manually stripmine so we can limit amount of
#line 3354
   * vector work space reserved to LOOPCNT elements. Also
#line 3354
   * makes vectorisation easy */
#line 3354
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3354
    ni=Min(nelems-j,LOOPCNT);
#line 3354
    if (realign) {
#line 3354
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT));
#line 3354
      xp = tmp;
#line 3354
    } else {
#line 3354
      xp = (uint *) *xpp;
#line 3354
    }
#line 3354
   /* copy the next block */
#line 3354
#pragma cdir loopcnt=LOOPCNT
#line 3354
#pragma cdir shortloop
#line 3354
    for (i=0; i<ni; i++) {
#line 3354
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3354
     /* test for range errors (not always needed but do it anyway) */
#line 3354
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3354
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3354
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3354
    }
#line 3354
   /* update xpp and tp */
#line 3354
    if (realign) xp = (uint *) *xpp;
#line 3354
    xp += ni;
#line 3354
    tp += ni;
#line 3354
    *xpp = (void*)xp;
#line 3354
  }
#line 3354
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3354

#line 3354
#else   /* not SX */
#line 3354
	const char *xp = (const char *) *xpp;
#line 3354
	int status = NC_NOERR;
#line 3354

#line 3354
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3354
	{
#line 3354
		const int lstatus = ncx_get_uint_ulonglong(xp, tp);
#line 3354
		if (status == NC_NOERR) /* report the first encountered error */
#line 3354
			status = lstatus;
#line 3354
	}
#line 3354

#line 3354
	*xpp = (const void *)xp;
#line 3354
	return status;
#line 3354
#endif
#line 3354
}
#line 3354


#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_putn_uint_uint(void **xpp, size_t nelems, const unsigned int *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 3370
ncx_putn_uint_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3370
{
#line 3370
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3370

#line 3370
 /* basic algorithm is:
#line 3370
  *   - ensure sane alignment of output data
#line 3370
  *   - copy (conversion happens automatically) input data
#line 3370
  *     to output
#line 3370
  *   - update tp to point at next unconverted input, and xpp to point
#line 3370
  *     at next location for converted output
#line 3370
  */
#line 3370
  long i, j, ni;
#line 3370
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3370
  uint *xp;
#line 3370
  int nrange = 0;         /* number of range errors */
#line 3370
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3370
  long cxp = (long) *((char**)xpp);
#line 3370

#line 3370
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3370
  /* sjl: manually stripmine so we can limit amount of
#line 3370
   * vector work space reserved to LOOPCNT elements. Also
#line 3370
   * makes vectorisation easy */
#line 3370
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3370
    ni=Min(nelems-j,LOOPCNT);
#line 3370
    if (realign) {
#line 3370
      xp = tmp;
#line 3370
    } else {
#line 3370
      xp = (uint *) *xpp;
#line 3370
    }
#line 3370
   /* copy the next block */
#line 3370
#pragma cdir loopcnt=LOOPCNT
#line 3370
#pragma cdir shortloop
#line 3370
    for (i=0; i<ni; i++) {
#line 3370
      /* the normal case: */
#line 3370
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3370
     /* test for range errors (not always needed but do it anyway) */
#line 3370
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3370
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3370
      nrange += tp[i] > X_UINT_MAX ;
#line 3370
    }
#line 3370
   /* copy workspace back if necessary */
#line 3370
    if (realign) {
#line 3370
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3370
      xp = (uint *) *xpp;
#line 3370
    }
#line 3370
   /* update xpp and tp */
#line 3370
    xp += ni;
#line 3370
    tp += ni;
#line 3370
    *xpp = (void*)xp;
#line 3370
  }
#line 3370
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3370

#line 3370
#else   /* not SX */
#line 3370

#line 3370
	char *xp = (char *) *xpp;
#line 3370
	int status = NC_NOERR;
#line 3370

#line 3370
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3370
	{
#line 3370
		int lstatus = ncx_put_uint_uint(xp, tp, fillp);
#line 3370
		if (status == NC_NOERR) /* report the first encountered error */
#line 3370
			status = lstatus;
#line 3370
	}
#line 3370

#line 3370
	*xpp = (void *)xp;
#line 3370
	return status;
#line 3370
#endif
#line 3370
}
#line 3370

#endif
int
#line 3372
ncx_putn_uint_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3372
{
#line 3372
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3372

#line 3372
 /* basic algorithm is:
#line 3372
  *   - ensure sane alignment of output data
#line 3372
  *   - copy (conversion happens automatically) input data
#line 3372
  *     to output
#line 3372
  *   - update tp to point at next unconverted input, and xpp to point
#line 3372
  *     at next location for converted output
#line 3372
  */
#line 3372
  long i, j, ni;
#line 3372
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3372
  uint *xp;
#line 3372
  int nrange = 0;         /* number of range errors */
#line 3372
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3372
  long cxp = (long) *((char**)xpp);
#line 3372

#line 3372
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3372
  /* sjl: manually stripmine so we can limit amount of
#line 3372
   * vector work space reserved to LOOPCNT elements. Also
#line 3372
   * makes vectorisation easy */
#line 3372
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3372
    ni=Min(nelems-j,LOOPCNT);
#line 3372
    if (realign) {
#line 3372
      xp = tmp;
#line 3372
    } else {
#line 3372
      xp = (uint *) *xpp;
#line 3372
    }
#line 3372
   /* copy the next block */
#line 3372
#pragma cdir loopcnt=LOOPCNT
#line 3372
#pragma cdir shortloop
#line 3372
    for (i=0; i<ni; i++) {
#line 3372
      /* the normal case: */
#line 3372
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3372
     /* test for range errors (not always needed but do it anyway) */
#line 3372
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3372
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3372
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3372
    }
#line 3372
   /* copy workspace back if necessary */
#line 3372
    if (realign) {
#line 3372
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3372
      xp = (uint *) *xpp;
#line 3372
    }
#line 3372
   /* update xpp and tp */
#line 3372
    xp += ni;
#line 3372
    tp += ni;
#line 3372
    *xpp = (void*)xp;
#line 3372
  }
#line 3372
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3372

#line 3372
#else   /* not SX */
#line 3372

#line 3372
	char *xp = (char *) *xpp;
#line 3372
	int status = NC_NOERR;
#line 3372

#line 3372
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3372
	{
#line 3372
		int lstatus = ncx_put_uint_schar(xp, tp, fillp);
#line 3372
		if (status == NC_NOERR) /* report the first encountered error */
#line 3372
			status = lstatus;
#line 3372
	}
#line 3372

#line 3372
	*xpp = (void *)xp;
#line 3372
	return status;
#line 3372
#endif
#line 3372
}
#line 3372

int
#line 3373
ncx_putn_uint_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3373
{
#line 3373
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3373

#line 3373
 /* basic algorithm is:
#line 3373
  *   - ensure sane alignment of output data
#line 3373
  *   - copy (conversion happens automatically) input data
#line 3373
  *     to output
#line 3373
  *   - update tp to point at next unconverted input, and xpp to point
#line 3373
  *     at next location for converted output
#line 3373
  */
#line 3373
  long i, j, ni;
#line 3373
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3373
  uint *xp;
#line 3373
  int nrange = 0;         /* number of range errors */
#line 3373
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3373
  long cxp = (long) *((char**)xpp);
#line 3373

#line 3373
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3373
  /* sjl: manually stripmine so we can limit amount of
#line 3373
   * vector work space reserved to LOOPCNT elements. Also
#line 3373
   * makes vectorisation easy */
#line 3373
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3373
    ni=Min(nelems-j,LOOPCNT);
#line 3373
    if (realign) {
#line 3373
      xp = tmp;
#line 3373
    } else {
#line 3373
      xp = (uint *) *xpp;
#line 3373
    }
#line 3373
   /* copy the next block */
#line 3373
#pragma cdir loopcnt=LOOPCNT
#line 3373
#pragma cdir shortloop
#line 3373
    for (i=0; i<ni; i++) {
#line 3373
      /* the normal case: */
#line 3373
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3373
     /* test for range errors (not always needed but do it anyway) */
#line 3373
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3373
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3373
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3373
    }
#line 3373
   /* copy workspace back if necessary */
#line 3373
    if (realign) {
#line 3373
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3373
      xp = (uint *) *xpp;
#line 3373
    }
#line 3373
   /* update xpp and tp */
#line 3373
    xp += ni;
#line 3373
    tp += ni;
#line 3373
    *xpp = (void*)xp;
#line 3373
  }
#line 3373
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3373

#line 3373
#else   /* not SX */
#line 3373

#line 3373
	char *xp = (char *) *xpp;
#line 3373
	int status = NC_NOERR;
#line 3373

#line 3373
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3373
	{
#line 3373
		int lstatus = ncx_put_uint_short(xp, tp, fillp);
#line 3373
		if (status == NC_NOERR) /* report the first encountered error */
#line 3373
			status = lstatus;
#line 3373
	}
#line 3373

#line 3373
	*xpp = (void *)xp;
#line 3373
	return status;
#line 3373
#endif
#line 3373
}
#line 3373

int
#line 3374
ncx_putn_uint_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3374
{
#line 3374
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3374

#line 3374
 /* basic algorithm is:
#line 3374
  *   - ensure sane alignment of output data
#line 3374
  *   - copy (conversion happens automatically) input data
#line 3374
  *     to output
#line 3374
  *   - update tp to point at next unconverted input, and xpp to point
#line 3374
  *     at next location for converted output
#line 3374
  */
#line 3374
  long i, j, ni;
#line 3374
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3374
  uint *xp;
#line 3374
  int nrange = 0;         /* number of range errors */
#line 3374
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3374
  long cxp = (long) *((char**)xpp);
#line 3374

#line 3374
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3374
  /* sjl: manually stripmine so we can limit amount of
#line 3374
   * vector work space reserved to LOOPCNT elements. Also
#line 3374
   * makes vectorisation easy */
#line 3374
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3374
    ni=Min(nelems-j,LOOPCNT);
#line 3374
    if (realign) {
#line 3374
      xp = tmp;
#line 3374
    } else {
#line 3374
      xp = (uint *) *xpp;
#line 3374
    }
#line 3374
   /* copy the next block */
#line 3374
#pragma cdir loopcnt=LOOPCNT
#line 3374
#pragma cdir shortloop
#line 3374
    for (i=0; i<ni; i++) {
#line 3374
      /* the normal case: */
#line 3374
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3374
     /* test for range errors (not always needed but do it anyway) */
#line 3374
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3374
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3374
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3374
    }
#line 3374
   /* copy workspace back if necessary */
#line 3374
    if (realign) {
#line 3374
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3374
      xp = (uint *) *xpp;
#line 3374
    }
#line 3374
   /* update xpp and tp */
#line 3374
    xp += ni;
#line 3374
    tp += ni;
#line 3374
    *xpp = (void*)xp;
#line 3374
  }
#line 3374
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3374

#line 3374
#else   /* not SX */
#line 3374

#line 3374
	char *xp = (char *) *xpp;
#line 3374
	int status = NC_NOERR;
#line 3374

#line 3374
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3374
	{
#line 3374
		int lstatus = ncx_put_uint_int(xp, tp, fillp);
#line 3374
		if (status == NC_NOERR) /* report the first encountered error */
#line 3374
			status = lstatus;
#line 3374
	}
#line 3374

#line 3374
	*xpp = (void *)xp;
#line 3374
	return status;
#line 3374
#endif
#line 3374
}
#line 3374

int
#line 3375
ncx_putn_uint_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3375
{
#line 3375
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3375

#line 3375
 /* basic algorithm is:
#line 3375
  *   - ensure sane alignment of output data
#line 3375
  *   - copy (conversion happens automatically) input data
#line 3375
  *     to output
#line 3375
  *   - update tp to point at next unconverted input, and xpp to point
#line 3375
  *     at next location for converted output
#line 3375
  */
#line 3375
  long i, j, ni;
#line 3375
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3375
  uint *xp;
#line 3375
  int nrange = 0;         /* number of range errors */
#line 3375
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3375
  long cxp = (long) *((char**)xpp);
#line 3375

#line 3375
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3375
  /* sjl: manually stripmine so we can limit amount of
#line 3375
   * vector work space reserved to LOOPCNT elements. Also
#line 3375
   * makes vectorisation easy */
#line 3375
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3375
    ni=Min(nelems-j,LOOPCNT);
#line 3375
    if (realign) {
#line 3375
      xp = tmp;
#line 3375
    } else {
#line 3375
      xp = (uint *) *xpp;
#line 3375
    }
#line 3375
   /* copy the next block */
#line 3375
#pragma cdir loopcnt=LOOPCNT
#line 3375
#pragma cdir shortloop
#line 3375
    for (i=0; i<ni; i++) {
#line 3375
      /* the normal case: */
#line 3375
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3375
     /* test for range errors (not always needed but do it anyway) */
#line 3375
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3375
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3375
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3375
    }
#line 3375
   /* copy workspace back if necessary */
#line 3375
    if (realign) {
#line 3375
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3375
      xp = (uint *) *xpp;
#line 3375
    }
#line 3375
   /* update xpp and tp */
#line 3375
    xp += ni;
#line 3375
    tp += ni;
#line 3375
    *xpp = (void*)xp;
#line 3375
  }
#line 3375
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3375

#line 3375
#else   /* not SX */
#line 3375

#line 3375
	char *xp = (char *) *xpp;
#line 3375
	int status = NC_NOERR;
#line 3375

#line 3375
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3375
	{
#line 3375
		int lstatus = ncx_put_uint_long(xp, tp, fillp);
#line 3375
		if (status == NC_NOERR) /* report the first encountered error */
#line 3375
			status = lstatus;
#line 3375
	}
#line 3375

#line 3375
	*xpp = (void *)xp;
#line 3375
	return status;
#line 3375
#endif
#line 3375
}
#line 3375

int
#line 3376
ncx_putn_uint_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3376
{
#line 3376
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3376

#line 3376
 /* basic algorithm is:
#line 3376
  *   - ensure sane alignment of output data
#line 3376
  *   - copy (conversion happens automatically) input data
#line 3376
  *     to output
#line 3376
  *   - update tp to point at next unconverted input, and xpp to point
#line 3376
  *     at next location for converted output
#line 3376
  */
#line 3376
  long i, j, ni;
#line 3376
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3376
  uint *xp;
#line 3376
  int nrange = 0;         /* number of range errors */
#line 3376
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3376
  long cxp = (long) *((char**)xpp);
#line 3376

#line 3376
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3376
  /* sjl: manually stripmine so we can limit amount of
#line 3376
   * vector work space reserved to LOOPCNT elements. Also
#line 3376
   * makes vectorisation easy */
#line 3376
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3376
    ni=Min(nelems-j,LOOPCNT);
#line 3376
    if (realign) {
#line 3376
      xp = tmp;
#line 3376
    } else {
#line 3376
      xp = (uint *) *xpp;
#line 3376
    }
#line 3376
   /* copy the next block */
#line 3376
#pragma cdir loopcnt=LOOPCNT
#line 3376
#pragma cdir shortloop
#line 3376
    for (i=0; i<ni; i++) {
#line 3376
      /* the normal case: */
#line 3376
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3376
     /* test for range errors (not always needed but do it anyway) */
#line 3376
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3376
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3376
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3376
    }
#line 3376
   /* copy workspace back if necessary */
#line 3376
    if (realign) {
#line 3376
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3376
      xp = (uint *) *xpp;
#line 3376
    }
#line 3376
   /* update xpp and tp */
#line 3376
    xp += ni;
#line 3376
    tp += ni;
#line 3376
    *xpp = (void*)xp;
#line 3376
  }
#line 3376
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3376

#line 3376
#else   /* not SX */
#line 3376

#line 3376
	char *xp = (char *) *xpp;
#line 3376
	int status = NC_NOERR;
#line 3376

#line 3376
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3376
	{
#line 3376
		int lstatus = ncx_put_uint_float(xp, tp, fillp);
#line 3376
		if (status == NC_NOERR) /* report the first encountered error */
#line 3376
			status = lstatus;
#line 3376
	}
#line 3376

#line 3376
	*xpp = (void *)xp;
#line 3376
	return status;
#line 3376
#endif
#line 3376
}
#line 3376

int
#line 3377
ncx_putn_uint_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3377
{
#line 3377
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3377

#line 3377
 /* basic algorithm is:
#line 3377
  *   - ensure sane alignment of output data
#line 3377
  *   - copy (conversion happens automatically) input data
#line 3377
  *     to output
#line 3377
  *   - update tp to point at next unconverted input, and xpp to point
#line 3377
  *     at next location for converted output
#line 3377
  */
#line 3377
  long i, j, ni;
#line 3377
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3377
  uint *xp;
#line 3377
  int nrange = 0;         /* number of range errors */
#line 3377
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3377
  long cxp = (long) *((char**)xpp);
#line 3377

#line 3377
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3377
  /* sjl: manually stripmine so we can limit amount of
#line 3377
   * vector work space reserved to LOOPCNT elements. Also
#line 3377
   * makes vectorisation easy */
#line 3377
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3377
    ni=Min(nelems-j,LOOPCNT);
#line 3377
    if (realign) {
#line 3377
      xp = tmp;
#line 3377
    } else {
#line 3377
      xp = (uint *) *xpp;
#line 3377
    }
#line 3377
   /* copy the next block */
#line 3377
#pragma cdir loopcnt=LOOPCNT
#line 3377
#pragma cdir shortloop
#line 3377
    for (i=0; i<ni; i++) {
#line 3377
      /* the normal case: */
#line 3377
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3377
     /* test for range errors (not always needed but do it anyway) */
#line 3377
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3377
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3377
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3377
    }
#line 3377
   /* copy workspace back if necessary */
#line 3377
    if (realign) {
#line 3377
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3377
      xp = (uint *) *xpp;
#line 3377
    }
#line 3377
   /* update xpp and tp */
#line 3377
    xp += ni;
#line 3377
    tp += ni;
#line 3377
    *xpp = (void*)xp;
#line 3377
  }
#line 3377
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3377

#line 3377
#else   /* not SX */
#line 3377

#line 3377
	char *xp = (char *) *xpp;
#line 3377
	int status = NC_NOERR;
#line 3377

#line 3377
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3377
	{
#line 3377
		int lstatus = ncx_put_uint_double(xp, tp, fillp);
#line 3377
		if (status == NC_NOERR) /* report the first encountered error */
#line 3377
			status = lstatus;
#line 3377
	}
#line 3377

#line 3377
	*xpp = (void *)xp;
#line 3377
	return status;
#line 3377
#endif
#line 3377
}
#line 3377

int
#line 3378
ncx_putn_uint_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3378
{
#line 3378
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3378

#line 3378
 /* basic algorithm is:
#line 3378
  *   - ensure sane alignment of output data
#line 3378
  *   - copy (conversion happens automatically) input data
#line 3378
  *     to output
#line 3378
  *   - update tp to point at next unconverted input, and xpp to point
#line 3378
  *     at next location for converted output
#line 3378
  */
#line 3378
  long i, j, ni;
#line 3378
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3378
  uint *xp;
#line 3378
  int nrange = 0;         /* number of range errors */
#line 3378
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3378
  long cxp = (long) *((char**)xpp);
#line 3378

#line 3378
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3378
  /* sjl: manually stripmine so we can limit amount of
#line 3378
   * vector work space reserved to LOOPCNT elements. Also
#line 3378
   * makes vectorisation easy */
#line 3378
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3378
    ni=Min(nelems-j,LOOPCNT);
#line 3378
    if (realign) {
#line 3378
      xp = tmp;
#line 3378
    } else {
#line 3378
      xp = (uint *) *xpp;
#line 3378
    }
#line 3378
   /* copy the next block */
#line 3378
#pragma cdir loopcnt=LOOPCNT
#line 3378
#pragma cdir shortloop
#line 3378
    for (i=0; i<ni; i++) {
#line 3378
      /* the normal case: */
#line 3378
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3378
     /* test for range errors (not always needed but do it anyway) */
#line 3378
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3378
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3378
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 3378
    }
#line 3378
   /* copy workspace back if necessary */
#line 3378
    if (realign) {
#line 3378
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3378
      xp = (uint *) *xpp;
#line 3378
    }
#line 3378
   /* update xpp and tp */
#line 3378
    xp += ni;
#line 3378
    tp += ni;
#line 3378
    *xpp = (void*)xp;
#line 3378
  }
#line 3378
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3378

#line 3378
#else   /* not SX */
#line 3378

#line 3378
	char *xp = (char *) *xpp;
#line 3378
	int status = NC_NOERR;
#line 3378

#line 3378
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3378
	{
#line 3378
		int lstatus = ncx_put_uint_longlong(xp, tp, fillp);
#line 3378
		if (status == NC_NOERR) /* report the first encountered error */
#line 3378
			status = lstatus;
#line 3378
	}
#line 3378

#line 3378
	*xpp = (void *)xp;
#line 3378
	return status;
#line 3378
#endif
#line 3378
}
#line 3378

int
#line 3379
ncx_putn_uint_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3379
{
#line 3379
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3379

#line 3379
 /* basic algorithm is:
#line 3379
  *   - ensure sane alignment of output data
#line 3379
  *   - copy (conversion happens automatically) input data
#line 3379
  *     to output
#line 3379
  *   - update tp to point at next unconverted input, and xpp to point
#line 3379
  *     at next location for converted output
#line 3379
  */
#line 3379
  long i, j, ni;
#line 3379
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3379
  uint *xp;
#line 3379
  int nrange = 0;         /* number of range errors */
#line 3379
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3379
  long cxp = (long) *((char**)xpp);
#line 3379

#line 3379
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3379
  /* sjl: manually stripmine so we can limit amount of
#line 3379
   * vector work space reserved to LOOPCNT elements. Also
#line 3379
   * makes vectorisation easy */
#line 3379
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3379
    ni=Min(nelems-j,LOOPCNT);
#line 3379
    if (realign) {
#line 3379
      xp = tmp;
#line 3379
    } else {
#line 3379
      xp = (uint *) *xpp;
#line 3379
    }
#line 3379
   /* copy the next block */
#line 3379
#pragma cdir loopcnt=LOOPCNT
#line 3379
#pragma cdir shortloop
#line 3379
    for (i=0; i<ni; i++) {
#line 3379
      /* the normal case: */
#line 3379
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3379
     /* test for range errors (not always needed but do it anyway) */
#line 3379
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3379
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3379
      nrange += tp[i] > X_UINT_MAX ;
#line 3379
    }
#line 3379
   /* copy workspace back if necessary */
#line 3379
    if (realign) {
#line 3379
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3379
      xp = (uint *) *xpp;
#line 3379
    }
#line 3379
   /* update xpp and tp */
#line 3379
    xp += ni;
#line 3379
    tp += ni;
#line 3379
    *xpp = (void*)xp;
#line 3379
  }
#line 3379
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3379

#line 3379
#else   /* not SX */
#line 3379

#line 3379
	char *xp = (char *) *xpp;
#line 3379
	int status = NC_NOERR;
#line 3379

#line 3379
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3379
	{
#line 3379
		int lstatus = ncx_put_uint_uchar(xp, tp, fillp);
#line 3379
		if (status == NC_NOERR) /* report the first encountered error */
#line 3379
			status = lstatus;
#line 3379
	}
#line 3379

#line 3379
	*xpp = (void *)xp;
#line 3379
	return status;
#line 3379
#endif
#line 3379
}
#line 3379

int
#line 3380
ncx_putn_uint_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3380
{
#line 3380
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3380

#line 3380
 /* basic algorithm is:
#line 3380
  *   - ensure sane alignment of output data
#line 3380
  *   - copy (conversion happens automatically) input data
#line 3380
  *     to output
#line 3380
  *   - update tp to point at next unconverted input, and xpp to point
#line 3380
  *     at next location for converted output
#line 3380
  */
#line 3380
  long i, j, ni;
#line 3380
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3380
  uint *xp;
#line 3380
  int nrange = 0;         /* number of range errors */
#line 3380
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3380
  long cxp = (long) *((char**)xpp);
#line 3380

#line 3380
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3380
  /* sjl: manually stripmine so we can limit amount of
#line 3380
   * vector work space reserved to LOOPCNT elements. Also
#line 3380
   * makes vectorisation easy */
#line 3380
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3380
    ni=Min(nelems-j,LOOPCNT);
#line 3380
    if (realign) {
#line 3380
      xp = tmp;
#line 3380
    } else {
#line 3380
      xp = (uint *) *xpp;
#line 3380
    }
#line 3380
   /* copy the next block */
#line 3380
#pragma cdir loopcnt=LOOPCNT
#line 3380
#pragma cdir shortloop
#line 3380
    for (i=0; i<ni; i++) {
#line 3380
      /* the normal case: */
#line 3380
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3380
     /* test for range errors (not always needed but do it anyway) */
#line 3380
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3380
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3380
      nrange += tp[i] > X_UINT_MAX ;
#line 3380
    }
#line 3380
   /* copy workspace back if necessary */
#line 3380
    if (realign) {
#line 3380
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3380
      xp = (uint *) *xpp;
#line 3380
    }
#line 3380
   /* update xpp and tp */
#line 3380
    xp += ni;
#line 3380
    tp += ni;
#line 3380
    *xpp = (void*)xp;
#line 3380
  }
#line 3380
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3380

#line 3380
#else   /* not SX */
#line 3380

#line 3380
	char *xp = (char *) *xpp;
#line 3380
	int status = NC_NOERR;
#line 3380

#line 3380
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3380
	{
#line 3380
		int lstatus = ncx_put_uint_ushort(xp, tp, fillp);
#line 3380
		if (status == NC_NOERR) /* report the first encountered error */
#line 3380
			status = lstatus;
#line 3380
	}
#line 3380

#line 3380
	*xpp = (void *)xp;
#line 3380
	return status;
#line 3380
#endif
#line 3380
}
#line 3380

int
#line 3381
ncx_putn_uint_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3381
{
#line 3381
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT == SIZEOF_UINT
#line 3381

#line 3381
 /* basic algorithm is:
#line 3381
  *   - ensure sane alignment of output data
#line 3381
  *   - copy (conversion happens automatically) input data
#line 3381
  *     to output
#line 3381
  *   - update tp to point at next unconverted input, and xpp to point
#line 3381
  *     at next location for converted output
#line 3381
  */
#line 3381
  long i, j, ni;
#line 3381
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 3381
  uint *xp;
#line 3381
  int nrange = 0;         /* number of range errors */
#line 3381
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3381
  long cxp = (long) *((char**)xpp);
#line 3381

#line 3381
  realign = (cxp & 7) % SIZEOF_UINT;
#line 3381
  /* sjl: manually stripmine so we can limit amount of
#line 3381
   * vector work space reserved to LOOPCNT elements. Also
#line 3381
   * makes vectorisation easy */
#line 3381
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3381
    ni=Min(nelems-j,LOOPCNT);
#line 3381
    if (realign) {
#line 3381
      xp = tmp;
#line 3381
    } else {
#line 3381
      xp = (uint *) *xpp;
#line 3381
    }
#line 3381
   /* copy the next block */
#line 3381
#pragma cdir loopcnt=LOOPCNT
#line 3381
#pragma cdir shortloop
#line 3381
    for (i=0; i<ni; i++) {
#line 3381
      /* the normal case: */
#line 3381
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 3381
     /* test for range errors (not always needed but do it anyway) */
#line 3381
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3381
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3381
      nrange += tp[i] > X_UINT_MAX ;
#line 3381
    }
#line 3381
   /* copy workspace back if necessary */
#line 3381
    if (realign) {
#line 3381
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT);
#line 3381
      xp = (uint *) *xpp;
#line 3381
    }
#line 3381
   /* update xpp and tp */
#line 3381
    xp += ni;
#line 3381
    tp += ni;
#line 3381
    *xpp = (void*)xp;
#line 3381
  }
#line 3381
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3381

#line 3381
#else   /* not SX */
#line 3381

#line 3381
	char *xp = (char *) *xpp;
#line 3381
	int status = NC_NOERR;
#line 3381

#line 3381
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 3381
	{
#line 3381
		int lstatus = ncx_put_uint_ulonglong(xp, tp, fillp);
#line 3381
		if (status == NC_NOERR) /* report the first encountered error */
#line 3381
			status = lstatus;
#line 3381
	}
#line 3381

#line 3381
	*xpp = (void *)xp;
#line 3381
	return status;
#line 3381
#endif
#line 3381
}
#line 3381



/* float ---------------------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_FLOAT);
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_float_float(const void **xpp, size_t nfloats, float *ip)
{
	float *const end = ip + nfloats;

	while (ip < end)
	{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 3407
		const struct ieee_single *const isp =
#line 3407
			 (const struct ieee_single *) (*xpp);
#line 3407
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 3407

#line 3407
		switch(exp) {
#line 3407
		case 0 :
#line 3407
			/* ieee subnormal */
#line 3407
			if (isp->mant_hi == min.ieee.mant_hi
#line 3407
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 3407
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 3407
			{
#line 3407
				*vsp = min.s;
#line 3407
			}
#line 3407
			else
#line 3407
			{
#line 3407
				unsigned mantissa = (isp->mant_hi << 16)
#line 3407
					 | isp->mant_lo_hi << 8
#line 3407
					 | isp->mant_lo_lo;
#line 3407
				unsigned tmp = mantissa >> 20;
#line 3407
				if (tmp >= 4) {
#line 3407
					vsp->exp = 2;
#line 3407
				} else if (tmp >= 2) {
#line 3407
					vsp->exp = 1;
#line 3407
				} else {
#line 3407
					*vsp = min.s;
#line 3407
					break;
#line 3407
				} /* else */
#line 3407
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 3407
				tmp <<= 3 - vsp->exp;
#line 3407
				vsp->mantissa2 = tmp;
#line 3407
				vsp->mantissa1 = (tmp >> 16);
#line 3407
			}
#line 3407
			break;
#line 3407
		case 0xfe :
#line 3407
		case 0xff :
#line 3407
			*vsp = max.s;
#line 3407
			break;
#line 3407
		default :
#line 3407
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 3407
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 3407
			vsp->mantissa1 = isp->mant_hi;
#line 3407
		}
#line 3407

#line 3407
		vsp->sign = isp->sign;
#line 3407


		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}

#endif
int
#line 3433
ncx_getn_float_schar(const void **xpp, size_t nelems, schar *tp)
#line 3433
{
#line 3433
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3433

#line 3433
 /* basic algorithm is:
#line 3433
  *   - ensure sane alignment of input data
#line 3433
  *   - copy (conversion happens automatically) input data
#line 3433
  *     to output
#line 3433
  *   - update xpp to point at next unconverted input, and tp to point
#line 3433
  *     at next location for converted output
#line 3433
  */
#line 3433
  long i, j, ni;
#line 3433
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3433
  float *xp;
#line 3433
  int nrange = 0;         /* number of range errors */
#line 3433
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3433
  long cxp = (long) *((char**)xpp);
#line 3433

#line 3433
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3433
  /* sjl: manually stripmine so we can limit amount of
#line 3433
   * vector work space reserved to LOOPCNT elements. Also
#line 3433
   * makes vectorisation easy */
#line 3433
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3433
    ni=Min(nelems-j,LOOPCNT);
#line 3433
    if (realign) {
#line 3433
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3433
      xp = tmp;
#line 3433
    } else {
#line 3433
      xp = (float *) *xpp;
#line 3433
    }
#line 3433
   /* copy the next block */
#line 3433
#pragma cdir loopcnt=LOOPCNT
#line 3433
#pragma cdir shortloop
#line 3433
    for (i=0; i<ni; i++) {
#line 3433
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3433
     /* test for range errors (not always needed but do it anyway) */
#line 3433
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3433
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3433
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3433
    }
#line 3433
   /* update xpp and tp */
#line 3433
    if (realign) xp = (float *) *xpp;
#line 3433
    xp += ni;
#line 3433
    tp += ni;
#line 3433
    *xpp = (void*)xp;
#line 3433
  }
#line 3433
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3433

#line 3433
#else   /* not SX */
#line 3433
	const char *xp = (const char *) *xpp;
#line 3433
	int status = NC_NOERR;
#line 3433

#line 3433
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3433
	{
#line 3433
		const int lstatus = ncx_get_float_schar(xp, tp);
#line 3433
		if (status == NC_NOERR) /* report the first encountered error */
#line 3433
			status = lstatus;
#line 3433
	}
#line 3433

#line 3433
	*xpp = (const void *)xp;
#line 3433
	return status;
#line 3433
#endif
#line 3433
}
#line 3433

int
#line 3434
ncx_getn_float_short(const void **xpp, size_t nelems, short *tp)
#line 3434
{
#line 3434
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3434

#line 3434
 /* basic algorithm is:
#line 3434
  *   - ensure sane alignment of input data
#line 3434
  *   - copy (conversion happens automatically) input data
#line 3434
  *     to output
#line 3434
  *   - update xpp to point at next unconverted input, and tp to point
#line 3434
  *     at next location for converted output
#line 3434
  */
#line 3434
  long i, j, ni;
#line 3434
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3434
  float *xp;
#line 3434
  int nrange = 0;         /* number of range errors */
#line 3434
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3434
  long cxp = (long) *((char**)xpp);
#line 3434

#line 3434
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3434
  /* sjl: manually stripmine so we can limit amount of
#line 3434
   * vector work space reserved to LOOPCNT elements. Also
#line 3434
   * makes vectorisation easy */
#line 3434
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3434
    ni=Min(nelems-j,LOOPCNT);
#line 3434
    if (realign) {
#line 3434
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3434
      xp = tmp;
#line 3434
    } else {
#line 3434
      xp = (float *) *xpp;
#line 3434
    }
#line 3434
   /* copy the next block */
#line 3434
#pragma cdir loopcnt=LOOPCNT
#line 3434
#pragma cdir shortloop
#line 3434
    for (i=0; i<ni; i++) {
#line 3434
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3434
     /* test for range errors (not always needed but do it anyway) */
#line 3434
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3434
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3434
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3434
    }
#line 3434
   /* update xpp and tp */
#line 3434
    if (realign) xp = (float *) *xpp;
#line 3434
    xp += ni;
#line 3434
    tp += ni;
#line 3434
    *xpp = (void*)xp;
#line 3434
  }
#line 3434
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3434

#line 3434
#else   /* not SX */
#line 3434
	const char *xp = (const char *) *xpp;
#line 3434
	int status = NC_NOERR;
#line 3434

#line 3434
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3434
	{
#line 3434
		const int lstatus = ncx_get_float_short(xp, tp);
#line 3434
		if (status == NC_NOERR) /* report the first encountered error */
#line 3434
			status = lstatus;
#line 3434
	}
#line 3434

#line 3434
	*xpp = (const void *)xp;
#line 3434
	return status;
#line 3434
#endif
#line 3434
}
#line 3434

int
#line 3435
ncx_getn_float_int(const void **xpp, size_t nelems, int *tp)
#line 3435
{
#line 3435
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3435

#line 3435
 /* basic algorithm is:
#line 3435
  *   - ensure sane alignment of input data
#line 3435
  *   - copy (conversion happens automatically) input data
#line 3435
  *     to output
#line 3435
  *   - update xpp to point at next unconverted input, and tp to point
#line 3435
  *     at next location for converted output
#line 3435
  */
#line 3435
  long i, j, ni;
#line 3435
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3435
  float *xp;
#line 3435
  int nrange = 0;         /* number of range errors */
#line 3435
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3435
  long cxp = (long) *((char**)xpp);
#line 3435

#line 3435
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3435
  /* sjl: manually stripmine so we can limit amount of
#line 3435
   * vector work space reserved to LOOPCNT elements. Also
#line 3435
   * makes vectorisation easy */
#line 3435
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3435
    ni=Min(nelems-j,LOOPCNT);
#line 3435
    if (realign) {
#line 3435
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3435
      xp = tmp;
#line 3435
    } else {
#line 3435
      xp = (float *) *xpp;
#line 3435
    }
#line 3435
   /* copy the next block */
#line 3435
#pragma cdir loopcnt=LOOPCNT
#line 3435
#pragma cdir shortloop
#line 3435
    for (i=0; i<ni; i++) {
#line 3435
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3435
     /* test for range errors (not always needed but do it anyway) */
#line 3435
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3435
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3435
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3435
    }
#line 3435
   /* update xpp and tp */
#line 3435
    if (realign) xp = (float *) *xpp;
#line 3435
    xp += ni;
#line 3435
    tp += ni;
#line 3435
    *xpp = (void*)xp;
#line 3435
  }
#line 3435
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3435

#line 3435
#else   /* not SX */
#line 3435
	const char *xp = (const char *) *xpp;
#line 3435
	int status = NC_NOERR;
#line 3435

#line 3435
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3435
	{
#line 3435
		const int lstatus = ncx_get_float_int(xp, tp);
#line 3435
		if (status == NC_NOERR) /* report the first encountered error */
#line 3435
			status = lstatus;
#line 3435
	}
#line 3435

#line 3435
	*xpp = (const void *)xp;
#line 3435
	return status;
#line 3435
#endif
#line 3435
}
#line 3435

int
#line 3436
ncx_getn_float_long(const void **xpp, size_t nelems, long *tp)
#line 3436
{
#line 3436
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3436

#line 3436
 /* basic algorithm is:
#line 3436
  *   - ensure sane alignment of input data
#line 3436
  *   - copy (conversion happens automatically) input data
#line 3436
  *     to output
#line 3436
  *   - update xpp to point at next unconverted input, and tp to point
#line 3436
  *     at next location for converted output
#line 3436
  */
#line 3436
  long i, j, ni;
#line 3436
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3436
  float *xp;
#line 3436
  int nrange = 0;         /* number of range errors */
#line 3436
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3436
  long cxp = (long) *((char**)xpp);
#line 3436

#line 3436
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3436
  /* sjl: manually stripmine so we can limit amount of
#line 3436
   * vector work space reserved to LOOPCNT elements. Also
#line 3436
   * makes vectorisation easy */
#line 3436
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3436
    ni=Min(nelems-j,LOOPCNT);
#line 3436
    if (realign) {
#line 3436
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3436
      xp = tmp;
#line 3436
    } else {
#line 3436
      xp = (float *) *xpp;
#line 3436
    }
#line 3436
   /* copy the next block */
#line 3436
#pragma cdir loopcnt=LOOPCNT
#line 3436
#pragma cdir shortloop
#line 3436
    for (i=0; i<ni; i++) {
#line 3436
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3436
     /* test for range errors (not always needed but do it anyway) */
#line 3436
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3436
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3436
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3436
    }
#line 3436
   /* update xpp and tp */
#line 3436
    if (realign) xp = (float *) *xpp;
#line 3436
    xp += ni;
#line 3436
    tp += ni;
#line 3436
    *xpp = (void*)xp;
#line 3436
  }
#line 3436
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3436

#line 3436
#else   /* not SX */
#line 3436
	const char *xp = (const char *) *xpp;
#line 3436
	int status = NC_NOERR;
#line 3436

#line 3436
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3436
	{
#line 3436
		const int lstatus = ncx_get_float_long(xp, tp);
#line 3436
		if (status == NC_NOERR) /* report the first encountered error */
#line 3436
			status = lstatus;
#line 3436
	}
#line 3436

#line 3436
	*xpp = (const void *)xp;
#line 3436
	return status;
#line 3436
#endif
#line 3436
}
#line 3436

int
#line 3437
ncx_getn_float_double(const void **xpp, size_t nelems, double *tp)
#line 3437
{
#line 3437
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3437

#line 3437
 /* basic algorithm is:
#line 3437
  *   - ensure sane alignment of input data
#line 3437
  *   - copy (conversion happens automatically) input data
#line 3437
  *     to output
#line 3437
  *   - update xpp to point at next unconverted input, and tp to point
#line 3437
  *     at next location for converted output
#line 3437
  */
#line 3437
  long i, j, ni;
#line 3437
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3437
  float *xp;
#line 3437
  int nrange = 0;         /* number of range errors */
#line 3437
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3437
  long cxp = (long) *((char**)xpp);
#line 3437

#line 3437
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3437
  /* sjl: manually stripmine so we can limit amount of
#line 3437
   * vector work space reserved to LOOPCNT elements. Also
#line 3437
   * makes vectorisation easy */
#line 3437
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3437
    ni=Min(nelems-j,LOOPCNT);
#line 3437
    if (realign) {
#line 3437
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3437
      xp = tmp;
#line 3437
    } else {
#line 3437
      xp = (float *) *xpp;
#line 3437
    }
#line 3437
   /* copy the next block */
#line 3437
#pragma cdir loopcnt=LOOPCNT
#line 3437
#pragma cdir shortloop
#line 3437
    for (i=0; i<ni; i++) {
#line 3437
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3437
     /* test for range errors (not always needed but do it anyway) */
#line 3437
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3437
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3437
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3437
    }
#line 3437
   /* update xpp and tp */
#line 3437
    if (realign) xp = (float *) *xpp;
#line 3437
    xp += ni;
#line 3437
    tp += ni;
#line 3437
    *xpp = (void*)xp;
#line 3437
  }
#line 3437
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3437

#line 3437
#else   /* not SX */
#line 3437
	const char *xp = (const char *) *xpp;
#line 3437
	int status = NC_NOERR;
#line 3437

#line 3437
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3437
	{
#line 3437
		const int lstatus = ncx_get_float_double(xp, tp);
#line 3437
		if (status == NC_NOERR) /* report the first encountered error */
#line 3437
			status = lstatus;
#line 3437
	}
#line 3437

#line 3437
	*xpp = (const void *)xp;
#line 3437
	return status;
#line 3437
#endif
#line 3437
}
#line 3437

int
#line 3438
ncx_getn_float_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3438
{
#line 3438
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3438

#line 3438
 /* basic algorithm is:
#line 3438
  *   - ensure sane alignment of input data
#line 3438
  *   - copy (conversion happens automatically) input data
#line 3438
  *     to output
#line 3438
  *   - update xpp to point at next unconverted input, and tp to point
#line 3438
  *     at next location for converted output
#line 3438
  */
#line 3438
  long i, j, ni;
#line 3438
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3438
  float *xp;
#line 3438
  int nrange = 0;         /* number of range errors */
#line 3438
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3438
  long cxp = (long) *((char**)xpp);
#line 3438

#line 3438
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3438
  /* sjl: manually stripmine so we can limit amount of
#line 3438
   * vector work space reserved to LOOPCNT elements. Also
#line 3438
   * makes vectorisation easy */
#line 3438
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3438
    ni=Min(nelems-j,LOOPCNT);
#line 3438
    if (realign) {
#line 3438
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3438
      xp = tmp;
#line 3438
    } else {
#line 3438
      xp = (float *) *xpp;
#line 3438
    }
#line 3438
   /* copy the next block */
#line 3438
#pragma cdir loopcnt=LOOPCNT
#line 3438
#pragma cdir shortloop
#line 3438
    for (i=0; i<ni; i++) {
#line 3438
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3438
     /* test for range errors (not always needed but do it anyway) */
#line 3438
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3438
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3438
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3438
    }
#line 3438
   /* update xpp and tp */
#line 3438
    if (realign) xp = (float *) *xpp;
#line 3438
    xp += ni;
#line 3438
    tp += ni;
#line 3438
    *xpp = (void*)xp;
#line 3438
  }
#line 3438
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3438

#line 3438
#else   /* not SX */
#line 3438
	const char *xp = (const char *) *xpp;
#line 3438
	int status = NC_NOERR;
#line 3438

#line 3438
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3438
	{
#line 3438
		const int lstatus = ncx_get_float_longlong(xp, tp);
#line 3438
		if (status == NC_NOERR) /* report the first encountered error */
#line 3438
			status = lstatus;
#line 3438
	}
#line 3438

#line 3438
	*xpp = (const void *)xp;
#line 3438
	return status;
#line 3438
#endif
#line 3438
}
#line 3438

int
#line 3439
ncx_getn_float_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3439
{
#line 3439
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3439

#line 3439
 /* basic algorithm is:
#line 3439
  *   - ensure sane alignment of input data
#line 3439
  *   - copy (conversion happens automatically) input data
#line 3439
  *     to output
#line 3439
  *   - update xpp to point at next unconverted input, and tp to point
#line 3439
  *     at next location for converted output
#line 3439
  */
#line 3439
  long i, j, ni;
#line 3439
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3439
  float *xp;
#line 3439
  int nrange = 0;         /* number of range errors */
#line 3439
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3439
  long cxp = (long) *((char**)xpp);
#line 3439

#line 3439
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3439
  /* sjl: manually stripmine so we can limit amount of
#line 3439
   * vector work space reserved to LOOPCNT elements. Also
#line 3439
   * makes vectorisation easy */
#line 3439
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3439
    ni=Min(nelems-j,LOOPCNT);
#line 3439
    if (realign) {
#line 3439
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3439
      xp = tmp;
#line 3439
    } else {
#line 3439
      xp = (float *) *xpp;
#line 3439
    }
#line 3439
   /* copy the next block */
#line 3439
#pragma cdir loopcnt=LOOPCNT
#line 3439
#pragma cdir shortloop
#line 3439
    for (i=0; i<ni; i++) {
#line 3439
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3439
     /* test for range errors (not always needed but do it anyway) */
#line 3439
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3439
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3439
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3439
    }
#line 3439
   /* update xpp and tp */
#line 3439
    if (realign) xp = (float *) *xpp;
#line 3439
    xp += ni;
#line 3439
    tp += ni;
#line 3439
    *xpp = (void*)xp;
#line 3439
  }
#line 3439
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3439

#line 3439
#else   /* not SX */
#line 3439
	const char *xp = (const char *) *xpp;
#line 3439
	int status = NC_NOERR;
#line 3439

#line 3439
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3439
	{
#line 3439
		const int lstatus = ncx_get_float_ushort(xp, tp);
#line 3439
		if (status == NC_NOERR) /* report the first encountered error */
#line 3439
			status = lstatus;
#line 3439
	}
#line 3439

#line 3439
	*xpp = (const void *)xp;
#line 3439
	return status;
#line 3439
#endif
#line 3439
}
#line 3439

int
#line 3440
ncx_getn_float_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3440
{
#line 3440
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3440

#line 3440
 /* basic algorithm is:
#line 3440
  *   - ensure sane alignment of input data
#line 3440
  *   - copy (conversion happens automatically) input data
#line 3440
  *     to output
#line 3440
  *   - update xpp to point at next unconverted input, and tp to point
#line 3440
  *     at next location for converted output
#line 3440
  */
#line 3440
  long i, j, ni;
#line 3440
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3440
  float *xp;
#line 3440
  int nrange = 0;         /* number of range errors */
#line 3440
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3440
  long cxp = (long) *((char**)xpp);
#line 3440

#line 3440
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3440
  /* sjl: manually stripmine so we can limit amount of
#line 3440
   * vector work space reserved to LOOPCNT elements. Also
#line 3440
   * makes vectorisation easy */
#line 3440
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3440
    ni=Min(nelems-j,LOOPCNT);
#line 3440
    if (realign) {
#line 3440
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3440
      xp = tmp;
#line 3440
    } else {
#line 3440
      xp = (float *) *xpp;
#line 3440
    }
#line 3440
   /* copy the next block */
#line 3440
#pragma cdir loopcnt=LOOPCNT
#line 3440
#pragma cdir shortloop
#line 3440
    for (i=0; i<ni; i++) {
#line 3440
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3440
     /* test for range errors (not always needed but do it anyway) */
#line 3440
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3440
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3440
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3440
    }
#line 3440
   /* update xpp and tp */
#line 3440
    if (realign) xp = (float *) *xpp;
#line 3440
    xp += ni;
#line 3440
    tp += ni;
#line 3440
    *xpp = (void*)xp;
#line 3440
  }
#line 3440
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3440

#line 3440
#else   /* not SX */
#line 3440
	const char *xp = (const char *) *xpp;
#line 3440
	int status = NC_NOERR;
#line 3440

#line 3440
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3440
	{
#line 3440
		const int lstatus = ncx_get_float_uchar(xp, tp);
#line 3440
		if (status == NC_NOERR) /* report the first encountered error */
#line 3440
			status = lstatus;
#line 3440
	}
#line 3440

#line 3440
	*xpp = (const void *)xp;
#line 3440
	return status;
#line 3440
#endif
#line 3440
}
#line 3440

int
#line 3441
ncx_getn_float_uint(const void **xpp, size_t nelems, uint *tp)
#line 3441
{
#line 3441
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3441

#line 3441
 /* basic algorithm is:
#line 3441
  *   - ensure sane alignment of input data
#line 3441
  *   - copy (conversion happens automatically) input data
#line 3441
  *     to output
#line 3441
  *   - update xpp to point at next unconverted input, and tp to point
#line 3441
  *     at next location for converted output
#line 3441
  */
#line 3441
  long i, j, ni;
#line 3441
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3441
  float *xp;
#line 3441
  int nrange = 0;         /* number of range errors */
#line 3441
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3441
  long cxp = (long) *((char**)xpp);
#line 3441

#line 3441
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3441
  /* sjl: manually stripmine so we can limit amount of
#line 3441
   * vector work space reserved to LOOPCNT elements. Also
#line 3441
   * makes vectorisation easy */
#line 3441
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3441
    ni=Min(nelems-j,LOOPCNT);
#line 3441
    if (realign) {
#line 3441
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3441
      xp = tmp;
#line 3441
    } else {
#line 3441
      xp = (float *) *xpp;
#line 3441
    }
#line 3441
   /* copy the next block */
#line 3441
#pragma cdir loopcnt=LOOPCNT
#line 3441
#pragma cdir shortloop
#line 3441
    for (i=0; i<ni; i++) {
#line 3441
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3441
     /* test for range errors (not always needed but do it anyway) */
#line 3441
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3441
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3441
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3441
    }
#line 3441
   /* update xpp and tp */
#line 3441
    if (realign) xp = (float *) *xpp;
#line 3441
    xp += ni;
#line 3441
    tp += ni;
#line 3441
    *xpp = (void*)xp;
#line 3441
  }
#line 3441
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3441

#line 3441
#else   /* not SX */
#line 3441
	const char *xp = (const char *) *xpp;
#line 3441
	int status = NC_NOERR;
#line 3441

#line 3441
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3441
	{
#line 3441
		const int lstatus = ncx_get_float_uint(xp, tp);
#line 3441
		if (status == NC_NOERR) /* report the first encountered error */
#line 3441
			status = lstatus;
#line 3441
	}
#line 3441

#line 3441
	*xpp = (const void *)xp;
#line 3441
	return status;
#line 3441
#endif
#line 3441
}
#line 3441

int
#line 3442
ncx_getn_float_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3442
{
#line 3442
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3442

#line 3442
 /* basic algorithm is:
#line 3442
  *   - ensure sane alignment of input data
#line 3442
  *   - copy (conversion happens automatically) input data
#line 3442
  *     to output
#line 3442
  *   - update xpp to point at next unconverted input, and tp to point
#line 3442
  *     at next location for converted output
#line 3442
  */
#line 3442
  long i, j, ni;
#line 3442
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3442
  float *xp;
#line 3442
  int nrange = 0;         /* number of range errors */
#line 3442
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3442
  long cxp = (long) *((char**)xpp);
#line 3442

#line 3442
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3442
  /* sjl: manually stripmine so we can limit amount of
#line 3442
   * vector work space reserved to LOOPCNT elements. Also
#line 3442
   * makes vectorisation easy */
#line 3442
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3442
    ni=Min(nelems-j,LOOPCNT);
#line 3442
    if (realign) {
#line 3442
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_FLOAT));
#line 3442
      xp = tmp;
#line 3442
    } else {
#line 3442
      xp = (float *) *xpp;
#line 3442
    }
#line 3442
   /* copy the next block */
#line 3442
#pragma cdir loopcnt=LOOPCNT
#line 3442
#pragma cdir shortloop
#line 3442
    for (i=0; i<ni; i++) {
#line 3442
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3442
     /* test for range errors (not always needed but do it anyway) */
#line 3442
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3442
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3442
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3442
    }
#line 3442
   /* update xpp and tp */
#line 3442
    if (realign) xp = (float *) *xpp;
#line 3442
    xp += ni;
#line 3442
    tp += ni;
#line 3442
    *xpp = (void*)xp;
#line 3442
  }
#line 3442
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3442

#line 3442
#else   /* not SX */
#line 3442
	const char *xp = (const char *) *xpp;
#line 3442
	int status = NC_NOERR;
#line 3442

#line 3442
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3442
	{
#line 3442
		const int lstatus = ncx_get_float_ulonglong(xp, tp);
#line 3442
		if (status == NC_NOERR) /* report the first encountered error */
#line 3442
			status = lstatus;
#line 3442
	}
#line 3442

#line 3442
	*xpp = (const void *)xp;
#line 3442
	return status;
#line 3442
#endif
#line 3442
}
#line 3442


int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_FLOAT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
{
	const float *const end = tp + nelems;

	while (tp < end) {
				const struct vax_single *const vsp =
#line 3462
			 (const struct vax_single *)ip;
#line 3462
		struct ieee_single *const isp = (struct ieee_single *) (*xpp);
#line 3462

#line 3462
		switch(vsp->exp){
#line 3462
		case 0 :
#line 3462
			/* all vax float with zero exponent map to zero */
#line 3462
			*isp = min.ieee;
#line 3462
			break;
#line 3462
		case 2 :
#line 3462
		case 1 :
#line 3462
		{
#line 3462
			/* These will map to subnormals */
#line 3462
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 3462
					 | vsp->mantissa2;
#line 3462
			mantissa >>= 3 - vsp->exp;
#line 3462
			mantissa += (1 << (20 + vsp->exp));
#line 3462
			isp->mant_lo_lo = mantissa;
#line 3462
			isp->mant_lo_hi = mantissa >> 8;
#line 3462
			isp->mant_hi = mantissa >> 16;
#line 3462
			isp->exp_lo = 0;
#line 3462
			isp->exp_hi = 0;
#line 3462
		}
#line 3462
			break;
#line 3462
		case 0xff : /* max.s.exp */
#line 3462
			if (vsp->mantissa2 == max.s.mantissa2 &&
#line 3462
			    vsp->mantissa1 == max.s.mantissa1)
#line 3462
			{
#line 3462
				/* map largest vax float to ieee infinity */
#line 3462
				*isp = max.ieee;
#line 3462
				break;
#line 3462
			} /* else, fall thru */
#line 3462
		default :
#line 3462
		{
#line 3462
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 3462
			isp->exp_hi = exp >> 1;
#line 3462
			isp->exp_lo = exp;
#line 3462
			isp->mant_lo_lo = vsp->mantissa2;
#line 3462
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 3462
			isp->mant_hi = vsp->mantissa1;
#line 3462
		}
#line 3462
		}
#line 3462

#line 3462
		isp->sign = vsp->sign;
#line 3462

		tp++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++) {
		int lstatus = ncx_put_float_float(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3483
ncx_putn_float_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3483
{
#line 3483
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3483

#line 3483
 /* basic algorithm is:
#line 3483
  *   - ensure sane alignment of output data
#line 3483
  *   - copy (conversion happens automatically) input data
#line 3483
  *     to output
#line 3483
  *   - update tp to point at next unconverted input, and xpp to point
#line 3483
  *     at next location for converted output
#line 3483
  */
#line 3483
  long i, j, ni;
#line 3483
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3483
  float *xp;
#line 3483
  int nrange = 0;         /* number of range errors */
#line 3483
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3483
  long cxp = (long) *((char**)xpp);
#line 3483

#line 3483
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3483
  /* sjl: manually stripmine so we can limit amount of
#line 3483
   * vector work space reserved to LOOPCNT elements. Also
#line 3483
   * makes vectorisation easy */
#line 3483
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3483
    ni=Min(nelems-j,LOOPCNT);
#line 3483
    if (realign) {
#line 3483
      xp = tmp;
#line 3483
    } else {
#line 3483
      xp = (float *) *xpp;
#line 3483
    }
#line 3483
   /* copy the next block */
#line 3483
#pragma cdir loopcnt=LOOPCNT
#line 3483
#pragma cdir shortloop
#line 3483
    for (i=0; i<ni; i++) {
#line 3483
      /* the normal case: */
#line 3483
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3483
     /* test for range errors (not always needed but do it anyway) */
#line 3483
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3483
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3483
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3483
    }
#line 3483
   /* copy workspace back if necessary */
#line 3483
    if (realign) {
#line 3483
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3483
      xp = (float *) *xpp;
#line 3483
    }
#line 3483
   /* update xpp and tp */
#line 3483
    xp += ni;
#line 3483
    tp += ni;
#line 3483
    *xpp = (void*)xp;
#line 3483
  }
#line 3483
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3483

#line 3483
#else   /* not SX */
#line 3483

#line 3483
	char *xp = (char *) *xpp;
#line 3483
	int status = NC_NOERR;
#line 3483

#line 3483
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3483
	{
#line 3483
		int lstatus = ncx_put_float_schar(xp, tp, fillp);
#line 3483
		if (status == NC_NOERR) /* report the first encountered error */
#line 3483
			status = lstatus;
#line 3483
	}
#line 3483

#line 3483
	*xpp = (void *)xp;
#line 3483
	return status;
#line 3483
#endif
#line 3483
}
#line 3483

int
#line 3484
ncx_putn_float_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3484
{
#line 3484
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3484

#line 3484
 /* basic algorithm is:
#line 3484
  *   - ensure sane alignment of output data
#line 3484
  *   - copy (conversion happens automatically) input data
#line 3484
  *     to output
#line 3484
  *   - update tp to point at next unconverted input, and xpp to point
#line 3484
  *     at next location for converted output
#line 3484
  */
#line 3484
  long i, j, ni;
#line 3484
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3484
  float *xp;
#line 3484
  int nrange = 0;         /* number of range errors */
#line 3484
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3484
  long cxp = (long) *((char**)xpp);
#line 3484

#line 3484
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3484
  /* sjl: manually stripmine so we can limit amount of
#line 3484
   * vector work space reserved to LOOPCNT elements. Also
#line 3484
   * makes vectorisation easy */
#line 3484
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3484
    ni=Min(nelems-j,LOOPCNT);
#line 3484
    if (realign) {
#line 3484
      xp = tmp;
#line 3484
    } else {
#line 3484
      xp = (float *) *xpp;
#line 3484
    }
#line 3484
   /* copy the next block */
#line 3484
#pragma cdir loopcnt=LOOPCNT
#line 3484
#pragma cdir shortloop
#line 3484
    for (i=0; i<ni; i++) {
#line 3484
      /* the normal case: */
#line 3484
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3484
     /* test for range errors (not always needed but do it anyway) */
#line 3484
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3484
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3484
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3484
    }
#line 3484
   /* copy workspace back if necessary */
#line 3484
    if (realign) {
#line 3484
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3484
      xp = (float *) *xpp;
#line 3484
    }
#line 3484
   /* update xpp and tp */
#line 3484
    xp += ni;
#line 3484
    tp += ni;
#line 3484
    *xpp = (void*)xp;
#line 3484
  }
#line 3484
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3484

#line 3484
#else   /* not SX */
#line 3484

#line 3484
	char *xp = (char *) *xpp;
#line 3484
	int status = NC_NOERR;
#line 3484

#line 3484
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3484
	{
#line 3484
		int lstatus = ncx_put_float_short(xp, tp, fillp);
#line 3484
		if (status == NC_NOERR) /* report the first encountered error */
#line 3484
			status = lstatus;
#line 3484
	}
#line 3484

#line 3484
	*xpp = (void *)xp;
#line 3484
	return status;
#line 3484
#endif
#line 3484
}
#line 3484

int
#line 3485
ncx_putn_float_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3485
{
#line 3485
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3485

#line 3485
 /* basic algorithm is:
#line 3485
  *   - ensure sane alignment of output data
#line 3485
  *   - copy (conversion happens automatically) input data
#line 3485
  *     to output
#line 3485
  *   - update tp to point at next unconverted input, and xpp to point
#line 3485
  *     at next location for converted output
#line 3485
  */
#line 3485
  long i, j, ni;
#line 3485
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3485
  float *xp;
#line 3485
  int nrange = 0;         /* number of range errors */
#line 3485
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3485
  long cxp = (long) *((char**)xpp);
#line 3485

#line 3485
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3485
  /* sjl: manually stripmine so we can limit amount of
#line 3485
   * vector work space reserved to LOOPCNT elements. Also
#line 3485
   * makes vectorisation easy */
#line 3485
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3485
    ni=Min(nelems-j,LOOPCNT);
#line 3485
    if (realign) {
#line 3485
      xp = tmp;
#line 3485
    } else {
#line 3485
      xp = (float *) *xpp;
#line 3485
    }
#line 3485
   /* copy the next block */
#line 3485
#pragma cdir loopcnt=LOOPCNT
#line 3485
#pragma cdir shortloop
#line 3485
    for (i=0; i<ni; i++) {
#line 3485
      /* the normal case: */
#line 3485
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3485
     /* test for range errors (not always needed but do it anyway) */
#line 3485
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3485
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3485
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3485
    }
#line 3485
   /* copy workspace back if necessary */
#line 3485
    if (realign) {
#line 3485
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3485
      xp = (float *) *xpp;
#line 3485
    }
#line 3485
   /* update xpp and tp */
#line 3485
    xp += ni;
#line 3485
    tp += ni;
#line 3485
    *xpp = (void*)xp;
#line 3485
  }
#line 3485
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3485

#line 3485
#else   /* not SX */
#line 3485

#line 3485
	char *xp = (char *) *xpp;
#line 3485
	int status = NC_NOERR;
#line 3485

#line 3485
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3485
	{
#line 3485
		int lstatus = ncx_put_float_int(xp, tp, fillp);
#line 3485
		if (status == NC_NOERR) /* report the first encountered error */
#line 3485
			status = lstatus;
#line 3485
	}
#line 3485

#line 3485
	*xpp = (void *)xp;
#line 3485
	return status;
#line 3485
#endif
#line 3485
}
#line 3485

int
#line 3486
ncx_putn_float_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3486
{
#line 3486
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3486

#line 3486
 /* basic algorithm is:
#line 3486
  *   - ensure sane alignment of output data
#line 3486
  *   - copy (conversion happens automatically) input data
#line 3486
  *     to output
#line 3486
  *   - update tp to point at next unconverted input, and xpp to point
#line 3486
  *     at next location for converted output
#line 3486
  */
#line 3486
  long i, j, ni;
#line 3486
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3486
  float *xp;
#line 3486
  int nrange = 0;         /* number of range errors */
#line 3486
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3486
  long cxp = (long) *((char**)xpp);
#line 3486

#line 3486
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3486
  /* sjl: manually stripmine so we can limit amount of
#line 3486
   * vector work space reserved to LOOPCNT elements. Also
#line 3486
   * makes vectorisation easy */
#line 3486
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3486
    ni=Min(nelems-j,LOOPCNT);
#line 3486
    if (realign) {
#line 3486
      xp = tmp;
#line 3486
    } else {
#line 3486
      xp = (float *) *xpp;
#line 3486
    }
#line 3486
   /* copy the next block */
#line 3486
#pragma cdir loopcnt=LOOPCNT
#line 3486
#pragma cdir shortloop
#line 3486
    for (i=0; i<ni; i++) {
#line 3486
      /* the normal case: */
#line 3486
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3486
     /* test for range errors (not always needed but do it anyway) */
#line 3486
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3486
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3486
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3486
    }
#line 3486
   /* copy workspace back if necessary */
#line 3486
    if (realign) {
#line 3486
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3486
      xp = (float *) *xpp;
#line 3486
    }
#line 3486
   /* update xpp and tp */
#line 3486
    xp += ni;
#line 3486
    tp += ni;
#line 3486
    *xpp = (void*)xp;
#line 3486
  }
#line 3486
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3486

#line 3486
#else   /* not SX */
#line 3486

#line 3486
	char *xp = (char *) *xpp;
#line 3486
	int status = NC_NOERR;
#line 3486

#line 3486
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3486
	{
#line 3486
		int lstatus = ncx_put_float_long(xp, tp, fillp);
#line 3486
		if (status == NC_NOERR) /* report the first encountered error */
#line 3486
			status = lstatus;
#line 3486
	}
#line 3486

#line 3486
	*xpp = (void *)xp;
#line 3486
	return status;
#line 3486
#endif
#line 3486
}
#line 3486

int
#line 3487
ncx_putn_float_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3487
{
#line 3487
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3487

#line 3487
 /* basic algorithm is:
#line 3487
  *   - ensure sane alignment of output data
#line 3487
  *   - copy (conversion happens automatically) input data
#line 3487
  *     to output
#line 3487
  *   - update tp to point at next unconverted input, and xpp to point
#line 3487
  *     at next location for converted output
#line 3487
  */
#line 3487
  long i, j, ni;
#line 3487
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3487
  float *xp;
#line 3487
  int nrange = 0;         /* number of range errors */
#line 3487
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3487
  long cxp = (long) *((char**)xpp);
#line 3487

#line 3487
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3487
  /* sjl: manually stripmine so we can limit amount of
#line 3487
   * vector work space reserved to LOOPCNT elements. Also
#line 3487
   * makes vectorisation easy */
#line 3487
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3487
    ni=Min(nelems-j,LOOPCNT);
#line 3487
    if (realign) {
#line 3487
      xp = tmp;
#line 3487
    } else {
#line 3487
      xp = (float *) *xpp;
#line 3487
    }
#line 3487
   /* copy the next block */
#line 3487
#pragma cdir loopcnt=LOOPCNT
#line 3487
#pragma cdir shortloop
#line 3487
    for (i=0; i<ni; i++) {
#line 3487
      /* the normal case: */
#line 3487
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3487
     /* test for range errors (not always needed but do it anyway) */
#line 3487
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3487
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3487
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3487
    }
#line 3487
   /* copy workspace back if necessary */
#line 3487
    if (realign) {
#line 3487
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3487
      xp = (float *) *xpp;
#line 3487
    }
#line 3487
   /* update xpp and tp */
#line 3487
    xp += ni;
#line 3487
    tp += ni;
#line 3487
    *xpp = (void*)xp;
#line 3487
  }
#line 3487
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3487

#line 3487
#else   /* not SX */
#line 3487

#line 3487
	char *xp = (char *) *xpp;
#line 3487
	int status = NC_NOERR;
#line 3487

#line 3487
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3487
	{
#line 3487
		int lstatus = ncx_put_float_double(xp, tp, fillp);
#line 3487
		if (status == NC_NOERR) /* report the first encountered error */
#line 3487
			status = lstatus;
#line 3487
	}
#line 3487

#line 3487
	*xpp = (void *)xp;
#line 3487
	return status;
#line 3487
#endif
#line 3487
}
#line 3487

int
#line 3488
ncx_putn_float_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3488
{
#line 3488
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3488

#line 3488
 /* basic algorithm is:
#line 3488
  *   - ensure sane alignment of output data
#line 3488
  *   - copy (conversion happens automatically) input data
#line 3488
  *     to output
#line 3488
  *   - update tp to point at next unconverted input, and xpp to point
#line 3488
  *     at next location for converted output
#line 3488
  */
#line 3488
  long i, j, ni;
#line 3488
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3488
  float *xp;
#line 3488
  int nrange = 0;         /* number of range errors */
#line 3488
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3488
  long cxp = (long) *((char**)xpp);
#line 3488

#line 3488
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3488
  /* sjl: manually stripmine so we can limit amount of
#line 3488
   * vector work space reserved to LOOPCNT elements. Also
#line 3488
   * makes vectorisation easy */
#line 3488
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3488
    ni=Min(nelems-j,LOOPCNT);
#line 3488
    if (realign) {
#line 3488
      xp = tmp;
#line 3488
    } else {
#line 3488
      xp = (float *) *xpp;
#line 3488
    }
#line 3488
   /* copy the next block */
#line 3488
#pragma cdir loopcnt=LOOPCNT
#line 3488
#pragma cdir shortloop
#line 3488
    for (i=0; i<ni; i++) {
#line 3488
      /* the normal case: */
#line 3488
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3488
     /* test for range errors (not always needed but do it anyway) */
#line 3488
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3488
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3488
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3488
    }
#line 3488
   /* copy workspace back if necessary */
#line 3488
    if (realign) {
#line 3488
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3488
      xp = (float *) *xpp;
#line 3488
    }
#line 3488
   /* update xpp and tp */
#line 3488
    xp += ni;
#line 3488
    tp += ni;
#line 3488
    *xpp = (void*)xp;
#line 3488
  }
#line 3488
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3488

#line 3488
#else   /* not SX */
#line 3488

#line 3488
	char *xp = (char *) *xpp;
#line 3488
	int status = NC_NOERR;
#line 3488

#line 3488
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3488
	{
#line 3488
		int lstatus = ncx_put_float_longlong(xp, tp, fillp);
#line 3488
		if (status == NC_NOERR) /* report the first encountered error */
#line 3488
			status = lstatus;
#line 3488
	}
#line 3488

#line 3488
	*xpp = (void *)xp;
#line 3488
	return status;
#line 3488
#endif
#line 3488
}
#line 3488

int
#line 3489
ncx_putn_float_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3489
{
#line 3489
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3489

#line 3489
 /* basic algorithm is:
#line 3489
  *   - ensure sane alignment of output data
#line 3489
  *   - copy (conversion happens automatically) input data
#line 3489
  *     to output
#line 3489
  *   - update tp to point at next unconverted input, and xpp to point
#line 3489
  *     at next location for converted output
#line 3489
  */
#line 3489
  long i, j, ni;
#line 3489
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3489
  float *xp;
#line 3489
  int nrange = 0;         /* number of range errors */
#line 3489
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3489
  long cxp = (long) *((char**)xpp);
#line 3489

#line 3489
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3489
  /* sjl: manually stripmine so we can limit amount of
#line 3489
   * vector work space reserved to LOOPCNT elements. Also
#line 3489
   * makes vectorisation easy */
#line 3489
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3489
    ni=Min(nelems-j,LOOPCNT);
#line 3489
    if (realign) {
#line 3489
      xp = tmp;
#line 3489
    } else {
#line 3489
      xp = (float *) *xpp;
#line 3489
    }
#line 3489
   /* copy the next block */
#line 3489
#pragma cdir loopcnt=LOOPCNT
#line 3489
#pragma cdir shortloop
#line 3489
    for (i=0; i<ni; i++) {
#line 3489
      /* the normal case: */
#line 3489
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3489
     /* test for range errors (not always needed but do it anyway) */
#line 3489
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3489
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3489
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3489
    }
#line 3489
   /* copy workspace back if necessary */
#line 3489
    if (realign) {
#line 3489
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3489
      xp = (float *) *xpp;
#line 3489
    }
#line 3489
   /* update xpp and tp */
#line 3489
    xp += ni;
#line 3489
    tp += ni;
#line 3489
    *xpp = (void*)xp;
#line 3489
  }
#line 3489
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3489

#line 3489
#else   /* not SX */
#line 3489

#line 3489
	char *xp = (char *) *xpp;
#line 3489
	int status = NC_NOERR;
#line 3489

#line 3489
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3489
	{
#line 3489
		int lstatus = ncx_put_float_uchar(xp, tp, fillp);
#line 3489
		if (status == NC_NOERR) /* report the first encountered error */
#line 3489
			status = lstatus;
#line 3489
	}
#line 3489

#line 3489
	*xpp = (void *)xp;
#line 3489
	return status;
#line 3489
#endif
#line 3489
}
#line 3489

int
#line 3490
ncx_putn_float_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3490
{
#line 3490
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3490

#line 3490
 /* basic algorithm is:
#line 3490
  *   - ensure sane alignment of output data
#line 3490
  *   - copy (conversion happens automatically) input data
#line 3490
  *     to output
#line 3490
  *   - update tp to point at next unconverted input, and xpp to point
#line 3490
  *     at next location for converted output
#line 3490
  */
#line 3490
  long i, j, ni;
#line 3490
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3490
  float *xp;
#line 3490
  int nrange = 0;         /* number of range errors */
#line 3490
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3490
  long cxp = (long) *((char**)xpp);
#line 3490

#line 3490
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3490
  /* sjl: manually stripmine so we can limit amount of
#line 3490
   * vector work space reserved to LOOPCNT elements. Also
#line 3490
   * makes vectorisation easy */
#line 3490
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3490
    ni=Min(nelems-j,LOOPCNT);
#line 3490
    if (realign) {
#line 3490
      xp = tmp;
#line 3490
    } else {
#line 3490
      xp = (float *) *xpp;
#line 3490
    }
#line 3490
   /* copy the next block */
#line 3490
#pragma cdir loopcnt=LOOPCNT
#line 3490
#pragma cdir shortloop
#line 3490
    for (i=0; i<ni; i++) {
#line 3490
      /* the normal case: */
#line 3490
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3490
     /* test for range errors (not always needed but do it anyway) */
#line 3490
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3490
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3490
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3490
    }
#line 3490
   /* copy workspace back if necessary */
#line 3490
    if (realign) {
#line 3490
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3490
      xp = (float *) *xpp;
#line 3490
    }
#line 3490
   /* update xpp and tp */
#line 3490
    xp += ni;
#line 3490
    tp += ni;
#line 3490
    *xpp = (void*)xp;
#line 3490
  }
#line 3490
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3490

#line 3490
#else   /* not SX */
#line 3490

#line 3490
	char *xp = (char *) *xpp;
#line 3490
	int status = NC_NOERR;
#line 3490

#line 3490
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3490
	{
#line 3490
		int lstatus = ncx_put_float_ushort(xp, tp, fillp);
#line 3490
		if (status == NC_NOERR) /* report the first encountered error */
#line 3490
			status = lstatus;
#line 3490
	}
#line 3490

#line 3490
	*xpp = (void *)xp;
#line 3490
	return status;
#line 3490
#endif
#line 3490
}
#line 3490

int
#line 3491
ncx_putn_float_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3491
{
#line 3491
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3491

#line 3491
 /* basic algorithm is:
#line 3491
  *   - ensure sane alignment of output data
#line 3491
  *   - copy (conversion happens automatically) input data
#line 3491
  *     to output
#line 3491
  *   - update tp to point at next unconverted input, and xpp to point
#line 3491
  *     at next location for converted output
#line 3491
  */
#line 3491
  long i, j, ni;
#line 3491
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3491
  float *xp;
#line 3491
  int nrange = 0;         /* number of range errors */
#line 3491
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3491
  long cxp = (long) *((char**)xpp);
#line 3491

#line 3491
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3491
  /* sjl: manually stripmine so we can limit amount of
#line 3491
   * vector work space reserved to LOOPCNT elements. Also
#line 3491
   * makes vectorisation easy */
#line 3491
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3491
    ni=Min(nelems-j,LOOPCNT);
#line 3491
    if (realign) {
#line 3491
      xp = tmp;
#line 3491
    } else {
#line 3491
      xp = (float *) *xpp;
#line 3491
    }
#line 3491
   /* copy the next block */
#line 3491
#pragma cdir loopcnt=LOOPCNT
#line 3491
#pragma cdir shortloop
#line 3491
    for (i=0; i<ni; i++) {
#line 3491
      /* the normal case: */
#line 3491
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3491
     /* test for range errors (not always needed but do it anyway) */
#line 3491
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3491
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3491
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3491
    }
#line 3491
   /* copy workspace back if necessary */
#line 3491
    if (realign) {
#line 3491
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3491
      xp = (float *) *xpp;
#line 3491
    }
#line 3491
   /* update xpp and tp */
#line 3491
    xp += ni;
#line 3491
    tp += ni;
#line 3491
    *xpp = (void*)xp;
#line 3491
  }
#line 3491
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3491

#line 3491
#else   /* not SX */
#line 3491

#line 3491
	char *xp = (char *) *xpp;
#line 3491
	int status = NC_NOERR;
#line 3491

#line 3491
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3491
	{
#line 3491
		int lstatus = ncx_put_float_uint(xp, tp, fillp);
#line 3491
		if (status == NC_NOERR) /* report the first encountered error */
#line 3491
			status = lstatus;
#line 3491
	}
#line 3491

#line 3491
	*xpp = (void *)xp;
#line 3491
	return status;
#line 3491
#endif
#line 3491
}
#line 3491

int
#line 3492
ncx_putn_float_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3492
{
#line 3492
#if defined(_SX) && _SX != 0 && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3492

#line 3492
 /* basic algorithm is:
#line 3492
  *   - ensure sane alignment of output data
#line 3492
  *   - copy (conversion happens automatically) input data
#line 3492
  *     to output
#line 3492
  *   - update tp to point at next unconverted input, and xpp to point
#line 3492
  *     at next location for converted output
#line 3492
  */
#line 3492
  long i, j, ni;
#line 3492
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3492
  float *xp;
#line 3492
  int nrange = 0;         /* number of range errors */
#line 3492
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3492
  long cxp = (long) *((char**)xpp);
#line 3492

#line 3492
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3492
  /* sjl: manually stripmine so we can limit amount of
#line 3492
   * vector work space reserved to LOOPCNT elements. Also
#line 3492
   * makes vectorisation easy */
#line 3492
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3492
    ni=Min(nelems-j,LOOPCNT);
#line 3492
    if (realign) {
#line 3492
      xp = tmp;
#line 3492
    } else {
#line 3492
      xp = (float *) *xpp;
#line 3492
    }
#line 3492
   /* copy the next block */
#line 3492
#pragma cdir loopcnt=LOOPCNT
#line 3492
#pragma cdir shortloop
#line 3492
    for (i=0; i<ni; i++) {
#line 3492
      /* the normal case: */
#line 3492
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3492
     /* test for range errors (not always needed but do it anyway) */
#line 3492
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3492
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3492
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3492
    }
#line 3492
   /* copy workspace back if necessary */
#line 3492
    if (realign) {
#line 3492
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_FLOAT);
#line 3492
      xp = (float *) *xpp;
#line 3492
    }
#line 3492
   /* update xpp and tp */
#line 3492
    xp += ni;
#line 3492
    tp += ni;
#line 3492
    *xpp = (void*)xp;
#line 3492
  }
#line 3492
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3492

#line 3492
#else   /* not SX */
#line 3492

#line 3492
	char *xp = (char *) *xpp;
#line 3492
	int status = NC_NOERR;
#line 3492

#line 3492
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3492
	{
#line 3492
		int lstatus = ncx_put_float_ulonglong(xp, tp, fillp);
#line 3492
		if (status == NC_NOERR) /* report the first encountered error */
#line 3492
			status = lstatus;
#line 3492
	}
#line 3492

#line 3492
	*xpp = (void *)xp;
#line 3492
	return status;
#line 3492
#endif
#line 3492
}
#line 3492


/* double --------------------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_DOUBLE);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_getn_double_double(const void **xpp, size_t ndoubles, double *ip)
{
	double *const end = ip + ndoubles;

	while (ip < end)
	{
	struct vax_double *const vdp =
#line 3517
			 (struct vax_double *)ip;
#line 3517
	const struct ieee_double *const idp =
#line 3517
			 (const struct ieee_double *) (*xpp);
#line 3517
	{
#line 3517
		const struct dbl_limits *lim;
#line 3517
		int ii;
#line 3517
		for (ii = 0, lim = dbl_limits;
#line 3517
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 3517
			ii++, lim++)
#line 3517
		{
#line 3517
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 3517
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 3517
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 3517
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 3517
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 3517
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 3517
				)
#line 3517
			{
#line 3517
				*vdp = lim->d;
#line 3517
				goto doneit;
#line 3517
			}
#line 3517
		}
#line 3517
	}
#line 3517
	{
#line 3517
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 3517
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 3517
	}
#line 3517
	{
#line 3517
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 3517
				 | (idp->mant_5 << 8)
#line 3517
				 | idp->mant_4);
#line 3517
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 3517
		vdp->mantissa1 = (mant_hi >> 13);
#line 3517
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 3517
				| (mant_lo >> 29);
#line 3517
		vdp->mantissa3 = (mant_lo >> 13);
#line 3517
		vdp->mantissa4 = (mant_lo << 3);
#line 3517
	}
#line 3517
	doneit:
#line 3517
		vdp->sign = idp->sign;
#line 3517

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}
#endif
int
#line 3542
ncx_getn_double_schar(const void **xpp, size_t nelems, schar *tp)
#line 3542
{
#line 3542
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3542

#line 3542
 /* basic algorithm is:
#line 3542
  *   - ensure sane alignment of input data
#line 3542
  *   - copy (conversion happens automatically) input data
#line 3542
  *     to output
#line 3542
  *   - update xpp to point at next unconverted input, and tp to point
#line 3542
  *     at next location for converted output
#line 3542
  */
#line 3542
  long i, j, ni;
#line 3542
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3542
  double *xp;
#line 3542
  int nrange = 0;         /* number of range errors */
#line 3542
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3542
  long cxp = (long) *((char**)xpp);
#line 3542

#line 3542
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3542
  /* sjl: manually stripmine so we can limit amount of
#line 3542
   * vector work space reserved to LOOPCNT elements. Also
#line 3542
   * makes vectorisation easy */
#line 3542
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3542
    ni=Min(nelems-j,LOOPCNT);
#line 3542
    if (realign) {
#line 3542
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3542
      xp = tmp;
#line 3542
    } else {
#line 3542
      xp = (double *) *xpp;
#line 3542
    }
#line 3542
   /* copy the next block */
#line 3542
#pragma cdir loopcnt=LOOPCNT
#line 3542
#pragma cdir shortloop
#line 3542
    for (i=0; i<ni; i++) {
#line 3542
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3542
     /* test for range errors (not always needed but do it anyway) */
#line 3542
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3542
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3542
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3542
    }
#line 3542
   /* update xpp and tp */
#line 3542
    if (realign) xp = (double *) *xpp;
#line 3542
    xp += ni;
#line 3542
    tp += ni;
#line 3542
    *xpp = (void*)xp;
#line 3542
  }
#line 3542
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3542

#line 3542
#else   /* not SX */
#line 3542
	const char *xp = (const char *) *xpp;
#line 3542
	int status = NC_NOERR;
#line 3542

#line 3542
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3542
	{
#line 3542
		const int lstatus = ncx_get_double_schar(xp, tp);
#line 3542
		if (status == NC_NOERR) /* report the first encountered error */
#line 3542
			status = lstatus;
#line 3542
	}
#line 3542

#line 3542
	*xpp = (const void *)xp;
#line 3542
	return status;
#line 3542
#endif
#line 3542
}
#line 3542

int
#line 3543
ncx_getn_double_short(const void **xpp, size_t nelems, short *tp)
#line 3543
{
#line 3543
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3543

#line 3543
 /* basic algorithm is:
#line 3543
  *   - ensure sane alignment of input data
#line 3543
  *   - copy (conversion happens automatically) input data
#line 3543
  *     to output
#line 3543
  *   - update xpp to point at next unconverted input, and tp to point
#line 3543
  *     at next location for converted output
#line 3543
  */
#line 3543
  long i, j, ni;
#line 3543
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3543
  double *xp;
#line 3543
  int nrange = 0;         /* number of range errors */
#line 3543
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3543
  long cxp = (long) *((char**)xpp);
#line 3543

#line 3543
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3543
  /* sjl: manually stripmine so we can limit amount of
#line 3543
   * vector work space reserved to LOOPCNT elements. Also
#line 3543
   * makes vectorisation easy */
#line 3543
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3543
    ni=Min(nelems-j,LOOPCNT);
#line 3543
    if (realign) {
#line 3543
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3543
      xp = tmp;
#line 3543
    } else {
#line 3543
      xp = (double *) *xpp;
#line 3543
    }
#line 3543
   /* copy the next block */
#line 3543
#pragma cdir loopcnt=LOOPCNT
#line 3543
#pragma cdir shortloop
#line 3543
    for (i=0; i<ni; i++) {
#line 3543
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3543
     /* test for range errors (not always needed but do it anyway) */
#line 3543
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3543
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3543
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3543
    }
#line 3543
   /* update xpp and tp */
#line 3543
    if (realign) xp = (double *) *xpp;
#line 3543
    xp += ni;
#line 3543
    tp += ni;
#line 3543
    *xpp = (void*)xp;
#line 3543
  }
#line 3543
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3543

#line 3543
#else   /* not SX */
#line 3543
	const char *xp = (const char *) *xpp;
#line 3543
	int status = NC_NOERR;
#line 3543

#line 3543
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3543
	{
#line 3543
		const int lstatus = ncx_get_double_short(xp, tp);
#line 3543
		if (status == NC_NOERR) /* report the first encountered error */
#line 3543
			status = lstatus;
#line 3543
	}
#line 3543

#line 3543
	*xpp = (const void *)xp;
#line 3543
	return status;
#line 3543
#endif
#line 3543
}
#line 3543

int
#line 3544
ncx_getn_double_int(const void **xpp, size_t nelems, int *tp)
#line 3544
{
#line 3544
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3544

#line 3544
 /* basic algorithm is:
#line 3544
  *   - ensure sane alignment of input data
#line 3544
  *   - copy (conversion happens automatically) input data
#line 3544
  *     to output
#line 3544
  *   - update xpp to point at next unconverted input, and tp to point
#line 3544
  *     at next location for converted output
#line 3544
  */
#line 3544
  long i, j, ni;
#line 3544
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3544
  double *xp;
#line 3544
  int nrange = 0;         /* number of range errors */
#line 3544
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3544
  long cxp = (long) *((char**)xpp);
#line 3544

#line 3544
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3544
  /* sjl: manually stripmine so we can limit amount of
#line 3544
   * vector work space reserved to LOOPCNT elements. Also
#line 3544
   * makes vectorisation easy */
#line 3544
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3544
    ni=Min(nelems-j,LOOPCNT);
#line 3544
    if (realign) {
#line 3544
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3544
      xp = tmp;
#line 3544
    } else {
#line 3544
      xp = (double *) *xpp;
#line 3544
    }
#line 3544
   /* copy the next block */
#line 3544
#pragma cdir loopcnt=LOOPCNT
#line 3544
#pragma cdir shortloop
#line 3544
    for (i=0; i<ni; i++) {
#line 3544
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3544
     /* test for range errors (not always needed but do it anyway) */
#line 3544
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3544
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3544
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3544
    }
#line 3544
   /* update xpp and tp */
#line 3544
    if (realign) xp = (double *) *xpp;
#line 3544
    xp += ni;
#line 3544
    tp += ni;
#line 3544
    *xpp = (void*)xp;
#line 3544
  }
#line 3544
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3544

#line 3544
#else   /* not SX */
#line 3544
	const char *xp = (const char *) *xpp;
#line 3544
	int status = NC_NOERR;
#line 3544

#line 3544
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3544
	{
#line 3544
		const int lstatus = ncx_get_double_int(xp, tp);
#line 3544
		if (status == NC_NOERR) /* report the first encountered error */
#line 3544
			status = lstatus;
#line 3544
	}
#line 3544

#line 3544
	*xpp = (const void *)xp;
#line 3544
	return status;
#line 3544
#endif
#line 3544
}
#line 3544

int
#line 3545
ncx_getn_double_long(const void **xpp, size_t nelems, long *tp)
#line 3545
{
#line 3545
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3545

#line 3545
 /* basic algorithm is:
#line 3545
  *   - ensure sane alignment of input data
#line 3545
  *   - copy (conversion happens automatically) input data
#line 3545
  *     to output
#line 3545
  *   - update xpp to point at next unconverted input, and tp to point
#line 3545
  *     at next location for converted output
#line 3545
  */
#line 3545
  long i, j, ni;
#line 3545
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3545
  double *xp;
#line 3545
  int nrange = 0;         /* number of range errors */
#line 3545
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3545
  long cxp = (long) *((char**)xpp);
#line 3545

#line 3545
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3545
  /* sjl: manually stripmine so we can limit amount of
#line 3545
   * vector work space reserved to LOOPCNT elements. Also
#line 3545
   * makes vectorisation easy */
#line 3545
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3545
    ni=Min(nelems-j,LOOPCNT);
#line 3545
    if (realign) {
#line 3545
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3545
      xp = tmp;
#line 3545
    } else {
#line 3545
      xp = (double *) *xpp;
#line 3545
    }
#line 3545
   /* copy the next block */
#line 3545
#pragma cdir loopcnt=LOOPCNT
#line 3545
#pragma cdir shortloop
#line 3545
    for (i=0; i<ni; i++) {
#line 3545
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3545
     /* test for range errors (not always needed but do it anyway) */
#line 3545
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3545
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3545
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3545
    }
#line 3545
   /* update xpp and tp */
#line 3545
    if (realign) xp = (double *) *xpp;
#line 3545
    xp += ni;
#line 3545
    tp += ni;
#line 3545
    *xpp = (void*)xp;
#line 3545
  }
#line 3545
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3545

#line 3545
#else   /* not SX */
#line 3545
	const char *xp = (const char *) *xpp;
#line 3545
	int status = NC_NOERR;
#line 3545

#line 3545
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3545
	{
#line 3545
		const int lstatus = ncx_get_double_long(xp, tp);
#line 3545
		if (status == NC_NOERR) /* report the first encountered error */
#line 3545
			status = lstatus;
#line 3545
	}
#line 3545

#line 3545
	*xpp = (const void *)xp;
#line 3545
	return status;
#line 3545
#endif
#line 3545
}
#line 3545

int
#line 3546
ncx_getn_double_float(const void **xpp, size_t nelems, float *tp)
#line 3546
{
#line 3546
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3546

#line 3546
 /* basic algorithm is:
#line 3546
  *   - ensure sane alignment of input data
#line 3546
  *   - copy (conversion happens automatically) input data
#line 3546
  *     to output
#line 3546
  *   - update xpp to point at next unconverted input, and tp to point
#line 3546
  *     at next location for converted output
#line 3546
  */
#line 3546
  long i, j, ni;
#line 3546
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3546
  double *xp;
#line 3546
  int nrange = 0;         /* number of range errors */
#line 3546
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3546
  long cxp = (long) *((char**)xpp);
#line 3546

#line 3546
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3546
  /* sjl: manually stripmine so we can limit amount of
#line 3546
   * vector work space reserved to LOOPCNT elements. Also
#line 3546
   * makes vectorisation easy */
#line 3546
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3546
    ni=Min(nelems-j,LOOPCNT);
#line 3546
    if (realign) {
#line 3546
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3546
      xp = tmp;
#line 3546
    } else {
#line 3546
      xp = (double *) *xpp;
#line 3546
    }
#line 3546
   /* copy the next block */
#line 3546
#pragma cdir loopcnt=LOOPCNT
#line 3546
#pragma cdir shortloop
#line 3546
    for (i=0; i<ni; i++) {
#line 3546
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3546
     /* test for range errors (not always needed but do it anyway) */
#line 3546
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3546
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3546
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3546
    }
#line 3546
   /* update xpp and tp */
#line 3546
    if (realign) xp = (double *) *xpp;
#line 3546
    xp += ni;
#line 3546
    tp += ni;
#line 3546
    *xpp = (void*)xp;
#line 3546
  }
#line 3546
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3546

#line 3546
#else   /* not SX */
#line 3546
	const char *xp = (const char *) *xpp;
#line 3546
	int status = NC_NOERR;
#line 3546

#line 3546
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3546
	{
#line 3546
		const int lstatus = ncx_get_double_float(xp, tp);
#line 3546
		if (status == NC_NOERR) /* report the first encountered error */
#line 3546
			status = lstatus;
#line 3546
	}
#line 3546

#line 3546
	*xpp = (const void *)xp;
#line 3546
	return status;
#line 3546
#endif
#line 3546
}
#line 3546

int
#line 3547
ncx_getn_double_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3547
{
#line 3547
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3547

#line 3547
 /* basic algorithm is:
#line 3547
  *   - ensure sane alignment of input data
#line 3547
  *   - copy (conversion happens automatically) input data
#line 3547
  *     to output
#line 3547
  *   - update xpp to point at next unconverted input, and tp to point
#line 3547
  *     at next location for converted output
#line 3547
  */
#line 3547
  long i, j, ni;
#line 3547
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3547
  double *xp;
#line 3547
  int nrange = 0;         /* number of range errors */
#line 3547
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3547
  long cxp = (long) *((char**)xpp);
#line 3547

#line 3547
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3547
  /* sjl: manually stripmine so we can limit amount of
#line 3547
   * vector work space reserved to LOOPCNT elements. Also
#line 3547
   * makes vectorisation easy */
#line 3547
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3547
    ni=Min(nelems-j,LOOPCNT);
#line 3547
    if (realign) {
#line 3547
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3547
      xp = tmp;
#line 3547
    } else {
#line 3547
      xp = (double *) *xpp;
#line 3547
    }
#line 3547
   /* copy the next block */
#line 3547
#pragma cdir loopcnt=LOOPCNT
#line 3547
#pragma cdir shortloop
#line 3547
    for (i=0; i<ni; i++) {
#line 3547
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3547
     /* test for range errors (not always needed but do it anyway) */
#line 3547
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3547
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3547
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3547
    }
#line 3547
   /* update xpp and tp */
#line 3547
    if (realign) xp = (double *) *xpp;
#line 3547
    xp += ni;
#line 3547
    tp += ni;
#line 3547
    *xpp = (void*)xp;
#line 3547
  }
#line 3547
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3547

#line 3547
#else   /* not SX */
#line 3547
	const char *xp = (const char *) *xpp;
#line 3547
	int status = NC_NOERR;
#line 3547

#line 3547
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3547
	{
#line 3547
		const int lstatus = ncx_get_double_longlong(xp, tp);
#line 3547
		if (status == NC_NOERR) /* report the first encountered error */
#line 3547
			status = lstatus;
#line 3547
	}
#line 3547

#line 3547
	*xpp = (const void *)xp;
#line 3547
	return status;
#line 3547
#endif
#line 3547
}
#line 3547

int
#line 3548
ncx_getn_double_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3548
{
#line 3548
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3548

#line 3548
 /* basic algorithm is:
#line 3548
  *   - ensure sane alignment of input data
#line 3548
  *   - copy (conversion happens automatically) input data
#line 3548
  *     to output
#line 3548
  *   - update xpp to point at next unconverted input, and tp to point
#line 3548
  *     at next location for converted output
#line 3548
  */
#line 3548
  long i, j, ni;
#line 3548
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3548
  double *xp;
#line 3548
  int nrange = 0;         /* number of range errors */
#line 3548
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3548
  long cxp = (long) *((char**)xpp);
#line 3548

#line 3548
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3548
  /* sjl: manually stripmine so we can limit amount of
#line 3548
   * vector work space reserved to LOOPCNT elements. Also
#line 3548
   * makes vectorisation easy */
#line 3548
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3548
    ni=Min(nelems-j,LOOPCNT);
#line 3548
    if (realign) {
#line 3548
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3548
      xp = tmp;
#line 3548
    } else {
#line 3548
      xp = (double *) *xpp;
#line 3548
    }
#line 3548
   /* copy the next block */
#line 3548
#pragma cdir loopcnt=LOOPCNT
#line 3548
#pragma cdir shortloop
#line 3548
    for (i=0; i<ni; i++) {
#line 3548
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3548
     /* test for range errors (not always needed but do it anyway) */
#line 3548
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3548
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3548
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3548
    }
#line 3548
   /* update xpp and tp */
#line 3548
    if (realign) xp = (double *) *xpp;
#line 3548
    xp += ni;
#line 3548
    tp += ni;
#line 3548
    *xpp = (void*)xp;
#line 3548
  }
#line 3548
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3548

#line 3548
#else   /* not SX */
#line 3548
	const char *xp = (const char *) *xpp;
#line 3548
	int status = NC_NOERR;
#line 3548

#line 3548
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3548
	{
#line 3548
		const int lstatus = ncx_get_double_uchar(xp, tp);
#line 3548
		if (status == NC_NOERR) /* report the first encountered error */
#line 3548
			status = lstatus;
#line 3548
	}
#line 3548

#line 3548
	*xpp = (const void *)xp;
#line 3548
	return status;
#line 3548
#endif
#line 3548
}
#line 3548

int
#line 3549
ncx_getn_double_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3549
{
#line 3549
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3549

#line 3549
 /* basic algorithm is:
#line 3549
  *   - ensure sane alignment of input data
#line 3549
  *   - copy (conversion happens automatically) input data
#line 3549
  *     to output
#line 3549
  *   - update xpp to point at next unconverted input, and tp to point
#line 3549
  *     at next location for converted output
#line 3549
  */
#line 3549
  long i, j, ni;
#line 3549
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3549
  double *xp;
#line 3549
  int nrange = 0;         /* number of range errors */
#line 3549
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3549
  long cxp = (long) *((char**)xpp);
#line 3549

#line 3549
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3549
  /* sjl: manually stripmine so we can limit amount of
#line 3549
   * vector work space reserved to LOOPCNT elements. Also
#line 3549
   * makes vectorisation easy */
#line 3549
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3549
    ni=Min(nelems-j,LOOPCNT);
#line 3549
    if (realign) {
#line 3549
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3549
      xp = tmp;
#line 3549
    } else {
#line 3549
      xp = (double *) *xpp;
#line 3549
    }
#line 3549
   /* copy the next block */
#line 3549
#pragma cdir loopcnt=LOOPCNT
#line 3549
#pragma cdir shortloop
#line 3549
    for (i=0; i<ni; i++) {
#line 3549
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3549
     /* test for range errors (not always needed but do it anyway) */
#line 3549
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3549
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3549
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3549
    }
#line 3549
   /* update xpp and tp */
#line 3549
    if (realign) xp = (double *) *xpp;
#line 3549
    xp += ni;
#line 3549
    tp += ni;
#line 3549
    *xpp = (void*)xp;
#line 3549
  }
#line 3549
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3549

#line 3549
#else   /* not SX */
#line 3549
	const char *xp = (const char *) *xpp;
#line 3549
	int status = NC_NOERR;
#line 3549

#line 3549
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3549
	{
#line 3549
		const int lstatus = ncx_get_double_ushort(xp, tp);
#line 3549
		if (status == NC_NOERR) /* report the first encountered error */
#line 3549
			status = lstatus;
#line 3549
	}
#line 3549

#line 3549
	*xpp = (const void *)xp;
#line 3549
	return status;
#line 3549
#endif
#line 3549
}
#line 3549

int
#line 3550
ncx_getn_double_uint(const void **xpp, size_t nelems, uint *tp)
#line 3550
{
#line 3550
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3550

#line 3550
 /* basic algorithm is:
#line 3550
  *   - ensure sane alignment of input data
#line 3550
  *   - copy (conversion happens automatically) input data
#line 3550
  *     to output
#line 3550
  *   - update xpp to point at next unconverted input, and tp to point
#line 3550
  *     at next location for converted output
#line 3550
  */
#line 3550
  long i, j, ni;
#line 3550
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3550
  double *xp;
#line 3550
  int nrange = 0;         /* number of range errors */
#line 3550
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3550
  long cxp = (long) *((char**)xpp);
#line 3550

#line 3550
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3550
  /* sjl: manually stripmine so we can limit amount of
#line 3550
   * vector work space reserved to LOOPCNT elements. Also
#line 3550
   * makes vectorisation easy */
#line 3550
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3550
    ni=Min(nelems-j,LOOPCNT);
#line 3550
    if (realign) {
#line 3550
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3550
      xp = tmp;
#line 3550
    } else {
#line 3550
      xp = (double *) *xpp;
#line 3550
    }
#line 3550
   /* copy the next block */
#line 3550
#pragma cdir loopcnt=LOOPCNT
#line 3550
#pragma cdir shortloop
#line 3550
    for (i=0; i<ni; i++) {
#line 3550
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3550
     /* test for range errors (not always needed but do it anyway) */
#line 3550
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3550
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3550
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3550
    }
#line 3550
   /* update xpp and tp */
#line 3550
    if (realign) xp = (double *) *xpp;
#line 3550
    xp += ni;
#line 3550
    tp += ni;
#line 3550
    *xpp = (void*)xp;
#line 3550
  }
#line 3550
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3550

#line 3550
#else   /* not SX */
#line 3550
	const char *xp = (const char *) *xpp;
#line 3550
	int status = NC_NOERR;
#line 3550

#line 3550
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3550
	{
#line 3550
		const int lstatus = ncx_get_double_uint(xp, tp);
#line 3550
		if (status == NC_NOERR) /* report the first encountered error */
#line 3550
			status = lstatus;
#line 3550
	}
#line 3550

#line 3550
	*xpp = (const void *)xp;
#line 3550
	return status;
#line 3550
#endif
#line 3550
}
#line 3550

int
#line 3551
ncx_getn_double_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3551
{
#line 3551
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3551

#line 3551
 /* basic algorithm is:
#line 3551
  *   - ensure sane alignment of input data
#line 3551
  *   - copy (conversion happens automatically) input data
#line 3551
  *     to output
#line 3551
  *   - update xpp to point at next unconverted input, and tp to point
#line 3551
  *     at next location for converted output
#line 3551
  */
#line 3551
  long i, j, ni;
#line 3551
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3551
  double *xp;
#line 3551
  int nrange = 0;         /* number of range errors */
#line 3551
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3551
  long cxp = (long) *((char**)xpp);
#line 3551

#line 3551
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3551
  /* sjl: manually stripmine so we can limit amount of
#line 3551
   * vector work space reserved to LOOPCNT elements. Also
#line 3551
   * makes vectorisation easy */
#line 3551
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3551
    ni=Min(nelems-j,LOOPCNT);
#line 3551
    if (realign) {
#line 3551
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_DOUBLE));
#line 3551
      xp = tmp;
#line 3551
    } else {
#line 3551
      xp = (double *) *xpp;
#line 3551
    }
#line 3551
   /* copy the next block */
#line 3551
#pragma cdir loopcnt=LOOPCNT
#line 3551
#pragma cdir shortloop
#line 3551
    for (i=0; i<ni; i++) {
#line 3551
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3551
     /* test for range errors (not always needed but do it anyway) */
#line 3551
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3551
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3551
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3551
    }
#line 3551
   /* update xpp and tp */
#line 3551
    if (realign) xp = (double *) *xpp;
#line 3551
    xp += ni;
#line 3551
    tp += ni;
#line 3551
    *xpp = (void*)xp;
#line 3551
  }
#line 3551
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3551

#line 3551
#else   /* not SX */
#line 3551
	const char *xp = (const char *) *xpp;
#line 3551
	int status = NC_NOERR;
#line 3551

#line 3551
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3551
	{
#line 3551
		const int lstatus = ncx_get_double_ulonglong(xp, tp);
#line 3551
		if (status == NC_NOERR) /* report the first encountered error */
#line 3551
			status = lstatus;
#line 3551
	}
#line 3551

#line 3551
	*xpp = (const void *)xp;
#line 3551
	return status;
#line 3551
#endif
#line 3551
}
#line 3551


#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_DOUBLE);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif defined(vax) && vax != 0
int
ncx_putn_double_double(void **xpp, size_t ndoubles, const double *ip, void *fillp)
{
	const double *const end = ip + ndoubles;

	while (ip < end)
	{
	const struct vax_double *const vdp =
#line 3574
			(const struct vax_double *)ip;
#line 3574
	struct ieee_double *const idp =
#line 3574
			 (struct ieee_double *) (*xpp);
#line 3574

#line 3574
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 3574
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 3574
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 3574
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 3574
		(vdp->exp == dbl_limits[0].d.exp))
#line 3574
	{
#line 3574
		*idp = dbl_limits[0].ieee;
#line 3574
		goto shipit;
#line 3574
	}
#line 3574
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 3574
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 3574
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 3574
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 3574
		(vdp->exp == dbl_limits[1].d.exp))
#line 3574
	{
#line 3574
		*idp = dbl_limits[1].ieee;
#line 3574
		goto shipit;
#line 3574
	}
#line 3574

#line 3574
	{
#line 3574
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 3574

#line 3574
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 3574
			(vdp->mantissa3 << 13) |
#line 3574
			((vdp->mantissa4 >> 3) & MASK(13));
#line 3574

#line 3574
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 3574
				 | (vdp->mantissa2 >> 3);
#line 3574

#line 3574
		if ((vdp->mantissa4 & 7) > 4)
#line 3574
		{
#line 3574
			/* round up */
#line 3574
			mant_lo++;
#line 3574
			if (mant_lo == 0)
#line 3574
			{
#line 3574
				mant_hi++;
#line 3574
				if (mant_hi > 0xffffff)
#line 3574
				{
#line 3574
					mant_hi = 0;
#line 3574
					exp++;
#line 3574
				}
#line 3574
			}
#line 3574
		}
#line 3574

#line 3574
		idp->mant_lo = SWAP4(mant_lo);
#line 3574
		idp->mant_6 = mant_hi >> 16;
#line 3574
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 3574
		idp->mant_4 = mant_hi;
#line 3574
		idp->exp_hi = exp >> 4;
#line 3574
		idp->exp_lo = exp;
#line 3574
	}
#line 3574

#line 3574
	shipit:
#line 3574
		idp->sign = vdp->sign;
#line 3574

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp, void *fillp)
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_double(xp, tp, fillp);
		if (status == NC_NOERR) /* report the first encountered error */
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3599
ncx_putn_double_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3599
{
#line 3599
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3599

#line 3599
 /* basic algorithm is:
#line 3599
  *   - ensure sane alignment of output data
#line 3599
  *   - copy (conversion happens automatically) input data
#line 3599
  *     to output
#line 3599
  *   - update tp to point at next unconverted input, and xpp to point
#line 3599
  *     at next location for converted output
#line 3599
  */
#line 3599
  long i, j, ni;
#line 3599
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3599
  double *xp;
#line 3599
  int nrange = 0;         /* number of range errors */
#line 3599
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3599
  long cxp = (long) *((char**)xpp);
#line 3599

#line 3599
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3599
  /* sjl: manually stripmine so we can limit amount of
#line 3599
   * vector work space reserved to LOOPCNT elements. Also
#line 3599
   * makes vectorisation easy */
#line 3599
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3599
    ni=Min(nelems-j,LOOPCNT);
#line 3599
    if (realign) {
#line 3599
      xp = tmp;
#line 3599
    } else {
#line 3599
      xp = (double *) *xpp;
#line 3599
    }
#line 3599
   /* copy the next block */
#line 3599
#pragma cdir loopcnt=LOOPCNT
#line 3599
#pragma cdir shortloop
#line 3599
    for (i=0; i<ni; i++) {
#line 3599
      /* the normal case: */
#line 3599
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3599
     /* test for range errors (not always needed but do it anyway) */
#line 3599
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3599
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3599
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3599
    }
#line 3599
   /* copy workspace back if necessary */
#line 3599
    if (realign) {
#line 3599
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3599
      xp = (double *) *xpp;
#line 3599
    }
#line 3599
   /* update xpp and tp */
#line 3599
    xp += ni;
#line 3599
    tp += ni;
#line 3599
    *xpp = (void*)xp;
#line 3599
  }
#line 3599
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3599

#line 3599
#else   /* not SX */
#line 3599

#line 3599
	char *xp = (char *) *xpp;
#line 3599
	int status = NC_NOERR;
#line 3599

#line 3599
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3599
	{
#line 3599
		int lstatus = ncx_put_double_schar(xp, tp, fillp);
#line 3599
		if (status == NC_NOERR) /* report the first encountered error */
#line 3599
			status = lstatus;
#line 3599
	}
#line 3599

#line 3599
	*xpp = (void *)xp;
#line 3599
	return status;
#line 3599
#endif
#line 3599
}
#line 3599

int
#line 3600
ncx_putn_double_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3600
{
#line 3600
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3600

#line 3600
 /* basic algorithm is:
#line 3600
  *   - ensure sane alignment of output data
#line 3600
  *   - copy (conversion happens automatically) input data
#line 3600
  *     to output
#line 3600
  *   - update tp to point at next unconverted input, and xpp to point
#line 3600
  *     at next location for converted output
#line 3600
  */
#line 3600
  long i, j, ni;
#line 3600
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3600
  double *xp;
#line 3600
  int nrange = 0;         /* number of range errors */
#line 3600
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3600
  long cxp = (long) *((char**)xpp);
#line 3600

#line 3600
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3600
  /* sjl: manually stripmine so we can limit amount of
#line 3600
   * vector work space reserved to LOOPCNT elements. Also
#line 3600
   * makes vectorisation easy */
#line 3600
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3600
    ni=Min(nelems-j,LOOPCNT);
#line 3600
    if (realign) {
#line 3600
      xp = tmp;
#line 3600
    } else {
#line 3600
      xp = (double *) *xpp;
#line 3600
    }
#line 3600
   /* copy the next block */
#line 3600
#pragma cdir loopcnt=LOOPCNT
#line 3600
#pragma cdir shortloop
#line 3600
    for (i=0; i<ni; i++) {
#line 3600
      /* the normal case: */
#line 3600
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3600
     /* test for range errors (not always needed but do it anyway) */
#line 3600
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3600
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3600
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3600
    }
#line 3600
   /* copy workspace back if necessary */
#line 3600
    if (realign) {
#line 3600
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3600
      xp = (double *) *xpp;
#line 3600
    }
#line 3600
   /* update xpp and tp */
#line 3600
    xp += ni;
#line 3600
    tp += ni;
#line 3600
    *xpp = (void*)xp;
#line 3600
  }
#line 3600
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3600

#line 3600
#else   /* not SX */
#line 3600

#line 3600
	char *xp = (char *) *xpp;
#line 3600
	int status = NC_NOERR;
#line 3600

#line 3600
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3600
	{
#line 3600
		int lstatus = ncx_put_double_short(xp, tp, fillp);
#line 3600
		if (status == NC_NOERR) /* report the first encountered error */
#line 3600
			status = lstatus;
#line 3600
	}
#line 3600

#line 3600
	*xpp = (void *)xp;
#line 3600
	return status;
#line 3600
#endif
#line 3600
}
#line 3600

int
#line 3601
ncx_putn_double_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3601
{
#line 3601
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3601

#line 3601
 /* basic algorithm is:
#line 3601
  *   - ensure sane alignment of output data
#line 3601
  *   - copy (conversion happens automatically) input data
#line 3601
  *     to output
#line 3601
  *   - update tp to point at next unconverted input, and xpp to point
#line 3601
  *     at next location for converted output
#line 3601
  */
#line 3601
  long i, j, ni;
#line 3601
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3601
  double *xp;
#line 3601
  int nrange = 0;         /* number of range errors */
#line 3601
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3601
  long cxp = (long) *((char**)xpp);
#line 3601

#line 3601
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3601
  /* sjl: manually stripmine so we can limit amount of
#line 3601
   * vector work space reserved to LOOPCNT elements. Also
#line 3601
   * makes vectorisation easy */
#line 3601
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3601
    ni=Min(nelems-j,LOOPCNT);
#line 3601
    if (realign) {
#line 3601
      xp = tmp;
#line 3601
    } else {
#line 3601
      xp = (double *) *xpp;
#line 3601
    }
#line 3601
   /* copy the next block */
#line 3601
#pragma cdir loopcnt=LOOPCNT
#line 3601
#pragma cdir shortloop
#line 3601
    for (i=0; i<ni; i++) {
#line 3601
      /* the normal case: */
#line 3601
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3601
     /* test for range errors (not always needed but do it anyway) */
#line 3601
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3601
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3601
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3601
    }
#line 3601
   /* copy workspace back if necessary */
#line 3601
    if (realign) {
#line 3601
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3601
      xp = (double *) *xpp;
#line 3601
    }
#line 3601
   /* update xpp and tp */
#line 3601
    xp += ni;
#line 3601
    tp += ni;
#line 3601
    *xpp = (void*)xp;
#line 3601
  }
#line 3601
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3601

#line 3601
#else   /* not SX */
#line 3601

#line 3601
	char *xp = (char *) *xpp;
#line 3601
	int status = NC_NOERR;
#line 3601

#line 3601
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3601
	{
#line 3601
		int lstatus = ncx_put_double_int(xp, tp, fillp);
#line 3601
		if (status == NC_NOERR) /* report the first encountered error */
#line 3601
			status = lstatus;
#line 3601
	}
#line 3601

#line 3601
	*xpp = (void *)xp;
#line 3601
	return status;
#line 3601
#endif
#line 3601
}
#line 3601

int
#line 3602
ncx_putn_double_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3602
{
#line 3602
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3602

#line 3602
 /* basic algorithm is:
#line 3602
  *   - ensure sane alignment of output data
#line 3602
  *   - copy (conversion happens automatically) input data
#line 3602
  *     to output
#line 3602
  *   - update tp to point at next unconverted input, and xpp to point
#line 3602
  *     at next location for converted output
#line 3602
  */
#line 3602
  long i, j, ni;
#line 3602
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3602
  double *xp;
#line 3602
  int nrange = 0;         /* number of range errors */
#line 3602
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3602
  long cxp = (long) *((char**)xpp);
#line 3602

#line 3602
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3602
  /* sjl: manually stripmine so we can limit amount of
#line 3602
   * vector work space reserved to LOOPCNT elements. Also
#line 3602
   * makes vectorisation easy */
#line 3602
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3602
    ni=Min(nelems-j,LOOPCNT);
#line 3602
    if (realign) {
#line 3602
      xp = tmp;
#line 3602
    } else {
#line 3602
      xp = (double *) *xpp;
#line 3602
    }
#line 3602
   /* copy the next block */
#line 3602
#pragma cdir loopcnt=LOOPCNT
#line 3602
#pragma cdir shortloop
#line 3602
    for (i=0; i<ni; i++) {
#line 3602
      /* the normal case: */
#line 3602
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3602
     /* test for range errors (not always needed but do it anyway) */
#line 3602
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3602
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3602
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3602
    }
#line 3602
   /* copy workspace back if necessary */
#line 3602
    if (realign) {
#line 3602
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3602
      xp = (double *) *xpp;
#line 3602
    }
#line 3602
   /* update xpp and tp */
#line 3602
    xp += ni;
#line 3602
    tp += ni;
#line 3602
    *xpp = (void*)xp;
#line 3602
  }
#line 3602
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3602

#line 3602
#else   /* not SX */
#line 3602

#line 3602
	char *xp = (char *) *xpp;
#line 3602
	int status = NC_NOERR;
#line 3602

#line 3602
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3602
	{
#line 3602
		int lstatus = ncx_put_double_long(xp, tp, fillp);
#line 3602
		if (status == NC_NOERR) /* report the first encountered error */
#line 3602
			status = lstatus;
#line 3602
	}
#line 3602

#line 3602
	*xpp = (void *)xp;
#line 3602
	return status;
#line 3602
#endif
#line 3602
}
#line 3602

int
#line 3603
ncx_putn_double_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3603
{
#line 3603
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3603

#line 3603
 /* basic algorithm is:
#line 3603
  *   - ensure sane alignment of output data
#line 3603
  *   - copy (conversion happens automatically) input data
#line 3603
  *     to output
#line 3603
  *   - update tp to point at next unconverted input, and xpp to point
#line 3603
  *     at next location for converted output
#line 3603
  */
#line 3603
  long i, j, ni;
#line 3603
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3603
  double *xp;
#line 3603
  int nrange = 0;         /* number of range errors */
#line 3603
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3603
  long cxp = (long) *((char**)xpp);
#line 3603

#line 3603
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3603
  /* sjl: manually stripmine so we can limit amount of
#line 3603
   * vector work space reserved to LOOPCNT elements. Also
#line 3603
   * makes vectorisation easy */
#line 3603
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3603
    ni=Min(nelems-j,LOOPCNT);
#line 3603
    if (realign) {
#line 3603
      xp = tmp;
#line 3603
    } else {
#line 3603
      xp = (double *) *xpp;
#line 3603
    }
#line 3603
   /* copy the next block */
#line 3603
#pragma cdir loopcnt=LOOPCNT
#line 3603
#pragma cdir shortloop
#line 3603
    for (i=0; i<ni; i++) {
#line 3603
      /* the normal case: */
#line 3603
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3603
     /* test for range errors (not always needed but do it anyway) */
#line 3603
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3603
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3603
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3603
    }
#line 3603
   /* copy workspace back if necessary */
#line 3603
    if (realign) {
#line 3603
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3603
      xp = (double *) *xpp;
#line 3603
    }
#line 3603
   /* update xpp and tp */
#line 3603
    xp += ni;
#line 3603
    tp += ni;
#line 3603
    *xpp = (void*)xp;
#line 3603
  }
#line 3603
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3603

#line 3603
#else   /* not SX */
#line 3603

#line 3603
	char *xp = (char *) *xpp;
#line 3603
	int status = NC_NOERR;
#line 3603

#line 3603
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3603
	{
#line 3603
		int lstatus = ncx_put_double_float(xp, tp, fillp);
#line 3603
		if (status == NC_NOERR) /* report the first encountered error */
#line 3603
			status = lstatus;
#line 3603
	}
#line 3603

#line 3603
	*xpp = (void *)xp;
#line 3603
	return status;
#line 3603
#endif
#line 3603
}
#line 3603

int
#line 3604
ncx_putn_double_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3604
{
#line 3604
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3604

#line 3604
 /* basic algorithm is:
#line 3604
  *   - ensure sane alignment of output data
#line 3604
  *   - copy (conversion happens automatically) input data
#line 3604
  *     to output
#line 3604
  *   - update tp to point at next unconverted input, and xpp to point
#line 3604
  *     at next location for converted output
#line 3604
  */
#line 3604
  long i, j, ni;
#line 3604
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3604
  double *xp;
#line 3604
  int nrange = 0;         /* number of range errors */
#line 3604
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3604
  long cxp = (long) *((char**)xpp);
#line 3604

#line 3604
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3604
  /* sjl: manually stripmine so we can limit amount of
#line 3604
   * vector work space reserved to LOOPCNT elements. Also
#line 3604
   * makes vectorisation easy */
#line 3604
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3604
    ni=Min(nelems-j,LOOPCNT);
#line 3604
    if (realign) {
#line 3604
      xp = tmp;
#line 3604
    } else {
#line 3604
      xp = (double *) *xpp;
#line 3604
    }
#line 3604
   /* copy the next block */
#line 3604
#pragma cdir loopcnt=LOOPCNT
#line 3604
#pragma cdir shortloop
#line 3604
    for (i=0; i<ni; i++) {
#line 3604
      /* the normal case: */
#line 3604
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3604
     /* test for range errors (not always needed but do it anyway) */
#line 3604
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3604
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3604
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3604
    }
#line 3604
   /* copy workspace back if necessary */
#line 3604
    if (realign) {
#line 3604
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3604
      xp = (double *) *xpp;
#line 3604
    }
#line 3604
   /* update xpp and tp */
#line 3604
    xp += ni;
#line 3604
    tp += ni;
#line 3604
    *xpp = (void*)xp;
#line 3604
  }
#line 3604
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3604

#line 3604
#else   /* not SX */
#line 3604

#line 3604
	char *xp = (char *) *xpp;
#line 3604
	int status = NC_NOERR;
#line 3604

#line 3604
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3604
	{
#line 3604
		int lstatus = ncx_put_double_longlong(xp, tp, fillp);
#line 3604
		if (status == NC_NOERR) /* report the first encountered error */
#line 3604
			status = lstatus;
#line 3604
	}
#line 3604

#line 3604
	*xpp = (void *)xp;
#line 3604
	return status;
#line 3604
#endif
#line 3604
}
#line 3604

int
#line 3605
ncx_putn_double_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3605
{
#line 3605
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3605

#line 3605
 /* basic algorithm is:
#line 3605
  *   - ensure sane alignment of output data
#line 3605
  *   - copy (conversion happens automatically) input data
#line 3605
  *     to output
#line 3605
  *   - update tp to point at next unconverted input, and xpp to point
#line 3605
  *     at next location for converted output
#line 3605
  */
#line 3605
  long i, j, ni;
#line 3605
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3605
  double *xp;
#line 3605
  int nrange = 0;         /* number of range errors */
#line 3605
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3605
  long cxp = (long) *((char**)xpp);
#line 3605

#line 3605
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3605
  /* sjl: manually stripmine so we can limit amount of
#line 3605
   * vector work space reserved to LOOPCNT elements. Also
#line 3605
   * makes vectorisation easy */
#line 3605
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3605
    ni=Min(nelems-j,LOOPCNT);
#line 3605
    if (realign) {
#line 3605
      xp = tmp;
#line 3605
    } else {
#line 3605
      xp = (double *) *xpp;
#line 3605
    }
#line 3605
   /* copy the next block */
#line 3605
#pragma cdir loopcnt=LOOPCNT
#line 3605
#pragma cdir shortloop
#line 3605
    for (i=0; i<ni; i++) {
#line 3605
      /* the normal case: */
#line 3605
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3605
     /* test for range errors (not always needed but do it anyway) */
#line 3605
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3605
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3605
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3605
    }
#line 3605
   /* copy workspace back if necessary */
#line 3605
    if (realign) {
#line 3605
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3605
      xp = (double *) *xpp;
#line 3605
    }
#line 3605
   /* update xpp and tp */
#line 3605
    xp += ni;
#line 3605
    tp += ni;
#line 3605
    *xpp = (void*)xp;
#line 3605
  }
#line 3605
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3605

#line 3605
#else   /* not SX */
#line 3605

#line 3605
	char *xp = (char *) *xpp;
#line 3605
	int status = NC_NOERR;
#line 3605

#line 3605
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3605
	{
#line 3605
		int lstatus = ncx_put_double_uchar(xp, tp, fillp);
#line 3605
		if (status == NC_NOERR) /* report the first encountered error */
#line 3605
			status = lstatus;
#line 3605
	}
#line 3605

#line 3605
	*xpp = (void *)xp;
#line 3605
	return status;
#line 3605
#endif
#line 3605
}
#line 3605

int
#line 3606
ncx_putn_double_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3606
{
#line 3606
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3606

#line 3606
 /* basic algorithm is:
#line 3606
  *   - ensure sane alignment of output data
#line 3606
  *   - copy (conversion happens automatically) input data
#line 3606
  *     to output
#line 3606
  *   - update tp to point at next unconverted input, and xpp to point
#line 3606
  *     at next location for converted output
#line 3606
  */
#line 3606
  long i, j, ni;
#line 3606
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3606
  double *xp;
#line 3606
  int nrange = 0;         /* number of range errors */
#line 3606
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3606
  long cxp = (long) *((char**)xpp);
#line 3606

#line 3606
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3606
  /* sjl: manually stripmine so we can limit amount of
#line 3606
   * vector work space reserved to LOOPCNT elements. Also
#line 3606
   * makes vectorisation easy */
#line 3606
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3606
    ni=Min(nelems-j,LOOPCNT);
#line 3606
    if (realign) {
#line 3606
      xp = tmp;
#line 3606
    } else {
#line 3606
      xp = (double *) *xpp;
#line 3606
    }
#line 3606
   /* copy the next block */
#line 3606
#pragma cdir loopcnt=LOOPCNT
#line 3606
#pragma cdir shortloop
#line 3606
    for (i=0; i<ni; i++) {
#line 3606
      /* the normal case: */
#line 3606
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3606
     /* test for range errors (not always needed but do it anyway) */
#line 3606
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3606
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3606
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3606
    }
#line 3606
   /* copy workspace back if necessary */
#line 3606
    if (realign) {
#line 3606
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3606
      xp = (double *) *xpp;
#line 3606
    }
#line 3606
   /* update xpp and tp */
#line 3606
    xp += ni;
#line 3606
    tp += ni;
#line 3606
    *xpp = (void*)xp;
#line 3606
  }
#line 3606
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3606

#line 3606
#else   /* not SX */
#line 3606

#line 3606
	char *xp = (char *) *xpp;
#line 3606
	int status = NC_NOERR;
#line 3606

#line 3606
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3606
	{
#line 3606
		int lstatus = ncx_put_double_ushort(xp, tp, fillp);
#line 3606
		if (status == NC_NOERR) /* report the first encountered error */
#line 3606
			status = lstatus;
#line 3606
	}
#line 3606

#line 3606
	*xpp = (void *)xp;
#line 3606
	return status;
#line 3606
#endif
#line 3606
}
#line 3606

int
#line 3607
ncx_putn_double_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3607
{
#line 3607
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3607

#line 3607
 /* basic algorithm is:
#line 3607
  *   - ensure sane alignment of output data
#line 3607
  *   - copy (conversion happens automatically) input data
#line 3607
  *     to output
#line 3607
  *   - update tp to point at next unconverted input, and xpp to point
#line 3607
  *     at next location for converted output
#line 3607
  */
#line 3607
  long i, j, ni;
#line 3607
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3607
  double *xp;
#line 3607
  int nrange = 0;         /* number of range errors */
#line 3607
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3607
  long cxp = (long) *((char**)xpp);
#line 3607

#line 3607
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3607
  /* sjl: manually stripmine so we can limit amount of
#line 3607
   * vector work space reserved to LOOPCNT elements. Also
#line 3607
   * makes vectorisation easy */
#line 3607
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3607
    ni=Min(nelems-j,LOOPCNT);
#line 3607
    if (realign) {
#line 3607
      xp = tmp;
#line 3607
    } else {
#line 3607
      xp = (double *) *xpp;
#line 3607
    }
#line 3607
   /* copy the next block */
#line 3607
#pragma cdir loopcnt=LOOPCNT
#line 3607
#pragma cdir shortloop
#line 3607
    for (i=0; i<ni; i++) {
#line 3607
      /* the normal case: */
#line 3607
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3607
     /* test for range errors (not always needed but do it anyway) */
#line 3607
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3607
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3607
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3607
    }
#line 3607
   /* copy workspace back if necessary */
#line 3607
    if (realign) {
#line 3607
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3607
      xp = (double *) *xpp;
#line 3607
    }
#line 3607
   /* update xpp and tp */
#line 3607
    xp += ni;
#line 3607
    tp += ni;
#line 3607
    *xpp = (void*)xp;
#line 3607
  }
#line 3607
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3607

#line 3607
#else   /* not SX */
#line 3607

#line 3607
	char *xp = (char *) *xpp;
#line 3607
	int status = NC_NOERR;
#line 3607

#line 3607
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3607
	{
#line 3607
		int lstatus = ncx_put_double_uint(xp, tp, fillp);
#line 3607
		if (status == NC_NOERR) /* report the first encountered error */
#line 3607
			status = lstatus;
#line 3607
	}
#line 3607

#line 3607
	*xpp = (void *)xp;
#line 3607
	return status;
#line 3607
#endif
#line 3607
}
#line 3607

int
#line 3608
ncx_putn_double_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3608
{
#line 3608
#if defined(_SX) && _SX != 0 && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3608

#line 3608
 /* basic algorithm is:
#line 3608
  *   - ensure sane alignment of output data
#line 3608
  *   - copy (conversion happens automatically) input data
#line 3608
  *     to output
#line 3608
  *   - update tp to point at next unconverted input, and xpp to point
#line 3608
  *     at next location for converted output
#line 3608
  */
#line 3608
  long i, j, ni;
#line 3608
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3608
  double *xp;
#line 3608
  int nrange = 0;         /* number of range errors */
#line 3608
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3608
  long cxp = (long) *((char**)xpp);
#line 3608

#line 3608
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3608
  /* sjl: manually stripmine so we can limit amount of
#line 3608
   * vector work space reserved to LOOPCNT elements. Also
#line 3608
   * makes vectorisation easy */
#line 3608
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3608
    ni=Min(nelems-j,LOOPCNT);
#line 3608
    if (realign) {
#line 3608
      xp = tmp;
#line 3608
    } else {
#line 3608
      xp = (double *) *xpp;
#line 3608
    }
#line 3608
   /* copy the next block */
#line 3608
#pragma cdir loopcnt=LOOPCNT
#line 3608
#pragma cdir shortloop
#line 3608
    for (i=0; i<ni; i++) {
#line 3608
      /* the normal case: */
#line 3608
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3608
     /* test for range errors (not always needed but do it anyway) */
#line 3608
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3608
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3608
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3608
    }
#line 3608
   /* copy workspace back if necessary */
#line 3608
    if (realign) {
#line 3608
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_DOUBLE);
#line 3608
      xp = (double *) *xpp;
#line 3608
    }
#line 3608
   /* update xpp and tp */
#line 3608
    xp += ni;
#line 3608
    tp += ni;
#line 3608
    *xpp = (void*)xp;
#line 3608
  }
#line 3608
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3608

#line 3608
#else   /* not SX */
#line 3608

#line 3608
	char *xp = (char *) *xpp;
#line 3608
	int status = NC_NOERR;
#line 3608

#line 3608
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3608
	{
#line 3608
		int lstatus = ncx_put_double_ulonglong(xp, tp, fillp);
#line 3608
		if (status == NC_NOERR) /* report the first encountered error */
#line 3608
			status = lstatus;
#line 3608
	}
#line 3608

#line 3608
	*xpp = (void *)xp;
#line 3608
	return status;
#line 3608
#endif
#line 3608
}
#line 3608



/* longlong ------------------------------------------------------------------*/

#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3627
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3627
{
#line 3627
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3627

#line 3627
 /* basic algorithm is:
#line 3627
  *   - ensure sane alignment of input data
#line 3627
  *   - copy (conversion happens automatically) input data
#line 3627
  *     to output
#line 3627
  *   - update xpp to point at next unconverted input, and tp to point
#line 3627
  *     at next location for converted output
#line 3627
  */
#line 3627
  long i, j, ni;
#line 3627
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3627
  int64 *xp;
#line 3627
  int nrange = 0;         /* number of range errors */
#line 3627
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3627
  long cxp = (long) *((char**)xpp);
#line 3627

#line 3627
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3627
  /* sjl: manually stripmine so we can limit amount of
#line 3627
   * vector work space reserved to LOOPCNT elements. Also
#line 3627
   * makes vectorisation easy */
#line 3627
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3627
    ni=Min(nelems-j,LOOPCNT);
#line 3627
    if (realign) {
#line 3627
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3627
      xp = tmp;
#line 3627
    } else {
#line 3627
      xp = (int64 *) *xpp;
#line 3627
    }
#line 3627
   /* copy the next block */
#line 3627
#pragma cdir loopcnt=LOOPCNT
#line 3627
#pragma cdir shortloop
#line 3627
    for (i=0; i<ni; i++) {
#line 3627
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3627
     /* test for range errors (not always needed but do it anyway) */
#line 3627
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3627
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3627
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3627
    }
#line 3627
   /* update xpp and tp */
#line 3627
    if (realign) xp = (int64 *) *xpp;
#line 3627
    xp += ni;
#line 3627
    tp += ni;
#line 3627
    *xpp = (void*)xp;
#line 3627
  }
#line 3627
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3627

#line 3627
#else   /* not SX */
#line 3627
	const char *xp = (const char *) *xpp;
#line 3627
	int status = NC_NOERR;
#line 3627

#line 3627
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3627
	{
#line 3627
		const int lstatus = ncx_get_longlong_longlong(xp, tp);
#line 3627
		if (status == NC_NOERR) /* report the first encountered error */
#line 3627
			status = lstatus;
#line 3627
	}
#line 3627

#line 3627
	*xpp = (const void *)xp;
#line 3627
	return status;
#line 3627
#endif
#line 3627
}
#line 3627

#endif
int
#line 3629
ncx_getn_longlong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3629
{
#line 3629
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3629

#line 3629
 /* basic algorithm is:
#line 3629
  *   - ensure sane alignment of input data
#line 3629
  *   - copy (conversion happens automatically) input data
#line 3629
  *     to output
#line 3629
  *   - update xpp to point at next unconverted input, and tp to point
#line 3629
  *     at next location for converted output
#line 3629
  */
#line 3629
  long i, j, ni;
#line 3629
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3629
  int64 *xp;
#line 3629
  int nrange = 0;         /* number of range errors */
#line 3629
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3629
  long cxp = (long) *((char**)xpp);
#line 3629

#line 3629
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3629
  /* sjl: manually stripmine so we can limit amount of
#line 3629
   * vector work space reserved to LOOPCNT elements. Also
#line 3629
   * makes vectorisation easy */
#line 3629
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3629
    ni=Min(nelems-j,LOOPCNT);
#line 3629
    if (realign) {
#line 3629
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3629
      xp = tmp;
#line 3629
    } else {
#line 3629
      xp = (int64 *) *xpp;
#line 3629
    }
#line 3629
   /* copy the next block */
#line 3629
#pragma cdir loopcnt=LOOPCNT
#line 3629
#pragma cdir shortloop
#line 3629
    for (i=0; i<ni; i++) {
#line 3629
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3629
     /* test for range errors (not always needed but do it anyway) */
#line 3629
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3629
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3629
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3629
    }
#line 3629
   /* update xpp and tp */
#line 3629
    if (realign) xp = (int64 *) *xpp;
#line 3629
    xp += ni;
#line 3629
    tp += ni;
#line 3629
    *xpp = (void*)xp;
#line 3629
  }
#line 3629
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3629

#line 3629
#else   /* not SX */
#line 3629
	const char *xp = (const char *) *xpp;
#line 3629
	int status = NC_NOERR;
#line 3629

#line 3629
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3629
	{
#line 3629
		const int lstatus = ncx_get_longlong_schar(xp, tp);
#line 3629
		if (status == NC_NOERR) /* report the first encountered error */
#line 3629
			status = lstatus;
#line 3629
	}
#line 3629

#line 3629
	*xpp = (const void *)xp;
#line 3629
	return status;
#line 3629
#endif
#line 3629
}
#line 3629

int
#line 3630
ncx_getn_longlong_short(const void **xpp, size_t nelems, short *tp)
#line 3630
{
#line 3630
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3630

#line 3630
 /* basic algorithm is:
#line 3630
  *   - ensure sane alignment of input data
#line 3630
  *   - copy (conversion happens automatically) input data
#line 3630
  *     to output
#line 3630
  *   - update xpp to point at next unconverted input, and tp to point
#line 3630
  *     at next location for converted output
#line 3630
  */
#line 3630
  long i, j, ni;
#line 3630
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3630
  int64 *xp;
#line 3630
  int nrange = 0;         /* number of range errors */
#line 3630
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3630
  long cxp = (long) *((char**)xpp);
#line 3630

#line 3630
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3630
  /* sjl: manually stripmine so we can limit amount of
#line 3630
   * vector work space reserved to LOOPCNT elements. Also
#line 3630
   * makes vectorisation easy */
#line 3630
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3630
    ni=Min(nelems-j,LOOPCNT);
#line 3630
    if (realign) {
#line 3630
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3630
      xp = tmp;
#line 3630
    } else {
#line 3630
      xp = (int64 *) *xpp;
#line 3630
    }
#line 3630
   /* copy the next block */
#line 3630
#pragma cdir loopcnt=LOOPCNT
#line 3630
#pragma cdir shortloop
#line 3630
    for (i=0; i<ni; i++) {
#line 3630
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3630
     /* test for range errors (not always needed but do it anyway) */
#line 3630
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3630
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3630
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3630
    }
#line 3630
   /* update xpp and tp */
#line 3630
    if (realign) xp = (int64 *) *xpp;
#line 3630
    xp += ni;
#line 3630
    tp += ni;
#line 3630
    *xpp = (void*)xp;
#line 3630
  }
#line 3630
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3630

#line 3630
#else   /* not SX */
#line 3630
	const char *xp = (const char *) *xpp;
#line 3630
	int status = NC_NOERR;
#line 3630

#line 3630
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3630
	{
#line 3630
		const int lstatus = ncx_get_longlong_short(xp, tp);
#line 3630
		if (status == NC_NOERR) /* report the first encountered error */
#line 3630
			status = lstatus;
#line 3630
	}
#line 3630

#line 3630
	*xpp = (const void *)xp;
#line 3630
	return status;
#line 3630
#endif
#line 3630
}
#line 3630

int
#line 3631
ncx_getn_longlong_int(const void **xpp, size_t nelems, int *tp)
#line 3631
{
#line 3631
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3631

#line 3631
 /* basic algorithm is:
#line 3631
  *   - ensure sane alignment of input data
#line 3631
  *   - copy (conversion happens automatically) input data
#line 3631
  *     to output
#line 3631
  *   - update xpp to point at next unconverted input, and tp to point
#line 3631
  *     at next location for converted output
#line 3631
  */
#line 3631
  long i, j, ni;
#line 3631
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3631
  int64 *xp;
#line 3631
  int nrange = 0;         /* number of range errors */
#line 3631
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3631
  long cxp = (long) *((char**)xpp);
#line 3631

#line 3631
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3631
  /* sjl: manually stripmine so we can limit amount of
#line 3631
   * vector work space reserved to LOOPCNT elements. Also
#line 3631
   * makes vectorisation easy */
#line 3631
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3631
    ni=Min(nelems-j,LOOPCNT);
#line 3631
    if (realign) {
#line 3631
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3631
      xp = tmp;
#line 3631
    } else {
#line 3631
      xp = (int64 *) *xpp;
#line 3631
    }
#line 3631
   /* copy the next block */
#line 3631
#pragma cdir loopcnt=LOOPCNT
#line 3631
#pragma cdir shortloop
#line 3631
    for (i=0; i<ni; i++) {
#line 3631
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3631
     /* test for range errors (not always needed but do it anyway) */
#line 3631
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3631
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3631
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3631
    }
#line 3631
   /* update xpp and tp */
#line 3631
    if (realign) xp = (int64 *) *xpp;
#line 3631
    xp += ni;
#line 3631
    tp += ni;
#line 3631
    *xpp = (void*)xp;
#line 3631
  }
#line 3631
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3631

#line 3631
#else   /* not SX */
#line 3631
	const char *xp = (const char *) *xpp;
#line 3631
	int status = NC_NOERR;
#line 3631

#line 3631
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3631
	{
#line 3631
		const int lstatus = ncx_get_longlong_int(xp, tp);
#line 3631
		if (status == NC_NOERR) /* report the first encountered error */
#line 3631
			status = lstatus;
#line 3631
	}
#line 3631

#line 3631
	*xpp = (const void *)xp;
#line 3631
	return status;
#line 3631
#endif
#line 3631
}
#line 3631

int
#line 3632
ncx_getn_longlong_long(const void **xpp, size_t nelems, long *tp)
#line 3632
{
#line 3632
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3632

#line 3632
 /* basic algorithm is:
#line 3632
  *   - ensure sane alignment of input data
#line 3632
  *   - copy (conversion happens automatically) input data
#line 3632
  *     to output
#line 3632
  *   - update xpp to point at next unconverted input, and tp to point
#line 3632
  *     at next location for converted output
#line 3632
  */
#line 3632
  long i, j, ni;
#line 3632
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3632
  int64 *xp;
#line 3632
  int nrange = 0;         /* number of range errors */
#line 3632
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3632
  long cxp = (long) *((char**)xpp);
#line 3632

#line 3632
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3632
  /* sjl: manually stripmine so we can limit amount of
#line 3632
   * vector work space reserved to LOOPCNT elements. Also
#line 3632
   * makes vectorisation easy */
#line 3632
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3632
    ni=Min(nelems-j,LOOPCNT);
#line 3632
    if (realign) {
#line 3632
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3632
      xp = tmp;
#line 3632
    } else {
#line 3632
      xp = (int64 *) *xpp;
#line 3632
    }
#line 3632
   /* copy the next block */
#line 3632
#pragma cdir loopcnt=LOOPCNT
#line 3632
#pragma cdir shortloop
#line 3632
    for (i=0; i<ni; i++) {
#line 3632
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3632
     /* test for range errors (not always needed but do it anyway) */
#line 3632
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3632
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3632
      nrange += xp[i] > LONG_MAX || xp[i] < LONG_MIN;
#line 3632
    }
#line 3632
   /* update xpp and tp */
#line 3632
    if (realign) xp = (int64 *) *xpp;
#line 3632
    xp += ni;
#line 3632
    tp += ni;
#line 3632
    *xpp = (void*)xp;
#line 3632
  }
#line 3632
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3632

#line 3632
#else   /* not SX */
#line 3632
	const char *xp = (const char *) *xpp;
#line 3632
	int status = NC_NOERR;
#line 3632

#line 3632
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3632
	{
#line 3632
		const int lstatus = ncx_get_longlong_long(xp, tp);
#line 3632
		if (status == NC_NOERR) /* report the first encountered error */
#line 3632
			status = lstatus;
#line 3632
	}
#line 3632

#line 3632
	*xpp = (const void *)xp;
#line 3632
	return status;
#line 3632
#endif
#line 3632
}
#line 3632

int
#line 3633
ncx_getn_longlong_float(const void **xpp, size_t nelems, float *tp)
#line 3633
{
#line 3633
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3633

#line 3633
 /* basic algorithm is:
#line 3633
  *   - ensure sane alignment of input data
#line 3633
  *   - copy (conversion happens automatically) input data
#line 3633
  *     to output
#line 3633
  *   - update xpp to point at next unconverted input, and tp to point
#line 3633
  *     at next location for converted output
#line 3633
  */
#line 3633
  long i, j, ni;
#line 3633
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3633
  int64 *xp;
#line 3633
  int nrange = 0;         /* number of range errors */
#line 3633
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3633
  long cxp = (long) *((char**)xpp);
#line 3633

#line 3633
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3633
  /* sjl: manually stripmine so we can limit amount of
#line 3633
   * vector work space reserved to LOOPCNT elements. Also
#line 3633
   * makes vectorisation easy */
#line 3633
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3633
    ni=Min(nelems-j,LOOPCNT);
#line 3633
    if (realign) {
#line 3633
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3633
      xp = tmp;
#line 3633
    } else {
#line 3633
      xp = (int64 *) *xpp;
#line 3633
    }
#line 3633
   /* copy the next block */
#line 3633
#pragma cdir loopcnt=LOOPCNT
#line 3633
#pragma cdir shortloop
#line 3633
    for (i=0; i<ni; i++) {
#line 3633
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3633
     /* test for range errors (not always needed but do it anyway) */
#line 3633
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3633
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3633
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3633
    }
#line 3633
   /* update xpp and tp */
#line 3633
    if (realign) xp = (int64 *) *xpp;
#line 3633
    xp += ni;
#line 3633
    tp += ni;
#line 3633
    *xpp = (void*)xp;
#line 3633
  }
#line 3633
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3633

#line 3633
#else   /* not SX */
#line 3633
	const char *xp = (const char *) *xpp;
#line 3633
	int status = NC_NOERR;
#line 3633

#line 3633
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3633
	{
#line 3633
		const int lstatus = ncx_get_longlong_float(xp, tp);
#line 3633
		if (status == NC_NOERR) /* report the first encountered error */
#line 3633
			status = lstatus;
#line 3633
	}
#line 3633

#line 3633
	*xpp = (const void *)xp;
#line 3633
	return status;
#line 3633
#endif
#line 3633
}
#line 3633

int
#line 3634
ncx_getn_longlong_double(const void **xpp, size_t nelems, double *tp)
#line 3634
{
#line 3634
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3634

#line 3634
 /* basic algorithm is:
#line 3634
  *   - ensure sane alignment of input data
#line 3634
  *   - copy (conversion happens automatically) input data
#line 3634
  *     to output
#line 3634
  *   - update xpp to point at next unconverted input, and tp to point
#line 3634
  *     at next location for converted output
#line 3634
  */
#line 3634
  long i, j, ni;
#line 3634
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3634
  int64 *xp;
#line 3634
  int nrange = 0;         /* number of range errors */
#line 3634
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3634
  long cxp = (long) *((char**)xpp);
#line 3634

#line 3634
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3634
  /* sjl: manually stripmine so we can limit amount of
#line 3634
   * vector work space reserved to LOOPCNT elements. Also
#line 3634
   * makes vectorisation easy */
#line 3634
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3634
    ni=Min(nelems-j,LOOPCNT);
#line 3634
    if (realign) {
#line 3634
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3634
      xp = tmp;
#line 3634
    } else {
#line 3634
      xp = (int64 *) *xpp;
#line 3634
    }
#line 3634
   /* copy the next block */
#line 3634
#pragma cdir loopcnt=LOOPCNT
#line 3634
#pragma cdir shortloop
#line 3634
    for (i=0; i<ni; i++) {
#line 3634
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3634
     /* test for range errors (not always needed but do it anyway) */
#line 3634
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3634
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3634
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3634
    }
#line 3634
   /* update xpp and tp */
#line 3634
    if (realign) xp = (int64 *) *xpp;
#line 3634
    xp += ni;
#line 3634
    tp += ni;
#line 3634
    *xpp = (void*)xp;
#line 3634
  }
#line 3634
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3634

#line 3634
#else   /* not SX */
#line 3634
	const char *xp = (const char *) *xpp;
#line 3634
	int status = NC_NOERR;
#line 3634

#line 3634
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3634
	{
#line 3634
		const int lstatus = ncx_get_longlong_double(xp, tp);
#line 3634
		if (status == NC_NOERR) /* report the first encountered error */
#line 3634
			status = lstatus;
#line 3634
	}
#line 3634

#line 3634
	*xpp = (const void *)xp;
#line 3634
	return status;
#line 3634
#endif
#line 3634
}
#line 3634

int
#line 3635
ncx_getn_longlong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3635
{
#line 3635
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3635

#line 3635
 /* basic algorithm is:
#line 3635
  *   - ensure sane alignment of input data
#line 3635
  *   - copy (conversion happens automatically) input data
#line 3635
  *     to output
#line 3635
  *   - update xpp to point at next unconverted input, and tp to point
#line 3635
  *     at next location for converted output
#line 3635
  */
#line 3635
  long i, j, ni;
#line 3635
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3635
  int64 *xp;
#line 3635
  int nrange = 0;         /* number of range errors */
#line 3635
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3635
  long cxp = (long) *((char**)xpp);
#line 3635

#line 3635
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3635
  /* sjl: manually stripmine so we can limit amount of
#line 3635
   * vector work space reserved to LOOPCNT elements. Also
#line 3635
   * makes vectorisation easy */
#line 3635
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3635
    ni=Min(nelems-j,LOOPCNT);
#line 3635
    if (realign) {
#line 3635
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3635
      xp = tmp;
#line 3635
    } else {
#line 3635
      xp = (int64 *) *xpp;
#line 3635
    }
#line 3635
   /* copy the next block */
#line 3635
#pragma cdir loopcnt=LOOPCNT
#line 3635
#pragma cdir shortloop
#line 3635
    for (i=0; i<ni; i++) {
#line 3635
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3635
     /* test for range errors (not always needed but do it anyway) */
#line 3635
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3635
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3635
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3635
    }
#line 3635
   /* update xpp and tp */
#line 3635
    if (realign) xp = (int64 *) *xpp;
#line 3635
    xp += ni;
#line 3635
    tp += ni;
#line 3635
    *xpp = (void*)xp;
#line 3635
  }
#line 3635
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3635

#line 3635
#else   /* not SX */
#line 3635
	const char *xp = (const char *) *xpp;
#line 3635
	int status = NC_NOERR;
#line 3635

#line 3635
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3635
	{
#line 3635
		const int lstatus = ncx_get_longlong_uchar(xp, tp);
#line 3635
		if (status == NC_NOERR) /* report the first encountered error */
#line 3635
			status = lstatus;
#line 3635
	}
#line 3635

#line 3635
	*xpp = (const void *)xp;
#line 3635
	return status;
#line 3635
#endif
#line 3635
}
#line 3635

int
#line 3636
ncx_getn_longlong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3636
{
#line 3636
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3636

#line 3636
 /* basic algorithm is:
#line 3636
  *   - ensure sane alignment of input data
#line 3636
  *   - copy (conversion happens automatically) input data
#line 3636
  *     to output
#line 3636
  *   - update xpp to point at next unconverted input, and tp to point
#line 3636
  *     at next location for converted output
#line 3636
  */
#line 3636
  long i, j, ni;
#line 3636
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3636
  int64 *xp;
#line 3636
  int nrange = 0;         /* number of range errors */
#line 3636
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3636
  long cxp = (long) *((char**)xpp);
#line 3636

#line 3636
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3636
  /* sjl: manually stripmine so we can limit amount of
#line 3636
   * vector work space reserved to LOOPCNT elements. Also
#line 3636
   * makes vectorisation easy */
#line 3636
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3636
    ni=Min(nelems-j,LOOPCNT);
#line 3636
    if (realign) {
#line 3636
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3636
      xp = tmp;
#line 3636
    } else {
#line 3636
      xp = (int64 *) *xpp;
#line 3636
    }
#line 3636
   /* copy the next block */
#line 3636
#pragma cdir loopcnt=LOOPCNT
#line 3636
#pragma cdir shortloop
#line 3636
    for (i=0; i<ni; i++) {
#line 3636
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3636
     /* test for range errors (not always needed but do it anyway) */
#line 3636
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3636
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3636
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3636
    }
#line 3636
   /* update xpp and tp */
#line 3636
    if (realign) xp = (int64 *) *xpp;
#line 3636
    xp += ni;
#line 3636
    tp += ni;
#line 3636
    *xpp = (void*)xp;
#line 3636
  }
#line 3636
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3636

#line 3636
#else   /* not SX */
#line 3636
	const char *xp = (const char *) *xpp;
#line 3636
	int status = NC_NOERR;
#line 3636

#line 3636
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3636
	{
#line 3636
		const int lstatus = ncx_get_longlong_ushort(xp, tp);
#line 3636
		if (status == NC_NOERR) /* report the first encountered error */
#line 3636
			status = lstatus;
#line 3636
	}
#line 3636

#line 3636
	*xpp = (const void *)xp;
#line 3636
	return status;
#line 3636
#endif
#line 3636
}
#line 3636

int
#line 3637
ncx_getn_longlong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3637
{
#line 3637
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3637

#line 3637
 /* basic algorithm is:
#line 3637
  *   - ensure sane alignment of input data
#line 3637
  *   - copy (conversion happens automatically) input data
#line 3637
  *     to output
#line 3637
  *   - update xpp to point at next unconverted input, and tp to point
#line 3637
  *     at next location for converted output
#line 3637
  */
#line 3637
  long i, j, ni;
#line 3637
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3637
  int64 *xp;
#line 3637
  int nrange = 0;         /* number of range errors */
#line 3637
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3637
  long cxp = (long) *((char**)xpp);
#line 3637

#line 3637
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3637
  /* sjl: manually stripmine so we can limit amount of
#line 3637
   * vector work space reserved to LOOPCNT elements. Also
#line 3637
   * makes vectorisation easy */
#line 3637
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3637
    ni=Min(nelems-j,LOOPCNT);
#line 3637
    if (realign) {
#line 3637
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3637
      xp = tmp;
#line 3637
    } else {
#line 3637
      xp = (int64 *) *xpp;
#line 3637
    }
#line 3637
   /* copy the next block */
#line 3637
#pragma cdir loopcnt=LOOPCNT
#line 3637
#pragma cdir shortloop
#line 3637
    for (i=0; i<ni; i++) {
#line 3637
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3637
     /* test for range errors (not always needed but do it anyway) */
#line 3637
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3637
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3637
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3637
    }
#line 3637
   /* update xpp and tp */
#line 3637
    if (realign) xp = (int64 *) *xpp;
#line 3637
    xp += ni;
#line 3637
    tp += ni;
#line 3637
    *xpp = (void*)xp;
#line 3637
  }
#line 3637
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3637

#line 3637
#else   /* not SX */
#line 3637
	const char *xp = (const char *) *xpp;
#line 3637
	int status = NC_NOERR;
#line 3637

#line 3637
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3637
	{
#line 3637
		const int lstatus = ncx_get_longlong_uint(xp, tp);
#line 3637
		if (status == NC_NOERR) /* report the first encountered error */
#line 3637
			status = lstatus;
#line 3637
	}
#line 3637

#line 3637
	*xpp = (const void *)xp;
#line 3637
	return status;
#line 3637
#endif
#line 3637
}
#line 3637

int
#line 3638
ncx_getn_longlong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3638
{
#line 3638
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3638

#line 3638
 /* basic algorithm is:
#line 3638
  *   - ensure sane alignment of input data
#line 3638
  *   - copy (conversion happens automatically) input data
#line 3638
  *     to output
#line 3638
  *   - update xpp to point at next unconverted input, and tp to point
#line 3638
  *     at next location for converted output
#line 3638
  */
#line 3638
  long i, j, ni;
#line 3638
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3638
  int64 *xp;
#line 3638
  int nrange = 0;         /* number of range errors */
#line 3638
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3638
  long cxp = (long) *((char**)xpp);
#line 3638

#line 3638
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3638
  /* sjl: manually stripmine so we can limit amount of
#line 3638
   * vector work space reserved to LOOPCNT elements. Also
#line 3638
   * makes vectorisation easy */
#line 3638
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3638
    ni=Min(nelems-j,LOOPCNT);
#line 3638
    if (realign) {
#line 3638
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_INT64));
#line 3638
      xp = tmp;
#line 3638
    } else {
#line 3638
      xp = (int64 *) *xpp;
#line 3638
    }
#line 3638
   /* copy the next block */
#line 3638
#pragma cdir loopcnt=LOOPCNT
#line 3638
#pragma cdir shortloop
#line 3638
    for (i=0; i<ni; i++) {
#line 3638
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3638
     /* test for range errors (not always needed but do it anyway) */
#line 3638
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3638
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3638
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3638
    }
#line 3638
   /* update xpp and tp */
#line 3638
    if (realign) xp = (int64 *) *xpp;
#line 3638
    xp += ni;
#line 3638
    tp += ni;
#line 3638
    *xpp = (void*)xp;
#line 3638
  }
#line 3638
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3638

#line 3638
#else   /* not SX */
#line 3638
	const char *xp = (const char *) *xpp;
#line 3638
	int status = NC_NOERR;
#line 3638

#line 3638
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3638
	{
#line 3638
		const int lstatus = ncx_get_longlong_ulonglong(xp, tp);
#line 3638
		if (status == NC_NOERR) /* report the first encountered error */
#line 3638
			status = lstatus;
#line 3638
	}
#line 3638

#line 3638
	*xpp = (const void *)xp;
#line 3638
	return status;
#line 3638
#endif
#line 3638
}
#line 3638


#if X_SIZEOF_INT64 == SIZEOF_LONGLONG
/* optimized version */
int
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_INT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT64);
	return NC_NOERR;
}
#else
int
#line 3654
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3654
{
#line 3654
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3654

#line 3654
 /* basic algorithm is:
#line 3654
  *   - ensure sane alignment of output data
#line 3654
  *   - copy (conversion happens automatically) input data
#line 3654
  *     to output
#line 3654
  *   - update tp to point at next unconverted input, and xpp to point
#line 3654
  *     at next location for converted output
#line 3654
  */
#line 3654
  long i, j, ni;
#line 3654
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3654
  int64 *xp;
#line 3654
  int nrange = 0;         /* number of range errors */
#line 3654
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3654
  long cxp = (long) *((char**)xpp);
#line 3654

#line 3654
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3654
  /* sjl: manually stripmine so we can limit amount of
#line 3654
   * vector work space reserved to LOOPCNT elements. Also
#line 3654
   * makes vectorisation easy */
#line 3654
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3654
    ni=Min(nelems-j,LOOPCNT);
#line 3654
    if (realign) {
#line 3654
      xp = tmp;
#line 3654
    } else {
#line 3654
      xp = (int64 *) *xpp;
#line 3654
    }
#line 3654
   /* copy the next block */
#line 3654
#pragma cdir loopcnt=LOOPCNT
#line 3654
#pragma cdir shortloop
#line 3654
    for (i=0; i<ni; i++) {
#line 3654
      /* the normal case: */
#line 3654
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3654
     /* test for range errors (not always needed but do it anyway) */
#line 3654
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3654
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3654
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3654
    }
#line 3654
   /* copy workspace back if necessary */
#line 3654
    if (realign) {
#line 3654
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3654
      xp = (int64 *) *xpp;
#line 3654
    }
#line 3654
   /* update xpp and tp */
#line 3654
    xp += ni;
#line 3654
    tp += ni;
#line 3654
    *xpp = (void*)xp;
#line 3654
  }
#line 3654
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3654

#line 3654
#else   /* not SX */
#line 3654

#line 3654
	char *xp = (char *) *xpp;
#line 3654
	int status = NC_NOERR;
#line 3654

#line 3654
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3654
	{
#line 3654
		int lstatus = ncx_put_longlong_longlong(xp, tp, fillp);
#line 3654
		if (status == NC_NOERR) /* report the first encountered error */
#line 3654
			status = lstatus;
#line 3654
	}
#line 3654

#line 3654
	*xpp = (void *)xp;
#line 3654
	return status;
#line 3654
#endif
#line 3654
}
#line 3654

#endif
int
#line 3656
ncx_putn_longlong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3656
{
#line 3656
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3656

#line 3656
 /* basic algorithm is:
#line 3656
  *   - ensure sane alignment of output data
#line 3656
  *   - copy (conversion happens automatically) input data
#line 3656
  *     to output
#line 3656
  *   - update tp to point at next unconverted input, and xpp to point
#line 3656
  *     at next location for converted output
#line 3656
  */
#line 3656
  long i, j, ni;
#line 3656
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3656
  int64 *xp;
#line 3656
  int nrange = 0;         /* number of range errors */
#line 3656
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3656
  long cxp = (long) *((char**)xpp);
#line 3656

#line 3656
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3656
  /* sjl: manually stripmine so we can limit amount of
#line 3656
   * vector work space reserved to LOOPCNT elements. Also
#line 3656
   * makes vectorisation easy */
#line 3656
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3656
    ni=Min(nelems-j,LOOPCNT);
#line 3656
    if (realign) {
#line 3656
      xp = tmp;
#line 3656
    } else {
#line 3656
      xp = (int64 *) *xpp;
#line 3656
    }
#line 3656
   /* copy the next block */
#line 3656
#pragma cdir loopcnt=LOOPCNT
#line 3656
#pragma cdir shortloop
#line 3656
    for (i=0; i<ni; i++) {
#line 3656
      /* the normal case: */
#line 3656
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3656
     /* test for range errors (not always needed but do it anyway) */
#line 3656
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3656
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3656
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3656
    }
#line 3656
   /* copy workspace back if necessary */
#line 3656
    if (realign) {
#line 3656
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3656
      xp = (int64 *) *xpp;
#line 3656
    }
#line 3656
   /* update xpp and tp */
#line 3656
    xp += ni;
#line 3656
    tp += ni;
#line 3656
    *xpp = (void*)xp;
#line 3656
  }
#line 3656
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3656

#line 3656
#else   /* not SX */
#line 3656

#line 3656
	char *xp = (char *) *xpp;
#line 3656
	int status = NC_NOERR;
#line 3656

#line 3656
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3656
	{
#line 3656
		int lstatus = ncx_put_longlong_schar(xp, tp, fillp);
#line 3656
		if (status == NC_NOERR) /* report the first encountered error */
#line 3656
			status = lstatus;
#line 3656
	}
#line 3656

#line 3656
	*xpp = (void *)xp;
#line 3656
	return status;
#line 3656
#endif
#line 3656
}
#line 3656

int
#line 3657
ncx_putn_longlong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3657
{
#line 3657
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3657

#line 3657
 /* basic algorithm is:
#line 3657
  *   - ensure sane alignment of output data
#line 3657
  *   - copy (conversion happens automatically) input data
#line 3657
  *     to output
#line 3657
  *   - update tp to point at next unconverted input, and xpp to point
#line 3657
  *     at next location for converted output
#line 3657
  */
#line 3657
  long i, j, ni;
#line 3657
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3657
  int64 *xp;
#line 3657
  int nrange = 0;         /* number of range errors */
#line 3657
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3657
  long cxp = (long) *((char**)xpp);
#line 3657

#line 3657
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3657
  /* sjl: manually stripmine so we can limit amount of
#line 3657
   * vector work space reserved to LOOPCNT elements. Also
#line 3657
   * makes vectorisation easy */
#line 3657
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3657
    ni=Min(nelems-j,LOOPCNT);
#line 3657
    if (realign) {
#line 3657
      xp = tmp;
#line 3657
    } else {
#line 3657
      xp = (int64 *) *xpp;
#line 3657
    }
#line 3657
   /* copy the next block */
#line 3657
#pragma cdir loopcnt=LOOPCNT
#line 3657
#pragma cdir shortloop
#line 3657
    for (i=0; i<ni; i++) {
#line 3657
      /* the normal case: */
#line 3657
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3657
     /* test for range errors (not always needed but do it anyway) */
#line 3657
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3657
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3657
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3657
    }
#line 3657
   /* copy workspace back if necessary */
#line 3657
    if (realign) {
#line 3657
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3657
      xp = (int64 *) *xpp;
#line 3657
    }
#line 3657
   /* update xpp and tp */
#line 3657
    xp += ni;
#line 3657
    tp += ni;
#line 3657
    *xpp = (void*)xp;
#line 3657
  }
#line 3657
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3657

#line 3657
#else   /* not SX */
#line 3657

#line 3657
	char *xp = (char *) *xpp;
#line 3657
	int status = NC_NOERR;
#line 3657

#line 3657
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3657
	{
#line 3657
		int lstatus = ncx_put_longlong_short(xp, tp, fillp);
#line 3657
		if (status == NC_NOERR) /* report the first encountered error */
#line 3657
			status = lstatus;
#line 3657
	}
#line 3657

#line 3657
	*xpp = (void *)xp;
#line 3657
	return status;
#line 3657
#endif
#line 3657
}
#line 3657

int
#line 3658
ncx_putn_longlong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3658
{
#line 3658
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3658

#line 3658
 /* basic algorithm is:
#line 3658
  *   - ensure sane alignment of output data
#line 3658
  *   - copy (conversion happens automatically) input data
#line 3658
  *     to output
#line 3658
  *   - update tp to point at next unconverted input, and xpp to point
#line 3658
  *     at next location for converted output
#line 3658
  */
#line 3658
  long i, j, ni;
#line 3658
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3658
  int64 *xp;
#line 3658
  int nrange = 0;         /* number of range errors */
#line 3658
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3658
  long cxp = (long) *((char**)xpp);
#line 3658

#line 3658
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3658
  /* sjl: manually stripmine so we can limit amount of
#line 3658
   * vector work space reserved to LOOPCNT elements. Also
#line 3658
   * makes vectorisation easy */
#line 3658
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3658
    ni=Min(nelems-j,LOOPCNT);
#line 3658
    if (realign) {
#line 3658
      xp = tmp;
#line 3658
    } else {
#line 3658
      xp = (int64 *) *xpp;
#line 3658
    }
#line 3658
   /* copy the next block */
#line 3658
#pragma cdir loopcnt=LOOPCNT
#line 3658
#pragma cdir shortloop
#line 3658
    for (i=0; i<ni; i++) {
#line 3658
      /* the normal case: */
#line 3658
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3658
     /* test for range errors (not always needed but do it anyway) */
#line 3658
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3658
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3658
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3658
    }
#line 3658
   /* copy workspace back if necessary */
#line 3658
    if (realign) {
#line 3658
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3658
      xp = (int64 *) *xpp;
#line 3658
    }
#line 3658
   /* update xpp and tp */
#line 3658
    xp += ni;
#line 3658
    tp += ni;
#line 3658
    *xpp = (void*)xp;
#line 3658
  }
#line 3658
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3658

#line 3658
#else   /* not SX */
#line 3658

#line 3658
	char *xp = (char *) *xpp;
#line 3658
	int status = NC_NOERR;
#line 3658

#line 3658
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3658
	{
#line 3658
		int lstatus = ncx_put_longlong_int(xp, tp, fillp);
#line 3658
		if (status == NC_NOERR) /* report the first encountered error */
#line 3658
			status = lstatus;
#line 3658
	}
#line 3658

#line 3658
	*xpp = (void *)xp;
#line 3658
	return status;
#line 3658
#endif
#line 3658
}
#line 3658

int
#line 3659
ncx_putn_longlong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3659
{
#line 3659
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3659

#line 3659
 /* basic algorithm is:
#line 3659
  *   - ensure sane alignment of output data
#line 3659
  *   - copy (conversion happens automatically) input data
#line 3659
  *     to output
#line 3659
  *   - update tp to point at next unconverted input, and xpp to point
#line 3659
  *     at next location for converted output
#line 3659
  */
#line 3659
  long i, j, ni;
#line 3659
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3659
  int64 *xp;
#line 3659
  int nrange = 0;         /* number of range errors */
#line 3659
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3659
  long cxp = (long) *((char**)xpp);
#line 3659

#line 3659
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3659
  /* sjl: manually stripmine so we can limit amount of
#line 3659
   * vector work space reserved to LOOPCNT elements. Also
#line 3659
   * makes vectorisation easy */
#line 3659
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3659
    ni=Min(nelems-j,LOOPCNT);
#line 3659
    if (realign) {
#line 3659
      xp = tmp;
#line 3659
    } else {
#line 3659
      xp = (int64 *) *xpp;
#line 3659
    }
#line 3659
   /* copy the next block */
#line 3659
#pragma cdir loopcnt=LOOPCNT
#line 3659
#pragma cdir shortloop
#line 3659
    for (i=0; i<ni; i++) {
#line 3659
      /* the normal case: */
#line 3659
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3659
     /* test for range errors (not always needed but do it anyway) */
#line 3659
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3659
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3659
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3659
    }
#line 3659
   /* copy workspace back if necessary */
#line 3659
    if (realign) {
#line 3659
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3659
      xp = (int64 *) *xpp;
#line 3659
    }
#line 3659
   /* update xpp and tp */
#line 3659
    xp += ni;
#line 3659
    tp += ni;
#line 3659
    *xpp = (void*)xp;
#line 3659
  }
#line 3659
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3659

#line 3659
#else   /* not SX */
#line 3659

#line 3659
	char *xp = (char *) *xpp;
#line 3659
	int status = NC_NOERR;
#line 3659

#line 3659
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3659
	{
#line 3659
		int lstatus = ncx_put_longlong_long(xp, tp, fillp);
#line 3659
		if (status == NC_NOERR) /* report the first encountered error */
#line 3659
			status = lstatus;
#line 3659
	}
#line 3659

#line 3659
	*xpp = (void *)xp;
#line 3659
	return status;
#line 3659
#endif
#line 3659
}
#line 3659

int
#line 3660
ncx_putn_longlong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3660
{
#line 3660
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3660

#line 3660
 /* basic algorithm is:
#line 3660
  *   - ensure sane alignment of output data
#line 3660
  *   - copy (conversion happens automatically) input data
#line 3660
  *     to output
#line 3660
  *   - update tp to point at next unconverted input, and xpp to point
#line 3660
  *     at next location for converted output
#line 3660
  */
#line 3660
  long i, j, ni;
#line 3660
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3660
  int64 *xp;
#line 3660
  int nrange = 0;         /* number of range errors */
#line 3660
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3660
  long cxp = (long) *((char**)xpp);
#line 3660

#line 3660
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3660
  /* sjl: manually stripmine so we can limit amount of
#line 3660
   * vector work space reserved to LOOPCNT elements. Also
#line 3660
   * makes vectorisation easy */
#line 3660
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3660
    ni=Min(nelems-j,LOOPCNT);
#line 3660
    if (realign) {
#line 3660
      xp = tmp;
#line 3660
    } else {
#line 3660
      xp = (int64 *) *xpp;
#line 3660
    }
#line 3660
   /* copy the next block */
#line 3660
#pragma cdir loopcnt=LOOPCNT
#line 3660
#pragma cdir shortloop
#line 3660
    for (i=0; i<ni; i++) {
#line 3660
      /* the normal case: */
#line 3660
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3660
     /* test for range errors (not always needed but do it anyway) */
#line 3660
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3660
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3660
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3660
    }
#line 3660
   /* copy workspace back if necessary */
#line 3660
    if (realign) {
#line 3660
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3660
      xp = (int64 *) *xpp;
#line 3660
    }
#line 3660
   /* update xpp and tp */
#line 3660
    xp += ni;
#line 3660
    tp += ni;
#line 3660
    *xpp = (void*)xp;
#line 3660
  }
#line 3660
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3660

#line 3660
#else   /* not SX */
#line 3660

#line 3660
	char *xp = (char *) *xpp;
#line 3660
	int status = NC_NOERR;
#line 3660

#line 3660
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3660
	{
#line 3660
		int lstatus = ncx_put_longlong_float(xp, tp, fillp);
#line 3660
		if (status == NC_NOERR) /* report the first encountered error */
#line 3660
			status = lstatus;
#line 3660
	}
#line 3660

#line 3660
	*xpp = (void *)xp;
#line 3660
	return status;
#line 3660
#endif
#line 3660
}
#line 3660

int
#line 3661
ncx_putn_longlong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3661
{
#line 3661
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3661

#line 3661
 /* basic algorithm is:
#line 3661
  *   - ensure sane alignment of output data
#line 3661
  *   - copy (conversion happens automatically) input data
#line 3661
  *     to output
#line 3661
  *   - update tp to point at next unconverted input, and xpp to point
#line 3661
  *     at next location for converted output
#line 3661
  */
#line 3661
  long i, j, ni;
#line 3661
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3661
  int64 *xp;
#line 3661
  int nrange = 0;         /* number of range errors */
#line 3661
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3661
  long cxp = (long) *((char**)xpp);
#line 3661

#line 3661
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3661
  /* sjl: manually stripmine so we can limit amount of
#line 3661
   * vector work space reserved to LOOPCNT elements. Also
#line 3661
   * makes vectorisation easy */
#line 3661
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3661
    ni=Min(nelems-j,LOOPCNT);
#line 3661
    if (realign) {
#line 3661
      xp = tmp;
#line 3661
    } else {
#line 3661
      xp = (int64 *) *xpp;
#line 3661
    }
#line 3661
   /* copy the next block */
#line 3661
#pragma cdir loopcnt=LOOPCNT
#line 3661
#pragma cdir shortloop
#line 3661
    for (i=0; i<ni; i++) {
#line 3661
      /* the normal case: */
#line 3661
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3661
     /* test for range errors (not always needed but do it anyway) */
#line 3661
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3661
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3661
      nrange += tp[i] > X_INT64_MAX || tp[i] < X_INT64_MIN;
#line 3661
    }
#line 3661
   /* copy workspace back if necessary */
#line 3661
    if (realign) {
#line 3661
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3661
      xp = (int64 *) *xpp;
#line 3661
    }
#line 3661
   /* update xpp and tp */
#line 3661
    xp += ni;
#line 3661
    tp += ni;
#line 3661
    *xpp = (void*)xp;
#line 3661
  }
#line 3661
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3661

#line 3661
#else   /* not SX */
#line 3661

#line 3661
	char *xp = (char *) *xpp;
#line 3661
	int status = NC_NOERR;
#line 3661

#line 3661
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3661
	{
#line 3661
		int lstatus = ncx_put_longlong_double(xp, tp, fillp);
#line 3661
		if (status == NC_NOERR) /* report the first encountered error */
#line 3661
			status = lstatus;
#line 3661
	}
#line 3661

#line 3661
	*xpp = (void *)xp;
#line 3661
	return status;
#line 3661
#endif
#line 3661
}
#line 3661

int
#line 3662
ncx_putn_longlong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3662
{
#line 3662
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3662

#line 3662
 /* basic algorithm is:
#line 3662
  *   - ensure sane alignment of output data
#line 3662
  *   - copy (conversion happens automatically) input data
#line 3662
  *     to output
#line 3662
  *   - update tp to point at next unconverted input, and xpp to point
#line 3662
  *     at next location for converted output
#line 3662
  */
#line 3662
  long i, j, ni;
#line 3662
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3662
  int64 *xp;
#line 3662
  int nrange = 0;         /* number of range errors */
#line 3662
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3662
  long cxp = (long) *((char**)xpp);
#line 3662

#line 3662
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3662
  /* sjl: manually stripmine so we can limit amount of
#line 3662
   * vector work space reserved to LOOPCNT elements. Also
#line 3662
   * makes vectorisation easy */
#line 3662
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3662
    ni=Min(nelems-j,LOOPCNT);
#line 3662
    if (realign) {
#line 3662
      xp = tmp;
#line 3662
    } else {
#line 3662
      xp = (int64 *) *xpp;
#line 3662
    }
#line 3662
   /* copy the next block */
#line 3662
#pragma cdir loopcnt=LOOPCNT
#line 3662
#pragma cdir shortloop
#line 3662
    for (i=0; i<ni; i++) {
#line 3662
      /* the normal case: */
#line 3662
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3662
     /* test for range errors (not always needed but do it anyway) */
#line 3662
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3662
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3662
      nrange += tp[i] > X_INT64_MAX ;
#line 3662
    }
#line 3662
   /* copy workspace back if necessary */
#line 3662
    if (realign) {
#line 3662
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3662
      xp = (int64 *) *xpp;
#line 3662
    }
#line 3662
   /* update xpp and tp */
#line 3662
    xp += ni;
#line 3662
    tp += ni;
#line 3662
    *xpp = (void*)xp;
#line 3662
  }
#line 3662
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3662

#line 3662
#else   /* not SX */
#line 3662

#line 3662
	char *xp = (char *) *xpp;
#line 3662
	int status = NC_NOERR;
#line 3662

#line 3662
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3662
	{
#line 3662
		int lstatus = ncx_put_longlong_uchar(xp, tp, fillp);
#line 3662
		if (status == NC_NOERR) /* report the first encountered error */
#line 3662
			status = lstatus;
#line 3662
	}
#line 3662

#line 3662
	*xpp = (void *)xp;
#line 3662
	return status;
#line 3662
#endif
#line 3662
}
#line 3662

int
#line 3663
ncx_putn_longlong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3663
{
#line 3663
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3663

#line 3663
 /* basic algorithm is:
#line 3663
  *   - ensure sane alignment of output data
#line 3663
  *   - copy (conversion happens automatically) input data
#line 3663
  *     to output
#line 3663
  *   - update tp to point at next unconverted input, and xpp to point
#line 3663
  *     at next location for converted output
#line 3663
  */
#line 3663
  long i, j, ni;
#line 3663
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3663
  int64 *xp;
#line 3663
  int nrange = 0;         /* number of range errors */
#line 3663
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3663
  long cxp = (long) *((char**)xpp);
#line 3663

#line 3663
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3663
  /* sjl: manually stripmine so we can limit amount of
#line 3663
   * vector work space reserved to LOOPCNT elements. Also
#line 3663
   * makes vectorisation easy */
#line 3663
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3663
    ni=Min(nelems-j,LOOPCNT);
#line 3663
    if (realign) {
#line 3663
      xp = tmp;
#line 3663
    } else {
#line 3663
      xp = (int64 *) *xpp;
#line 3663
    }
#line 3663
   /* copy the next block */
#line 3663
#pragma cdir loopcnt=LOOPCNT
#line 3663
#pragma cdir shortloop
#line 3663
    for (i=0; i<ni; i++) {
#line 3663
      /* the normal case: */
#line 3663
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3663
     /* test for range errors (not always needed but do it anyway) */
#line 3663
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3663
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3663
      nrange += tp[i] > X_INT64_MAX ;
#line 3663
    }
#line 3663
   /* copy workspace back if necessary */
#line 3663
    if (realign) {
#line 3663
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3663
      xp = (int64 *) *xpp;
#line 3663
    }
#line 3663
   /* update xpp and tp */
#line 3663
    xp += ni;
#line 3663
    tp += ni;
#line 3663
    *xpp = (void*)xp;
#line 3663
  }
#line 3663
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3663

#line 3663
#else   /* not SX */
#line 3663

#line 3663
	char *xp = (char *) *xpp;
#line 3663
	int status = NC_NOERR;
#line 3663

#line 3663
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3663
	{
#line 3663
		int lstatus = ncx_put_longlong_ushort(xp, tp, fillp);
#line 3663
		if (status == NC_NOERR) /* report the first encountered error */
#line 3663
			status = lstatus;
#line 3663
	}
#line 3663

#line 3663
	*xpp = (void *)xp;
#line 3663
	return status;
#line 3663
#endif
#line 3663
}
#line 3663

int
#line 3664
ncx_putn_longlong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3664
{
#line 3664
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3664

#line 3664
 /* basic algorithm is:
#line 3664
  *   - ensure sane alignment of output data
#line 3664
  *   - copy (conversion happens automatically) input data
#line 3664
  *     to output
#line 3664
  *   - update tp to point at next unconverted input, and xpp to point
#line 3664
  *     at next location for converted output
#line 3664
  */
#line 3664
  long i, j, ni;
#line 3664
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3664
  int64 *xp;
#line 3664
  int nrange = 0;         /* number of range errors */
#line 3664
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3664
  long cxp = (long) *((char**)xpp);
#line 3664

#line 3664
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3664
  /* sjl: manually stripmine so we can limit amount of
#line 3664
   * vector work space reserved to LOOPCNT elements. Also
#line 3664
   * makes vectorisation easy */
#line 3664
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3664
    ni=Min(nelems-j,LOOPCNT);
#line 3664
    if (realign) {
#line 3664
      xp = tmp;
#line 3664
    } else {
#line 3664
      xp = (int64 *) *xpp;
#line 3664
    }
#line 3664
   /* copy the next block */
#line 3664
#pragma cdir loopcnt=LOOPCNT
#line 3664
#pragma cdir shortloop
#line 3664
    for (i=0; i<ni; i++) {
#line 3664
      /* the normal case: */
#line 3664
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3664
     /* test for range errors (not always needed but do it anyway) */
#line 3664
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3664
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3664
      nrange += tp[i] > X_INT64_MAX ;
#line 3664
    }
#line 3664
   /* copy workspace back if necessary */
#line 3664
    if (realign) {
#line 3664
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3664
      xp = (int64 *) *xpp;
#line 3664
    }
#line 3664
   /* update xpp and tp */
#line 3664
    xp += ni;
#line 3664
    tp += ni;
#line 3664
    *xpp = (void*)xp;
#line 3664
  }
#line 3664
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3664

#line 3664
#else   /* not SX */
#line 3664

#line 3664
	char *xp = (char *) *xpp;
#line 3664
	int status = NC_NOERR;
#line 3664

#line 3664
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3664
	{
#line 3664
		int lstatus = ncx_put_longlong_uint(xp, tp, fillp);
#line 3664
		if (status == NC_NOERR) /* report the first encountered error */
#line 3664
			status = lstatus;
#line 3664
	}
#line 3664

#line 3664
	*xpp = (void *)xp;
#line 3664
	return status;
#line 3664
#endif
#line 3664
}
#line 3664

int
#line 3665
ncx_putn_longlong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3665
{
#line 3665
#if defined(_SX) && _SX != 0 && X_SIZEOF_INT64 == SIZEOF_INT64
#line 3665

#line 3665
 /* basic algorithm is:
#line 3665
  *   - ensure sane alignment of output data
#line 3665
  *   - copy (conversion happens automatically) input data
#line 3665
  *     to output
#line 3665
  *   - update tp to point at next unconverted input, and xpp to point
#line 3665
  *     at next location for converted output
#line 3665
  */
#line 3665
  long i, j, ni;
#line 3665
  int64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3665
  int64 *xp;
#line 3665
  int nrange = 0;         /* number of range errors */
#line 3665
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3665
  long cxp = (long) *((char**)xpp);
#line 3665

#line 3665
  realign = (cxp & 7) % SIZEOF_INT64;
#line 3665
  /* sjl: manually stripmine so we can limit amount of
#line 3665
   * vector work space reserved to LOOPCNT elements. Also
#line 3665
   * makes vectorisation easy */
#line 3665
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3665
    ni=Min(nelems-j,LOOPCNT);
#line 3665
    if (realign) {
#line 3665
      xp = tmp;
#line 3665
    } else {
#line 3665
      xp = (int64 *) *xpp;
#line 3665
    }
#line 3665
   /* copy the next block */
#line 3665
#pragma cdir loopcnt=LOOPCNT
#line 3665
#pragma cdir shortloop
#line 3665
    for (i=0; i<ni; i++) {
#line 3665
      /* the normal case: */
#line 3665
      xp[i] = (int64) Max( X_INT64_MIN, Min(X_INT64_MAX, (int64) tp[i]));
#line 3665
     /* test for range errors (not always needed but do it anyway) */
#line 3665
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3665
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3665
      nrange += tp[i] > X_INT64_MAX ;
#line 3665
    }
#line 3665
   /* copy workspace back if necessary */
#line 3665
    if (realign) {
#line 3665
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_INT64);
#line 3665
      xp = (int64 *) *xpp;
#line 3665
    }
#line 3665
   /* update xpp and tp */
#line 3665
    xp += ni;
#line 3665
    tp += ni;
#line 3665
    *xpp = (void*)xp;
#line 3665
  }
#line 3665
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3665

#line 3665
#else   /* not SX */
#line 3665

#line 3665
	char *xp = (char *) *xpp;
#line 3665
	int status = NC_NOERR;
#line 3665

#line 3665
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT64, tp++)
#line 3665
	{
#line 3665
		int lstatus = ncx_put_longlong_ulonglong(xp, tp, fillp);
#line 3665
		if (status == NC_NOERR) /* report the first encountered error */
#line 3665
			status = lstatus;
#line 3665
	}
#line 3665

#line 3665
	*xpp = (void *)xp;
#line 3665
	return status;
#line 3665
#endif
#line 3665
}
#line 3665


/* uint64 --------------------------------------------------------------------*/

#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, unsigned long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, (size_t)nelems * SIZEOF_UNSIGNED_LONG_LONG);
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3683
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3683
{
#line 3683
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3683

#line 3683
 /* basic algorithm is:
#line 3683
  *   - ensure sane alignment of input data
#line 3683
  *   - copy (conversion happens automatically) input data
#line 3683
  *     to output
#line 3683
  *   - update xpp to point at next unconverted input, and tp to point
#line 3683
  *     at next location for converted output
#line 3683
  */
#line 3683
  long i, j, ni;
#line 3683
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3683
  uint64 *xp;
#line 3683
  int nrange = 0;         /* number of range errors */
#line 3683
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3683
  long cxp = (long) *((char**)xpp);
#line 3683

#line 3683
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3683
  /* sjl: manually stripmine so we can limit amount of
#line 3683
   * vector work space reserved to LOOPCNT elements. Also
#line 3683
   * makes vectorisation easy */
#line 3683
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3683
    ni=Min(nelems-j,LOOPCNT);
#line 3683
    if (realign) {
#line 3683
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3683
      xp = tmp;
#line 3683
    } else {
#line 3683
      xp = (uint64 *) *xpp;
#line 3683
    }
#line 3683
   /* copy the next block */
#line 3683
#pragma cdir loopcnt=LOOPCNT
#line 3683
#pragma cdir shortloop
#line 3683
    for (i=0; i<ni; i++) {
#line 3683
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3683
     /* test for range errors (not always needed but do it anyway) */
#line 3683
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3683
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3683
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3683
    }
#line 3683
   /* update xpp and tp */
#line 3683
    if (realign) xp = (uint64 *) *xpp;
#line 3683
    xp += ni;
#line 3683
    tp += ni;
#line 3683
    *xpp = (void*)xp;
#line 3683
  }
#line 3683
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3683

#line 3683
#else   /* not SX */
#line 3683
	const char *xp = (const char *) *xpp;
#line 3683
	int status = NC_NOERR;
#line 3683

#line 3683
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3683
	{
#line 3683
		const int lstatus = ncx_get_ulonglong_ulonglong(xp, tp);
#line 3683
		if (status == NC_NOERR) /* report the first encountered error */
#line 3683
			status = lstatus;
#line 3683
	}
#line 3683

#line 3683
	*xpp = (const void *)xp;
#line 3683
	return status;
#line 3683
#endif
#line 3683
}
#line 3683

#endif
int
#line 3685
ncx_getn_ulonglong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3685
{
#line 3685
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3685

#line 3685
 /* basic algorithm is:
#line 3685
  *   - ensure sane alignment of input data
#line 3685
  *   - copy (conversion happens automatically) input data
#line 3685
  *     to output
#line 3685
  *   - update xpp to point at next unconverted input, and tp to point
#line 3685
  *     at next location for converted output
#line 3685
  */
#line 3685
  long i, j, ni;
#line 3685
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3685
  uint64 *xp;
#line 3685
  int nrange = 0;         /* number of range errors */
#line 3685
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3685
  long cxp = (long) *((char**)xpp);
#line 3685

#line 3685
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3685
  /* sjl: manually stripmine so we can limit amount of
#line 3685
   * vector work space reserved to LOOPCNT elements. Also
#line 3685
   * makes vectorisation easy */
#line 3685
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3685
    ni=Min(nelems-j,LOOPCNT);
#line 3685
    if (realign) {
#line 3685
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3685
      xp = tmp;
#line 3685
    } else {
#line 3685
      xp = (uint64 *) *xpp;
#line 3685
    }
#line 3685
   /* copy the next block */
#line 3685
#pragma cdir loopcnt=LOOPCNT
#line 3685
#pragma cdir shortloop
#line 3685
    for (i=0; i<ni; i++) {
#line 3685
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3685
     /* test for range errors (not always needed but do it anyway) */
#line 3685
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3685
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3685
      nrange += xp[i] > SCHAR_MAX ;
#line 3685
    }
#line 3685
   /* update xpp and tp */
#line 3685
    if (realign) xp = (uint64 *) *xpp;
#line 3685
    xp += ni;
#line 3685
    tp += ni;
#line 3685
    *xpp = (void*)xp;
#line 3685
  }
#line 3685
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3685

#line 3685
#else   /* not SX */
#line 3685
	const char *xp = (const char *) *xpp;
#line 3685
	int status = NC_NOERR;
#line 3685

#line 3685
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3685
	{
#line 3685
		const int lstatus = ncx_get_ulonglong_schar(xp, tp);
#line 3685
		if (status == NC_NOERR) /* report the first encountered error */
#line 3685
			status = lstatus;
#line 3685
	}
#line 3685

#line 3685
	*xpp = (const void *)xp;
#line 3685
	return status;
#line 3685
#endif
#line 3685
}
#line 3685

int
#line 3686
ncx_getn_ulonglong_short(const void **xpp, size_t nelems, short *tp)
#line 3686
{
#line 3686
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3686

#line 3686
 /* basic algorithm is:
#line 3686
  *   - ensure sane alignment of input data
#line 3686
  *   - copy (conversion happens automatically) input data
#line 3686
  *     to output
#line 3686
  *   - update xpp to point at next unconverted input, and tp to point
#line 3686
  *     at next location for converted output
#line 3686
  */
#line 3686
  long i, j, ni;
#line 3686
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3686
  uint64 *xp;
#line 3686
  int nrange = 0;         /* number of range errors */
#line 3686
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3686
  long cxp = (long) *((char**)xpp);
#line 3686

#line 3686
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3686
  /* sjl: manually stripmine so we can limit amount of
#line 3686
   * vector work space reserved to LOOPCNT elements. Also
#line 3686
   * makes vectorisation easy */
#line 3686
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3686
    ni=Min(nelems-j,LOOPCNT);
#line 3686
    if (realign) {
#line 3686
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3686
      xp = tmp;
#line 3686
    } else {
#line 3686
      xp = (uint64 *) *xpp;
#line 3686
    }
#line 3686
   /* copy the next block */
#line 3686
#pragma cdir loopcnt=LOOPCNT
#line 3686
#pragma cdir shortloop
#line 3686
    for (i=0; i<ni; i++) {
#line 3686
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3686
     /* test for range errors (not always needed but do it anyway) */
#line 3686
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3686
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3686
      nrange += xp[i] > SHORT_MAX ;
#line 3686
    }
#line 3686
   /* update xpp and tp */
#line 3686
    if (realign) xp = (uint64 *) *xpp;
#line 3686
    xp += ni;
#line 3686
    tp += ni;
#line 3686
    *xpp = (void*)xp;
#line 3686
  }
#line 3686
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3686

#line 3686
#else   /* not SX */
#line 3686
	const char *xp = (const char *) *xpp;
#line 3686
	int status = NC_NOERR;
#line 3686

#line 3686
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3686
	{
#line 3686
		const int lstatus = ncx_get_ulonglong_short(xp, tp);
#line 3686
		if (status == NC_NOERR) /* report the first encountered error */
#line 3686
			status = lstatus;
#line 3686
	}
#line 3686

#line 3686
	*xpp = (const void *)xp;
#line 3686
	return status;
#line 3686
#endif
#line 3686
}
#line 3686

int
#line 3687
ncx_getn_ulonglong_int(const void **xpp, size_t nelems, int *tp)
#line 3687
{
#line 3687
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3687

#line 3687
 /* basic algorithm is:
#line 3687
  *   - ensure sane alignment of input data
#line 3687
  *   - copy (conversion happens automatically) input data
#line 3687
  *     to output
#line 3687
  *   - update xpp to point at next unconverted input, and tp to point
#line 3687
  *     at next location for converted output
#line 3687
  */
#line 3687
  long i, j, ni;
#line 3687
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3687
  uint64 *xp;
#line 3687
  int nrange = 0;         /* number of range errors */
#line 3687
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3687
  long cxp = (long) *((char**)xpp);
#line 3687

#line 3687
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3687
  /* sjl: manually stripmine so we can limit amount of
#line 3687
   * vector work space reserved to LOOPCNT elements. Also
#line 3687
   * makes vectorisation easy */
#line 3687
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3687
    ni=Min(nelems-j,LOOPCNT);
#line 3687
    if (realign) {
#line 3687
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3687
      xp = tmp;
#line 3687
    } else {
#line 3687
      xp = (uint64 *) *xpp;
#line 3687
    }
#line 3687
   /* copy the next block */
#line 3687
#pragma cdir loopcnt=LOOPCNT
#line 3687
#pragma cdir shortloop
#line 3687
    for (i=0; i<ni; i++) {
#line 3687
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3687
     /* test for range errors (not always needed but do it anyway) */
#line 3687
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3687
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3687
      nrange += xp[i] > INT_MAX ;
#line 3687
    }
#line 3687
   /* update xpp and tp */
#line 3687
    if (realign) xp = (uint64 *) *xpp;
#line 3687
    xp += ni;
#line 3687
    tp += ni;
#line 3687
    *xpp = (void*)xp;
#line 3687
  }
#line 3687
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3687

#line 3687
#else   /* not SX */
#line 3687
	const char *xp = (const char *) *xpp;
#line 3687
	int status = NC_NOERR;
#line 3687

#line 3687
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3687
	{
#line 3687
		const int lstatus = ncx_get_ulonglong_int(xp, tp);
#line 3687
		if (status == NC_NOERR) /* report the first encountered error */
#line 3687
			status = lstatus;
#line 3687
	}
#line 3687

#line 3687
	*xpp = (const void *)xp;
#line 3687
	return status;
#line 3687
#endif
#line 3687
}
#line 3687

int
#line 3688
ncx_getn_ulonglong_long(const void **xpp, size_t nelems, long *tp)
#line 3688
{
#line 3688
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3688

#line 3688
 /* basic algorithm is:
#line 3688
  *   - ensure sane alignment of input data
#line 3688
  *   - copy (conversion happens automatically) input data
#line 3688
  *     to output
#line 3688
  *   - update xpp to point at next unconverted input, and tp to point
#line 3688
  *     at next location for converted output
#line 3688
  */
#line 3688
  long i, j, ni;
#line 3688
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3688
  uint64 *xp;
#line 3688
  int nrange = 0;         /* number of range errors */
#line 3688
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3688
  long cxp = (long) *((char**)xpp);
#line 3688

#line 3688
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3688
  /* sjl: manually stripmine so we can limit amount of
#line 3688
   * vector work space reserved to LOOPCNT elements. Also
#line 3688
   * makes vectorisation easy */
#line 3688
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3688
    ni=Min(nelems-j,LOOPCNT);
#line 3688
    if (realign) {
#line 3688
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3688
      xp = tmp;
#line 3688
    } else {
#line 3688
      xp = (uint64 *) *xpp;
#line 3688
    }
#line 3688
   /* copy the next block */
#line 3688
#pragma cdir loopcnt=LOOPCNT
#line 3688
#pragma cdir shortloop
#line 3688
    for (i=0; i<ni; i++) {
#line 3688
      tp[i] = (long) Max( LONG_MIN, Min(LONG_MAX, (long) xp[i]));
#line 3688
     /* test for range errors (not always needed but do it anyway) */
#line 3688
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3688
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3688
      nrange += xp[i] > LONG_MAX ;
#line 3688
    }
#line 3688
   /* update xpp and tp */
#line 3688
    if (realign) xp = (uint64 *) *xpp;
#line 3688
    xp += ni;
#line 3688
    tp += ni;
#line 3688
    *xpp = (void*)xp;
#line 3688
  }
#line 3688
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3688

#line 3688
#else   /* not SX */
#line 3688
	const char *xp = (const char *) *xpp;
#line 3688
	int status = NC_NOERR;
#line 3688

#line 3688
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3688
	{
#line 3688
		const int lstatus = ncx_get_ulonglong_long(xp, tp);
#line 3688
		if (status == NC_NOERR) /* report the first encountered error */
#line 3688
			status = lstatus;
#line 3688
	}
#line 3688

#line 3688
	*xpp = (const void *)xp;
#line 3688
	return status;
#line 3688
#endif
#line 3688
}
#line 3688

int
#line 3689
ncx_getn_ulonglong_float(const void **xpp, size_t nelems, float *tp)
#line 3689
{
#line 3689
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3689

#line 3689
 /* basic algorithm is:
#line 3689
  *   - ensure sane alignment of input data
#line 3689
  *   - copy (conversion happens automatically) input data
#line 3689
  *     to output
#line 3689
  *   - update xpp to point at next unconverted input, and tp to point
#line 3689
  *     at next location for converted output
#line 3689
  */
#line 3689
  long i, j, ni;
#line 3689
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3689
  uint64 *xp;
#line 3689
  int nrange = 0;         /* number of range errors */
#line 3689
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3689
  long cxp = (long) *((char**)xpp);
#line 3689

#line 3689
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3689
  /* sjl: manually stripmine so we can limit amount of
#line 3689
   * vector work space reserved to LOOPCNT elements. Also
#line 3689
   * makes vectorisation easy */
#line 3689
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3689
    ni=Min(nelems-j,LOOPCNT);
#line 3689
    if (realign) {
#line 3689
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3689
      xp = tmp;
#line 3689
    } else {
#line 3689
      xp = (uint64 *) *xpp;
#line 3689
    }
#line 3689
   /* copy the next block */
#line 3689
#pragma cdir loopcnt=LOOPCNT
#line 3689
#pragma cdir shortloop
#line 3689
    for (i=0; i<ni; i++) {
#line 3689
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3689
     /* test for range errors (not always needed but do it anyway) */
#line 3689
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3689
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3689
      nrange += xp[i] > FLOAT_MAX ;
#line 3689
    }
#line 3689
   /* update xpp and tp */
#line 3689
    if (realign) xp = (uint64 *) *xpp;
#line 3689
    xp += ni;
#line 3689
    tp += ni;
#line 3689
    *xpp = (void*)xp;
#line 3689
  }
#line 3689
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3689

#line 3689
#else   /* not SX */
#line 3689
	const char *xp = (const char *) *xpp;
#line 3689
	int status = NC_NOERR;
#line 3689

#line 3689
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3689
	{
#line 3689
		const int lstatus = ncx_get_ulonglong_float(xp, tp);
#line 3689
		if (status == NC_NOERR) /* report the first encountered error */
#line 3689
			status = lstatus;
#line 3689
	}
#line 3689

#line 3689
	*xpp = (const void *)xp;
#line 3689
	return status;
#line 3689
#endif
#line 3689
}
#line 3689

int
#line 3690
ncx_getn_ulonglong_double(const void **xpp, size_t nelems, double *tp)
#line 3690
{
#line 3690
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3690

#line 3690
 /* basic algorithm is:
#line 3690
  *   - ensure sane alignment of input data
#line 3690
  *   - copy (conversion happens automatically) input data
#line 3690
  *     to output
#line 3690
  *   - update xpp to point at next unconverted input, and tp to point
#line 3690
  *     at next location for converted output
#line 3690
  */
#line 3690
  long i, j, ni;
#line 3690
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3690
  uint64 *xp;
#line 3690
  int nrange = 0;         /* number of range errors */
#line 3690
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3690
  long cxp = (long) *((char**)xpp);
#line 3690

#line 3690
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3690
  /* sjl: manually stripmine so we can limit amount of
#line 3690
   * vector work space reserved to LOOPCNT elements. Also
#line 3690
   * makes vectorisation easy */
#line 3690
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3690
    ni=Min(nelems-j,LOOPCNT);
#line 3690
    if (realign) {
#line 3690
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3690
      xp = tmp;
#line 3690
    } else {
#line 3690
      xp = (uint64 *) *xpp;
#line 3690
    }
#line 3690
   /* copy the next block */
#line 3690
#pragma cdir loopcnt=LOOPCNT
#line 3690
#pragma cdir shortloop
#line 3690
    for (i=0; i<ni; i++) {
#line 3690
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3690
     /* test for range errors (not always needed but do it anyway) */
#line 3690
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3690
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3690
      nrange += xp[i] > DOUBLE_MAX ;
#line 3690
    }
#line 3690
   /* update xpp and tp */
#line 3690
    if (realign) xp = (uint64 *) *xpp;
#line 3690
    xp += ni;
#line 3690
    tp += ni;
#line 3690
    *xpp = (void*)xp;
#line 3690
  }
#line 3690
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3690

#line 3690
#else   /* not SX */
#line 3690
	const char *xp = (const char *) *xpp;
#line 3690
	int status = NC_NOERR;
#line 3690

#line 3690
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3690
	{
#line 3690
		const int lstatus = ncx_get_ulonglong_double(xp, tp);
#line 3690
		if (status == NC_NOERR) /* report the first encountered error */
#line 3690
			status = lstatus;
#line 3690
	}
#line 3690

#line 3690
	*xpp = (const void *)xp;
#line 3690
	return status;
#line 3690
#endif
#line 3690
}
#line 3690

int
#line 3691
ncx_getn_ulonglong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3691
{
#line 3691
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3691

#line 3691
 /* basic algorithm is:
#line 3691
  *   - ensure sane alignment of input data
#line 3691
  *   - copy (conversion happens automatically) input data
#line 3691
  *     to output
#line 3691
  *   - update xpp to point at next unconverted input, and tp to point
#line 3691
  *     at next location for converted output
#line 3691
  */
#line 3691
  long i, j, ni;
#line 3691
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3691
  uint64 *xp;
#line 3691
  int nrange = 0;         /* number of range errors */
#line 3691
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3691
  long cxp = (long) *((char**)xpp);
#line 3691

#line 3691
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3691
  /* sjl: manually stripmine so we can limit amount of
#line 3691
   * vector work space reserved to LOOPCNT elements. Also
#line 3691
   * makes vectorisation easy */
#line 3691
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3691
    ni=Min(nelems-j,LOOPCNT);
#line 3691
    if (realign) {
#line 3691
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3691
      xp = tmp;
#line 3691
    } else {
#line 3691
      xp = (uint64 *) *xpp;
#line 3691
    }
#line 3691
   /* copy the next block */
#line 3691
#pragma cdir loopcnt=LOOPCNT
#line 3691
#pragma cdir shortloop
#line 3691
    for (i=0; i<ni; i++) {
#line 3691
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3691
     /* test for range errors (not always needed but do it anyway) */
#line 3691
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3691
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3691
      nrange += xp[i] > LONGLONG_MAX ;
#line 3691
    }
#line 3691
   /* update xpp and tp */
#line 3691
    if (realign) xp = (uint64 *) *xpp;
#line 3691
    xp += ni;
#line 3691
    tp += ni;
#line 3691
    *xpp = (void*)xp;
#line 3691
  }
#line 3691
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3691

#line 3691
#else   /* not SX */
#line 3691
	const char *xp = (const char *) *xpp;
#line 3691
	int status = NC_NOERR;
#line 3691

#line 3691
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3691
	{
#line 3691
		const int lstatus = ncx_get_ulonglong_longlong(xp, tp);
#line 3691
		if (status == NC_NOERR) /* report the first encountered error */
#line 3691
			status = lstatus;
#line 3691
	}
#line 3691

#line 3691
	*xpp = (const void *)xp;
#line 3691
	return status;
#line 3691
#endif
#line 3691
}
#line 3691

int
#line 3692
ncx_getn_ulonglong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3692
{
#line 3692
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3692

#line 3692
 /* basic algorithm is:
#line 3692
  *   - ensure sane alignment of input data
#line 3692
  *   - copy (conversion happens automatically) input data
#line 3692
  *     to output
#line 3692
  *   - update xpp to point at next unconverted input, and tp to point
#line 3692
  *     at next location for converted output
#line 3692
  */
#line 3692
  long i, j, ni;
#line 3692
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3692
  uint64 *xp;
#line 3692
  int nrange = 0;         /* number of range errors */
#line 3692
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3692
  long cxp = (long) *((char**)xpp);
#line 3692

#line 3692
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3692
  /* sjl: manually stripmine so we can limit amount of
#line 3692
   * vector work space reserved to LOOPCNT elements. Also
#line 3692
   * makes vectorisation easy */
#line 3692
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3692
    ni=Min(nelems-j,LOOPCNT);
#line 3692
    if (realign) {
#line 3692
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3692
      xp = tmp;
#line 3692
    } else {
#line 3692
      xp = (uint64 *) *xpp;
#line 3692
    }
#line 3692
   /* copy the next block */
#line 3692
#pragma cdir loopcnt=LOOPCNT
#line 3692
#pragma cdir shortloop
#line 3692
    for (i=0; i<ni; i++) {
#line 3692
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3692
     /* test for range errors (not always needed but do it anyway) */
#line 3692
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3692
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3692
      nrange += xp[i] > UCHAR_MAX ;
#line 3692
    }
#line 3692
   /* update xpp and tp */
#line 3692
    if (realign) xp = (uint64 *) *xpp;
#line 3692
    xp += ni;
#line 3692
    tp += ni;
#line 3692
    *xpp = (void*)xp;
#line 3692
  }
#line 3692
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3692

#line 3692
#else   /* not SX */
#line 3692
	const char *xp = (const char *) *xpp;
#line 3692
	int status = NC_NOERR;
#line 3692

#line 3692
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3692
	{
#line 3692
		const int lstatus = ncx_get_ulonglong_uchar(xp, tp);
#line 3692
		if (status == NC_NOERR) /* report the first encountered error */
#line 3692
			status = lstatus;
#line 3692
	}
#line 3692

#line 3692
	*xpp = (const void *)xp;
#line 3692
	return status;
#line 3692
#endif
#line 3692
}
#line 3692

int
#line 3693
ncx_getn_ulonglong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3693
{
#line 3693
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3693

#line 3693
 /* basic algorithm is:
#line 3693
  *   - ensure sane alignment of input data
#line 3693
  *   - copy (conversion happens automatically) input data
#line 3693
  *     to output
#line 3693
  *   - update xpp to point at next unconverted input, and tp to point
#line 3693
  *     at next location for converted output
#line 3693
  */
#line 3693
  long i, j, ni;
#line 3693
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3693
  uint64 *xp;
#line 3693
  int nrange = 0;         /* number of range errors */
#line 3693
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3693
  long cxp = (long) *((char**)xpp);
#line 3693

#line 3693
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3693
  /* sjl: manually stripmine so we can limit amount of
#line 3693
   * vector work space reserved to LOOPCNT elements. Also
#line 3693
   * makes vectorisation easy */
#line 3693
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3693
    ni=Min(nelems-j,LOOPCNT);
#line 3693
    if (realign) {
#line 3693
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3693
      xp = tmp;
#line 3693
    } else {
#line 3693
      xp = (uint64 *) *xpp;
#line 3693
    }
#line 3693
   /* copy the next block */
#line 3693
#pragma cdir loopcnt=LOOPCNT
#line 3693
#pragma cdir shortloop
#line 3693
    for (i=0; i<ni; i++) {
#line 3693
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3693
     /* test for range errors (not always needed but do it anyway) */
#line 3693
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3693
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3693
      nrange += xp[i] > USHORT_MAX ;
#line 3693
    }
#line 3693
   /* update xpp and tp */
#line 3693
    if (realign) xp = (uint64 *) *xpp;
#line 3693
    xp += ni;
#line 3693
    tp += ni;
#line 3693
    *xpp = (void*)xp;
#line 3693
  }
#line 3693
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3693

#line 3693
#else   /* not SX */
#line 3693
	const char *xp = (const char *) *xpp;
#line 3693
	int status = NC_NOERR;
#line 3693

#line 3693
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3693
	{
#line 3693
		const int lstatus = ncx_get_ulonglong_ushort(xp, tp);
#line 3693
		if (status == NC_NOERR) /* report the first encountered error */
#line 3693
			status = lstatus;
#line 3693
	}
#line 3693

#line 3693
	*xpp = (const void *)xp;
#line 3693
	return status;
#line 3693
#endif
#line 3693
}
#line 3693

int
#line 3694
ncx_getn_ulonglong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3694
{
#line 3694
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3694

#line 3694
 /* basic algorithm is:
#line 3694
  *   - ensure sane alignment of input data
#line 3694
  *   - copy (conversion happens automatically) input data
#line 3694
  *     to output
#line 3694
  *   - update xpp to point at next unconverted input, and tp to point
#line 3694
  *     at next location for converted output
#line 3694
  */
#line 3694
  long i, j, ni;
#line 3694
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3694
  uint64 *xp;
#line 3694
  int nrange = 0;         /* number of range errors */
#line 3694
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3694
  long cxp = (long) *((char**)xpp);
#line 3694

#line 3694
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3694
  /* sjl: manually stripmine so we can limit amount of
#line 3694
   * vector work space reserved to LOOPCNT elements. Also
#line 3694
   * makes vectorisation easy */
#line 3694
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3694
    ni=Min(nelems-j,LOOPCNT);
#line 3694
    if (realign) {
#line 3694
      memcpy(tmp, *xpp, (size_t)(ni*SIZEOF_UINT64));
#line 3694
      xp = tmp;
#line 3694
    } else {
#line 3694
      xp = (uint64 *) *xpp;
#line 3694
    }
#line 3694
   /* copy the next block */
#line 3694
#pragma cdir loopcnt=LOOPCNT
#line 3694
#pragma cdir shortloop
#line 3694
    for (i=0; i<ni; i++) {
#line 3694
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3694
     /* test for range errors (not always needed but do it anyway) */
#line 3694
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3694
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3694
      nrange += xp[i] > UINT_MAX ;
#line 3694
    }
#line 3694
   /* update xpp and tp */
#line 3694
    if (realign) xp = (uint64 *) *xpp;
#line 3694
    xp += ni;
#line 3694
    tp += ni;
#line 3694
    *xpp = (void*)xp;
#line 3694
  }
#line 3694
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3694

#line 3694
#else   /* not SX */
#line 3694
	const char *xp = (const char *) *xpp;
#line 3694
	int status = NC_NOERR;
#line 3694

#line 3694
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3694
	{
#line 3694
		const int lstatus = ncx_get_ulonglong_uint(xp, tp);
#line 3694
		if (status == NC_NOERR) /* report the first encountered error */
#line 3694
			status = lstatus;
#line 3694
	}
#line 3694

#line 3694
	*xpp = (const void *)xp;
#line 3694
	return status;
#line 3694
#endif
#line 3694
}
#line 3694


#if X_SIZEOF_UINT64 == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const unsigned long long *tp, void *fillp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, (size_t)nelems * X_SIZEOF_UINT64);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT64);
	return NC_NOERR;
}
#else
int
#line 3710
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp, void *fillp)
#line 3710
{
#line 3710
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3710

#line 3710
 /* basic algorithm is:
#line 3710
  *   - ensure sane alignment of output data
#line 3710
  *   - copy (conversion happens automatically) input data
#line 3710
  *     to output
#line 3710
  *   - update tp to point at next unconverted input, and xpp to point
#line 3710
  *     at next location for converted output
#line 3710
  */
#line 3710
  long i, j, ni;
#line 3710
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3710
  uint64 *xp;
#line 3710
  int nrange = 0;         /* number of range errors */
#line 3710
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3710
  long cxp = (long) *((char**)xpp);
#line 3710

#line 3710
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3710
  /* sjl: manually stripmine so we can limit amount of
#line 3710
   * vector work space reserved to LOOPCNT elements. Also
#line 3710
   * makes vectorisation easy */
#line 3710
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3710
    ni=Min(nelems-j,LOOPCNT);
#line 3710
    if (realign) {
#line 3710
      xp = tmp;
#line 3710
    } else {
#line 3710
      xp = (uint64 *) *xpp;
#line 3710
    }
#line 3710
   /* copy the next block */
#line 3710
#pragma cdir loopcnt=LOOPCNT
#line 3710
#pragma cdir shortloop
#line 3710
    for (i=0; i<ni; i++) {
#line 3710
      /* the normal case: */
#line 3710
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3710
     /* test for range errors (not always needed but do it anyway) */
#line 3710
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3710
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3710
      nrange += tp[i] > X_UINT64_MAX ;
#line 3710
    }
#line 3710
   /* copy workspace back if necessary */
#line 3710
    if (realign) {
#line 3710
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3710
      xp = (uint64 *) *xpp;
#line 3710
    }
#line 3710
   /* update xpp and tp */
#line 3710
    xp += ni;
#line 3710
    tp += ni;
#line 3710
    *xpp = (void*)xp;
#line 3710
  }
#line 3710
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3710

#line 3710
#else   /* not SX */
#line 3710

#line 3710
	char *xp = (char *) *xpp;
#line 3710
	int status = NC_NOERR;
#line 3710

#line 3710
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3710
	{
#line 3710
		int lstatus = ncx_put_ulonglong_ulonglong(xp, tp, fillp);
#line 3710
		if (status == NC_NOERR) /* report the first encountered error */
#line 3710
			status = lstatus;
#line 3710
	}
#line 3710

#line 3710
	*xpp = (void *)xp;
#line 3710
	return status;
#line 3710
#endif
#line 3710
}
#line 3710

#endif
int
#line 3712
ncx_putn_ulonglong_schar(void **xpp, size_t nelems, const schar *tp, void *fillp)
#line 3712
{
#line 3712
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3712

#line 3712
 /* basic algorithm is:
#line 3712
  *   - ensure sane alignment of output data
#line 3712
  *   - copy (conversion happens automatically) input data
#line 3712
  *     to output
#line 3712
  *   - update tp to point at next unconverted input, and xpp to point
#line 3712
  *     at next location for converted output
#line 3712
  */
#line 3712
  long i, j, ni;
#line 3712
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3712
  uint64 *xp;
#line 3712
  int nrange = 0;         /* number of range errors */
#line 3712
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3712
  long cxp = (long) *((char**)xpp);
#line 3712

#line 3712
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3712
  /* sjl: manually stripmine so we can limit amount of
#line 3712
   * vector work space reserved to LOOPCNT elements. Also
#line 3712
   * makes vectorisation easy */
#line 3712
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3712
    ni=Min(nelems-j,LOOPCNT);
#line 3712
    if (realign) {
#line 3712
      xp = tmp;
#line 3712
    } else {
#line 3712
      xp = (uint64 *) *xpp;
#line 3712
    }
#line 3712
   /* copy the next block */
#line 3712
#pragma cdir loopcnt=LOOPCNT
#line 3712
#pragma cdir shortloop
#line 3712
    for (i=0; i<ni; i++) {
#line 3712
      /* the normal case: */
#line 3712
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3712
     /* test for range errors (not always needed but do it anyway) */
#line 3712
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3712
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3712
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3712
    }
#line 3712
   /* copy workspace back if necessary */
#line 3712
    if (realign) {
#line 3712
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3712
      xp = (uint64 *) *xpp;
#line 3712
    }
#line 3712
   /* update xpp and tp */
#line 3712
    xp += ni;
#line 3712
    tp += ni;
#line 3712
    *xpp = (void*)xp;
#line 3712
  }
#line 3712
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3712

#line 3712
#else   /* not SX */
#line 3712

#line 3712
	char *xp = (char *) *xpp;
#line 3712
	int status = NC_NOERR;
#line 3712

#line 3712
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3712
	{
#line 3712
		int lstatus = ncx_put_ulonglong_schar(xp, tp, fillp);
#line 3712
		if (status == NC_NOERR) /* report the first encountered error */
#line 3712
			status = lstatus;
#line 3712
	}
#line 3712

#line 3712
	*xpp = (void *)xp;
#line 3712
	return status;
#line 3712
#endif
#line 3712
}
#line 3712

int
#line 3713
ncx_putn_ulonglong_short(void **xpp, size_t nelems, const short *tp, void *fillp)
#line 3713
{
#line 3713
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3713

#line 3713
 /* basic algorithm is:
#line 3713
  *   - ensure sane alignment of output data
#line 3713
  *   - copy (conversion happens automatically) input data
#line 3713
  *     to output
#line 3713
  *   - update tp to point at next unconverted input, and xpp to point
#line 3713
  *     at next location for converted output
#line 3713
  */
#line 3713
  long i, j, ni;
#line 3713
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3713
  uint64 *xp;
#line 3713
  int nrange = 0;         /* number of range errors */
#line 3713
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3713
  long cxp = (long) *((char**)xpp);
#line 3713

#line 3713
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3713
  /* sjl: manually stripmine so we can limit amount of
#line 3713
   * vector work space reserved to LOOPCNT elements. Also
#line 3713
   * makes vectorisation easy */
#line 3713
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3713
    ni=Min(nelems-j,LOOPCNT);
#line 3713
    if (realign) {
#line 3713
      xp = tmp;
#line 3713
    } else {
#line 3713
      xp = (uint64 *) *xpp;
#line 3713
    }
#line 3713
   /* copy the next block */
#line 3713
#pragma cdir loopcnt=LOOPCNT
#line 3713
#pragma cdir shortloop
#line 3713
    for (i=0; i<ni; i++) {
#line 3713
      /* the normal case: */
#line 3713
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3713
     /* test for range errors (not always needed but do it anyway) */
#line 3713
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3713
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3713
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3713
    }
#line 3713
   /* copy workspace back if necessary */
#line 3713
    if (realign) {
#line 3713
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3713
      xp = (uint64 *) *xpp;
#line 3713
    }
#line 3713
   /* update xpp and tp */
#line 3713
    xp += ni;
#line 3713
    tp += ni;
#line 3713
    *xpp = (void*)xp;
#line 3713
  }
#line 3713
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3713

#line 3713
#else   /* not SX */
#line 3713

#line 3713
	char *xp = (char *) *xpp;
#line 3713
	int status = NC_NOERR;
#line 3713

#line 3713
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3713
	{
#line 3713
		int lstatus = ncx_put_ulonglong_short(xp, tp, fillp);
#line 3713
		if (status == NC_NOERR) /* report the first encountered error */
#line 3713
			status = lstatus;
#line 3713
	}
#line 3713

#line 3713
	*xpp = (void *)xp;
#line 3713
	return status;
#line 3713
#endif
#line 3713
}
#line 3713

int
#line 3714
ncx_putn_ulonglong_int(void **xpp, size_t nelems, const int *tp, void *fillp)
#line 3714
{
#line 3714
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3714

#line 3714
 /* basic algorithm is:
#line 3714
  *   - ensure sane alignment of output data
#line 3714
  *   - copy (conversion happens automatically) input data
#line 3714
  *     to output
#line 3714
  *   - update tp to point at next unconverted input, and xpp to point
#line 3714
  *     at next location for converted output
#line 3714
  */
#line 3714
  long i, j, ni;
#line 3714
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3714
  uint64 *xp;
#line 3714
  int nrange = 0;         /* number of range errors */
#line 3714
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3714
  long cxp = (long) *((char**)xpp);
#line 3714

#line 3714
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3714
  /* sjl: manually stripmine so we can limit amount of
#line 3714
   * vector work space reserved to LOOPCNT elements. Also
#line 3714
   * makes vectorisation easy */
#line 3714
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3714
    ni=Min(nelems-j,LOOPCNT);
#line 3714
    if (realign) {
#line 3714
      xp = tmp;
#line 3714
    } else {
#line 3714
      xp = (uint64 *) *xpp;
#line 3714
    }
#line 3714
   /* copy the next block */
#line 3714
#pragma cdir loopcnt=LOOPCNT
#line 3714
#pragma cdir shortloop
#line 3714
    for (i=0; i<ni; i++) {
#line 3714
      /* the normal case: */
#line 3714
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3714
     /* test for range errors (not always needed but do it anyway) */
#line 3714
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3714
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3714
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3714
    }
#line 3714
   /* copy workspace back if necessary */
#line 3714
    if (realign) {
#line 3714
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3714
      xp = (uint64 *) *xpp;
#line 3714
    }
#line 3714
   /* update xpp and tp */
#line 3714
    xp += ni;
#line 3714
    tp += ni;
#line 3714
    *xpp = (void*)xp;
#line 3714
  }
#line 3714
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3714

#line 3714
#else   /* not SX */
#line 3714

#line 3714
	char *xp = (char *) *xpp;
#line 3714
	int status = NC_NOERR;
#line 3714

#line 3714
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3714
	{
#line 3714
		int lstatus = ncx_put_ulonglong_int(xp, tp, fillp);
#line 3714
		if (status == NC_NOERR) /* report the first encountered error */
#line 3714
			status = lstatus;
#line 3714
	}
#line 3714

#line 3714
	*xpp = (void *)xp;
#line 3714
	return status;
#line 3714
#endif
#line 3714
}
#line 3714

int
#line 3715
ncx_putn_ulonglong_long(void **xpp, size_t nelems, const long *tp, void *fillp)
#line 3715
{
#line 3715
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3715

#line 3715
 /* basic algorithm is:
#line 3715
  *   - ensure sane alignment of output data
#line 3715
  *   - copy (conversion happens automatically) input data
#line 3715
  *     to output
#line 3715
  *   - update tp to point at next unconverted input, and xpp to point
#line 3715
  *     at next location for converted output
#line 3715
  */
#line 3715
  long i, j, ni;
#line 3715
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3715
  uint64 *xp;
#line 3715
  int nrange = 0;         /* number of range errors */
#line 3715
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3715
  long cxp = (long) *((char**)xpp);
#line 3715

#line 3715
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3715
  /* sjl: manually stripmine so we can limit amount of
#line 3715
   * vector work space reserved to LOOPCNT elements. Also
#line 3715
   * makes vectorisation easy */
#line 3715
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3715
    ni=Min(nelems-j,LOOPCNT);
#line 3715
    if (realign) {
#line 3715
      xp = tmp;
#line 3715
    } else {
#line 3715
      xp = (uint64 *) *xpp;
#line 3715
    }
#line 3715
   /* copy the next block */
#line 3715
#pragma cdir loopcnt=LOOPCNT
#line 3715
#pragma cdir shortloop
#line 3715
    for (i=0; i<ni; i++) {
#line 3715
      /* the normal case: */
#line 3715
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3715
     /* test for range errors (not always needed but do it anyway) */
#line 3715
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3715
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3715
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3715
    }
#line 3715
   /* copy workspace back if necessary */
#line 3715
    if (realign) {
#line 3715
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3715
      xp = (uint64 *) *xpp;
#line 3715
    }
#line 3715
   /* update xpp and tp */
#line 3715
    xp += ni;
#line 3715
    tp += ni;
#line 3715
    *xpp = (void*)xp;
#line 3715
  }
#line 3715
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3715

#line 3715
#else   /* not SX */
#line 3715

#line 3715
	char *xp = (char *) *xpp;
#line 3715
	int status = NC_NOERR;
#line 3715

#line 3715
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3715
	{
#line 3715
		int lstatus = ncx_put_ulonglong_long(xp, tp, fillp);
#line 3715
		if (status == NC_NOERR) /* report the first encountered error */
#line 3715
			status = lstatus;
#line 3715
	}
#line 3715

#line 3715
	*xpp = (void *)xp;
#line 3715
	return status;
#line 3715
#endif
#line 3715
}
#line 3715

int
#line 3716
ncx_putn_ulonglong_float(void **xpp, size_t nelems, const float *tp, void *fillp)
#line 3716
{
#line 3716
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3716

#line 3716
 /* basic algorithm is:
#line 3716
  *   - ensure sane alignment of output data
#line 3716
  *   - copy (conversion happens automatically) input data
#line 3716
  *     to output
#line 3716
  *   - update tp to point at next unconverted input, and xpp to point
#line 3716
  *     at next location for converted output
#line 3716
  */
#line 3716
  long i, j, ni;
#line 3716
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3716
  uint64 *xp;
#line 3716
  int nrange = 0;         /* number of range errors */
#line 3716
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3716
  long cxp = (long) *((char**)xpp);
#line 3716

#line 3716
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3716
  /* sjl: manually stripmine so we can limit amount of
#line 3716
   * vector work space reserved to LOOPCNT elements. Also
#line 3716
   * makes vectorisation easy */
#line 3716
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3716
    ni=Min(nelems-j,LOOPCNT);
#line 3716
    if (realign) {
#line 3716
      xp = tmp;
#line 3716
    } else {
#line 3716
      xp = (uint64 *) *xpp;
#line 3716
    }
#line 3716
   /* copy the next block */
#line 3716
#pragma cdir loopcnt=LOOPCNT
#line 3716
#pragma cdir shortloop
#line 3716
    for (i=0; i<ni; i++) {
#line 3716
      /* the normal case: */
#line 3716
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3716
     /* test for range errors (not always needed but do it anyway) */
#line 3716
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3716
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3716
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3716
    }
#line 3716
   /* copy workspace back if necessary */
#line 3716
    if (realign) {
#line 3716
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3716
      xp = (uint64 *) *xpp;
#line 3716
    }
#line 3716
   /* update xpp and tp */
#line 3716
    xp += ni;
#line 3716
    tp += ni;
#line 3716
    *xpp = (void*)xp;
#line 3716
  }
#line 3716
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3716

#line 3716
#else   /* not SX */
#line 3716

#line 3716
	char *xp = (char *) *xpp;
#line 3716
	int status = NC_NOERR;
#line 3716

#line 3716
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3716
	{
#line 3716
		int lstatus = ncx_put_ulonglong_float(xp, tp, fillp);
#line 3716
		if (status == NC_NOERR) /* report the first encountered error */
#line 3716
			status = lstatus;
#line 3716
	}
#line 3716

#line 3716
	*xpp = (void *)xp;
#line 3716
	return status;
#line 3716
#endif
#line 3716
}
#line 3716

int
#line 3717
ncx_putn_ulonglong_double(void **xpp, size_t nelems, const double *tp, void *fillp)
#line 3717
{
#line 3717
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3717

#line 3717
 /* basic algorithm is:
#line 3717
  *   - ensure sane alignment of output data
#line 3717
  *   - copy (conversion happens automatically) input data
#line 3717
  *     to output
#line 3717
  *   - update tp to point at next unconverted input, and xpp to point
#line 3717
  *     at next location for converted output
#line 3717
  */
#line 3717
  long i, j, ni;
#line 3717
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3717
  uint64 *xp;
#line 3717
  int nrange = 0;         /* number of range errors */
#line 3717
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3717
  long cxp = (long) *((char**)xpp);
#line 3717

#line 3717
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3717
  /* sjl: manually stripmine so we can limit amount of
#line 3717
   * vector work space reserved to LOOPCNT elements. Also
#line 3717
   * makes vectorisation easy */
#line 3717
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3717
    ni=Min(nelems-j,LOOPCNT);
#line 3717
    if (realign) {
#line 3717
      xp = tmp;
#line 3717
    } else {
#line 3717
      xp = (uint64 *) *xpp;
#line 3717
    }
#line 3717
   /* copy the next block */
#line 3717
#pragma cdir loopcnt=LOOPCNT
#line 3717
#pragma cdir shortloop
#line 3717
    for (i=0; i<ni; i++) {
#line 3717
      /* the normal case: */
#line 3717
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3717
     /* test for range errors (not always needed but do it anyway) */
#line 3717
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3717
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3717
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3717
    }
#line 3717
   /* copy workspace back if necessary */
#line 3717
    if (realign) {
#line 3717
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3717
      xp = (uint64 *) *xpp;
#line 3717
    }
#line 3717
   /* update xpp and tp */
#line 3717
    xp += ni;
#line 3717
    tp += ni;
#line 3717
    *xpp = (void*)xp;
#line 3717
  }
#line 3717
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3717

#line 3717
#else   /* not SX */
#line 3717

#line 3717
	char *xp = (char *) *xpp;
#line 3717
	int status = NC_NOERR;
#line 3717

#line 3717
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3717
	{
#line 3717
		int lstatus = ncx_put_ulonglong_double(xp, tp, fillp);
#line 3717
		if (status == NC_NOERR) /* report the first encountered error */
#line 3717
			status = lstatus;
#line 3717
	}
#line 3717

#line 3717
	*xpp = (void *)xp;
#line 3717
	return status;
#line 3717
#endif
#line 3717
}
#line 3717

int
#line 3718
ncx_putn_ulonglong_longlong(void **xpp, size_t nelems, const longlong *tp, void *fillp)
#line 3718
{
#line 3718
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3718

#line 3718
 /* basic algorithm is:
#line 3718
  *   - ensure sane alignment of output data
#line 3718
  *   - copy (conversion happens automatically) input data
#line 3718
  *     to output
#line 3718
  *   - update tp to point at next unconverted input, and xpp to point
#line 3718
  *     at next location for converted output
#line 3718
  */
#line 3718
  long i, j, ni;
#line 3718
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3718
  uint64 *xp;
#line 3718
  int nrange = 0;         /* number of range errors */
#line 3718
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3718
  long cxp = (long) *((char**)xpp);
#line 3718

#line 3718
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3718
  /* sjl: manually stripmine so we can limit amount of
#line 3718
   * vector work space reserved to LOOPCNT elements. Also
#line 3718
   * makes vectorisation easy */
#line 3718
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3718
    ni=Min(nelems-j,LOOPCNT);
#line 3718
    if (realign) {
#line 3718
      xp = tmp;
#line 3718
    } else {
#line 3718
      xp = (uint64 *) *xpp;
#line 3718
    }
#line 3718
   /* copy the next block */
#line 3718
#pragma cdir loopcnt=LOOPCNT
#line 3718
#pragma cdir shortloop
#line 3718
    for (i=0; i<ni; i++) {
#line 3718
      /* the normal case: */
#line 3718
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3718
     /* test for range errors (not always needed but do it anyway) */
#line 3718
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3718
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3718
      nrange += tp[i] > X_UINT64_MAX || tp[i] < 0;
#line 3718
    }
#line 3718
   /* copy workspace back if necessary */
#line 3718
    if (realign) {
#line 3718
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3718
      xp = (uint64 *) *xpp;
#line 3718
    }
#line 3718
   /* update xpp and tp */
#line 3718
    xp += ni;
#line 3718
    tp += ni;
#line 3718
    *xpp = (void*)xp;
#line 3718
  }
#line 3718
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3718

#line 3718
#else   /* not SX */
#line 3718

#line 3718
	char *xp = (char *) *xpp;
#line 3718
	int status = NC_NOERR;
#line 3718

#line 3718
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3718
	{
#line 3718
		int lstatus = ncx_put_ulonglong_longlong(xp, tp, fillp);
#line 3718
		if (status == NC_NOERR) /* report the first encountered error */
#line 3718
			status = lstatus;
#line 3718
	}
#line 3718

#line 3718
	*xpp = (void *)xp;
#line 3718
	return status;
#line 3718
#endif
#line 3718
}
#line 3718

int
#line 3719
ncx_putn_ulonglong_uchar(void **xpp, size_t nelems, const uchar *tp, void *fillp)
#line 3719
{
#line 3719
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3719

#line 3719
 /* basic algorithm is:
#line 3719
  *   - ensure sane alignment of output data
#line 3719
  *   - copy (conversion happens automatically) input data
#line 3719
  *     to output
#line 3719
  *   - update tp to point at next unconverted input, and xpp to point
#line 3719
  *     at next location for converted output
#line 3719
  */
#line 3719
  long i, j, ni;
#line 3719
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3719
  uint64 *xp;
#line 3719
  int nrange = 0;         /* number of range errors */
#line 3719
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3719
  long cxp = (long) *((char**)xpp);
#line 3719

#line 3719
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3719
  /* sjl: manually stripmine so we can limit amount of
#line 3719
   * vector work space reserved to LOOPCNT elements. Also
#line 3719
   * makes vectorisation easy */
#line 3719
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3719
    ni=Min(nelems-j,LOOPCNT);
#line 3719
    if (realign) {
#line 3719
      xp = tmp;
#line 3719
    } else {
#line 3719
      xp = (uint64 *) *xpp;
#line 3719
    }
#line 3719
   /* copy the next block */
#line 3719
#pragma cdir loopcnt=LOOPCNT
#line 3719
#pragma cdir shortloop
#line 3719
    for (i=0; i<ni; i++) {
#line 3719
      /* the normal case: */
#line 3719
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3719
     /* test for range errors (not always needed but do it anyway) */
#line 3719
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3719
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3719
      nrange += tp[i] > X_UINT64_MAX ;
#line 3719
    }
#line 3719
   /* copy workspace back if necessary */
#line 3719
    if (realign) {
#line 3719
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3719
      xp = (uint64 *) *xpp;
#line 3719
    }
#line 3719
   /* update xpp and tp */
#line 3719
    xp += ni;
#line 3719
    tp += ni;
#line 3719
    *xpp = (void*)xp;
#line 3719
  }
#line 3719
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3719

#line 3719
#else   /* not SX */
#line 3719

#line 3719
	char *xp = (char *) *xpp;
#line 3719
	int status = NC_NOERR;
#line 3719

#line 3719
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3719
	{
#line 3719
		int lstatus = ncx_put_ulonglong_uchar(xp, tp, fillp);
#line 3719
		if (status == NC_NOERR) /* report the first encountered error */
#line 3719
			status = lstatus;
#line 3719
	}
#line 3719

#line 3719
	*xpp = (void *)xp;
#line 3719
	return status;
#line 3719
#endif
#line 3719
}
#line 3719

int
#line 3720
ncx_putn_ulonglong_ushort(void **xpp, size_t nelems, const ushort *tp, void *fillp)
#line 3720
{
#line 3720
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3720

#line 3720
 /* basic algorithm is:
#line 3720
  *   - ensure sane alignment of output data
#line 3720
  *   - copy (conversion happens automatically) input data
#line 3720
  *     to output
#line 3720
  *   - update tp to point at next unconverted input, and xpp to point
#line 3720
  *     at next location for converted output
#line 3720
  */
#line 3720
  long i, j, ni;
#line 3720
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3720
  uint64 *xp;
#line 3720
  int nrange = 0;         /* number of range errors */
#line 3720
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3720
  long cxp = (long) *((char**)xpp);
#line 3720

#line 3720
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3720
  /* sjl: manually stripmine so we can limit amount of
#line 3720
   * vector work space reserved to LOOPCNT elements. Also
#line 3720
   * makes vectorisation easy */
#line 3720
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3720
    ni=Min(nelems-j,LOOPCNT);
#line 3720
    if (realign) {
#line 3720
      xp = tmp;
#line 3720
    } else {
#line 3720
      xp = (uint64 *) *xpp;
#line 3720
    }
#line 3720
   /* copy the next block */
#line 3720
#pragma cdir loopcnt=LOOPCNT
#line 3720
#pragma cdir shortloop
#line 3720
    for (i=0; i<ni; i++) {
#line 3720
      /* the normal case: */
#line 3720
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3720
     /* test for range errors (not always needed but do it anyway) */
#line 3720
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3720
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3720
      nrange += tp[i] > X_UINT64_MAX ;
#line 3720
    }
#line 3720
   /* copy workspace back if necessary */
#line 3720
    if (realign) {
#line 3720
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3720
      xp = (uint64 *) *xpp;
#line 3720
    }
#line 3720
   /* update xpp and tp */
#line 3720
    xp += ni;
#line 3720
    tp += ni;
#line 3720
    *xpp = (void*)xp;
#line 3720
  }
#line 3720
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3720

#line 3720
#else   /* not SX */
#line 3720

#line 3720
	char *xp = (char *) *xpp;
#line 3720
	int status = NC_NOERR;
#line 3720

#line 3720
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3720
	{
#line 3720
		int lstatus = ncx_put_ulonglong_ushort(xp, tp, fillp);
#line 3720
		if (status == NC_NOERR) /* report the first encountered error */
#line 3720
			status = lstatus;
#line 3720
	}
#line 3720

#line 3720
	*xpp = (void *)xp;
#line 3720
	return status;
#line 3720
#endif
#line 3720
}
#line 3720

int
#line 3721
ncx_putn_ulonglong_uint(void **xpp, size_t nelems, const uint *tp, void *fillp)
#line 3721
{
#line 3721
#if defined(_SX) && _SX != 0 && X_SIZEOF_UINT64 == SIZEOF_UINT64
#line 3721

#line 3721
 /* basic algorithm is:
#line 3721
  *   - ensure sane alignment of output data
#line 3721
  *   - copy (conversion happens automatically) input data
#line 3721
  *     to output
#line 3721
  *   - update tp to point at next unconverted input, and xpp to point
#line 3721
  *     at next location for converted output
#line 3721
  */
#line 3721
  long i, j, ni;
#line 3721
  uint64 tmp[LOOPCNT];        /* in case input is misaligned */
#line 3721
  uint64 *xp;
#line 3721
  int nrange = 0;         /* number of range errors */
#line 3721
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3721
  long cxp = (long) *((char**)xpp);
#line 3721

#line 3721
  realign = (cxp & 7) % SIZEOF_UINT64;
#line 3721
  /* sjl: manually stripmine so we can limit amount of
#line 3721
   * vector work space reserved to LOOPCNT elements. Also
#line 3721
   * makes vectorisation easy */
#line 3721
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3721
    ni=Min(nelems-j,LOOPCNT);
#line 3721
    if (realign) {
#line 3721
      xp = tmp;
#line 3721
    } else {
#line 3721
      xp = (uint64 *) *xpp;
#line 3721
    }
#line 3721
   /* copy the next block */
#line 3721
#pragma cdir loopcnt=LOOPCNT
#line 3721
#pragma cdir shortloop
#line 3721
    for (i=0; i<ni; i++) {
#line 3721
      /* the normal case: */
#line 3721
      xp[i] = (uint64) Max( X_UINT64_MIN, Min(X_UINT64_MAX, (uint64) tp[i]));
#line 3721
     /* test for range errors (not always needed but do it anyway) */
#line 3721
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3721
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3721
      nrange += tp[i] > X_UINT64_MAX ;
#line 3721
    }
#line 3721
   /* copy workspace back if necessary */
#line 3721
    if (realign) {
#line 3721
      memcpy(*xpp, tmp, (size_t)*ni*X_SIZEOF_UINT64);
#line 3721
      xp = (uint64 *) *xpp;
#line 3721
    }
#line 3721
   /* update xpp and tp */
#line 3721
    xp += ni;
#line 3721
    tp += ni;
#line 3721
    *xpp = (void*)xp;
#line 3721
  }
#line 3721
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3721

#line 3721
#else   /* not SX */
#line 3721

#line 3721
	char *xp = (char *) *xpp;
#line 3721
	int status = NC_NOERR;
#line 3721

#line 3721
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT64, tp++)
#line 3721
	{
#line 3721
		int lstatus = ncx_put_ulonglong_uint(xp, tp, fillp);
#line 3721
		if (status == NC_NOERR) /* report the first encountered error */
#line 3721
			status = lstatus;
#line 3721
	}
#line 3721

#line 3721
	*xpp = (void *)xp;
#line 3721
	return status;
#line 3721
#endif
#line 3721
}
#line 3721



/*
 * Other aggregate conversion functions.
 */

/* text */

int
ncx_getn_text(const void **xpp, size_t nelems, char *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3733
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3733
	return NC_NOERR;
#line 3733

}

int
ncx_pad_getn_text(const void **xpp, size_t nelems, char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3739

#line 3739
	if (rndup)
#line 3739
		rndup = X_ALIGN - rndup;
#line 3739

#line 3739
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3739
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3739

#line 3739
	return NC_NOERR;
#line 3739

}

int
ncx_putn_text(void **xpp, size_t nelems, const char *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3745
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3745

#line 3745
	return NC_NOERR;
#line 3745

}

int
ncx_pad_putn_text(void **xpp, size_t nelems, const char *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3751

#line 3751
	if (rndup)
#line 3751
		rndup = X_ALIGN - rndup;
#line 3751

#line 3751
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3751
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3751

#line 3751
	if (rndup)
#line 3751
	{
#line 3751
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3751
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3751
	}
#line 3751

#line 3751
	return NC_NOERR;
#line 3751

}


/* opaque */

int
ncx_getn_void(const void **xpp, size_t nelems, void *tp)
{
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3760
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3760
	return NC_NOERR;
#line 3760

}

int
ncx_pad_getn_void(const void **xpp, size_t nelems, void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3766

#line 3766
	if (rndup)
#line 3766
		rndup = X_ALIGN - rndup;
#line 3766

#line 3766
	(void) memcpy(tp, *xpp, (size_t)nelems);
#line 3766
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3766

#line 3766
	return NC_NOERR;
#line 3766

}

int
ncx_putn_void(void **xpp, size_t nelems, const void *tp)
{
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3772
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3772

#line 3772
	return NC_NOERR;
#line 3772

}

int
ncx_pad_putn_void(void **xpp, size_t nelems, const void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3778

#line 3778
	if (rndup)
#line 3778
		rndup = X_ALIGN - rndup;
#line 3778

#line 3778
	(void) memcpy(*xpp, tp, (size_t)nelems);
#line 3778
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3778

#line 3778
	if (rndup)
#line 3778
	{
#line 3778
		(void) memcpy(*xpp, nada, (size_t)rndup);
#line 3778
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3778
	}
#line 3778

#line 3778
	return NC_NOERR;
#line 3778

}
