/* This is part of the netCDF package.
   Copyright 2005 University Corporation for Atmospheric Research/Unidata
   See COPYRIGHT file for conditions of use.

   Test netcdf-4 compound type feature. 

   $Id: tst_compounds.c,v 1.15 2007/04/14 15:05:19 ed Exp $
*/

#include <config.h>
#include <netcdf.h>
#include <nc_tests.h>

#define FILE_NAME "tst_compounds.nc"
#define SVC_REC "Service_Record"
#define BATTLES_WITH_KLINGONS "Number_of_Battles_with_Klingons"
#define DATES_WITH_ALIENS "Dates_with_Alien_Hotties"
#define STARDATE "Stardate"
#define DIM_LEN 3
#define SERVICE_RECORD "Kirk_Service_Record"

int
main(int argc, char **argv)
{
   int ncid, typeid, varid;
   size_t nfields;
   int dimid;
   int ndims, nvars, natts, unlimdimid;
   char name[NC_MAX_NAME + 1];
   size_t size, len;
   nc_type xtype, field_xtype;
   int dimids[] = {0}, fieldid;
   int field_ndims, field_sizes[NC_MAX_DIMS];
   size_t offset;
   int i, j;

   /* The following structs are written and read as compound types by
    * the tests below. */
   struct s1 
   {
	 int i1;
	 int i2;
   };
   struct s1 data[DIM_LEN], data_in[DIM_LEN];

   /* StarFleet Medical Record. */
   struct sf_med_rec
   {
	 unsigned char num_heads;
	 unsigned short num_arms;
	 unsigned int num_toes;
	 long long ago; /* in a galaxy far far away... */
	 unsigned long long num_hairs;
   };
   struct sf_med_rec med_data_out[DIM_LEN], med_data_in[DIM_LEN];

   /* Since some aliens exists in different, or more than one,
    * dimensions, StarFleet keeps track of the dimensional abilities
    * of everyone on 7 dimensions. */
#define NUM_DIMENSIONS 7
   struct dim_rec
   {
	 int starfleet_id;
	 int abilities[NUM_DIMENSIONS];
   };
   struct dim_rec dim_data_out[DIM_LEN], dim_data_in[DIM_LEN];
   
   /* StarFleet Human Resources Department has data records for all
    * employees. */
   struct hr_rec
   {
	 int starfleet_id;
	 struct s1 svc_rec;
	 char name[NC_MAX_NAME + 1];
	 float max_temp, min_temp; /* temperature range */
	 double percent_transporter_errosion; 
   };
   struct hr_rec hr_data_out[DIM_LEN], hr_data_in[DIM_LEN];

   /* Create some phoney data. */   
   for (i=0; i<DIM_LEN; i++)
   {
      data[i].i1 = 5;
      data[i].i2 = 10;
      /* medical data */
      med_data_out[i].num_heads = 254;
      med_data_out[i].num_arms = NC_FILL_USHORT - 1;
      med_data_out[i].num_toes = NC_FILL_UINT - 1;
      med_data_out[i].ago = NC_FILL_INT64 + 1;
      med_data_out[i].num_hairs = NC_FILL_UINT64 - 1;
      /* Dimensional data. */
      dim_data_out[i].starfleet_id = i;
      for (j = 0; j < NUM_DIMENSIONS; j++)
	 dim_data_out[i].abilities[j] = j;
      /* hr data */
      hr_data_out[i].starfleet_id = i;
      hr_data_out[i].svc_rec = data[i];      
      if (sprintf(hr_data_out[i].name, "alien_%d", i) < 0) ERR;
      hr_data_out[i].max_temp = 99.99;
      hr_data_out[i].min_temp = -9.99;
      hr_data_out[i].percent_transporter_errosion = .030303;
   }

   printf("\n*** Testing netcdf-4 user defined type functions.\n");
   printf("*** testing REALLY simple compound variable create...");
   {
      /* Create a file with a compound type. Write a little data. */
      if (nc_create(FILE_NAME, NC_NETCDF4, &ncid)) ERR;
      if (nc_def_compound(ncid, sizeof(int), SVC_REC, &typeid)) ERR;
      if (nc_insert_compound(ncid, typeid, BATTLES_WITH_KLINGONS, 
			     0, NC_INT)) ERR;
      if (nc_def_var(ncid, SERVICE_RECORD, typeid, 0, NULL, &varid)) ERR;
      if (nc_close(ncid)) ERR;

      /* Open the file and take a peek. */
      if (nc_open(FILE_NAME, NC_WRITE, &ncid)) ERR;
/*       if (nc_inq(ncid, &ndims, &nvars, &natts, &unlimdimid)) ERR; */
/*       if (ndims != 1 || nvars != 1 || natts != 0 || unlimdimid != -1) ERR; */
      if (nc_close(ncid)) ERR;
   }

   SUMMARIZE_ERR;
   printf("*** testing simple compound variable create...");
   {
      /* Create a file with a compound type. Write a little data. */
      if (nc_create(FILE_NAME, NC_NETCDF4, &ncid)) ERR;
      if (nc_def_compound(ncid, sizeof(struct s1), SVC_REC, &typeid)) ERR;
      if (nc_inq_compound(ncid, typeid, name, &size, &nfields)) ERR;
      if (nfields) ERR;
      if (nc_insert_compound(ncid, typeid, BATTLES_WITH_KLINGONS, 
			     HOFFSET(struct s1, i1), NC_INT)) ERR;
      if (nc_insert_compound(ncid, typeid, DATES_WITH_ALIENS, 
			     HOFFSET(struct s1, i2), NC_INT)) ERR;
      if (nc_def_dim(ncid, STARDATE, DIM_LEN, &dimid)) ERR;
      if (nc_def_var(ncid, SERVICE_RECORD, typeid, 1, dimids, &varid)) ERR;
      if (nc_put_var(ncid, varid, data)) ERR;
      if (nc_close(ncid)) ERR;

      /* Open the file and take a peek. */
      if (nc_open(FILE_NAME, NC_WRITE, &ncid)) ERR;
      if (nc_inq(ncid, &ndims, &nvars, &natts, &unlimdimid)) ERR;
      if (ndims != 1 || nvars != 1 || natts != 0 || unlimdimid != -1) ERR;
      if (nc_close(ncid)) ERR;

      /* Reopen the file and take a more detailed look at the compound
       * type. */
      {
	 if (nc_open(FILE_NAME, NC_WRITE, &ncid)) ERR;
	 if (nc_inq_var(ncid, 0, name, &xtype, &ndims, dimids, &natts)) ERR;
	 if (strcmp(name, SERVICE_RECORD) || ndims != 1 || natts != 0 || dimids[0] != 0) ERR;
	 if (nc_inq_compound(ncid, xtype, name, &size, &nfields)) ERR;
	 if (nfields != 2 || size != 8 || strcmp(name, SVC_REC)) ERR;
	 if (nc_inq_compound_name(ncid, xtype, name)) ERR;
	 if (strcmp(name, SVC_REC)) ERR;
	 if (nc_inq_compound_size(ncid, xtype, &size)) ERR;
	 if (size != 8) ERR;
	 if (nc_inq_compound_nfields(ncid, xtype, &nfields)) ERR;
	 if (nfields != 2) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 0, name, &offset, &field_xtype, &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, BATTLES_WITH_KLINGONS) || offset != 0 || (field_xtype != NC_INT && field_ndims != 0)) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 1, name, &offset, &field_xtype, &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, DATES_WITH_ALIENS) || offset != 4 || field_xtype != NC_INT) ERR;
	 if (nc_inq_compound_fieldname(ncid, xtype, 1, name)) ERR;
	 if (strcmp(name, DATES_WITH_ALIENS)) ERR;
	 if (nc_inq_compound_fieldindex(ncid, xtype, BATTLES_WITH_KLINGONS, &fieldid)) ERR;
	 if (fieldid != 0) ERR;
	 if (nc_inq_compound_fieldoffset(ncid, xtype, 1, &offset)) ERR;
	 if (offset != 4) ERR;
	 if (nc_inq_compound_fieldtype(ncid, xtype, 1, &field_xtype)) ERR;
	 if (field_xtype != NC_INT) ERR;
	 if (nc_get_var(ncid, varid, data_in)) ERR;
	 for (i=0; i<DIM_LEN; i++)
	 if (data[i].i1 != data_in[i].i1 || data[i].i2 != data_in[i].i2) ERR;
	 if (nc_close(ncid)) ERR;
      }
   }

   SUMMARIZE_ERR;
   printf("*** testing simple compound attribute create...");
   
   {
      /* Create a file with a global attribute of compound type. */
      if (nc_create(FILE_NAME, NC_NETCDF4, &ncid)) ERR;
      if (nc_def_compound(ncid, sizeof(struct s1), SVC_REC, &typeid)) ERR;
      if (nc_insert_compound(ncid, typeid, BATTLES_WITH_KLINGONS, 
			     HOFFSET(struct s1, i1), NC_INT)) ERR;
      if (nc_insert_compound(ncid, typeid, DATES_WITH_ALIENS, 
			     HOFFSET(struct s1, i2), NC_INT)) ERR;
      if (nc_put_att(ncid, NC_GLOBAL, SERVICE_RECORD, typeid, 3, data)) ERR;
      if (nc_close(ncid)) ERR;

      /* Open the file and take a peek. */
      if (nc_open(FILE_NAME, NC_WRITE, &ncid)) ERR;
      if (nc_inq(ncid, &ndims, &nvars, &natts, &unlimdimid)) ERR;
      if (ndims != 0 || nvars != 0 || natts != 1 || unlimdimid != -1) ERR;
      if (nc_close(ncid)) ERR;

      /* Reopen the file and take a more detailed look at the compound
       * type. */
      {
	 if (nc_open(FILE_NAME, NC_WRITE, &ncid)) ERR;
	 if (nc_get_att(ncid, NC_GLOBAL, SERVICE_RECORD, data_in)) ERR;
	 for (i=0; i<DIM_LEN; i++)
	    if (data[i].i1 != data_in[i].i1 || data[i].i2 != data_in[i].i2) ERR;;
	 if (nc_inq_att(ncid, NC_GLOBAL, SERVICE_RECORD, &xtype, &len)) ERR;
	 if (len != 3) ERR;
	 if (nc_inq_compound(ncid, xtype, name, &size, &nfields)) ERR;
	 if (nfields != 2 || size != 8 || strcmp(name, SVC_REC)) ERR;
	 if (nc_inq_compound_nfields(ncid, xtype, &nfields)) ERR;
	 if (nfields != 2) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 0, name, &offset, &field_xtype, &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, BATTLES_WITH_KLINGONS) || offset != 0 || field_xtype != NC_INT) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 1, name, &offset, &field_xtype, &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, DATES_WITH_ALIENS) || offset != 4 || field_xtype != NC_INT) ERR;
	 if (nc_inq_compound_fieldindex(ncid, xtype, BATTLES_WITH_KLINGONS, &fieldid)) ERR;
	 if (fieldid != 0) ERR;
	 if (nc_inq_compound_fieldoffset(ncid, xtype, 1, &offset)) ERR;
	 if (offset != 4) ERR;
	 if (nc_inq_compound_fieldtype(ncid, xtype, 1, &field_xtype)) ERR;
	 if (field_xtype != NC_INT) ERR;
	 if (nc_close(ncid)) ERR;
      }
   }

   SUMMARIZE_ERR;
   printf("*** testing compound variable with new atomic types...");
   {
      /* Create a file with a compound type. Write a little data. */
      if (nc_create(FILE_NAME, NC_NETCDF4, &ncid)) ERR;
      if (nc_def_compound(ncid, sizeof(struct sf_med_rec), 
			  "SFMedRec", &typeid)) ERR;
      if (nc_insert_compound(ncid, typeid, "num_heads", 
			     HOFFSET(struct sf_med_rec, num_heads), NC_UBYTE)) ERR;
      if (nc_insert_compound(ncid, typeid, "num_arms", 
			     HOFFSET(struct sf_med_rec, num_arms), NC_USHORT)) ERR;
      if (nc_insert_compound(ncid, typeid, "num_toes", 
			     HOFFSET(struct sf_med_rec, num_toes), NC_UINT)) ERR;
      if (nc_insert_compound(ncid, typeid, "ago", 
			     HOFFSET(struct sf_med_rec, ago), NC_INT64)) ERR;
      if (nc_insert_compound(ncid, typeid, "num_hairs", 
			     HOFFSET(struct sf_med_rec, num_hairs), NC_UINT64)) ERR;
      if (nc_def_dim(ncid, STARDATE, DIM_LEN, &dimid)) ERR;
      if (nc_def_var(ncid, "starbase_13", typeid, 1, dimids, &varid)) ERR;
      if (nc_put_var(ncid, varid, med_data_out)) ERR;
      if (nc_close(ncid)) ERR;

      /* Open the file and take a look. */
      {
	 if (nc_open(FILE_NAME, NC_WRITE, &ncid)) ERR;
	 if (nc_inq_var(ncid, 0, name, &xtype, &ndims, dimids, &natts)) ERR;
	 if (strcmp(name, "starbase_13") || ndims != 1 || natts != 0 || dimids[0] != 0) ERR;
	 if (nc_inq_compound(ncid, xtype, name, &size, &nfields)) ERR;
	 if (nfields != 5 || size != sizeof(struct sf_med_rec) || strcmp(name, "SFMedRec")) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 0, name, &offset, &field_xtype, &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, "num_heads") || offset != 0 || field_xtype != NC_UBYTE) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 1, name, &offset, &field_xtype, &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, "num_arms") || offset != HOFFSET(struct sf_med_rec, num_arms) || 
	     field_xtype != NC_USHORT) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 2, name, &offset, &field_xtype, &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, "num_toes") || offset != HOFFSET(struct sf_med_rec, num_toes) || 
	     field_xtype != NC_UINT) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 3, name, &offset, &field_xtype, &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, "ago") || offset != HOFFSET(struct sf_med_rec, ago) || 
	     field_xtype != NC_INT64) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 4, name, &offset, &field_xtype, &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, "num_hairs") || offset != HOFFSET(struct sf_med_rec, num_hairs) || 
	     field_xtype != NC_UINT64) ERR;
	 if (nc_get_var(ncid, varid, med_data_in)) ERR;
	 for (i=0; i<DIM_LEN; i++)
	    if (med_data_in[i].num_heads != med_data_out[i].num_heads || 
		med_data_in[i].num_arms != med_data_out[i].num_arms ||
		med_data_in[i].num_toes != med_data_out[i].num_toes ||
		med_data_in[i].ago != med_data_out[i].ago ||
		med_data_in[i].num_hairs != med_data_out[i].num_hairs) ERR;
	 if (nc_close(ncid)) ERR;
      }
   }

   SUMMARIZE_ERR;
   printf("*** testing compound variable containing an array of ints...");
   {
      nc_type field_typeid;
      int dim_sizes[] = {NUM_DIMENSIONS};

      /* Create a file with a compound type which contains an array of
       * int. Write a little data. */
      if (nc_create(FILE_NAME, NC_NETCDF4, &ncid)) ERR;
      if (nc_def_compound(ncid, sizeof(struct dim_rec), "SFDimRec", &typeid)) ERR;
      if (nc_insert_compound(ncid, typeid, "starfleet_id", 
			     HOFFSET(struct dim_rec, starfleet_id), NC_INT)) ERR;
      if (nc_insert_array_compound(ncid, typeid, "abilities", 
			     HOFFSET(struct dim_rec, abilities), NC_INT, 1, dim_sizes)) ERR;
      if (nc_inq_compound_field(ncid, xtype, 1, name, &offset, &field_typeid, 
				&field_ndims, field_sizes)) ERR;
      if (strcmp(name, "abilities") || offset != 4 || field_typeid != NC_INT || 
	  field_ndims != 1 || field_sizes[0] != dim_sizes[0]) ERR;
      if (nc_def_dim(ncid, STARDATE, DIM_LEN, &dimid)) ERR;
      if (nc_def_var(ncid, "dimension_data", typeid, 1, dimids, &varid)) ERR;
      if (nc_put_var(ncid, varid, dim_data_out)) ERR;
      if (nc_close(ncid)) ERR;

      /* Open the file and take a look. */
      {
	 if (nc_open(FILE_NAME, NC_WRITE, &ncid)) ERR;
	 if (nc_inq_var(ncid, 0, name, &xtype, &ndims, dimids, &natts)) ERR;
	 if (strcmp(name, "dimension_data") || ndims != 1 || natts != 0 || dimids[0] != 0) ERR;
	 if (nc_inq_compound(ncid, xtype, name, &size, &nfields)) ERR;
	 if (nfields != 2 || size != sizeof(struct dim_rec) || strcmp(name, "SFDimRec")) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 1, name, &offset, &field_typeid, 
				   &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, "abilities") || offset != 4 || field_typeid != NC_INT || 
	     field_ndims != 1 || field_sizes[0] != NUM_DIMENSIONS) ERR;
	 if (nc_get_var(ncid, varid, dim_data_in)) ERR;
	 for (i=0; i<DIM_LEN; i++)
	 {
	    if (dim_data_in[i].starfleet_id != dim_data_out[i].starfleet_id) ERR;
	    for (j = 0; j < NUM_DIMENSIONS; j++)
	       if (dim_data_in[i].abilities[j] != dim_data_out[i].abilities[j]) ERR;
	 }
	 if (nc_close(ncid)) ERR;
      }
   }

   SUMMARIZE_ERR;
   printf("*** testing compound var containing compound type...");
   
   {
      nc_type svc_recid, hr_recid;

      /* Create a file with a nested compound type attribute and variable. */
      if (nc_create(FILE_NAME, NC_NETCDF4, &ncid)) ERR; 

      /* Define the inner type first. */
      if (nc_def_compound(ncid, sizeof(struct s1), SVC_REC, &svc_recid)) ERR;
      if (nc_insert_compound(ncid, svc_recid, BATTLES_WITH_KLINGONS, 
			     HOFFSET(struct s1, i1), NC_INT)) ERR;
      if (nc_insert_compound(ncid, svc_recid, DATES_WITH_ALIENS, 
			     HOFFSET(struct s1, i2), NC_INT)) ERR;

      /* Now define the containing type. */
      if (nc_def_compound(ncid, sizeof(struct hr_rec), "SF_HR_Record", &hr_recid)) ERR;
      if (nc_insert_compound(ncid, hr_recid, "StarFleet_ID",
			     HOFFSET(struct hr_rec, starfleet_id), NC_INT)) ERR;
      if (nc_insert_compound(ncid, hr_recid, "Service_Record",
			     HOFFSET(struct hr_rec, svc_rec), svc_recid)) ERR;
      if (nc_insert_compound(ncid, hr_recid, "Name",
			     HOFFSET(struct hr_rec, name), NC_CHAR)) ERR;
      if (nc_insert_compound(ncid, hr_recid, "Max_Temp",
			     HOFFSET(struct hr_rec, max_temp), NC_FLOAT)) ERR;
      if (nc_insert_compound(ncid, hr_recid, "Min_Temp",
			     HOFFSET(struct hr_rec, min_temp), NC_FLOAT)) ERR;
      if (nc_insert_compound(ncid, hr_recid, "Percent_Transporter_Erosian",
			     HOFFSET(struct hr_rec, percent_transporter_errosion), 
			     NC_DOUBLE)) ERR;

      /* Write it as an attribute. */
      if (nc_put_att(ncid, NC_GLOBAL, "HR_Records", hr_recid, DIM_LEN, 
		     hr_data_out)) ERR;
      if (nc_close(ncid)) ERR;

      /* Reopen the file and take detailed look at the compound
       * attribute. */
      {
	 /* Read the att and check values. */
	 if (nc_open(FILE_NAME, NC_WRITE, &ncid)) ERR;
	 if (nc_get_att(ncid, NC_GLOBAL, "HR_Records", hr_data_in)) ERR;
	 for (i=0; i<DIM_LEN; i++)
	 {
	    if (hr_data_in[i].starfleet_id != hr_data_out[i].starfleet_id || 
		hr_data_in[i].svc_rec.i1 != hr_data_out[i].svc_rec.i1 || 
		hr_data_in[i].svc_rec.i2 != hr_data_out[i].svc_rec.i2 || 
		strcmp(hr_data_in[i].name, hr_data_out[i].name) ||
		hr_data_in[i].max_temp != hr_data_out[i].max_temp || 
		hr_data_in[i].min_temp != hr_data_out[i].min_temp || 
		hr_data_in[i].percent_transporter_errosion != 
		hr_data_out[i].percent_transporter_errosion) ERR;
	 }

	 /* Use the inq functions to learn about nested compound type. */
	 if (nc_inq_att(ncid, NC_GLOBAL, "HR_Records", &xtype, &len)) ERR;
	 if (len != DIM_LEN) ERR;
	 if (nc_inq_compound(ncid, xtype, name, &size, &nfields)) ERR;
	 if (nfields != 6 || size != sizeof(struct hr_rec) || strcmp(name, "SF_HR_Record")) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 0, name, &offset, &field_xtype, &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, "StarFleet_ID") || offset != 0 || field_xtype != NC_INT) ERR;
	 if (nc_inq_compound_field(ncid, xtype, 1, name, &offset, &field_xtype, &field_ndims, field_sizes)) ERR;
	 if (strcmp(name, "Service_Record") || offset != HOFFSET(struct hr_rec, svc_rec)) ERR;
	 /* Check the internal compound type. */

	 /* Finish checking the containing compound type. */
	 if (nc_close(ncid)) ERR;
      }
   }

   SUMMARIZE_ERR;

   FINAL_RESULTS;
}

