/* This is part of the netCDF package. Copyright 2005 University
   Corporation for Atmospheric Research/Unidata See COPYRIGHT file for
   conditions of use. See www.unidata.ucar.edu for more info.

   Test netcdf-4 enum types.

   $Id: tst_enums.c,v 1.2 2005/12/21 20:55:16 ed Exp $
*/

#include <nc_tests.h>
#include <netcdf.h>

#define FILE_NAME "tst_enums.nc"
#define DIM_LEN 4
#define NUM_MEMBERS 4
#define DIM_NAME "dim"
#define BASE_SIZE 20
#define VAR_NAME "Advice"
#define TYPE_NAME "Mysterous_Word"

int
main(int argc, char **argv)
{
   int ncid;
   nc_type typeid;
   int i;
   char name_in[NC_MAX_NAME+1];
   int ntypes, typeids[1] = {0};
   nc_type base_nc_type, base_nc_type_in;
   size_t nfields_in, num_members, base_size_in;
   int class_in;

   printf("\n*** Testing netcdf-4 enum type.\n");
   /*nc_set_log_level(3);*/

   printf("*** creating enum type...");
   {
      int value_in;
      unsigned char data[DIM_LEN];
      /* Can't use the same name twice! */
      char member_name[NUM_MEMBERS][NC_MAX_NAME + 1] = {"Mene1", "Mene2", 
							"Tekel", "Upharsin"};
      int member_value[NUM_MEMBERS] = {0, 99, 81232, 12};

      for (i=0; i<DIM_LEN; i++)
	 data[i] = i;

      /* Create a file. */
      if (nc_create(FILE_NAME, NC_NETCDF4, &ncid)) ERR;

      /* Create an enum type. */
      if (nc_def_enum(ncid, NC_INT, TYPE_NAME, &typeid)) ERR;
      for (i = 0; i < NUM_MEMBERS; i++)
	 if (nc_insert_enum(ncid, typeid, member_name[i], 
			    &member_value[i])) ERR;

      /* Check it out. */
      if (nc_inq_user_type(ncid, typeid, name_in, &base_size_in, &base_nc_type_in,
			   &nfields_in, &class_in)) ERR;
      if (strcmp(name_in, TYPE_NAME) || base_size_in != sizeof(int) ||
	  base_nc_type_in != NC_INT || nfields_in != NUM_MEMBERS || class_in != NC_ENUM) ERR;
      if (nc_inq_enum(ncid, typeid, name_in, &base_nc_type, &base_size_in, &num_members)) ERR;
      if (strcmp(name_in, TYPE_NAME) || base_nc_type != NC_INT || 
	  num_members != NUM_MEMBERS) ERR;
      for (i = 0; i < NUM_MEMBERS; i++)
      {
	 if (nc_inq_enum_member(ncid, typeid, i, name_in, &value_in)) ERR;
	 if (strcmp(name_in, member_name[i]) || value_in != member_value[i]) ERR;
      }

      /* Write the file. */
      if (nc_close(ncid)) ERR;

      /* Reopen the file. */
      if (nc_open(FILE_NAME, NC_NOWRITE, &ncid)) ERR;

      /* Get type info. */
      if (nc_inq_typeids(ncid, &ntypes, typeids)) ERR;
      if (ntypes != 1 || !typeids[0]) ERR;

      /* Check it out. */
      if (nc_inq_user_type(ncid, typeids[0], name_in, &base_size_in, &base_nc_type_in,
			   &nfields_in, &class_in)) ERR;
      if (strcmp(name_in, TYPE_NAME) || base_size_in != sizeof(int) ||
	  base_nc_type_in != NC_INT || nfields_in != NUM_MEMBERS || class_in != NC_ENUM) ERR;
      if (nc_inq_enum(ncid, typeids[0], name_in, &base_nc_type, &base_size_in, &num_members)) ERR;
      if (strcmp(name_in, TYPE_NAME) || base_nc_type != NC_INT || num_members != NUM_MEMBERS) ERR;
      for (i = 0; i < NUM_MEMBERS; i++)
      {
	 if (nc_inq_enum_member(ncid, typeid, i, name_in, &value_in)) ERR;
	 if (strcmp(name_in, member_name[i]) || value_in != member_value[i]) ERR;
      }

      if (nc_close(ncid)) ERR; 
   }

   SUMMARIZE_ERR;

#define NUM_BRADYS 9
#define BRADYS "Bradys"
#define BRADY_DIM_LEN 3
#define ATT_NAME "brady_attribute"

   printf("*** testing enum attribute...");
   {
      char brady_name[NUM_BRADYS][NC_MAX_NAME + 1] = {"Mike", "Carol", "Greg", "Marsha",
						       "Peter", "Jan", "Bobby", "Whats-her-face",
						       "Alice"};
      unsigned char brady_value[NUM_BRADYS] = {0, 1,2,3,4,5,6,7,8};
      unsigned char data[BRADY_DIM_LEN] = {0, 4, 8};
      unsigned char value_in;

      /* Create a file. */
      if (nc_create(FILE_NAME, NC_NETCDF4, &ncid)) ERR;

      /* Create an enum type based on unsigned bytes. */
      if (nc_def_enum(ncid, NC_UBYTE, BRADYS, &typeid)) ERR;
      for (i = 0; i < NUM_BRADYS; i++)
	 if (nc_insert_enum(ncid, typeid, brady_name[i], 
			    &brady_value[i])) ERR;

      /* Check it out. */
      if (nc_inq_user_type(ncid, typeid, name_in, &base_size_in, &base_nc_type_in,
			   &nfields_in, &class_in)) ERR;
      if (strcmp(name_in, BRADYS) || base_size_in != 1 ||
	  base_nc_type_in != NC_UBYTE || nfields_in != NUM_BRADYS || class_in != NC_ENUM) ERR;
      if (nc_inq_enum(ncid, typeid, name_in, &base_nc_type, &base_size_in, &num_members)) ERR;
      if (strcmp(name_in, BRADYS) || base_nc_type != NC_UBYTE || base_size_in != 1 ||
	  num_members != NUM_BRADYS) ERR;
      for (i = 0; i < NUM_BRADYS; i++)
      {
	 if (nc_inq_enum_member(ncid, typeid, i, name_in, &value_in)) ERR;
	 if (strcmp(name_in, brady_name[i]) || value_in != brady_value[i]) ERR;
      }

      /* Write an att of this enum type. */
      if (nc_put_att(ncid, NC_GLOBAL, ATT_NAME, typeid, BRADY_DIM_LEN, data)) ERR;
      
      /* Close the file. */
      if (nc_close(ncid)) ERR;

/*       /\* Reopen. *\/ */
/*       if (nc_open(FILE_NAME, NC_NOWRITE, &ncid)) ERR; */

/*       /\* Check it out. *\/ */
/*       if (nc_inq_att(ncid, NC_GLOBAL, ATT_NAME, &typeid, &size_in)) ERR; */
/*       if (size_in != BRADY_DIM_LEN) ERR; */
/*       if (nc_inq_user_type(ncid, typeid, name_in, &base_size_in, &base_nc_type_in, &nfields_in, &class_in)) ERR; */
/*       if (strcmp(name_in, TYPE_NAME) || base_size_in != BASE_SIZE || */
/* 	  base_nc_type_in != 0 || nfields_in != 0 || class_in != NC_OPAQUE) ERR; */
/*       if (nc_inq_opaque(ncid, typeid, name_in, &base_size_in)) ERR; */
/*       if (strcmp(name_in, TYPE_NAME) || base_size_in != BASE_SIZE) ERR; */
/*       if (nc_get_att(ncid, NC_GLOBAL, ATT_NAME, data_in)) ERR; */
/*       for (i=0; i<BRADY_DIM_LEN; i++) */
/*  	 for (j=0; j<BASE_SIZE; j++) */
/*  	    if (data_in[i][j] != data[i][j]) ERR; */

/*      if (nc_close(ncid)) ERR; */
   }

   SUMMARIZE_ERR;
   printf("*** testing opaque variable...");

   {
/*       int dimid, varid, dimids[] = {0}; */
/*       char name_in[NC_MAX_NAME+1]; */
/*       nc_type base_nc_type_in, var_type; */
/*       size_t base_size_in; */
/*       int nfields_in, class_in; */
/*       char var_name[NC_MAX_NAME+1]; */
/*       int  nvars, natts, ndims, unlimdimid, dimids_var[1]; */
/*       char var_data[] = "Even a fool, when he holdeth his peace, is counted wise:" */
/* 	 " and he that shutteth his lips is esteemed a man of understanding."; */

/*       /\* Create a file that has an opaque variable. *\/ */
/*       if (nc_create(FILE_NAME, NC_NETCDF4|NC_CLOBBER, &ncid)) ERR; */
/*       if (nc_def_opaque(ncid, BASE_SIZE, TYPE_NAME, &xtype)) ERR; */
/*       if (nc_inq_user_type(ncid, xtype, name_in, &base_size_in, &base_nc_type_in, &nfields_in, &class_in)) ERR; */
/*       if (strcmp(name_in, TYPE_NAME) || base_size_in != BASE_SIZE || */
/* 	  base_nc_type_in != 0 || nfields_in != 0 || class_in != NC_OPAQUE) ERR; */
/*       if (nc_inq_opaque(ncid, xtype, name_in, &base_size_in)) ERR; */
/*       if (strcmp(name_in, TYPE_NAME) || base_size_in != BASE_SIZE) ERR; */
/*       if (nc_def_dim(ncid, DIM_NAME, DIM_LEN, &dimid)) ERR; */
/*       if (nc_def_var(ncid, VAR_NAME, xtype, 1, dimids, &varid)) ERR; */
/*       if (nc_put_var(ncid, varid, data)) ERR; */
/*       if (nc_close(ncid)) ERR; */
      
/*       /\* Check it out. *\/ */
/*       if (nc_open(FILE_NAME, NC_NOWRITE, &ncid)) ERR; */
/*       if (nc_inq(ncid, &ndims, &nvars, &natts, &unlimdimid)) ERR; */
/*       if (ndims != 1 || nvars != 1 || natts != 0 || unlimdimid != -1) ERR; */
/*       if (nc_inq_var(ncid, 0, var_name, &var_type, &ndims, dimids_var, &natts)) ERR; */
/*       if (ndims != 1 || strcmp(var_name, VAR_NAME) || */
/* 	  dimids_var[0] != dimids[0] || natts != 0) ERR; */
/*       if (nc_get_var(ncid, 0, data_in)) ERR; */
/*       for (i=0; i<DIM_LEN; i++) */
/*  	 for (j=0; j<BASE_SIZE; j++) */
/*  	    if (data_in[i][j] != data[i][j]) ERR; */
/*       if (nc_close(ncid)) ERR; */
   }

   SUMMARIZE_ERR;

   FINAL_RESULTS;
}

