/* This is part of the netCDF package.
   Copyright 2005 University Corporation for Atmospheric Research/Unidata
   See COPYRIGHT file for conditions of use.

   Check out HDF5 groups. 

   $Id: tst_h_grps.c,v 1.5 2005/12/06 19:01:01 ed Exp $
*/
#include <nc_tests.h>

#define FILE_NAME "tst_h_grps.h5"
#define GRP_NAME "Bubba-Joe"
#define SUB_GRP_NAME "Billy-Bob"
#define DATASET_NAME "Sally-Sue"
#define NEW_NAME "Mary-Lou"

int
main()
{
   hid_t fileid, grpid, subgrpid, access_plistid;
   hid_t datasetid, spaceid;

   printf("\n*** Checking HDF5 group functions.\n");
   printf("*** Checking out root group...");

   /* Open the root group of a new file. */
   if ((access_plistid = H5Pcreate(H5P_FILE_ACCESS)) < 0) ERR;
   if (H5Pset_fclose_degree(access_plistid, H5F_CLOSE_SEMI)) ERR;
   if ((fileid = H5Fcreate(FILE_NAME, H5F_ACC_TRUNC, H5P_DEFAULT, 
			   access_plistid)) < 0) ERR;
   if ((grpid = H5Gopen(fileid, "/")) < 0) ERR;
   if (H5Gclose(grpid) < 0 ||
       H5Fclose(fileid) < 0) ERR;
   
   /* Reopen file and root group. */
   if ((fileid = H5Fopen(FILE_NAME, H5F_ACC_RDWR, 
			 access_plistid)) < 0) ERR;
   if ((grpid = H5Gopen(fileid, "/")) < 0) ERR;
   if (H5Gclose(grpid) < 0 ||
       H5Fclose(fileid) < 0)
      ERR;

   SUMMARIZE_ERR;
   printf("*** Checking out H5Gmove...");

   /* Create file with one dataset. */
   if ((fileid = H5Fcreate(FILE_NAME, H5F_ACC_TRUNC, H5P_DEFAULT, 
			   H5P_DEFAULT)) < 0) ERR;
   if ((grpid = H5Gopen(fileid, "/")) < 0) ERR;
   if ((spaceid = H5Screate(H5S_SCALAR)) < 0) ERR;
   if ((datasetid = H5Dcreate(grpid, DATASET_NAME, H5T_NATIVE_INT, 
			      spaceid, H5P_DEFAULT)) < 0) ERR;
   if (H5Dclose(datasetid) < 0 ||
       H5Sclose(spaceid) < 0 ||
       H5Gclose(grpid) < 0 ||
       H5Fclose(fileid) < 0) ERR;
   
   /* Reopen file and check, then rename dataset. */
   if ((fileid = H5Fopen(FILE_NAME, H5F_ACC_RDWR, 
			 H5P_DEFAULT)) < 0) ERR;
   if ((grpid = H5Gopen(fileid, "/")) < 0) ERR;
   if ((datasetid = H5Dopen(grpid, DATASET_NAME)) < 0) ERR;
   if (H5Dclose(datasetid) < 0) ERR;
   if (H5Gmove(grpid, DATASET_NAME, NEW_NAME) < 0) ERR;
   if ((datasetid = H5Dopen(grpid, NEW_NAME)) < 0) ERR;
   if (H5Dclose(datasetid) < 0 ||
       H5Gclose(grpid) < 0 || 
       H5Pclose(access_plistid) < 0 ||
       H5Fclose(fileid) < 0)
      ERR;

   SUMMARIZE_ERR;
   printf("*** Checking out HDF5 groups...");

   /* Create file with some nested groups. */
   if ((fileid = H5Fcreate(FILE_NAME, H5F_ACC_TRUNC, H5P_DEFAULT, 
			   H5P_DEFAULT)) < 0) ERR;
   if ((grpid = H5Gcreate(fileid, GRP_NAME, 0)) < 0) ERR;
   if ((subgrpid = H5Gcreate(grpid, SUB_GRP_NAME, 0)) < 0) ERR;
   if (H5Gclose(subgrpid) < 0 ||
       H5Gclose(grpid) < 0 ||
       H5Fclose(fileid) < 0) ERR;

   /* Reopen file and discover groups. */
   if ((fileid = H5Fopen(FILE_NAME, H5F_ACC_RDONLY, H5P_DEFAULT)) < 0)
      ERR;
   if ((grpid = H5Gopen(fileid, GRP_NAME)) < 0)
      ERR;
   if ((subgrpid = H5Gopen(grpid, SUB_GRP_NAME)) < 0)
      ERR;
   if (H5Gclose(subgrpid) < 0 ||
       H5Gclose(grpid) < 0 ||
       H5Fclose(fileid) < 0)
      ERR;

   SUMMARIZE_ERR;

   FINAL_RESULTS;
}
















